#define INCL_WIN      /* win function definitions */
#define INCL_GPI      /* all gpi specific definitions */

#include <string.h>
#include <os2.h>
#include <stdio.h>
#include "PTTDLLDF.h" // test case defines
#include "std_util.h"  // standard screen text functions header file
#include "gpipath.h"  // gpi path dll header file
#include "gpi_grid.h" // gpi standard grid functions header file
 /***************************************************************************
 *\\ddd
 * Routine name:  PathApp
 *
 * Purpose:  This is the body of the GpiPathApp entry point, which has been
 *           broken out of the original source file to prevent a code segment
 *           becoming too large.
 *
 * Revision Log:  01/04/91, PDVT, Kim Cairns
 *                - Initial function template
 *                01/11/91, PDVT, Kim Cairns
 *                - Converted to standard utility functions
 *
 * Inputs:
 *             hPS            - presentation space handle
 *             hWndClient     - client window handle
 *
 * Outputs:
 *             None
 *
 * Subroutines Required:
 *             set_delta()   - sets device-specific units
 *
 * Limitations:
 *             None
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *   Draw arcs using the following methods:
 *      GpiFillPath
 *      GpiOutlinePath
 *      GpiStrokePath
 *      GpiModifyPath and GpiFillPath
 *   Test all line ends and joins
 *   Test two figures in the same path
 *   Test overlapping figures from two different paths
 *
 *\\end
 ***************************************************************************/
VOID APIENTRY PathApp(HPS hPS,HWND hWndClient)
{
  POINTL  ptl, ptlShape[10];

     TEST_SIGNATURE(0,0);
     LOG_SIGNATURE;
     CWRITELOG(L_LOTRACE, 0, "+ee+ GpiPathApp - Entry.\n");

     lErrorCount = 0L;

     /*
      * set device-specific units
      */
        set_delta(hPS);

     /*
      * Set fill pattern to halftone
      */
        GpiSetPattern(hPS, PATSYM_HALFTONE);

     /*
      * Set geometric line width to 10x
      */
        if (GpiSetLineWidthGeom(hPS, 10L) == FALSE)
        {
          BADERROR("GpiSetLineWidthGeom", FALSE, NULL);
        }

  /*
   * Arcs - GpiFillPath
   */
        ptl.x = delta_x * 0;
        ptl.y = delta_y * 3/2;
        MapPt(ptl);
        GpiMove (hPS, &ptl);

        ptlShape[0].x = delta_x * 1/2;
        ptlShape[0].y = delta_y * 2;
        MapPt(ptlShape[0]);
        ptlShape[1].x = delta_x * 1;
        ptlShape[1].y = delta_y * 1;
        MapPt(ptlShape[1]);

        if (GpiBeginPath(hPS, 1L) == FALSE)
        {
          BADERROR("GpiBeginPath", TRUE, "GpiPathApp");
          return;
        }
        GpiPointArc(hPS, ptlShape);
        if (GpiEndPath(hPS) == FALSE)
        {
          BADERROR("GpiEndPath", TRUE, "GpiPathApp");
          return;
        }
        if (GpiFillPath(hPS, 1L, FPATH_ALTERNATE) == GPI_ERROR)
        {
          BADERROR("GpiFillPath", FALSE, NULL);
        }
        MapAndWriteString(hPS, 0L, delta_y * 2 + line_space,
           "GpiFillPath");

  /*
   * Arcs - GpiOutlinePath
   */
        ptl.x = delta_x * 2;
        ptl.y = delta_y * 3/2;
        MapPt(ptl);
        GpiMove (hPS, &ptl);

        ptlShape[0].x = delta_x * 5/2;
        ptlShape[0].y = delta_y * 2;
        MapPt(ptlShape[0]);
        ptlShape[1].x = delta_x * 3;
        ptlShape[1].y = delta_y * 1;
        MapPt(ptlShape[1]);

        if (GpiBeginPath(hPS, 1L) == FALSE)
        {
          BADERROR("GpiBeginPath", TRUE, "GpiPathApp");
          return;
        }
        GpiPointArc(hPS, ptlShape);
        if (GpiEndPath(hPS) == FALSE)
        {
          BADERROR("GpiEndPath", TRUE, "GpiPathApp");
          return;
        }
        if (GpiOutlinePath(hPS, 1L, 0L) == GPI_ERROR)
        {
          BADERROR("GpiOutlinePath", FALSE, NULL);
        }
        MapAndWriteString(hPS, delta_x * 2, delta_y * 2 + line_space,
           "GpiOutlinePath");

  /*
   * Arcs - GpiStrokePath
   */
        ptl.x = delta_x * 4;
        ptl.y = delta_y * 3/2;
        MapPt(ptl);
        GpiMove (hPS, &ptl);

        ptlShape[0].x = delta_x * 9/2;
        ptlShape[0].y = delta_y * 2;
        MapPt(ptlShape[0]);
        ptlShape[1].x = delta_x * 5;
        ptlShape[1].y = delta_y * 1;
        MapPt(ptlShape[1]);

        if (GpiBeginPath(hPS, 1L) == FALSE)
        {
          BADERROR("GpiBeginPath", TRUE, "GpiPathApp");
          return;
        }
        GpiPointArc(hPS, ptlShape);
        if (GpiEndPath(hPS) == FALSE)
        {
          BADERROR("GpiEndPath", TRUE, "GpiPathApp");
          return;
        }
        if (GpiStrokePath(hPS, 1L, 0L) == GPI_ERROR)
        {
          BADERROR("GpiStrokePath", FALSE, NULL);
        }
        MapAndWriteString(hPS, delta_x * 4, delta_y * 2 + line_space,
           "GpiStrokePath");

  /*
   * Arcs - GpiModifyPath and GpiFillPath
   */
        ptl.x = delta_x * 6;
        ptl.y = delta_y * 3/2;
        MapPt(ptl);
        GpiMove (hPS, &ptl);

        ptlShape[0].x = delta_x * 13/2;
        ptlShape[0].y = delta_y * 2;
        MapPt(ptlShape[0]);
        ptlShape[1].x = delta_x * 7;
        ptlShape[1].y = delta_y * 1;
        MapPt(ptlShape[1]);

        if (GpiBeginPath(hPS, 1L) == FALSE)
        {
          BADERROR("GpiBeginPath", TRUE, "GpiPathApp");
          return;
        }
        GpiPointArc(hPS, ptlShape);
        if (GpiEndPath(hPS) == FALSE)
        {
          BADERROR("GpiEndPath", TRUE, "GpiPathApp");
          return;
        }
        if (GpiModifyPath(hPS, 1L, MPATH_STROKE) == FALSE)
        {
          BADERROR("GpiModifyPath", FALSE, NULL);
        }
        if (GpiFillPath(hPS, 1L, FPATH_WINDING) == GPI_ERROR)
        {
          BADERROR("GpiFillPath", FALSE, NULL);
        }
        MapAndWriteString(hPS, delta_x * 6, delta_y * 2 + line_space,
           "GpiModify&FillPath");

  /*
   * Line end & join test
   */
     // Test 1
        if (GpiSetLineEnd(hPS, LINEEND_ROUND) == FALSE)
        {
          BADERROR("GpiSetLineEnd", FALSE, NULL);
        }
        if (GpiSetLineJoin(hPS, LINEJOIN_MITRE) == FALSE)
        {
          BADERROR("GpiSetLineJoin", FALSE, NULL);
        }

        ptl.x = delta_x * 1/2;
        ptl.y = delta_y * 7/2;
        MapPt(ptl);
        GpiMove(hPS, &ptl);

        ptlShape[0].x = delta_x * 1/2;
        ptlShape[0].y = delta_y * 3;
        MapPt(ptlShape[0]);
        ptlShape[1].x = delta_x * 1;
        ptlShape[1].y = delta_y * 3;
        MapPt(ptlShape[1]);

        if (GpiBeginPath(hPS, 1L) == FALSE)
        {
          BADERROR("GpiBeginPath", TRUE, "GpiPathApp");
          return;
        }
        GpiPolyLine(hPS, 2L, ptlShape);
        if (GpiEndPath(hPS) == FALSE)
        {
          BADERROR("GpiEndPath", TRUE, "GpiPathApp");
          return;
        }
        if (GpiStrokePath(hPS, 1L, 0L) == GPI_ERROR)
        {
          BADERROR("GpiStrokePath", FALSE, NULL);
        }
        MapAndWriteString(hPS, 0L, delta_y * 4 + line_space,
           "LINEEND_ROUND");
        MapAndWriteString(hPS, 0L, delta_y * 4,
           "LINEJOIN_MITRE");


     // Test 2
        if (GpiSetLineEnd(hPS, LINEEND_SQUARE) == FALSE)
        {
          BADERROR("GpiSetLineEnd", FALSE, NULL);
        }
        if (GpiSetLineJoin(hPS, LINEJOIN_ROUND) == FALSE)
        {
          BADERROR("GpiSetLineJoin", FALSE, NULL);
        }

        ptl.x = delta_x * 5/2;
        ptl.y = delta_y * 7/2;
        MapPt(ptl);
        GpiMove(hPS, &ptl);

        ptlShape[0].x = delta_x * 5/2;
        ptlShape[0].y = delta_y * 3;
        MapPt(ptlShape[0]);
        ptlShape[1].x = delta_x * 3;
        ptlShape[1].y = delta_y * 3;
        MapPt(ptlShape[1]);

        if (GpiBeginPath(hPS, 1L) == FALSE)
        {
          BADERROR("GpiBeginPath", TRUE, "GpiPathApp");
          return;
        }
        GpiPolyLine(hPS, 2L, ptlShape);
        if (GpiEndPath(hPS) == FALSE)
        {
          BADERROR("GpiEndPath", TRUE, "GpiPathApp");
          return;
        }
        if (GpiStrokePath(hPS, 1L, 0L) == GPI_ERROR)
        {
          BADERROR("GpiStrokePath", FALSE, NULL);
        }
        MapAndWriteString(hPS, delta_x * 2, delta_y * 4 + line_space,
           "LINEEND_SQUARE");
        MapAndWriteString(hPS, delta_x * 2, delta_y * 4,
           "LINEJOIN_ROUND");


     // Test 3
        if (GpiSetLineEnd(hPS, LINEEND_FLAT) == FALSE)
        {
          BADERROR("GpiSetLineEnd", FALSE, NULL);
        }
        if (GpiSetLineJoin(hPS, LINEJOIN_BEVEL) == FALSE)
        {
          BADERROR("GpiSetLineJoin", FALSE, NULL);
        }

        ptl.x = delta_x * 9/2;
        ptl.y = delta_y * 7/2;
        MapPt(ptl);
        GpiMove(hPS, &ptl);

        ptlShape[0].x = delta_x * 9/2;
        ptlShape[0].y = delta_y * 3;
        MapPt(ptlShape[0]);
        ptlShape[1].x = delta_x * 5;
        ptlShape[1].y = delta_y * 3;
        MapPt(ptlShape[1]);

        if (GpiBeginPath(hPS, 1L) == FALSE)
        {
          BADERROR("GpiBeginPath", TRUE, "GpiPathApp");
          return;
        }
        GpiPolyLine(hPS, 2L, ptlShape);
        if (GpiEndPath(hPS) == FALSE)
        {
          BADERROR("GpiEndPath", TRUE, "GpiPathApp");
          return;
        }
        if (GpiStrokePath(hPS, 1L, 0L) == GPI_ERROR)
        {
          BADERROR("GpiStrokePath", FALSE, NULL);
        }
        MapAndWriteString(hPS, delta_x * 4, delta_y * 4 + line_space,
           "LINEEND_FLAT");
        MapAndWriteString(hPS, delta_x * 4, delta_y * 4,
           "LINEJOIN_BEVEL");


     // Test 4
        if (GpiSetLineEnd(hPS, LINEEND_DEFAULT) == FALSE)
        {
          BADERROR("GpiSetLineEnd", FALSE, NULL);
        }
        if (GpiSetLineJoin(hPS, LINEJOIN_DEFAULT) == FALSE)
        {
          BADERROR("GpiSetLineJoin", FALSE, NULL);
        }

        ptl.x = delta_x * 13/2;
        ptl.y = delta_y * 7/2;
        MapPt(ptl);
        GpiMove(hPS, &ptl);

        ptlShape[0].x = delta_x * 13/2;
        ptlShape[0].y = delta_y * 3;
        MapPt(ptlShape[0]);
        ptlShape[1].x = delta_x * 7;
        ptlShape[1].y = delta_y * 3;
        MapPt(ptlShape[1]);

        if (GpiBeginPath(hPS, 1L) == FALSE)
        {
          BADERROR("GpiBeginPath", TRUE, "GpiPathApp");
          return;
        }
        GpiPolyLine(hPS, 2L, ptlShape);
        if (GpiEndPath(hPS) == FALSE)
        {
          BADERROR("GpiEndPath", TRUE, "GpiPathApp");
          return;
        }
        if (GpiStrokePath(hPS, 1L, 0L) == GPI_ERROR)
        {
          BADERROR("GpiStrokePath", FALSE, NULL);
        }
        MapAndWriteString(hPS, delta_x * 6, delta_y * 4 + line_space,
           "LINEEND_DEFAULT");
        MapAndWriteString(hPS, delta_x * 6, delta_y * 4,
           "LINEJOIN_DEFAULT");

  /*
   * Two figures in same path
   */
        ptl.x = delta_x * 1;
        ptl.y = delta_y * 11/2;
        MapPt(ptl);
        GpiMove(hPS, &ptl);

        ptlShape[0].x = delta_x * 4;
        ptlShape[0].y = delta_y * 6;
        MapPt(ptlShape[0]);
        ptlShape[1].x = delta_x * 5;
        ptlShape[1].y = delta_y * 5;
        MapPt(ptlShape[1]);
        ptlShape[2].x = delta_x * 3;
        ptlShape[2].y = delta_y * 5;
        MapPt(ptlShape[2]);

        if (GpiBeginPath(hPS, 1L) == FALSE)
        {
          BADERROR("GpiBeginPath", TRUE, "GpiPathApp");
          return;
        }
        GpiFullArc(hPS, DRO_OUTLINE, MAKEFIXED(50,0));
        GpiMove(hPS, &ptlShape[2]);
        GpiPolyFillet(hPS, 2L, ptlShape);
        if (GpiEndPath(hPS) == FALSE)
        {
          BADERROR("GpiEndPath", TRUE, "GpiPathApp");
          return;
        }
        if (GpiStrokePath(hPS, 1L, 0L) == GPI_ERROR)
        {
          BADERROR("GpiStrokePath", FALSE, NULL);
        }
        MapAndWriteString(hPS, delta_x * 2, delta_y * 6 + line_space,
           "Two figures drawn in the same path.");

  /*
   * Overlapping figures from two different paths
   */
        ptl.x = delta_x * 9/2;
        ptl.y = delta_y * 5;
        MapPt(ptl);
        GpiMove(hPS, &ptl);

        ptl.x = delta_x * 11/2;
        ptl.y = delta_y * 6;
        MapPt(ptl);

        if (GpiBeginPath(hPS, 1L) == FALSE)
        {
          BADERROR("GpiBeginPath", TRUE, "GpiPathApp");
          return;
        }
        GpiBox(hPS, DRO_OUTLINE, &ptl, MAKEFIXED(0,0), MAKEFIXED(0,0));
        if (GpiEndPath(hPS) == FALSE)
        {
          BADERROR("GpiEndPath", TRUE, "GpiPathApp");
          return;
        }
        if (GpiOutlinePath(hPS, 1L, 0L) == GPI_ERROR)
        {
          BADERROR("GpiOutlinePath", FALSE, NULL);
        }
        MapAndWriteString(hPS, delta_x * 11/2 + (delta_x * 1/5), delta_y * 5 + line_space,
           "Overlapping figures");
        MapAndWriteString(hPS, delta_x * 11/2 + (delta_x * 1/5), delta_y * 5,
           "drawn in different paths.");

    if (lErrorCount) {
       sprintf(out_string,"$ERRORCOUNT = %ld.\n",lErrorCount);
       CWRITELOG(L_HDR,0,out_string);
       CWRITELOG(L_HDR,0,
       "$GpiPath Application Test                                       -    FAIL.\n");
    }
    else
       CWRITELOG(L_HDR,0,
         "$GpiPath Application Test                                       -    PASS.\n");

  CWRITELOG(L_LOTRACE, 0, "+ex+ GpiPathApp - Exit.\n");
}

