/**************************************************************************
 *
 * SOURCE FILE NAME = ERRORS.H
 *
 * DESCRIPTIVE NAME = Include file for test case DLLs
 *
 * Purpose: This header file contains all the error codes, matched with
 *          the names of the error codes, to use for logging error
 *          messages during return code test cases.
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION :
 *
 *
 * CONTENTS   :   Function prototypes
 *                Defines specific to COMMON.C
 *
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 *
 *
 * EXTERNAL FUNCTIONS
 *
 * CHANGE ACTIVITY =
 *   DATE      FLAG        APAR   CHANGE DESCRIPTION
 *   --------  ----------  -----  --------------------------------------
 *   mm/dd/yy  @VR.MPPPXX  XXXXX  XXXXXXX
 *
 *
 ****************************************************************************/

#define NUMERRORS   ARRAYLEN(errorcodes)

struct {
   CHAR    *ErrorName;
   USHORT  ErrorId;
   } errorcodes[] =
     {
        "PMERR_INVALID_HWND",              0x1001,
        "PMERR_INVALID_HMQ",               0x1002,
        "PMERR_PARAMETER_OUT_OF_RANGE",    0x1003,
        "PMERR_WINDOW_LOCK_UNDERFLOW",     0x1004,
        "PMERR_WINDOW_LOCK_OVERFLOW",      0x1005,
        "PMERR_BAD_WINDOW_LOCK_COUNT",     0x1006,
        "PMERR_WINDOW_NOT_LOCKED",         0x1007,
        "PMERR_INVALID_SELECTOR",          0x1008,
        "PMERR_CALL_FROM_WRONG_THREAD",    0x1009,
        "PMERR_RESOURCE_NOT_FOUND",        0x100A,
        "PMERR_INVALID_STRING_PARM",       0x100B,
        "PMERR_INVALID_HHEAP",             0x100C,
        "PMERR_INVALID_HEAP_POINTER",      0x100D,
        "PMERR_INVALID_HEAP_SIZE_PARM",    0x100E,
        "PMERR_INVALID_HEAP_SIZE",         0x100F,
        "PMERR_INVALID_HEAP_SIZE_WORD",    0x1010,
        "PMERR_HEAP_OUT_OF_MEMORY",        0x1011,
        "PMERR_HEAP_MAX_SIZE_REACHED",     0x1012,
        "PMERR_INVALID_HATOMTBL",          0x1013,
        "PMERR_INVALID_ATOM",              0x1014,
        "PMERR_INVALID_ATOM_NAME",         0x1015,
        "PMERR_INVALID_INTEGER_ATOM",      0x1016,
        "PMERR_ATOM_NAME_NOT_FOUND",       0x1017,
        "PMERR_QUEUE_TOO_LARGE",           0x1018,
        "PMERR_INVALID_FLAG",              0x1019,
        "PMERR_INVALID_HACCEL",            0x101A,
        "PMERR_INVALID_HPTR",              0x101B,
        "PMERR_INVALID_HENUM",             0x101C,
        "PMERR_INVALID_SRC_CODEPAGE",      0x101D,
        "PMERR_INVALID_DST_CODEPAGE",      0x101E,
        "PMERR_UNKNOWN_COMPONENT_ID",      0x101f,
        "PMERR_UNKNOWN_ERROR_CODE",        0x1020,
        "PMERR_SEVERITY_LEVELS",           0x1021,
        "PMERR_INVALID_RESOURCE_FORMAT",   0x1034,
        "PMERR_NO_MSG_QUEUE",              0x1036,
        "PMERR_WIN_DEBUGMSG",              0x1037,
        "PMERR_QUEUE_FULL",                0x1038,
        "PMERR_LIBRARY_LOAD_FAILED",       0x1039,
        "PMERR_PROCEDURE_LOAD_FAILED",     0x103A,
        "PMERR_LIBRARY_DELETE_FAILED",     0x103B,
        "PMERR_PROCEDURE_DELETE_FAILED",   0x103C,
        "PMERR_ARRAY_TOO_LARGE",           0x103D,
        "PMERR_ARRAY_TOO_SMALL",           0x103E,
        "PMERR_DATATYPE_ENTRY_BAD_INDEX",  0x103F,
        "PMERR_DATATYPE_ENTRY_CTL_BAD",    0x1040,
        "PMERR_DATATYPE_ENTRY_CTL_MISS",   0x1041,
        "PMERR_DATATYPE_ENTRY_INVALID",    0x1042,
        "PMERR_DATATYPE_ENTRY_NOT_NUM",    0x1043,
        "PMERR_DATATYPE_ENTRY_NOT_OFF",    0x1044,
        "PMERR_DATATYPE_INVALID",          0x1045,
        "PMERR_DATATYPE_NOT_UNIQUE",       0x1046,
        "PMERR_DATATYPE_TOO_LONG",         0x1047,
        "PMERR_DATATYPE_TOO_SMALL",        0x1048,
        "PMERR_DIRECTION_INVALID",         0x1049,
        "PMERR_INVALID_HAB",               0x104A,
        "PMERR_INVALID_HSTRUCT",           0x104D,
        "PMERR_LENGTH_TOO_SMALL",          0x104E,
        "PMERR_MSGID_TOO_SMALL",           0x104F,
        "PMERR_NO_HANDLE_ALLOC",           0x1050,
        "PMERR_NOT_IN_A_PM_SESSION",       0x1051,
        "PMERR_MSG_QUEUE_ALREADY_EXISTS",  0x1052,
        "PMERR_INVALID_PIB",               0x1101,
        "PMERR_INSUFF_SPACE_TO_ADD",       0x1102,
        "PMERR_INVALID_GROUP_HANDLE",      0x1103,
        "PMERR_DUPLICATE_TITLE",           0x1104,
        "PMERR_INVALID_TITLE",             0x1105,
        "PMERR_HANDLE_NOT_IN_GROUP",       0x1107,
        "PMERR_INVALID_TARGET_HANDLE",     0x1106,
        "PMERR_INVALID_PATH_STATEMENT",    0x1108,
        "PMERR_NO_PROGRAM_FOUND",          0x1109,
        "PMERR_INVALID_BUFFER_SIZE",       0x110A,
        "PMERR_BUFFER_TOO_SMALL",          0x110B,
        "PMERR_PL_INITIALISATION_FAIL",    0x110C,
        "PMERR_CANT_DESTROY_SYS_GROUP",    0x110D,
        "PMERR_INVALID_TYPE_CHANGE",       0x110E,
        "PMERR_INVALID_PROGRAM_HANDLE",    0x110F,
        "PMERR_NOT_CURRENT_PL_VERSION",    0x1110,
        "PMERR_INVALID_CIRCULAR_REF",      0x1111,
        "PMERR_MEMORY_ALLOCATION_ERR",     0x1112,
        "PMERR_MEMORY_DEALLOCATION_ERR",   0x1113,
        "PMERR_TASK_HEADER_TOO_BIG",       0x1114,
        "PMERR_INVALID_INI_FILE_HANDLE",   0x1115,
        "PMERR_MEMORY_SHARE",              0x1116,
        "PMERR_OPEN_QUEUE",                0x1117,
        "PMERR_CREATE_QUEUE",              0x1118,
        "PMERR_WRITE_QUEUE",               0x1119,
        "PMERR_READ_QUEUE",                0x111A,
        "PMERR_CALL_NOT_EXECUTED",         0x111B,
        "PMERR_UNKNOWN_APIPKT",            0x111C,
        "PMERR_INITHREAD_EXISTS",          0x111D,
        "PMERR_CREATE_THREAD",             0x111E,
        "PMERR_NO_HK_PROFILE_INSTALLED",   0x111F,
        "PMERR_INVALID_DIRECTORY",         0x1120,
        "PMERR_WILDCARD_IN_FILENAME",      0x1121,
        "PMERR_FILENAME_BUFFER_FULL",      0x1122,
        "PMERR_FILENAME_TOO_LONG",         0x1123,
        "PMERR_INI_FILE_IS_SYS_OR_USER",   0x1124,
        "PMERR_BROADCAST_PLMSG",           0x1125,
        "PMERR_190_INIT_DONE",             0x1126,
        "PMERR_HMOD_FOR_PMSHAPI",          0x1127,
        "PMERR_SET_HK_PROFILE",            0x1128,
        "PMERR_API_NOT_ALLOWED",           0x1129,
        "PMERR_INI_STILL_OPEN",            0x112A,
        "PMERR_PROGDETAILS_NOT_IN_INI",    0x112B,
        "PMERR_PIBSTRUCT_NOT_IN_INI",      0x112C,
        "PMERR_INVALID_DISKPROGDETAILS",   0x112D,
        "PMERR_PROGDETAILS_READ_FAILURE",  0x112E,
        "PMERR_PROGDETAILS_WRITE_FAILURE", 0x112F,
        "PMERR_PROGDETAILS_QSIZE_FAILURE", 0x1130,
        "PMERR_INVALID_PROGDETAILS",       0x1131,
        "PMERR_SHEPROFILEHOOK_NOT_FOUND",  0x1132,
        "PMERR_190PLCONVERTED",            0x1133,
        "PMERR_FAILED_TO_CONVERT_INI_PL",  0x1134,
        "PMERR_PMSHAPI_NOT_INITIALISED",   0x1135,
        "PMERR_INVALID_SHELL_API_HOOK_ID", 0x1136,
        "PMERR_DOS_ERROR",                 0x1200,
        "PMERR_NO_SPACE",                  0x1201,
        "PMERR_INVALID_SWITCH_HANDLE",     0x1202,
        "PMERR_NO_HANDLE",                 0x1203,
        "PMERR_INVALID_PROCESS_ID",        0x1204,
        "PMERR_NOT_SHELL",                 0x1205,
        "PMERR_INVALID_WINDOW",            0x1206,
        "PMERR_INVALID_POST_MSG",          0x1207,
        "PMERR_INVALID_PARAMETERS",        0x1208,
        "PMERR_INVALID_PROGRAM_TYPE",      0x1209,
        "PMERR_NOT_EXTENDED_FOCUS",        0x120A,
        "PMERR_INVALID_SESSION_ID",        0x120B,
        "PMERR_SMG_INVALID_ICON_FILE",     0x120C,
        "PMERR_SMG_ICON_NOT_CREATED",      0x120D,
        "PMERR_SHL_DEBUG",                 0x120E,
        "PMERR_OPENING_INI_FILE",          0x1301,
        "PMERR_INI_FILE_CORRUPT",          0x1302,
        "PMERR_INVALID_PARM",              0x1303,
        "PMERR_NOT_IN_IDX",                0x1304,
        "PMERR_NO_ENTRIES_IN_GROUP",       0x1305,
        "PMERR_INI_WRITE_FAIL",            0x1306,
        "PMERR_IDX_FULL",                  0x1307,
        "PMERR_INI_PROTECTED",             0x1308,
        "PMERR_MEMORY_ALLOC",              0x1309,
        "PMERR_INI_INIT_ALREADY_DONE",     0x130A,
        "PMERR_INVALID_INTEGER",           0x130B,
        "PMERR_INVALID_ASCIIZ",            0x130C,
        "PMERR_CAN_NOT_CALL_SPOOLER",      0x130D,
        "PMERR_WARNING_WINDOW_NOT_KILLED", 0x1401,
        "PMERR_ERROR_INVALID_WINDOW",      0x1402,
        "PMERR_ALREADY_INITIALIZED",       0x1403,
        "PMERR_MSG_PROG_NO_MOU",           0x1405,
        "PMERR_MSG_PROG_NON_RECOV",        0x1406,
        "PMERR_WINCONV_INVALID_PATH",      0x1407,
        "PMERR_PI_NOT_INITIALISED",        0x1408,
        "PMERR_PL_NOT_INITIALISED",        0x1409,
        "PMERR_NO_TASK_MANAGER",           0x140A,
        "PMERR_SAVE_NOT_IN_PROGRESS",      0x140B,
        "PMERR_NO_STACK_SPACE",            0x140C,
        "PMERR_INVALID_COLR_FIELD",        0x140d,
        "PMERR_INVALID_COLR_VALUE",        0x140e,
        "PMERR_COLR_WRITE",                0x140f,
        "PMERR_TARGET_FILE_EXISTS",        0x1501,
        "PMERR_SOURCE_SAME_AS_TARGET",     0x1502,
        "PMERR_SOURCE_FILE_NOT_FOUND",     0x1503,
        "PMERR_INVALID_NEW_PATH",          0x1504,
        "PMERR_TARGET_FILE_NOT_FOUND",     0x1505,
        "PMERR_INVALID_DRIVE_NUMBER",      0x1506,
        "PMERR_NAME_TOO_LONG",             0x1507,
        "PMERR_NOT_ENOUGH_ROOM_ON_DISK",   0x1508,
        "PMERR_NOT_ENOUGH_MEM",            0x1509,
        "PMERR_LOG_DRV_DOES_NOT_EXIST",    0x150B,
        "PMERR_INVALID_DRIVE",             0x150C,
        "PMERR_ACCESS_DENIED",             0x150D,
        "PMERR_NO_FIRST_SLASH",            0x150E,
        "PMERR_READ_ONLY_FILE",            0x150F,
        "PMERR_GROUP_PROTECTED",           0x151F,
        "PMERR_INVALID_PROGRAM_CATEGORY",  0x152F,
        "PMERR_INVALID_APPL",              0x1530,
        "PMERR_CANNOT_START",              0x1531,
        "PMERR_STARTED_IN_BACKGROUND",     0x1532,
        "PMERR_INVALID_HAPP",              0x1533,
        "PMERR_CANNOT_STOP",               0x1534,
        "PMERR_INTERNAL_ERROR_1",          0x1601,
        "PMERR_INTERNAL_ERROR_2",          0x1602,
        "PMERR_INTERNAL_ERROR_3",          0x1603,
        "PMERR_INTERNAL_ERROR_4",          0x1604,
        "PMERR_INTERNAL_ERROR_5",          0x1605,
        "PMERR_INTERNAL_ERROR_6",          0x1606,
        "PMERR_INTERNAL_ERROR_7",          0x1607,
        "PMERR_INTERNAL_ERROR_8",          0x1608,
        "PMERR_INTERNAL_ERROR_9",          0x1609,
        "PMERR_INTERNAL_ERROR_10",         0x160A,
        "PMERR_INTERNAL_ERROR_11",         0x160B,
        "PMERR_INTERNAL_ERROR_12",         0x160C,
        "PMERR_INTERNAL_ERROR_13",         0x160D,
        "PMERR_INTERNAL_ERROR_14",         0x160E,
        "PMERR_INTERNAL_ERROR_15",         0x160F,
        "PMERR_INTERNAL_ERROR_16",         0x1610,
        "PMERR_INTERNAL_ERROR_17",         0x1611,
        "PMERR_INTERNAL_ERROR_18",         0x1612,
        "PMERR_INTERNAL_ERROR_19",         0x1613,
        "PMERR_INTERNAL_ERROR_20",         0x1614,
        "PMERR_INTERNAL_ERROR_21",         0x1615,
        "PMERR_INTERNAL_ERROR_22",         0x1616,
        "PMERR_INTERNAL_ERROR_23",         0x1617,
        "PMERR_INTERNAL_ERROR_24",         0x1618,
        "PMERR_INTERNAL_ERROR_25",         0x1619,
        "PMERR_INTERNAL_ERROR_26",         0x161A,
        "PMERR_INTERNAL_ERROR_27",         0x161B,
        "PMERR_INTERNAL_ERROR_28",         0x161C,
        "PMERR_INTERNAL_ERROR_29",         0x161D,
        "PMERR_INVALID_FREE_MESSAGE_ID",   0x1630,
        "PMERR_FUNCTION_NOT_SUPPORTED",    0x1641,
        "PMERR_INVALID_ARRAY_COUNT",       0x1642,
        "PMERR_INVALID_LENGTH",            0x1643,
        "PMERR_INVALID_BUNDLE_TYPE",       0x1644,
        "PMERR_INVALID_PARAMETER",         0x1645,
        "PMERR_INVALID_NUMBER_OF_PARMS",   0x1646,
        "PMERR_GREATER_THAN_64K",          0x1647,
        "PMERR_INVALID_PARAMETER_TYPE",    0x1648,
        "PMERR_NEGATIVE_STRCOND_DIM",      0x1649,
        "PMERR_INVALID_NUMBER_OF_TYPES",   0x164A,
        "PMERR_INCORRECT_HSTRUCT",         0x164B,
        "PMERR_INVALID_ARRAY_SIZE",        0x164C,
        "PMERR_INVALID_CONTROL_DATATYPE",  0x164D,
        "PMERR_INCOMPLETE_CONTROL_SEQU",   0x164E,
        "PMERR_INVALID_DATATYPE",          0x164F,
        "PMERR_INCORRECT_DATATYPE",        0x1650,
        "PMERR_NOT_SELF_DESCRIBING_DTYP",  0x1651,
        "PMERR_INVALID_CTRL_SEQ_INDEX",    0x1652,
        "PMERR_INVALID_TYPE_FOR_LENGTH",   0x1653,
        "PMERR_INVALID_TYPE_FOR_OFFSET",   0x1654,
        "PMERR_INVALID_TYPE_FOR_MPARAM",   0x1655,
        "PMERR_INVALID_MESSAGE_ID",        0x1656,
        "PMERR_C_LENGTH_TOO_SMALL",        0x1657,
        "PMERR_APPL_STRUCTURE_TOO_SMALL",  0x1658,
        "PMERR_INVALID_ERRORINFO_HANDLE",  0x1659,
        "PMERR_INVALID_CHARACTER_INDEX",   0x165A,
        "PMERR_OK",                        0x0000,
        "PMERR_ALREADY_IN_AREA",           0x2001,
        "PMERR_ALREADY_IN_ELEMENT",        0x2002,
        "PMERR_ALREADY_IN_PATH",           0x2003,
        "PMERR_ALREADY_IN_SEG",            0x2004,
        "PMERR_AREA_INCOMPLETE",           0x2005,
        "PMERR_BASE_ERROR",                0x2006,
        "PMERR_BITBLT_LENGTH_EXCEEDED",    0x2007,
        "PMERR_BITMAP_IN_USE",             0x2008,
        "PMERR_BITMAP_IS_SELECTED",        0x2009,
        "PMERR_BITMAP_NOT_FOUND",          0x200A,
        "PMERR_BITMAP_NOT_SELECTED",       0x200B,
        "PMERR_BOUNDS_OVERFLOW",           0x200C,
        "PMERR_CALLED_SEG_IS_CHAINED",     0x200D,
        "PMERR_CALLED_SEG_IS_CURRENT",     0x200E,
        "PMERR_CALLED_SEG_NOT_FOUND",      0x200F,
        "PMERR_CANNOT_DELETE_ALL_DATA",    0x2010,
        "PMERR_CANNOT_REPLACE_ELEMENT_0",  0x2011,
        "PMERR_COL_TABLE_NOT_REALIZABLE",  0x2012,
        "PMERR_COL_TABLE_NOT_REALIZED",    0x2013,
        "PMERR_COORDINATE_OVERFLOW",       0x2014,
        "PMERR_CORR_FORMAT_MISMATCH",      0x2015,
        "PMERR_DATA_TOO_LONG",             0x2016,
        "PMERR_DC_IS_ASSOCIATED",          0x2017,
        "PMERR_DESC_STRING_TRUNCATED",     0x2018,
        "PMERR_DEVICE_DRIVER_ERROR_1",     0x2019,
        "PMERR_DEVICE_DRIVER_ERROR_2",     0x201A,
        "PMERR_DEVICE_DRIVER_ERROR_3",     0x201B,
        "PMERR_DEVICE_DRIVER_ERROR_4",     0x201C,
        "PMERR_DEVICE_DRIVER_ERROR_5",     0x201D,
        "PMERR_DEVICE_DRIVER_ERROR_6",     0x201E,
        "PMERR_DEVICE_DRIVER_ERROR_7",     0x201F,
        "PMERR_DEVICE_DRIVER_ERROR_8",     0x2020,
        "PMERR_DEVICE_DRIVER_ERROR_9",     0x2021,
        "PMERR_DEVICE_DRIVER_ERROR_10",    0x2022,
        "PMERR_DEV_FUNC_NOT_INSTALLED",    0x2023,
        "PMERR_DOSOPEN_FAILURE",           0x2024,
        "PMERR_DOSREAD_FAILURE",           0x2025,
        "PMERR_DRIVER_NOT_FOUND",          0x2026,
        "PMERR_DUP_SEG",                   0x2027,
        "PMERR_DYNAMIC_SEG_SEQ_ERROR",     0x2028,
        "PMERR_DYNAMIC_SEG_ZERO_INV",      0x2029,
        "PMERR_ELEMENT_INCOMPLETE",        0x202A,
        "PMERR_ESC_CODE_NOT_SUPPORTED",    0x202B,
        "PMERR_EXCEEDS_MAX_SEG_LENGTH",    0x202C,
        "PMERR_FONT_AND_MODE_MISMATCH",    0x202D,
        "PMERR_FONT_FILE_NOT_LOADED",      0x202E,
        "PMERR_FONT_NOT_LOADED",           0x202F,
        "PMERR_FONT_TOO_BIG",              0x2030,
        "PMERR_HARDWARE_INIT_FAILURE",     0x2031,
        "PMERR_HBITMAP_BUSY",              0x2032,
        "PMERR_HDC_BUSY",                  0x2033,
        "PMERR_HRGN_BUSY",                 0x2034,
        "PMERR_HUGE_FONTS_NOT_SUPPORTED",  0x2035,
        "PMERR_ID_HAS_NO_BITMAP",          0x2036,
        "PMERR_IMAGE_INCOMPLETE",          0x2037,
        "PMERR_INCOMPAT_COLOR_FORMAT",     0x2038,
        "PMERR_INCOMPAT_COLOR_OPTIONS",    0x2039,
        "PMERR_INCOMPATIBLE_BITMAP",       0x203A,
        "PMERR_INCOMPATIBLE_METAFILE",     0x203B,
        "PMERR_INCORRECT_DC_TYPE",         0x203C,
        "PMERR_INSUFFICIENT_DISK_SPACE",   0x203D,
        "PMERR_INSUFFICIENT_MEMORY",       0x203E,
        "PMERR_INV_ANGLE_PARM",            0x203F,
        "PMERR_INV_ARC_CONTROL",           0x2040,
        "PMERR_INV_AREA_CONTROL",          0x2041,
        "PMERR_INV_ARC_POINTS",            0x2042,
        "PMERR_INV_ATTR_MODE",             0x2043,
        "PMERR_INV_BACKGROUND_COL_ATTR",   0x2044,
        "PMERR_INV_BACKGROUND_MIX_ATTR",   0x2045,
        "PMERR_INV_BITBLT_MIX",            0x2046,
        "PMERR_INV_BITBLT_STYLE",          0x2047,
        "PMERR_INV_BITMAP_DIMENSION",      0x2048,
        "PMERR_INV_BOX_CONTROL",           0x2049,
        "PMERR_INV_BOX_ROUNDING_PARM",     0x204A,
        "PMERR_INV_CHAR_ANGLE_ATTR",       0x204B,
        "PMERR_INV_CHAR_DIRECTION_ATTR",   0x204C,
        "PMERR_INV_CHAR_MODE_ATTR",        0x204D,
        "PMERR_INV_CHAR_POS_OPTIONS",      0x204E,
        "PMERR_INV_CHAR_SET_ATTR",         0x204F,
        "PMERR_INV_CHAR_SHEAR_ATTR",       0x2050,
        "PMERR_INV_CLIP_PATH_OPTIONS",     0x2051,
        "PMERR_INV_CODEPAGE",              0x2052,
        "PMERR_INV_COLOR_ATTR",            0x2053,
        "PMERR_INV_COLOR_DATA",            0x2054,
        "PMERR_INV_COLOR_FORMAT",          0x2055,
        "PMERR_INV_COLOR_INDEX",           0x2056,
        "PMERR_INV_COLOR_OPTIONS",         0x2057,
        "PMERR_INV_COLOR_START_INDEX",     0x2058,
        "PMERR_INV_COORD_OFFSET",          0x2059,
        "PMERR_INV_COORD_SPACE",           0x205A,
        "PMERR_INV_COORDINATE",            0x205B,
        "PMERR_INV_CORRELATE_DEPTH",       0x205C,
        "PMERR_INV_CORRELATE_TYPE",        0x205D,
        "PMERR_INV_CURSOR_BITMAP",         0x205E,
        "PMERR_INV_DC_DATA",               0x205F,
        "PMERR_INV_DC_TYPE",               0x2060,
        "PMERR_INV_DEVICE_NAME",           0x2061,
        "PMERR_INV_DEV_MODES_OPTIONS",     0x2062,
        "PMERR_INV_DRAW_CONTROL",          0x2063,
        "PMERR_INV_DRAW_VALUE",            0x2064,
        "PMERR_INV_DRAWING_MODE",          0x2065,
        "PMERR_INV_DRIVER_DATA",           0x2066,
        "PMERR_INV_DRIVER_NAME",           0x2067,
        "PMERR_INV_DRAW_BORDER_OPTION",    0x2068,
        "PMERR_INV_EDIT_MODE",             0x2069,
        "PMERR_INV_ELEMENT_OFFSET",        0x206A,
        "PMERR_INV_ELEMENT_POINTER",       0x206B,
        "PMERR_INV_END_PATH_OPTIONS",      0x206C,
        "PMERR_INV_ESC_CODE",              0x206D,
        "PMERR_INV_ESCAPE_DATA",           0x206E,
        "PMERR_INV_EXTENDED_LCID",         0x206F,
        "PMERR_INV_FILL_PATH_OPTIONS",     0x2070,
        "PMERR_INV_FIRST_CHAR",            0x2071,
        "PMERR_INV_FONT_ATTRS",            0x2072,
        "PMERR_INV_FONT_FILE_DATA",        0x2073,
        "PMERR_INV_FOR_THIS_DC_TYPE",      0x2074,
        "PMERR_INV_FORMAT_CONTROL",        0x2075,
        "PMERR_INV_FORMS_CODE",            0x2076,
        "PMERR_INV_FONTDEF",               0x2077,
        "PMERR_INV_GEOM_LINE_WIDTH_ATTR",  0x2078,
        "PMERR_INV_GETDATA_CONTROL",       0x2079,
        "PMERR_INV_GRAPHICS_FIELD",        0x207A,
        "PMERR_INV_HBITMAP",               0x207B,
        "PMERR_INV_HDC",                   0x207C,
        "PMERR_INV_HJOURNAL",              0x207D,
        "PMERR_INV_HMF",                   0x207E,
        "PMERR_INV_HPS",                   0x207F,
        "PMERR_INV_HRGN",                  0x2080,
        "PMERR_INV_ID",                    0x2081,
        "PMERR_INV_IMAGE_DATA_LENGTH",     0x2082,
        "PMERR_INV_IMAGE_DIMENSION",       0x2083,
        "PMERR_INV_IMAGE_FORMAT",          0x2084,
        "PMERR_INV_IN_AREA",               0x2085,
        "PMERR_INV_IN_CALLED_SEG",         0x2086,
        "PMERR_INV_IN_CURRENT_EDIT_MODE",  0x2087,
        "PMERR_INV_IN_DRAW_MODE",          0x2088,
        "PMERR_INV_IN_ELEMENT",            0x2089,
        "PMERR_INV_IN_IMAGE",              0x208A,
        "PMERR_INV_IN_PATH",               0x208B,
        "PMERR_INV_IN_RETAIN_MODE",        0x208C,
        "PMERR_INV_IN_SEG",                0x208D,
        "PMERR_INV_IN_VECTOR_SYMBOL",      0x208E,
        "PMERR_INV_INFO_TABLE",            0x208F,
        "PMERR_INV_JOURNAL_OPTION",        0x2090,
        "PMERR_INV_KERNING_FLAGS",         0x2091,
        "PMERR_INV_LENGTH_OR_COUNT",       0x2092,
        "PMERR_INV_LINE_END_ATTR",         0x2093,
        "PMERR_INV_LINE_JOIN_ATTR",        0x2094,
        "PMERR_INV_LINE_TYPE_ATTR",        0x2095,
        "PMERR_INV_LINE_WIDTH_ATTR",       0x2096,
        "PMERR_INV_LOGICAL_ADDRESS",       0x2097,
        "PMERR_INV_MARKER_BOX_ATTR",       0x2098,
        "PMERR_INV_MARKER_SET_ATTR",       0x2099,
        "PMERR_INV_MARKER_SYMBOL_ATTR",    0x209A,
        "PMERR_INV_MATRIX_ELEMENT",        0x209B,
        "PMERR_INV_MAX_HITS",              0x209C,
        "PMERR_INV_METAFILE",              0x209D,
        "PMERR_INV_METAFILE_LENGTH",       0x209E,
        "PMERR_INV_METAFILE_OFFSET",       0x209F,
        "PMERR_INV_MICROPS_DRAW_CONTROL",  0x20A0,
        "PMERR_INV_MICROPS_FUNCTION",      0x20A1,
        "PMERR_INV_MICROPS_ORDER",         0x20A2,
        "PMERR_INV_MIX_ATTR",              0x20A3,
        "PMERR_INV_MODE_FOR_OPEN_DYN",     0x20A4,
        "PMERR_INV_MODE_FOR_REOPEN_SEG",   0x20A5,
        "PMERR_INV_MODIFY_PATH_MODE",      0x20A6,
        "PMERR_INV_MULTIPLIER",            0x20A7,
        "PMERR_INV_NESTED_FIGURES",        0x20A8,
        "PMERR_INV_OR_INCOMPAT_OPTIONS",   0x20A9,
        "PMERR_INV_ORDER_LENGTH",          0x20AA,
        "PMERR_INV_ORDERING_PARM",         0x20AB,
        "PMERR_INV_OUTSIDE_DRAW_MODE",     0x20AC,
        "PMERR_INV_PAGE_VIEWPORT",         0x20AD,
        "PMERR_INV_PATH_ID",               0x20AE,
        "PMERR_INV_PATH_MODE",             0x20AF,
        "PMERR_INV_PATTERN_ATTR",          0x20B0,
        "PMERR_INV_PATTERN_REF_PT_ATTR",   0x20B1,
        "PMERR_INV_PATTERN_SET_ATTR",      0x20B2,
        "PMERR_INV_PATTERN_SET_FONT",      0x20B3,
        "PMERR_INV_PICK_APERTURE_OPTION",  0x20B4,
        "PMERR_INV_PICK_APERTURE_POSN",    0x20B5,
        "PMERR_INV_PICK_APERTURE_SIZE",    0x20B6,
        "PMERR_INV_PICK_NUMBER",           0x20B7,
        "PMERR_INV_PLAY_METAFILE_OPTION",  0x20B8,
        "PMERR_INV_PRIMITIVE_TYPE",        0x20B9,
        "PMERR_INV_PS_SIZE",               0x20BA,
        "PMERR_INV_PUTDATA_FORMAT",        0x20BB,
        "PMERR_INV_QUERY_ELEMENT_NO",      0x20BC,
        "PMERR_INV_RECT",                  0x20BD,
        "PMERR_INV_REGION_CONTROL",        0x20BE,
        "PMERR_INV_REGION_MIX_MODE",       0x20BF,
        "PMERR_INV_REPLACE_MODE_FUNC",     0x20C0,
        "PMERR_INV_RESERVED_FIELD",        0x20C1,
        "PMERR_INV_RESET_OPTIONS",         0x20C2,
        "PMERR_INV_RGBCOLOR",              0x20C3,
        "PMERR_INV_SCAN_START",            0x20C4,
        "PMERR_INV_SEG_ATTR",              0x20C5,
        "PMERR_INV_SEG_ATTR_VALUE",        0x20C6,
        "PMERR_INV_SEG_CH_LENGTH",         0x20C7,
        "PMERR_INV_SEG_NAME",              0x20C8,
        "PMERR_INV_SEG_OFFSET",            0x20C9,
        "PMERR_INV_SETID",                 0x20CA,
        "PMERR_INV_SETID_TYPE",            0x20CB,
        "PMERR_INV_SET_VIEWPORT_OPTION",   0x20CC,
        "PMERR_INV_SHARPNESS_PARM",        0x20CD,
        "PMERR_INV_SOURCE_OFFSET",         0x20CE,
        "PMERR_INV_STOP_DRAW_VALUE",       0x20CF,
        "PMERR_INV_TRANSFORM_TYPE",        0x20D0,
        "PMERR_INV_USAGE_PARM",            0x20D1,
        "PMERR_INV_VIEWING_LIMITS",        0x20D2,
        "PMERR_JFILE_BUSY",                0x20D3,
        "PMERR_JNL_FUNC_DATA_TOO_LONG",    0x20D4,
        "PMERR_KERNING_NOT_SUPPORTED",     0x20D5,
        "PMERR_LABEL_NOT_FOUND",           0x20D6,
        "PMERR_MATRIX_OVERFLOW",           0x20D7,
        "PMERR_METAFILE_INTERNAL_ERROR",   0x20D8,
        "PMERR_METAFILE_IN_USE",           0x20D9,
        "PMERR_METAFILE_LIMIT_EXCEEDED",   0x20DA,
        "PMERR_NAME_STACK_FULL",           0x20DB,
        "PMERR_NOT_CREATED_BY_DEVOPENDC",  0x20DC,
        "PMERR_NOT_IN_AREA",               0x20DD,
        "PMERR_NOT_IN_DRAW_MODE",          0x20DE,
        "PMERR_NOT_IN_ELEMENT",            0x20DF,
        "PMERR_NOT_IN_IMAGE",              0x20E0,
        "PMERR_NOT_IN_PATH",               0x20E1,
        "PMERR_NOT_IN_RETAIN_MODE",        0x20E2,
        "PMERR_NOT_IN_SEG",                0x20E3,
        "PMERR_NO_BITMAP_SELECTED",        0x20E4,
        "PMERR_NO_CURRENT_ELEMENT",        0x20E5,
        "PMERR_NO_CURRENT_SEG",            0x20E6,
        "PMERR_NO_METAFILE_RECORD_HANDLE", 0x20E7,
        "PMERR_ORDER_TOO_BIG",             0x20E8,
        "PMERR_OTHER_SET_ID_REFS",         0x20E9,
        "PMERR_OVERRAN_SEG",               0x20EA,
        "PMERR_OWN_SET_ID_REFS",           0x20EB,
        "PMERR_PATH_INCOMPLETE",           0x20EC,
        "PMERR_PATH_LIMIT_EXCEEDED",       0x20ED,
        "PMERR_PATH_UNKNOWN",              0x20EE,
        "PMERR_PEL_IS_CLIPPED",            0x20EF,
        "PMERR_PEL_NOT_AVAILABLE",         0x20F0,
        "PMERR_PRIMITIVE_STACK_EMPTY",     0x20F1,
        "PMERR_PROLOG_ERROR",              0x20F2,
        "PMERR_PROLOG_SEG_ATTR_NOT_SET",   0x20F3,
        "PMERR_PS_BUSY",                   0x20F4,
        "PMERR_PS_IS_ASSOCIATED",          0x20F5,
        "PMERR_RAM_JNL_FILE_TOO_SMALL",    0x20F6,
        "PMERR_REALIZE_NOT_SUPPORTED",     0x20F7,
        "PMERR_REGION_IS_CLIP_REGION",     0x20F8,
        "PMERR_RESOURCE_DEPLETION",        0x20F9,
        "PMERR_SEG_AND_REFSEG_ARE_SAME",   0x20FA,
        "PMERR_SEG_CALL_RECURSIVE",        0x20FB,
        "PMERR_SEG_CALL_STACK_EMPTY",      0x20FC,
        "PMERR_SEG_CALL_STACK_FULL",       0x20FD,
        "PMERR_SEG_IS_CURRENT",            0x20FE,
        "PMERR_SEG_NOT_CHAINED",           0x20FF,
        "PMERR_SEG_NOT_FOUND",             0x2100,
        "PMERR_SEG_STORE_LIMIT_EXCEEDED",  0x2101,
        "PMERR_SETID_IN_USE",              0x2102,
        "PMERR_SETID_NOT_FOUND",           0x2103,
        "PMERR_STARTDOC_NOT_ISSUED",       0x2104,
        "PMERR_STOP_DRAW_OCCURRED",        0x2105,
        "PMERR_TOO_MANY_METAFILES_IN_USE", 0x2106,
        "PMERR_TRUNCATED_ORDER",           0x2107,
        "PMERR_UNCHAINED_SEG_ZERO_INV",    0x2108,
        "PMERR_UNSUPPORTED_ATTR",          0x2109,
        "PMERR_UNSUPPORTED_ATTR_VALUE",    0x210A,
        "PMERR_ENDDOC_NOT_ISSUED",         0x210B,
        "PMERR_SPL_DRIVER_ERROR",          0x4001,
        "PMERR_SPL_DEVICE_ERROR",          0x4002,
        "PMERR_SPL_DEVICE_NOT_INSTALLED",  0x4003,
        "PMERR_SPL_QUEUE_ERROR",           0x4004,
        "PMERR_SPL_INV_HSPL",              0x4005,
        "PMERR_SPL_NO_DISK_SPACE",         0x4006,
        "PMERR_SPL_NO_MEMORY",             0x4007,
        "PMERR_SPL_PRINT_ABORT",           0x4008,
        "PMERR_SPL_SPOOLER_NOT_INSTALLED", 0x4009,
        "PMERR_SPL_INV_FORMS_CODE",        0x400A,
        "PMERR_SPL_INV_PRIORITY",          0x400B,
        "PMERR_SPL_NO_FREE_JOB_ID",        0x400C,
        "PMERR_SPL_NO_DATA",               0x400D,
        "PMERR_SPL_INV_TOKEN",             0x400E,
        "PMERR_SPL_INV_DATATYPE",          0x400F,
        "PMERR_SPL_PROCESSOR_ERROR",       0x4010,
        "PMERR_SPL_INV_JOB_ID",            0x4011,
        "PMERR_SPL_JOB_NOT_PRINTING",      0x4012,
        "PMERR_SPL_JOB_PRINTING",          0x4013,
        "PMERR_SPL_QUEUE_ALREADY_EXISTS",  0x4014,
        "PMERR_SPL_INV_QUEUE_NAME",        0x4015,
        "PMERR_SPL_QUEUE_NOT_EMPTY",       0x4016,
        "PMERR_SPL_DEVICE_ALREADY_EXISTS", 0x4017,
        "PMERR_SPL_DEVICE_LIMIT_REACHED",  0x4018,
        "PMERR_SPL_STATUS_STRING_TRUNC",   0x4019,
        "PMERR_SPL_INV_LENGTH_OR_COUNT",   0x401A,
        "PMERR_SPL_FILE_NOT_FOUND",        0x401B,
        "PMERR_SPL_CANNOT_OPEN_FILE",      0x401C,
        "PMERR_SPL_DRIVER_NOT_INSTALLED",  0x401D,
        "PMERR_SPL_INV_PROCESSOR_DATTYPE", 0x401E,
        "PMERR_SPL_INV_DRIVER_DATATYPE",   0x401F,
        "PMERR_SPL_PROCESSOR_NOT_INST",    0x4020,
        "PMERR_SPL_NO_SUCH_LOG_ADDRESS",   0x4021,
        "PMERR_SPL_PRINTER_NOT_FOUND",     0x4022,
        "PMERR_SPL_DD_NOT_FOUND",          0x4023,
        "PMERR_SPL_QUEUE_NOT_FOUND",       0x4024,
        "PMERR_SPL_MANY_QUEUES_ASSOC",     0x4025,
        "PMERR_SPL_NO_QUEUES_ASSOCIATED",  0x4026,
        "PMERR_SPL_INI_FILE_ERROR",        0x4027,
        "PMERR_SPL_NO_DEFAULT_QUEUE",      0x4028,
        "PMERR_SPL_NO_CURRENT_FORMS_CODE", 0x4029,
        "PMERR_SPL_NOT_AUTHORISED",        0x402A,
        "PMERR_SPL_TEMP_NETWORK_ERROR",    0x402B,
        "PMERR_SPL_HARD_NETWORK_ERROR",    0x402C,
        "PMERR_DEL_NOT_ALLOWED",           0x402D,
        "PMERR_CANNOT_DEL_QP_REF",         0x402E,
        "PMERR_CANNOT_DEL_QNAME_REF",      0x402F,
        "PMERR_CANNOT_DEL_PRINTER_DD_REF", 0x4030,
        "PMERR_CANNOT_DEL_PRN_NAME_REF",   0x4031,
        "PMERR_CANNOT_DEL_PRN_ADDR_REF",   0x4032,
        "PMERR_SPOOLER_QP_NOT_DEFINED",    0x4033,
        "PMERR_PRN_NAME_NOT_DEFINED",      0x4034,
        "PMERR_PRN_ADDR_NOT_DEFINED",      0x4035,
        "PMERR_PRINTER_DD_NOT_DEFINED",    0x4036,
        "PMERR_PRINTER_QUEUE_NOT_DEFINED", 0x4037,
        "PMERR_PRN_ADDR_IN_USE",           0x4038,
        "PMERR_SPL_TOO_MANY_OPEN_FILES",   0x4039,
        "PMERR_SPL_CP_NOT_REQD",           0x403A,
        "PMERR_UNABLE_TO_CLOSE_DEVICE",    0x4040,
        "PMERR_INV_TYPE",                  0x5001,
        "PMERR_INV_CONV",                  0x5002,
        "PMERR_INV_SEGLEN",                0x5003,
        "PMERR_DUP_SEGNAME",               0x5004,
        "PMERR_INV_XFORM",                 0x5005,
        "PMERR_INV_VIEWLIM",               0x5006,
        "PMERR_INV_3DCOORD",               0x5007,
        "PMERR_SMB_OVFLOW",                0x5008,
        "PMERR_SEG_OVFLOW",                0x5009,
        "PMERR_PIC_DUP_FILENAME",          0x5010,
     };
