#ifndef GPIIMAGE_H
#define GPIIMAGE_H

/****************************************************************************
 *\\ddd
 * Subtask Name: PDVT
 *
 * Module name:  GPIIMAGE
 *
 * Purpose:  Include file for GpiImage DLL.
 *
 * Revision Log: 10/24/90, PDVT, Donna Williams
 *                     - initial creation
 *               11/17/90 ,PDVT ,Mike ABuzant
 *                     - Included some more DEFINE  statments.
 *
 *               12/04/90 ,PDVT, Mike Abuzant
 *                     -Eliminated hAB parameter.
 *               12/06/90 ,PDVT ,Mike ABuzant
 *                     - Included some more DEFINE  statments.
 *
 * SRS References: 5.10
 *
 * Contents: This file contains the following definitions:
 *
 *           - function prototypes
 *           - defines specific to GpiImage
 *
 * Limitations: NONE
 *
 *\\end
****************************************************************************/

VOID  APIENTRY GpiImagePre(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiImageApp(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiImageExh(HPS hPS, HWND hWndClient, BOOL SelectionCall);

#define NTESTS  3
#define IMAGESIZE  2000
#define ALLOCFLAGS 0
#define DATASIZE  32            // size of array used to hold bit-map informations.
#define MAX_IMAGE_WIDTH  700    //Max width of bitmaps allowable for
                                // GpiImage().
#define CONVERTTOINCHES(Value)  (((double)Value)/((double)100.000000/(double)2.5400050800))
#define PIXELSPERUNIT(a,b,c)    ((a)*((double)(b)/CONVERTTOINCHES((c))))

PCHAR  testname0="GpiImageRc";
PCHAR  testname1="GpiImagePre";
PCHAR  testname2="GpiImageApp";
PCHAR  testname3="GpiImageExh";
PCHAR  testcase ="GPI Image";

INT GpiImage_test1(HPS hPS, HWND hWndClient);
LONG GpiImage_test2(HPS hPS, HWND hWndClient);
LONG GpiImage_test3(HPS hPS, HWND hWndClient);
LONG GpiImage_test4(HPS hPS, HWND hWndClient);
LONG GpiImage_test5(HPS hPS, HWND hWndClient);
LONG GpiImage_test6(HPS hPS, HWND hWndClient);

#endif

