/****************************************************************************
 *\\ddd
 * Subtask Name: PDVT
 *
 * Module name:  GPIIMAGE
 *
 * Purpose:  This module is called by PTT to test the Gpi Image APIs.
 *
 * Revision Log: 10/24/90, PDVT, Donna Williams
 *                     - initial creation
 *               11/09/90 ,PDVT, Mike Abuzant
 *                     -TestCase Design
 *               12/04/90 ,PDVT, Mike Abuzant
 *                     -Eliminated hAB parameter.
 *                     -Edited limitation Section
 *               12/06/90 ,PDVT, Mike Abuzant
 *                     -Integrated MAPPING functions
 *                     -Code reconstruction.
 *               01/03/91, pdvt, markrichardson
 *                     - remove std_err references
 *               02/13/91 ,PDVT, Mike Abuzant
 *                     -TestCase Cleaning up.
 *
 * SRS References: Section 5.10
 *
 * Contents: InitTest(),
 *           GpiImagePre(),
 *           GpiImageApp(),
 *           GpiImageExh()
 *
 * Design Overview:
 *
 *    This TestCase is designed to test the Gpi function GpiImage(). This
 *    Gpi is used to display  raster (bit-map) images. The functionality
 *    of this Gpi will be tested  along with testing all the error
 *    codes that may be returned by this Gpi.
 *
 * Limitations:
 *   1. GpiImage() CAN NOT  be used to load bitmaps that
 *      a pixel is represented by more than one bit.
 *
 *\\end
****************************************************************************/
#define INCL_WIN
#define INCL_GPI
#define INCL_ERRORS
#define INCL_DEV

#include <string.h>
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include "PTTDLLDF.h"                     // test case defines
#include "gpiimage.h"
#include "gpi_grid.h"                        // For grid drawing functions
#include "std_util.h"                        // for screen comments

/****************************************************************************
 *\\ddd
 * Routine Name: InitTest()
 *
 * Purpose: Initialize function name and address array for PTT.
 *
 * System Requirements: NONE
 *
 * Revision Log: 10/24/90, PDVT, Donna Williams
 *                     - initial creation
 *               11/09/90, PDVT ,Mike Abuzant
 *                     - TestCase Design
 *
 * Inputs: sel               - pass thru parameter for other function calls.
 *         init_info_p       - pointer to info array.
 *
 * Outputs: init_info_p      - updated with all entry point names and addresses
 *
 * Subroutines Required:
 *                InitTestSegVars()
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 *
 *  Set the testcase name .
 *   for the number of test functions {
 *       set function name
 *       set function address
 *   }
 *   call init set function
 *
 *\\end
 ***************************************************************************/
VOID APIENTRY InitTest(PVOID sel, PTESTINITINFO init_info_p)
  {
    strcpy(init_info_p->group_name,testcase); //Testcase Name
    init_info_p->ntests = NTESTS;
    strcpy(init_info_p->test_names[0],testname1);
    init_info_p->test_addrs[0]=GpiImagePre;
    strcpy(init_info_p->test_names[1],testname2);
    init_info_p->test_addrs[1]=GpiImageApp;
    strcpy(init_info_p->test_names[2],testname3);
    init_info_p->test_addrs[2]=GpiImageExh;
    strcpy(init_info_p->test_names[3],testname0);
    InitTestSegVars(sel);
  }

/****************************************************************************
 *\\ddd
 * Routine Name: GpiImagePre()
 *
 * Purpose: This PTT entry point will call the precision test.
 *
 * System Requirements: Section 5.10.2
 *
 * Revision Log: 10/24/90, PDVT, Donna Williams
 *                     - initial creation
 *
 * Inputs:  hPS           - presentation space handle
 *          hWndClient  - client window handle
 *          SelectionCall- selection indicator
 *
 * Outputs:
 *
 * Subroutines Required:
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 *   //Call the grid function to  draw 100 X 100  grid
 *    gpi_grid(hPS, ....);
 *    // move to one of the grids cells
 *       GpiMove(hPS..);
 *    //   change  the foreground  color to GREEN
 *         GpiSetColor(hPS..);
 *   // setup the bitmap in an array to draw a solid bitmap  image inside
 *   // inside a grid cell.
 *   // Since the bitmap dimensions must by multiple of 8, This setup
 *      took some calculations because the grid size is 100 X 100.
 *      for (index=0 ....){
 *       fill the BYTE array with the appropriate  byte to form a solid
 *       bitmap.
 *      }
 *    // draw the bitmap
 *       GpiImage(hPS....).
 *    // move coordinates to  one corner of the grid cell
 *       GpiMove(hPS..);
 *    //   change  the foreground  color to CLR_RED
 *         GpiSetColor(hPS..);
 *   // setup the bitmap in an array to draw CROSS bitmap image that is
 *   // centered  inside a grid cell
 *   // Since the bitmap dimensions must by multiple of 8, This setup
 *      took some calculations because the grid size is 100 X 100.
 *      for (index=0 ....){
 *       fill the BYTE array with the appropriate byte to form a centered
 *       CROSS bit-map.
 *      }
 *    // draw the bitmap
 *       GpiImage(hPS....).
 *    // move coordinates to  one corner of the grid cell
 *       GpiMove(hPS..);
 *    //   change  the foreground  color to CLR_BLUE
 *         GpiSetColor(hPS..);
 *   // setup the bitmap in an array to draw  bitmap  image that
 *   // Lookslike a one pixel horizontal LINE
 *   // Since the bitmap dimensions must by multiple of 8, This setup
 *      took some calculations because the grid size is 100 X 100.
 *       fill the BYTE array with the appropriate byte to form a
 *       horizontal Line bit-map.
 *    // draw the bitmap
 *       GpiImage(hPS....).
 *    // Set the foreground color to CLR_BLACK and return .
 *       GpiSetColor(hPS...);
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiImagePre(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  POINTL ptl;                           //Screen coordinate point
  SIZEL sizel;                          // size of bitmap to draw
  INT   xaccess;
  INT   yaccess;
  LONG lIndex;                          // used as an index into bitmap array
  PBYTE  abImage;                      // used to store bitmap image
  PVOID    ImageSel;
  LONG   Temp;
  LONG lErrorCount;
  CHAR ErrorString[200];

  if (SelectionCall) {
     WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
     *pBasisX=
     *pBasisY=10000;
  }
  else {
        TEST_SIGNATURE(0,0);
        LOG_SIGNATURE;
        lErrorCount = 0L;
        set_delta(hPS);
        CWRITELOG(L_LOTRACE,0,"+ee+ GpiImagePre Precision Test - Entry Point\n");
        // call the grid function to draw 1 INCH  grid cells.
        // Allocate Segment to hold bitmap data
        DosAllocMem(&ImageSel,MAX_IMAGE_WIDTH*((MAX_IMAGE_WIDTH/8)+1),
                    PAG_WRITE | PAG_READ | PAG_COMMIT);

        abImage = ImageSel;
        gpi_grid(hPS,(LONG)INCH);

        // Set the width and height of the bit map in units of pixels.
        // This time the bitmap will be delta_x X delta_y  pixels.
        sizel.cx=(LONG)CONVERTTOINCHES(hori_pels_per_m);
        sizel.cx+=(LONG)(8-(sizel.cx%8));  // Must be multiple of 8's
        xaccess=(INT)(sizel.cx-(LONG)CONVERTTOINCHES(hori_pels_per_m));
        Temp=
        sizel.cy=(LONG)CONVERTTOINCHES(vert_pels_per_m);
        yaccess=(INT)(sizel.cy-(LONG)CONVERTTOINCHES(vert_pels_per_m));
        sizel.cy+=(8-(sizel.cy%8));  // Must be multiple of 8's
        memset(abImage,0x00,MAX_IMAGE_WIDTH*(MAX_IMAGE_WIDTH/8+1));

        ptl.x=2*delta_x;
        ptl.y=4*delta_y;
        MapPt(ptl);
        if ( GpiMove(hPS,&ptl)==GPI_ERROR) {
        }
        if (GpiSetColor(hPS,CLR_GREEN)==GPI_ERROR){   // Set foreground color to Green
        }
        for (lIndex=0 ;lIndex<=Temp;lIndex++){
            // fill the appropriate bits to form a solid bitmap
            memset(abImage+lIndex*(sizel.cx/8),0xff,(USHORT)(sizel.cx/8));
            //The last four bits are OFF since grids are 100 X100 pixel
            abImage[((lIndex+1)*(sizel.cx/8))-1]=(BYTE)
                    ((xaccess>2) ? (0xff <<(xaccess-2)) : 0xff);
        }
        memset(&abImage[((lIndex-yaccess)*(sizel.cx/8))],0x00,(USHORT)(sizel.cx/8*yaccess));
        if (GpiImage(hPS, 0L,&sizel, sizel.cx/8*sizel.cy , abImage)==GPI_ERROR) {
        }
        sprintf(ErrorString,"Image Of Square Box 1\" X 1\"  Located @ (2\",3\")" );
        if (GpiSetColor(hPS,CLR_DEFAULT)==GPI_ERROR) {   // Set foreground color to Green
        }
        ptl.x=delta_x;
        ptl.y=3*delta_y-delta_y/3;
        MapAndWriteString(hPS,ptl.x,ptl.y,ErrorString);
        /**********************************************************
        * Draw a bitmap of a CROSS inside one of the grid boxes
        ***********************************************************/
        sizel.cx=(LONG)CONVERTTOINCHES(hori_pels_per_m);
        sizel.cx+=(8-(sizel.cx%8));  // Must be multiple of 8's
        xaccess=(INT)(sizel.cx-CONVERTTOINCHES(hori_pels_per_m));
        Temp=
        sizel.cy=(LONG)CONVERTTOINCHES(vert_pels_per_m);
        yaccess=(INT)(sizel.cy-CONVERTTOINCHES(vert_pels_per_m));
        sizel.cy+=(8-(sizel.cy%8));  // Must be multiple of 8's

        ptl.x=4*delta_x;
        ptl.y=6*delta_y;
        MapPt(ptl);
        memset(abImage,0x00,MAX_IMAGE_WIDTH*(MAX_IMAGE_WIDTH/8+1));
        // fill bitmap buffer with appropriate bit to form
        // a CROSS bitmap.
        for (lIndex=0 ;lIndex<=Temp;lIndex++)
            abImage[lIndex*(sizel.cx/8)+(sizel.cx/16)]=(BYTE)(0x40>>(xaccess/2)) ;
        memset(abImage+(Temp/2)*(sizel.cx/8),0xff,(INT)(sizel.cx/8));
        *(abImage+(Temp/2)*(sizel.cx/8)+(sizel.cx/8)-1)=(BYTE)(0xff<<(xaccess));
        if ( GpiMove(hPS,&ptl)==GPI_ERROR) {
        }
        if (GpiSetColor(hPS,CLR_RED)==GPI_ERROR) {   // Set foreground color to RED
        }
        if (GpiImage(hPS, 0L,&sizel, sizel.cx/8*sizel.cy , abImage)==GPI_ERROR) {
        }
        if (GpiSetColor(hPS,CLR_DEFAULT)==GPI_ERROR)   {
        }
        sprintf(ErrorString,"Image Of a Cross  1\" X 1\" Located @ (4\",5\")" );
        ptl.x=2*delta_x;
        ptl.y=5*delta_y-delta_y/3;
        MapAndWriteString(hPS,ptl.x,ptl.y,ErrorString);
        /********************************************************************
         *  Draw a bitmap of a Horizontal line inside one of the grid cells
        *********************************************************************/
        memset (abImage,0x00,MAX_IMAGE_WIDTH);  // Clear bitmap buffer.
        // set appropriate bits to form a horizontal LINE bit map
        sizel.cx=(LONG)CONVERTTOINCHES(hori_pels_per_m);
        sizel.cx+=(8-(sizel.cx%8));  // Must be multiple of 8's
        sizel.cy=1L;
        memset(abImage,0xff,(USHORT)(sizel.cx/8));
        *(abImage+(sizel.cx/8)-1)=(BYTE)(0xff<<xaccess);

        ptl.x=6*delta_x;
        ptl.y=2*delta_y;
        MapPt(ptl);
        if ( GpiMove(hPS,&ptl)==GPI_ERROR) {
        }
        if (GpiSetColor(hPS,CLR_BACKGROUND)==GPI_ERROR){   // Set foreground color to BLUE
        }
        // Draw the bitmap.
        if (GpiImage(hPS, 0L,&sizel, sizel.cx/8*sizel.cy , abImage)==GPI_ERROR) {
           BADERROR("GpiImage()",TRUE,"GpiImagePre");
           return;
        }
        //Always set the foreground color to its default.
        if (GpiSetColor(hPS,CLR_DEFAULT)==GPI_ERROR)   {
        }
        sprintf(ErrorString,"Image Of a Line  1\" X 1\" Pixel Located @ (6\",2\")" );

        ptl.x=0;
        ptl.y=((LONG)4*delta_y/3);
        MapAndWriteString(hPS,ptl.x,ptl.y,ErrorString);

 //TSS...added more description of expected testcase output.
        sprintf(ErrorString,"Grid Line from (6,2) to (7,2) should be is missing due to Image of line." );
        ptl.x=0;
        ptl.y=((LONG)4*delta_y/3-(LONG)delta_y/4);
        MapAndWriteString(hPS,ptl.x,ptl.y,ErrorString);

        DosFreeMem(ImageSel);
        if (lErrorCount) {
           sprintf(ErrorString,"$Errorcount == %ld.\n",lErrorCount);
           CWRITELOG(L_HDR,0,ErrorString);
           CWRITELOG(L_HDR,0,
"$GpiImagePre                                                    -    FAIL.\n");
        }
        else {
           CWRITELOG(L_HDR,0,
"$GpiImagePre                                                    -    PASS.\n");
        }
        CWRITELOG(L_LOTRACE,0,"+ex+ GpiImagePre Precision  Test - Exit Point\n\n\n");
    }
}
/****************************************************************************
 *\\ddd
 * Routine Name: GpiImageApp()
 *
 * Purpose: This function tests the basic functionality of the following
 *          GPI functions:
 *
 *          GpiImage()
 *
 * System Requirements: Section 5.10.2
 *
 * Revision Log: 10/24/90, PDVT, Donna Williams
 *                     - initial creation
 *               11/09/90 ,PDVT ,Mike Abuzant
 *                     -TestCase Design
 *
 * Inputs:  hPS           - presentation space handle
 *          hWndClient  - client window handle
 *          SelectionCall- selection indicator
 *
 * Outputs:
 *
 * Subroutines Required:
 *            GpiImage_test1()  //functionality  Test for GpiImage().
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/

/****************************************************************************
 *\\algorithm
 *   // call  functionality test for GpiImage.
 *
 *   GpiImage_test1( hPS, hWndClient)
 *
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiImageApp(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
   *pBasisX=
   *pBasisY=10000;
  }
  else {
       TEST_SIGNATURE(0,0);
       LOG_SIGNATURE;
       set_delta(hPS);
       // Call functionality test
       GpiImage_test1(hPS,hWndClient);
  }
}
/****************************************************************************
 *\\ddd
 * Routine Name: GpiImage_test1()
 *
 * Purpose:
 *    This function will test the functionality of the GpiImage() function
 *    and see how it would interact and behave with using other GPi and
 *    GRE.Since this Gpi has limited applications, we will tress on how it
 *    behaves in real applications.
 *
 *
 * System Requirements:
 *   None
 *
 * Revision Log:
 *               11/09/90, PDVT , Mike Abuzant
 *               - initial file
 *
 * Inputs:
 *   hPS            // presentation space
 *   hWndClient   // client window handle
 *
 * Outputs:
 *
 * Subroutines Required:
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *      // Setup conditions to test how this Gpi will behave in real
 *         applications.
 *     // For each box to be drawn do ..
 *     // set  coordinates of one  of box corners.
 *         GpiMove(hPS...);
 *     // Change the foreground color
 *        GpiSetColor(hPS..);
 *     // Change the filling pattern
 *        GpiSetPattern(hPS..);
 *    // Set POINT structure to the coordinate of the other box corner.
 *       ptl.x=XXX;
 *       ptl.y=XXX;
 *    // Draw a filled box.
 *       GpiBox(hPS..);
 *    // For each of the bitmaps to drawn do ...
 *     // Change the foregound color
 *       GpiSetColor(hPS...)
 *    // Change the background color
 *       GpiSetBackColor(hPS...);
 *    // change the foreground mix mode
 *       GpiSetMix(hPS..);
 *    //Change the background mix mode
 *       GpiSetBackMix(hPS,....);
 *    // Draw an image
 *       GpiImage(hPS...);
 * }
 *\\end
 ***************************************************************************/
INT GpiImage_test1(HPS hPS, HWND hWndClient)
{
    SIZEL sizel;                           //Size of bitmap in pixels
    CHAR ErrorString[200];
    LONG lSaveID;                          // ID of saved presentation space
    INT color_index=0;                     // color index
    static LONG  colors[]={ CLR_RED,       // Colors that will draw with
                             CLR_PINK,
                             CLR_GREEN,
                             CLR_BLUE,
                             CLR_CYAN,
                             CLR_YELLOW,
                             CLR_BROWN};

    INT back_index=0;                          // Background mix mode index

    static LONG  back_mix[]={ BM_OR,
                              BM_XOR,          //Background mix modes.
                              BM_OVERPAINT};

    static BYTE abImage[]={0x01,0x00,0x01,0x00,
                           0x01,0x00,0x01,0x00,
                           0x01,0x00,0x01,0x00,
                           0x01,0x00,0xff,0xff,
                           0x01,0x00,0x01,0x00,
                           0x01,0x00,0x01,0x00,
                           0x01,0x00,0x01,0x00,
                           0x01,0x00,0x01,0x00};
    INT for_index=0;                              // Forground mix mode index
    static LONG  for_mix[]={ FM_OR,
                             FM_INVERT,         //forground mix modes
                             FM_SUBTRACT,
                             FM_AND,
                             FM_NOTCOPYSRC};
    INT pat_index=0;                      // pattern index
    static LONG  pats[]={ PATSYM_DENSE8,
                          PATSYM_DIAG1,
                          PATSYM_DIAG4,
                          PATSYM_DENSE4};
     POINTL  ptl2;                        //screen coordinate
     LONG lIndex1;                        // long Counter
     LONG lIndex2;                        // long Counter
     LONG lIndex3;                        // long Counter
     LONG lErrorCount=0L;

     CWRITELOG(L_LOTRACE,0,"+ee+ GpiImageApp Application Test - Entry Point\n");
     /*************************************************************
     * Draw some boxes by calling GpiBox(hPS..). Each box will
     * have a different pattern and different color.
     *************************************************************/
     if ((lSaveID=GpiSavePS(hPS))==GPI_ERROR) {   // Save the current PS attributes.
     }
     for (lIndex3=delta_x ;lIndex3 <((pg_size_x*delta_x))  ; lIndex3+=delta_x){
         //Move to the first corner of the Box
         ptl2.y=delta_y;
         ptl2.x=lIndex3;
         MapPt(ptl2);
         if ( GpiMove(hPS,&ptl2)==GPI_ERROR) {
         }
         // Set pattern to use for filling the boxes
         if (GpiSetPattern(hPS,pats[pat_index])==GPI_ERROR) {
            BADERROR("GpiSetPattern()",TRUE,"GpiImageApp");
            return FALSE;
         }
         pat_index=(++pat_index)%(sizeof(pats)/sizeof(pats[0]));
         // Change the foreground color
         if (GpiSetColor(hPS,colors[color_index])==GPI_ERROR) {
         }
         color_index=(++color_index)%(sizeof(colors)/sizeof(colors[0]));
         // supply the other corner of the Box
         ptl2.y=2*delta_y;
         ptl2.x=lIndex3+delta_x;
         MapPt(ptl2);
         // Draw a filled box
         if (GpiBox(hPS,DRO_FILL,&ptl2,0L,0L)==GPI_ERROR) {
            BADERROR("GpiBox",TRUE,"GpiImageApp");
            return FALSE;
         }
     }
     // Restore the presentation space attributes .
     if(GpiRestorePS(hPS,lSaveID)==GPI_ERROR) {
     }

     sprintf(ErrorString,"Images Of Square Boxes 1\" X 1\" Each ");
     ptl2.x = delta_x/2;
     ptl2.y = 4*delta_y/5;
     MapAndWriteString(hPS,ptl2.x,ptl2.y,ErrorString);
     /*********************************************************************
     * The following code segment will draw an bitmap image using
     * the function GpiImage(hPS..). each bitmap will be drawn with
     * a different color, backgorund mix ,foreground mix, background color,
     * and foreground. We are testing how will GpiImage() will
     * interact and behave with other GPi function calles.
     **********************************************************************/
     sizel.cx=
     sizel.cy=16L;
     for (lIndex2=3*delta_y ;lIndex2 <(pg_size_y*delta_y) ;
          lIndex2+=(LONG)PIXELSPERUNIT(sizel.cy,delta_y,vert_pels_per_m)){
        if ((lSaveID=GpiSavePS(hPS))==GPI_ERROR) {    // Save the current PS attributes.
        }
        // Change current foreground color
        if(GpiSetColor(hPS,colors[color_index])==GPI_ERROR) {
        }
        color_index=(++color_index)%(sizeof(colors)/sizeof(colors[0]));
        for (lIndex1=delta_x ;lIndex1 <(pg_size_x*delta_x) ;
             lIndex1+=(LONG)PIXELSPERUNIT(sizel.cx,delta_x,hori_pels_per_m)){
           ptl2.x=lIndex1;
           ptl2.y=lIndex2;
           MapPt(ptl2);
           if ( GpiMove(hPS,&ptl2)==GPI_ERROR) {
           }
           // Now draw the bitmap . GpiImage(hPS...)
           if (GpiImage(hPS, 0L,&sizel, (LONG)sizeof(abImage) , abImage)==GPI_ERROR) {
              BADERROR("GpiImage()",TRUE,"GpiImageApp");
              return FALSE;
           }
        }
        // Restore the original PS attributes.
        if (GpiRestorePS(hPS,lSaveID)==GPI_ERROR) {
        }
     }
     sprintf(ErrorString,"\t Above image is composed of 16 X 16 Pixel bitmaps. \t");
     //Always set the foreground color to its default.
     ptl2.x = delta_x;
     ptl2.y = 5*delta_y/2;
     MapAndWriteString(hPS,ptl2.x,ptl2.y,ErrorString);
     if (lErrorCount) {
        sprintf(ErrorString,"$Errorcount == %ld.\n",lErrorCount);
        CWRITELOG(L_HDR,0,ErrorString);
        CWRITELOG(L_HDR,0,
"$GpiImageApp                                                    -    FAIL.\n");
     }
     else {
        CWRITELOG(L_HDR,0,
"$GpiImageApp                                                    -    PASS.\n");
     }
     CWRITELOG(L_LOTRACE,0,"+ex+ GpiImageApp Application Test - Exit Point\n\n\n");
     return TRUE;
}
/****************************************************************************
 *\\ddd
 * Routine Name: GpiImageExh()
 *
 * Purpose:  This function Exhaustively tests the GpiImage() for
 *           correctness in operating.
 *
 *
 * System Requirements: Section 5.10.3
 *
 * Revision Log: 10/24/90, PDVT, Donna Williams
 *                     - initial creation
 *               11/09/90 ,PDVT , Mike Abuzant
 *                     -TestCase Design
 *               11/20/90 ,PDVT ,Mike Abuzant
 *                     -Coded this function.
 *
 *
 * Inputs:  hPS           - presentation space handle
 *          hWndClient  - client window handle
 *          SelectionCall- selection indicator
 *
 * Outputs:
 *
 * Subroutines Required:
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 *  // setup conditions to draw an bitmap that has horizontal stripes in it
 *     memset(abImage ....);
 *  // Move the screen coordinates  where to begin placing bit map
 *    GpiImage(hPS...);
 *  //  Draw the bitmap using GpiImage().
 *    GpiImage(hPS..);
 *  // setup conditions to  draw an bitmap that has Vertical stripes in it
 *     memset(abImage ....);
 *  // Move the screen coordinates  where to begin placing bit map
 *    GpiImage(hPS...);
 *  //  Draw the bitmap using GpiImage().
 *    GpiImage(hPS..);
 *  // setup conditions to draw an bitmap that has every other bit
 *     turned OFF
 *    memset(abImage ....);
 *    // draw the same bitmap 30 times at the same location .
 *    // This should produce the same results as drawing the
 *    // bitmap once.
 *    for (index=0 .....){
 *  // Move the screen coordinates  where to begin placing bit map
 *    GpiImage(hPS...);
 *      //  Draw the bitmap using GpiImage().
 *       GpiImage(hPS..);
 *    }
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiImageExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
    POINTL      ptl;                            // Screen coordinates
    SIZEL       sizel;                           //Size of bitmap in pixels
    CHAR        ErrorString[200];                 // screen message output string
    LONG        lIndex1;                        // long Counter
    LONG        lIndex2;                        // long Counter
    PBYTE       abImage;
    LONG        lErrorCount=0L;
    INT         xaccess;
    INT         yaccess;
    LONG        Temp;
    INT         color_index=0;

#define CAT_WIDTH  32
#define CAT_HEIGHT 32
    static BYTE abCat[]={
                        0x01,0xf8,0x1f,0x80,0x01,0x04,0x20,0x80,
                        0x00,0x8f,0xf1,0x00,0x00,0x48,0x12,0x00,
                        0x00,0x28,0x14,0x00,0x00,0x1a,0x58,0x00,
                        0x00,0x08,0x10,0x00,0x00,0xfc,0x3f,0x00,

                        0x00,0x09,0x90,0x00,0x00,0xfc,0x3f,0x00,
                        0x00,0x08,0x10,0x00,0x00,0x07,0xe0,0x00,
                        0x00,0x08,0x10,0xc0,0x00,0x08,0x10,0x00,
                        0x00,0x08,0x10,0x10,0x00,0x10,0x08,0x20,

                        0x00,0x10,0x08,0x04,0x00,0x10,0x08,0x08,
                        0x00,0x20,0x04,0x04,0x00,0x20,0x04,0x04,
                        0x00,0x20,0x04,0x04,0x00,0x40,0x02,0x04,
                        0x00,0x40,0x02,0x04,0x00,0x40,0x02,0x04,

                        0x00,0xc0,0x03,0x08,0x00,0x9c,0x39,0x04,
                        0x00,0xa2,0x45,0x10,0x00,0xa2,0x45,0x08,
                        0x00,0xa2,0x45,0x00,0x00,0xa2,0x45,0xe0,
                        0x00,0xa2,0x45,0x00,0x00,0xff,0xff,0x00};

 static LONG  colors[]={ CLR_RED,       // Colors that will draw with
                         CLR_PINK,
                         CLR_GREEN,
                         CLR_BLUE,
                         CLR_CYAN,
                         CLR_YELLOW,
                         CLR_BROWN};


  if (SelectionCall) {
     WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
     *pBasisX=
     *pBasisY=10000;
  }
  else {
       TEST_SIGNATURE(0,0);
       LOG_SIGNATURE;
       set_delta(hPS);
       CWRITELOG(L_LOTRACE,0,"+ee+ GpiImageExh Exhaustive  Test- Entry Point\n");
       //Allocate a 64K segment.
       DosAllocMem((PVOID)&abImage, 65536L, PAG_READ | PAG_WRITE  | PAG_COMMIT);


       /**************************************************************
        * The following code segment will draw an bitmap image using
        * the function GpiImage(hPS..).
        **************************************************************/
       sizel.cx=(LONG)CONVERTTOINCHES(hori_pels_per_m);
       sizel.cx+=(8-(sizel.cx%8));  // Must be multiple of 8's
       xaccess=(INT)(sizel.cx-CONVERTTOINCHES(hori_pels_per_m));
       Temp=
       sizel.cy=(LONG)CONVERTTOINCHES(vert_pels_per_m);
       yaccess=(INT)(sizel.cy-CONVERTTOINCHES(vert_pels_per_m));
       sizel.cy+=(8-(sizel.cy%8));  // Must be multiple of 8's

       memset(abImage,0x00,MAX_IMAGE_WIDTH*(MAX_IMAGE_WIDTH/8+1));

       ptl.x=2*delta_x;
       ptl.y=2*delta_y;
       MapPt(ptl);


       for (lIndex2=0;lIndex2 <sizel.cy  ; lIndex2+=2)
           memset(abImage+lIndex2*(sizel.cx/8),0xFF ,(USHORT)(sizel.cx/8));

       GpiMove(hPS,&ptl);
       if (GpiImage(hPS, 0L, &sizel, (LONG) sizel.cx*sizel.cy/8, abImage)==GPI_ERROR) {
          BADERROR("GpiImage()",TRUE,"GpiImageExh");
          return;
       }

       sprintf(ErrorString,"1\" X 1\" Image  Located @  (2\",2\")");

       ptl.x=delta_x;
       ptl.y=4*delta_y/5;
       MapAndWriteString(hPS,ptl.x,ptl.y,ErrorString);
       memset(abImage,0x00,MAX_IMAGE_WIDTH*(MAX_IMAGE_WIDTH/8+1));
       ptl.x=(pg_size_x*delta_x)-(3*delta_x);
       ptl.y=3*delta_y;
       MapPt(ptl);
       for (lIndex2=0;lIndex2 <sizel.cy   ; lIndex2++)
            memset(abImage+lIndex2*(sizel.cx/8),0xAA ,(USHORT)(sizel.cx/8));
       if ( GpiMove(hPS,&ptl)==GPI_ERROR) {
       }
       if (GpiImage(hPS, 0L,&sizel, (LONG) sizel.cx*sizel.cy/8, abImage)==GPI_ERROR) {
           BADERROR("GpiImage()",TRUE,"GpiImageExh");
           return;
       }
       sprintf(ErrorString,"1\" X 1\" Image  Located @ (%d\",3\")",
                            pg_size_x-3);
       ptl.x=(pg_size_x*delta_x)-(4*delta_x);
       ptl.y=4*delta_y/3;
       MapAndWriteString(hPS,ptl.x,ptl.y,ErrorString);
       memset(abImage,0x00,MAX_IMAGE_WIDTH*(MAX_IMAGE_WIDTH/8+1));
       ptl.x=(pg_size_x*delta_x)-(2*delta_x);
       ptl.y=(pg_size_y*delta_y)-(2*delta_y);
       MapPt(ptl);
       for (lIndex2=0;lIndex2 <sizel.cy; lIndex2+=8)
            memset(abImage+lIndex2*(sizel.cx/8),0x80 ,(USHORT)(sizel.cx/8));
       for (lIndex1=0;lIndex1<30   ; lIndex1++){
           if ( GpiMove(hPS,&ptl)==GPI_ERROR) {
           }
           if (GpiImage(hPS, 0L,&sizel, (LONG) sizel.cx*sizel.cy/8, abImage)==GPI_ERROR) {
               BADERROR("GpiImage()",TRUE,"GpiImageExh");
               return;
           }
       }
       ptl.x=(pg_size_x*delta_x)-(3*delta_x);
       ptl.y=(pg_size_y*delta_y)-(10*delta_y/3);
       strcpy(ErrorString,"Above Image is Drawn ");
       MapAndWriteString(hPS,ptl.x,ptl.y,ErrorString);
       ptl.x=(pg_size_x*delta_x)-(3*delta_x);
       ptl.y=(pg_size_y*delta_y)-(11*delta_y/3);
       strcpy(ErrorString,"30 Times on Top of Each Other");
       MapAndWriteString(hPS,ptl.x,ptl.y,ErrorString);
       /**********************************************************
        * This segment will draw an image of bitmap cat.
        **********************************************************/

       sizel.cx=CAT_WIDTH;
       sizel.cy=CAT_HEIGHT;

       if (GpiSetColor(hPS,CLR_BLUE)==GPI_ERROR) {
       }
       for (lIndex2=3*delta_y ;lIndex2 < (pg_size_y*delta_y);
            lIndex2+=(LONG)PIXELSPERUNIT((sizel.cy+10),delta_y,vert_pels_per_m)){
           for (lIndex1=0 ;lIndex1 <((pg_size_x*delta_x)-(14*delta_x/4)) ;
                lIndex1+=(LONG)PIXELSPERUNIT(sizel.cx,delta_x,hori_pels_per_m)){
               ptl.x=lIndex1;
               ptl.y=lIndex2;
               MapPt(ptl);

               // Change the foreground color
               if (GpiSetColor(hPS,colors[color_index])==GPI_ERROR) {
               }
               color_index=(++color_index)%(sizeof(colors)/sizeof(colors[0]));

               if ( GpiMove(hPS,&ptl)==GPI_ERROR) {
               }
               // Now draw the bitmap . GpiImage(hPS...)
               if (GpiImage(hPS, 0L,&sizel, (LONG)sizeof(abCat) , abCat)==GPI_ERROR) {
                   BADERROR("GpiImage()",TRUE,"GpiImageExh");
                   return;
               }
           }
       }

       sprintf(ErrorString,"Above is a Bitmap Of a Cat %d X %d Pixels",
                            CAT_WIDTH,CAT_HEIGHT);

       if (GpiSetColor(hPS,CLR_DEFAULT)==GPI_ERROR) {
       }

       ptl.x=delta_x/2;
       ptl.y=3*delta_y-(2*delta_y/3);
       MapAndWriteString(hPS,ptl.x,ptl.y,ErrorString);

       DosFreeMem(abImage);

       if (lErrorCount) {
           sprintf(ErrorString,"$Errorcount == %ld.\n",lErrorCount);
           CWRITELOG(L_HDR,0,ErrorString);
           CWRITELOG(L_HDR,0,
"$GpiImagePre                                                    -    FAIL.\n");
       }
       else {
           CWRITELOG(L_HDR,0,
"$GpiImagePre                                                    -    PASS.\n");
        }
       CWRITELOG(L_LOTRACE,0,"+ex+ GpiImageExh Exhaustive  Test- Exit Point\n");
   }
}

