#ifndef GPIFONT_H
#define GPIFONT_H
/*****************************************************************************
 *\\ddd
 * Subtask Name: PDVT
 *
 * Module Name: GPIFONT
 *
 * Purpose: Include file for GPIFONT.DLL
 *
 *  $header$
 *
 * Revision Log: 10/25/90, PDVT, Gisselle Labault
 *                 - created initial file
 *               12/17/90, PDVT, Mike Abuzant
 *                 - Added function prototypes
 *                 - Deleted 'hAB' parameter.
 *               12/28/90, PDVT, Darin C. Hafer
 *                 - Adjust from GRETXTST.H
 *
 * SRS References:
 *
 * Contents:  This file contains the following definitions:
 *              - function prototypes
 *                        - define's specific to GPIFONT
 *
 * Limitations:
 *           none
 *\\end
 *****************************************************************************/



/*---------------------- Declare all dll functions -----------------------*/
//

static INT MyCompareFunction(const VOID * , const VOID *);
VOID  APIENTRY InitTest(PVOID sel, PTESTINITINFO pInitInfo);
VOID  APIENTRY GpiFontApp1(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID  APIENTRY GpiFontApp2(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID  APIENTRY GpiQueryFontFileDescriptionsExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID  APIENTRY GpiQueryFontMetricsExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID  APIENTRY GpiQueryFontsExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID  APIENTRY GpiCreateLogFontExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID  APIENTRY GpiQueryKerningPairsExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID  APIENTRY GpiSetAndQueryCpExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID  APIENTRY GpiSetAndQueryCharSetExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID  APIENTRY GpiQueryNumberSetIdsExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID  APIENTRY GpiDeleteSetIdExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID  APIENTRY GpiQueryWidthTableExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID  APIENTRY GpiLoadFontsExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID  APIENTRY GpiUnloadFontsExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
/*------------------------------------------------------------------------*/

/*---------------------- Declare all dll subroutines ---------------------*/
BOOL FaceList(HPS hPS, HWND hWndClient, LONG Enum, POINTL *pptl,
              LONG syPosition, LONG Number, PTEMPTYPE *FontStorage);
LONG PrintFonts(HPS hPS, HWND hWndClient, POINTL *pptl);
/*------------------------------------------------------------------------*/

#define USER_LCID 1L
#define NUMLINES  (sizeof(devcaps) / sizeof(devcaps[0]))

#define TOKENIZEFUNCTIONNAME(FunctionName) {#FunctionName,FunctionName}

static  NAMES_AND_ADDRESSES EntryPointList[]=
    {
        TOKENIZEFUNCTIONNAME(GpiFontApp1),
        TOKENIZEFUNCTIONNAME(GpiFontApp2),
        TOKENIZEFUNCTIONNAME(GpiQueryFontFileDescriptionsExh),
        TOKENIZEFUNCTIONNAME(GpiQueryFontMetricsExh         ),
        TOKENIZEFUNCTIONNAME(GpiQueryFontsExh               ),
        TOKENIZEFUNCTIONNAME(GpiCreateLogFontExh            ),
        TOKENIZEFUNCTIONNAME(GpiQueryKerningPairsExh        ),
        TOKENIZEFUNCTIONNAME(GpiSetAndQueryCpExh            ),
        TOKENIZEFUNCTIONNAME(GpiSetAndQueryCharSetExh       ),
        TOKENIZEFUNCTIONNAME(GpiQueryNumberSetIdsExh        ),
        TOKENIZEFUNCTIONNAME(GpiDeleteSetIdExh              ),
        TOKENIZEFUNCTIONNAME(GpiQueryWidthTableExh          ),
        TOKENIZEFUNCTIONNAME(GpiLoadFontsExh                ),
        TOKENIZEFUNCTIONNAME(GpiUnloadFontsExh              ),
    };

#ifdef MAINSOURCEFILE

struct {
    LONG  lIndex;
    CHAR  *szIdentifier;
  }
  devcaps[] =
  {
    CAPS_FAMILY                       , "CAPS_FAMILY",
    CAPS_IO_CAPS                      , "CAPS_IO_CAPS",
    CAPS_TECHNOLOGY                   , "CAPS_TECHNOLOGY",
    CAPS_DRIVER_VERSION               , "CAPS_DRIVER_VERSION",
    CAPS_HEIGHT                       , "CAPS_HEIGHT",
    CAPS_WIDTH                        , "CAPS_WIDTH",
    CAPS_HEIGHT_IN_CHARS              , "CAPS_HEIGHT_IN_CHARS",
    CAPS_WIDTH_IN_CHARS               , "CAPS_WIDTH_IN_CHARS",
    CAPS_VERTICAL_RESOLUTION          , "CAPS_VERTICAL_RESOLUTION",
    CAPS_HORIZONTAL_RESOLUTION        , "CAPS_HORIZONTAL_RESOLUTION",
    CAPS_CHAR_HEIGHT                  , "CAPS_CHAR_HEIGHT",
    CAPS_CHAR_WIDTH                   , "CAPS_CHAR_WIDTH",
    CAPS_SMALL_CHAR_HEIGHT            , "CAPS_SMALL_CHAR_HEIGHT",
    CAPS_SMALL_CHAR_WIDTH             , "CAPS_SMALL_CHAR_WIDTH",
    CAPS_COLORS                       , "CAPS_COLORS",
    CAPS_COLOR_PLANES                 , "CAPS_COLOR_PLANES",
    CAPS_COLOR_BITCOUNT               , "CAPS_COLOR_BITCOUNT",
    CAPS_COLOR_TABLE_SUPPORT          , "CAPS_COLOR_TABLE_SUPPORT",
    CAPS_MOUSE_BUTTONS                , "CAPS_MOUSE_BUTTONS",
    CAPS_FOREGROUND_MIX_SUPPORT       , "CAPS_FOREGROUND_MIX_SUPPORT",
    CAPS_BACKGROUND_MIX_SUPPORT       , "CAPS_BACKGROUND_MIX_SUPPORT",
    CAPS_VIO_LOADABLE_FONTS           , "CAPS_VIO_LOADABLE_FONTS",
    CAPS_WINDOW_BYTE_ALIGNMENT        , "CAPS_WINDOW_BYTE_ALIGNMENT",
    CAPS_BITMAP_FORMATS               , "CAPS_BITMAP_FORMATS",
    CAPS_RASTER_CAPS                  , "CAPS_RASTER_CAPS",
    CAPS_MARKER_HEIGHT                , "CAPS_MARKER_HEIGHT",
    CAPS_MARKER_WIDTH                 , "CAPS_MARKER_WIDTH",
    CAPS_DEVICE_FONTS                 , "CAPS_DEVICE_FONTS",
    CAPS_GRAPHICS_SUBSET              , "CAPS_GRAPHICS_SUBSET",
    CAPS_GRAPHICS_VERSION             , "CAPS_GRAPHICS_VERSION",
    CAPS_GRAPHICS_VECTOR_SUBSET       , "CAPS_GRAPHICS_VECTOR_SUBSET",
    CAPS_DEVICE_WINDOWING             , "CAPS_DEVICE_WINDOWING",
    CAPS_ADDITIONAL_GRAPHICS          , "CAPS_ADDITIONAL_GRAPHICS",
    CAPS_PHYS_COLORS                  , "CAPS_PHYS_COLORS",
    CAPS_COLOR_INDEX                  , "CAPS_COLOR_INDEX",
    CAPS_GRAPHICS_CHAR_WIDTH          , "CAPS_GRAPHICS_CHAR_WIDTH",
    CAPS_GRAPHICS_CHAR_HEIGHT         , "CAPS_GRAPHICS_CHAR_HEIGHT",
    CAPS_HORIZONTAL_FONT_RES          , "CAPS_HORIZONTAL_FONT_RES",
    CAPS_VERTICAL_FONT_RES            , "CAPS_VERTICAL_FONT_RES",
  };

struct {
    CHAR *szMetric;
  }
  FontMets[] =
  {
    "IDRegistry"         ,
    "CodePage"           ,
    "EmHeight"           ,
    "XHeight"            ,
    "MaxAscender"        ,
    "MaxDescender"       ,
    "LowerCaseAscent"    ,
    "LowerCaseDescent"   ,
    "InternalLeading"    ,
    "ExternalLeading"    ,
    "AveCharWidth"       ,
    "MaxCharInc"         ,
    "EmInc"              ,
    "MaxBaselineExt"     ,
    "CharSlope"          ,
    "InlineDir"          ,
    "CharRot"            ,
    "WeightClass"        ,
    "WidthClass"         ,
    "XDeviceRes"         ,
    "YDeviceRes"         ,
    "FirstChar"          ,
    "LastChar"           ,
    "DefaultChar"        ,
    "BreakChar"          ,
    "NominalPointSize"   ,
    "MinimumPointSize"   ,
    "MaximumPointSize"   ,
    "FSType"             ,
    "FSDefn"             ,
    "FSSelection"        ,
    "FSCapabilities"     ,
    "SubscriptXSize"     ,
    "SubscriptYSize"     ,
    "SubscriptXOffset"   ,
    "SubscriptYOffset"   ,
    "SuperscriptXSize"   ,
    "SuperscriptYSize"   ,
    "SuperscriptXOffset" ,
    "SuperscriptYOffset" ,
    "UnderscoreSize"     ,
    "UnderscorePosition" ,
    "StrikeoutSize"      ,
    "StrikeoutPosition"  ,
    "KerningPairs"       ,
    "FamilyClass"        ,
    "Match"              ,
   };

USHORT Offset[] = {0,32,
                   64,66,
                   68,72,76,80,84,88,92,96,100,104,108,112,116,
                   118,120,122,124,126,128,130,132,134,
                   136,138,140,142,144,146,148,150,152,
                   156,160,164,168,172,176,180,184,188,192,196,200,
                   202,204,208};

PCHAR  TestCaseName = "GpiFont";
CHAR   achLogLine[100];
POINTL ptl;
BOOL   bSuccess;
LONG   lSuccess;
LONG   ErrorCount=0L;

#else
   extern CHAR   achLogLine[];
   extern POINTL ptl;
   extern BOOL   bSuccess;
   extern LONG   lSuccess;
   extern LONG   ErrorCount;
#endif


#endif
