/************************************************************************/
/* Module name: PTTDLLDF.H                                              */
/*                                                                      */
/* Purpose: This header file contains all the global constants,         */
/*          variables, typedefs, and function prototypes for the        */
/*          test case DLLs.                                             */
/************************************************************************/
#define INCL_32
#include "ptt_dll.h" // include the common include file (between PTT & tests)

// function declaration for InitTest and test case entry point

#ifdef INCL_32
    VOID APIENTRY InitTest(PVOID sel, PTESTINITINFO pInitInfo);
#else
    VOID APIENTRY InitTest(USHORT sel, PTESTINITINFO pInitInfo);
#endif

/*****************************************************************************
* The following MAP macros can be used by test cases to print independently  *
* of the presentation space units used.  The test case must define the       *
* variables BasisX and BasisY which define the size in generic units of the  *
* surface the test case writer wants to draw on.  For example, a test case   *
* writer could decide to write units between 0 and 100 to write to a device  *
* context that is actually 640 by 480.  By setting BasisX and BasisY to 100, *
* the user could use the MapX and MapY macros to covert points from 0 to 100 *
* units to 640 by 480 units.  He could do the same for ARCPARAM variables    *
* using the MapArc macro, etc.                                               *
*****************************************************************************/

// Variables that make this mapping stuff work

extern LONG *pDimX, *pDimY, *pBasisX, *pBasisY, *alDevCaps;


// Pointer to the HAB of the Print Thread

extern PHAB phabPThread;


#define MapX(n) ((*pBasisX!=*pDimX)?(((((n) * 10000L) / *pBasisX) * (*pDimX)) / 10000L):(n))
#define MapY(n) ((*pBasisY!=*pDimY)?(((((n) * 10000L) / *pBasisY) * (*pDimY)) / 10000L):(n))

#define MapPt(pt) ((pt).x= MapX( (pt).x ), (pt).y= MapY( (pt).y ))
#define MapSz(pt) ((pt).cx= MapX( (pt).cx ), (pt).cy= MapY( (pt).cy ))
#define MapRect(rect) ((rect).xLeft=MapX((rect).xLeft), \
           (rect).yBottom=MapY((rect).yBottom), \
           (rect).xRight= MapX((rect).xRight), \
           (rect).yTop= MapY((rect).yTop))

#define MapArc(arc) ((arc).lR=MapX((arc).lR), \
           (arc).lQ=MapY((arc).lQ), \
           (arc).lP= MapX((arc).lP), \
           (arc).lS= MapY((arc).lS))

#define MapPX(n) ((*pDimX!=alDevCaps[CAPS_WIDTH])?(((((n) * 10000L) / (*pDimX)) * alDevCaps[CAPS_WIDTH]) / 10000L):(n))
#define MapPY(n) ((*pDimY!=alDevCaps[CAPS_HEIGHT])?(((((n) * 10000L) / (*pDimY)) * alDevCaps[CAPS_HEIGHT]) / 10000L):(n))
#define MapPtP(pt) ((pt).x= MapPX( (pt).x ), (pt).y= MapPY( (pt).y ))

#define MapRectP(rect) ((rect).xLeft=MapPX((rect).xLeft), \
           (rect).yBottom=MapPY((rect).yBottom), \
           (rect).xRight= MapPX((rect).xRight), \
           (rect).yTop= MapPY((rect).yTop))

/* return a mapped number in it's original form */
#define UnMapX(n) ((*pBasisX!=(*pDimX))?(((((n) * 1000L) / (*pDimX)) * *pBasisX) / 1000L):(n))
#define UnMapY(n) ((*pBasisY!=(*pDimY))?(((((n) * 1000L) / (*pDimY)) * *pBasisY) / 1000L):(n))

/* show the mapping equation for verification */
#define SeeMapX(old,new) \
        (LONG)(old), \
        (LONG)*pBasisX,(LONG)(*pDimX),(LONG)new);

#define SeeMapY(old,new) \
        (LONG)(old), \
        (LONG)*pBasisY,(LONG)(*pDimY),(LONG)(new));


/*****************************************************************************
* The following is a macro to simplify the Test Signature interface for      *
* the test case.  This macro will tell PTT to print the current information  *
* (ie, test case name, print driver, etc) to the output device.              *
*****************************************************************************/

#define TEST_SIGNATURE(X,Y) \
        WinSendMsg(hWndClient, \
                   WM_TEST_SIGNATURE, \
                   MPFROMLONG(hPS), \
                   MPFROM2SHORT(MapX(X),MapY(Y)))



/*****************************************************************************
* The following is a macro to simplify the Log Signature interface for       *
* the test case.  This macro will tell PTT to print the current information  *
* (ie, test case name, print driver, etc) to the log file.                   *
*****************************************************************************/

#define LOG_SIGNATURE \
        WinSendMsg(hWndClient, \
                   WM_LOG_SIGNATURE, \
                   NULL,NULL)


/*****************************************************************************
* This macro is used by the test case to log information to the log file.    *
* The format for the CWRITELOG statement is                                  *
*                                                                            *
*           CWRITELOG(level,return_code,"string \n");                        *
*                                                                            *
*     level -- any one of the following logging levels,                      *
*              L_HDR     = 1                                                 *
*              L_ABORT   = 2                                                 *
*              L_FAIL    = 4                                                 *
*              L_WARN    = 6                                                 *
*              L_TRACE   = 7                                                 *
*              L_LOTRACE = 8                                                 *
*              L_DEBUG   = 9                                                 *
*                                                                            *
*     return_code -- an integer value the user specifies                     *
*     "string \n" -- the message to log; if the user wants to log a message  *
*                    containing variables (ie, printf("var1 = %d",var1)),    *
*                    then an sprintf function call should be made to create  *
*                    a formatted string to pass to the CWRITELOG command.    *
*                                                                            *
*****************************************************************************/

#define CWRITELOG(X,Y,Z) \
        WinSendMsg(hWndClient, \
                   WM_TEST_LOG, \
                   MPFROM2SHORT(X,Y), \
                   MPFROMLONG(Z))

/*****************************************************************************
* Create function declarations for every function defined in PTTDLLVR the    *
* user needs access to.                                                      *
*****************************************************************************/

// Give each test case access to variable required to interface with
// external function declarations

#ifdef INCL_32
    extern VOID InitTestSegVars (PVOID selSeg);
#else
    extern VOID InitTestSegVars (USHORT selSeg);
#endif

// The following subroutines are designed to be called only via the
// macros CHECKRETURNERROR and REPORTSETUPERROR.  The macros facilitate
// the use of the subroutines taking care of passing the window handle
// and __FILE__, and __LINE__.  VerifyReturnedErrorCode is designed to
// be called by tests verifying API return codes.  It verifies that the
// PMERR error code returned matches that passed in ExpErrorid and
// usExpSev.  It logs all errors at the appropriate error levels.
// The function returns a 1 if it fails and a 0 if it passes.  Calling
// programs can use this value to add to counters that keep track of the
// number of error found in the test case.  ReportSetupError reports
// an error detected by API calls that were not intended to fail.  It
// should be included after all API calls to report API unexpected API
// failures.

extern SHORT VerifyReturnedErrorCode(HWND hWndClient, LONG ReturnCode,
                                     CHAR *szTestName, USHORT usExpSev,
                                     USHORT ExpErrorid, PSZ szFileName,
                                     USHORT usLineNo);

extern SHORT VerifyReturnCode(HWND hWndClient, LONG ReturnCode,
                              CHAR *szTestName, USHORT usExpSev,
                              USHORT usExpErrorid, PSZ szFileName,
                              USHORT usLineNo);

extern VOID ReportSetupError (HWND hWndClient, CHAR *pCallName,
                              PSZ szFileName, USHORT usLineNo);

#define CHECKRETURNERROR(APIRETCODE,TESTNAME,SEV,ERRID) \
           (LONG) VerifyReturnedErrorCode(hWndClient,(LONG) APIRETCODE, \
                TESTNAME, (USHORT) SEV, (USHORT) ERRID,__FILE__,__LINE__)

#define REPORTSETUPERROR(PCALLNAME) \
                ReportSetupError (hWndClient, PCALLNAME, __FILE__,__LINE__)


/*****************************************************************************
* Define routines that can be used by test cases to create a PMERR_PS_BUSY   *
* condition.  To create the busy condition, call the MakePSBusy routine      *
* and follow the call up with the call you want to test.                     *
*****************************************************************************/

BOOL  MakePSBusy(HWND hWndClient, HPS hps);
BOOL  FreePS(HWND hWndClient);

#define MAKEPSBUSY(HPS)  MakePSBusy(hWndClient, HPS)
#define FREEPS FreePS(hWndClient)
