PROJ = gpielmnt
CC = icc

#  /W3           - Warns of all non-ANSI usage
#  /G3           - Generate 80486 code
#  /DLINT_ARGS   - Check functional arguments against prototypes
#  /Sp           - Packs Structure
#  /Ti+          - Generates all debugger information
#  /Sm           - Allow all C Set/2 extensions including those for migration
#  /O+           - Optimize object code
#  /Gs+          - Stack checking
#  /Ge           - Build .EXE file
#  /Ss           - Allow for the // comments

CFLAGS  = /Ge- /Ti+ /O- /Oi- /Os- /Oc- /W3 /G3 /DLINT_ARGS /Sp /Sm /Gm+ /Gd+ /Gs+ /Ss

#
#  The following is to use the new libraries for Visual Age C/C++
#
LLIBS    = CPPOM30.LIB + OS2386.LIB

LFLAGS   =  /DE /CODEVIEW /STACK:64000 /NOD /ALIGN:16 /PACKC /PACKD /M /BASE:0x10000 

ICLCPPOPTS=/GM+ /GD+ /DIC_TRACE_ALL /DIC_DEVELOP /B" /PM:PM"

IMPLIB = implib/NOIGNORECASE

EXECFLAGS= $(ICLCPPOPTS)
EXELFLAGS=/B" /PM:PM"

MAPFILE  = gpielmnt.map
# LINKER   = link386
# old linker... the new linker is ilink
LINKER   = ilink
LRF      = echo > NUL
RC       = rc
DEF_FILE = gpielmnt.DEF

OBJS  = gpielmnt.obj \
        common1.obj   common2.obj \
        pttdllvr.obj

.dll.lib:
        $(IMPLIB) $*.lib $*.dll

compile = $(CC) /c $(CFLAGS)

all: $(PROJ).dll

.SUFFIXES:
.SUFFIXES: .sbr .obj .res .c .rc


gpielmnt.obj:   gpielmnt.c gpielmnt.h common1.h common2.h PTTdlldf.h
   $(compile) /Fo$@ gpielmnt.c

common1.obj:    common1.c   common1.h
   $(compile) /Fo$@ common1.c

common2.obj:    common2.c  common2.h
   $(compile) /Fo$@ common2.c

pttdllvr.obj:   pttdllvr.c pttdlldf.h
   $(compile) /Fo$@ pttdllvr.c

gpielmnt.dll: $(OBJS)
      $(LINKER) /nofree $(LFLAGS) \
          $(OBJS),gpielmnt.dll,gpielmnt.map,$(LLIBS),gpielmnt.def

