#ifndef GPIELMNT_H
#define GPIELMNT_H
/*****************************************************************************
 *\\ddd
 * Subtask Name: GREAT
 *
 * Module Name: ELEMNTST
 *
 * Purpose: Include file for ELEMNTST dll.
 *
 *  $header$
 *
 * Revision Log: 09/03/91, GREAT, Stanley Logan
 *               - created initial template
 *
 * SRS References: Section 6.4
 *
 * Contents:  This file contains the following definitions:
 *              - function prototypes
 *                                       - defines specific to ELEMNTST
 *
 * Limitations:
 *           none
 *\\end
 *****************************************************************************/



/* declare all dll functions */
VOID  APIENTRY InitTest(PVOID sel, PTESTINITINFO pInitInfo);

VOID  APIENTRY GpiElementTestApp1(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID  APIENTRY GpiElementTestApp2(HPS hPS,HWND hWndClient,BOOL SelectionCall);

VOID  APIENTRY GpiBeginAndEndElementExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID  APIENTRY GpiDeleteElementExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID  APIENTRY GpiDeleteElementRangeExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID  APIENTRY GpiDeleteElmntsBetweenLabelsExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID  APIENTRY GpiElementAndQryExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID  APIENTRY GpiGetAndPutDataExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID  APIENTRY GpiLabelAndSetElmtPtrAtLabelExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID  APIENTRY GpiOffsetElementPointerExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID  APIENTRY GpiQueryElementTypeExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID  APIENTRY GpiSetAndQryEditModeExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID  APIENTRY GpiSetAndQryElementPointerExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);


VOID DrawPyramid(HPS, double, HWND, LONG *, PCHAR);
VOID DrawLevel(HPS, double, double, HWND, LONG *, PCHAR);

USHORT   Max_Box_Level;
LONG     ElementBufferSize;
CHAR     LogText[250];
double  TopX,
         TopY;
PBYTE    pbData;

static CHAR * TestCaseName = "GpiElmnt";

static  NAMES_AND_ADDRESSES EntryPointList[]=
    {
        TOKENIZEFUNCTIONNAME(GpiElementTestApp1),
        TOKENIZEFUNCTIONNAME(GpiElementTestApp2),

        TOKENIZEFUNCTIONNAME(GpiBeginAndEndElementExh),
        TOKENIZEFUNCTIONNAME(GpiDeleteElementExh),
        TOKENIZEFUNCTIONNAME(GpiDeleteElementRangeExh),
        TOKENIZEFUNCTIONNAME(GpiDeleteElmntsBetweenLabelsExh),
        TOKENIZEFUNCTIONNAME(GpiElementAndQryExh),
        TOKENIZEFUNCTIONNAME(GpiGetAndPutDataExh),
        TOKENIZEFUNCTIONNAME(GpiLabelAndSetElmtPtrAtLabelExh),
        TOKENIZEFUNCTIONNAME(GpiOffsetElementPointerExh),
        TOKENIZEFUNCTIONNAME(GpiQueryElementTypeExh),
        TOKENIZEFUNCTIONNAME(GpiSetAndQryEditModeExh),
        TOKENIZEFUNCTIONNAME(GpiSetAndQryElementPointerExh),

    };

#define min(a,b) (((a) < (b)) ? (a) : (b))

#define DrwPyramid(scale)                                                                                                                                       \
        DrawPyramid(hPS, scale, hWndClient, &ErrorCount, EntryName)

#define DrwLevel(level)                                                                                                                                         \
        DrawLevel(hPS, level, Scale, hWndClient, &ErrorCount, EntryName)

#define BOX_SEGMENT 8000
#define BOX_ELEMENT 0x81000000

#define LnAttrMask LBB_COLOR | LBB_MIX_MODE | LBB_WIDTH | LBB_GEOM_WIDTH |\
                   LBB_TYPE | LBB_END | LBB_JOIN

#define ChAttrMask CBB_COLOR | CBB_BACK_COLOR | CBB_MIX_MODE |\
                   CBB_BACK_MIX_MODE | CBB_MODE | CBB_BOX |\
                   CBB_ANGLE | CBB_SHEAR | CBB_DIRECTION

#define MkAttrMask MBB_COLOR | MBB_BACK_COLOR | MBB_MIX_MODE |\
                   MBB_BACK_MIX_MODE | MBB_SYMBOL | MBB_BOX

#define ArAttrMask ABB_COLOR | ABB_BACK_COLOR | ABB_MIX_MODE |\
                   ABB_BACK_MIX_MODE | ABB_SYMBOL | ABB_REF_POINT

#define ImAttrMask IBB_COLOR | IBB_BACK_COLOR | IBB_MIX_MODE |\
                   IBB_BACK_MIX_MODE

#define DFORM_ERROR -1

#define ETYPE_CALLSEGMENT     0x00000007
#define ETYPE_POLYLINE        0x00000081
#define ETYPE_POLYFILLET      0x00000085
#define ETYPE_POLYFILLETSHARP 0x000000A4
#define ETYPE_POLYSPLINE      0x000000A5
#define ETYPE_POLYMARKER      0x000000C2
#define ETYPE_FULLARC         0x00000087
#define ETYPE_IMAGE           0x00000091
#define ETYPE_CURRCHARSTR     0x000000B1
#define ETYPE_GIVNCHARSTR     0x000000F1
#define ETYPE_USERELEMENT     0x81000000

#ifdef ONE_INCH
#undef ONE_INCH
#endif
#define ONE_INCH    1.0

#ifdef HALF_INCH
#undef HALF_INCH
#endif
#define HALF_INCH   0.5

#ifdef FOURTH_INCH
#undef FOURTH_INCH
#endif
#define FOURTH_INCH 0.25

#ifdef TENTH_INCH
#undef TENTH_INCH
#endif
#define TENTH_INCH  0.1

#endif
