#define GETX  pPoint.x = MapX((LONG) (((double) delta_x) * *(padPoint++)))
#define GETY  pPoint.y = MapY((LONG) (((double) delta_y) * *(padPoint++)))



/***************************************************************************
 *\\ddd
 * Subtask Name: PDVT (Phase II).
 *
 * Module name: COMMON.H
 *
 * Purpose: This Include file was created to provide a consistant format for
 *          error logging. Also, this file include all functions that
 *          are necessary to create a logical font to use for drawing
 *          text on current device.
 *
 * Revision Log:  01/22/91,PDVT (Phase II),David McCombs.
 *                                     -First draft:
 *                01/24/91 ,PDVT ,Mike Abuzant
 *                              - Wrote functions and macros.
 *                03/04/91 ,PDVT ,Mike Abuzant
 *                              - Included a new set_delta() and gpi_grid() functions.
 *                                              03/16/91 ,PDVT ,David McCombs.
 *                                              - New format specifiers for LogInfo, ErrorStatus,
 *                                                SetEnter and SetExit functions.
 * Contents:
 *              - function prototypes
 *              - define's specific to COMMON.C
 *
 * Limitations:
 *   none at this time.
 *
 *\\end
 ***************************************************************************/

typedef struct {
          LONG Detectable;
          LONG Visible;
          LONG Chained;
          LONG Dynamic;
          LONG FastChain;
          LONG Prop_Detectable;
          LONG Prop_Visible;
          LONG AttrMode;
        } SEGMENTATTRS;

typedef SEGMENTATTRS FAR *PSEGMENTATTRS;

#define GRID         0x01
#define GRID_FULL    0x02
#define NOPLUS       0x04
#define MODE_TYPE    0x18
#define TYPE_DRAW    0x08
#define TYPE_RETAIN  0x10
#define TYPE_DRAWRETAIN 0x18

#define WARNING_L1   0x01
#define WARNING_L5   0x05

#define TAGERROR     0x01
#define COLORERROR   0x02
#define AREAERROR    0x04

#define Seg1  1L
#define Seg2  2L
#define Seg3  3L
#define Seg4  4L
#define Seg5  5L
#define Seg6  6L
#define Seg7  7L
#define Seg8  8L
#define TEXT  16000L
#define MAXPOINTS       30
#define MINSEGMENTS      1
#define MAXSEGMENTS      8

ERRORID error;
POINTL  pPoint;

void MapArrayOfPoints(INT, PPOINTL);
INT  CreateSegmentChain(HPS, HWND, PSEGMENTATTRS, LONG, LONG, BYTE);
void SetSegmentAttrs(HPS, PSEGMENTATTRS, LONG);
void SetInitialSegmentAttrs(HPS, PSEGMENTATTRS);
void W_Text(HPS, HWND, LONG, LONG);
#define randL(a, b) (LONG)((a) + (((LONG)rand() << 15 | (LONG)rand()) % \
                                        ((LONG)(b) - (LONG)(a) + 1L)))

#define WriteText(lrange, urange)                                        \
        (void) W_Text(hPS, hWndClient, lrange, urange)
#define CreateSChain(SegmentAttrs,lrange,urange,mode)                    \
        (INT) CreateSegmentChain(hPS, hWndClient, SegmentAttrs, lrange,  \
                                                            urange, mode)
