#define GETX    pPoint.x = (LONG) (((double) delta_x) * *(padPoint++))
#define GETY    pPoint.y = (LONG) (((double) delta_y) * *(padPoint++))
#define CLR_RED_A       30L
#define CLR_RED_B               31L
#define CLR_GREEN_A     32L
#define CLR_GREEN_B     33L
#define CLR_BLUE_A      34L
#define CLR_BLUE_B      35L
#define OTHER             -10L


#ifndef COLOR_H
#define COLOR_H


/***************************************************************************
 *\\ddd
 * Subtask Name: pdvt
 *
 * Module name: GpiColor
 *
 * Purpose: GpiColor.dll include file
 *
 *  $header$
 *
 * Revision Log:  01/07/91 ,PDVT ,Mike Abuzant
 *                Prototype
 *
 *                                              01/28/91 ,PDVT , David McCombs
 *                              Gpi Color Testcase
 *
 *
 *
 *
 *
 *
 * Contents:  This file contains the following definitions:
 *
 *              - function prototypes
 *              - number of tests
 *      - name of tests
 *    - global color structure
 *
 * Limitations:
 *  None
 *
 *\\end
 ***************************************************************************/

/* declare all dll functions */

VOID  APIENTRY GpiColorApp1(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiColorApp2(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiColorApp3(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiSetColorExh(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiSetMixExh1(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiSetMixExh2(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiSetMixExh3(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiSetMixExh4(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiSetBackColorExh(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiSetBackMixExh(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiCreateLogColorTableExh1(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiCreateLogColorTableExh2(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiQueryColorDataExh(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiQueryColorIndexExh(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiQueryNearestColorExh(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiQueryRealColorsExh(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiQueryRGBColorExh(HPS hPS, HWND hWndClient, BOOL SelectionCall);




BOOL SineGraph(HWND hWndClient, HPS hPS, SHORT decrement , CHAR *string );
BOOL SinePolyGraph(HWND hWndClient, HPS hPS, SHORT decrement , CHAR *string );
BOOL Graph( HWND hWndClient, HPS hPS, SHORT decrement , LONG colorval, CHAR *string );
BOOL Bar( HWND hWndClient, HPS hPS, LONG lX, LONG lY, BOOL bVert, CHAR *string );
BOOL Wave(HPS hPS, PPOINTL pHorizon, SHORT Width);

static struct {
        LONG lColorIndex;
        CHAR *szColorIndex;
        }
        clr[] = {
                CLR_TRUE       , "                    TRUE"  ,
                CLR_FALSE      , "                    FALSE"  ,
                CLR_BACKGROUND , "                    BACKGROUND"  ,
                CLR_DEFAULT    , "                    DEFAULT"  ,
                CLR_DARKRED    , "                    DARKRED"  ,
                CLR_RED        , "                    RED"  ,
                CLR_DARKPINK   , "                    DARKPINK"  ,
                CLR_PINK       , "                    PINK"  ,
                CLR_WHITE      , "                    WHITE"  ,
                CLR_YELLOW     , "                    YELLOW"  ,
                CLR_CYAN       , "                    CYAN"  ,
                CLR_DARKCYAN   , "                    DARKCYAN"   ,
                CLR_GREEN      , "                    GREEN"  ,
                CLR_DARKGREEN  , "                    DARKGREEN"  ,
                CLR_DARKBLUE   , "                    DARKBLUE"  ,
                CLR_BLUE       , "                    BLUE"  ,
                CLR_PALEGRAY   , "                    PALEGRAY"  ,
                CLR_DARKGRAY   , "                    DARKGRAY"  ,
                CLR_BROWN      , "                    BROWN"  ,
                CLR_BLACK      , "                    BLACK"   ,
                CLR_NEUTRAL    , "                    NEUTRAL"
                } ;

        static struct {
        LONG lColorVal;
        CHAR *szColorText;
        }
        sClr[] = {
                        CLR_BLACK      , "CLR_BLACK    ",
                        CLR_WHITE      , "CLR_WHITE    ",
                        CLR_BLUE       , "CLR_BLUE     ",
                        CLR_RED       , "CLR_RED      ",
                        CLR_PINK       , "CLR_PINK     ",
                        CLR_GREEN      , "CLR_GREEN    ",
                        CLR_CYAN       , "CLR_CYAN     ",
                        CLR_YELLOW     , "CLR_YELLOW   ",
                        CLR_DARKGRAY   , "CLR_DARKGRAY ",
                        CLR_DARKBLUE   , "CLR_DARKBLUE ",
                        CLR_DARKRED    , "CLR_DARKRED  ",
                        CLR_DARKPINK   , "CLR_DARKPINK ",
                        CLR_DARKGREEN  , "CLR_DARKGREEN",
                        CLR_DARKCYAN   , "CLR_DARKCYAN ",
                        CLR_BROWN      , "CLR_BROWN    ",
                        CLR_PALEGRAY   , "CLR_PALEGRAY ",
                        CLR_NEUTRAL    , "CLR_NEUTRAL"  ,
                        CLR_RED_A      , "CLR_RED_A"     ,
                        CLR_RED_B      , "CLR_RED_B"     ,
                        CLR_GREEN_A             , "CLR_GREEN_A"  ,
                        CLR_GREEN_B             , "CLR_GREEN_B"  ,
                        CLR_BLUE_A              , "CLR_BLUE_A"    ,
                        CLR_BLUE_B              , "CLR_BLUE_B"    ,
                        OTHER                   , "OTHER "
                        } ;

/* set function name for dll init routine */

CHAR * TestCaseName= "GpiColorTests";

static  NAMES_AND_ADDRESSES EntryPointList[]=
    {
        TOKENIZEFUNCTIONNAME(GpiColorApp1),
        TOKENIZEFUNCTIONNAME(GpiColorApp2),
        TOKENIZEFUNCTIONNAME(GpiColorApp3),
        TOKENIZEFUNCTIONNAME(GpiSetColorExh),
        TOKENIZEFUNCTIONNAME(GpiSetMixExh1),
        TOKENIZEFUNCTIONNAME(GpiSetMixExh2),
        TOKENIZEFUNCTIONNAME(GpiSetMixExh3),
        TOKENIZEFUNCTIONNAME(GpiSetMixExh4),
        TOKENIZEFUNCTIONNAME(GpiSetBackColorExh),
        TOKENIZEFUNCTIONNAME(GpiSetBackMixExh),
        TOKENIZEFUNCTIONNAME(GpiCreateLogColorTableExh1),
        TOKENIZEFUNCTIONNAME(GpiCreateLogColorTableExh2),
        TOKENIZEFUNCTIONNAME(GpiQueryColorDataExh),
        TOKENIZEFUNCTIONNAME(GpiQueryColorIndexExh),
        TOKENIZEFUNCTIONNAME(GpiQueryNearestColorExh),
        TOKENIZEFUNCTIONNAME(GpiQueryRealColorsExh),
        TOKENIZEFUNCTIONNAME(GpiQueryRGBColorExh),

    };

LONG lSpace;                      // Used for offsets in columnar incremenents
POINTL pPoint, pTextPoint, pNearCorner, pFarCorner, pBoxSize;
CHAR szAddMessage[400];
CHAR achLogLine[200];  // Buffer used for printing error messages
COLOR clrTarget[256];  // COLOR maps to LONG, Target for GpiColorQueries.

static COLOR clrSource[]={
                        0x000011L, 0x000033L, 0x000044L, 0x000055L, 0x000066L,
                        0x000077L, 0X000099L, 0x0000AAL, 0x0000CCL, 0X0000FFL,
                        0x001100L, 0x003300L, 0x004400L, 0x005500L, 0x006600L,
                        0x007700L, 0X009900L, 0x00AA00L, 0x00CC00L, 0X00FF00L,
                        0x110000L, 0x330000L, 0x440000L, 0x550000L, 0x660000L,
                        0x770000L, 0X990000L, 0xAA0000L, 0xCC0000L, 0XFF0000L
                                                       } ; // Source for GpiCreateLogColorTable.

// L.M. Ruffing 3-19-20
// Changed all of the left parameters, CLR_BLUE_A through CLR_RED_B.
// They were previously in the wrong order, CLR_RED_A through CLR_BLUE_B.
static COLOR clrIndSource[]={
                        CLR_BLUE_A, 0x000033L,
                        CLR_BLUE_B, 0X0000FFL,
                        CLR_GREEN_A, 0x003300L,
                        CLR_GREEN_B, 0X00FF00L,
                        CLR_RED_A, 0x330000L,
                        CLR_RED_B, 0XFF0000L } ; // Source for GpiCreateLogColorTable.

LONG ErrorCount;       // Error counter.

/********************************************************************
*
*        The folowing lines force the compiler to manually assign
*        the function names passed to be assigned to seperate data
*        segments.  The C/2 compiler does not allocate a seperate segment
*   to the remainder of the program when the first segment is full.
*
*********************************************************************/


# endif

