#define INCL_DEV      // include all DEV definitions
#define INCL_WIN
#define INCL_GPI      // include all Gpi definitions
#define INCL_ERRORS   // include all Gre error definitions
#include <string.h>
#include <stdlib.h>
#include <os2.h>
#include <stdio.h>
#include <math.h>
#include "PTTDLLDF.h"               // test case defines
#include "common.h"
#include "gpicolor.h"


/****************************************************************************
 *\\ddd
 * Subtask Name: GpiColor.dll
 *
 * Module name: GpiColor.c
 *
 * Purpose: dll test functions
 *
 * Revision Log:
 *                                        01/20/91 ,PDVT ,D.K.McCombs
 *                                        -Initial Creation.
 *
 *               12/10/90 ,PDVT ,Mike Abuzant
 *               -Initial Template.
 *
 *
 * SAD References:
 *
 * SRS References: Printer Driver Verification Tool
 *
 * Contents:  InitTest()
 *            GpiSetColorApp()
 *            GpiSetColorExh()
 *            GpiSetColorRC()
 *
 * Design Overview:
 *
 * Limitations:
 *
 *
 *
 *\\end
****************************************************************************/
/****************************************************************************
 *\\ddd
 * Routine Name: InitTest()
 *
 * Purpose:  Initialize function names and address array for ptt.
 *
 * System Requirements:
 *
 * Revision Log:
 *
 *                                              10/24/90, pdvt, Mike Abuzant
 *               - initial file
 *
 * Inputs:
 *   sel          // passed through to the InitTestSegVars function
 *   init_info_p  // name and address array used by ptt interface
 *
 * Outputs:
 *   init_info_p  // returned initialized with names and addresses
 *
 * Subroutines Required:
 *   InitTestSegVars()    // used by the ptt interface
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/

/****************************************************************************
 *\\algorithm
 * {
 *        Get the number of tests.
 *   for the number of tests {
 *                      Get the test names;
 *                      Get the test addresses;
 *                      }
 *   call InitTestSegVars function
 *   }
 *\\end
 ***************************************************************************/
VOID APIENTRY InitTest(PVOID Selector, PTESTINITINFO init_info_p)
{
  register USHORT usTestCounter;

  init_info_p->ntests = NTESTS;
  strcpy(init_info_p->group_name,TestCaseName); //Testcase Name

  for (usTestCounter=0 ;usTestCounter< NTESTS; ++usTestCounter){

     init_info_p->test_addrs[usTestCounter]=
                               EntryPointList[usTestCounter].TestAddress;
     strcpy(init_info_p->test_names[usTestCounter],
                               EntryPointList[usTestCounter].TestName);
  }

  InitTestSegVars(Selector);
  return;
}


/****************************************************************************
 *\\ddd
 * Routine Name: GpiColorApp1()
 *
 * Purpose:  This is an entry point for the PTT.
 *                               Color Application tests 1.
 *
 *
 * System Requirements:  Section 6.3.2
 *
 * Revision Log:
 *               01/24/91, pdvt, Template from Mike Abuzant
 *               01/31/91, pdvt, Program by David McCombs
 *               06/28/91 - modified by Vish Thyagarajan (Boca)
 *    This testcase and the mix mode testcases involve almost the same changes,
 *    viz., moving the call GpiSetPattern inside the FOR loops.
 *    Originally, the Set Pattern call was out of the loop.
 *    But the attribute mode was not set to AM_PRESERVE and a subsequent attribute
 *    setting call (GpiSetColor) was made without preserving the value of the
 *    primitive attribute. As a result of that, the value of the pattern was lost
 *    and when the loop started doing its second iteration, the pattern value
 *    went back to DEFAULT, which is SOLID fill pattern. The testcases most
 *    affected were the MIX mode testcases, where we do not want solid patterns
 *    for various reasons.
 * Inputs:
 *        hPS           -presentation space.
 *        hWndClient    -client window handle
 *        SelectionCall -selection indicator.
 *
 * Outputs:     Void
 *
 * Subroutines Required:
 *
 *       BOOL Graph()
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/


/****************************************************************************
 *\\algorithm
 * {
 *      ENTER_MAIN();
 *      Initialize a static structure for 16 LONG color values
 *                                                                      and the associated color names;
 *
 *      Log begining of item entry using SUBENTER();
 *
 *      For (ColorNumber = 0 to 15) {
 *              Log Setup Entry Point using SETENTER();
 *              Set Pattern to PATSYM_DIAG3 using GpiSetPattern;
 *              Log end of setup using SETEXIT();
 *              Set color to struct[ColorNumber].Value using GpiSetColor.
 *              Set color name to struct[ColorNumber].Text.
 *              Use Graph() to display color value representation in RGBI terms.
 *              Use ERRSTATUS to display error status.
 *              }
 *      Log end of item entry using SUBEXIT();
 *      EXIT_MAIN();
 *
 * }
 *\\end
 ***************************************************************************/

VOID APIENTRY GpiColorApp1(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
        SHORT sColorNumber;
        static CHAR *szApiEntryName = "GpiColorApp1";
        static struct {
                LONG lColorIndex;
                CHAR *szColorIndex;
                }
                colr[] = {
                        CLR_DARKRED             , "CLR_DARKRED       "  ,
                        CLR_RED                 , "CLR_RED           "  ,
                        CLR_DARKPINK   , "CLR_DARKPINK      "  ,
                        CLR_PINK                        , "CLR_PINK          "  ,
                        CLR_YELLOW      , "CLR_YELLOW        "  ,
                        CLR_CYAN        , "CLR_CYAN          "  ,
                        CLR_DARKCYAN   , "CLR_DARKCYAN      "   ,
                        CLR_WHITE       , "CLR_WHITE         "  ,
                        CLR_GREEN       , "CLR_GREEN         "  ,
                        CLR_DARKGREEN   , "CLR_DARKGREEN     "  ,
                        CLR_DARKBLUE   , "CLR_DARKBLUE      "  ,
                        CLR_BLUE       , "CLR_BLUE          "  ,
                        CLR_PALEGRAY   , "CLR_PALEGRAY      "  ,
                        CLR_DARKGRAY   , "CLR_DARKGRAY      "  ,
                        CLR_BROWN               , "CLR_BROWN         "  ,
                        CLR_BLACK      , "CLR_BLACK         "
                        } ;

  SHORT sColorNumMax = sizeof(colr) / sizeof(colr[0]) ;

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else
        {

        ENTER_MAIN(szApiEntryName);

        SUBENTER(GpiColorApp1,"GpiSetColor");
        for ( sColorNumber = 0 ; sColorNumber < sColorNumMax ; sColorNumber++ ) {

              SETENTER(szApiEntryName,"GpiSetPattern");
              if ((GpiSetPattern(hPS, PATSYM_DIAG3)) == FALSE) {
                 ErrorCount++;
                  }
              ERRSTATUS( TRUE, szApiEntryName, "GpiSetPattern");
              SETEXIT();
                if ((GpiSetColor(hPS, colr[sColorNumber].lColorIndex)) == FALSE) {
                        ErrorCount++;
                        }
                ERRSTATUS(TRUE, "Color:",colr[sColorNumber].szColorIndex);

                if (Graph(hWndClient,hPS,sColorNumber,colr[sColorNumber].lColorIndex,colr[sColorNumber].szColorIndex) == FALSE) {
                        CLEANUP("Graph","GpiColorApp1");
                   return;
                   }
                }
        SUBEXIT();
        EXIT_MAIN(szApiEntryName);
        }
  return;
}

/****************************************************************************
 *\\ddd
 * Routine Name: Graph()
 *
 * Purpose:  Draw a graphical representation of the color value
 *                               at the desired point.
 *
 *
 * System Requirements:  Section 6.3.2
 *
 * Revision Log:
 *                                        01/31/91, for pdvt, Program by David McCombs
 *
 * Inputs:
 *       hPS           -presentation space.
 *       hWndClient    -client window handle
 *       SelectionCall -selection indicator.
 *                      position                        -short value for positioning graph.
 *                      colorvalue     - Index value of selected color.
 *                      *string                         - Index Description of selected color.
 *
 * Outputs:     Void
 *
 * Subroutines Required:
 *       BOOL Graph()
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/


/****************************************************************************
 *\\algorithm
 * {
 *              A switch case construction used to put axis in proper place on output device;
 *
 *              A switch case contruct used to assign each color a representitive number
 *                      that is decomposed into graph axis values. The number equals
 *                      (8*R) + (4*G) + (2*B) + (I);
 *
 *              The color number is then interpreted to create a rectangle that graphically
 *                      represents the RGBI values of the color.  This rectangle overlays the
 *                      index.
 *
 *              An RGBI axis is drawn.
 *
 *      A textual discription of the color index is displayed under the graph.
 *
 * }
 *\\end
 ***************************************************************************/


BOOL Graph(HWND hWndClient, HPS hPS, SHORT position, LONG colorvalue, CHAR *string) {

        POINTL ptl, inc, basis;               // World coordinate points
        struct {
                SHORT red, green, blue, intensity;
                } RGBI;
        SHORT sRGBIndex;
        LONG lBoolDeltX, lBoolDeltY;
        lBoolDeltX = delta_x/4;
        lBoolDeltY = delta_y/4;
        basis.x = inc.x = basis.y = inc.y = 0 ;

         /********************************************
         *
         *  The following code decides on the basis
         *  position from the position number passed
         *  from the calling environment.
         *
         *********************************************/

        switch (position) {
                case 0:
                case 1:
                case 2:
                case 3:
                        basis.y = (LONG) ((float) 5.85*delta_y);
                        basis.x = (LONG) (((LONG) position+1L)*(2L)*delta_x - ((float) 1.3*delta_x));
                        break;
                case 4:
                case 5:
                case 6:
                case 7:
                        basis.y = (LONG) ((float) 4.35*delta_y);
                        basis.x = (LONG) (((LONG) position-3L)*(2L)*delta_x - ((float) 1.3*delta_x));
                        break;
                case 8:
                case 9:
                case 10:
                case 11:
                        basis.y = (LONG) ((float) 2.85*delta_y);
                        basis.x = (LONG) (((LONG) position-7L)*(2L)*delta_x - ((float) 1.3*delta_x));
                        break;
                case 12:
                case 13:
                case 14:
                case 15:
                        basis.y = (LONG) ((float) 1.35*delta_y);
                        basis.x = (LONG) (((LONG) position-11L)*(2L)*delta_x - ((float) 1.3*delta_x));
                        break;
                }

        /************************************************************
        *
        * The following code draws an area which represents the
        * RGBI value of the color.
        *
        *************************************************************/

        switch ( (SHORT) colorvalue) {
                case CLR_DARKRED:
                sRGBIndex = 8;
                   break;
                case CLR_RED:
                   sRGBIndex = 9;
                        break;
                case CLR_DARKPINK:
                        sRGBIndex = 10;
                        break;
                case CLR_PINK:
                        sRGBIndex = 11;
                        break;
                case  CLR_WHITE:
                sRGBIndex = 15;
                        break;
                case CLR_YELLOW:
                sRGBIndex = 13;
                        break;
                case CLR_CYAN:
                sRGBIndex = 7 ;
                        break;
                case CLR_DARKCYAN:
                sRGBIndex = 6 ;
                        break;
                case CLR_GREEN:
                sRGBIndex = 5 ;
                        break;
                case CLR_DARKGREEN:
                sRGBIndex = 4 ;
                        break;
                case CLR_DARKBLUE:
                        sRGBIndex = 2 ;
                        break;
                case CLR_BLUE:
                sRGBIndex = 3 ;
                        break;
                case CLR_PALEGRAY:
                sRGBIndex = 14;
                        break;
                case CLR_DARKGRAY:
                sRGBIndex = 1 ;
                        break;
                case CLR_BROWN:
                sRGBIndex = 12;
                        break;
                case CLR_BLACK:
                sRGBIndex = 0 ;
                 }

                /* the following code deciphers the sRGBIndex into RGBI values */

                RGBI.red = RGBI.green = RGBI.blue = RGBI.intensity = 0;

                if (sRGBIndex >= 8) {
                        RGBI.red = 1;
                        sRGBIndex -= 8;
                        }
                if (sRGBIndex >= 4) {
                        RGBI.green = 1;
                        sRGBIndex -= 4;
                        }
                if (sRGBIndex >= 2) {
                        RGBI.blue = 1;
                        sRGBIndex -= 2;
                        }
                if (sRGBIndex == 1) {
                        RGBI.intensity = 1;
                        }


        inc.x = -lBoolDeltX - RGBI.red*lBoolDeltX;
        inc.y = -lBoolDeltY - RGBI.intensity*lBoolDeltY;
        ptl.x = basis.x + inc.x ;
        ptl.y = basis.y + inc.y ;
        MapPt(ptl);
        if (GpiMove(hPS, &ptl) == FALSE)
                return FALSE;

        inc.x = lBoolDeltX + RGBI.blue*lBoolDeltX;
        inc.y = lBoolDeltY + RGBI.green*lBoolDeltY;
        ptl.x = basis.x + inc.x;
        ptl.y = basis.y + inc.y ;
        MapPt(ptl);
        if (colorvalue == CLR_WHITE){
                GpiSetColor(hPS, CLR_BLACK);
           if (GpiBox(hPS, DRO_OUTLINE, &ptl, 0L, 0L) == FALSE)
                   return FALSE;
        }
        else {
           if (GpiBox(hPS, DRO_OUTLINEFILL, &ptl, 0L, 0L) == FALSE)
                   return FALSE;
        }

        if (GpiSetColor(hPS, CLR_BLACK)==FALSE)
                return FALSE;

        inc.x = (LONG) ((float) 2.1*lBoolDeltX);
        inc.y = 0;
        ptl.x = basis.x + inc.x;
        ptl.y = basis.y + inc.y ;
        MapPt(ptl);
        if (GpiMove(hPS, &ptl) == FALSE)
                return FALSE;
        WorldWriteString(ptl.x, ptl.y, "B");

        inc.x = 2*lBoolDeltX;
        inc.y = 0;
        ptl.x = basis.x + inc.x;
        ptl.y = basis.y + inc.y ;
        MapPt(ptl);
        if (GpiMove(hPS, &ptl) == FALSE)
                return FALSE;

        inc.x = -2*lBoolDeltX;
        ptl.x = basis.x + inc.x;
        ptl.y = basis.y + inc.y ;
        MapPt(ptl);
        if      (GpiLine(hPS, &ptl) == FALSE)
                return FALSE;

        inc.x = (LONG) ((float) -2.6*lBoolDeltX);
        ptl.x = basis.x + inc.x;
        ptl.y = basis.y + inc.y ;
        MapPt(ptl);
        if      (GpiMove(hPS, &ptl) == FALSE)
                return FALSE;
        WorldWriteString(ptl.x, ptl.y, "R");

        inc.x = 0;
        inc.y = (LONG) ((float) 2.1*lBoolDeltY);
        ptl.x = basis.x + inc.x;
        ptl.y = basis.y + inc.y ;
        MapPt(ptl);
        if (GpiMove(hPS, &ptl) == FALSE)
                return FALSE;
        WorldWriteString(ptl.x, ptl.y, "G");

        inc.x = 0;
        inc.y = 2*lBoolDeltY;
        ptl.x = basis.x + inc.x;
        ptl.y = basis.y + inc.y ;
        MapPt(ptl);
        if (GpiMove(hPS, &ptl) == FALSE)
                return FALSE;

        inc.x = 0;
        inc.y = -2*lBoolDeltY;
        ptl.x = basis.x + inc.x;
        ptl.y = basis.y + inc.y;
        MapPt(ptl);
        if      (GpiLine(hPS, &ptl) == FALSE)
                return FALSE;

        inc.x = 0;
        inc.y = (LONG) ((float) -2.7*lBoolDeltY);
        ptl.x = basis.x + inc.x;
        ptl.y = basis.y + inc.y;
        MapPt(ptl);
        if      (GpiMove(hPS, &ptl) == FALSE)
                return FALSE;
        WorldWriteString(ptl.x, ptl.y, "I");


        inc.x = lBoolDeltX/2;
        inc.y = (LONG) ((float) -2.75*lBoolDeltY);
        ptl.x = basis.x + inc.x;
        ptl.y = basis.y + inc.y;
        MapPt(ptl);
        if      (GpiMove(hPS, &ptl) == FALSE)
                return FALSE;

        WorldWriteString(ptl.x, ptl.y , string);
        return TRUE;
}



/****************************************************************************
 *\\ddd
 * Routine Name: GpiColorApp2()
 *
 * Purpose:  This is an entry point for the PTT excersises the GpiSetColor
 *                               function and uses GpiPolyLine.
 *
 *
 * System Requirements:  Section 6.3.2
 *
 * Revision Log:
 *               01/24/91, pdvt, Template from Mike Abuzant
 *                                        01/31/91, pdvt, Program by David McCombs
 *
 * Inputs:
 *        hPS           -presentation space.
 *        hWndClient    -client window handle
 *        SelectionCall -selection indicator.
 *
 * Outputs:     Void
 *
 * Subroutines Required:
 *       BOOL SineGraph()
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/


/****************************************************************************
 *\\algorithm
 * {
 *      if (SelectionCall){
 *              WndSendMsg();
 *              }
 *      else {
 *              ENTER_MAIN();
 *              SUBENTER();
 *      for (all color values in structure ) {
 *                      GpiSetColor();
 *              SinePolyGraph();
 *                      ERRSTATUS();
 *                      }
 *              SUBEXIT();
 *              EXIT_MAIN();
 *              return;
 *      } end else
 * }
 *\\end
 ***************************************************************************/


VOID APIENTRY GpiColorApp2(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
        static CHAR *szApiEntryName = "GpiColorApp2";
        SHORT sColorNumber;

  SHORT sColorNumMax = 16 ;

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else
        {
        ENTER_MAIN(szApiEntryName);
   (VOID)set_delta(hPS);
        GpiSetColor(hPS, CLR_BLUE);
   gpi_grid(hPS, (LONG) HALFINCH);
        GpiSetColor(hPS, CLR_BLACK);


        SUBENTER(GpiColorApp2,"Color Range Test");
        for ( sColorNumber = 0 ; sColorNumber < sColorNumMax ; sColorNumber++ ) {

                if ((GpiSetColor(hPS, sClr[sColorNumber].lColorVal)) == FALSE) {
                        ErrorCount++;
                        }
                        ERRSTATUS(TRUE,"Color:",sClr[sColorNumber].szColorText);

                if (SinePolyGraph(hWndClient,hPS,sColorNumber, sClr[sColorNumber].szColorText) == FALSE) {
                        ErrorCount++;
                        }
                        ERRSTATUS(TRUE,szApiEntryName,"SinePolyGraph");
                }
        SUBEXIT();
        EXIT_MAIN(szApiEntryName);
        }
  return;
}
/****************************************************************************
 *\\ddd
 * Routine Name: SinePolyGraph()
 *
 * Purpose:  Draw a Sine Wave with a ramp wave superimposed
 *                               of the color value at the desired point.
 *
 *
 * System Requirements:  Section 6.3.2
 *
 * Revision Log:
 *                                        01/31/91, for pdvt, Program by David McCombs
 *
 * Inputs:
 *       hPS           -presentation space.
 *       hWndClient    -client window handle
 *       SelectionCall -selection indicator.
 *                      decrement     -offset from top of position pointer.
 *                      string            -textual COLOR value discription.
 *
 * Outputs:     BOOL Success
 *
 * Subroutines Required: None
 *
 * Limitations: None
 *
 *\\end
 ***************************************************************************/

/****************************************************************************
 *\\algorithm
 * {
 *
 *              Move to the starting position with GpiMove();
 *              For 500 loops{
 *                      Set Amplitude = (1/2 inch)*(sine(PI/100)) inches;
 *                      Move from the y basis to Amplitude;
 *                      Move from the x basis to (loop-1)*(1/100 inch) inches;
 *                      Use GpiPolyLine to make a 1/100th inch cycle of a ramp wave{
 *                              Ramp Wave period = 1/100 inch;
 *                              Ramp Wave Height = 1/8 inch;
 *                              Approximate ramp wave appearance: |\|\;
 *                              }
 *                      } // end for loop
 *              Move 1/4 inch from end of resulting sine wave;
 *              Output the color with WorldWriteString function;
 *              return BOOL Success;
 *
 * }
 *\\end
 ***************************************************************************/


BOOL SinePolyGraph(HWND hWndClient, HPS hPS, SHORT decrement , CHAR *string) {
        double halfperiod = 3.14157;
        double lfAmplitude;
        POINTL ptl[2], inc, basis;
        SHORT loopvar;
        basis.x = inc.x = 0 ;
        basis.y = inc.y = (LONG) ( (5.5 - (float) (decrement) / 4 ) * delta_y) ;
        ptl[0].x = inc.x ;
        ptl[0].y = inc.y ;
        MapPt(ptl[0]);
        if (GpiMove(hPS, ptl) == FALSE)
                return FALSE;
        for ( loopvar = 0; loopvar <= 500; loopvar++ ) {
                lfAmplitude=( (double) delta_y/2.0 )*( sin(halfperiod*loopvar/100.0) ) + 0.5;
                inc.x = (loopvar*delta_x )/100;
                inc.y = (LONG) lfAmplitude;
                ptl[0].x = (ptl[1].x = (inc.x + basis.x));
                ptl[1].y = (ptl[0].y = (inc.y + basis.y)) + delta_y/8;
                MapPt(ptl[0]);
                MapPt(ptl[1]);



      if( GpiBeginPath(hPS, 1L) == FALSE )
          return FALSE;

         if( GpiPolyLine(hPS, 2L, ptl) != GPI_OK )
             return FALSE;

      if( GpiEndPath( hPS ) == FALSE )
          return FALSE;
      if( GpiStrokePath( hPS, 1L, (ULONG) 0 ) != GPI_OK )
          return FALSE;





                }

        ptl[0].x = inc.x + basis.x;
        ptl[0].y = inc.y + basis.y;
        MapPt (ptl[0]);
        if (GpiMove(hPS, ptl) == FALSE )
                return FALSE;
        ptl[0].x = inc.x + basis.x + delta_x/4;
        ptl[0].y = inc.y + basis.y;
        MapPt(ptl[0]);
        if (GpiSetColor(hPS, CLR_BLACK) == FALSE )
                return FALSE;
        if      (GpiLine(hPS, ptl) == FALSE)
                return FALSE;

                WorldWriteString(ptl[0].x, ptl[0].y , string);
        return TRUE;
}


/****************************************************************************
 *\\ddd
 *
 * Routine Name: GpiColorApp3 application algorithm
 *
 * Purpose:
 *
 * System Requirements:
 *
 *      Revision Log: 01/23/91 Initial creation for pdvt, David McCombs
 *                    3/16/92  Vish Thyagarajan (Boca)
 *                    GpiSetBackMix had to be set to BM_OVERPAINT in the
 *                    beginning of the program. (Reason : On the plotters,
 *                    PMPLOTPD.DRV considers diagonal hatch patterns to be
 *                    transparent and so, does not clip out the background.)
 *
 *
 * Inputs: hPS           -Presentations Space handle.
 *                        hWndClient    -Client Window handle.
 *         SelectionCall -Selection Indicator, is 0 if routine is selected.
 *
 * Outputs:
 *
 * Subroutines Required:
 *                              Wave();
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *      if (SelectionCall){
 *              WndSendMsg();
 *              }
 *      else {
 *              ENTER_MAIN();
 *              Log Setup Entry with SETENTER();
 *              Set Arc Parameters with GpiSetArcParameters;
 *    Set the pattern with GpiSetPattern(PATSYM_DIAG3);
 *              Log the Setup exit with SETEXIT();
 *              Mix is Default OVERPAINT.
 *              Move to lower left corner of drawing;
 *              Draw the whole scene space with a sky color. (CLR_CYAN)
 *              Make the Ocean {
 *                      GpiSetColor(CLR_DARKBLUE);
 *                      GpiBeginArea();
 *                      Use 3 GpiLine() calls for the bottom and sides;
 *                      Use Wave() for the top;
 *                      GpiEndArea() fills the area;
 *                      }
 *              Make the sun. {
 *                      GpiSetColor(CLR_YELLOW);
 *                      GpiFullArc();
 *                      }
 *              Make the Sails. {
 *               for (each sail) {
 *                      GpiSetColor(CLR_WHITE);
 *                      GpiBeginArea();
 *                      GpiPointArc();
 *                      GpiLine();
 *                      GpiEndArea:
 *                      }
 *               }
 *              Make the Mast.  {
 *                      GpiSetColor(CLR_BROWN);
 *                      GpiBox();
 *                      }
 *    Change the Mix to FM_NOTXORSRC to provide the illusion of
 *    Transparent water and the sun showing thru clouds using
 *              GpiSetMix(hPS, FM_NOTXORSRC ).
 *
 *              Make the clouds.
 *
 *              Make the boat hull.
 *
 *              EXIT_MAIN();
 *      }
 *      }
 *\\end
 ***************************************************************************/

VOID APIENTRY GpiColorApp3(HPS hPS, HWND hWndClient, BOOL SelectionCall)
{
        POINTL basis, inc, ptl, aptlArc[2];
        ARCPARAMS arcvals;
        SHORT width = 6;
        static CHAR *EntryName="GpiColorApp3";


        if (SelectionCall) {
                WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
               *pBasisX = 10000;
               *pBasisY = 10000;
                }
        else {
                ENTER_MAIN(EntryName);

                GpiSetBackMix (hPS, BM_OVERPAINT) ;   /****** fix - Vish *****/
/*  Set Arc Paramater Structure         */



                arcvals.lP = delta_x/4L;
                arcvals.lR = 0L;
                arcvals.lS = 0L;
                arcvals.lQ = delta_y/4L;

                MapArc(arcvals);
                SETENTER(EntryName,"ArcParameters + Pattern");
                /*  Set Arc Parameters                  */

                if ( GpiSetArcParams(hPS, &arcvals ) != GPI_OK ) {
                        CLEANUP("GpiSetArcParams",EntryName);
                        return;
                        }


                ptl.x = inc.x = (delta_x)/2L;
                ptl.y = inc.y = (6L*delta_y)/2L;                        // Sea Level.
                MapPt(inc);

                if ( GpiMove(hPS, &inc ) == FALSE ) {
                        CLEANUP("GpiMove",EntryName);
                        return;
                        }

                if ( GpiSetColor(hPS, CLR_CYAN) == FALSE ) {
                        CLEANUP("GpiSetColor",EntryName);
                        return;
                        }


/*************************************************************************
*
*         Initially, GpiSetMix is set to FM_OVERPAINT which is the default.
*        This value is used for all background drawing.  The background is
*   drawn first.
*
*************************************************************************/

                SUBENTER(GpiColorApp3, "Draw Scene");
                if ( GpiSetColor(hPS, CLR_CYAN) == FALSE ) {
                        CLEANUP("GpiSetColor",EntryName);
                        return;
                        }


// Move to lower left corner of drawing.

                basis.x = inc.x = delta_x/2L ;
                basis.y = inc.y = delta_y ;
                ptl.x = inc.x ;
                ptl.y = inc.y ;
                MapPt(ptl);

                if ( GpiMove(hPS, &ptl ) == FALSE ) {
                        CLEANUP("GpiMove",EntryName);
                        return;
                        }

// Draw the whole scene space with a sky color. (CLR_CYAN)

                inc.x = (13L*delta_x)/2L;
                inc.y = (12L*delta_y)/2L;                       // Top Right of Box.
                MapPt(inc);

                if ( GpiBox(hPS, DRO_OUTLINEFILL, &inc, 0L, 0L) == FALSE ) {
                        CLEANUP("GpiBox",EntryName);
                        return;
                        }

// Make the Ocean.

                if ( GpiSetColor(hPS, CLR_DARKBLUE) == FALSE ) {
                        CLEANUP("GpiSetColor",EntryName);
                        return;
                        }

                if ( GpiBeginArea(hPS, BA_BOUNDARY | BA_WINDING) == FALSE ) {
                        CLEANUP("GpiBeginArea","GpiColorApp");
                        return;
                        }

                ptl.x = inc.x = (delta_x)/2L;
                ptl.y = inc.y = (6L*delta_y)/2L;                        // Sea Level.
                MapPt(inc);

                if ( GpiMove(hPS, &inc ) == FALSE ) {
                        CLEANUP("GpiMove",EntryName);
                        return;
                        }

                if ( Wave( hPS, &ptl, width ) == FALSE ) {
                        CLEANUP("Wave",EntryName);
                        return;
                        }

                inc.x = (13L*delta_x)/2L;
                inc.y = (2L*delta_y)/2L;
                MapPt(inc);
                if ( GpiLine(hPS, &inc ) == FALSE ) {
                        CLEANUP("GpiLine",EntryName);
                        return;
                        }
                inc.x = (delta_x)/2L;
                inc.y = (2L*delta_y)/2L;
                MapPt(inc);
                if ( GpiLine(hPS, &inc ) == FALSE ) {
                        CLEANUP("GpiLine",EntryName);
                        return;
                        }
                inc.x = (delta_x)/2L;
                inc.y = (6L*delta_y)/2L;
                MapPt(inc);
                if ( GpiLine(hPS, &inc ) == FALSE ) {
                        CLEANUP("GpiLine",EntryName);
                        return;
                        }
                if ( GpiEndArea(hPS ) == FALSE ) {
                        CLEANUP("GpiEndArea",EntryName);
                        return;
                        }

// Make the sun.

                if ( GpiSetColor(hPS, CLR_YELLOW) == FALSE ) {
                        CLEANUP("GpiSetColor",EntryName);
                        return;
                        }

                ptl.x = inc.x = (3L*delta_x)/2L;
                ptl.y = inc.y = (11L*delta_y)/2L;                       // Sun Point.
                MapPt(inc);

                if ( GpiMove(hPS, &inc ) == FALSE ) {
                        CLEANUP("GpiMove",EntryName);
                        return;
                        }

      if ( GpiFullArc (hPS, DRO_OUTLINEFILL, MAKEFIXED(1,0)) != GPI_OK ) {
                        CLEANUP("GpiFullArc",EntryName);
                        return;
                        }


// Make the Sails.

                if ( GpiSetColor(hPS, CLR_WHITE) == FALSE ) {
                        CLEANUP("GpiSetColor",EntryName);
                        return;
                        }

// Sail One.

                inc.x = (4L*delta_x)/2L;
                inc.y = (7L*delta_y)/2L;       // Lower Left point of Left Sail.
                MapPt(inc);

                aptlArc[0].x = (5L*delta_x)/2L;
                aptlArc[0].y = (9L*delta_y)/2L;
                aptlArc[1].x = (7L*delta_x)/2L;
                aptlArc[1].y = (11L*delta_y)/2L;                        // Top of Left Sail.
                MapPt(aptlArc[0]);
                MapPt(aptlArc[1]);

                if ( GpiBeginArea(hPS, BA_BOUNDARY | BA_WINDING) == FALSE ) {
                        CLEANUP("GpiBeginArea",EntryName);
                        return;
                        }

                if ( GpiMove(hPS, &inc ) == FALSE ) {
                        CLEANUP("GpiMove",EntryName);
                        return;
                        }

                if ( GpiPointArc(hPS, aptlArc ) != GPI_OK ) {
                        CLEANUP("GpiPointArc",EntryName);
                        return;
                        }


                aptlArc[0].x = (13L*delta_x)/4L;
                aptlArc[0].y = (9L*delta_y)/2L;
                aptlArc[1].x = (7L*delta_x)/2L;
                aptlArc[1].y = (7L*delta_y)/2L;                 // Right point Left Sail.
                MapPt(aptlArc[0]);
                MapPt(aptlArc[1]);

                if ( GpiPointArc(hPS, aptlArc ) != GPI_OK ) {
                        CLEANUP("GpiPointArc",EntryName);
                        return;
                        }

                if ( GpiEndArea(hPS ) == FALSE ) {
                        CLEANUP("GpiEndArea",EntryName);
                        return;
                        }

// Sail Two

                inc.x = (15L*delta_x)/4L;
                inc.y = (7L*delta_y)/2L;       // Lower Left point of Right Sail.
                MapPt(inc);

                aptlArc[0].x = (8L*delta_x)/2L;
                aptlArc[0].y = (9L*delta_y)/2L;
                aptlArc[1].x = (15L*delta_x)/4L;
                aptlArc[1].y = (11L*delta_y)/2L;                        // Top of Right Sail.
                MapPt(aptlArc[0]);
                MapPt(aptlArc[1]);

                if ( GpiBeginArea(hPS, BA_BOUNDARY | BA_WINDING) == FALSE ) {
                        CLEANUP("GpiBeginArea",EntryName);
                        return;
                        }

                if ( GpiMove(hPS, &inc ) == FALSE ) {
                        CLEANUP("GpiMove",EntryName);
                        return;
                        }

                if ( GpiPointArc(hPS, aptlArc ) != GPI_OK ) {
                        CLEANUP("GpiPointArc",EntryName);
                        return;
                        }


                aptlArc[0].x = (10L*delta_x)/2L;
                aptlArc[0].y = (19L*delta_y)/4L;
                aptlArc[1].x = (12L*delta_x)/2L;
                aptlArc[1].y = (7L*delta_y)/2L;                 // Right point Right Sail.
                MapPt(aptlArc[0]);
                MapPt(aptlArc[1]);

                if ( GpiPointArc(hPS, aptlArc ) != GPI_OK ) {
                        CLEANUP("GpiPointArc",EntryName);
                        return;
                        }

                if ( GpiEndArea(hPS ) == FALSE ) {
                        CLEANUP("GpiEndArea",EntryName);
                        return;
                        }

// Make the Mast.

                if ( GpiSetColor(hPS, CLR_PALEGRAY) == FALSE ) {
                        CLEANUP("GpiSetColor",EntryName);
                        return;
                        }
                inc.x = (7L*delta_x)/2L;
                inc.y = (13L*delta_y)/4L;       // Lower Left point of Right Sail.
                MapPt(inc);

                if ( GpiMove(hPS, &inc ) == FALSE ) {
                        CLEANUP("GpiMove",EntryName);
                        return;
                        }

                inc.x = (29L*delta_x)/8L;
                inc.y = (23L*delta_y)/4L;       // Lower Left point of Right Sail.
                MapPt(inc);

                if ( GpiBox(hPS, DRO_OUTLINEFILL, &inc, 0L, 0L) == FALSE ) {
                        CLEANUP("GpiBox",EntryName);
                        return;
                        }



/*************************************************************************
* Xxxxxxxxxxxxxxxxxxxxxxxxxx see below xxxxxxxxxxxxxxxxxxxxxxxxxxX
* X  Change the Mix to FM_NOTXORSRC to provide the illusion of   X
* X  Transparent water and the sun showing thru clouds.          X
* Xxxxxxxxxxxxxxxxxxxxxxxxxx see below xxxxxxxxxxxxxxxxxxxxxxxxxxX
*************************************************************************/


/*************************************************************************
*
*   Note from TSS.....Using FM_NOTXORSRC does not comply with
*                     with the restrictions as found in Appendix D
*                     of the PM Programming Reference.
*                     The only supported modes are:  FM_DEFAULT
*                                                    FM_OR
*                                                    FM_OVERPAINT
*                                                    FM_LEAVEALONE
*   commented out set mix.  Overpaint is default.
*
*************************************************************************/



// Make the clouds.

                if ( GpiSetColor(hPS, CLR_RED) == FALSE ) {
                        CLEANUP("GpiSetColor",EntryName);
                        return;
                        }

                inc.x = (3L*delta_x)/2L;
                inc.y = (11L*delta_y)/2L;
                MapPt(inc);

                if ( GpiBeginArea(hPS, BA_BOUNDARY | BA_WINDING) == FALSE ) {
                        CLEANUP("GpiBeginArea",EntryName);
                        return;
                        }

// Lobe one of three.

                if ( GpiMove(hPS, &inc ) == FALSE ) {
                        CLEANUP("GpiMove",EntryName);
                        return;
                        }

                aptlArc[0].x = (9L*delta_x)/4L;
                aptlArc[0].y = (11L*delta_y)/2L;
                aptlArc[1].x = (3L*delta_x)/2L;
                aptlArc[1].y = (21L*delta_y)/4L;
                MapPt(aptlArc[0]);
                MapPt(aptlArc[1]);

                if ( GpiPointArc(hPS, aptlArc ) != GPI_OK ) {
                        CLEANUP("GpiPointArc",EntryName);
                        return;
                        }

// Lobe two of three

                aptlArc[0].x = (5L*delta_x)/4L;
                aptlArc[0].y = (10L*delta_y)/2L;
                aptlArc[1].x = (2L*delta_x)/2L;
                aptlArc[1].y = (21L*delta_y)/4L;
                MapPt(aptlArc[0]);
                MapPt(aptlArc[1]);

                if ( GpiPointArc(hPS, aptlArc ) != GPI_OK ) {
                        CLEANUP("GpiPointArc",EntryName);
                        return;
                        }
// Lobe three of three

                aptlArc[0].x = (2L*delta_x)/2L;
                aptlArc[0].y = (23L*delta_y)/4L;
                aptlArc[1].x = (3L*delta_x)/2L;
                aptlArc[1].y = (11L*delta_y)/2L;
                MapPt(aptlArc[0]);
                MapPt(aptlArc[1]);

                if ( GpiPointArc(hPS, aptlArc ) != GPI_OK ) {
                        CLEANUP("GpiPointArc",EntryName);
                        return;
                        }

                if ( GpiEndArea(hPS ) == FALSE ) {
                        CLEANUP("GpiEndArea",EntryName);
                        return;
                        }



// Make the boat.

                if ( GpiSetColor(hPS, CLR_DARKGRAY) == FALSE ) {
                        CLEANUP("GpiSetColor",EntryName);
                        return;
                        }
                inc.x = (4L*delta_x)/2L;
                inc.y = (13L*delta_y)/4L;
                MapPt(inc);

                if ( GpiBeginArea(hPS, BA_BOUNDARY | BA_WINDING) == FALSE ) {
                        CLEANUP("GpiBeginArea",EntryName);
                        return;
                        }

// Hull Bottom.

                if ( GpiMove(hPS, &inc ) == FALSE ) {
                        CLEANUP("GpiMove",EntryName);
                        return;
                        }
                inc.x = (5L*delta_x)/2L;
                inc.y = (5L*delta_y)/2L;
                MapPt(inc);

                if ( GpiLine(hPS, &inc ) == FALSE ) {
                        CLEANUP("GpiLine",EntryName);
                        return;
                        }


                aptlArc[0].x = (10L*delta_x)/2L;
                aptlArc[0].y = (5L*delta_y)/2L;
                aptlArc[1].x = (25L*delta_x)/4L;
                aptlArc[1].y = (15L*delta_y)/4L;
                MapPt(aptlArc[0]);
                MapPt(aptlArc[1]);

                if ( GpiPointArc(hPS, aptlArc ) != GPI_OK ) {
                        CLEANUP("GpiPointArc",EntryName);
                        return;
                        }

// Bow of Boat.

                inc.x = (47L*delta_x)/8L;
                inc.y = (13L*delta_y)/4L;
                MapPt(inc);

                if ( GpiLine(hPS, &inc ) == FALSE ) {
                        CLEANUP("GpiLine",EntryName);
                        return;
                        }

                if ( GpiEndArea(hPS ) == FALSE ) {
                        CLEANUP("GpiEndArea",EntryName);
                        return;
                        }

                SUBEXIT();
                EXIT_MAIN(EntryName);
                }
        return;
}
/****************************************************************************
 *\\ddd
 * Routine Name: Wave()
 *
 * Purpose:  Draw an 5", inverted, rectified Sine Wave
 *                               starting at the desired point.
 *
 *
 * System Requirements:  Section 6.3.2
 *
 * Revision Log:
 *                                        01/31/91, for pdvt, Program by David McCombs
 *
 * Inputs:
 *       hPS           -presentation space.
 *       hWndClient    -client window handle
 *       SelectionCall -selection indicator.
 *                      decrement     -offset from top of position pointer.
 *                      string            -textual COLOR value discription.
 *
 * Outputs:     BOOL Success
 *
 * Subroutines Required: None
 *
 * Limitations: None
 *
 *\\end
 ***************************************************************************/


/****************************************************************************
 *\\algorithm
 * {
 *
 *              Move to the starting position with GpiMove();
 *              For 500 loops{
 *                      Set Amplitude = - Absolute Value of (1/4 inch)*(sine(PI/100)) inches;
 *                      Move a point from the y basis to Amplitude;
 *                      Move a point from the x basis to (loop-1)*(1/100 inch) inches;
 *                      Use GpiLine to m                                Approximate ramp wave appearance: |\|\;
 *                              }
 *                      } // end for loop
 *              Move 1/4 inch from end of resulting sine wave;
 *              Output the color with WorldWriteString function;
 *              return BOOL Success;
 *
 * }
 *\\end
 ***************************************************************************/

BOOL Wave(HPS hPS, PPOINTL pHorizon, SHORT Width) {
        double halfperiod = 3.14157;
        double lfAmplitude;
        POINTL ptl, inc, basis;               // World coordinate points
        SHORT loopvar;
        basis.x = inc.x = pHorizon->x ;
        basis.y = inc.y = pHorizon->y ;
        ptl.x = inc.x ;
        ptl.y = inc.y ;
        MapPt(ptl);
        if (GpiMove(hPS, &ptl) == FALSE)
                return FALSE;
        for ( loopvar = 0; loopvar <= Width*100; loopvar += 5 ) {
                lfAmplitude=( (double) delta_y/4.0 )*( sin(halfperiod*loopvar/100.0) ) + 0.5;
                if (lfAmplitude > 0.0) lfAmplitude = -lfAmplitude;

                // One inch per 100 increments of loopvar
                inc.x = (loopvar*delta_x )/100;
                inc.y = (LONG) lfAmplitude;
                ptl.x = inc.x + basis.x;
                ptl.y = inc.y + basis.y;
                MapPt(ptl);
                GpiLine(hPS, &ptl);
                }
        return TRUE;
}



/****************************************************************************
 *\\ddd
 * Routine Name: GpiColorExh()
 *
 * Purpose:  This is an entry point for the PTT that causes Gpi
 *                               Color precision tests to be run.
 *
 *
 * System Requirements:  Section 6.3.2
 *
 * Revision Log:
 *               01/24/91, pdvt, Template from Mike Abuzant
 *                                        01/31/91, pdvt, Program by David McCombs
 *
 * Inputs:
 *        hPS           -presentation space.
 *        hWndClient    -client window handle
 *        SelectionCall -selection indicator.
 *
 * Outputs:     Void
 *
 * Subroutines Required:
 *       BOOL SineGraph()
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/

/****************************************************************************
 *\\algorithm
 * {
 *      if (SelectionCall){
 *              WndSendMsg();
 *              }
 *      else {
 *              ENTER_MAIN();
 *              SUBENTER();
 *      for (all color values) {
 *                      GpiSetColor();
 *              SineGraph();
 *                      ERRSTATUS();
 *                      }
 *              SUBEXIT();
 *              EXIT_MAIN();
 *              return;
 *      }
 * }
 *\\end
 ***************************************************************************/

VOID APIENTRY GpiSetColorExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
        SHORT sColorNumber;

        SHORT sColorNumMax = sizeof(clr) / sizeof(clr[0]) ;
        if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else
        {
        ENTER_MAIN("GpiSetColorExh");
   (VOID)set_delta(hPS);
        GpiSetColor(hPS, CLR_BLACK);
   gpi_grid(hPS, (LONG) HALFINCH);
        GpiSetColor(hPS, CLR_BLACK);

        SUBENTER( GpiSetColor,"Color Values");

        for ( sColorNumber = 0 ; sColorNumber < sColorNumMax ; sColorNumber++ )
                {

                strcpy(szAddMessage, clr[sColorNumber].szColorIndex);

                if ((GpiSetColor(hPS, clr[sColorNumber].lColorIndex)) == FALSE)
                        ErrorCount++;
                        ERRSTATUS(TRUE,"Color:",clr[sColorNumber].szColorIndex);

                if (SineGraph(hWndClient,hPS,sColorNumber,clr[sColorNumber].szColorIndex) == FALSE)
                        ERRSTATUS(FALSE,"SineGraph Failure","GpiSetColorExh");

                } // end for

                SUBEXIT();


        EXIT_MAIN("GpiSetColorExh");

        } // end else

  return;

} // end APIENTRY exhaustive test.


BOOL SineGraph(HWND hWndClient, HPS hPS, SHORT decrement , CHAR *string) {
        double halfperiod = 3.14157;
        double lfAmplitude;
        POINTL ptl, inc, basis;
        SHORT loopvar;

        basis.x = inc.x = 0 ;
        basis.y = inc.y = (LONG) ( (6.25 - (float) (decrement) / 4.0 ) * delta_y) ;
        ptl.x = inc.x ;
        ptl.y = inc.y ;
        MapPt(ptl);

        if (GpiMove(hPS, &ptl) == FALSE)
                return FALSE;

        for ( loopvar = 0; loopvar <= 500; loopvar += 5 ) {
                lfAmplitude=( (double) delta_y/2.0 )*( sin(halfperiod*loopvar/100.0) ) + 0.5;
                inc.x = (loopvar*delta_x )/100;
                inc.y = (LONG) lfAmplitude;
                ptl.x = inc.x + basis.x;
                ptl.y = inc.y + basis.y;
                MapPt(ptl);
                GpiLine(hPS, &ptl);
                }

        ptl.x = inc.x + basis.x + delta_x/4;
        ptl.y = inc.y + basis.y;
        MapPt(ptl);
        if (GpiSetColor(hPS, CLR_BLACK) == FALSE ||     GpiLine(hPS, &ptl) == FALSE)
                return FALSE;

        WorldWriteString(ptl.x, ptl.y, string);
        return TRUE;
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiSetMixExh1()
 *
 * Purpose:  This is an entry point for the PTT that tests
 *                               the GpiSetmix function exhaustively.
 *
 *
 * System Requirements:
 *
 * Revision Log:
 *               01/24/91, pdvt, David McCombs
 *               06/22/91, - modified by Vish (Boca)
 *                         - moved GpiSetPattern inside FOR loop.
 *
 * Inputs:
 *        hPS           -presentation space.
 *        hWndClient    -client window handle
 *        SelectionCall -selection indicator.
 *
 * Outputs:     Void
 *
 * Subroutines Required: none
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 * {
 *      if (SelectionCall)
 *              WndSendMsg()
 *              }
 *      else {
 *                SUBENTER
 *                      Get Output Device position for graphics:
 *                      For 5 different colors {
 *                              SETENTER
 *                               GpiSetPattern(
 *                               Log
 *                              SETEXIT;
 *                              Make diagonal boxes using the following functions
 *                                      GpiSetColor();
 *                                        Log error status with ERRSTATUS();
 *                                      GpiMove();
 *                                      GpiBeginArea();
 *                                      GpiEndArea();
 *                                      GpiEndArea();
 *                                      Decrement display position;
 *                              }
 *                SUBEXIT;
 *                SUBENTER Source Color and Logical Mix Test;
 *                      For 5 Logical Mixes and one source color {
 *                              SETENTER
 *                               GpiSetPattern(
 *                               Log
 *                              SETEXIT;
 *                              Make diagonal boxes using the following functions:
 *                                      GpiSetMix();
 *                                              Log error status with ERRSTATUS();
 *                                      GpiMove();
 *                                      GpiBeginArea();
 *                                      GpiPolyLine();
 *                                      GpiEndArea();
 *                                      GpiSetMix(FM_DEFAULT);
 *                                      GpiPolyLine();
 *                                      Decrement display position;
 *                              }
 *                SUBEXIT;
 *                Additional Information Queried from DevQueryCaps;
 *                      Information output to the display to
 *                      indicate applicability of logical mix output.
 *
 *      } end else
 *      }
 *\\end
 ***************************************************************************/

VOID APIENTRY GpiSetMixExh1(HPS hPS, HWND hWndClient, BOOL SelectionCall)
{
        INT iValueLoop;
        static CHAR *szApiEntryName = "GpiSetMixExh1";
        double *padPoint;
        LONG lWidth, lYup, lXover, lTextover, lDevCap;
        POINTL pArray[5];
        HDC hdc;
                static struct {
                LONG lColorsIndex;
                CHAR *szColorsIndex;
                }
                FewColors[] = {
                        CLR_PINK       , "CLR_PINK       " ,
                        CLR_BLUE       , "CLR_BLUE       " ,
                        CLR_DARKGREEN   , "CLR_DARKGREEN  " ,
                        CLR_RED                 , "CLR_RED        " ,
                        CLR_BLACK               , "CLR_BLACK      "
                        } ;
        SHORT sFewClrsMax = sizeof(FewColors) / sizeof(FewColors[0]) ;


        static struct {
                LONG lMixIndex;
                CHAR *szMixIndex;
                }
                mix[] = {
                        FM_DEFAULT      , "FM_DEFAULT      " ,
                        FM_OR           , "FM_OR           " ,
                        FM_OVERPAINT    , "FM_OVERPAINT    " ,
                        FM_LEAVEALONE   , "FM_LEAVEALONE   " ,
                        FM_XOR          , "FM_XOR          " ,
                        } ;

        SHORT sMixMax = sizeof(mix) / sizeof(mix[0]) ;

        static double adPointArray[]= {
                3.0, 6.0,       // Start of Mix Area.
                5.5, 6.0,   // Start of Information     1.
                0.5, 1.0 }; // Discription of Source Color

        padPoint = adPointArray;

        if (SelectionCall) {
                WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
               *pBasisX = 10000;
               *pBasisY = 10000;
                } // end if
        else {

                ENTER_MAIN(szApiEntryName);

                lSpace = (LONG) ( 0.5 * ((double) delta_y));
                lWidth =        (LONG) ( 0.35 * ((double) delta_y));     // 0.25 for BM_MIX
                lYup =  (LONG) ( 2.5 * ((double) delta_y));
                lXover =        (LONG) ( 2.5 * ((double) delta_y));
                lTextover =     (LONG) ( 0.25 * ((double) delta_y));


                /***************************************************
                *
                * Put Target Colors on the Output Device
                *
                \**************************************************/

                SUBENTER(GpiSetMixExh1,"Target Colors" );

                GETX; GETY;       // point 1

                for (iValueLoop = 0; iValueLoop < 5; iValueLoop ++) {

                        if (GpiSetPattern(hPS, PATSYM_DENSE4)==FALSE)   //PATSYM_NOSHADE for BM_MIX
                          ErrorCount++;
                        ERRSTATUS(TRUE,szApiEntryName,"GpiSetPattern");

                        if ( GpiSetColor(hPS,FewColors[iValueLoop].lColorsIndex ) == FALSE )
                                ErrorCount++;
                        ERRSTATUS(TRUE,"Color:",FewColors[iValueLoop].szColorsIndex );

                        // LONG lWidth, lYup, lXover, lTextover.
                        pNearCorner.x=pPoint.x;
                        pNearCorner.y=pPoint.y;
                        pArray[0].x = pPoint.x;
                        pArray[0].y = pPoint.y + lWidth;            // go up lWidth.
                        pArray[1].x = pArray[0].x - lXover;
                        pArray[1].y = pArray[0].y - lYup;        // go down and left.
                        pArray[2].x = pArray[1].x;
                        pArray[2].y = pArray[1].y - lWidth;  // go down lWidth.
                        pArray[3].x = pArray[2].x + lXover;
                        pArray[3].y = pArray[2].y + lYup;        // go up and right.
                        pArray[4].x = pPoint.x;
                        pArray[4].y = pPoint.y;                                  // go home.
                        MapPt(pNearCorner);
                        MapPt(pArray[0]);
                        MapPt(pArray[1]);
                        MapPt(pArray[2]);
                        MapPt(pArray[3]);
                        GpiMove(hPS, &pNearCorner);
                        GpiBeginArea(hPS, BA_BOUNDARY | BA_WINDING);
                        GpiPolyLine(hPS, 4L, pArray);
                   GpiEndArea(hPS );
                        GpiSetColor(hPS, CLR_BLACK);
                        GpiPolyLine(hPS, 4L, pArray);
                        pTextPoint.x = pPoint.x+lTextover;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        WorldWriteString(pTextPoint.x, pTextPoint.y,FewColors[iValueLoop].szColorsIndex );
                        pPoint.y -= lSpace;

                        }
                SUBEXIT();

                /***************************************************
                *
                * Put Mix and Source Color on the Output Device
                *
                \**************************************************/

                SUBENTER(GpiSetMixExh1,"Source Color & Mix" );
                LOGINFO(L_LOTRACE,"*","Source Color = CLR_WHITE");
                for (iValueLoop = 0; iValueLoop < 5; iValueLoop++) {

                        if (GpiSetPattern(hPS, PATSYM_DENSE4)==FALSE)   //PATSYM_NOSHADE for BM_MIX
                          ErrorCount++;
                        ERRSTATUS(TRUE,szApiEntryName,"GpiSetPattern");
                        if ( GpiSetMix(hPS, mix[iValueLoop].lMixIndex ) == FALSE )
                                ErrorCount++;
                        ERRSTATUS(TRUE,"Mix:",mix[iValueLoop].szMixIndex);

                        if ( GpiQueryMix(hPS ) != mix[iValueLoop].lMixIndex )
                                ErrorCount++;
                        ERRSTATUS(TRUE,"GpiQueryMix:",mix[iValueLoop].szMixIndex);


                        if ( GpiSetColor(hPS,CLR_WHITE) == FALSE )
                                ErrorCount++;
                        ERRSTATUS(TRUE,"Color:","CLR_WHITE" );

                        pNearCorner.x=pPoint.x;
                        pNearCorner.y=pPoint.y;
                        pArray[0].x = pPoint.x;
                        pArray[0].y = pPoint.y + lWidth;            // go up lWidth.
                        pArray[1].x = pArray[0].x - lXover;
                        pArray[1].y = pArray[0].y + lYup;        // go up and left.
                        pArray[2].x = pArray[1].x;
                        pArray[2].y = pArray[1].y - lWidth;  // go down lWidth.
                        pArray[3].x = pArray[2].x + lXover;
                        pArray[3].y = pArray[2].y - lYup;        // go down and right.
                        pArray[4].x = pPoint.x;
                        pArray[4].y = pPoint.y;                                  // go home.
                        MapPt(pNearCorner);
                        MapPt(pArray[0]);
                        MapPt(pArray[1]);
                        MapPt(pArray[2]);
                        MapPt(pArray[3]);
                        GpiMove(hPS, &pNearCorner);
                        GpiBeginArea(hPS, BA_BOUNDARY | BA_WINDING);
                        GpiPolyLine(hPS, 4L, pArray);
                   GpiEndArea(hPS );
                        if ( GpiSetMix(hPS, FM_DEFAULT) == FALSE ) {
                        ErrorCount++;
                        ERRSTATUS(TRUE,"Mix:", "FM_DEFAULT");
                        }
                        GpiSetColor(hPS, CLR_BLACK);
                        GpiPolyLine(hPS, 4L, pArray);
                        pTextPoint.x = pPoint.x+lTextover;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        sprintf (szAddMessage,"%s",mix[iValueLoop].szMixIndex);
                WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage);
                        pPoint.y -= lSpace;
                        }
                SUBEXIT();

                /***************************************************
                *
                * Output Added information.
                *
                \**************************************************/

                GETX; GETY;      // point 2

                lSpace = (LONG) ( 0.25 * ((double) delta_y));

                /* DevQueryCaps for foreground Mix */

                hdc = GpiQueryDevice(hPS);
                DevQueryCaps(hdc, CAPS_FOREGROUND_MIX_SUPPORT, 1L , &lDevCap );
                pTextPoint.x = pPoint.x;
                pTextPoint.y = pPoint.y;
                MapPt(pTextPoint);
                sprintf(szAddMessage, "Device Mix capabilities.");
                WorldWriteString(pTextPoint.x, pTextPoint.y , szAddMessage);
                pPoint.y -= lSpace;

                pTextPoint.x = pPoint.x;
                pTextPoint.y = pPoint.y;
                MapPt(pTextPoint);
                sprintf(szAddMessage, "----------------------------");
                WorldWriteString(pTextPoint.x, pTextPoint.y , szAddMessage);
                pPoint.y -= lSpace;

                if (lDevCap >= 64) {
                        pTextPoint.x = pPoint.x;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        sprintf(szAddMessage, "FM_GENERAL_BOOLEAN capable");
                        WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage);
                        lDevCap -= 64;
                        pPoint.y -= lSpace;
                        }
                if (lDevCap >= 32) {
                        pTextPoint.x = pPoint.x;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        sprintf(szAddMessage, "FM_AND capable");
                        WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage);
                        lDevCap -= 32;
                        pPoint.y -= lSpace;
                        }
                if (lDevCap >= 16) {
                        pTextPoint.x = pPoint.x;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        sprintf(szAddMessage, "FM_LEAVEALONE capable");
                        WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage);
                        lDevCap -= 16;
                        pPoint.y -= lSpace;
                        }
                if (lDevCap >= 8) {
                        pTextPoint.x = pPoint.x;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        sprintf(szAddMessage, "FM_XOR capable");
                        WorldWriteString(pTextPoint.x, pTextPoint.y , szAddMessage);
                        lDevCap -= 8;
                        pPoint.y -= lSpace;
                        }
                if (lDevCap >= 2) {
                        pTextPoint.x = pPoint.x;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        sprintf(szAddMessage, "FM_OVERPAINT capable");
                        WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage);
                        lDevCap -= 2;
                        pPoint.y -= lSpace;
                        }
                if (lDevCap == 1) {
                        pTextPoint.x = pPoint.x;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        sprintf(szAddMessage, "FM_OR capable");
                        WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage)                      ;
                        pPoint.y -= lSpace;
                        }

                GETX; GETY;      // point 3

                pTextPoint.x = pPoint.x;
                pTextPoint.y = pPoint.y;
                MapPt(pTextPoint);
                sprintf(szAddMessage, "Source Color for mix operations is CLR_WHITE.");
                WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage)                      ;

                EXIT_MAIN(szApiEntryName);

                } // end else

        return;

} // end APIENTRY exhaustive test

/****************************************************************************
 *\\ddd
 * Routine Name: GpiSetMixExh2()
 *
 * Purpose:  This is an entry point for the PTT that tests
 *                               the GpiSetmix function exhaustively.
 *
 *
 * System Requirements:
 *
 * Revision Log:
 *               01/24/91, pdvt, David McCombs
 *               06/22/91, - modified by Vish (Boca)
 *                         - moved GpiSetPattern inside FOR loop.
 *
 * Inputs:
 *        hPS           -presentation space.
 *        hWndClient    -client window handle
 *        SelectionCall -selection indicator.
 *
 * Outputs:     Void
 *
 * Subroutines Required: none
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 * {
 *      if (SelectionCall)
 *              WndSendMsg()
 *              }
 *      else {
 *                SUBENTER
 *                      Get Output Device position for graphics:
 *                      For 5 different colors{
 *                              SETENTER
 *                               GpiSetPattern
 *                               Log
 *                              SETEXIT;
 *                              Make diagonal boxes using the following functions
 *                                      GpiSetColor();
 *                                        Log error status with ERRSTATUS();
 *                                      GpiMove();
 *                                      GpiBeginArea();
 *                                      GpiEndArea();
 *                                      GpiEndArea();
 *                                      Decrement display position;
 *                              }
 *                SUBEXIT;
 *                SUBENTER Source Color and Logical Mix Test;
 *                      For 5 Logical Mixes and one source color {
 *                              SETENTER
 *                               GpiSetPattern
 *                               Log
 *                              SETEXIT;
 *                              Make diagonal boxes using the following functions:
 *                                      GpiSetMix();
 *                                              Log error status with ERRSTATUS();
 *                                      GpiMove();
 *                                      GpiBeginArea();
 *                                      GpiPolyLine();
 *                                      GpiEndArea();
 *                                      GpiSetMix(FM_DEFAULT);
 *                                      GpiPolyLine();
 *                                      Decrement display position;
 *                              }
 *                SUBEXIT;
 *                Additional Information Queried from DevQueryCaps;
 *                      Information output to the display to
 *                      indicate applicability of logical mix output.
 *
 *      } end else
 *      }
 *\\end
 ***************************************************************************/

VOID APIENTRY GpiSetMixExh2(HPS hPS, HWND hWndClient, BOOL SelectionCall)
{
        INT iValueLoop;
        static CHAR *szApiEntryName = "GpiSetMixExh2";
        double *padPoint;
        LONG lWidth, lYup, lXover, lTextover, lDevCap;
        POINTL pArray[5];
        HDC hdc;
                        static struct {
                LONG lColorsIndex;
                CHAR *szColorsIndex;
                }
                FewColors[] = {
                        CLR_DARKBLUE   , "CLR_DARKBLUE   " ,
                        CLR_PALEGRAY   , "CLR_PALEGRAY   " ,
                        CLR_YELLOW              , "CLR_YELLOW     " ,
                        CLR_DARKRED             , "CLR_DARKRED    " ,
                        CLR_DARKGRAY    , "CLR_DARKGRAY   "
                        } ;
        SHORT sFewClrsMax = sizeof(FewColors) / sizeof(FewColors[0]) ;

        static struct {
                LONG lMixIndex;
                CHAR *szMixIndex;
                }
                mix[] = {
                        FM_AND          , "FM_AND          " ,
                        FM_SUBTRACT     , "FM_SUBTRACT     " ,
                        FM_MASKSRCNOT   , "FM_MASKSRCNOT   " ,
                        FM_ZERO         , "FM_ZERO         " ,
                        FM_NOTMERGESRC   ,      "FM_NOTMERGESRC  " ,
                        } ;

        SHORT sMixMax = sizeof(mix) / sizeof(mix[0]) ;

        static double adPointArray[]= {
                3.0, 6.0,       // Start of Mix Area.
                5.5, 6.0,   // Start of Information     1.
                0.5, 1.0 }; // Discription of Source Color

        padPoint = adPointArray;

        if (SelectionCall) {
                WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
               *pBasisX = 10000;
               *pBasisY = 10000;
                } // end if
        else {

                ENTER_MAIN(szApiEntryName);

                lSpace = (LONG) ( 0.5 * ((double) delta_y));
                lWidth =        (LONG) ( 0.35 * ((double) delta_y));     // 0.25 for BM_MIX
                lYup =  (LONG) ( 2.5 * ((double) delta_y));
                lXover =        (LONG) ( 2.5 * ((double) delta_y));
                lTextover =     (LONG) ( 0.25 * ((double) delta_y));




                /***************************************************
                *
                * Put Target Colors on the Output Device
                *
                \**************************************************/

                SUBENTER(GpiSetMixExh2,"Target Colors" );

                GETX; GETY;       // point 1

                for (iValueLoop = 0; iValueLoop < 5; iValueLoop ++) {

                        if (GpiSetPattern(hPS, PATSYM_DENSE4)==FALSE)   //PATSYM_NOSHADE for BM_MIX
                          ErrorCount++;
                        ERRSTATUS(TRUE,szApiEntryName,"GpiSetPattern");
                        if ( GpiSetColor(hPS,FewColors[iValueLoop].lColorsIndex ) == FALSE )
                                ErrorCount++;
                        ERRSTATUS(TRUE,"Color:",FewColors[iValueLoop].szColorsIndex );

                        // LONG lWidth, lYup, lXover, lTextover.
                        pNearCorner.x=pPoint.x;
                        pNearCorner.y=pPoint.y;
                        pArray[0].x = pPoint.x;
                        pArray[0].y = pPoint.y + lWidth;            // go up lWidth.
                        pArray[1].x = pArray[0].x - lXover;
                        pArray[1].y = pArray[0].y - lYup;        // go down and left.
                        pArray[2].x = pArray[1].x;
                        pArray[2].y = pArray[1].y - lWidth;  // go down lWidth.
                        pArray[3].x = pArray[2].x + lXover;
                        pArray[3].y = pArray[2].y + lYup;        // go up and right.
                        pArray[4].x = pPoint.x;
                        pArray[4].y = pPoint.y;                                  // go home.
                        MapPt(pNearCorner);
                        MapPt(pArray[0]);
                        MapPt(pArray[1]);
                        MapPt(pArray[2]);
                        MapPt(pArray[3]);
                        GpiMove(hPS, &pNearCorner);
                        GpiBeginArea(hPS, BA_BOUNDARY | BA_WINDING);
                        GpiPolyLine(hPS, 4L, pArray);
                   GpiEndArea(hPS );
                        GpiSetColor(hPS, CLR_BLACK);
                        GpiPolyLine(hPS, 4L, pArray);
                        pTextPoint.x = pPoint.x+lTextover;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        WorldWriteString(pTextPoint.x, pTextPoint.y,FewColors[iValueLoop].szColorsIndex );
                        pPoint.y -= lSpace;
                        }
                SUBEXIT();

                /***************************************************
                *
                * Put Mix and Source Color on the Output Device
                *
                \**************************************************/

                SUBENTER(GpiSetMixExh2,"Source Color & Mix" );
                LOGINFO(L_LOTRACE,"*","Source Color = CLR_BLUE");
                for (iValueLoop = 0; iValueLoop < 5; iValueLoop++) {

                        if (GpiSetPattern(hPS, PATSYM_DENSE4)==FALSE)   //PATSYM_NOSHADE for BM_MIX
                          ErrorCount++;
                        ERRSTATUS(TRUE,szApiEntryName,"GpiSetPattern");
                        if ( GpiSetMix(hPS, mix[iValueLoop].lMixIndex ) == FALSE )
                                ErrorCount++;
                        ERRSTATUS(TRUE,"Mix:",mix[iValueLoop].szMixIndex);

                        if ( GpiQueryMix(hPS ) != mix[iValueLoop].lMixIndex )
                                ErrorCount++;
                        ERRSTATUS(TRUE,"GpiQueryMix:",mix[iValueLoop].szMixIndex);

                        if ( GpiSetColor(hPS,CLR_BLUE) == FALSE )
                                ErrorCount++;
                        ERRSTATUS(TRUE,"Color:","CLR_BLUE" );

                        pNearCorner.x=pPoint.x;
                        pNearCorner.y=pPoint.y;
                        pArray[0].x = pPoint.x;
                        pArray[0].y = pPoint.y + lWidth;            // go up lWidth.
                        pArray[1].x = pArray[0].x - lXover;
                        pArray[1].y = pArray[0].y + lYup;        // go up and left.
                        pArray[2].x = pArray[1].x;
                        pArray[2].y = pArray[1].y - lWidth;  // go down lWidth.
                        pArray[3].x = pArray[2].x + lXover;
                        pArray[3].y = pArray[2].y - lYup;        // go down and right.
                        pArray[4].x = pPoint.x;
                        pArray[4].y = pPoint.y;                                  // go home.
                        MapPt(pNearCorner);
                        MapPt(pArray[0]);
                        MapPt(pArray[1]);
                        MapPt(pArray[2]);
                        MapPt(pArray[3]);
                        GpiMove(hPS, &pNearCorner);
                        GpiBeginArea(hPS, BA_BOUNDARY | BA_WINDING);
                        GpiPolyLine(hPS, 4L, pArray);
                   GpiEndArea(hPS );
                        if ( GpiSetMix(hPS, FM_DEFAULT) == FALSE ) {
                        ErrorCount++;
                        ERRSTATUS(TRUE,"Mix:", "FM_DEFAULT");
                        }
                        GpiSetColor(hPS, CLR_BLACK);
                        GpiPolyLine(hPS, 4L, pArray);
                        pTextPoint.x = pPoint.x+lTextover;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        sprintf (szAddMessage,"%s",mix[iValueLoop].szMixIndex);
                WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage);
                        pPoint.y -= lSpace;
                        }
                SUBEXIT();


                /***************************************************
                *
                * Output Added information.
                *
                \**************************************************/

                GETX; GETY;      // point 2

                lSpace = (LONG) ( 0.25 * ((double) delta_y));

                /* DevQueryCaps for foreground Mix */

                hdc = GpiQueryDevice(hPS);
                DevQueryCaps(hdc, CAPS_FOREGROUND_MIX_SUPPORT, 1L , &lDevCap );
                pTextPoint.x = pPoint.x;
                pTextPoint.y = pPoint.y;
                MapPt(pTextPoint);
                sprintf(szAddMessage, "Device Mix capabilities.");
                WorldWriteString(pTextPoint.x, pTextPoint.y , szAddMessage);
                pPoint.y -= lSpace;

                pTextPoint.x = pPoint.x;
                pTextPoint.y = pPoint.y;
                MapPt(pTextPoint);
                sprintf(szAddMessage, "----------------------------");
                WorldWriteString(pTextPoint.x, pTextPoint.y , szAddMessage);
                pPoint.y -= lSpace;

                if (lDevCap >= 64) {
                        pTextPoint.x = pPoint.x;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        sprintf(szAddMessage, "FM_GENERAL_BOOLEAN capable");
                        WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage);
                        lDevCap -= 64;
                        pPoint.y -= lSpace;
                        }
                if (lDevCap >= 32) {
                        pTextPoint.x = pPoint.x;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        sprintf(szAddMessage, "FM_AND capable");
                        WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage);
                        lDevCap -= 32;
                        pPoint.y -= lSpace;
                        }
                if (lDevCap >= 16) {
                        pTextPoint.x = pPoint.x;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        sprintf(szAddMessage, "FM_LEAVEALONE capable");
                        WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage);
                        lDevCap -= 16;
                        pPoint.y -= lSpace;
                        }
                if (lDevCap >= 8) {
                        pTextPoint.x = pPoint.x;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        sprintf(szAddMessage, "FM_XOR capable");
                        WorldWriteString(pTextPoint.x, pTextPoint.y , szAddMessage);
                        lDevCap -= 8;
                        pPoint.y -= lSpace;
                        }
                if (lDevCap >= 2) {
                        pTextPoint.x = pPoint.x;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        sprintf(szAddMessage, "FM_OVERPAINT capable");
                        WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage);
                        lDevCap -= 2;
                        pPoint.y -= lSpace;
                        }
                if (lDevCap == 1) {
                        pTextPoint.x = pPoint.x;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        sprintf(szAddMessage, "FM_OR capable");
                        WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage)                      ;
                        pPoint.y -= lSpace;
                        }

                GETX; GETY;      // point 3

                pTextPoint.x = pPoint.x;
                pTextPoint.y = pPoint.y;
                MapPt(pTextPoint);
                sprintf(szAddMessage, "Source Color for mix operations is CLR_BLUE.");
                WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage)                      ;

                EXIT_MAIN(szApiEntryName);

                } // end else

        return;

} // end APIENTRY exhaustive test

/****************************************************************************
 *\\ddd
 * Routine Name: GpiSetMixExh3()
 *
 * Purpose:  This is an entry point for the PTT that tests
 *                               the GpiSetmix function exhaustively.
 *
 *
 * System Requirements:
 *
 * Revision Log:
 *               01/24/91, pdvt, David McCombs
 *               06/22/91, - modified by Vish (Boca)
 *                         - moved GpiSetPattern inside FOR loop.
 *
 * Inputs:
 *        hPS           -presentation space.
 *        hWndClient    -client window handle
 *        SelectionCall -selection indicator.
 *
 * Outputs:     Void
 *
 * Subroutines Required: none
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 * {
 *      if (SelectionCall)
 *              WndSendMsg()
 *              }
 *      else {
 *                SUBENTER
 *                      Get Output Device position for graphics:
 *                      For 5 different colors{
 *                              SETENTER
 *                               GpiSetPattern
 *                               Log
 *                              SETEXIT;
 *                              Make diagonal boxes using the following functions
 *                                      GpiSetColor();
 *                                        Log error status with ERRSTATUS();
 *                                      GpiMove();
 *                                      GpiBeginArea();
 *                                      GpiEndArea();
 *                                      GpiEndArea();
 *                                      Decrement display position;
 *                              }
 *                SUBEXIT;
 *                SUBENTER Source Color and Logical Mix Test;
 *                      For 5 Logical Mixes and one source color {
 *                              SETENTER
 *                               GpiSetPattern
 *                               Log
 *                              SETEXIT;
 *                              Make diagonal boxes using the following functions:
 *                                      GpiSetMix();
 *                                              Log error status with ERRSTATUS();
 *                                      GpiMove();
 *                                      GpiBeginArea();
 *                                      GpiPolyLine();
 *                                      GpiEndArea();
 *                                      GpiSetMix(FM_DEFAULT);
 *                                      GpiPolyLine();
 *                                      Decrement display position;
 *                              }
 *                SETEXIT;
 *                Additional Information Queried from DevQueryCaps;
 *                      Information output to the display to
 *                      indicate applicability of logical mix output.
 *
 *      } end else
 *      }
 *\\end
 ***************************************************************************/

VOID APIENTRY GpiSetMixExh3(HPS hPS, HWND hWndClient, BOOL SelectionCall)
{
        INT iValueLoop;
        static CHAR *szApiEntryName = "GpiSetMixExh3";
        double *padPoint;
        LONG lWidth, lYup, lXover, lTextover, lDevCap;
        POINTL pArray[5];
        HDC hdc;
                        static struct {
                LONG lColorsIndex;
                CHAR *szColorsIndex;
                }
                FewColors[] = {
                        CLR_DARKGREEN  , "CLR_DARKGREEN  " ,
                        CLR_DARKBLUE   , "CLR_DARKBLUE   " ,
                        CLR_DARKRED    , "CLR_DARKRED    " ,
                        CLR_PINK                        , "CLR_PINK       " ,
                        CLR_BLACK               , "CLR_BLACK     "
                        } ;
        SHORT sFewClrsMax = sizeof(FewColors) / sizeof(FewColors[0]) ;


        static struct {
                LONG lMixIndex;
                CHAR *szMixIndex;
                }
                mix[] = {
                        FM_NOTXORSRC    , "FM_NOTXORSRC    " ,
                        FM_INVERT       , "FM_INVERT       " ,
                FM_MERGESRCNOT  , "FM_MERGESRCNOT  " ,
                        FM_NOTCOPYSRC   , "FM_NOTCOPYSRC   " ,
                        FM_MERGENOTSRC  , "FM_MERGENOTSRC  " ,
                        } ;

        SHORT sMixMax = sizeof(mix) / sizeof(mix[0]) ;

        static double adPointArray[]= {
                3.0, 6.0,       // Start of Mix Area.
                5.5, 6.0,   // Start of Information     1.
                0.5, 1.0 }; // Discription of Source Color

        padPoint = adPointArray;

        if (SelectionCall) {
                WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
               *pBasisX = 10000;
               *pBasisY = 10000;
                } // end if
        else {

                ENTER_MAIN(szApiEntryName);

                lSpace = (LONG) ( 0.5 * ((double) delta_y));
                lWidth =        (LONG) ( 0.35 * ((double) delta_y));     // 0.25 for BM_MIX
                lYup =  (LONG) ( 2.5 * ((double) delta_y));
                lXover =        (LONG) ( 2.5 * ((double) delta_y));
                lTextover =     (LONG) ( 0.25 * ((double) delta_y));


                /***************************************************
                *
                * Put Target Colors on the Output Device
                *
                \**************************************************/

                SUBENTER(GpiSetMixExh3,"Target Colors" );

                GETX; GETY;       // point 1

                for (iValueLoop = 0; iValueLoop < 5; iValueLoop ++) {
                        if (GpiSetPattern(hPS, PATSYM_DENSE4)==FALSE)   //PATSYM_NOSHADE for BM_MIX
                          ErrorCount++;
                        ERRSTATUS(TRUE,szApiEntryName,"GpiSetPattern");
                        if ( GpiSetColor(hPS,FewColors[iValueLoop].lColorsIndex ) == FALSE )
                                ErrorCount++;
                        ERRSTATUS(TRUE,"Color:",FewColors[iValueLoop].szColorsIndex );

                        // LONG lWidth, lYup, lXover, lTextover.
                        pNearCorner.x=pPoint.x;
                        pNearCorner.y=pPoint.y;
                        pArray[0].x = pPoint.x;
                        pArray[0].y = pPoint.y + lWidth;            // go up lWidth.
                        pArray[1].x = pArray[0].x - lXover;
                        pArray[1].y = pArray[0].y - lYup;        // go down and left.
                        pArray[2].x = pArray[1].x;
                        pArray[2].y = pArray[1].y - lWidth;  // go down lWidth.
                        pArray[3].x = pArray[2].x + lXover;
                        pArray[3].y = pArray[2].y + lYup;        // go up and right.
                        pArray[4].x = pPoint.x;
                        pArray[4].y = pPoint.y;                                  // go home.
                        MapPt(pNearCorner);
                        MapPt(pArray[0]);
                        MapPt(pArray[1]);
                        MapPt(pArray[2]);
                        MapPt(pArray[3]);
                        GpiMove(hPS, &pNearCorner);
                        GpiBeginArea(hPS, BA_BOUNDARY | BA_WINDING);
                        GpiPolyLine(hPS, 4L, pArray);
                   GpiEndArea(hPS );
                        GpiSetColor(hPS, CLR_BLACK);
                        GpiPolyLine(hPS, 4L, pArray);
                        pTextPoint.x = pPoint.x+lTextover;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        WorldWriteString(pTextPoint.x, pTextPoint.y,FewColors[iValueLoop].szColorsIndex );
                        pPoint.y -= lSpace;
                        }
                SUBEXIT();

                /***************************************************
                *
                * Put Mix and Source Color on the Output Device
                *
                \**************************************************/

                SUBENTER(GpiSetMixExh3,"Source Color & Mix" );
                LOGINFO(L_LOTRACE,"*","Source Color = CLR_DARKGREEN");
                for (iValueLoop = 0; iValueLoop < 5; iValueLoop++) {

                        if (GpiSetPattern(hPS, PATSYM_DENSE4)==FALSE)   //PATSYM_NOSHADE for BM_MIX
                          ErrorCount++;
                        ERRSTATUS(TRUE,szApiEntryName,"GpiSetPattern");
                        if ( GpiSetMix(hPS, mix[iValueLoop].lMixIndex ) == FALSE )
                                ErrorCount++;
                        ERRSTATUS(TRUE,"Mix:",mix[iValueLoop].szMixIndex);

                        if ( GpiQueryMix(hPS ) != mix[iValueLoop].lMixIndex )
                                ErrorCount++;
                        ERRSTATUS(TRUE,"GpiQueryMix:",mix[iValueLoop].szMixIndex);

                        if ( GpiSetColor(hPS,CLR_DARKGREEN) == FALSE )
                                ErrorCount++;
                        ERRSTATUS(TRUE,"Color:", "CLR_DARKGREEN" );


                        pNearCorner.x=pPoint.x;
                        pNearCorner.y=pPoint.y;
                        pArray[0].x = pPoint.x;
                        pArray[0].y = pPoint.y + lWidth;            // go up lWidth.
                        pArray[1].x = pArray[0].x - lXover;
                        pArray[1].y = pArray[0].y + lYup;        // go up and left.
                        pArray[2].x = pArray[1].x;
                        pArray[2].y = pArray[1].y - lWidth;  // go down lWidth.
                        pArray[3].x = pArray[2].x + lXover;
                        pArray[3].y = pArray[2].y - lYup;        // go down and right.
                        pArray[4].x = pPoint.x;
                        pArray[4].y = pPoint.y;                                  // go home.
                        MapPt(pNearCorner);
                        MapPt(pArray[0]);
                        MapPt(pArray[1]);
                        MapPt(pArray[2]);
                        MapPt(pArray[3]);
                        GpiMove(hPS, &pNearCorner);
                        GpiBeginArea(hPS, BA_BOUNDARY | BA_WINDING);
                        GpiPolyLine(hPS, 4L, pArray);
                   GpiEndArea(hPS );
                        if ( GpiSetMix(hPS, FM_DEFAULT) == FALSE ) {
                        ErrorCount++;
                        ERRSTATUS(TRUE,"Mix:", "FM_DEFAULT");
                        }
                        GpiSetColor(hPS, CLR_BLACK);
                        GpiPolyLine(hPS, 4L, pArray);
                        pTextPoint.x = pPoint.x+lTextover;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        sprintf (szAddMessage,"%s",mix[iValueLoop].szMixIndex);
                WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage);
                        pPoint.y -= lSpace;
                        }
                SUBEXIT();

                /***************************************************
                *
                * Output Added information.
                *
                \**************************************************/

                GETX; GETY;      // point 2

                lSpace = (LONG) ( 0.25 * ((double) delta_y));

                /* DevQueryCaps for foreground Mix */

                hdc = GpiQueryDevice(hPS);
                DevQueryCaps(hdc, CAPS_FOREGROUND_MIX_SUPPORT, 1L , &lDevCap );
                pTextPoint.x = pPoint.x;
                pTextPoint.y = pPoint.y;
                MapPt(pTextPoint);
                sprintf(szAddMessage, "Device Mix capabilities.");
                WorldWriteString(pTextPoint.x, pTextPoint.y , szAddMessage);
                pPoint.y -= lSpace;

                pTextPoint.x = pPoint.x;
                pTextPoint.y = pPoint.y;
                MapPt(pTextPoint);
                sprintf(szAddMessage, "----------------------------");
                WorldWriteString(pTextPoint.x, pTextPoint.y , szAddMessage);
                pPoint.y -= lSpace;

                if (lDevCap >= 64) {
                        pTextPoint.x = pPoint.x;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        sprintf(szAddMessage, "FM_GENERAL_BOOLEAN capable");
                        WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage);
                        lDevCap -= 64;
                        pPoint.y -= lSpace;
                        }
                if (lDevCap >= 32) {
                        pTextPoint.x = pPoint.x;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        sprintf(szAddMessage, "FM_AND capable");
                        WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage);
                        lDevCap -= 32;
                        pPoint.y -= lSpace;
                        }
                if (lDevCap >= 16) {
                        pTextPoint.x = pPoint.x;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        sprintf(szAddMessage, "FM_LEAVEALONE capable");
                        WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage);
                        lDevCap -= 16;
                        pPoint.y -= lSpace;
                        }
                if (lDevCap >= 8) {
                        pTextPoint.x = pPoint.x;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        sprintf(szAddMessage, "FM_XOR capable");
                        WorldWriteString(pTextPoint.x, pTextPoint.y , szAddMessage);
                        lDevCap -= 8;
                        pPoint.y -= lSpace;
                        }
                if (lDevCap >= 2) {
                        pTextPoint.x = pPoint.x;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        sprintf(szAddMessage, "FM_OVERPAINT capable");
                        WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage);
                        lDevCap -= 2;
                        pPoint.y -= lSpace;
                        }
                if (lDevCap == 1) {
                        pTextPoint.x = pPoint.x;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        sprintf(szAddMessage, "FM_OR capable");
                        WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage)                      ;
                        pPoint.y -= lSpace;
                        }

                GETX; GETY;      // point 3

                pTextPoint.x = pPoint.x;
                pTextPoint.y = pPoint.y;
                MapPt(pTextPoint);
                sprintf(szAddMessage, "Source Color for mix operations is CLR_DARKGREEN.");
                WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage)                      ;

                EXIT_MAIN(szApiEntryName);

                } // end else

        return;

} // end APIENTRY exhaustive test

/****************************************************************************
 *\\ddd
 * Routine Name: GpiSetMixExh4()
 *
 * Purpose:  This is an entry point for the PTT that tests
 *                               the GpiSetmix function exhaustively.
 *
 *
 * System Requirements:
 *
 * Revision Log:
 *               01/24/91, pdvt, David McCombs
 *               06/22/91, - modified by Vish (Boca)
 *                         - moved GpiSetPattern inside FOR loop.
 *
 * Inputs:
 *        hPS           -presentation space.
 *        hWndClient    -client window handle
 *        SelectionCall -selection indicator.
 *
 * Outputs:     Void
 *
 * Subroutines Required: none
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 * {
 *      if (SelectionCall)
 *              WndSendMsg()
 *              }
 *      else {
 *                SUBENTER
 *                      Get Output Device position for graphics:
 *                      For 5 different colors {
 *                              SETENTER
 *                               GpiSetPattern
 *                               Log
 *                              SETEXIT;
 *                              Make diagonal boxes using the following functions
 *                                      GpiSetColor();
 *                                        Log error status with ERRSTATUS();
 *                                      GpiMove();
 *                                      GpiBeginArea();
 *                                      GpiEndArea();
 *                                      GpiEndArea();
 *                                      Decrement display position;
 *                              }
 *                SUBEXIT;
 *                SUBENTER Source Color and Logical Mix Test;
 *                      For 5 Logical Mixes and one source color {
 *                              SETENTER
 *                               GpiSetPattern
 *                               Log
 *                              SETEXIT;
 *                              Make diagonal boxes using the following functions:
 *                                      GpiSetMix();
 *                                              Log error status with ERRSTATUS();
 *                                      GpiMove();
 *                                      GpiBeginArea();
 *                                      GpiPolyLine();
 *                                      GpiEndArea();
 *                                      GpiSetMix(FM_DEFAULT);
 *                                      GpiPolyLine();
 *                                      Decrement display position;
 *                              }
 *                SUBEXIT;
 *                Additional Information Queried from DevQueryCaps;
 *                      Information output to the display to
 *                      indicate applicability of logical mix output.
 *
 *      } end else
 *      }
 *\\end
 ***************************************************************************/

VOID APIENTRY GpiSetMixExh4(HPS hPS, HWND hWndClient, BOOL SelectionCall)
{
        INT iValueLoop;
        static CHAR *szApiEntryName = "GpiSetMixExh4";
        double *padPoint;
        LONG lWidth, lYup, lXover, lTextover, lDevCap;
        POINTL pArray[5];
        HDC hdc;
                        static struct {
                LONG lColorsIndex;
                CHAR *szColorsIndex;
                }
                FewColors[] = {
                        CLR_YELLOW     , "CLR_YELLOW     " ,
                        CLR_BLUE       , "CLR_BLUE       " ,
                        CLR_GREEN               , "CLR_GREEN      " ,
                        CLR_RED                 , "CLR_RED        " ,
                        CLR_BLACK               , "CLR_BLACK     "
                        } ;
        SHORT sFewClrsMax = sizeof(FewColors) / sizeof(FewColors[0]) ;

        static struct {
                LONG lMixIndex;
                CHAR *szMixIndex;
                }
                mix[] = {
                        FM_OR           , "FM_OR           " ,
                        FM_XOR          , "FM_XOR          " ,
                        FM_AND          , "FM_AND          " ,
                        FM_NOTMASKSRC    , "FM_NOTMASKSRC   " ,
                        FM_ONE          , "FM_ONE          "
                        } ;

        SHORT sMixMax = sizeof(mix) / sizeof(mix[0]) ;

        static double adPointArray[]= {
                3.0, 6.0,       // Start of Mix Area.
                5.5, 6.0,   // Start of Information     1.
                0.5, 1.0 }; // Discription of Source Color

        padPoint = adPointArray;

        if (SelectionCall) {
                WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
               *pBasisX = 10000;
               *pBasisY = 10000;
                } // end if
        else {

                ENTER_MAIN(szApiEntryName);

                lSpace = (LONG) ( 0.5 * ((double) delta_y));
                lWidth =        (LONG) ( 0.35 * ((double) delta_y));     // 0.25 for BM_MIX
                lYup =  (LONG) ( 2.5 * ((double) delta_y));
                lXover =        (LONG) ( 2.5 * ((double) delta_y));
                lTextover =     (LONG) ( 0.25 * ((double) delta_y));


                /***************************************************
                *
                * Put Target Colors on the Output Device
                *
                \**************************************************/

                SUBENTER(GpiSetMixExh4,"Target Colors" );

                GETX; GETY;       // point 1

                for (iValueLoop = 0; iValueLoop < 5; iValueLoop ++) {
                        if (GpiSetPattern(hPS, PATSYM_DENSE4)==FALSE)   //PATSYM_NOSHADE for BM_MIX
                          ErrorCount++;
                        ERRSTATUS(TRUE,szApiEntryName,"GpiSetPattern");
                        if ( GpiSetColor(hPS,FewColors[iValueLoop].lColorsIndex ) == FALSE )
                                ErrorCount++;
                        ERRSTATUS(TRUE,"Color:",FewColors[iValueLoop].szColorsIndex );

                        pNearCorner.x=pPoint.x;
                        pNearCorner.y=pPoint.y;
                        pArray[0].x = pPoint.x;
                        pArray[0].y = pPoint.y + lWidth;            // go up lWidth.
                        pArray[1].x = pArray[0].x - lXover;
                        pArray[1].y = pArray[0].y - lYup;        // go down and left.
                        pArray[2].x = pArray[1].x;
                        pArray[2].y = pArray[1].y - lWidth;  // go down lWidth.
                        pArray[3].x = pArray[2].x + lXover;
                        pArray[3].y = pArray[2].y + lYup;        // go up and right.
                        pArray[4].x = pPoint.x;
                        pArray[4].y = pPoint.y;                                  // go home.
                        MapPt(pNearCorner);
                        MapPt(pArray[0]);
                        MapPt(pArray[1]);
                        MapPt(pArray[2]);
                        MapPt(pArray[3]);
                        GpiMove(hPS, &pNearCorner);
                        GpiBeginArea(hPS, BA_BOUNDARY | BA_WINDING);
                        GpiPolyLine(hPS, 4L, pArray);
                   GpiEndArea(hPS );
                        GpiSetColor(hPS, CLR_BLACK);
                        GpiPolyLine(hPS, 4L, pArray);
                        pTextPoint.x = pPoint.x+lTextover;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        WorldWriteString(pTextPoint.x, pTextPoint.y,FewColors[iValueLoop].szColorsIndex );
                        pPoint.y -= lSpace;
                        }
                SUBEXIT();

                /***************************************************
                *
                * Put Mix and Source Color on the Output Device
                *
                \**************************************************/

                SUBENTER(GpiSetMixExh1,"Source Color & Mix" );
                LOGINFO(L_LOTRACE,"*","Source Color = CLR_RED");
                for (iValueLoop = 0; iValueLoop < 5; iValueLoop++) {

                        if (GpiSetPattern(hPS, PATSYM_DENSE4)==FALSE)   //PATSYM_NOSHADE for BM_MIX
                          ErrorCount++;
                        ERRSTATUS(TRUE,szApiEntryName,"GpiSetPattern");
                        if ( GpiSetMix(hPS, mix[iValueLoop].lMixIndex ) == FALSE )
                                ErrorCount++;
                        ERRSTATUS(TRUE,"Mix:",mix[iValueLoop].szMixIndex);

                        if ( GpiQueryMix(hPS ) != mix[iValueLoop].lMixIndex )
                                ErrorCount++;
                        ERRSTATUS(TRUE,"GpiQueryMix:",mix[iValueLoop].szMixIndex);

                        if ( GpiSetColor(hPS,CLR_RED) == FALSE )
                                ErrorCount++;
                        ERRSTATUS(TRUE,"Color:","CLR_RED" );

                                pNearCorner.x=pPoint.x;
                        pNearCorner.y=pPoint.y;
                        pArray[0].x = pPoint.x;
                        pArray[0].y = pPoint.y + lWidth;            // go up lWidth.
                        pArray[1].x = pArray[0].x - lXover;
                        pArray[1].y = pArray[0].y + lYup;        // go up and left.
                        pArray[2].x = pArray[1].x;
                        pArray[2].y = pArray[1].y - lWidth;  // go down lWidth.
                        pArray[3].x = pArray[2].x + lXover;
                        pArray[3].y = pArray[2].y - lYup;        // go down and right.
                        pArray[4].x = pPoint.x;
                        pArray[4].y = pPoint.y;                                  // go home.
                        MapPt(pNearCorner);
                        MapPt(pArray[0]);
                        MapPt(pArray[1]);
                        MapPt(pArray[2]);
                        MapPt(pArray[3]);
                        GpiMove(hPS, &pNearCorner);
                        GpiBeginArea(hPS, BA_BOUNDARY | BA_WINDING);
                        GpiPolyLine(hPS, 4L, pArray);
                   GpiEndArea(hPS );
                        if ( GpiSetMix(hPS, FM_DEFAULT) == FALSE ) {
                        ErrorCount++;
                        ERRSTATUS(TRUE,"Mix:", "FM_DEFAULT");
                        }
                        GpiSetColor(hPS, CLR_BLACK);
                        GpiPolyLine(hPS, 4L, pArray);
                        pTextPoint.x = pPoint.x+lTextover;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        sprintf (szAddMessage,"%s",mix[iValueLoop].szMixIndex);
                WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage);
                        pPoint.y -= lSpace;
                        }
                SUBEXIT();

                /***************************************************
                *
                * Output Added information.
                *
                \**************************************************/

                GETX; GETY;      // point 2

                lSpace = (LONG) ( 0.25 * ((double) delta_y));

                /* DevQueryCaps for foreground Mix */

                hdc = GpiQueryDevice(hPS);
                DevQueryCaps(hdc, CAPS_FOREGROUND_MIX_SUPPORT, 1L , &lDevCap );
                pTextPoint.x = pPoint.x;
                pTextPoint.y = pPoint.y;
                MapPt(pTextPoint);
                sprintf(szAddMessage, "Device Mix capabilities.");
                WorldWriteString(pTextPoint.x, pTextPoint.y , szAddMessage);
                pPoint.y -= lSpace;

                pTextPoint.x = pPoint.x;
                pTextPoint.y = pPoint.y;
                MapPt(pTextPoint);
                sprintf(szAddMessage, "----------------------------");
                WorldWriteString(pTextPoint.x, pTextPoint.y , szAddMessage);
                pPoint.y -= lSpace;

                if (lDevCap >= 64) {
                        pTextPoint.x = pPoint.x;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        sprintf(szAddMessage, "FM_GENERAL_BOOLEAN capable");
                        WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage);
                        lDevCap -= 64;
                        pPoint.y -= lSpace;
                        }
                if (lDevCap >= 32) {
                        pTextPoint.x = pPoint.x;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        sprintf(szAddMessage, "FM_AND capable");
                        WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage);
                        lDevCap -= 32;
                        pPoint.y -= lSpace;
                        }
                if (lDevCap >= 16) {
                        pTextPoint.x = pPoint.x;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        sprintf(szAddMessage, "FM_LEAVEALONE capable");
                        WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage);
                        lDevCap -= 16;
                        pPoint.y -= lSpace;
                        }
                if (lDevCap >= 8) {
                        pTextPoint.x = pPoint.x;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        sprintf(szAddMessage, "FM_XOR capable");
                        WorldWriteString(pTextPoint.x, pTextPoint.y , szAddMessage);
                        lDevCap -= 8;
                        pPoint.y -= lSpace;
                        }
                if (lDevCap >= 2) {
                        pTextPoint.x = pPoint.x;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        sprintf(szAddMessage, "FM_OVERPAINT capable");
                        WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage);
                        lDevCap -= 2;
                        pPoint.y -= lSpace;
                        }
                if (lDevCap == 1) {
                        pTextPoint.x = pPoint.x;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        sprintf(szAddMessage, "FM_OR capable");
                        WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage)                      ;
                        pPoint.y -= lSpace;
                        }

                GETX; GETY;      // point 3

                pTextPoint.x = pPoint.x;
                pTextPoint.y = pPoint.y;
                MapPt(pTextPoint);
                sprintf(szAddMessage, "Source Color for mix operations is CLR_RED.");
                WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage)                      ;

                EXIT_MAIN(szApiEntryName);

                } // end else

        return;

} // end APIENTRY exhaustive test

/****************************************************************************
 *\\ddd
 *
 * Routine Name: GpiSetBackColor() exhaustive algorithm
 *
 * Purpose:
 *
 * System Requirements:
 *
 *      Revision Log: 02/19/91 Initial creation for pdvt, David McCombs
 *               01/22/91 Template from Mike Abuzant
 *               06/22/91, - modified by Vish (Boca)
 *                         - moved GpiSetPattern inside FOR loop.
 *
 * Inputs: hPS           -Presentations Space handle.
 *                        hWndClient    -Client Window handle.
 *         SelectionCall -Selection Indicator, is 0 if routine is selected.
 *
 * Outputs:
 *
 * Subroutines Required:
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *      if (SelectionCall){
 *              WndSendMsg();
 *              }
 *      else {
 *              ENTER_MAIN;
 *              Log beginning of Setup with SETENTER;
 *              Set the foreground Color to Black with GpiSetColor;
 *              Log end of Setup with SETEXIT;
 *              Log Beginning of item test with SUBENTER;
 *              for (all colors) {
 *                      Set the foreground mix to PATSYM NOSHADE with GpiSetPattern;
 *                      Call GpiSetBackColor(), testing for failure;
 *                      Log Failure status with ERRSTATUS;
 *                      Call GpiQueryBackColor(),
 *                              if return value is not equal to GpiSetBackColor, increment error;
 *                      Log Failure status with ERRSTATUS;
 *                      Output the Background Color as a background color filled box;
 *                      List Color Value of BackGround in the box to the right of the Box;
 *                      }
 *              Log end of item test with SUBEXIT;
 *              EXIT_MAIN;
 *       }  end of else
 *      return;
 *      }
 *\\end
 ***************************************************************************/

VOID APIENTRY GpiSetBackColorExh(HPS hPS, HWND hWndClient, BOOL SelectionCall)
{
        POINTL ptl, inc, basis;
        INT iValueLoop;
        static CHAR *szApiEntryName = "GpiSetBackColorExh() - Exhaustive Test";
        // [20];
        SHORT sColorNumMax = sizeof(clr) / sizeof(clr[0]) ;

        if (SelectionCall) {
                WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
               *pBasisX = 10000;
               *pBasisY = 10000;
                } // end if

        else {

                ENTER_MAIN(szApiEntryName);



                SUBENTER(GpiSetBackMixExh,"Background Color Testing");

           for (iValueLoop = 0; iValueLoop < sColorNumMax; iValueLoop++ )       {

                if ( GpiSetColor(hPS, CLR_BLACK) == FALSE ) {
                        SETEXIT();
                        CLEANUP("GpiSetColor()",szApiEntryName);
                        return;
                        } // end if

                if ( GpiSetPattern(hPS, PATSYM_NOSHADE) == FALSE ) {
                        SETEXIT();
                        CLEANUP("GpiSetPattern()",szApiEntryName);
                        return;
                        } // end if
                        strcpy(szAddMessage, clr[iValueLoop].szColorIndex);

                        if ( GpiSetBackMix(hPS, BM_OVERPAINT) == FALSE ){
                                ErrorCount++;
                                ERRSTATUS(TRUE, "GpiSetBackMix error", NULL );
                                }

                        if ((GpiSetBackColor(hPS, clr[iValueLoop].lColorIndex)) == FALSE)
                                ErrorCount++;
                        ERRSTATUS(TRUE,"Background Color:",szAddMessage);

                        if ((GpiQueryBackColor(hPS)) != clr[iValueLoop].lColorIndex) {
                                ErrorCount++;
                                ERRSTATUS(TRUE,"Query does not match Set", NULL);
                                } // end if


                        basis.x = 0L ;
                        basis.y = delta_y + (delta_y * ((LONG) iValueLoop + 1L ))/4L ;
                inc.x = 5L * delta_x ;
                        inc.y = delta_y + delta_y/8L + (delta_y * ((LONG) iValueLoop + 1L))/4L ;
                        MapPt(basis);
                        MapPt(inc);
                        GpiMove(hPS, &basis);

                        if ( GpiBox(hPS, DRO_OUTLINEFILL, &inc, 0L, 0L) != GPI_OK) {
                                ErrorCount++;
                                ERRSTATUS(TRUE,"GpiBox Error", NULL);
                                } // end if

                        basis.y = delta_y + (delta_y * ((LONG) iValueLoop + 1L))/4L ;
                inc.x = 5L * delta_x ;
                        ptl.x = inc.x + delta_x/4L;
                ptl.y = basis.y;
                MapPt(ptl);

                        if ( GpiSetBackMix(hPS, BM_DEFAULT) == FALSE ) {
                                ErrorCount++;
                                ERRSTATUS(TRUE, "GpiSetBackMix error", NULL );
                                } // end if

                        if (GpiSetColor(hPS, CLR_BLACK) == FALSE ) {
                                ErrorCount++;
                                ERRSTATUS(TRUE, "GpiSetColor error", NULL );
                                } // end if

                        if (GpiMove(hPS, &ptl) == FALSE)        {
                                ErrorCount++;
                                ERRSTATUS(TRUE, "GpiMove error", NULL );
                                } // end if

                        WorldWriteString(ptl.x, ptl.y, szAddMessage);

                        } // end for

                SUBEXIT();

                EXIT_MAIN(szApiEntryName);

                } // end else

        return;

} // end APIENTRY exhaustive test


/****************************************************************************
 *\\ddd
 *
 * Routine Name: GpiSetBackMix() exhaustive algorithm
 *
 * Purpose:
 *
 * System Requirements:
 *
 *      Revision Log: 02/19/91 Initial creation for pdvt, David McCombs
 *               01/22/91 Template from Mike Abuzant
 *               06/22/91, - modified by Vish (Boca)
 *                         - moved GpiSetPattern inside FOR loop.
 *
 * Inputs: hPS           -Presentations Space handle.
 *                        hWndClient    -Client Window handle.
 *         SelectionCall -Selection Indicator, is 0 if routine is selected.
 *
 * Outputs:
 *
 * Subroutines Required:
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/

/****************************************************************************
 *\\algorithm
 * {
 *      if (SelectionCall){
 *              WndSendMsg();
 *              }
 *      else {
 *              ENTER_MAIN();
 *              Log Beginning of setup with SETENTER();
 *              Log any GpiSetPattern errors with ERRSTATUS();
 *              Set the Background mix with GpiSetBackMix(BM_OVERPAINT);
 *              Log any GpiSetBackMix erors with ERRSTATUS();
 *              Set the foreground color with GpiSetColor(CLR_BLACK)
 *              Log end of setup with SETEXIT();
 *              SUBENTER();
 *                      For 5 different background colors;
 *                              Set the Pattern with GpiSetPattern(PATSYM_NOSHADE);
 *                              Make diagonal boxes using the following functions
 *                                      GpiSetBackColor();
 *                                        Log error status with ERRSTATUS();
 *                                      GpiMove();
 *                                      GpiBeginArea();
 *                                      GpiPolyLine();
 *                                      GpiEndArea();
 *                                      Decrement display position;
 *                              }
 *              SUBEXIT;
 *              SUBENTER Source Color and Logical Mix Test;
 *                      For 5 Logical Background Mixes and one source Background Color {
 *                              Set the Pattern with GpiSetPattern(PATSYM_NOSHADE);
 *                              Make diagonal boxes using the following functions:
 *                                      GpiSetBackMix();
 *                                              Log error status with ERRSTATUS();
 *                                      GpiMove();
 *                                      GpiBeginArea();
 *                                      GpiPolyLine();
 *                                      GpiEndArea();
 *                                      GpiMove(Text position);
 *                                      WorldWriteString(BackMix Value);
 *                                 Decrement display position;
 *                              }
 *              SUBEXIT;
 *              Additional Information Queried from DevQueryCaps;
 *              Information output to the display to
 *              indicate applicability of logical backmix output.
 *               } end else
 *      }
 *\\end
 ***************************************************************************/

VOID APIENTRY GpiSetBackMixExh(HPS hPS, HWND hWndClient, BOOL SelectionCall)
{
        LONG lDevBackMixCap;
        INT iValueLoop;
        static CHAR *szApiEntryName = "GpiSetBackMixExh";
        double *padPoint;
        LONG lWidth, lYup, lXover, lTextover;
        POINTL pArray[5];
        HDC hdc;
          static struct {
                LONG lColorsIndex;
                CHAR *szColorsIndex;
                }
                FewColors[] = {
                        CLR_WHITE      , "CLR_WHITE      " ,
                        CLR_BLUE       , "CLR_BLUE       " ,
                        CLR_GREEN               , "CLR_GREEN      " ,
                        CLR_DARKRED             , "CLR_DARKRED    " ,
                        CLR_BLACK               , "CLR_BLACK      "
                        } ;
        SHORT sFewClrsMax = sizeof(FewColors) / sizeof(FewColors[0]) ;

        static struct {
                LONG lMixIndex;
                CHAR *szMixIndex;
                }
                mix[] = {
                        BM_DEFAULT      , "BM_DEFAULT      " ,
                        BM_OVERPAINT    , "BM_OVERPAINT    " ,
                        BM_LEAVEALONE   , "BM_LEAVEALONE   " ,
                        BM_OR           , "BM_OR           " ,
                        BM_XOR          , "BM_XOR          "
                        } ;



        SHORT sMixMax = sizeof(mix) / sizeof(mix[0]) ;

        static double adPointArray[]= {
                3.0, 6.0,       // Start of Mix Area.
                5.5, 6.0,   // Start of Information     1.
                0.5, 1.0 }; // Discription of Source Color

        padPoint = adPointArray;

        if (SelectionCall) {
                WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
               *pBasisX = 10000;
               *pBasisY = 10000;
                } // end if
        else {

                ENTER_MAIN(szApiEntryName);

                lSpace = (LONG) ( 0.5 * ((double) delta_y));
                lWidth =        (LONG) ( 0.25 * ((double) delta_y));
                lYup =  (LONG) ( 2.5 * ((double) delta_y));
                lXover =        (LONG) ( 2.5 * ((double) delta_y));
                lTextover =     (LONG) ( 0.25 * ((double) delta_y));


                /***************************************************
                *
                * Put Target Colors on the Output Device
                *
                \**************************************************/

                SUBENTER(GpiSetMixExh1,"Target Colors" );

                GETX; GETY;                              // point 1

                for (iValueLoop = 0; iValueLoop < 5; iValueLoop ++) {
                       if (GpiSetPattern(hPS, PATSYM_NOSHADE)==FALSE)
                         ErrorCount++;
                       ERRSTATUS(TRUE,szApiEntryName,"GpiSetPattern");
                       if ( GpiSetBackMix(hPS, BM_OVERPAINT) == FALSE )
                         ErrorCount++;
                       ERRSTATUS(TRUE,szApiEntryName,"GpiSetBackMix");
                       if (GpiSetColor(hPS, CLR_BLACK) == FALSE )
                         ErrorCount++;
                       ERRSTATUS(TRUE,szApiEntryName,"GpiSetColor");
                       if ( GpiSetBackColor(hPS,FewColors[iValueLoop].lColorsIndex ) == FALSE )
                               ErrorCount++;
                       ERRSTATUS(TRUE,"Color:", FewColors[iValueLoop].szColorsIndex );

                        pNearCorner.x=pPoint.x;
                        pNearCorner.y=pPoint.y;
                        pArray[0].x = pPoint.x;
                        pArray[0].y = pPoint.y + lWidth;            // go up lWidth.
                        pArray[1].x = pArray[0].x - lXover;
                        pArray[1].y = pArray[0].y - lYup;        // go down and left.
                        pArray[2].x = pArray[1].x;
                        pArray[2].y = pArray[1].y - lWidth;  // go down lWidth.
                        pArray[3].x = pArray[2].x + lXover;
                        pArray[3].y = pArray[2].y + lYup;        // go up and right.
                        pArray[4].x = pPoint.x;
                        pArray[4].y = pPoint.y;                                  // go home.
                        MapPt(pNearCorner);
                        MapPt(pArray[0]);
                        MapPt(pArray[1]);
                        MapPt(pArray[2]);
                        MapPt(pArray[3]);
                        GpiMove(hPS, &pNearCorner);
                        GpiBeginArea(hPS, BA_BOUNDARY | BA_WINDING);
                        GpiPolyLine(hPS, 4L, pArray);
                        GpiEndArea(hPS );
                        pTextPoint.x = pPoint.x+lTextover;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        WorldWriteString(pTextPoint.x, pTextPoint.y,FewColors[iValueLoop].szColorsIndex );
                        pPoint.y -= lSpace;
                        }
                SUBEXIT();


                /*************************************************
                *
                * Set Constant background source color
                * for 5 mix operations:
                *
                **************************************************/

                if ( GpiSetBackColor(hPS, CLR_WHITE) == FALSE )
                        ErrorCount++;
                ERRSTATUS(TRUE,szApiEntryName,"GpiSetColor");

                /***************************************************
                *
                * Put BackMix and Source BackColor
                * on the Output Device
                *
                \**************************************************/

                SUBENTER(GpiSetMixExh1,"Source BackColor & BackMix" );
                LOGINFO(L_LOTRACE,"*","Source BackColor = CLR_WHITE");

                for (iValueLoop = 0; iValueLoop < 5; iValueLoop++) {

                       if (GpiSetPattern(hPS, PATSYM_NOSHADE)==FALSE)
                         ErrorCount++;
                       ERRSTATUS(TRUE,szApiEntryName,"GpiSetPattern");
                       if ( GpiSetBackMix(hPS, BM_OVERPAINT) == FALSE )
                         ErrorCount++;
                       ERRSTATUS(TRUE,szApiEntryName,"GpiSetBackMix");
                       if (GpiSetColor(hPS, CLR_BLACK) == FALSE )
                         ErrorCount++;
                       ERRSTATUS(TRUE,szApiEntryName,"GpiSetColor");
                        if ( GpiSetBackMix(hPS, mix[iValueLoop].lMixIndex ) == FALSE )
                                ErrorCount++;
                        ERRSTATUS(TRUE,"GpiSetBackMix:",mix[iValueLoop].szMixIndex);

                        if ( GpiQueryBackMix(hPS ) != mix[iValueLoop].lMixIndex  )
                                ErrorCount++;
                        ERRSTATUS(TRUE,"GpiQueryBackMix:",mix[iValueLoop].szMixIndex);

                        pNearCorner.x=pPoint.x;
                        pNearCorner.y=pPoint.y;
                        pArray[0].x = pPoint.x;
                        pArray[0].y = pPoint.y + lWidth;            // go up lWidth.
                        pArray[1].x = pArray[0].x - lXover;
                        pArray[1].y = pArray[0].y + lYup;        // go up and left.
                        pArray[2].x = pArray[1].x;
                        pArray[2].y = pArray[1].y - lWidth;  // go down lWidth.
                        pArray[3].x = pArray[2].x + lXover;
                        pArray[3].y = pArray[2].y - lYup;        // go up and right.
                        pArray[4].x = pPoint.x;
                        pArray[4].y = pPoint.y;                                  // go home.
                        MapPt(pNearCorner);
                        MapPt(pArray[0]);
                        MapPt(pArray[1]);
                        MapPt(pArray[2]);
                        MapPt(pArray[3]);
                        GpiMove(hPS, &pNearCorner);
                        GpiBeginArea(hPS, BA_BOUNDARY | BA_WINDING);
                        GpiPolyLine(hPS, 4L, pArray);
                        GpiEndArea(hPS );
                        pTextPoint.x = pPoint.x+lTextover;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        sprintf (szAddMessage,"%s",mix[iValueLoop].szMixIndex);
                        WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage);
                        pPoint.y -= lSpace;
                        } // end for()

                SUBEXIT();
                /* reset back mix to BM_OVERPAINT */

                GpiSetBackMix(hPS,BM_OVERPAINT);

                /***************************************************
                *
                * Output Added information.
                *
                \**************************************************/

                GETX; GETY;      // point 2

                lSpace = (LONG) ( 0.25 * ((double) delta_y));

                /*       DevQueryCaps for Back Mix */

                hdc = GpiQueryDevice(hPS);
                DevQueryCaps(hdc, CAPS_BACKGROUND_MIX_SUPPORT, 1L , &lDevBackMixCap );
                pTextPoint.x = pPoint.x;
                pTextPoint.y = pPoint.y;
                MapPt(pTextPoint);
                sprintf(szAddMessage, "Device BackMix capabilities.");
                WorldWriteString(pTextPoint.x, pTextPoint.y , szAddMessage);
                pPoint.y -= lSpace;

                pTextPoint.x = pPoint.x;
                pTextPoint.y = pPoint.y;
                MapPt(pTextPoint);
                sprintf(szAddMessage, "----------------------------");
                WorldWriteString(pTextPoint.x, pTextPoint.y , szAddMessage);
                pPoint.y -= lSpace;


                if (lDevBackMixCap >= 16) {
                        pTextPoint.x = pPoint.x;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        sprintf(szAddMessage, "BM_LEAVEALONE capable");
                        WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage);
                        lDevBackMixCap -= 16;
                        pPoint.y -= lSpace;
                        }
                if (lDevBackMixCap >= 8) {
                        pTextPoint.x = pPoint.x;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        sprintf(szAddMessage, "BM_XOR capable");
                        WorldWriteString(pTextPoint.x, pTextPoint.y , szAddMessage);
                        lDevBackMixCap -= 8;
                        pPoint.y -= lSpace;
                        }
                if (lDevBackMixCap >= 2) {
                        pTextPoint.x = pPoint.x;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        sprintf(szAddMessage, "BM_OVERPAINT capable");
                        WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage);
                        lDevBackMixCap -= 2;
                        pPoint.y -= lSpace;
                        }
                if (lDevBackMixCap == 1) {
                        pTextPoint.x = pPoint.x;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        sprintf(szAddMessage, "BM_OR capable");
                        WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage)                      ;
                        pPoint.y -= lSpace;
                        }

                GETX; GETY;      // point 3
                pTextPoint.x = pPoint.x;
                pTextPoint.y = pPoint.y;
                MapPt(pTextPoint);
                sprintf(szAddMessage, "Source Color for mix operations is CLR_WHITE.");
                WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage)                      ;


                EXIT_MAIN(szApiEntryName);

                } // end else

        return;

} // end APIENTRY exhaustive test


/****************************************************************************
 *\\ddd
 *
 * Routine Name: GpiCreateLogColorTable1() exhaustive algorithm
 *
 * Purpose:
 *
 * System Requirements:
 *
 *      Revision Log: XX/XX/XX Initial creation for pdvt, David McCombs
 *               01/22/91 Template from Mike Abuzant
 *
 * Inputs: hPS           -Presentations Space handle.
 *                        hWndClient    -Client Window handle.
 *         SelectionCall -Selection Indicator, is 0 if routine is selected.
 *
 * Outputs:
 *
 * Subroutines Required:
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 *{
 *      if (SelectionCall){
 *              WndSendMsg();
 *              }
 *      else {
 *       ENTER_MAIN();
 *       Get hDC;
 *       SETENTER(for dithering capability);
 *              GpiSetPattern(PATSYM_SOLID);
 *              GpiSetPatternSet(LCID_DEFAULT);
 *      SETEXIT();
 *      SUBENTER(for RGB case);
 *      GpiCreateLogColorTable(LCOL_RESET, LCOLF_RGB, 0L, 0L, NULL);
 *      ERRSTATUS();
 *      SUBEXIT();
 *      Draw Color Square:
 *              for ( R 0->255 ){
 *                      for ( B 0->255 ){
 *                              for ( G 0->255 ){
 *                                      RGB = R << 16 | G << 8 | B ;
 *                                      Put color box at RGBth Position of the color square;
 *                                      5 increment across for blue;
 *                                      5 increments up for red;
 *                                      25 increments green
 *                                              (cycles through 5 increments for each red value);
 *                                      }
 *                              }
 *                      }
 *      SUBENTER(for Index case);
 *      GpiCreateLogColorTable();
 *      GpiQueryLogColorTable();
 *      ERRSTATUS();
 *      SUBEXIT();
 *      Position screen pointer and output text and axis;
 *      SUBENTER();
 *      DevQueryCaps();
 *      if (DevCap means realizable) {
 *              GpiCreateLogColorTable();
 *              GpiRealizeColorTable();
 *              GpiUnrealizeColorTable();
 *              ERRSTATUS();
 *              }
 *      else {
 *              LOGINFO(Realize not supported);
 *              GpiCreateLogColorTable();
 *              GpiQueryLogColorTable();
 *              ERRSTATUS();
 *              }
 *      SUBEXIT();
 *      EXIT_MAIN();
 * }
 *}
 *\\end
 ***************************************************************************/

VOID APIENTRY GpiCreateLogColorTableExh1(HPS hPS, HWND hWndClient, BOOL SelectionCall)
{
        HDC hdc;
        SHORT sValueLoop, sLoopR, sLoopG, sLoopB ;
        ULONG R, G, B, RGB;
        POINTL ptl, inc, basis;
        static CHAR *szApiEntryName = "GpiCreateLogColorTableExh1";
        // [300];
        double *padPoint;
        LONG lClrDelX, lClrDelY, lTickLength, lDevCap;
        static LONG     lRange[] = { 0L, 50L, 100L, 150L, 255L };
        static COLOR clrRGBTab[] = { 0x00AFAFL, 0xAAAA00L,      // typedef COLOR = LONG
                                                                     0x0F0F0FL, 0xA000A0L
                                                                       };
        static double adPointArray[]= {
            2.0, 1.5,   // bottom left corner of color cube
                 1.5, 4.25,  // top of red axis
                 1.5, 1.5,       // intersection of red and blue axis
                 5.0, 1.5,   // intersection of blue and green axis
                 5.0, 4.25,  // top of green axis
                 5.25, 4.2,  // green text
                 5.25, 3.8,  // green 255 #1
                 5.25, 3.5,  // green 0   #1
                 5.25, 3.3,  // green 255 #2
                 5.25, 3.0,  // green 0   #2
                 5.25, 2.8,  // green 255 #3
                 5.25, 2.5,  // green 0   #3
                 5.25, 2.3,  // green 255 #4
                 5.25, 2.0,  // green 0   #4
                 5.25, 1.8,  // green 255 #5
                 5.25, 1.5,  // green 0   #5
                 4.5, 1.0,   // blue text
                 3.8, 1.0,   // blue 255
                 3.3, 1.0,   // blue 150
                 2.85, 1.0,  // blue 100
                 2.25, 1.0,  // blue 50
                 1.9,  1.0,  // blue 0
                 0.75, 1.5,  // red 0
                 0.75, 2.0,  // red 50
                 0.75, 2.5,  // red 100
                 0.75, 3.0,  // red 150
                 0.75, 3.5,  // red 255
                 0.75, 4.2,  // red text
                 1.4, 3.5,   // r255 tick
                 1.4, 3.0,   // r150 tick
                 1.4, 2.5,   // r100 tick
                 1.4, 2.0,   // r50 tick
                 1.4, 1.5,   // r0 tick
                 2.0, 1.4,   // b0 tick
                 2.5, 1.4,   // b50 tick
                 3.0, 1.4,   // b100 tick
                 3.5, 1.4,   // b150 tick
                 4.0, 1.4,   // b255 tick
                 5.1, 1.5,   // g0 tick    #1
                 5.1, 1.9,   // g255 tick  #1
                 5.1, 2.0,   // g0 tick    #2
                 5.1, 2.4,   // g255 tick  #2
                 5.1, 2.5,   // g0 tick    #3
                 5.1, 2.9,   // g255 tick  #3
                 5.1, 3.0,   // g0 tick    #4
                 5.1, 3.4,   // g255 tick  #4
                 5.1, 3.5,   // g0 tick    #5
                 5.1, 3.9,   // g255 tick #5
                 0.5, 6.0,   // Header point #1
                 0.5, 5.75,  // Header Point #1
                 0.5, 5.25,  // Header Point #2
                 0.5, 5.0 }; // Header Point #2


        if (SelectionCall) {
                WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
               *pBasisX = 10000;
               *pBasisY = 10000;
                } // end if
        else {
                ENTER_MAIN(szApiEntryName);
                hdc = GpiQueryDevice(hPS);
                padPoint = adPointArray;
                lClrDelX = (LONG) ((0.5)*((double) delta_x));
                lClrDelY = (LONG) ((0.1)*((double) delta_y));

                R = 150L;
                B = 150L;
                G = 150L;

                RGB = R << 16 | G << 8 | B ;

                // The following Gpi calls insure dithering capability.  (if supported)

                SETENTER(szApiEntryName,"Allow dithering");
                if ( GpiSetPattern(hPS, PATSYM_SOLID ) == FALSE ) {
                        SETEXIT();
                        CLEANUP("GpiSetPattern()",szApiEntryName);
                        return;
                        } // end if

                if ( GpiSetPatternSet(hPS, LCID_DEFAULT ) == FALSE ) {
                        SETEXIT();
                        CLEANUP("GpiSetPattern()",szApiEntryName);
                        return;
                        } // end if
                SETEXIT();


                // Set Color table to RGB mode.

                        strcpy(szAddMessage, ": LCOL_RESET, LCOLF_RGB");
                        SUBENTER(GpiCreateLogColorTableExh, szAddMessage);
                        if ( GpiCreateLogColorTable(hPS, LCOL_RESET, LCOLF_RGB, 0L, 0L, NULL ) == FALSE ) {
                                ErrorCount++;
                                }
                        ERRSTATUS(TRUE,szApiEntryName,"GpiCreateLogColorTable");
                        if (GpiQueryLogColorTable(hPS, 0L, 0L, 64L, clrTarget ) == QLCT_ERROR )
                                ErrorCount++;
                                ERRSTATUS(TRUE,szApiEntryName,"GpiQueryLogColorTable");
                        SUBEXIT();

                // (RGB Mode with dithering.)

                if ( GpiSetColor(hPS, RGB) == FALSE ) {
                        CLEANUP("GpiSetColor()",szApiEntryName);
                        return;
                        } // end if

                basis.x = (LONG) (((double) delta_x) * *(padPoint++));
                basis.y = (LONG) (((double) delta_y) * *(padPoint++));

                // Draw Color Square in RGB mode with dithering.

                for (sLoopR = 0; sLoopR < 5; sLoopR++) {
                        R=lRange[sLoopR];

                        for (sLoopG = 0; sLoopG < 5; sLoopG++) {
                                G=lRange[sLoopG];

                                for (sLoopB = 0; sLoopB < 5; sLoopB++) {
                                        B=lRange[sLoopB];
                                        RGB = R << 16 | G << 8 | B ;
                                        if ( GpiSetColor(hPS, RGB) == FALSE ) {
                                                CLEANUP("GpiSetColor()",szApiEntryName);
                                                return;
                                                } // end if
                                        ptl.y = basis.y+(((LONG) sLoopG)+5L*((LONG) sLoopR))*lClrDelY;
                                        ptl.x = basis.x + ((LONG) sLoopB)*lClrDelX;
                                        inc.x = ptl.x + lClrDelX;
                                        inc.y = ptl.y + lClrDelY;
                                        MapPt(ptl);
                                        MapPt(inc);
                                        GpiMove(hPS, &ptl);
                                        if (GpiBox(hPS, DRO_FILL, &inc, 0L, 0L) != GPI_OK) {
                                                CLEANUP("GpiBox()",szApiEntryName);
                                                return;
                                                } // end if

                                        } // end for - blue

                                } // end for - green

                        } // end for - red



                // Set color table back to Index mode.

                        strcpy(szAddMessage, "LCOL_RESET, LCOLF_INDRGB");
                        SUBENTER(GpiCreateColorTableExh1, szAddMessage);
                        if ( GpiCreateLogColorTable(hPS, LCOL_RESET, LCOLF_INDRGB, 0L, 0L, NULL ) == FALSE )
                                ErrorCount++;
                        ERRSTATUS(TRUE,szApiEntryName,"GpiCreateLogColorTable");
                        if ( GpiQueryLogColorTable(hPS, LCOLOPT_INDEX, 0L, 64L, clrTarget ) == QLCT_ERROR ) {
                                ErrorCount++;
                                ERRSTATUS(TRUE, szApiEntryName,"GpiQueryLogColorTable");
                                } // end if
                        SUBEXIT();

                if ( GpiSetColor(hPS, CLR_BLACK) == FALSE ) {
                        CLEANUP("GpiSetColor()",szApiEntryName);
                        return;
                        } // end if


                ptl.x   = (LONG) (((double) delta_x) * *(padPoint++));
                ptl.y = (LONG) (((double) delta_y) * *(padPoint++));
                MapPt(ptl);
                GpiMove(hPS, &ptl);

                // Draw Axis

                for (sValueLoop = 0; sValueLoop < 3; sValueLoop ++)     {
                        ptl.x   = (LONG) (((double) delta_x) * *(padPoint++));
                        ptl.y = (LONG) (((double) delta_y) * *(padPoint++));
                        MapPt(ptl);
                        GpiLine(hPS, &ptl);

                        } // end for

                // Green axis text

                if ( GpiSetColor(hPS, CLR_DARKGREEN) == FALSE ) {
                        CLEANUP("GpiSetColor()",szApiEntryName);
                        return;
                        } // end if

                ptl.x   = (LONG) (((double) delta_x) * *(padPoint++));
                ptl.y = (LONG) (((double) delta_y) * *(padPoint++));
                MapPt(ptl);
                WorldWriteString(ptl.x, ptl.y ,"Green");

                // Green axis intensity values

                for (sValueLoop = 0; sValueLoop < 10; sValueLoop ++)    {    // increment thru all values.
                        ptl.x   = (LONG) (((double) delta_x) * *(padPoint++));
                        ptl.y = (LONG) (((double) delta_y) * *(padPoint++));
                        MapPt(ptl);
                        if ((sValueLoop % 2) == 0 ) {
                                WorldWriteString(ptl.x, ptl.y  ,"255");
                                } // end if
                        else {
                                        WorldWriteString(ptl.x, ptl.y ,"0" );
                                }  // end else
                        }  // end for

                // Blue axis text

                if ( GpiSetColor(hPS, CLR_DARKBLUE) == FALSE ) {
                        CLEANUP("GpiSetColor()",szApiEntryName);
                        return;
                        } // end if

                ptl.x   = (LONG) (((double) delta_x) * *(padPoint++));
                ptl.y = (LONG) (((double) delta_y) * *(padPoint++));
                MapPt(ptl);
                WorldWriteString(ptl.x, ptl.y, "Blue");

                // Blue axis Intensity values

                for (sValueLoop = 0; sValueLoop < 5; sValueLoop ++)     {    // increment thru all values.
                        ptl.x   = (LONG) (((double) delta_x) * *(padPoint++));
                        ptl.y = (LONG) (((double) delta_y) * *(padPoint++));
                        MapPt(ptl);
                        sprintf(szAddMessage," %-5d",lRange[4-sValueLoop]);
                        WorldWriteString(ptl.x, ptl.y, szAddMessage);
                        }  // end for

                // Red axis Intensity values

                if ( GpiSetColor(hPS, CLR_DARKRED) == FALSE ) {
                        CLEANUP("GpiSetColor()",szApiEntryName);
                        return;
                        } // end if

                for (sValueLoop = 0; sValueLoop < 5; sValueLoop ++)     {
                        ptl.x   = (LONG) (((double) delta_x) * *(padPoint++));
                        ptl.y = (LONG) (((double) delta_y) * *(padPoint++));
                        MapPt(ptl);
                        sprintf(szAddMessage," %3d",lRange[sValueLoop]);
                        WorldWriteString(ptl.x, ptl.y, szAddMessage);
                        }  // end for

                // Red Axis text

                ptl.x   = (LONG) (((double) delta_x) * *(padPoint++));
                ptl.y = (LONG) (((double) delta_y) * *(padPoint++));
                MapPt(ptl);
                (LONG) sprintf(szAddMessage,"Red");
                WorldWriteString(ptl.x, ptl.y, szAddMessage);
                // Draw Red axis ticks

                if ( GpiSetColor(hPS, CLR_BLACK) == FALSE ) {
                        CLEANUP("GpiSetColor()",szApiEntryName);
                        return;
                        } // end if

                lTickLength = (LONG) ( ((double) delta_x) * (0.1) );
                for (sValueLoop = 0; sValueLoop < 5; sValueLoop ++)     {
                        ptl.x   = (LONG) (((double) delta_x) * *(padPoint++));
                        ptl.y = (LONG) (((double) delta_y) * *(padPoint++));
                        inc.x = ptl.x + lTickLength;
                        inc.y = ptl.y;
                        MapPt(ptl);
                        MapPt(inc);
                        GpiMove(hPS, &ptl);
                        GpiLine(hPS, &inc);
                        } // end for

                // Draw Blue axis ticks

                for (sValueLoop = 0; sValueLoop < 5; sValueLoop ++)     {
                        ptl.x   = (LONG) (((double) delta_x) * *(padPoint++));
                        ptl.y = (LONG) (((double) delta_y) * *(padPoint++));
                        inc.x = ptl.x;
                        inc.y = ptl.y + lTickLength;
                        MapPt(ptl);
                        MapPt(inc);
                        GpiMove(hPS, &ptl);
                        GpiLine(hPS, &inc);
                        } // end for

                // Draw Green axis ticks

                for (sValueLoop = 0; sValueLoop < 10; sValueLoop ++)    {
                        ptl.x   = (LONG) (((double) delta_x) * *(padPoint++));
                        ptl.y = (LONG) (((double) delta_y) * *(padPoint++));
                        inc.x = ptl.x - lTickLength;
                        inc.y = ptl.y;
                        MapPt(ptl);
                        MapPt(inc);
                        GpiMove(hPS, &ptl);
                        GpiLine(hPS, &inc);
                        } // end for

                // Text describing Color Table options used for Color square.

                ptl.x   = (LONG) (((double) delta_x) * *(padPoint++));
                ptl.y = (LONG) (((double) delta_y) * *(padPoint++));
                MapPt(ptl);
                sprintf(szAddMessage, "Color Square:");
                WorldWriteString(ptl.x, ptl.y, szAddMessage);

                ptl.x   = (LONG) (((double) delta_x) * *(padPoint++));
                ptl.y = (LONG) (((double) delta_y) * *(padPoint++));
                MapPt(ptl);
                sprintf(szAddMessage, "GpiCreateLogColorTable(hPS,LCOL_RESET,LCOLF_RGB,0L,0L,NULL)");
                WorldWriteString(ptl.x, ptl.y, szAddMessage);


                // Text describing Color Table options used for lines and text output.

                ptl.x   = (LONG) (((double) delta_x) * *(padPoint++));
                ptl.y = (LONG) (((double) delta_y) * *(padPoint++));
                MapPt(ptl);
                sprintf(szAddMessage, "Lines & Text:");
                WorldWriteString(ptl.x, ptl.y, szAddMessage);

                ptl.x   = (LONG) (((double) delta_x) * *(padPoint++));
                ptl.y = (LONG) (((double) delta_y) * *padPoint);
                MapPt(ptl);
                sprintf(szAddMessage, "GpiCreateLogColorTable(hPS,LCOL_RESET,LCOLF_INDRGB,0L,0L,NULL)");
                WorldWriteString(ptl.x, ptl.y, szAddMessage);

 /***************************************************************************
 *
 *       Test of LCOL_REALIZABLE, LCOLF_CONSECRGB, 40L, 4L, array
 *
 ***************************************************************************/

                strcpy(szAddMessage, "LCOL_REALIZABLE, LCOLF_CONSECRGB.");
                SUBENTER(CreateColorTableExh, szAddMessage);
                DevQueryCaps(hdc, CAPS_COLOR_TABLE_SUPPORT, 1L , &lDevCap );
                LOGINFO(L_LOTRACE,"*","Test Realizable Case.");
                if (lDevCap >=8) {
                        if ( GpiCreateLogColorTable(hPS, LCOL_REALIZABLE, LCOLF_CONSECRGB, 20L, 4L, clrRGBTab ) == FALSE ) {
                                ErrorCount++;
                                }
                        ERRSTATUS(TRUE, szApiEntryName,"GpiCreateLogColorTable");

                       //16 GpiRealizeColorTable and GpiUnrealizeColorTable
                       //16 are no longer supported under 32 bit code
                        /*if ( GpiRealizeColorTable(hPS ) == FALSE ) {
                                ErrorCount++;
                                }
                        ERRSTATUS(TRUE, szApiEntryName,"GpiRealizeTable");

                        if ( GpiUnrealizeColorTable(hPS ) == FALSE ) {
                                ErrorCount++;
                                }
                        ERRSTATUS(TRUE, szApiEntryName,"GpiUnrealizeColorTable");*/

                } // end if 8

                else
                        {
                        sprintf(szAddMessage,"Device does not support realize.\n ");
                        strcat(szAddMessage," GpiRealizeColorTable and GpiUnrealizeColorTable cannot be tested.");
                        LOGINFO(L_LOTRACE,"*",szAddMessage);
                        LOGINFO(L_LOTRACE,"*","Test: GpiCreateLogColorTable(LCOL_RESET, LCOLF_CONSECRGB).");
                        if ( GpiCreateLogColorTable(hPS, LCOL_RESET, LCOLF_CONSECRGB, 40L, 4L, clrRGBTab ) == FALSE ) {
                                ErrorCount++;
                                }
                        ERRSTATUS(TRUE, szApiEntryName,"GpiCreateLogColorTable");
                        }

                SUBEXIT();

                EXIT_MAIN(szApiEntryName);

                } // end else

        return;

} // end APIENTRY exhaustive test


/****************************************************************************
 *\\ddd
 *
 * Routine Name: GpiCreateLogColorTable2() exhaustive algorithm
 *
 * Purpose:
 *
 * System Requirements:
 *
 *      Revision Log: 02/25/91 Initial creation for pdvt, David McCombs
 *               01/22/91 Template from Mike Abuzant
 *                Revised by : Hengli Jia for FVT at Boca Raton.
 *                                                      07/22/91
 *      3/16/92 : Vish Thyagarajan, Boca
 *                fInc was initialized to 0.0
 *                Uninitialized fInc in an if statement was causing system hang.
 *
 *
 * Inputs: hPS           -Presentations Space handle.
 *                        hWndClient    -Client Window handle.
 *         SelectionCall -Selection Indicator, is 0 if routine is selected.
 *
 * Outputs:
 *
 * Subroutines Required:
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *      if (SelectionCall){
 *              WndSendMsg();
 *              }
 *      else {
 *              ENTER_MAIN();
 *              SETENTER("Set Pattern");
 *              Get number of colors from DevQueryCaps(CAPS_COLORS);
 *              if number of colors is 2 or less
 *                      call GpiSetPattern( PATSYM_DENSE6 );
 *              else
 *                      call GpiSetPattern( PATSYM_SOLID );
 *              SETEXIT();
 *              SUBENTER(for RGB Purecolor case);
 *              GpiCreateLogColorTable(LCOL_PURECOLOR, LCOLF_RGB, 0L, 0L, NULL);
 *              ERRSTATUS();
 *              SUBEXIT();
 *              Draw Color Square:
 *              for ( R 0->255 ){
 *                      for ( B 0->255 ){
 *                              for ( G 0->255 ){
 *                                      RGB = R << 16 | G << 8 | B ;
 *                                      Put color box at RGBth Position of the color square;
 *                                      20 increments across for blue;
 *                                      20 increments up for red;
 *                                      sqr(20) increments green
 *                                              (cycles through 20 increments for each
 *                                               1/5 of full range of red values);
 *                                      }
 *                              }
 *                      }
 *
 *                      SUBENTER(for LCOL_PURECOLOR, Index RGB case);
 *                      GpiCreateLogColorTable(LCOL_PURECOLOR, LCOLF_INDRGB, 0L, 0L, NULL );
 *                      ERRSTATUS();
 *                      SUBEXIT();
 *      } end if
 *      }
 *\\end
 ***************************************************************************/

VOID APIENTRY GpiCreateLogColorTableExh2(HPS hPS, HWND hWndClient, BOOL SelectionCall)
{

        HDC hdc;
        SHORT sValueLoop, sLoopR, sLoopG, sLoopB, sMAXVAR=20;
        ULONG R, G, B, RGB;
        POINTL ptl, inc, basis;
        static CHAR *szApiEntryName = "GpiCreateLogColorTableExh2";
        double dClrDelX, dClrDelY, *padPoint;
        double fInc = 0.0 ;                               /*** Fix by Vish **/
        LONG  lTickLength, lDevCap;
        static LONG     lRange[] = { 0L, 50L, 100L, 150L, 200, 255L };
        static double adPointArray[]= {
                 2.0, 1.5,   // bottom left corner of color cube
                 1.5, 4.25,  // top of red axis
                 1.5, 1.5,       // intersection of red and blue axis
                 5.0, 1.5,   // intersection of blue and green axis
                 5.0, 4.25,  // top of green axis
                 5.25, 4.3,  // green text
                 5.25, 3.9,  // green 255 #1
                 5.25, 3.5,  // green 0   #1
                 5.25, 3.3,  // green 255 #2
                 5.25, 3.0,  // green 0   #2
                 5.25, 2.8,  // green 255 #3
                 5.25, 2.5,  // green 0   #3
                 5.25, 2.3,  // green 255 #4
                 5.25, 2.0,  // green 0   #4
                 5.25, 1.8,  // green 255 #5
                 5.25, 1.5,  // green 0   #5
                 5.0, 1.0,   // blue text
                 4.3, 1.0,    // blue 255
                 3.8, 1.0,   // blue 200
                 3.3, 1.0,   // blue 150
                 2.8, 1.0,  // blue 100
                 2.4, 1.0,  // blue 50
                 1.9,  1.0,  // blue 0
                 0.75, 1.5,  // red 0
                 0.75, 2.0,  // red 50
                 0.75, 2.5,  // red 100
                 0.75, 3.0,  // red 150
                 0.75, 3.5,  // red 200
                 0.75, 4.0,      // red 255
                 0.75, 4.3,  // red text
                 1.4, 4.0,   // r255 tick
                 1.4, 3.5,   // r200 tick
                 1.4, 3.0,   // r150 tick
                 1.4, 2.5,   // r100 tick
                 1.4, 2.0,   // r50 tick
                 1.4, 1.5,   // r0 tick
                 2.0, 1.4,   // b0 tick
                 2.5, 1.4,   // b50 tick
                 3.0, 1.4,   // b100 tick
                 3.5, 1.4,   // b150 tick
                 4.0, 1.4,   // b200 tick
                 4.5, 1.4,   // b255 tick
                 5.1, 1.5,   // g0,255 tick    #1
                 5.1, 2.0,   // g0,255 tick    #2
                 5.1, 2.5,   // g0,255 tick    #3
                 5.1, 3.0,   // g0,255 tick    #4
                 5.1, 3.5,   // g0,255 tick    #5
                 5.1, 4.0,   // g255 tick
                 0.5, 6.0,   // Header Point #1
                 0.5, 5.75,  // Header Point #1
                 0.5, 5.25,  // Header Point #2
                 0.5, 5.0,   // Header Point #2
                 6.0, 3.75,  // Text CAPS_COLORS:
                 6.0, 3.5};  // Text lDevCap.

        if (SelectionCall) {
                WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
               *pBasisX = 10000;
               *pBasisY = 10000;
                } // end if
        else {
                ENTER_MAIN(szApiEntryName);
                hdc = GpiQueryDevice(hPS);
                padPoint = adPointArray;
                dClrDelX =  (2.5/ ((double) sMAXVAR) ) * ((double) delta_x);
                dClrDelY =  (2.5/ (((double) sMAXVAR)*((double) sMAXVAR)) ) * ((double) delta_y);

                R = 150L;
                B = 150L;
                G = 150L;

                RGB = R << 16 | G << 8 | B ;

                SETENTER(szApiEntryName, "Set Pattern");

              //Query the device cap. for # of distinct colors supported at
                                  //the same time, including reset.      7/22/91.....

                                         DevQueryCaps(hdc, CAPS_COLORS, 1L , &lDevCap );

                if (lDevCap <= 2)
                        {
                        if ( GpiSetPattern(hPS, PATSYM_DENSE6 ) == FALSE )
                                ErrorCount++;
                        ERRSTATUS(TRUE, szApiEntryName, "GpiSetPattern");
                        LOGINFO(L_LOTRACE, "*", "Only 2 colors supported by device, using PATSYM_DENSE6 pattern on output device");
                        } // end if
                else
                        {
                        if ( GpiSetPattern(hPS, PATSYM_SOLID ) == FALSE ) {
                                CLEANUP("GpiSetPattern()",szApiEntryName);
                                } // end if
                        } // end else

                SETEXIT();

                // Set Color table to RGB mode without dithering.

                        strcpy(szAddMessage, "LCOL_PURECOLOR, LCOLF_RGB.");
                        SUBENTER(GpiCreateLogColorTableExh, szAddMessage);

                        if ( GpiCreateLogColorTable(hPS, LCOL_PURECOLOR, LCOLF_RGB, 0L, 0L, NULL ) == FALSE )
                                ErrorCount++;
                        ERRSTATUS(FALSE, szApiEntryName,"GpiCreateLogColorTable");

                        SUBEXIT();


                // Set begin point to lower left hand corner of the square.

                basis.x = (LONG) (((double) delta_x) * *(padPoint++));
                basis.y = (LONG) (((double) delta_y) * *(padPoint++));

                // Draw Color Square in RGB mode without dithering.
                // Dense Dot Pattern used to save toner.

                for (sLoopR = 0; sLoopR < sMAXVAR; sLoopR++) {
                        R = (LONG) ( (((double) sLoopR) * 255.0) / ((double) sMAXVAR) );

                        for (sLoopG = 0; sLoopG < sMAXVAR; sLoopG++) {
                                if (fInc < (double) sMAXVAR) {
                                        G = (LONG) ((fInc+=(5.0/((double)sMAXVAR*sMAXVAR)))*255.0)  ;
                                        }
                                else
                                        fInc = 0.0;
                                for (sLoopB = 0; sLoopB < sMAXVAR; sLoopB++) {
                                        B = (LONG) ( (((double) sLoopB) * 255.0) / ((double) sMAXVAR) );
                                        RGB = R << 16 | G << 8 | B ;
                                        if ( GpiSetColor(hPS, RGB) == FALSE ) {
                                                CLEANUP("GpiSetColor()",szApiEntryName);
                                                return;
                                                } // end if
                                        ptl.y = basis.y+(LONG) (( ((double) sLoopG) + ((double) sMAXVAR)*((double) sLoopR) )*dClrDelY);
                                        ptl.x = basis.x + (LONG) ( ((double) sLoopB)*dClrDelX );
                                        inc.x = ptl.x + (LONG) dClrDelX;
                                        inc.y = ptl.y + (LONG) dClrDelY;
                                        MapPt(ptl);
                                        MapPt(inc);
                                        GpiMove(hPS, &ptl);
                                        if (GpiBox(hPS, DRO_FILL, &inc, 0L, 0L) != GPI_OK) {
                                                CLEANUP("GpiBox()",szApiEntryName);
                                                return;
                                                } // end if

                                        } // end for - blue

                                } // end for - green

                        } // end for - red

                // Set color table back to Index mode.

                        strcpy(szAddMessage, "LCOL_PURECOLOR, LCOLF_INDRGB.");
                        SUBENTER(GpiCreateColorTableExh(), szAddMessage);

                        if ( GpiCreateLogColorTable(hPS, LCOL_PURECOLOR, LCOLF_INDRGB, 0L, 0L, NULL ) == FALSE )
                                ErrorCount++;
                        ERRSTATUS(TRUE,szApiEntryName,"GpiCreateLogColorTable");

                        SUBEXIT();

                if ( GpiSetColor(hPS, CLR_BLACK) == FALSE ) {
                        CLEANUP("GpiSetColor()",szApiEntryName);
                        return;
                        } // end if


                ptl.x   = (LONG) (((double) delta_x) * *(padPoint++));
                ptl.y = (LONG) (((double) delta_y) * *(padPoint++));
                MapPt(ptl);
                GpiMove(hPS, &ptl);

                // Draw Axis

                for (sValueLoop = 0; sValueLoop < 3; sValueLoop ++)     {
                        ptl.x   = (LONG) (((double) delta_x) * *(padPoint++));
                        ptl.y = (LONG) (((double) delta_y) * *(padPoint++));
                        MapPt(ptl);
                        GpiLine(hPS, &ptl);

                        } // end for

                // Green axis text

                if ( GpiSetColor(hPS, CLR_DARKGREEN) == FALSE ) {
                        CLEANUP("GpiSetColor()",szApiEntryName);
                        return;
                        } // end if

                ptl.x   = (LONG) (((double) delta_x) * *(padPoint++));
                ptl.y = (LONG) (((double) delta_y) * *(padPoint++));
                MapPt(ptl);
                sprintf(szAddMessage,"Green");
                WorldWriteString(ptl.x, ptl.y, szAddMessage);

                // Green axis intensity values

                for (sValueLoop = 0; sValueLoop < 10; sValueLoop ++)    {    // increment thru all values.
                        ptl.x   = (LONG) (((double) delta_x) * *(padPoint++));
                        ptl.y = (LONG) (((double) delta_y) * *(padPoint++));
                        MapPt(ptl);
                        if ((sValueLoop % 2) == 0 ) {
                                sprintf(szAddMessage," %-5d",255);
                                WorldWriteString(ptl.x, ptl.y, szAddMessage);
                                } // end if
                        else {
                                sprintf(szAddMessage," %-5d",0);
                                WorldWriteString(ptl.x, ptl.y, szAddMessage);
                                }  // end else
                        }  // end for

                // Blue axis text

                if ( GpiSetColor(hPS, CLR_DARKBLUE) == FALSE ) {
                        CLEANUP("GpiSetColor()",szApiEntryName);
                        return;
                        } // end if

                ptl.x   = (LONG) (((double) delta_x) * *(padPoint++));
                ptl.y = (LONG) (((double) delta_y) * *(padPoint++));
                MapPt(ptl);
                sprintf(szAddMessage,"Blue");
                WorldWriteString(ptl.x, ptl.y, szAddMessage);

                // Blue axis Intensity values

                for (sValueLoop = 0; sValueLoop < 6; sValueLoop ++)     {    // increment thru all values.
                        ptl.x   = (LONG) (((double) delta_x) * *(padPoint++));
                        ptl.y = (LONG) (((double) delta_y) * *(padPoint++));
                        MapPt(ptl);
                        sprintf(szAddMessage," %-5d",lRange[5-sValueLoop]);
                        WorldWriteString(ptl.x, ptl.y, szAddMessage);
                        }  // end for

                // Red axis Intensity values

                if ( GpiSetColor(hPS, CLR_DARKRED) == FALSE ) {
                        CLEANUP("GpiSetColor()",szApiEntryName);
                        return;
                        } // end if

                for (sValueLoop = 0; sValueLoop < 6; sValueLoop ++)     {
                        ptl.x   = (LONG) (((double) delta_x) * *(padPoint++));
                        ptl.y = (LONG) (((double) delta_y) * *(padPoint++));
                        MapPt(ptl);
                        sprintf(szAddMessage," %3d",lRange[sValueLoop]);
                        WorldWriteString(ptl.x, ptl.y, szAddMessage);
                        }  // end for

                // Red Axis text

                ptl.x   = (LONG) (((double) delta_x) * *(padPoint++));
                ptl.y = (LONG) (((double) delta_y) * *(padPoint++));
                MapPt(ptl);
                sprintf(szAddMessage,"Red");
                WorldWriteString(ptl.x, ptl.y, szAddMessage);

                // Draw Red axis ticks

                if ( GpiSetColor(hPS, CLR_BLACK) == FALSE ) {
                        CLEANUP("GpiSetColor()",szApiEntryName);
                        return;
                        } // end if

                lTickLength = (LONG) ( ((double) delta_x) * (0.1) );
                for (sValueLoop = 0; sValueLoop < 6; sValueLoop ++)     {
                        ptl.x   = (LONG) (((double) delta_x) * *(padPoint++));
                        ptl.y = (LONG) (((double) delta_y) * *(padPoint++));
                        inc.x = ptl.x + lTickLength;
                        inc.y = ptl.y;
                        MapPt(ptl);
                        MapPt(inc);
                        GpiMove(hPS, &ptl);
                        GpiLine(hPS, &inc);
                        } // end for

                // Draw Blue axis ticks

                for (sValueLoop = 0; sValueLoop < 6; sValueLoop ++)     {
                        ptl.x   = (LONG) (((double) delta_x) * *(padPoint++));
                        ptl.y = (LONG) (((double) delta_y) * *(padPoint++));
                        inc.x = ptl.x;
                        inc.y = ptl.y + lTickLength;
                        MapPt(ptl);
                        MapPt(inc);
                        GpiMove(hPS, &ptl);
                        GpiLine(hPS, &inc);
                        } // end for

                // Draw Green axis ticks

                for (sValueLoop = 0; sValueLoop < 6; sValueLoop ++)     {
                        ptl.x   = (LONG) (((double) delta_x) * *(padPoint++));
                        ptl.y = (LONG) (((double) delta_y) * *(padPoint++));
                        inc.x = ptl.x - lTickLength;
                        inc.y = ptl.y;
                        MapPt(ptl);
                        MapPt(inc);
                        GpiMove(hPS, &ptl);
                        GpiLine(hPS, &inc);
                        } // end for

                // Text describing Color Table options used for Color Square.

                ptl.x   = (LONG) (((double) delta_x) * *(padPoint++));
                ptl.y = (LONG) (((double) delta_y) * *(padPoint++));
                MapPt(ptl);
                sprintf(szAddMessage, "Color Square:");
                WorldWriteString(ptl.x, ptl.y, szAddMessage);

                ptl.x   = (LONG) (((double) delta_x) * *(padPoint++));
                ptl.y = (LONG) (((double) delta_y) * *(padPoint++));
                MapPt(ptl);
                sprintf(szAddMessage, "GpiCreateLogColorTable(hPS,LCOL_PURECOLOR,LCOLF_RGB,0L,0L,NULL)");
                WorldWriteString(ptl.x, ptl.y, szAddMessage);


                // Text describing Color Table options used for lines and text output.

                ptl.x   = (LONG) (((double) delta_x) * *(padPoint++));
                ptl.y = (LONG) (((double) delta_y) * *(padPoint++));
                MapPt(ptl);
                sprintf(szAddMessage, "Lines & Text:");
                WorldWriteString(ptl.x, ptl.y, szAddMessage);

                ptl.x   = (LONG) (((double) delta_x) * *(padPoint++));
                ptl.y = (LONG) (((double) delta_y) * *(padPoint++));
                MapPt(ptl);
                sprintf(szAddMessage, "GpiCreateLogColorTable(hPS,LCOL_PURECOLOR,LCOLF_INDRGB,0L,0L,NULL)");
                WorldWriteString(ptl.x, ptl.y, szAddMessage);

                // Text describing Number of Colors the device is capable of.

                ptl.x   = (LONG) (((double) delta_x) * *(padPoint++));
                ptl.y = (LONG) (((double) delta_y) * *(padPoint++));
                MapPt(ptl);
                sprintf(szAddMessage, "Number of Colors");
                WorldWriteString(ptl.x, ptl.y, szAddMessage);

                ptl.x   = (LONG) (((double) delta_x) * *(padPoint++));
                ptl.y = (LONG) (((double) delta_y) * *(padPoint++));
                MapPt(ptl);
                sprintf(szAddMessage, "Supported: %d",lDevCap);
                WorldWriteString(ptl.x, ptl.y, szAddMessage);

                /******************************************************************
                *  Close  Entry point.
                *******************************************************************/

                EXIT_MAIN(szApiEntryName);

                } // end else

        return;

} // end APIENTRY exhaustive test



/****************************************************************************
 *\\ddd
 *
 * Routine Name: GpiQueryColorData() exhaustive algorithm
 *
 * Purpose:
 *
 * System Requirements:
 *
 *      Revision Log: 03/01/91 Initial creation for pdvt, David McCombs
 *               01/22/91 Template from Mike Abuzant
 *
 * Inputs: hPS           -Presentations Space handle.
 *                        hWndClient    -Client Window handle.
 *         SelectionCall -Selection Indicator, is 0 if routine is selected.
 *
 * Outputs:
 *
 * Subroutines Required:
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *      if (SelectionCall){
 *              WndSendMsg();
 *              }
 *      else {
 *
 *              Set Up:  Color and Pattern values selected;
 *
 *              Test GpiQueryColorData for (Default) Index case:
 *                      Test that the start index = 0;
 *                      Test that the index count = 16;
 *                      Test that the format = LCOLF_DEFAULT;
 *                      Output Target Array information to output device and log.
 *
 *              Set Color Table to RGB mode; (with 30 RGB Color values in source array)
 *              Test GpiQueryColorData for the RGB case:
 *                      Test that start index = 0;
 *                      Test that index count = 0;
 *                      Test that format = LCOLF_RGB;
 *                      Output Target Array information to output device and log.
 *
 *              Set Color Table to Index RGB mode // 6 Color values in source array
 *              Test GpiQueryColorData for the Index RGB case:
 *                      Test that start index = 0;
 *                      Test that index count = 35;
 *                      Test that format = LCOLF_INDRGB;
 *                      Output Target Array Information to output device and log.
 *
 * }
 *
 *\\end
 ***************************************************************************/



VOID APIENTRY GpiQueryColorDataExh(HPS hPS, HWND hWndClient, BOOL SelectionCall)
{
        INT iValueLoop;
        static CHAR *szApiEntryName = "GpiQueryColorDataExh";
        double *padPoint;

        static struct {
                        LONG lFormValue;
                        CHAR *szFormText;
                        }
                        Format[] = {
                                LCOLF_DEFAULT   , "LCOLF_DEFAULT   " ,
                                LCOLF_INDRGB     , "LCOLF_INDRGB    " ,
                                LCOLF_RGB       , "LCOLF_RGB       "
                                } ;
        static double adPointArray[]= {
                        0.2, 1.5,   // Start of output Box
                        2.2, 1.5,   // Start of Source Descriptions
                        4.2, 1.5,   //  Start of Target Descriptions
                        0.0, 5.9,   // Start Sub HeadLine
                        6.0, 5.9,   // End Sub Headline
                        0.0, 5.5,   // Start HeadLine
                        8.0, 5.5,   // End Headline
                        6.2, 6.5,   // Top of Divider Line
                        6.2, 0.75,  // Bottom of Divider Line
                        0.2, 5.6,   // 'Output' text
                        2.0, 5.6,   // Source Header
                        4.0, 5.6,   // Target Header
                        6.3, 6.0,   // 'Test' text
                        6.3, 5.8,   // 'Color Table' text
                        6.3, 5.6,   // 'Information' text
                        6.3, 1.5,       // Start of Test Information.
                        6.3, 3.0,
                        6.3, 4.5,   // End of Test Information
                   0.2, 6.0 }; // 'Returns From GpiQueryColorData' text.

        padPoint = adPointArray;

        if (SelectionCall) {
                WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
               *pBasisX = 10000;
               *pBasisY = 10000;
                } // end if
        else {
                ENTER_MAIN(szApiEntryName);

                lSpace = (LONG) ( 1.5 * ((double) delta_y));

                /***************************************************
                *
                * Setup to test
                *
                \**************************************************/

                SETENTER(szApiEntryName,"GpiSetPattern");
                if (GpiSetPattern(hPS, PATSYM_HALFTONE)==FALSE)
                        ErrorCount++;
                ERRSTATUS(TRUE,szApiEntryName,"GpiSetPattern");
                if ( GpiSetColor(hPS, CLR_BLACK) == FALSE)
                        ErrorCount++;
                ERRSTATUS(TRUE,szApiEntryName,"GpiSetColor");
                SETEXIT();

                /***************************************************
                *
                * Default ColorTable Case
                *
                \**************************************************/

                strcpy(szAddMessage,"Default Color Table");
                SUBENTER(GpiQueryColorDataExh,szAddMessage );
/*              if ( GpiQueryColordata(hPS, 3L, clrTarget) == FALSE )
                        ErrorCount++;  changed for ppc */
                if ( GpiQueryColorData(hPS, 3L, clrTarget) == FALSE )
                        ErrorCount++;
                if ( clrTarget[0] != LCOLF_DEFAULT ) {
                        ErrorCount++;
                        LOGINFO(L_LOTRACE,"@","Bad Format: Not LCOLF_DEFAULT");
                        }
                if ( clrTarget[1] != 0L ) {
                        ErrorCount++;
                        LOGINFO(L_LOTRACE,"@","Bad Low Index: Not = 0L");
                        }
                if ( clrTarget[2] != 15L )      {
                        ErrorCount++;
                        LOGINFO(L_LOTRACE,"@","Bad High Index: Not = 15L");
                        }
                ERRSTATUS(TRUE,szApiEntryName,szAddMessage );
                SUBEXIT();

                GETX;   //first column  = default case.
                GETY;

                for (iValueLoop = 0; iValueLoop < 3; iValueLoop ++) {
                        if ( clrTarget[1] == Format[iValueLoop].lFormValue ) {
                                pTextPoint.x = pPoint.x;
                                pTextPoint.y = pPoint.y;
                                MapPt(pTextPoint);
                                WorldWriteString(pTextPoint.x, pTextPoint.y, Format[iValueLoop].szFormText);
                                }
                        }
                pPoint.y += lSpace;

                for (iValueLoop = 1; iValueLoop < 3; iValueLoop++) {
                        pTextPoint.x = pPoint.x;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        pPoint.y += lSpace;
                        sprintf (szAddMessage,"%d",clrTarget[iValueLoop]);
                WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage);
                        }

                /***************************************************
                *
                * RGB ColorTable Case
                *
                \**************************************************/

                GETX;   //second column
                GETY;

                strcpy(szAddMessage,"RGB Color Table");
                SUBENTER(GpiQueryColorDataExh,szAddMessage );
                if ( GpiCreateLogColorTable(hPS, LCOL_RESET, LCOLF_RGB, 0L, 30L, clrSource) == FALSE)
                        ErrorCount++;
                ERRSTATUS(TRUE,szApiEntryName,"GpiCreateLogColorTable");
/*              if ( GpiQueryColordata(hPS, 3L, clrTarget) == FALSE )
                        ErrorCount++; changed for ppc */
                if ( GpiQueryColorData(hPS, 3L, clrTarget) == FALSE )
                        ErrorCount++;
                if ( clrTarget[0] != LCOLF_RGB ) {
                        ErrorCount++;
                        LOGINFO(L_LOTRACE,"@","Bad Format: Not LCOLF_RGB");
                        }
                if ( clrTarget[1] != 0L ) {
                        ErrorCount++;
                        LOGINFO(L_LOTRACE,"@","Bad Low Index: Not = 0L");
                        }
                if ( clrTarget[2] != 0L )       {
                        ErrorCount++;
                        LOGINFO(L_LOTRACE,"@","Bad High Index: Not = 0L");
                        }
                ERRSTATUS(TRUE,szApiEntryName,szAddMessage );
                SUBEXIT();

                for (iValueLoop = 0; iValueLoop < 3; iValueLoop ++) {
                        if ( clrTarget[0] == Format[iValueLoop].lFormValue ) {
                                pTextPoint.x = pPoint.x;
                                pTextPoint.y = pPoint.y;
                                MapPt(pTextPoint);
                                WorldWriteString(pTextPoint.x, pTextPoint.y, Format[iValueLoop].szFormText);
                                }
                        }
                pPoint.y += lSpace;

                for (iValueLoop = 1; iValueLoop < 3; iValueLoop++) {
                        pTextPoint.x = pPoint.x;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        pPoint.y += lSpace;
                        sprintf (szAddMessage,"%d",clrTarget[iValueLoop]);
                WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage);
                        }

                /***************************************************
                *
                * Index/RGB ColorTable Case
                *
                \**************************************************/

                GETX;           //third column
                GETY;

                strcpy(szAddMessage,"IRGB Color Table");
                SUBENTER(GpiQueryColorDataExh,szAddMessage );
                if ( GpiCreateLogColorTable(hPS, LCOL_RESET, LCOLF_INDRGB, 0L, 12L, clrIndSource) == FALSE)
                        ErrorCount++;
                ERRSTATUS(TRUE,szApiEntryName,"GpiCreateLogColorTable");
/*              if ( GpiQueryColordata(hPS, 3L, clrTarget) == FALSE )
                        ErrorCount++; changed for ppc */
                if ( GpiQueryColorData(hPS, 3L, clrTarget) == FALSE )
                        ErrorCount++;
                if ( clrTarget[0] != LCOLF_INDRGB ) {
                        ErrorCount++;
                        LOGINFO(L_LOTRACE,"@","Bad Format: Not LCOLF_INDRGB");
                        }
                if ( clrTarget[1] != 0L ) {
                        ErrorCount++;
                        LOGINFO(L_LOTRACE,"@","Bad Low Index: Not = 0L");
                        }
                if ( clrTarget[2] != 35L )      {
                        ErrorCount++;
                        LOGINFO(L_LOTRACE,"@","Bad High Index: Not = 35L");
                        }
                ERRSTATUS(TRUE,szApiEntryName,szAddMessage );
                SUBEXIT();

                for (iValueLoop = 0; iValueLoop < 3; iValueLoop ++) {
                        if ( clrTarget[0] == Format[iValueLoop].lFormValue ) {
                                pTextPoint.x = pPoint.x;
                                pTextPoint.y = pPoint.y;
                                MapPt(pTextPoint);
                                WorldWriteString(pTextPoint.x, pTextPoint.y, Format[iValueLoop].szFormText);
                                        }
                                }
                pPoint.y += lSpace;

                for (iValueLoop = 1; iValueLoop < 3; iValueLoop++) {
                        pTextPoint.x = pPoint.x;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        sprintf (szAddMessage,"%d",clrTarget[iValueLoop]);
                WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage);
                        pPoint.y += lSpace;
                        }

                // draw axis.

                GETX;   //  SubHeader Line
                GETY;
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                GETX;
                GETY;
                MapPt(pPoint);
                GpiLine(hPS,&pPoint);

                GETX;   // Header Line
                GETY;
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                GETX;
                GETY;
                MapPt(pPoint);
                GpiLine(hPS,&pPoint);

                GETX;   // Divider Line
                GETY;
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                GETX;
                GETY;
                MapPt(pPoint);
                GpiLine(hPS,&pPoint);

                // Put test descriptions on output device

                GETX;
                GETY;
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                WorldWriteString(pPoint.x, pPoint.y, "Default Case");
                GETX;
                GETY;
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                WorldWriteString(pPoint.x, pPoint.y, "RGB Case");
                GETX;
                GETY;
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                WorldWriteString(pPoint.x, pPoint.y, "Index RGB Case");
                GETX;
                GETY;
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                WorldWriteString(pPoint.x, pPoint.y, "GpiQueryColordata,");
                GETX;
                GETY;
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                WorldWriteString(pPoint.x, pPoint.y, "Type of");
                GETX;
                GETY;
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                WorldWriteString(pPoint.x, pPoint.y, "Return Data:");
                GETX;
                GETY;
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                WorldWriteString(pPoint.x, pPoint.y, "<- Color Format.");
                GETX;
                GETY;
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                WorldWriteString(pPoint.x, pPoint.y, "<- Start Index.");
                GETX;
                GETY;
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                WorldWriteString(pPoint.x, pPoint.y, "<- End Index.");
                GETX;
                GETY;
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                WorldWriteString(pPoint.x, pPoint.y, "GpiCreateLogColorTable Format Settings.");

                EXIT_MAIN(szApiEntryName);

                } // end else

        return;

} // end APIENTRY exhaustive test



/****************************************************************************
 *\\ddd
 *
 * Routine Name: GpiQueryColorIndexExh() exhaustive algorithm
 *
 * Purpose:
 *
 * System Requirements:
 *
 *      Revision Log: XX/XX/XX Initial creation for pdvt, David McCombs
 *               01/22/91 Template from Mike Abuzant
 *
 * Inputs: hPS           -Presentations Space handle.
 *                        hWndClient    -Client Window handle.
 *         SelectionCall -Selection Indicator, is 0 if routine is selected.
 *
 * Outputs:
 *
 * Subroutines Required:
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *      if (SelectionCall){
 *              WndSendMsg();
 *              }
 *      else {
 *      Create output positioning array;
 *      Setup{
 *              GpiSetPattern set to PATSYM_HALFTONE;
 *              GpiCreateLogColorTable used to load RGB table of 30 colors;
 *              }
 *      Item Entry 1 {
 *              Output odd colors of the 30 RGB colors as a
 *                      box to the left hand side of the display;
 *              Log any errors of GpiSetColor function;
 *              }
 *      Setup 2 {
 *              Return to index color table mode        to prevent QueryColorIndex
 *                      from returning RGB values;
 *              Set color to CLR_BLACK;
 *              Output the RGB value of odd colors of
 *                      the 30 RGB colors to the right of the boxes;
 *              {
 *      Item Entry 2 {
 *              Use GpiQueryColorIndex to find the closest match to the
 *                      odd RGB values;
 *              Match the Index arrived at with the corresponding
 *                      Index value;
 *              Output the color corresponding to the index match achieved;
 *              }
 *
 *   }
 *      }
 *\\end
 ***************************************************************************/

VOID APIENTRY GpiQueryColorIndexExh(HPS hPS, HWND hWndClient, BOOL SelectionCall)
{
        INT iValueLoop, iTestLoop;
        LONG lColorIndex;
        static CHAR *szApiEntryName = "GpiQueryColorIndexExh";
        double *padPoint;
        HDC hdc;
        LONG lDevCap;
        static double adPointArray[]= {
                        0.2, 1.5,   //  Color Bars
                        1.2, 1.5,   // RGB Text
                        3.2, 1.5,   // Index Match Text
                        0.0, 6.0,   // Start HeadLine
                        8.0, 6.0,   // End Headline
                        6.0, 6.5,   // Top of Divider Line
                        6.0, 0.6,   // Bottom of Divider Line
                        0.2, 6.1,   // 'Output' text
                        1.2, 6.1,   // Source Header
                        3.2, 6.1,   // Target Header
                        6.2, 6.3,   // 'Test' text
                        6.2, 6.1,   // 'Information' text
                        0.5, 0.75,  // Start of output window
                        2.0, 0.75,  // Start of Source Descriptions
                        4.0, 0.75,  //  Start of Target Descriptions
                        6.2, 5.5 };     // Start of Test Information.

                padPoint = adPointArray;

        if (SelectionCall) {
                WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
               *pBasisX = 10000;
               *pBasisY = 10000;
                } // end if

        else {

                ENTER_MAIN(szApiEntryName);
                lSpace = (LONG) ( 0.28 * ((double) delta_y));
                pBoxSize.x = (LONG) ( 0.5 * delta_x);
                pBoxSize.y = (LONG) ( 0.2 * delta_y);

                SETENTER(szApiEntryName, NULL );
                if ( GpiCreateLogColorTable(hPS, LCOL_RESET, LCOLF_RGB, 0L, 30L, clrSource) == FALSE)
                        ErrorCount++;
                ERRSTATUS(TRUE,szApiEntryName,"GpiCreateLogColorTable");
                SETEXIT();

                GETX; GETY;

                SUBENTER(GpiQueryColorIndexExh,"RGB Color Table");
                for (iValueLoop = 1; iValueLoop < 30; iValueLoop+=2) {
                        if (GpiSetColor(hPS,clrSource[iValueLoop]) == FALSE)
                                ErrorCount++;
                        sprintf(szAddMessage,"0x%06lX RGB", clrSource[iValueLoop]);
                        ERRSTATUS(TRUE, "Color:", szAddMessage );
                        pNearCorner.x = pPoint.x;
                        pNearCorner.y = pPoint.y;
                        pFarCorner.x = pPoint.x + pBoxSize.x;
                        pFarCorner.y = pPoint.y + pBoxSize.y;
                        MapPt(pNearCorner);
                        MapPt(pFarCorner);
                        GpiMove(hPS, &pNearCorner);
                        GpiBox(hPS, DRO_OUTLINEFILL, &pFarCorner, 0L, 0L);
                        pPoint.y += lSpace;
                        }
                SUBEXIT();

                SETENTER(szApiEntryName,"Index Color Table");

                if ( GpiCreateLogColorTable(hPS, LCOL_RESET, LCOLF_INDRGB, 0L, 12L, clrIndSource) == FALSE)
                        ErrorCount++;
                ERRSTATUS(TRUE,szApiEntryName,"GpiCreateLogColorTable");

                if ( GpiSetColor(hPS,CLR_BLACK) == FALSE)
                        ErrorCount++;
                ERRSTATUS(TRUE,szApiEntryName,"GpiSetColor");

                GETX;   GETY;

                for (iValueLoop = 1; iValueLoop < 30; iValueLoop+=2) {
                        sprintf(szAddMessage,"0x%06lX RGB", clrSource[iValueLoop]);
                        pTextPoint.x = pPoint.x;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        GpiMove(hPS, &pTextPoint);
                        WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage);
                        pPoint.y += lSpace;
                        }
                SETEXIT();

                GETX;   GETY;

                SUBENTER(szApiEntryName,"Query Index Mapping");
                for (iValueLoop = 1; iValueLoop < 30; iValueLoop+=2) {
                        lColorIndex = GpiQueryColorIndex(hPS, 0L, clrSource[iValueLoop]);
                        if ( lColorIndex == GPI_ALTERROR ) {
                                LOGINFO(L_LOTRACE,"*","Unexpected GPI_ALTERROR returned from GpiQueryColorIndex.");
                                ErrorCount++;
                                }

                        iTestLoop = 0;
                while(lColorIndex != sClr[iTestLoop].lColorVal
                                && iTestLoop < 23)                              // Increment until
                           iTestLoop++;                                                 // desired match is found,
                                                                                                                // and then print match.
                                                                                                                        // at 23, end of structure,
                                                                                                                        //      indicates OTHER.

                        sprintf(szAddMessage, "%s", sClr[iTestLoop].szColorText );

                        pTextPoint.x = pPoint.x;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        GpiMove(hPS, &pTextPoint);
                        ERRSTATUS(TRUE,"Queried Index Color Value:",szAddMessage);
                        WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage);
                        pPoint.y += lSpace;
                        }

                SUBEXIT();

                GETX;   GETY;     // Header Line
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                GETX; GETY;
                MapPt(pPoint);
                GpiLine(hPS,&pPoint);

                GETX;   GETY;    // Divider Line
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                GETX; GETY;
                MapPt(pPoint);
                GpiLine(hPS,&pPoint);

                GETX; GETY;
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                WorldWriteString(pPoint.x, pPoint.y, "Output.");


                GETX; GETY;
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                WorldWriteString(pPoint.x, pPoint.y, "RGB Values.");

                GETX; GETY;
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                WorldWriteString(pPoint.x, pPoint.y, "Index Values.");

                GETX; GETY;
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                WorldWriteString(pPoint.x, pPoint.y, "Test");

                GETX; GETY;
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                WorldWriteString(pPoint.x, pPoint.y, "Information.");

        hdc = GpiQueryDevice(hPS);
        DevQueryCaps(hdc, CAPS_COLOR_TABLE_SUPPORT, 1L , &lDevCap );
        LOGINFO(L_LOTRACE,"*", "Color Table Support Device Capabilities.");

        if (lDevCap >= 8L) {
                sprintf(szAddMessage, "CAPS_COLTBL_RGB_8.");
                LOGINFO(L_LOTRACE, "*", szAddMessage);
                lDevCap -= 8L;
                }
        if (lDevCap >= 4L) {
                sprintf(szAddMessage, "CAPS_COLTBL_RGB_8_PLUS.");
                LOGINFO(L_LOTRACE, "*", szAddMessage);
                lDevCap -= 8;
                }
        if (lDevCap >= 2L) {
                sprintf(szAddMessage, "CAPS_COLTBL_TRUE_MIX.");
                LOGINFO(L_LOTRACE, "*", szAddMessage);
                lDevCap -= 2;
                }
        if (lDevCap == 1L) {
                sprintf(szAddMessage, "CAPS_COLTBL_REALIZE.");
                LOGINFO(L_LOTRACE, "*", szAddMessage);
                }




                EXIT_MAIN(szApiEntryName);
                } // end else

        return;

} // end APIENTRY exhaustive test

/****************************************************************************
 *\\ddd
 *
 * Routine Name: GpiQueryNearestColor() exhaustive algorithm
 *
 * Purpose:
 *
 * System Requirements:
 *
 *      Revision Log: 03/05/91 Initial creation for pdvt, David McCombs
 *               01/22/91 Template from Mike Abuzant
 *
 * Inputs: hPS           -Presentations Space handle.
 *                        hWndClient    -Client Window handle.
 *         SelectionCall -Selection Indicator, is 0 if routine is selected.
 *
 * Outputs:
 *
 * Subroutines Required:
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *      if (SelectionCall){
 *              WndSendMsg();
 *              }
 *      else {
 *              ENTER_MAIN;
 *              SETENTER();
 *              GpiSetPattern(PATSYM_HALFTONE);
 *              ERRSTATUS();
 *              GpiCreateLogColorTable(LCOL_RESET, LCOLF_RGB );
 *              ERRSTATUS(TRUE,szApiEntryName,"GpiCreateLogColorTable");
 *              SETEXIT();
 *              SUBENTER( Output RGB Source Color Values Range );
 *              for all colors in color array {
 *                      GpiSetColor();
 *                      ERRSTATUS( RGB Color: [color value] );
 *                      GpiMove();
 *                      GpiBox();
 *                      }
 *              SUBEXIT();
 *
 *              SETENTER( Write Source Values );
 *              GpiSetColor(RGB_BLACK);
 *              ERRSTATUS()
 *              for all colors in source array {
 *                      GpiMove();
 *                      WorldWriteString( RGB Color Source Value );
 *                      }
 *              SETEXIT();
 *
 *              SUBENTER( Query Nearest RGB );
 *              for all colors in source array {
 *                      Nearest RGB = GpiQueryNearestColor( Source RGB );
 *                      ERRSTATUS();
 *                      GpiMove();
 *                      WorldWriteString( Nearest RGB );
 *                      }
 *
 *              SUBEXIT();
 *              EXIT_MAIN();
 *
 *      } end else
 *      }
 *\\end
 ***************************************************************************/

VOID APIENTRY GpiQueryNearestColorExh(HPS hPS, HWND hWndClient, BOOL SelectionCall)
{
        HDC hdc;
        LONG lDevCap;
        INT iValueLoop;
        static CHAR *szApiEntryName = "GpiQueryNearestColorExh";
        double *padPoint;
        LONG lColorRGB;
        static double adPointArray[]= {
                        0.2, 1.5,   //  Color Bars
                        1.2, 1.5,   // RGB Text
                        3.2, 1.5,   // RGB Match Text
                        0.0, 6.0,   // Start HeadLine
                        8.0, 6.0,   // End Headline
                        6.0, 6.5,   // Top of Divider Line
                        6.0, 0.6,   // Bottom of Divider Line
                        0.2, 6.1,   // 'Output' text
                        1.2, 6.1,   // Source Header
                        3.2, 6.1,   // Target Header
                        6.2, 6.3,   // 'Test' text
                        6.2, 6.1,   // 'Information' text
                        0.5, 0.75,  // Start of output window
                        2.0, 0.75,  // Start of Source Descriptions
                        4.0, 0.75,  //  Start of Target Descriptions
                        6.2, 5.5 };     // Start of Test Information.

        padPoint = adPointArray;

        if (SelectionCall) {
                WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
               *pBasisX = 10000;
               *pBasisY = 10000;
                } // end if

        else {

                ENTER_MAIN(szApiEntryName);
                lSpace = (LONG) ( 0.28 * ((double) delta_y));
                pBoxSize.x = (LONG) ( 0.5 * delta_x);
                pBoxSize.y = (LONG) ( 0.2 * delta_y);
                SETENTER(szApiEntryName, NULL );
                if (GpiSetPattern(hPS, PATSYM_HALFTONE)==FALSE)
                        ErrorCount++;
                ERRSTATUS(TRUE,szApiEntryName,"GpiSetPattern");
                if ( GpiCreateLogColorTable(hPS, LCOL_RESET, LCOLF_RGB, 0L, 30L, clrSource) == FALSE)
                        ErrorCount++;
                ERRSTATUS(TRUE,szApiEntryName,"GpiCreateLogColorTable");
                SETEXIT();

                GETX; GETY;

                SUBENTER(GpiQueryNearestColorExh,"RGB Color Table");
                for (iValueLoop = 0; iValueLoop < 30; iValueLoop+=2) {
                        if (GpiSetColor(hPS,clrSource[iValueLoop]) == FALSE)
                                ErrorCount++;
                        sprintf(szAddMessage,"0x%06lX RGB", clrSource[iValueLoop]);
                        ERRSTATUS(TRUE, "RGB Color:", szAddMessage );
                        pNearCorner.x = pPoint.x;
                        pNearCorner.y = pPoint.y;
                        pFarCorner.x = pPoint.x + pBoxSize.x;
                        pFarCorner.y = pPoint.y + pBoxSize.y;
                        MapPt(pNearCorner);
                        MapPt(pFarCorner);
                        GpiMove(hPS, &pNearCorner);
                        GpiBox(hPS, DRO_OUTLINEFILL, &pFarCorner, 0L, 0L);
                        pPoint.y += lSpace;
                        }
                SUBEXIT();

                SETENTER(szApiEntryName,"Write Source Values");

                if ( GpiSetColor(hPS,RGB_BLACK) == FALSE)
                        ErrorCount++;
                ERRSTATUS(TRUE,szApiEntryName,"GpiSetColor");

                GETX;   GETY;

                for (iValueLoop = 0; iValueLoop < 30; iValueLoop+=2)
                        {
                        sprintf(szAddMessage,"0x%06lX RGB", clrSource[iValueLoop]);
                        pTextPoint.x = pPoint.x;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        GpiMove(hPS, &pTextPoint);
                        WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage);
                        pPoint.y += lSpace;
                        }
                SETEXIT();

                GETX;   GETY;

                SUBENTER(GpiQueryNearestColorExh,"Query Nearest RGB.");
                for (iValueLoop = 0; iValueLoop < 30; iValueLoop+=2)
                        {
                        lColorRGB = GpiQueryNearestColor(hPS, 0L, clrSource[iValueLoop]);
                        if ( lColorRGB == GPI_ALTERROR )
                                {
                                LOGINFO(L_LOTRACE,"*","Unexpected GPI_ALTERROR returned from GpiQueryNearestColor.");
                                ErrorCount++;
                                }
                        sprintf(szAddMessage, "0x%06lX RGB", lColorRGB );
                        pTextPoint.x = pPoint.x;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        GpiMove(hPS, &pTextPoint);
                        ERRSTATUS(TRUE,"Nearest RGB Color:",szAddMessage);
                        WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage);
                        pPoint.y += lSpace;
                        }

                SUBEXIT();

                GETX;   GETY;     // Header Line
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                GETX; GETY;
                MapPt(pPoint);
                GpiLine(hPS,&pPoint);

                GETX;   GETY;    // Divider Line
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                GETX; GETY;
                MapPt(pPoint);
                GpiLine(hPS,&pPoint);

                GETX; GETY;
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                WorldWriteString(pPoint.x, pPoint.y, "Output.");


                GETX; GETY;
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                WorldWriteString(pPoint.x, pPoint.y, "Requested RGB.");

                GETX; GETY;
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                WorldWriteString(pPoint.x, pPoint.y, "Nearest RGB.");

                GETX; GETY;
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                WorldWriteString(pPoint.x, pPoint.y, "Test");

                GETX; GETY;
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                WorldWriteString(pPoint.x, pPoint.y, "Information.");

        hdc = GpiQueryDevice(hPS);
        DevQueryCaps(hdc, CAPS_COLOR_TABLE_SUPPORT, 1L , &lDevCap );
        LOGINFO(L_LOTRACE,"*", "Color Table Support Device Capabilities.");

        if (lDevCap >= 8L) {
                sprintf(szAddMessage, "CAPS_COLTBL_RGB_8.");
                LOGINFO(L_LOTRACE, "*", szAddMessage);
                lDevCap -= 8L;
                }
        if (lDevCap >= 4L) {
                sprintf(szAddMessage, "CAPS_COLTBL_RGB_8_PLUS.");
                LOGINFO(L_LOTRACE, "*", szAddMessage);
                lDevCap -= 8;
                }
        if (lDevCap >= 2L) {
                sprintf(szAddMessage, "CAPS_COLTBL_TRUE_MIX.");
                LOGINFO(L_LOTRACE, "*", szAddMessage);
                lDevCap -= 2;
                }
        if (lDevCap == 1L) {
                sprintf(szAddMessage, "CAPS_COLTBL_REALIZE.");
                LOGINFO(L_LOTRACE, "*", szAddMessage);
                }


                EXIT_MAIN(szApiEntryName);

                } // end else

        return;

} // end APIENTRY exhaustive test


/****************************************************************************
 *\\ddd
 *
 * Routine Name: GpiQueryRealColors() exhaustive algorithm
 *
 * Purpose:
 *
 * System Requirements:
 *
 *      Revision Log: 03/05/91 Initial creation for pdvt, David McCombs
 *               01/22/91 Template from Mike Abuzant
 *
 *
 *                Revised by  : Hengli Jia for FVT at Boca Raton.
 *                                                       07/22/91
 *
 * Inputs: hPS           -Presentations Space handle.
 *                        hWndClient    -Client Window handle.
 *         SelectionCall -Selection Indicator, is 0 if routine is selected.
 *
 * Outputs:
 *
 * Subroutines Required:
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *      if (SelectionCall){
 *              WndSendMsg();
 *              }
 *      else {
 *      ENTER_MAIN();
 *      SUBENTER(Check Return Values);
 *      In Index Mode{
 *              Check if the return from GpiQueryRealColors
 *                      matches DevQueryCaps CAPS_COLORS;
 *              Output the Index Values of the device colors;
 *              }
 *      In RGB Mode{
 *              Output the full range of RGB colors as color squares;
 *              Output the RGB Values of the device colors;
 *              }
 *      SUBEXIT();
 *      }
 *      }
 *\\end
 ***************************************************************************/


VOID APIENTRY GpiQueryRealColorsExh(HPS hPS, HWND hWndClient, BOOL SelectionCall)
{
        HDC hdc;
        LONG lDevCap, lNumClrs;
        INT iValueLoop;
        static CHAR *szApiEntryName = "GpiQueryRealColorsExh";
        CHAR comment1[100], comment2[100];
        double *padPoint;
        static double adPointArray[]= {
                        3.2, 1.5,   // Index Text
                        0.2, 1.5,   //  Color Bars
                        1.2, 1.5,   // RGB Text
                        0.5, 7.2,       // comment1 text added 7/22/91
                        0.5, 7.0,       // comment2 text added 7/22/91
                        0.0, 6.0,   // Start HeadLine
                        8.0, 6.0,   // End Headline
                        6.0, 6.5,   // Top of Divider Line
                        6.0, 0.6,   // Bottom of Divider Line
                        0.2, 6.1,   // 'Output' text
                        1.2, 6.1,   // Source Header
                        3.2, 6.1,   // Target Header
                        6.2, 6.3,   // 'Test' text
                        6.2, 6.1,   // 'Information' text
                        0.5, 0.75,  // Start of output window
                        2.0, 0.75,  // Start of Source Descriptions
                        4.0, 0.75,  //  Start of Target Descriptions
                        6.2, 5.5 };     // Start of Test Information.

        padPoint = adPointArray;

        if (SelectionCall) {
                WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
               *pBasisX = 10000;
               *pBasisY = 10000;
                } // end if

        else {

                ENTER_MAIN(szApiEntryName);
                pBoxSize.x = (LONG) ( 0.5 * delta_x);
                pBoxSize.y = (LONG) ( 0.2 * delta_y);

                SUBENTER(GpiQueryRealColors., "Return Check:");
                hdc = GpiQueryDevice(hPS);

                //Query the actual(physical) # of colors supported by the device.

                DevQueryCaps(hdc, CAPS_PHYS_COLORS, 1L , &lDevCap );     // This is the number
                                                                                                                                                 // That should be
                                                                                                                                                 // returned from
                                                                                                                                                 // GpiQueryRealColors.

                if ((lNumClrs=GpiQueryRealColors(hPS, LCOLOPT_INDEX, 0L, 256L, clrTarget)) == GPI_ALTERROR )
                        {                                        // Sends Index and Color Values
                        ErrorCount++;
                        LOGINFO(L_LOTRACE,"*","Unexpected GPI_ALTERROR returned\n from GpiQueryRealColors.");
                        ERRSTATUS(TRUE, szApiEntryName, NULL);
                        SUBEXIT();
                        EXIT_MAIN(szApiEntryName);
                        return;
                        }
                if (lNumClrs != 2*lDevCap )
                        {
                        ErrorCount++;
                        LOGINFO(L_LOTRACE,"*","Number of colors supported, as returned from DevQueryCaps Does not match Return from GpiQueryRealColors.");
                        }
                sprintf(szAddMessage, "DevCap = %ld, Return Colors  = %ld", lDevCap, (lNumClrs/2) );
                ERRSTATUS(TRUE, szAddMessage, NULL);

                if ((lNumClrs=GpiQueryRealColors(hPS, 0L, 0L, 256L, clrTarget)) == GPI_ALTERROR )
                        {
                        ErrorCount++;
                        LOGINFO(L_LOTRACE,"*","Unexpected GPI_ALTERROR returned\n from GpiQueryRealColors.");
                        ERRSTATUS(TRUE, szApiEntryName, NULL);
                        SUBEXIT();
                        EXIT_MAIN(szApiEntryName);
                        return;
                        }
                if (lNumClrs != lDevCap )
                        {
                        ErrorCount++;
                        LOGINFO(L_LOTRACE,"*","Number of colors supported, as returned from DevQueryCaps Does not match Return from GpiQueryRealColors.");
                        }
                sprintf(szAddMessage, "DevCap = %ld, Return Colors  = %ld", lDevCap, lNumClrs);
                ERRSTATUS(TRUE, szAddMessage, NULL);

                SUBEXIT();

                // Set spacing for output to device.

                lSpace = (LONG) ( (4.0 / ((double) lNumClrs)) * ((double) delta_y));
                pBoxSize.y = (LONG) ( (3.5 / ((double) lNumClrs)) * ((double) delta_y));

                GETX; GETY;

                SUBENTER(GpiQueryRealColors, "Colors Values:");

                // Output the Color Values with color table in Index mode:

                if (lNumClrs <= 16)
                        {
                        for (iValueLoop = 0; iValueLoop < ((INT) lNumClrs); iValueLoop ++)
                                {
                                sprintf(szAddMessage, "%#lx RGB",clrTarget[iValueLoop]  );
                                pTextPoint.x = pPoint.x;
                                pTextPoint.y = pPoint.y;
                                MapPt(pTextPoint);
                                GpiMove(hPS, &pTextPoint);
                                ERRSTATUS(FALSE, "Color:",szAddMessage);
                                WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage);
                                pPoint.y += lSpace;
                                }
                        }


                SUBEXIT();


                /* RGB MODE */

                SETENTER(szApiEntryName,"GpiCreatLogColorTable (LCOLF_RGB)");
                if ( GpiCreateLogColorTable(hPS, LCOL_RESET, LCOLF_RGB, 0L, 0L, NULL ) == FALSE)
                        ErrorCount++;
                ERRSTATUS(TRUE,szApiEntryName,"GpiCreateLogColorTable");
                if (GpiSetPattern(hPS, PATSYM_HALFTONE)==FALSE)
                        ErrorCount++;
                ERRSTATUS(TRUE,szApiEntryName,"GpiSetPattern");
                SETEXIT();

                SUBENTER(GpiQueryRealColors, "RGB Colors:");
                if ((lNumClrs=GpiQueryRealColors(hPS, 0L, 0L, 256L, clrTarget)) == GPI_ALTERROR )
                        {
                        ErrorCount++;
                        LOGINFO(L_LOTRACE,"*","Unexpected GPI_ALTERROR returned\n from GpiQueryRealColors.");
                        ERRSTATUS(TRUE, szApiEntryName, "GpiQueryRealColors");
                        SUBEXIT();
                        EXIT_MAIN(szApiEntryName);
                        return;
                        }

                GETX; GETY;

                for (iValueLoop = 0; iValueLoop < ((INT) lNumClrs); iValueLoop ++)
                        {
                        if (GpiSetColor(hPS, clrTarget[iValueLoop]) == FALSE)
                                ErrorCount++;
                        sprintf(szAddMessage,"%#lx RGB",clrTarget[iValueLoop]);
                        ERRSTATUS(TRUE,"Color:",szAddMessage);
                        pNearCorner.x = pPoint.x;
                        pNearCorner.y = pPoint.y;
                        pFarCorner.x = pPoint.x + pBoxSize.x;
                        pFarCorner.y = pPoint.y + pBoxSize.y;
                        MapPt(pNearCorner);
                        MapPt(pFarCorner);
                        GpiMove(hPS, &pNearCorner);
                        GpiBox(hPS, DRO_FILL, &pFarCorner, 0L, 0L);
                        if (GpiSetColor(hPS, RGB_BLACK) == FALSE)
                                ErrorCount++;
                        ERRSTATUS(TRUE,"Color:",szAddMessage);
                        GpiBox(hPS, DRO_OUTLINE, &pFarCorner, 0L, 0L);
                        pPoint.y += lSpace;
                        }

                GETX; GETY;

                if (lNumClrs <= 16)
                        {
                        for (iValueLoop = 0; iValueLoop < ((INT) lNumClrs) ; iValueLoop ++)
                                {
                                sprintf(szAddMessage, "%#lx RGB",clrTarget[iValueLoop]);
                                pTextPoint.x = pPoint.x;
                                pTextPoint.y = pPoint.y;
                                MapPt(pTextPoint);
                                GpiMove(hPS, &pTextPoint);
                                WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage);
                                pPoint.y += lSpace;
                                }
                        }
                else {
                        pPoint.y += 4L*delta_y;
                        MapPt(pPoint);
                        WorldWriteString(pPoint.x, pPoint.y, "Multiple Colors");
                        }


                SUBEXIT();

                GETX; GETY;                     //comment1 added 7/22/91
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                                         sprintf(comment1, "The number of colors shown are the physical colors of this device.");
                WorldWriteString(pPoint.x, pPoint.y, comment1);

                GETX; GETY;               //comment2 added 7/22/91
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                                         sprintf(comment2, "They should not be compared against the display output.");
                WorldWriteString(pPoint.x, pPoint.y, comment2);

                GETX;   GETY;     // Header Line
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                GETX; GETY;
                MapPt(pPoint);
                GpiLine(hPS,&pPoint);

                GETX;   GETY;    // Divider Line
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                GETX; GETY;
                MapPt(pPoint);
                GpiLine(hPS,&pPoint);

                GETX; GETY;
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                WorldWriteString(pPoint.x, pPoint.y, "Output.");


                GETX; GETY;
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                WorldWriteString(pPoint.x, pPoint.y, "Index, RGB.");

                GETX; GETY;
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                WorldWriteString(pPoint.x, pPoint.y, "RGB.");

                GETX; GETY;
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                WorldWriteString(pPoint.x, pPoint.y, "Test");

                GETX; GETY;
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                WorldWriteString(pPoint.x, pPoint.y, "Information.");


                EXIT_MAIN(szApiEntryName);

                } // end else

        return;

} // end APIENTRY exhaustive test



/****************************************************************************
 *\\ddd
 *
 * Routine Name: GpiQueryRGBColor() exhaustive algorithm
 *
 * Purpose:
 *
 * System Requirements:
 *
 *      Revision Log: 03/13/91 Initial creation for pdvt, David McCombs
 *               01/22/91 Template from Mike Abuzant
 *
 * Inputs: hPS           -Presentations Space handle.
 *                        hWndClient    -Client Window handle.
 *         SelectionCall -Selection Indicator, is 0 if routine is selected.
 *
 * Outputs:
 *
 * Subroutines Required:
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *      if (SelectionCall){
 *              WndSendMsg();
 *              }
 *      else {
 *      ENTER_MAIN();
                Log beginning of setup with SETENTER( Set Pattern );
                Set the fill pattern with GpiSetPattern( PATSYM_HALFTONE );
                Log error status with ERRSTATUS();
                Log end of Setup with SETEXIT();
                SUBENTER( Index Color Table );
                for all index color values {
                        GpiSetColor()
                        ERRSTATUS( Color );
                        GpiMove();
                        GpiBox();
                        }
                SUBEXIT();

                SETENTER( Index Colors );

                GpiSetColor(hPS,CLR_BLACK);

                for all index color values {
                        GpiMove();
                        WorldWriteString(index color value);
                        }

                SETEXIT();

                GETX;   GETY;

                Log an Item test entry with SUBENTER( Query RGB Mapping );
                 for all index color values {
                        RGB Color = GpiQueryRGBColor(hPS, 0L, sClr[iValueLoop].lColorVal);
                        GpiMove();
                        log the error status with ERRSTATUS( COLOR: RGB Color );
                        WorldWriteString( COLOR: RGB Color );
                        }

                SUBEXIT();

 *      } end else
 *      }
 *\\end
 ***************************************************************************/

VOID APIENTRY GpiQueryRGBColorExh(HPS hPS, HWND hWndClient, BOOL SelectionCall)
{
        INT iValueLoop;
        static CHAR *szApiEntryName = "GpiQueryRGBColorExh";
        HDC hdc;
        LONG lDevCap, lRgbColor;
        double *padPoint;
        static double adPointArray[]= {
                        0.2, 1.5,   //  Color Bars
                        1.2, 1.5,   // Index Text
                        3.2, 1.5,   // RGB Match Text
                        0.0, 6.0,   // Start HeadLine
                        8.0, 6.0,   // End Headline
                        6.0, 6.5,   // Top of Divider Line
                        6.0, 0.6,   // Bottom of Divider Line
                        0.2, 6.1,   // 'Output' text
                        1.2, 6.1,   // Source Header
                        3.2, 6.1,   // Target Header
                        6.2, 6.3,   // 'Test' text
                        6.2, 6.1,   // 'Information' text
                        0.5, 0.75,  // Start of output window
                        2.0, 0.75,  // Start of Source Descriptions
                        4.0, 0.75,  //  Start of Target Descriptions
                        6.2, 5.5 };     // Start of Test Information.

        padPoint = adPointArray;

        if (SelectionCall) {
                WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
               *pBasisX = 10000;
               *pBasisY = 10000;
                } // end if
        else {
                ENTER_MAIN(szApiEntryName);
                lSpace = (LONG) ( 0.28 * ((double) delta_y));
                pBoxSize.x = (LONG) ( 0.5 * delta_x);
                pBoxSize.y = (LONG) ( 0.2 * delta_y);

                SETENTER(szApiEntryName, NULL );
                if (GpiSetPattern(hPS, PATSYM_HALFTONE)==FALSE)
                        ErrorCount++;
                ERRSTATUS(TRUE, szApiEntryName, "GpiSetPattern");
                SETEXIT();


                GETX; GETY;

                SUBENTER(GpiQueryRGBColorExh,"Index Color Table");

                for (iValueLoop = 1; iValueLoop < 16; iValueLoop++) {

                        // Put color boxes on output device.

                        if (GpiSetColor(hPS,sClr[iValueLoop].lColorVal) == FALSE)
                                ErrorCount++;
                        sprintf(szAddMessage,"COLOR: %s", sClr[iValueLoop].szColorText);
                        ERRSTATUS(TRUE, szApiEntryName, szAddMessage );
                        pNearCorner.x = pPoint.x;
                        pNearCorner.y = pPoint.y;
                        pFarCorner.x = pPoint.x + pBoxSize.x;
                        pFarCorner.y = pPoint.y + pBoxSize.y;
                        MapPt(pNearCorner);
                        MapPt(pFarCorner);
                        GpiMove(hPS, &pNearCorner);
                        GpiBox(hPS, DRO_OUTLINEFILL, &pFarCorner, 0L, 0L);
                        pPoint.y += lSpace;
                        }
                SUBEXIT();

                SETENTER(szApiEntryName,"Index Colors");

                if ( GpiSetColor(hPS,CLR_BLACK) == FALSE)
                        ErrorCount++;
                ERRSTATUS(TRUE,szApiEntryName,"GpiSetColor");

                GETX;   GETY;

                for (iValueLoop = 1; iValueLoop < 16; iValueLoop++) {
                        sprintf(szAddMessage,"%s", sClr[iValueLoop].szColorText);
                        pTextPoint.x = pPoint.x;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        GpiMove(hPS, &pTextPoint);
                        WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage);
                        pPoint.y += lSpace;
                        }

                SETEXIT();

                GETX;   GETY;

                SUBENTER(szApiEntryName,"Query RGB Mapping");
                for (iValueLoop = 1; iValueLoop < 16; iValueLoop++ ) {
                        lRgbColor = GpiQueryRGBColor(hPS, 0L, sClr[iValueLoop].lColorVal);
                        if ( lRgbColor == GPI_ALTERROR ) {
                                LOGINFO(L_LOTRACE,"*","Unexpected GPI_ALTERROR returned from GpiQueryRGBColor.");
                                ErrorCount++;
                                sprintf(szAddMessage, "GPI_ALTERROR");
                                }
                        else
                        sprintf(szAddMessage, "0x%06lX RGB", lRgbColor );
                        pTextPoint.x = pPoint.x;
                        pTextPoint.y = pPoint.y;
                        MapPt(pTextPoint);
                        GpiMove(hPS, &pTextPoint);
                        ERRSTATUS(TRUE,szApiEntryName,szAddMessage);
                        WorldWriteString(pTextPoint.x, pTextPoint.y, szAddMessage);
                        pPoint.y += lSpace;
                        }

                SUBEXIT();

                GETX;   GETY;     // Header Line
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                GETX; GETY;
                MapPt(pPoint);
                GpiLine(hPS,&pPoint);

                GETX;   GETY;    // Divider Line
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                GETX; GETY;
                MapPt(pPoint);
                GpiLine(hPS,&pPoint);

                GETX; GETY;
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                WorldWriteString(pPoint.x, pPoint.y, "Output.");


                GETX; GETY;
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                WorldWriteString(pPoint.x, pPoint.y, "Index Values.");

                GETX; GETY;
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                WorldWriteString(pPoint.x, pPoint.y, "RGB Values.");

                GETX; GETY;
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                WorldWriteString(pPoint.x, pPoint.y, "Test");

                GETX; GETY;
                MapPt(pPoint);
                GpiMove(hPS,&pPoint);
                WorldWriteString(pPoint.x, pPoint.y, "Information.");

        hdc = GpiQueryDevice(hPS);
        DevQueryCaps(hdc, CAPS_COLOR_TABLE_SUPPORT, 1L , &lDevCap );
        LOGINFO(L_LOTRACE,"*", "Color Table Support Device Capabilities.");

        if (lDevCap >= 8L) {
                sprintf(szAddMessage, "CAPS_COLTBL_RGB_8.");
                LOGINFO(L_LOTRACE, "*", szAddMessage);
                lDevCap -= 8L;
                }
        if (lDevCap >= 4L) {
                sprintf(szAddMessage, "CAPS_COLTBL_RGB_8_PLUS.");
                LOGINFO(L_LOTRACE, "*", szAddMessage);
                lDevCap -= 8;
                }
        if (lDevCap >= 2L) {
                sprintf(szAddMessage, "CAPS_COLTBL_TRUE_MIX.");
                LOGINFO(L_LOTRACE, "*", szAddMessage);
                lDevCap -= 2;
                }
        if (lDevCap == 1L) {
                sprintf(szAddMessage, "CAPS_COLTBL_REALIZE.");
                LOGINFO(L_LOTRACE, "*", szAddMessage);
                }



                EXIT_MAIN(szApiEntryName);

                } // end else

        return;

} // end APIENTRY exhaustive test

/***************************************************************
*                                                                                                                                                                       *
*   END OF EXHAUSTIVE TESTING.                                                                                  *
*                                                                                                                                                                       *
***************************************************************/

/***************************************************************
*                                                                                                                                                                       *
*   BEGINING OF RETURN CODE TESTING.                                                                    *
*                                                                                                                                                                       *
***************************************************************/

/****************************************************************************
 *\\ddd
 *
 * Routine Name: GpiSetColor return code algorithm
 *
 * Purpose:
 *
 * System Requirements:
 *
 *      Revision Log: 02/13/91 Initial creation for pdvt, David McCombs
 *               01/22/91 Template from Mike Abuzant
 *
 * Inputs: hPS           -Presentations Space handle.
 *                        hWndClient    -Client Window handle.
 *         SelectionCall -Selection Indicator, is 0 if routine is selected.
 *
 * Outputs:
 *
 * Subroutines Required:
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *      if (SelectionCall){
 *              WndSendMsg();
 *              }
 *      else {
 *              Log test entry with ENTER_MAIN();
 *              Log item test entry with SUBENTER(PMERR_INV_COLOR_ATTR);
 *              Return = (GpiSetColor( CLR_ERROR ) == FALSE);
 *              Check error message with CHECKRC(Return,PMERR_INV_COLOR_ATTR);
 *              Log test item exit with SUBEXIT();
 *              Log test exit with EXIT_MAIN();
 *      } end else
 *      }
 *\\end
 ***************************************************************************/


VOID APIENTRY GpiSetColorRc(HPS hPS, HWND hWndClient, BOOL SelectionCall)  {
        LONG lReturnValue;
        static CHAR *szApiEntryName = "GpiSetColorRC";

        if (SelectionCall) {
                WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
               *pBasisX = 10000;
               *pBasisY = 10000;
                }

        else {

                ENTER_MAIN(szApiEntryName);

                sprintf(szAddMessage, "Test 1");
                SUBENTER( PMERR_INV_COLOR_ATTR, szAddMessage);
                lReturnValue = GpiSetColor(hPS, CLR_ERROR);
                CHECKRC(lReturnValue,PMERR_INV_COLOR_ATTR,szAddMessage);
                SUBEXIT();
                DeletePrinterOutput(szApiEntryName);
                EXIT_MAIN(szApiEntryName);
                }
        return;
}


/****************************************************************************
 *\\ddd
 *
 * Routine Name: GpiCreateLogColorTable() return code algorithm
 *
 * Purpose:
 *
 * System Requirements:
 *
 *      Revision Log: 02/13/91 Initial creation for pdvt, David McCombs
 *               01/22/91 Template from Mike Abuzant
 *
 * Inputs: hPS           -Presentations Space handle.
 *                        hWndClient    -Client Window handle.
 *         SelectionCall -Selection Indicator, is 0 if routine is selected.
 *
 * Outputs:
 *
 * Subroutines Required:
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *      if (SelectionCall){
 *              WndSendMsg();
 *              }
 *      else {
 *              ENTER_MAIN;
 *              SUBENTER( PMERR_REALIZE_NOT_SUPPORTED );
 *      Find and output the device support with DevQueryCaps;
 *      If device cannot be set to Realizable, try setting it;
 *              GpiCreateLogColorTable(LCOL_REALIZABLE) should
 *                                      return a warning PMERR_REALIZE_NOT_SUPPORTED.);
 *              CHECKRC();
 *              SUBEXIT();
 *
 *              SUBENTER( PMERR_INV_COLOR_START_INDEX );
 *              for a wide range of index values {
 *      find starting index that will solicit a
 *                               PMERR_INV_COLOR_START_INDEX message;
 *              } end for
 *              CHECKRC();
 *              SUBEXIT();
 *
 *              SUBENTER(PMERR_INV_LENGTH_OR_COUNT, szAddMessage);
 *
 *              Use an Invalid Array length by querying the Device
 *              for Maximum Color       Array size and then exceeding it
 *              to solicit a PMERR_INV_LENGTH_OR_COUNT  Message;
 *
 *              CHECKRC();
 *              SUBEXIT();
 *              EXIT_MAIN();
 *      } end else
 *      }
 *\\end
 ***************************************************************************/

VOID APIENTRY GpiCreateLogColorTableRc(HPS hPS, HWND hWndClient, BOOL SelectionCall)  {
        LONG lReturnValue,lDevCap,lDevCap2, lTestVar;
        static CHAR *szApiEntryName = "GpiCreateLogColorTableRC";
        HDC hdc;
        static COLOR clrRGBTab[] = { 0x000F0FL, 0xAA0000L, 0xFFF0AAL, 0xA0A0AAL };

        if (SelectionCall) {
                WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
               *pBasisX = 10000;
               *pBasisY = 10000;
                } // end if

        else {

                ENTER_MAIN(szApiEntryName);

/****************************************************************
*
* Find and output the device support.
*
****************************************************************/

                hdc = GpiQueryDevice(hPS);
                DevQueryCaps(hdc, CAPS_COLOR_TABLE_SUPPORT, 1L , &lDevCap );
                DevQueryCaps(hdc, CAPS_COLORS, 1L , &lDevCap2 );
                LOGINFO(L_LOTRACE, "*", "Color Table Device Capabilities:");

/***********************************************************************
*
* If device cannot be set to Realizable, try setting it.
* Should return a warning PMERR_REALIZE_NOT_SUPPORTED.
*
***********************************************************************/

                if (lDevCap == 0L) {
                        sprintf(szAddMessage, "No Color Table Support by device.");
                        LOGINFO(L_LOTRACE,"*", szAddMessage);
                        }
                if (lDevCap >= 8L) {
                        sprintf(szAddMessage, "CAPS_COLTBL_REALIZE capable.");
                        LOGINFO(L_LOTRACE,"*", szAddMessage);
                        lDevCap -= 8;
                }
                else {
                        SUBENTER(PMERR_REALIZE_NOT_SUPPORTED, NULL);
                        GpiCreateLogColorTable(hPS, LCOL_REALIZABLE, LCOLF_CONSECRGB, 17L, 4L, clrRGBTab);
                        lReturnValue = 0L;       // must manually set to 0 since Gpi returns 1.

                        CHECKRC(lReturnValue,PMERR_REALIZE_NOT_SUPPORTED,NULL);
                        SUBEXIT();

                        }
                if (lDevCap >= 4L) {
                        sprintf(szAddMessage, "CAPS_COLTBL_TRUE_MIX.");
                        LOGINFO(L_LOTRACE, "*", szAddMessage);
                        lDevCap -= 4L;
                        }
                if (lDevCap >= 2L) {
                        sprintf(szAddMessage, "CAPS_COLTBL_RGB_8_PLUS.");
                        LOGINFO(L_LOTRACE, "*", szAddMessage);
                        lDevCap -= 2;
                        }
                if (lDevCap == 1L) {
                        sprintf(szAddMessage, "CAPS_COLTBL_RGB_8 capable.");
                        LOGINFO(L_LOTRACE, "*", szAddMessage);
                        lDevCap = 0L;
                }

/***************************************************************************
*                                                                                                                                                                                                       *
*  Use an invalid starting index to solicit a PMERR_INV_COLOR_START_INDEX       *
*       message.                                                                                                                                                                                *
*                                                                                                                                                                                                       *
***************************************************************************/

                sprintf( szAddMessage,"Test 1");
                SUBENTER(PMERR_INV_COLOR_START_INDEX, szAddMessage);
                lReturnValue = TRUE;
                for (lTestVar = 18L; lTestVar > -0xFFL; --lTestVar) {
                        if( GpiCreateLogColorTable(hPS,LCOL_RESET,LCOLF_CONSECRGB,lTestVar,4L,clrRGBTab) == FALSE ) {
                                lReturnValue = FALSE;
                                break;
                                } // end if
                        } // end for
                sprintf(szAddMessage, "INV_INDEX = %d",lTestVar);
                CHECKRC(lReturnValue,PMERR_INV_COLOR_START_INDEX,szAddMessage);
                SUBEXIT();

/************************************************************************
*
*       Use an Invalid Array length by querying the Device for Maximum Color
*  Array size and then exceeding it to solicit a PMERR_INV_LENGTH_OR_COUNT
*  Message.
*
*************************************************************************/


                sprintf(szAddMessage, "Test 1");
                SUBENTER(PMERR_INV_LENGTH_OR_COUNT, szAddMessage);
                lReturnValue = GpiCreateLogColorTable(hPS,LCOL_RESET,LCOLF_CONSECRGB,17L,(lDevCap2+0xFFL),clrRGBTab);
                sprintf(szAddMessage, "INV_COUNT = %d",lDevCap2+0xFFL);
                CHECKRC(lReturnValue,PMERR_INV_LENGTH_OR_COUNT,szAddMessage);
                SUBEXIT();
                DeletePrinterOutput(szApiEntryName);
                EXIT_MAIN(szApiEntryName);

                } // end else

        return;

} // end APIENTRY return code test.


/****************************************************************************
 *\\ddd
 *
 * Routine Name: GpiQueryLogColorTable() return code algorithm
 *
 * Purpose:
 *
 * System Requirements:
 *
 *      Revision Log: 02/15/91 Initial creation for pdvt, David McCombs
 *               01/22/91 Template from Mike Abuzant
 *
 * Inputs: hPS           -Presentations Space handle.
 *                        hWndClient    -Client Window handle.
 *         SelectionCall -Selection Indicator, is 0 if routine is selected.
 *
 * Outputs:
 *
 * Subroutines Required:
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *      if (SelectionCall){
 *              WndSendMsg();
 *              }
 *      else {
 *              ENTER_MAIN();
 *              SUBENTER( PMERR_INV_LENGTH_OR_COUNT );
 *              for (a range of count values) {
 *              find count that will solicit a
 *                      PMERR_INV_LENGTH_OR COUNT message;
 *                      } end for
 *              CHECKRC();
 *              SUBEXIT();
 *              EXIT_MAIN();
 *      } end else
 *      }
 *\\end
 ***************************************************************************/

VOID APIENTRY GpiQueryLogColorTableRc(HPS hPS, HWND hWndClient, BOOL SelectionCall)  {
        COLOR clrTarget[100];  // COLOR maps to LONG
        LONG lReturnValue, lTestVar;
        static CHAR *szApiEntryName = "GpiQueryLogColorTableRC";

        if (SelectionCall) {
                WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
               *pBasisX = 10000;
               *pBasisY = 10000;
                } // end if

        else {

                ENTER_MAIN(szApiEntryName);
                lReturnValue=TRUE;
                sprintf(szAddMessage, "Test");
                SUBENTER(PMERR_INV_LENGTH_OR_COUNT, szAddMessage);
                for (lTestVar=0xFL; lTestVar >= -0xFFFL; --lTestVar) {
                        if (GpiQueryLogColorTable(hPS,0L,17L,lTestVar,clrTarget) == QLCT_ERROR){
                                lReturnValue=FALSE;
                                break;
                                }
                        }
                sprintf(szAddMessage, "INV_COUNT = %d",lTestVar);
                CHECKRC(lReturnValue,PMERR_INV_LENGTH_OR_COUNT,szAddMessage);
                SUBEXIT();
                DeletePrinterOutput(szApiEntryName);
                EXIT_MAIN(szApiEntryName);

                } // end else

        return;

} // end APIENTRY return code test.


/****************************************************************************
 *\\ddd
 *
 * Routine Name: GpiQueryColorDataRC() return code algorithm
 *
 * Purpose:
 *
 * System Requirements:
 *
 *      Revision Log: 02/19/91 Initial creation for pdvt, David McCombs
 *               01/22/91 Template from Mike Abuzant
 *
 * Inputs: hPS           -Presentations Space handle.
 *                        hWndClient    -Client Window handle.
 *         SelectionCall -Selection Indicator, is 0 if routine is selected.
 *
 * Outputs:
 *
 * Subroutines Required:
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *      if (SelectionCall){
 *              WndSendMsg();
 *              }
 *      else {
 *              ENTER_MAIN();
 *              SUBENTER( PMERR_INV_LENGTH_OR_COUNT );
 *              for ( a range of count values ) {
 *              find count that will solicit a
 *                      PMERR_INV_LENGTH_OR COUNT message;
 *                      } end for
 *              CHECKRC();
 *              SUBEXIT();
 *              EXIT_MAIN();
 *
 *      } end else
 *      }
 *\\end
 ***************************************************************************/

VOID APIENTRY GpiQueryColorDataRc(HPS hPS, HWND hWndClient, BOOL SelectionCall)  {
        COLOR clrTarget[100];  // COLOR maps to LONG
        LONG lReturnValue;
        static CHAR *szApiEntryName = "GpiQueryColorDataRC";

        if (SelectionCall) {
                WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
               *pBasisX = 10000;
               *pBasisY = 10000;
                } // end if

        else {

                ENTER_MAIN(szApiEntryName);
                lReturnValue=TRUE;
                sprintf(szAddMessage,"Test");
                SUBENTER(PMERR_INV_LENGTH_OR_COUNT, szAddMessage);

                /* 3L is the only appropriate number for this query */
           /* protect violation on 52xx at Negative Values.      */
                /* clrTarget is 256 elements long.                                               */

/*              if (GpiQueryColordata(hPS, -1L, clrTarget) == FALSE)
                                lReturnValue=FALSE; changed for pcc */
                if (GpiQueryColorData(hPS, -1L, clrTarget) == FALSE)
                                lReturnValue=FALSE;
                sprintf(szAddMessage,"INV_COUNT = %d",-1L);
                CHECKRC(lReturnValue,PMERR_INV_LENGTH_OR_COUNT,szAddMessage);
                SUBEXIT();
                DeletePrinterOutput(szApiEntryName);
                EXIT_MAIN(szApiEntryName);

                } // end else

        return;

} // end APIENTRY return code test.

/****************************************************************************
 *\\ddd
 *
 * Routine Name: GpiQueryRealColors() return code algorithm
 *
 * Purpose:
 *
 * System Requirements:
 *
 *      Revision Log: 02/13/91 Initial creation for pdvt, David McCombs
 *               01/22/91 Template from Mike Abuzant
 *
 * Inputs: hPS           -Presentations Space handle.
 *                        hWndClient    -Client Window handle.
 *         SelectionCall -Selection Indicator, is 0 if routine is selected.
 *
 * Outputs:
 *
 * Subroutines Required:
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *      if (SelectionCall){
 *              WndSendMsg();
 *              }
 *      else {
 *              ENTER_MAIN();
 *              SUBENTER( PMERR_INV_LENGTH_OR_COUNT );
 *              for a range of count values {
 *              find count that will solicit a
 *                      PMERR_INV_LENGTH_OR COUNT message;
 *                      } end for
 *              CHECKRC();
 *              SUBEXIT();
 *              EXIT_MAIN();
 *              ENTER_MAIN();
 *              SUBENTER( PMERR_INV_COLOR_START_INDEX );
 *              for a range of index values {
 *              find index that will solicit a
 *                      PMERR_INV_COLOR_START_INDEX message;
 *                      } end for
 *              CHECKRC();
 *              SUBEXIT();
 *              EXIT_MAIN();
 *
 *   } end else
 *      }
 *\\end
 ***************************************************************************/

VOID APIENTRY GpiQueryRealColorsRc(HPS hPS, HWND hWndClient, BOOL SelectionCall)  {
        LONG lReturnValue, lTestVar;
        static CHAR *szApiEntryName = "GpiQueryRealColorsRC";

        if (SelectionCall) {
                WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
               *pBasisX = 10000;
               *pBasisY = 10000;
                } // end if

        else {

                ENTER_MAIN(szApiEntryName);
                sprintf(szAddMessage, "Test.");
                lReturnValue=TRUE;

                SUBENTER(PMERR_INV_LENGTH_OR_COUNT, szAddMessage);
                for (lTestVar = 100L; lTestVar > -0xFFFL; --lTestVar) {
                        if (GpiQueryRealColors(hPS,0L,0L,lTestVar,clrTarget) == GPI_ALTERROR ) {
                                lReturnValue=FALSE;
                                break;
                                }
                        }
                sprintf(szAddMessage,"INV_COUNT = %d",lTestVar);
                CHECKRC(lReturnValue,PMERR_INV_LENGTH_OR_COUNT,szAddMessage);
                SUBEXIT();

                sprintf(szAddMessage, "Test.");
                SUBENTER(PMERR_INV_COLOR_START_INDEX, szAddMessage);
                for (lTestVar = 21L; lTestVar >= -0xFFFL; --lTestVar) {
                        if (GpiQueryRealColors(hPS,0L,lTestVar,50L,clrTarget) == GPI_ALTERROR) {
                                lReturnValue=FALSE;
                                break;
                                }
                        }
                sprintf(szAddMessage,"INV_INDEX = %d",lTestVar);
                CHECKRC(lReturnValue,PMERR_INV_COLOR_START_INDEX, szAddMessage);
                SUBEXIT();
                DeletePrinterOutput(szApiEntryName);
                EXIT_MAIN(szApiEntryName);

                } // end else

        return;

} // end APIENTRY return code test.

/****************************************************************************
 *\\ddd
 *
 * Routine Name: GpiQueryRGBColors() return code algorithm
 *
 * Purpose:
 *
 * System Requirements:
 *
 *      Revision Log: 02/15/91 Initial creation for pdvt, David McCombs
 *               01/22/91 Template from Mike Abuzant
 *
 * Inputs: hPS           -Presentations Space handle.
 *                        hWndClient    -Client Window handle.
 *         SelectionCall -Selection Indicator, is 0 if routine is selected.
 *
 * Outputs:
 *
 * Subroutines Required:
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/

/****************************************************************************
 *\\algorithm
 * {
 *      if (SelectionCall){
 *              WndSendMsg();
 *              }
 *      else {
 *              ENTER_MAIN();
 *              SUBENTER(PMERR_INV_COLOR_INDEX );
 *              where CLR_ERROR is defined as -255L in PMGPI.H,
 *              if (GpiQueryRGBColor( CLR_ERROR ) == GPI_ALTERROR)
 *              lReturnValue=FALSE;
 *              CHECKRC();
 *              SUBEXIT();
 *              EXIT_MAIN(szApiEntryName);
 *
 *      }
 *      }
 *\\end
 ***************************************************************************/

VOID APIENTRY GpiQueryRGBColorRc(HPS hPS, HWND hWndClient, BOOL SelectionCall)  {
        LONG lReturnValue;
        static CHAR *szApiEntryName = "GpiQueryRGBColorsRC() - Return Code Test";

        if (SelectionCall) {
                WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
               *pBasisX = 10000;
               *pBasisY = 10000;
                } // end if

        else {

                ENTER_MAIN(szApiEntryName);
                lReturnValue=TRUE;

                sprintf(szAddMessage, "Test.");
                SUBENTER(PMERR_INV_COLOR_INDEX, szAddMessage);
                if (GpiQueryRGBColor(hPS, 0L, CLR_ERROR) == GPI_ALTERROR)
                lReturnValue=FALSE;     // It had better choke on CLR_ERROR!
                CHECKRC(lReturnValue,PMERR_INV_COLOR_INDEX,szAddMessage);
                SUBEXIT();
                DeletePrinterOutput(szApiEntryName);
                EXIT_MAIN(szApiEntryName);

                } // end else

        return;

} // end APIENTRY return code test.





