#define INCL_DOS
#define INCL_WIN
#define INCL_GPI
#define INCL_ERRORS

#include <string.h>
#include <stdio.h>
#include <os2.h>
#include "PTTDLLDF.H"
#include "gpi_grid.h"
#include "routines.h"
#include "std_util.h"

LONG  error_count;

VOID exclude_clip_rect(HPS hPS,HWND hWndClient)
{
  POINTL   ptl;
  RECTL    region[4];
  RECTL    exclude;
  HRGN     hrgn;
  LONG     complx;
  CHAR     str1_msg[200],
           str2_msg[200];

    TEST_SIGNATURE(0, 0);
    LOG_SIGNATURE;
    CWRITELOG(L_LOTRACE,0,"+ee+ Test GpiExcludeClipRectangle - Entry\n");
    gpi_grid(hPS, (LONG)INCH);
    error_count = 0;
    MapAndWriteString(hPS, 2 * delta_x, 6 * delta_y + delta_y/6, "Excludes a rectangle from a clipping region");
    memset(str1_msg, '\\', sizeof(str1_msg));
    memset(str2_msg, '/', sizeof(str2_msg));

    /*******************************/
    /* Test for Indicator RGN_NULL */
    /*******************************/
    region[0].xLeft = MapX(delta_x);
    region[0].yBottom = MapY(delta_y);
    region[0].xRight = MapX(delta_x);
    region[0].yTop = MapY(delta_y);
    CWRITELOG(L_LOTRACE,0,"+ie+ Test Indicator RGN_NULL - Entry\n");
    hrgn = GpiCreateRegion(hPS,    // Create region in presentation space
                           0L,     // with zero rectangle; using coordinates
                           region); // from region.

    /***********************************************************/
    /* Test GpiSetClipRegion for Complexity Indicator RGN_NULL */
    /***********************************************************/
    complx = GpiSetClipRegion(hPS,  // set region created to a clipping region
                            hrgn,
                            NULL);
    if (complx == RGN_NULL)   // check if indicator equals RGN_NULL
    {
      MapAndWriteString(hPS, delta_x, 3 * delta_y, "THIS SHOULD NEVER APPEAR ON THE SCREEN OR PAPER !!!");
      CWRITELOG(L_LOTRACE,0,
"$GpiSetClipRegion RGN_NULL Test                                 -    PASS.\n");
    }
    else
      check_rtn((INT) complx, hWndClient, "GpiSetClipRegion");
    exclude.xLeft = MapX(delta_x);
    exclude.yBottom = MapY(2 * delta_y);
    exclude.xRight = MapX(3 * delta_x);
    exclude.yTop = MapY(4 * delta_y);
    complx = GpiExcludeClipRectangle(hPS, &exclude);
    if (complx == RGN_NULL)  // check if indicator equals RGN_NULL
    {
      /* This string should never appear on the screen */
      MapAndWriteString(hPS, delta_x, 2 * delta_y + delta_y/2, "THIS SHOULD NEVER APPEAR ON THE SCREEN OR PAPER !!!");
      CWRITELOG(L_LOTRACE,0,
"$GpiExcludeClipRectangle RGN_NULL Test                          -    PASS.\n");
    }
    else
      check_rtn((INT) complx, hWndClient, "GpiExcludeClipRectangle");
    GpiSetClipRegion(hPS, NULLHANDLE, NULL);
    GpiDestroyRegion(hPS, hrgn);
    CWRITELOG(L_LOTRACE,0,"+ix+ Test Indicator RGN_NULL - Exit\n");

    /**********************************/
    /* Test for Indicator RGN_COMPLEX */
    /**********************************/
    CWRITELOG(L_LOTRACE,0,"+ie+ Test Indicator RGN_COMPLEX - Entry\n");
    MapAndWriteString(hPS, delta_x - delta_x/5, 5 * delta_y + delta_y/4, "<<< Complex Region >>>");
    MapAndWriteString(hPS, 0, 2 * delta_y + delta_y/2, "Excluded");
    MapAndWriteString(hPS, 0,2 * delta_y + delta_y/4, " Area ----->");

    region[0].xLeft = MapX(delta_x);
    region[0].yBottom = MapY(delta_y);
    region[0].xRight = MapX(3 * delta_x);
    region[0].yTop = MapY(2 * delta_y);

    region[1].xLeft = MapX(delta_x);
    region[1].yBottom = MapY(2 * delta_y);
    region[1].xRight = MapX(2 * delta_x);
    region[1].yTop = MapY(3 * delta_y);

    region[2].xLeft = MapX(delta_x);
    region[2].yBottom = MapY(3 * delta_y);
    region[2].xRight = MapX(3 * delta_x);
    region[2].yTop = MapY(4 * delta_y);

    region[3].xLeft = MapX(delta_x);
    region[3].yBottom = MapY(4 * delta_y);
    region[3].xRight = MapX(2 * delta_x);
    region[3].yTop = MapY(5 * delta_y);
    hrgn = GpiCreateRegion(hPS,    // create region in presentation space
                            4L,     // of four rectangles using coordinates
                            region); // from region.

    /**************************************************************/
    /* Test GpiSetClipRegion for Complexity Indicator RGN_COMPLEX */
    /**************************************************************/
    complx = GpiSetClipRegion(hPS,  // set region created to a clipping region
                            hrgn,
                            NULL);
    if (complx == RGN_COMPLEX)   // check if indicator equals RGN_NULL
    {
      ptl.x = delta_x / 2;
      ptl.y = 6 * delta_y;
      display_text(hPS, ptl.x, ptl.y, str1_msg);
      CWRITELOG(L_LOTRACE,0,"GpiSetClipRegion RGN_COMPLEX Test                     -    PASS.\n");
    }
    else
      check_rtn((INT) complx, hWndClient, "GpiSetClipRegion");

    exclude.xLeft = MapX(delta_x);
    exclude.yBottom = MapY(2 * delta_y);
    exclude.xRight = MapX(2 * delta_x);
    exclude.yTop = MapY(3 * delta_y);
    complx = GpiExcludeClipRectangle(hPS, &exclude);
    if ( complx == RGN_COMPLEX )   // check if indicator is RGN_COMPLEX
    {
      ptl.x = delta_x / 2;
      ptl.y = 6 * delta_y;
      display_text(hPS, ptl.x, ptl.y, str2_msg);
      CWRITELOG(L_LOTRACE,0,
"$GpiExcludeClipRectangle RGN_COMPLEX Test                       -    PASS.\n");
    }
    else
      check_rtn((INT) complx, hWndClient, "GpiExcludeClipRectangle");
    GpiSetClipRegion(hPS, NULLHANDLE, NULL);
    GpiDestroyRegion(hPS, hrgn);
    CWRITELOG(L_LOTRACE,0,"+ix+ Test Indicator RGN_COMPLEX - Exit\n");

    /*******************************/
    /* Test for Indicator RGN_RECT */
    /*******************************/
    CWRITELOG(L_LOTRACE,0,"+ie+ Test Indicator RGN_RECT - Entry\n");
    MapAndWriteString(hPS, 4 * delta_x, 5 * delta_y + delta_y/4, " <<< Rectangular Region >>>");

    region[0].xLeft = MapX(5 * delta_x);        /*****************************/
    region[0].yBottom = MapY(delta_y);                  /*modified to have a rectangle*/
    region[0].xRight = MapX(7 * delta_x);       /*of 2X4                      */
    region[0].yTop = MapY(5 * delta_y);         /*Modified by Hengli Jia, FVT */
                                                                                                                        /******************************/

    hrgn = GpiCreateRegion(hPS,    // Create region in presentation space
                            1L,     // of one rectangle using coordinates
                            region); // from region.

    /***********************************************************/
    /* Test GpiSetClipRegion for Complexity Indicator RGN_RECT */
    /***********************************************************/
    complx = GpiSetClipRegion(hPS,  // set region created to a clipping region
                             hrgn,
                             NULL);
    if (complx == RGN_RECT)   // check if indicator equals RGN_RECT
    {
      ptl.x = 3 * delta_x;
      ptl.y = 7 * delta_y;
      display_text(hPS, ptl.x, ptl.y, str1_msg);
      CWRITELOG(L_LOTRACE,0, "GpiSetClipRegion RGN_RECT Test                        -    PASS.\n");
    }
    else
      check_rtn((INT) complx, hWndClient, "GpiSetClipRegion");

    exclude.xLeft = MapX(6 * delta_x);   /*********************************/
    exclude.yBottom = MapY(delta_y);      /*Exclude the rectangle 1X4 of 2X4*/
    exclude.xRight = MapX(7 * delta_x);  /*Modified by Hengli Jia, FVT */
    exclude.yTop = MapY(5 * delta_y);    /*********************************/
    complx = GpiExcludeClipRectangle(hPS, &exclude);
    if (complx == RGN_RECT)   // check if indicator equals RGN_RECT
    {
      ptl.x = 4 * delta_x;
      ptl.y = 7 * delta_y;
      display_text(hPS, ptl.x, ptl.y, str2_msg);
      CWRITELOG(L_LOTRACE,0,"GpiExcludeClipRectangle RGN_RECT Test                 -    PASS.\n");
    }
    else  //  FAILURE
      check_rtn((INT) complx, hWndClient, "GpiExcludeClipRectangle");
    GpiSetClipRegion(hPS, NULLHANDLE, NULL);
    GpiDestroyRegion(hPS, hrgn);
    CWRITELOG(L_LOTRACE,0,"+ix+ Test Indicator RGN_RECT - Exit\n");

    /********************************/
    /* Test for Indicator RGN_ERROR */
    /********************************/

    CWRITELOG(L_LOTRACE,0,"+ie+ Test Indicator RGN_ERROR - Entry\n");
    hrgn = GpiCreateRegion( hPS,      // create region in presentation space
                            1L,       // of one rectangle using coordinates
                            region);  // from region.

    /************************************************************/
    /* Test GpiSetClipRegion for Complexity Indicator RGN_ERROR */
    /************************************************************/
    complx = GpiSetClipRegion(0,  // set invalid presentation handle
                            hrgn,
                            NULL);

    if (complx == RGN_ERROR)   // check if indicator equals RGN_ERROR
      error_count += CHECKRETURNERROR(complx, "GpiSetClipRegion", SEVERITY_ERROR,PMERR_INV_HPS);
    else
      check_rtn((INT) complx, hWndClient, "GpiSetClipRegion");
    complx = GpiExcludeClipRectangle(0, &exclude);

    if (complx == RGN_ERROR)   // check if indicator is RGN_ERROR
      error_count += CHECKRETURNERROR(complx, "GpiExcludeClipRectangle", SEVERITY_ERROR,PMERR_INV_HPS);
    else
      check_rtn((INT) complx, hWndClient, "GpiExcludeClipRectangle");
    GpiDestroyRegion(hPS, hrgn);
    CWRITELOG(L_LOTRACE,0,"+ix+ Test Indicator RGN_ERROR - Exit\n");
    if (!error_count)
      CWRITELOG(L_HDR,0,
"$GpiExcludeClipRectangle                                        -    PASS.\n");
    else
    {
      sprintf(str1_msg, "$ERRORCOUNT = %d.\n", error_count);
      CWRITELOG(L_HDR,0, str1_msg);
      CWRITELOG(L_HDR,0,
"$GpiExcludeClipRectangle                                        -    FAIL.\n");
    }
    CWRITELOG(L_LOTRACE,0,"+ex+ Test GpiExcludeClipRectangle - Exit\n");
}

VOID query_clip_box(HPS hPS,HWND hWndClient)
{
  POINTL ptl; //, pt;
  RECTL region[5];
  RECTL rect_test;
  HRGN hrgn1;
  HRGN hrgn2;
  HRGN hrgn3;
  LONG complx;
  CHAR str_msg[100];


    TEST_SIGNATURE(0, 0);
    LOG_SIGNATURE;
    CWRITELOG(L_LOTRACE,0,"+ee+ Test GpiQueryClipBox - Entry\n");
    gpi_grid(hPS, (LONG)INCH);
    error_count = 0;

    /*******************************/
    /* Test for Indicator RGN_NULL */
    /*******************************/
    CWRITELOG(L_LOTRACE,0,"+ie+ Test Indicator RGN_NULL - Entry\n");
    region[0].xLeft = MapX(5 * delta_x);
    region[0].yBottom = MapY(delta_y);
    region[0].xRight = MapX(6 * delta_x);
    region[0].yTop = MapY(delta_y);

    hrgn1 = GpiCreateRegion(hPS,    // Create region in presentation space
                           1L,      // of one rectangle using coordinates
                           region); // from region.

    /***********************************************************/
    /* Test GpiSetClipRegion for Complexity Indicator RGN_NULL */
    /***********************************************************/
    complx = GpiSetClipRegion(hPS,   // set region created to a clipping region
                            hrgn1,
                            NULL);
    if (complx == RGN_NULL)   // check if indicator equals RGN_NULL
    {
      /* This string should never appear on the screen */
      MapAndWriteString(hPS, delta_x, 3 * delta_y, "THIS SHOULD NEVER APPEAR ON THE SCREEN OR PAPER !!!");
      CWRITELOG(L_LOTRACE,0,"GpiSetClipRegion RGN_NULL Test                        -    PASS.\n");
    }
    else
      check_rtn((INT) complx, hWndClient, "GpiSetClipRegion");

    complx = GpiQueryClipBox(hPS,         // query the region, to get
                            &rect_test);  // the tightest rectangle

    if (complx == RGN_NULL)   // check if indicator equals RGN_NULL
      CWRITELOG(L_LOTRACE,0,"GpiQueryClipBox RGN_NULL Test                         -    PASS.\n");
    else
      check_rtn((INT) complx, hWndClient, "GpiQueryClipBox");

    GpiSetClipRegion(hPS, NULLHANDLE, NULL);
    GpiDestroyRegion(hPS, hrgn1);
    CWRITELOG(L_LOTRACE,0,"+ix+ Test Indicator RGN_NULL - Exit\n");

    /**********************************/
    /* Test for Indicator RGN_COMPLEX */
    /**********************************/
    CWRITELOG(L_LOTRACE,0,"+ie+ Test Indicator RGN_COMPLEX - Entry\n");
    strcpy(str_msg, "CLIPPING AREA FOR A COMPLEX REGION");
    MapAndWriteString(hPS, delta_x - delta_x/2, 6 * delta_y + delta_y/4, str_msg);
    region[0].xLeft = MapX(delta_x);
    region[0].yBottom = MapY(delta_y);
    region[0].xRight = MapX(2 * delta_x);
    region[0].yTop = MapY(2 * delta_y);

    region[1].xLeft = MapX(2 * delta_x);
    region[1].yBottom = MapY(2 * delta_y);
    region[1].xRight = MapX(3 * delta_x);
    region[1].yTop = MapY(3 * delta_y);

    region[2].xLeft = MapX(delta_x);
    region[2].yBottom = MapY(3 * delta_y);
    region[2].xRight = MapX(2 * delta_x);
    region[2].yTop = MapY(4 * delta_y);

    region[3].xLeft = MapX(2 * delta_x);
    region[3].yBottom = MapY(4 * delta_y);
    region[3].xRight = MapX(3 * delta_x);
    region[3].yTop = MapY(5 * delta_y);

    region[4].xLeft = MapX(delta_x);
    region[4].yBottom = MapY(5 * delta_y);
    region[4].xRight = MapX(2 * delta_x);
    region[4].yTop = MapY(6 * delta_y);

    hrgn2 = GpiCreateRegion(hPS,     // create region in presentation space
                            5L,      // of five rectangles using coordinates
                            region); // from region.

    /**************************************************************/
    /* Test GpiSetClipRegion for Complexity Indicator RGN_COMPLEX */
    /**************************************************************/
    complx = GpiSetClipRegion(hPS,   // set region created to a clipping region
                            hrgn2,
                            NULL);

    if ( complx == RGN_COMPLEX )   // check if indicator is RGN_COMPLEX
      CWRITELOG(L_LOTRACE,0,"GpiSetClipRegion RGN_COMPLEX Test                     -    PASS.\n");
    else
      check_rtn((INT) complx, hWndClient, "GpiSetClipRegion");

    complx = GpiQueryClipBox( hPS,          // query the region to get
                              &rect_test);  // the tightest rectangle

    if (complx == RGN_COMPLEX)   // check if indicator equals RGN_COMPLEX
    {
      ptl.x = 0;
      ptl.x = delta_x - delta_x/2;
      ptl.y = 6 * delta_y;
      display_text(hPS, ptl.x, ptl.y, str_msg);
      CWRITELOG(L_LOTRACE,0,"GpiQueryClipBox RGN_COMPLEX Test                      -    PASS.\n");
    }
    else  //  FAILURE
      check_rtn((INT) complx, hWndClient, "GpiQueryClipBox");

    GpiSetClipRegion(hPS, NULLHANDLE, NULL);
    GpiDestroyRegion(hPS, hrgn2);
    CWRITELOG(L_LOTRACE,0,"+ix+ Test Indicator RGN_COMPLEX - Exit\n");

    /*******************************/
    /* Test for Indicator RGN_RECT */
    /*******************************/
    CWRITELOG(L_LOTRACE,0,"+ie+ Test Indicator RGN_RECT - Entry\n");
    strcpy(str_msg, "   CLIPPING AREA FOR");
    MapAndWriteString(hPS, 4 * delta_x, 5 * delta_y + delta_y/2, str_msg);
    strcpy(str_msg, "   A RECTANGULAR REGION");
    MapAndWriteString(hPS, 4 * delta_x, 5 * delta_y + delta_y/4, str_msg);

    region[0].xLeft = MapX(5 * delta_x);
    region[0].yBottom = MapY(delta_y);
    region[0].xRight = MapX(6 * delta_x);
    region[0].yTop = MapY(5 * delta_y);

    hrgn3 = GpiCreateRegion( hPS,      // create region in presentation space
                             1L,       // of one rectangle using coordinates
                             region); // from region.

    /***********************************************************/
    /* Test GpiSetClipRegion for Complexity Indicator RGN_RECT */
    /***********************************************************/
    complx = GpiSetClipRegion(hPS,   // set region created to a clipping region
                              hrgn3,
                              NULL);

    if (complx == RGN_RECT)   // check if indicator is RGN_RECT
      CWRITELOG(L_LOTRACE,0,"GpiSetClipRegion RGN_RECT Test                        -    PASS.\n");
    else
      check_rtn((INT) complx, hWndClient, "GpiSetClipRegion");

    complx = GpiQueryClipBox(hPS,          // query the region to get
                             &rect_test);  // the tightest rectangle

    if (complx == RGN_RECT )   // check if indicator is RGN_RECT
    {
      ptl.x = 4 * delta_x;
      ptl.y = 7 * delta_y;
      display_text(hPS, ptl.x, ptl.y, str_msg);
      CWRITELOG(L_LOTRACE,0, "GpiQueryClipBox RGN_RECT Test                         -    PASS.\n");
    }
    else  // FAILURE
      check_rtn((INT) complx, hWndClient, "GpiQueryClipBox");

    GpiSetClipRegion(hPS, NULLHANDLE, NULL);
    GpiDestroyRegion(hPS, hrgn3);
    CWRITELOG(L_LOTRACE,0,"+ix+ Test Indicator RGN_RECT - Exit\n");

    /********************************/
    /* Test for Indicator RGN_ERROR */
    /********************************/
    CWRITELOG(L_LOTRACE,0,"+ie+ Test Indicator RGN_ERROR - Entry\n");
    hrgn3 = GpiCreateRegion( hPS,      // create region in presentation space
                             1L,       // of one rectangle using coordinates
                             region); // from region.

    /************************************************************/
    /* Test GpiSetClipRegion for Complexity Indicator RGN_ERROR */
    /************************************************************/
    complx = GpiSetClipRegion(0,   // pass an invalid region handle
                              hrgn3,
                              NULL);
    if (complx == RGN_ERROR)   // check if indicator is RGN_ERROR
      error_count += CHECKRETURNERROR(complx, "GpiSetClipRegion", SEVERITY_ERROR,PMERR_INV_HPS);
    else
      check_rtn((INT) complx, hWndClient, "GpiSetClipRegion");

    complx = GpiQueryClipBox(0, // query the region with a bad PS handle
                             &rect_test);
    if (complx == RGN_ERROR)   // check if indicator equals RGN_ERROR
      error_count += CHECKRETURNERROR(complx, "GpiQueryClipBox", SEVERITY_ERROR,PMERR_INV_HPS);
    else
      check_rtn((INT) complx, hWndClient, "GpiQueryClipBox");
    GpiDestroyRegion(hPS, hrgn3);
    CWRITELOG(L_LOTRACE,0,"+ix+ Test Indicator RGN_ERROR - Exit\n");
    if (!error_count)
      CWRITELOG(L_HDR,0,
"$GpiQueryClipBox                                                -    PASS.\n");
    else
    {
      sprintf(str_msg, "$ERRORCOUNT = %d.\n", error_count);
      CWRITELOG(L_HDR,0, str_msg);
      CWRITELOG(L_HDR,0,
"$GpiQueryClipBox                                                -    FAIL.\n");
    }
    CWRITELOG(L_LOTRACE, 0,"+ex+ Test GpiQueryClipBox - Exit\n");
} /* END - GpiSetClipRegion and GpiQueryClipBox EXHAUSTIVE TEST */

