

#define INCL_DEV      // include all DEV definitions
#define INCL_WIN
#define INCL_GPI      // include all Gpi definitions
#define INCL_ERRORS   // include all Gpi error definitions
#define INCL_FONTFILEFORMAT
#include <string.h>
#include <stdlib.h>
#include <os2.h>
#include <stdio.h>
#include <math.h>
#include "PTTDLLDF.h"               // test case defines
#include "common.h"
#include "gpichar.h"

#define PI 3.141592654
#define TWOPI 6.283185307
#define PISCALE  (PI / 180.0)
#define HALFPI (PI / 2.0)
#define LONGSCALEX 30000
#define LONGSCALEY 30000

/***************************************************************************
 *\\ddd
 * Routine Name: GpiCharStringExh
 *
 * Purpose:  This is an entry point for the PTT that causes exhaustive
 *           testing of GpiCharString()
 *
 * System Requirements: Section ???
 *
 * Revision Log: 01/08/91, PDVT, Stanley Logan
 *               - created initial template
 *               - TestCase Design
 *               - Modified font selection algorithm for rotated lines
 *               - Corrected a storage allocation problem
 *               - Corrected problem with test signature
 *
 *
 * Inputs:
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    SelectionCall  // selection parameter
 *
 * Outputs:
 *
 * Subroutines Required:
 *              ENTER_MAIN
 *              SHOWERROR
 *              TEST_SIGNATURE
 *              DeviceIsDisplay
 *              EzQueryFonts
 *              EzCreateLogicalFonts
 *              CreateSysOutlineFont
 *              LOGINFO
 *              EXIT_MAIN
 *
 * Limitations:
 *              NONE
 *
 *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 *
 *      Allocate memory for the output string.
 *      Set current character mode to CM_MODE3.
 *      Set current character box to 15 characters per inch.
 *      Set angle to 90 degrees.
 *      Position and draw 512 character long string.
 *      Set current character box to 7 characters per inch.
 *      Draw explanatory remark about string with tiny characters.
 *      Set current character box to 6 characters per inch.
 *      Set current character mode to CM_MODE1.
 *      Set angle to 0 degrees.
 *      Position character pointer.
 *      Query the fonts to get match numbers and facenames.
 *      For index = 0 until index = # of fonts
 *              Create logical font[index].
 *              Set current font to newly created logical font.
 *              Query to get the fontmetrics structure.
 *              Set current character position.
 *              Draw string containing font name and GpiCharString.
 *              Increment y field of the character position.
 *              If character position is at top of page, start new page.
 *              Delete newly created logical font.
 *      End for
 *      De-allocate space for output string.
 *
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiCharStringExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
        static PCHAR    EntryName="GpiCharStringExh";   //      entry point name
        POINTL          ptl;         //      point structure
        GRADIENTL       Angle;       //      angle vector structure
        SIZEF           Box;         //      character box structure
        LONG              i,         //      loop variable
                        Count,       //      number of public fonts
                        ErrorCount;  //      error count
        CHAR            *out;        //      output string
        PTEMPTYPE       FontStorage; //      font structure
        FONTMETRICS     fm;          //      fontmetrics structure
        HDC             hDC;         //      device context
        BOOL            fontfound=FALSE;
        LONG            lcid;        //      logical font id
        SIZEL           DefCharBox;  // default box structure
        SIZEF           CharBox;     // character box structure
        LONG num = 2080L;

        if (SelectionCall) {
                WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
                *pBasisX = 10000;
                *pBasisY = 10000;
        }
        else {
                ENTER_MAIN(EntryName);

//      Call GpiQueryDefCharBox() to determine the default character box.
//      This character box will be used to reset the character box
//      for test signature output

                if(GpiQueryDefCharBox(hPS, &DefCharBox)==FALSE)
                        SHOWERROR("GpiQueryDefCharBox", EntryName);

                CharBox.cx = (FIXED)(DefCharBox.cx * 65536.0);
                CharBox.cy = (FIXED)(DefCharBox.cy * 65536.0);

// Allocate memory for output string
                if((out=malloc(num * sizeof(CHAR)))==NULL) {
                        SHOWERROR("malloc", EntryName);
                        return;
                };

// Build output string
                sprintf(out,"This text should fall off of the edge.  It is 512 "
                                                "characters long, which is the maximum number of ch"
                                                "aracters which GpiCharString can handle.  If we ad"
                                                "d another character to this string, we would expec"
                                                "t an error to occur (PMERR_INV_LENGTH_OR_COUNT).  "
                                                "We will do this as well in order to test the retur"
                                                "n code received from GpiCharString.  This string i"
                                                "s getting quite large, and I never realized exactl"
                                                "y how hard it is to write 512 characters and form "
                                                "a coherent sentence which makes sense.  The end ap"
                                                "proaches.  ");

// Set up conditions for drawing text sideways up the left side of the page
// An outline font is required for mode 3

              lcid=5;
              if ((fontfound=CreateSysOutlineFont(hPS,hWndClient,lcid,NULL,
                                                  FATTR_SEL_OUTLINE))==FALSE)
               {
                SHOWERROR("CreateSysOutlineFontGpiCharString", EntryName);
                } // end if
               else
               {
                if(GpiSetCharSet(hPS, lcid)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

                if(GpiSetCharMode(hPS, CM_MODE3)==FALSE)
                        SHOWERROR("GpiSetCharMode", EntryName);

                Box.cx = (LONG)(MapX(delta_x / 15.0) * 65536.0);
                Box.cy = Box.cx;
                if(GpiSetCharBox(hPS, &Box)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

                Angle.x = 0;
                Angle.y = 1;
                if(GpiSetCharAngle(hPS, &Angle)==FALSE)
                        SHOWERROR("GpiSetCharAngle", EntryName);

                ptl.x = (LONG)(0.5 * delta_x);
                ptl.y = (LONG)(0.75 * delta_y);
                MapPt(ptl);

                if(GpiMove(hPS, &ptl)==FALSE)
                        SHOWERROR("GpiMove", EntryName);

                if(GpiCharString(hPS, (LONG)strlen(out), out)==GPI_ERROR)
                        SHOWERROR("GpiCharString", EntryName);

// Set up conditions for drawing explanatory string alongside tiny string
                Box.cx = (LONG)(MapX(delta_x / 7.0) * 65536.0);
                  //TSS...was Box.cy = Box.cx
                Box.cy = (LONG)(MapY(delta_y / 7.0) * 65536.0);
                if(GpiSetCharBox(hPS, &Box)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

                ptl.x = (LONG)(0.25 * delta_x);
                ptl.y = (LONG)(0.75 * delta_y);
                MapPt(ptl);

                if(GpiMove(hPS, &ptl)==FALSE)
                        SHOWERROR("GpiMove", EntryName);

                sprintf(out, "Adjacent line tiny due to large number of characters");

                if(GpiCharString(hPS, (LONG)strlen(out), out)==GPI_ERROR)
                        SHOWERROR("GpiCharString", EntryName);

                if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

                if(GpiDeleteSetId(hPS, lcid)==FALSE)
                        SHOWERROR("GpiDeleteSetId", EntryName);

               }    // end else - CreateSysOutlineFont

// Set up conditions to print all fonts
                Box.cx = (LONG)(MapX(delta_x / 6.0) * 65536.0);
                   //TSS...was Box.cy = Box.cx
                Box.cy = (LONG)(MapY(delta_y / 6.0) * 65536.0);
                if(GpiSetCharBox(hPS, &Box)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

                if(GpiSetCharMode(hPS, CM_MODE1)==FALSE)
                        SHOWERROR("GpiSetCharMode", EntryName);

                Angle.x = 1;
                Angle.y = 0;
                if(GpiSetCharAngle(hPS, &Angle)==FALSE)
                        SHOWERROR("GpiSetCharAngle", EntryName);

                ptl.x = (LONG)(0.75 * delta_x);
                ptl.y = (LONG)(0.75 * delta_y);
                MapPt(ptl);

                if(GpiMove(hPS, &ptl)==FALSE)
                        SHOWERROR("GpiMove", EntryName);

// Query to get all fontnames and match numbers
                EzQueryFonts(hPS, hWndClient, QF_PUBLIC, &Count, &FontStorage);

// Get DC handle for DevEscape call
                hDC = GpiQueryDevice(hPS);

// For each font found, create it, then make it the current font. The
// fontmetrics is queried, and the current character position pointer is
// updated.  The output string is built and drawn to the device.  Following
// this, the y coordinate of the pointer is incremented.  If at the top of
// the page, start a new page, draw test signature, and continue loop.
                for(i = 0; i < Count; i++) {
                        EzCreateLogicalFonts(hPS, hWndClient, 150L, FontStorage[i]);

// Select newly created logical font
                        if(GpiSetCharSet(hPS, 150L)==FALSE)
                                SHOWERROR("GpiSetCharSet", EntryName);

                        if (GpiQueryFontMetrics(hPS, (LONG)sizeof(FONTMETRICS), &fm)== FALSE)
                                SHOWERROR("GpiQueryFontMetrics", EntryName);

                        if(GpiMove(hPS, &ptl)==FALSE)
                                SHOWERROR("GpiMove", EntryName);

                        sprintf(out, "%s by GpiCharString", FontStorage[i].Fontname);

                        if(GpiCharString(hPS, (LONG)strlen(out), out)==GPI_ERROR)
                                SHOWERROR("GpiCharString", EntryName);

                   ptl.y += 2 * fm.lMaxBaselineExt;

      // Quit if the output is to the display and the current
      // position is 3/4 inches from the top of the page.

                        if ((UnMapY(ptl.y) >= ((pg_size_y * delta_y) - 75L))
                             && DeviceIsDisplay())
                                break;

      // If the output is to the printer and the current position
      // is 1/4 inch from the top of the page, start a new page,
      // print the test signature in the same font as the first page,
      // and reset the y coordinates.

                        if ((UnMapY(ptl.y) >= ((pg_size_y * delta_y) - 25L))
                            && (i < Count - 1) && DeviceIsPrinter()) {
                                if ((DevEscape(hDC, DEVESC_NEWFRAME, 0L, NULL, 0L, NULL))
                                              == DEVESC_ERROR)
                                        SHOWERROR("DevEscape", EntryName);
                           /*
                                if (!GpiSetCharSet(hPS,DESIRED_FONT_ID))
                                        SHOWERROR("GpiSetCharSet", EntryName); */

                                if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                                      SHOWERROR("GpiSetCharSet", EntryName);


      // Set character box to be equal to default character box size.

                                if(GpiSetCharBox(hPS, &CharBox)==FALSE)
                                    SHOWERROR("GpiSetCharBox", EntryName);

                                TEST_SIGNATURE(0,0);

                                ptl.y = MapY(0.75 * delta_y);
                        }      // end if

                        else if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                                SHOWERROR("GpiSetCharSet", EntryName);

// Delete newly created logical fonts
                        if(GpiDeleteSetId(hPS, 150L)==FALSE)
                                SHOWERROR("GpiDeleteSetId", EntryName);
                } //end for
                // Fontstorage allocated by ezQueryFonts
                if (FontStorage != NULL) DosFreeMem(FontStorage);

                free(out);

                if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

// Delete all logical fonts
                if(GpiDeleteSetId(hPS, LCID_ALL)==FALSE)
                        SHOWERROR("GpiDeleteSetId", EntryName);

                EXIT_MAIN(EntryName);
        }
}


/***************************************************************************
 *\\ddd
 * Routine Name: GpiCharStringAtExh
 *
 * Purpose:  This is an entry point for the PTT that causes exhaustive
 *           testing of GpiCharStringAt()
 *
 * System Requirements: Section ???
 *
 * Revision Log: 01/08/91, PDVT, Stanley Logan
 *               - created initial template
 *               - TestCase Design
 *               - Changed the way font processing was done for rotated text
 *               - Freed font storage
 *               - Corrected problem with test signature
 *
 * Inputs:
 *
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    SelectionCall  // selection parameter
 *
 * Outputs:
 *    NONE
 *
 * Subroutines Required:
 *              ENTER_MAIN
 *              SHOWERROR
 *              TEST_SIGNATURE
 *              DeviceIsDisplay
 *              EzQueryFonts
 *              EzCreateLogicalFonts
 *              CreateSysOutlineFont
 *              LOGINFO
 *              EXIT_MAIN
 *
 * Limitations:
 *              NONE
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *      Allocate memory for the output string.
 *      Set current character mode to CM_MODE3.
 *      Set current character box to 15 characters per inch.
 *      Set angle to 90 degrees.
 *      Draw 512 character long string at specified position.
 *      Set current character box to 7 characters per inch.
 *      Draw explanatory remark about string with tiny characters.
 *      Set current character box to 6 characters per inch.
 *      Set current character mode to CM_MODE1.
 *      Set angle to 0 degrees.
 *      Query the fonts to get match numbers and facenames.
 *      For index = 0 until index = # of fonts
 *              Create logical font[index].
 *              Set current font to newly created logical font.
 *              Query to get the fontmetrics structure.
 *              Draw string containing font name and GpiCharStringAt at specified pos.
 *              Increment y field of the character position.
 *              If character position is at top of page, start new page.
 *              Delete newly created logical font.
 *      End for
 *      De-allocate space for output string.
 *
 *\\end
 ***************************************************************************/
VOID APIENTRY  GpiCharStringAtExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
        static PCHAR    EntryName="GpiCharStringAtExh"; //      entry point name
        POINTL          ptl;              //      point structure
        GRADIENTL       Angle;            //      angle vector structure
        SIZEF           Box;              //      character box structure
        LONG            i,                //      loop variable
                        Count,            //      number of public fonts
                        ErrorCount;       //      error count
        CHAR            *out;             //      output string
        PTEMPTYPE       FontStorage;      //      font structure
        FONTMETRICS     fm;               //      fontmetrics structure
        HDC             hDC;              //      device context
        BOOL            fontfound=FALSE;
        LONG            lcid;             //      logical font id
        SIZEL           DefCharBox;            // default box structure
        SIZEF           CharBox;               // character box structure
        LONG num = 2080L;

        if (SelectionCall) {
                WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
                *pBasisX = 10000;
                *pBasisY = 10000;
        }
        else {
                ENTER_MAIN(EntryName);

//      Call GpiQueryDefCharBox() to determine the default character box.
//      This character box will be used to reset the character box
//      for test signature output

                if(GpiQueryDefCharBox(hPS, &DefCharBox)==FALSE)
                        SHOWERROR("GpiQueryDefCharBox", EntryName);

                CharBox.cx = (FIXED)(DefCharBox.cx * 65536.0);
                CharBox.cy = (FIXED)(DefCharBox.cy * 65536.0);

// Allocate memory for output string
                if((out=malloc(num * sizeof(CHAR)))==NULL) {
                        SHOWERROR("malloc", EntryName);
                        return;
                };

// Build output string
                sprintf(out,"This text should fall off of the edge.  It is 512 "
                                                "characters long, which is the maximum number of ch"
                                                "aracters which GpiCharStringAt can handle.  If we "
                                                "add another character to this string, we would exp"
                                                "ect an error to occur (PMERR_INV_LENGTH_OR_COUNT)."
                                                "  We will do this as well in order to test the ret"
                                                "urn code received from GpiCharString.  This string"
                                                " is getting quite large, and I never realized exac"
                                                "tly how hard it is to write 512 characters and for"
                                                "m a coherent sentence which makes sense.  The end "
                                                "approaches.");

// Set up conditions for drawing text sideways up the left side of the page
// An outline font is required for mode 3

              lcid=5;
              if ((fontfound=CreateSysOutlineFont(hPS,hWndClient,lcid,NULL,
                             FATTR_SEL_OUTLINE|FATTR_SEL_UNDERSCORE))==FALSE)
               {
                SHOWERROR("CreateSysOutlineFontGpiCharString", EntryName);
                } // end if
               else
               {
                if(GpiSetCharSet(hPS, lcid)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

                if(GpiSetCharMode(hPS, CM_MODE3)==FALSE)
                        SHOWERROR("GpiSetCharMode", EntryName);

                Box.cx = (LONG)(MapX(delta_x / 15.0) * 65536.0);
                   //TSS...was Box.cy = Box.cx
                Box.cy = (LONG)(MapY(delta_y / 15.0) * 65536.0);
                if (hPS==NULLHANDLE)
                        SHOWERROR("hPS is NULL", EntryName);

                if(GpiSetCharBox(hPS, &Box)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

                Angle.x = 0;
                Angle.y = 1;
                if(GpiSetCharAngle(hPS, &Angle)==FALSE)
                        SHOWERROR("GpiSetCharAngle", EntryName);

                ptl.x = (LONG)(0.5 * delta_x);
                ptl.y = (LONG)(0.75 * delta_y);
                MapPt(ptl);

                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(out), out)==GPI_ERROR)
                        SHOWERROR("GpiCharStringAt", EntryName);

// Set up conditions for drawing explanatory string alongside tiny string
                Box.cx = (LONG)(MapX(delta_x / 7.0) * 65536.0);
                   //TSS...was Box.cy = Box.cx
                Box.cy = (LONG)(MapY(delta_y / 7.0) * 65536.0);
                if(GpiSetCharBox(hPS, &Box)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

                ptl.x = (LONG)(0.25 * delta_x);
                ptl.y = (LONG)(0.75 * delta_y);
                MapPt(ptl);

                if(GpiMove(hPS, &ptl)==FALSE)
                        SHOWERROR("GpiMove", EntryName);

                sprintf(out, "Adjacent line tiny due to large number of characters");

                if(GpiCharString(hPS, (LONG)strlen(out), out)==GPI_ERROR)
                        SHOWERROR("GpiCharString", EntryName);

                if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

                if(GpiDeleteSetId(hPS, lcid)==FALSE)
                        SHOWERROR("GpiDeleteSetId", EntryName);

               }                // end else - CreateSysOutlineFont
// Set up conditions to print all fonts
                Box.cx = (LONG)(MapX(delta_x / 6.0) * 65536.0);
                   //TSS...was Box.cy = Box.cx
                Box.cy = (LONG)(MapY(delta_y / 6.0) * 65536.0);
                if(GpiSetCharBox(hPS, &Box)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

                if(GpiSetCharMode(hPS, CM_MODE1)==FALSE)
                        SHOWERROR("GpiSetCharMode", EntryName);

                Angle.x = 1;
                Angle.y = 0;
                if(GpiSetCharAngle(hPS, &Angle)==FALSE)
                        SHOWERROR("GpiSetCharAngle", EntryName);

                ptl.x = (LONG)(0.75 * delta_x);
                ptl.y = (LONG)(0.75 * delta_y);
                MapPt(ptl);

// Query to get all fontnames and match numbers
                EzQueryFonts(hPS, hWndClient, QF_PUBLIC, &Count, &FontStorage);

// Get DC handle for DevEscape call
                hDC = GpiQueryDevice(hPS);

// For each font found, create it, then make it the current font. The
// fontmetrics is queried, and the current character position pointer is
// updated.  The output string is built and drawn to the device.  Following
// this, the y coordinate of the pointer is incremented.  If at the top of
// the page, start a new page, draw test signature, and continue loop.
                for(i = 0; i < Count; i++) {
                        EzCreateLogicalFonts(hPS, hWndClient, 150L, FontStorage[i]);

// Select newly created logical font
                        if(GpiSetCharSet(hPS, 150L)==FALSE)
                                SHOWERROR("GpiSetCharSet", EntryName);

                        if (GpiQueryFontMetrics(hPS, (LONG)sizeof(FONTMETRICS), &fm)== FALSE)
                                SHOWERROR("GpiQueryFontMetrics", EntryName);

                        sprintf(out, "%s by GpiCharStringAt", FontStorage[i].Fontname);

                        if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(out), out)==GPI_ERROR)
                                SHOWERROR("GpiCharStringAt", EntryName);

                   ptl.y += 2 * fm.lMaxBaselineExt;

      // Quit if the output is to the display and the current
      // position is 3/4 inches from the top of the page.

                        if ((UnMapY(ptl.y) >= ((pg_size_y * delta_y) - 75L))
                                 && DeviceIsDisplay())
                                break;

      // If the output is to the printer and the current position
      // is 1/4 inch from the top of the page, start a new page,
      // print the test signature in the same font as the first page,
      // and reset the y coordinates.

                        if ((UnMapY(ptl.y) >= ((pg_size_y * delta_y) - 25L))
                              && (i < Count - 1) && DeviceIsPrinter()) {
                                if ((DevEscape(hDC, DEVESC_NEWFRAME, 0L, NULL, 0L, NULL))
                                                            == DEVESC_ERROR)
                                        SHOWERROR("DevEscape", EntryName);

                            /*    if (!GpiSetCharSet(hPS,DESIRED_FONT_ID))
                                        SHOWERROR("GpiSetCharSet", EntryName);  */
                                if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                                      SHOWERROR("GpiSetCharSet", EntryName);

      // Set character box to be equal to default character box size.

                                if(GpiSetCharBox(hPS, &CharBox)==FALSE)
                                    SHOWERROR("GpiSetCharBox", EntryName);

                                TEST_SIGNATURE(0,0);

                                ptl.y = MapY(0.75 * delta_y);
                        } // end if

                        else if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                                    SHOWERROR("GpiSetCharSet", EntryName);

// Delete newly created logical fonts
                        if(GpiDeleteSetId(hPS, 150L)==FALSE)
                                SHOWERROR("GpiDeleteSetId", EntryName);
                } // end for

                free(out);

                // Fontstorage allocated by ezQueryFonts
                if (FontStorage != NULL) DosFreeMem(FontStorage);

                if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

// Delete all logical fonts
                if(GpiDeleteSetId(hPS, LCID_ALL)==FALSE)
                        SHOWERROR("GpiDeleteSetId", EntryName);

                EXIT_MAIN(EntryName);
        }
}


/***************************************************************************
 *\\ddd
 * Routine Name: GpiCharStringPosAndQryExh
 *
 * Purpose:  This is an entry point for the PTT that causes exhaustive
 *           testing of GpiSetCharStringPos()
 *
 * System Requirements: Section ???
 *
 * Revision Log: 01/08/91, PDVT, Stanley Logan
 *               - created initial template
 *               - TestCase Design
 *               - Corrected multiple page output and put back to mode2
 *               - Modified font selection for rotated text
 *               - Corrected problem with the test signature
 *
 *
 * Inputs:
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    SelectionCall  // selection parameter
 *
 * Outputs:
 *    NONE
 *
 * Subroutines Required:
 *              ENTER_MAIN
 *              SHOWERROR
 *              TEST_SIGNATURE
 *              DeviceIsDisplay
 *              EzQueryFonts
 *              EzCreateLogicalFonts
 *              CreateSystemOutlineFont
 *              LOGINFO
 *              EXIT_MAIN
 *
 * Limitations:
 *              NONE
 *
 *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 *
 *      Allocate memory for the increments array.
 *      Allocate memory for the output string.
 *      Set current character mode to CM_MODE3.
 *      Query to get the fontmetrics structure.
 *      Set current character box to 15 characters per inch.
 *      Set angle to 90 degrees.
 *      Set character increments to the maximum increment for the font.
 *      Position and draw 512 character long string.
 *      Set current character box to 7 characters per inch.
 *      Draw explanatory remark about string with tiny characters.
 *      Set current character box to 5 characters per inch.
 * Build string.
 *      Set character increments to the maximum increment for the font.
 *      Position and draw string, leaving position at beginning of string.
 *      Redraw string with characters appended.
 *      Set current character mode to CM_MODE2.
 *      Set angle to 0 degrees.
 *      Position character pointer.
 *      Query the fonts to get match numbers and facenames.
 *      For index = 0 until index = # of fonts
 *              Create logical font[index].
 *              Set current font to newly created logical font.
 *              Query to get the fontmetrics structure.
 *              Query to get the default character box size.
 *      Set character box to default character box size.
 *              Set current character position.
 *      Build string containing font name and GpiCharString.
 *      Query to get the box coordinates surrounding the string.
 *              Set character increments to the maximum increment for the font.
 *              Draw string, clipping on text box surrounding string.
 *              Increment y field of the character position.
 *              If character position is at top of page, start new page.
 *              Delete newly created logical font.
 *      End for
 *      De-allocate space for font storage
 *      De-allocate space for the increments array.
 *      De-allocate space for output string.
 *
 *\\end
 ***************************************************************************/
VOID APIENTRY  GpiCharStringPosAndQryExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
        static PCHAR    EntryName="GpiCharStringPosAndQryExh"; // entry point name
        POINTL                  ptl,                                   // point structure
                                Points[TXTBOX_COUNT],                  // text box coords.
                                Points2[TXTBOX_COUNT];                  // text box coords.
        RECTL                   Rect;                                  // clipping rectangle
        GRADIENTL               Angle;                                 // angle structure
        SIZEF                   Box;                                   // character box
        LONG                    i,                                     // loop variable
                                j,                                     // loop variable
                               *Adx,                                   // increments array
                                Count,                                 // number of fonts
                                ErrorCount;                            // error count
        CHAR                   *out;                                   // output string
        CHAR                    tempout[2];
        PTEMPTYPE               FontStorage;                           // font structure
        FONTMETRICS             fm;                                    // fontmetrics struct
        HDC                     hDC;                                   //      device context
        BOOL                    fontfound=FALSE;
        LONG                    lcid;                                  //      logical font id
        SIZEL                   DefCharBox;              // default box structure
        SIZEF                   CharBox;                 // character box structure

        LONG num = 2080L;

        if (SelectionCall) {
                WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
                *pBasisX = 10000;
                *pBasisY = 10000;
        }
        else {
                ENTER_MAIN(EntryName);

//      Call GpiQueryDefCharBox() to determine the default character box.
//      This character box will be used to reset the character box
//      for test signature output

                if(GpiQueryDefCharBox(hPS, &DefCharBox)==FALSE)
                        SHOWERROR("GpiQueryDefCharBox", EntryName);

                CharBox.cx = (FIXED)(DefCharBox.cx * 65536.0);
                CharBox.cy = (FIXED)(DefCharBox.cy * 65536.0);


// Allocate memory for increments array
               if((Adx=malloc(num * sizeof(LONG)))==NULL) {
                        SHOWERROR("malloc", EntryName);
                }


// Allocate memory for output string
               if((out=malloc(num * sizeof(CHAR)))==NULL) {
                       SHOWERROR("malloc", EntryName);
               }


// Build output string
                sprintf(out,"This text should fall off of the edge.  It is 512 "
                            "characters long, which is the maximum number of ch"
                            "aracters which GpiCharStringPos can handle.  If we"
                            " add another character to this string, we would ex"
                            "pect an error to occur (PMERR_INV_LENGTH_OR_COUNT)"
                            ". We will do this as well in order to test the ret"
                            "urn code received from GpiCharString.  This string"
                            " is getting quite large, and I never realized exac"
                            "tly how hard it is to write 512 characters and for"
                            "m a coherent sentence which makes sense.  The end "
                            "approaches.");

// Set up conditions for drawing text sideways up the left side of the page
// An outline font is required for mode 3

              lcid=5;
              if ((fontfound=CreateSysOutlineFont(hPS,hWndClient,lcid,NULL,
                                                    FATTR_SEL_OUTLINE))==FALSE)
               {
                SHOWERROR("CreateSysOutlineFontGpiCharString", EntryName);
                } // end if
               else
               {
                if(GpiSetCharSet(hPS, lcid)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

                if(GpiSetCharMode(hPS, CM_MODE3)==FALSE)
                        SHOWERROR("GpiSetCharMode", EntryName);

                Box.cx = (FIXED)(MapX(delta_x / 15.0) * 65536.0);
                   //TSS...was Box.cy = Box.cx
                Box.cy = (FIXED)(MapY(delta_y / 15.0) * 65536.0);
                if(GpiSetCharBox(hPS, &Box)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

                if(GpiQueryFontMetrics(hPS, (LONG)sizeof(FONTMETRICS), &fm)== FALSE)
                        SHOWERROR("GpiQueryFontMetrics", EntryName);

                Angle.x = 0;
                Angle.y = 1;
                if(GpiSetCharAngle(hPS, &Angle)==FALSE)
                        SHOWERROR("GpiSetCharAngle", EntryName);

                ptl.x = (LONG)(0.5 * delta_x);
                ptl.y = (LONG)(0.75 * delta_y);
                MapPt(ptl);

                if(GpiMove(hPS, &ptl)==FALSE)
                        SHOWERROR("GpiMove", EntryName);

                for(j = 0; j < (INT)strlen(out); j++)
                        Adx[j] = fm.lMaxCharInc + j / 100;
                    //    Adx[j] = fm.lAveCharWidth;

                if(GpiCharStringPos(hPS, NULL, CHS_VECTOR,
                                   (LONG)strlen(out), out, Adx)==GPI_ERROR)
                        SHOWERROR("GpiCharStringPos", EntryName);

// Set up conditions for drawing explanatory string alongside tiny string
                Box.cx = (LONG)(MapX(delta_x / 7.0) * 65536.0);
                   //TSS...was Box.cy = Box.cx
                Box.cy = (LONG)(MapY(delta_y / 7.0) * 65536.0);
                if(GpiSetCharBox(hPS, &Box)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

                ptl.x = (LONG)(0.35 * delta_x);
                ptl.y = (LONG)(0.75 * delta_y);
                MapPt(ptl);

                if(GpiMove(hPS, &ptl)==FALSE)
                        SHOWERROR("GpiMove", EntryName);

                sprintf(out, "Adjacent line tiny due to large number of characters");

                if(GpiCharString(hPS, (LONG)strlen(out), out)==GPI_ERROR)
                        SHOWERROR("GpiCharString", EntryName);

// Set up conditions for drawing two overlapping lines of text
                Box.cx = (LONG)(MapX(delta_x / 5.0) * 65536.0);
                   //TSS...was Box.cy = Box.cx
                Box.cy = (LONG)(MapY(delta_y / 5.0) * 65536.0);
                if(GpiSetCharBox(hPS, &Box)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

                sprintf(out,"Only one line of text should appear.");

// Calculate increments array for longest string of two overlapping lines
                for(j = 0; j < (INT)strlen(out); j++)
                        Adx[j] = fm.lMaxCharInc;

                ptl.x = (LONG)(0.2 * delta_x);
                ptl.y = (LONG)(0.75 * delta_y);
                MapPt(ptl);

                if(GpiMove(hPS, &ptl)==FALSE)
                        SHOWERROR("GpiMove", EntryName);

                sprintf(out,"Only one line of text");

// Draw first (shorter) line
                if(GpiCharStringPos(hPS, NULL, CHS_LEAVEPOS,
                                   (LONG)strlen(out), out, Adx)==GPI_ERROR)
                        SHOWERROR("GpiCharStringPos", EntryName);

                sprintf(out,"Only one line of text should appear.");

// Draw second (longer) line.  This line should superimpose itself on the
// first line.
                if(GpiCharStringPos(hPS, NULL, NULLHANDLE, (LONG)strlen(out), out, Adx)
                                                                                                                                                                                ==GPI_ERROR)
                        SHOWERROR("GpiCharStringPos", EntryName);

                if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

                if(GpiDeleteSetId(hPS, lcid)==FALSE)
                        SHOWERROR("GpiDeleteSetId", EntryName);

                } // end else - CreateSysOutlineFont

                if(GpiSetCharMode(hPS, CM_MODE2)==FALSE)
                        SHOWERROR("GpiSetCharMode", EntryName);

//TSS...Reset the angle 0 degrees....9/22/92
                Angle.x = 1;
                Angle.y = 0;
                if(GpiSetCharAngle(hPS, &Angle)==FALSE)
                        SHOWERROR("GpiSetCharAngle", EntryName);


                ptl.x = (LONG)(0.75 * delta_x);
                ptl.y = (LONG)(0.75 * delta_y);
                MapPt(ptl);

                if(GpiMove(hPS, &ptl)==FALSE)
                        SHOWERROR("GpiMove", EntryName);

// Query to get all fontnames and match numbers
                EzQueryFonts(hPS, hWndClient, QF_PUBLIC, &Count, &FontStorage);

// Get DC handle for DevEscape call
                hDC = GpiQueryDevice(hPS);

// For each font found, create it, then make it the current font. The
// fontmetrics is queried, and the current character position pointer is
// updated.  The output string is built and drawn to the device.  Following
// this, the y coordinate of the pointer is incremented.  If at the top of
// the page, start a new page, draw test signature, and continue loop.
                              // 30 was count
             //   for(i = 0; i < 30; i++) {
                for(i = 0; i < Count; i++) {
                        EzCreateLogicalFonts(hPS, hWndClient, 150L, FontStorage[i]);

// Select newly created logical font
                        if(GpiSetCharSet(hPS, 150L)==FALSE)
                                SHOWERROR("GpiSetCharSet", EntryName);

// Query to get fontmetrics structure for current font
                        if (GpiQueryFontMetrics(hPS, (LONG)sizeof(FONTMETRICS), &fm)== FALSE)
                                SHOWERROR("GpiQueryFontMetrics", EntryName);

                        // set the character box

                        if (fm.fsDefn & FM_DEFN_OUTLINE) { // outline font
                            Box.cx = MAKEFIXED(MapX(delta_x / 5.0),0);
                            Box.cy = MAKEFIXED(MapY(delta_y / 5.0),0);
                        }
                        else  // image font
                        {
                            Box.cx = MAKEFIXED(fm.lEmInc,0);
                            Box.cy = MAKEFIXED(fm.lEmHeight,0);
                        }

                       if(GpiSetCharBox(hPS, &Box)==FALSE)
                            SHOWERROR("GpiSetCharBox", EntryName);

                        if(GpiMove(hPS, &ptl)==FALSE)
                                SHOWERROR("GpiMove", EntryName);

                        sprintf(out, "%s by GpiCharStringPos", FontStorage[i].Fontname);

// Query to get the text box coordinates surrounding text string
                        if(GpiQueryTextBox(hPS, (LONG)strlen(out), out, TXTBOX_COUNT,
                                                               Points)==FALSE)
                                SHOWERROR("GpiQueryTextBox", EntryName);

// Set up clipping rectangle coordinates
                        Rect.xLeft      = Points[TXTBOX_BOTTOMLEFT].x + ptl.x;
                        Rect.yBottom    = Points[TXTBOX_BOTTOMLEFT].y + ptl.y;
                        Rect.xRight     = Points[TXTBOX_TOPRIGHT].x + ptl.x;
                        Rect.yTop       = Points[TXTBOX_TOPLEFT].y + ptl.y;

                        tempout[1] = '\0';

// Calculate increments array for output string
                        for(j = 0; j < (INT)strlen(out); j++) {

                           tempout[0] = out[j];
                           if(GpiQueryTextBox(hPS, (LONG)strlen(tempout), tempout, TXTBOX_COUNT,
                                                               Points2)==FALSE)
                                SHOWERROR("GpiQueryTextBox", EntryName);

                           Adx[j] = Points2[TXTBOX_CONCAT].x;

                        }


              //                  Adx[j] = fm.lMaxCharInc;

                        if(GpiCharStringPos(hPS, &Rect, CHS_VECTOR | CHS_OPAQUE | CHS_CLIP,
                                       (LONG)strlen(out), out, Adx)==GPI_ERROR)
                                SHOWERROR("GpiCharStringPos", EntryName);

                   ptl.y += 2 * fm.lMaxBaselineExt;

      // Quit if the output is to the display and the current
      // position is 3/4 inches from the top of the page.

                        if ((UnMapY(ptl.y) >= ((pg_size_y * delta_y) - 75L))
                                                 && DeviceIsDisplay())
                                break;
      // If the output is to the printer and the current position
      // is 1/4 inch from the top of the page, start a new page,
      // print the test signature in the same font as the first page,
      // and reset the y coordinates.

                        if ((UnMapY(ptl.y) >= ((pg_size_y * delta_y) - 25L))
                            && (i < Count - 1) && DeviceIsPrinter()) {
                                if ((DevEscape(hDC, DEVESC_NEWFRAME, 0L, NULL, 0L, NULL))
                                              == DEVESC_ERROR)
                                        SHOWERROR("DevEscape", EntryName);

                                if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                                      SHOWERROR("GpiSetCharSet", EntryName);

      // Set character box to be equal to default character box size.

                                if(GpiSetCharBox(hPS, &CharBox)==FALSE)
                                    SHOWERROR("GpiSetCharBox", EntryName);

                                TEST_SIGNATURE(0,0);

                                ptl.y = MapY(0.75 * delta_y);
                        }      // end if


                        else if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                                SHOWERROR("GpiSetCharSet", EntryName);

// Delete newly created logical fonts
                        if(GpiDeleteSetId(hPS, 150L)==FALSE)
                                SHOWERROR("GpiDeleteSetId", EntryName);
                }  // end for

                free(Adx);
                free(out);

                // Fontstorage allocated by ezQueryFonts
                if (FontStorage != NULL) DosFreeMem(FontStorage);

                if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

// Delete all logical fonts
                if(GpiDeleteSetId(hPS, LCID_ALL)==FALSE)
                        SHOWERROR("GpiDeleteSetId", EntryName);

                EXIT_MAIN(EntryName);
        }
}


/***************************************************************************
 *\\ddd
 * Routine Name: GpiCharStringPosAndQryShadeExh
 *
 * Purpose:  This is an entry point for the PTT that causes exhaustive
 *           testing of GpiCharStringPos()
 *
 * System Requirements: Section ???
 *
 * Revision Log: ????
 *               - Corrected multiple page output and put back to mode2
 *
 *
 * Inputs:
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    SelectionCall  // selection parameter
 *
 * Outputs:
 *    NONE
 *
 * Subroutines Required:
 *              ENTER_MAIN
 *              SHOWERROR
 *              TEST_SIGNATURE
 *              DeviceIsDisplay
 *              EzQueryFonts
 *              EzCreateLogicalFonts
 *              CreateSysOutlineFont
 *              LOGINFO
 *              EXIT_MAIN
 *
 * Limitations:
 *              NONE
 *
 *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 *
 *      Allocate memory for the increments array.
 *      Allocate memory for the output string.
 *      Set current character mode to CM_MODE3.
 *      Query to get the fontmetrics structure.
 *      Set current character box to 15 characters per inch.
 *      Set angle to 90 degrees.
 *      Set character increments to the maximum increment for the font.
 *      Position and draw 512 character long string.
 *      Set current character box to 7 characters per inch.
 *      Draw explanatory remark about string with tiny characters.
 *      Set current character box to 5 characters per inch.
 * Build string.
 *      Set character increments to the maximum increment for the font.
 *      Position and draw string, leaving position at beginning of string.
 *      Redraw string with characters appended.
 *      Set current character mode to CM_MODE2.
 *      Set angle to 0 degrees.
 *      Position character pointer.
 *      Query the fonts to get match numbers and facenames.
 *      For index = 0 until index = # of fonts
 *              Create logical font[index].
 *              Set current font to newly created logical font.
 *              Query to get the fontmetrics structure.
 *              Query to get the default character box size.
 *      Set character box to default character box size.
 *              Set current character position.
 *      Build string containing font name and GpiCharString.
 *      Query to get the box coordinates surrounding the string.
 *              Set character increments to the maximum increment for the font.
 *              Draw string, clipping on text box surrounding string.
 *              Increment y field of the character position.
 *              If character position is at top of page, start new page.
 *              Delete newly created logical font.
 *      End for
 *      De-allocate space for the increments array.
 *      De-allocate space for output string.
 *      De-allocate space for font storage
 *
 *\\end
 ***************************************************************************/
VOID APIENTRY  GpiCharStringPosAndQryShadeExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
        static PCHAR    EntryName="GpiCharStringPosAndQryShadeExh"; // entry point name
        POINTL                  ptl,                                   // point structure
                                Points[TXTBOX_COUNT],                  // text box coords.
                                Points2[TXTBOX_COUNT];                  // text box coords.
        RECTL                   Rect;                                  // clipping rectangle
        GRADIENTL               Angle;                                 // angle structure
        SIZEF                   Box;                                   // character box
        LONG                    i,                                     // loop variable
                                j,                                     // loop variable
                               *Adx,                                   // increments array
                                Count,                                 // number of fonts
                                ErrorCount;                            // error count
        CHAR                   *out;                                   // output string
        CHAR                    tempout[2];
        PTEMPTYPE               FontStorage;                           // font structure
        FONTMETRICS             fm;                                    // fontmetrics struct
        HDC                     hDC;                                   //      device context
        BOOL                    fontfound=FALSE;
        LONG                    lcid;                                  //      logical font id
        SIZEL                   DefCharBox;              // default box structure
        SIZEF                   CharBox;                 // character box structure

        LONG num = 2080L;

        if (SelectionCall) {
                WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
                *pBasisX = 10000;
                *pBasisY = 10000;
        }
        else {
                ENTER_MAIN(EntryName);
//      Call GpiQueryDefCharBox() to determine the default character box.
//      This character box will be used to reset the character box
//      for test signature output

                if(GpiQueryDefCharBox(hPS, &DefCharBox)==FALSE)
                        SHOWERROR("GpiQueryDefCharBox", EntryName);

                CharBox.cx = (FIXED)(DefCharBox.cx * 65536.0);
                CharBox.cy = (FIXED)(DefCharBox.cy * 65536.0);

 // set color used for shading

                GpiSetPattern(hPS,PATSYM_DENSE8);
                GpiSetColor(hPS,CLR_BLACK);
                GpiSetBackColor( hPS, CLR_GREEN );

// Allocate memory for increments array
                if((Adx=malloc(num * sizeof(LONG)))==NULL) {
                        SHOWERROR("malloc", EntryName);
                }

// Allocate memory for output string
                if((out=malloc(num * sizeof(CHAR)))==NULL) {
                        SHOWERROR("malloc", EntryName);
                }

// Build output string
                sprintf(out,"This text should fall off of the edge.  It is 512 "
                            "characters long, which is the maximum number of ch"
                            "aracters which GpiCharStringPos can handle.  If we"
                            " add another character to this string, we would ex"
                            "pect an error to occur (PMERR_INV_LENGTH_OR_COUNT)"
                            ". We will do this as well in order to test the ret"
                            "urn code received from GpiCharString.  This string"
                            " is getting quite large, and I never realized exac"
                            "tly how hard it is to write 512 characters and for"
                            "m a coherent sentence which makes sense.  The end "
                            "approaches.");

// Set up conditions for drawing text sideways up the left side of the page
// An outline font is required for mode 3

              lcid=5;
              if ((fontfound=CreateSysOutlineFont(hPS,hWndClient,lcid,NULL,
                                             FATTR_SEL_ITALIC))==FALSE)
               {
                SHOWERROR("CreateSysOutlineFontGpiCharString", EntryName);
                } // end if
               else
               {
                  if(GpiSetCharSet(hPS, lcid)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

                if(GpiSetCharMode(hPS, CM_MODE3)==FALSE)
                        SHOWERROR("GpiSetCharMode", EntryName);

                Box.cx = (FIXED)(MapX(delta_x / 15.0) * 65536.0);
                   //TSS...was Box.cy = Box.cx
                Box.cy = (FIXED)(MapY(delta_y / 15.0) * 65536.0);
                if(GpiSetCharBox(hPS, &Box)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

                if(GpiQueryFontMetrics(hPS, (LONG)sizeof(FONTMETRICS), &fm)== FALSE)
                        SHOWERROR("GpiQueryFontMetrics", EntryName);

                Angle.x = 0;
                Angle.y = 1;
                if(GpiSetCharAngle(hPS, &Angle)==FALSE)
                        SHOWERROR("GpiSetCharAngle", EntryName);

                ptl.x = (LONG)(0.5 * delta_x);
                ptl.y = (LONG)(0.75 * delta_y);
                MapPt(ptl);

                if(GpiMove(hPS, &ptl)==FALSE)
                        SHOWERROR("GpiMove", EntryName);

                for(j = 0; j < (INT)strlen(out); j++)
                        Adx[j] = fm.lMaxCharInc + j / 100;

                if(GpiCharStringPos(hPS, NULL, CHS_VECTOR,
                                         (LONG)strlen(out), out, Adx)==GPI_ERROR)
                        SHOWERROR("GpiCharStringPos", EntryName);

// Set up conditions for drawing explanatory string alongside tiny string
                Box.cx = (LONG)(MapX(delta_x / 7.0) * 65536.0);
                   //TSS...was Box.cy = Box.cx
                Box.cy = (LONG)(MapY(delta_y / 7.0) * 65536.0);
                if(GpiSetCharBox(hPS, &Box)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

                ptl.x = (LONG)(0.35 * delta_x);
                ptl.y = (LONG)(0.75 * delta_y);
                MapPt(ptl);

                if(GpiMove(hPS, &ptl)==FALSE)
                        SHOWERROR("GpiMove", EntryName);

                sprintf(out, "Adjacent line tiny due to large number of characters");

                if(GpiCharString(hPS, (LONG)strlen(out), out)==GPI_ERROR)
                        SHOWERROR("GpiCharString", EntryName);

// Set up conditions for drawing two overlapping lines of text
                Box.cx = (LONG)(MapX(delta_x / 5.0) * 65536.0);
                   //TSS...was Box.cy = Box.cx
                Box.cy = (LONG)(MapY(delta_y / 5.0) * 65536.0);
                if(GpiSetCharBox(hPS, &Box)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

                sprintf(out,"Only one line of text should appear.");

// Calculate increments array for longest string of two overlapping lines
                for(j = 0; j < (INT)strlen(out); j++)
                        Adx[j] = fm.lMaxCharInc;

                ptl.x = (LONG)(0.2 * delta_x);
                ptl.y = (LONG)(0.75 * delta_y);
                MapPt(ptl);

                if(GpiMove(hPS, &ptl)==FALSE)
                        SHOWERROR("GpiMove", EntryName);

                sprintf(out,"Only one line of text");

// Draw first (shorter) line

                if(GpiCharStringPos(hPS, NULL, CHS_LEAVEPOS,
                                    (LONG)strlen(out), out, Adx)==GPI_ERROR)
                        SHOWERROR("GpiCharStringPos", EntryName);

                sprintf(out,"Only one line of text should appear.");

// Draw second (longer) line.  This line should superimpose itself on the
// first line.

                if(GpiCharStringPos(hPS, NULL, NULLHANDLE, (LONG)strlen(out), out, Adx)
                                                                                                                                                                                ==GPI_ERROR)
                        SHOWERROR("GpiCharStringPos", EntryName);

                if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

                if(GpiDeleteSetId(hPS, lcid)==FALSE)
                        SHOWERROR("GpiDeleteSetId", EntryName);

               }    // end else - CreateSysOutlineFont

// Set up conditions to print all fonts    //was mode 2...tss
                if(GpiSetCharMode(hPS, CM_MODE2)==FALSE)
                        SHOWERROR("GpiSetCharMode", EntryName);

//TSS...Reset the angle 0 degrees....9/22/92
                Angle.x = 1;
                Angle.y = 0;
                if(GpiSetCharAngle(hPS, &Angle)==FALSE)
                        SHOWERROR("GpiSetCharAngle", EntryName);


                ptl.x = (LONG)(0.75 * delta_x);
                ptl.y = (LONG)(0.75 * delta_y);
                MapPt(ptl);

                if(GpiMove(hPS, &ptl)==FALSE)
                        SHOWERROR("GpiMove", EntryName);

// Query to get all fontnames and match numbers
                EzQueryFonts(hPS, hWndClient, QF_PUBLIC, &Count, &FontStorage);

// Get DC handle for DevEscape call
                hDC = GpiQueryDevice(hPS);

// For each font found, create it, then make it the current font. The
// fontmetrics is queried, and the current character position pointer is
// updated.  The output string is built and drawn to the device.  Following
// this, the y coordinate of the pointer is incremented.  If at the top of
// the page, start a new page, draw test signature, and continue loop.
                              // 30 was Count


                for(i = 0; i < Count; i++) {
                        EzCreateLogicalFonts(hPS, hWndClient, 150L, FontStorage[i]);

// Select newly created logical font
                        if(GpiSetCharSet(hPS, 150L)==FALSE)
                                SHOWERROR("GpiSetCharSet", EntryName);

// Query to get fontmetrics structure for current font
                        if (GpiQueryFontMetrics(hPS, (LONG)sizeof(FONTMETRICS), &fm)== FALSE)
                                SHOWERROR("GpiQueryFontMetrics", EntryName);

                        // set the character box

                        if (fm.fsDefn & FM_DEFN_OUTLINE) { // outline font
                            Box.cx = MAKEFIXED(MapX(delta_x / 5.0),0);
                            Box.cy = MAKEFIXED(MapY(delta_y / 5.0),0);
                        }
                        else  // image font
                        {
                            Box.cx = MAKEFIXED(fm.lEmInc,0);
                            Box.cy = MAKEFIXED(fm.lEmHeight,0);
                        }

                       if(GpiSetCharBox(hPS, &Box)==FALSE)
                            SHOWERROR("GpiSetCharBox", EntryName);

                        if(GpiMove(hPS, &ptl)==FALSE)
                                SHOWERROR("GpiMove", EntryName);

                        sprintf(out, "%s by GpiCharStringPos", FontStorage[i].Fontname);

// Query to get the text box coordinates surrounding text string
                        if(GpiQueryTextBox(hPS, (LONG)strlen(out), out, TXTBOX_COUNT,
                                                               Points)==FALSE)
                                SHOWERROR("GpiQueryTextBox", EntryName);

// Set up clipping rectangle coordinates
                        Rect.xLeft      = Points[TXTBOX_BOTTOMLEFT].x + ptl.x;
                        Rect.yBottom    = Points[TXTBOX_BOTTOMLEFT].y + ptl.y;
                        Rect.xRight     = Points[TXTBOX_TOPRIGHT].x + ptl.x;
                        Rect.yTop       = Points[TXTBOX_TOPLEFT].y + ptl.y;

                        tempout[1] = '\0';

// Calculate increments array for output string
                        for(j = 0; j < (INT)strlen(out); j++) {

                           tempout[0] = out[j];
                           if(GpiQueryTextBox(hPS, (LONG)strlen(tempout), tempout, TXTBOX_COUNT,
                                                               Points2)==FALSE)
                                SHOWERROR("GpiQueryTextBox", EntryName);

                           Adx[j] = Points2[TXTBOX_CONCAT].x;

                        }

                        if(GpiCharStringPos(hPS, &Rect, CHS_VECTOR | CHS_OPAQUE | CHS_CLIP,
                                       (LONG)strlen(out), out, Adx)==GPI_ERROR)
                                SHOWERROR("GpiCharStringPos", EntryName);

                   ptl.y += 2 * fm.lMaxBaselineExt;

      // Quit if the output is to the display and the current
      // position is 3/4 inches from the top of the page.

                        if ((UnMapY(ptl.y) >= ((pg_size_y * delta_y) - 75L))
                                                 && DeviceIsDisplay())
                                break;
      // If the output is to the printer and the current position
      // is 1/4 inch from the top of the page, start a new page,
      // print the test signature in the same font as the first page,
      // and reset the y coordinates.

                        if ((UnMapY(ptl.y) >= ((pg_size_y * delta_y) - 25L))
                            && (i < Count - 1) && DeviceIsPrinter()) {
                                if ((DevEscape(hDC, DEVESC_NEWFRAME, 0L, NULL, 0L, NULL))
                                              == DEVESC_ERROR)
                                        SHOWERROR("DevEscape", EntryName);

                                if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                                      SHOWERROR("GpiSetCharSet", EntryName);

      // Set character box to be equal to default character box size.

                                if(GpiSetCharBox(hPS, &CharBox)==FALSE)
                                    SHOWERROR("GpiSetCharBox", EntryName);

                                TEST_SIGNATURE(0,0);

                                ptl.y = MapY(0.75 * delta_y);
                        }      // end if


                        else if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                                SHOWERROR("GpiSetCharSet", EntryName);

// Delete newly created logical fonts
                        if(GpiDeleteSetId(hPS, 150L)==FALSE)
                                SHOWERROR("GpiDeleteSetId", EntryName);
                }  // end for

                free(Adx);
                free(out);

                // Fontstorage allocated by ezQueryFonts
                if (FontStorage != NULL) DosFreeMem(FontStorage);

                if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

// Delete all logical fonts
                if(GpiDeleteSetId(hPS, LCID_ALL)==FALSE)
                        SHOWERROR("GpiDeleteSetId", EntryName);

                EXIT_MAIN(EntryName);
        }
}



/***************************************************************************
 *\\ddd
 * Routine Name: GpiCharStringPosAndQryBoxExh
 *
 * Purpose:  This is an entry point for the PTT that causes exhaustive
 *           testing of GpiCharStringPos()
 *
 * System Requirements: Section ???
 *
 * Revision Log: ????
 *               - created initial template
 *               - TestCase Design
 *               - Corrected multiple page output and put back to mode2
 *               - Modified font selection for rotated text
 *               - Corrected character box for image fonts
 *
 *
 * Inputs:
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    SelectionCall  // selection parameter
 *
 * Outputs:
 *    NONE
 *
 * Subroutines Required:
 *              ENTER_MAIN
 *              SHOWERROR
 *              TEST_SIGNATURE
 *              DeviceIsDisplay
 *              EzQueryFonts
 *              EzCreateLogicalFonts
 *              CreateSysOutlineFont
 *              LOGINFO
 *              EXIT_MAIN
 *
 * Limitations:
 *              NONE
 *
 *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 *
 *      Allocate memory for the increments array.
 *      Allocate memory for the output string.
 *      Set current character mode to CM_MODE3.
 *      Query to get the fontmetrics structure.
 *      Set current character box to 15 characters per inch.
 *      Set angle to 90 degrees.
 *      Set character increments to the maximum increment for the font.
 *      Position and draw 512 character long string.
 *      Set current character box to 7 characters per inch.
 *      Draw explanatory remark about string with tiny characters.
 *      Set current character box to 5 characters per inch.
 * Build string.
 *      Set character increments to the maximum increment for the font.
 *      Position and draw string, leaving position at beginning of string.
 *      Redraw string with characters appended.
 *      Set current character mode to CM_MODE2.
 *      Set angle to 0 degrees.
 *      Position character pointer.
 *      Query the fonts to get match numbers and facenames.
 *      For index = 0 until index = # of fonts
 *              Create logical font[index].
 *              Set current font to newly created logical font.
 *              Query to get the fontmetrics structure.
 *              Query to get the default character box size.
 *      Set character box to default character box size for outline fonts.
 *      Set character box to M values for image font
 *              Set current character position.
 *      Build string containing font name and GpiCharString.
 *      Query to get the box coordinates surrounding the string.
 *              Draw boxes around characters in string
 *              Set character increments to the maximum increment for the font.
 *              Draw string, clipping on text box surrounding string.
 *              Increment y field of the character position.
 *              If character position is at top of page, start new page.
 *              Delete newly created logical font.
 *      End for
 *      De-allocate space for the increments array.
 *      De-allocate space for output string.
 *      De-allocate space for font storage.
 *
 *\\end
 ***************************************************************************/
VOID APIENTRY  GpiCharStringPosAndQryBoxExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
        static PCHAR    EntryName="GpiCharStringPosAndQryBoxExh"; // entry point name
        POINTL                  ptl,                     // point structure
                                ptl2,
                                ptl3,                    // used to calculate line spacing
                                ptlTemp,
                                Points[TXTBOX_COUNT],    // text box coords.
                                Points2[TXTBOX_COUNT];   // text box coords.
        RECTL                   Rect;                    // clipping rectangle
        GRADIENTL               Angle;                   // angle structure
        SIZEF                   Box;                     // character box
        LONG                    i,                       // loop variable
                                j,                       // loop variable
                               *Adx,                     // increments array
                                Count,                   // number of fonts
                                ErrorCount;              // error count
        CHAR                   *out;                     // output string
        CHAR                    tempout[2];
        PTEMPTYPE               FontStorage;             // font structure
        FONTMETRICS             fm;                      // fontmetrics struct
        HDC                     hDC;                     // device context
        BOOL                    fontfound=FALSE;
        LONG                    lcid;                    // logical font id
        SIZEL                   DefCharBox;              // default box structure
        SIZEF                   CharBox;                 // character box structure

        LONG num = 2080L;

        if (SelectionCall) {
                WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
                *pBasisX = 10000;
                *pBasisY = 10000;
        }
        else {
                ENTER_MAIN(EntryName);


//      Call GpiQueryDefCharBox() to determine the default character box.
//      This character box will be used to reset the character box
//      for test signature output

                if(GpiQueryDefCharBox(hPS, &DefCharBox)==FALSE)
                        SHOWERROR("GpiQueryDefCharBox", EntryName);

                CharBox.cx = (FIXED)(DefCharBox.cx * 65536.0);
                CharBox.cy = (FIXED)(DefCharBox.cy * 65536.0);

// Allocate memory for increments array
                if((Adx=malloc(num * sizeof(LONG)))==NULL) {
                        SHOWERROR("malloc", EntryName);
                }

// Allocate memory for output string
                if((out=malloc(num * sizeof(CHAR)))==NULL) {
                        SHOWERROR("malloc", EntryName);
                }

// Build output string
                sprintf(out,"This text should fall off of the edge.  It is 512 "
                            "characters long, which is the maximum number of ch"
                            "aracters which GpiCharStringPos can handle.  If we"
                            " add another character to this string, we would ex"
                            "pect an error to occur (PMERR_INV_LENGTH_OR_COUNT)"
                            ". We will do this as well in order to test the ret"
                            "urn code received from GpiCharString.  This string"
                            " is getting quite large, and I never realized exac"
                            "tly how hard it is to write 512 characters and for"
                            "m a coherent sentence which makes sense.  The end "
                            "approaches.");

// Set up conditions for drawing text sideways up the left side of the page

// An outline font is required for mode 3

              lcid=5;
              if ((fontfound=CreateSysOutlineFont(hPS,hWndClient,lcid,NULL,
                                                  FATTR_SEL_BOLD))==FALSE)
               {
                SHOWERROR("CreateSysOutlineFontGpiCharString", EntryName);
                } // end if
               else
               {
                if(GpiSetCharSet(hPS, lcid)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

                if(GpiSetCharMode(hPS, CM_MODE3)==FALSE)
                        SHOWERROR("GpiSetCharMode", EntryName);

                Box.cx = (FIXED)(MapX(delta_x / 15.0) * 65536.0);
                   //TSS...was Box.cy = Box.cx
                Box.cy = (FIXED)(MapY(delta_y / 15.0) * 65536.0);
                if(GpiSetCharBox(hPS, &Box)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

                if(GpiQueryFontMetrics(hPS, (LONG)sizeof(FONTMETRICS), &fm)== FALSE)
                        SHOWERROR("GpiQueryFontMetrics", EntryName);

                Angle.x = 0;
                Angle.y = 1;
                if(GpiSetCharAngle(hPS, &Angle)==FALSE)
                        SHOWERROR("GpiSetCharAngle", EntryName);

                ptl.x = (LONG)(0.5 * delta_x);
                ptl.y = (LONG)(0.75 * delta_y);
                MapPt(ptl);

                if(GpiMove(hPS, &ptl)==FALSE)
                        SHOWERROR("GpiMove", EntryName);

                for(j = 0; j < (INT)strlen(out); j++)
                        Adx[j] = fm.lMaxCharInc + j / 100;

                if(GpiCharStringPos(hPS, NULL, CHS_VECTOR,
                                         (LONG)strlen(out), out, Adx)==GPI_ERROR)
                        SHOWERROR("GpiCharStringPos", EntryName);

// Set up conditions for drawing explanatory string alongside tiny string
                Box.cx = (LONG)(MapX(delta_x / 7.0) * 65536.0);
                   //TSS...was Box.cy = Box.cx
                Box.cy = (LONG)(MapY(delta_y / 7.0) * 65536.0);
                if(GpiSetCharBox(hPS, &Box)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

                ptl.x = (LONG)(0.35 * delta_x);
                ptl.y = (LONG)(0.75 * delta_y);
                MapPt(ptl);

                if(GpiMove(hPS, &ptl)==FALSE)
                        SHOWERROR("GpiMove", EntryName);

                sprintf(out, "Adjacent line tiny due to large number of characters");

                if(GpiCharString(hPS, (LONG)strlen(out), out)==GPI_ERROR)
                        SHOWERROR("GpiCharString", EntryName);

// Set up conditions for drawing two overlapping lines of text
                Box.cx = (LONG)(MapX(delta_x / 5.0) * 65536.0);
                   //TSS...was Box.cy = Box.cx
                Box.cy = (LONG)(MapY(delta_y / 5.0) * 65536.0);
                if(GpiSetCharBox(hPS, &Box)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

                sprintf(out,"Only one line of text should appear.");

// Calculate increments array for longest string of two overlapping lines
                for(j = 0; j < (INT)strlen(out); j++)
                        Adx[j] = fm.lMaxCharInc;

                ptl.x = (LONG)(0.2 * delta_x);
                ptl.y = (LONG)(0.75 * delta_y);
                MapPt(ptl);

                if(GpiMove(hPS, &ptl)==FALSE)
                        SHOWERROR("GpiMove", EntryName);

                sprintf(out,"Only one line of text");

// Draw first (shorter) line
                if(GpiCharStringPos(hPS, NULL, CHS_LEAVEPOS,
                                        (LONG)strlen(out), out, Adx)==GPI_ERROR)
                        SHOWERROR("GpiCharStringPos", EntryName);

                sprintf(out,"Only one line of text should appear.");

// Draw second (longer) line.  This line should superimpose itself on the
// first line.
                if(GpiCharStringPos(hPS, NULL, NULLHANDLE, (LONG)strlen(out), out, Adx) == GPI_ERROR)
                        SHOWERROR("GpiCharStringPos", EntryName);

                if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

                if(GpiDeleteSetId(hPS, lcid)==FALSE)
                        SHOWERROR("GpiDeleteSetId", EntryName);

               }    // end else - CreateLogicalOutlineFont

// Set up conditions to print all fonts    //was mode 2...tss
                if(GpiSetCharMode(hPS, CM_MODE2)==FALSE)
                        SHOWERROR("GpiSetCharMode", EntryName);

//TSS...Reset the angle 0 degrees....9/22/92
                Angle.x = 1;
                Angle.y = 0;
                if(GpiSetCharAngle(hPS, &Angle)==FALSE)
                        SHOWERROR("GpiSetCharAngle", EntryName);


                ptl.x = (LONG)(0.75 * delta_x);
                ptl.y = (LONG)(0.75 * delta_y);
                MapPt(ptl);

                if(GpiMove(hPS, &ptl)==FALSE)
                        SHOWERROR("GpiMove", EntryName);


// Query to get all fontnames and match numbers
                EzQueryFonts(hPS, hWndClient, QF_PUBLIC, &Count, &FontStorage);

// Get DC handle for DevEscape call
                hDC = GpiQueryDevice(hPS);

// For each font found, create it, then make it the current font. The
// fontmetrics is queried, and the current character position pointer is
// updated.  The output string is built and drawn to the device.  Following
// this, the y coordinate of the pointer is incremented.  If at the top of
// the page, start a new page, draw test signature, and continue loop.
                             // 30 was Count
                for(i = 0; i < Count; i++) {
                        EzCreateLogicalFonts(hPS, hWndClient, 150L, FontStorage[i]);

// Select newly created logical font
                        if(GpiSetCharSet(hPS, 150L)==FALSE)
                                SHOWERROR("GpiSetCharSet", EntryName);

// Query to get fontmetrics structure for current font
                        if (GpiQueryFontMetrics(hPS, (LONG)sizeof(FONTMETRICS), &fm)== FALSE)
                                SHOWERROR("GpiQueryFontMetrics", EntryName);

                        // set the character box

                        if (fm.fsDefn & FM_DEFN_OUTLINE) { // outline font
                            Box.cx = MAKEFIXED(MapX(delta_x / 5.0),0);
                            Box.cy = MAKEFIXED(MapY(delta_y / 5.0),0);
                        }
                        else  // image font
                        {
                            Box.cx = MAKEFIXED(fm.lEmInc,0);
                            Box.cy = MAKEFIXED(fm.lEmHeight,0);
                        }

                       if(GpiSetCharBox(hPS, &Box)==FALSE)
                            SHOWERROR("GpiSetCharBox", EntryName);

                        if(GpiMove(hPS, &ptl)==FALSE)
                                SHOWERROR("GpiMove", EntryName);

                        sprintf(out, "%s by GpiCharStringPos", FontStorage[i].Fontname);

// Query to get the text box coordinates surrounding text string
                        if(GpiQueryTextBox(hPS, (LONG)strlen(out), out, TXTBOX_COUNT,
                                                               Points)==FALSE)
                                SHOWERROR("GpiQueryTextBox", EntryName);

// Set up clipping rectangle coordinates
                        Rect.xLeft      = Points[TXTBOX_BOTTOMLEFT].x + ptl.x;
                        Rect.yBottom    = Points[TXTBOX_BOTTOMLEFT].y + ptl.y;
                        Rect.xRight     = Points[TXTBOX_TOPRIGHT].x + ptl.x;
                        Rect.yTop       = Points[TXTBOX_TOPLEFT].y + ptl.y;

                        tempout[1] = '\0';
                        ptlTemp.x = ptl.x;
                        ptlTemp.y = ptl.y;

// Calculate increments array for output string
                        for(j = 0; j < (INT)strlen(out); j++) {

                           tempout[0] = out[j];
                           if(GpiQueryTextBox(hPS, (LONG)strlen(tempout), tempout, TXTBOX_COUNT,
                                                               Points2)==FALSE)
                                SHOWERROR("GpiQueryTextBox", EntryName);

                           ptl2.x = ptlTemp.x + Points2[TXTBOX_BOTTOMLEFT].x;
                           ptl2.y = ptlTemp.y + Points2[TXTBOX_BOTTOMLEFT].y;
                           GpiMove( hPS, &ptl2 );

                           ptl2.x = ptlTemp.x + Points2[TXTBOX_BOTTOMRIGHT].x;
                           ptl2.y = ptlTemp.y + Points2[TXTBOX_BOTTOMRIGHT].y;
                           GpiLine( hPS, &ptl2 );
                           ptl2.x = ptlTemp.x + Points2[TXTBOX_TOPRIGHT].x;
                           ptl2.y = ptlTemp.y + Points2[TXTBOX_TOPRIGHT].y;
                           GpiLine( hPS, &ptl2 );
                           ptl2.x = ptlTemp.x + Points2[TXTBOX_TOPLEFT].x;
                           ptl2.y = ptlTemp.y + Points2[TXTBOX_TOPLEFT].y;
                           ptl3.x=ptl2.x;
                           ptl3.y=ptl2.y;
                           GpiLine( hPS, &ptl2 );
                           ptl2.x = ptlTemp.x + Points2[TXTBOX_BOTTOMLEFT].x;
                           ptl2.y = ptlTemp.y + Points2[TXTBOX_BOTTOMLEFT].y;
                           GpiLine( hPS, &ptl2 );

                           ptlTemp.x += Points2[TXTBOX_CONCAT].x;
                           ptlTemp.y += Points2[TXTBOX_CONCAT].y;
                           GpiMove( hPS, &ptlTemp );

                           Adx[j] = Points2[TXTBOX_CONCAT].x;

                        }



                        GpiMove( hPS, &ptl );
                        if(GpiCharStringPos(hPS, &Rect, CHS_VECTOR | CHS_CLIP,
                                       (LONG)strlen(out), out, Adx)==GPI_ERROR)
                                SHOWERROR("GpiCharStringPos", EntryName);

                        ptl.y += 2 * (ptl3.y - ptl2.y);

      // Quit if the output is to the display and the current
      // position is 3/4 inches from the top of the page.

                        if ((UnMapY(ptl.y) >= ((pg_size_y * delta_y) - 75L))
                                                 && DeviceIsDisplay())
                                break;

      // If the output is to the printer and the current position
      // is 1/4 inch from the top of the page, start a new page,
      // print the test signature in the same font as the first page,
      // and reset the y coordinates.

                        if ((UnMapY(ptl.y) >= ((pg_size_y * delta_y) - 25L))
                            && (i < Count - 1) && DeviceIsPrinter()) {
                                if ((DevEscape(hDC, DEVESC_NEWFRAME, 0L, NULL, 0L, NULL))
                                              == DEVESC_ERROR)
                                        SHOWERROR("DevEscape", EntryName);

                                if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                                      SHOWERROR("GpiSetCharSet", EntryName);

      // Set character box to be equal to default character box size.

                                if(GpiSetCharBox(hPS, &CharBox)==FALSE)
                                    SHOWERROR("GpiSetCharBox", EntryName);

                                TEST_SIGNATURE(0,0);

                                ptl.y = MapY(0.75 * delta_y);
                        }      // end if


                        else if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                                SHOWERROR("GpiSetCharSet", EntryName);

// Delete newly created logical fonts
                        if(GpiDeleteSetId(hPS, 150L)==FALSE)
                                SHOWERROR("GpiDeleteSetId", EntryName);
                }

                free(Adx);
                free(out);

                // Fontstorage allocated by ezQueryFonts
                if (FontStorage != NULL) DosFreeMem(FontStorage);

                if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

// Delete all logical fonts
                if(GpiDeleteSetId(hPS, LCID_ALL)==FALSE)
                        SHOWERROR("GpiDeleteSetId", EntryName);

                EXIT_MAIN(EntryName);
        }
}


/***************************************************************************
 *\\ddd
 * Routine Name: GpiCharStringPosAtAndQryBoxExh
 *
 * Purpose:  This is an entry point for the PTT that causes exhaustive
 *           testing of GpiCharStringPosAt()
 *
 * System Requirements: Section ???
 *
 * Revision Log: ????
 *               - created initial template
 *               - TestCase Design
 *               - Corrected multiple page output and put back to mode2
 *               - Modified font selection for rotated text
 *               - Corrected character box for image fonts
 *
 *
 * Inputs:
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    SelectionCall  // selection parameter
 *
 * Outputs:
 *    NONE
 *
 * Subroutines Required:
 *              ENTER_MAIN
 *              SHOWERROR
 *              TEST_SIGNATURE
 *              DeviceIsDisplay
 *              EzQueryFonts
 *              EzCreateLogicalFonts
 *              CreateSysOutlineFont
 *              LOGINFO
 *              EXIT_MAIN
 *
 * Limitations:
 *              NONE
 *
 *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 *
 *      Allocate memory for the increments array.
 *      Allocate memory for the output string.
 *      Set current character mode to CM_MODE3.
 *      Query to get the fontmetrics structure.
 *      Set current character box to 15 characters per inch.
 *      Set angle to 90 degrees.
 *      Set character increments to the maximum increment for the font.
 *      Position and draw 512 character long string.
 *      Set current character box to 7 characters per inch.
 *      Draw explanatory remark about string with tiny characters.
 *      Set current character box to 5 characters per inch.
 * Build string.
 *      Set character increments to the maximum increment for the font.
 *      Position and draw string, leaving position at beginning of string.
 *      Redraw string with characters appended.
 *      Set current character mode to CM_MODE2.
 *      Set angle to 0 degrees.
 *      Position character pointer.
 *      Query the fonts to get match numbers and facenames.
 *      For index = 0 until index = # of fonts
 *              Create logical font[index].
 *              Set current font to newly created logical font.
 *              Query to get the fontmetrics structure.
 *              Query to get the default character box size.
 *      Set character box to default character box size for outline fonts.
 *      Set character box to M values for image font
 *              Set current character position.
 *      Build string containing font name and GpiCharString.
 *      Query to get the box coordinates surrounding the string.
 *              Draw boxes around characters in string
 *              Set character increments to the maximum increment for the font.
 *              Draw string, clipping on text box surrounding string.
 *              Increment y field of the character position.
 *              If character position is at top of page, start new page.
 *              Delete newly created logical font.
 *      End for
 *      De-allocate space for the increments array.
 *      De-allocate space for output string.
 *      De-allocate space for font storage.
 *
 *\\end
 ***************************************************************************/
VOID APIENTRY  GpiCharStringPosAtAndQryBoxExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
        static PCHAR    EntryName="GpiCharStringPosAtAndQryBoxExh";// entry point name
        POINTL          ptl,                     // point structure
                        ptl2,
                        ptlTemp,
                        Points[TXTBOX_COUNT],    // text box coords.
                        Points2[TXTBOX_COUNT];   // text box coords.
        RECTL           Rect;                    // clipping rectangle
        GRADIENTL       Angle;                   // angle structure
        SIZEF           Box;                     // character box
        LONG            i,                       // loop variable
                        j,                       // loop variable
                        *Adx,                    // increments array
                        Count,                   // number of fonts
                        ErrorCount;              // error count
        CHAR            *out;                    // output string
        CHAR            tempout[2];
        PTEMPTYPE       FontStorage;             // font structure
        FONTMETRICS     fm;                      // fontmetrics struct
        HDC             hDC;                     // device context
        BOOL            fontfound=FALSE;
        LONG            lcid;                    // logical font id
        SIZEL           DefCharBox;              // default box structure
        SIZEF           CharBox;                 // character box structure

        LONG num = 2080L;

        if (SelectionCall) {
                WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
                *pBasisX = 10000;
                *pBasisY = 10000;
        }
        else {
                ENTER_MAIN(EntryName);

//      Call GpiQueryDefCharBox() to determine the default character box.
//      This character box will be used to reset the character box
//      for test signature output

                if(GpiQueryDefCharBox(hPS, &DefCharBox)==FALSE)
                        SHOWERROR("GpiQueryDefCharBox", EntryName);

                CharBox.cx = (FIXED)(DefCharBox.cx * 65536.0);
                CharBox.cy = (FIXED)(DefCharBox.cy * 65536.0);


// Allocate memory for increments array
                if((Adx=malloc(num * sizeof(LONG)))==NULL) {
                        SHOWERROR("malloc", EntryName);
                }

// Allocate memory for output string
                if((out=malloc(num * sizeof(CHAR)))==NULL) {
                        SHOWERROR("malloc", EntryName);
                }

// Build output string
                sprintf(out,"This text should fall off of the edge.  It is 512 "
                            "characters long, which is the maximum number of ch"
                            "aracters which GpiCharStringPosAt can handle.  Ano"
                            "ther character onto to this string causes us to ex"
                            "pect an error to occur (PMERR_INV_LENGTH_OR_COUNT)"
                            ". We will do this as well in order to test the ret"
                            "urn code received from GpiCharString.  This string"
                            " is getting quite large, and I never realized exac"
                            "tly how hard it is to write 512 characters and for"
                            "m a coherent sentence which makes sense.  The end "
                            "approaches.");

// Set up conditions for drawing text sideways up the left side of the page

// An outline font is required for mode 3

              lcid=5;
              if ((fontfound=CreateSysOutlineFont(hPS,hWndClient,lcid,NULL,
                                              FATTR_SEL_BOLD))==FALSE)
               {
                SHOWERROR("CreateSysOutlineFontGpiCharString", EntryName);
                } // end if
               else
               {
                  if(GpiSetCharSet(hPS, lcid)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

                if(GpiSetCharMode(hPS, CM_MODE3)==FALSE)
                        SHOWERROR("GpiSetCharMode", EntryName);

                Box.cx = (LONG)(MapX(delta_x / 15.0) * 65536.0);
                   //TSS...was Box.cy = Box.cx
                Box.cy = (LONG)(MapY(delta_y / 15.0) * 65536.0);
                if(GpiSetCharBox(hPS, &Box)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

                if (GpiQueryFontMetrics(hPS, (LONG)sizeof(FONTMETRICS), &fm)== FALSE)
                        SHOWERROR("GpiQueryFontMetrics", EntryName);

                Angle.x = 0;
                Angle.y = 1;
                if(GpiSetCharAngle(hPS, &Angle)==FALSE)
                        SHOWERROR("GpiSetCharAngle", EntryName);

                ptl.x = (LONG)(0.5 * delta_x);
                ptl.y = (LONG)(0.75 * delta_y);
                MapPt(ptl);

                for(j = 0; j < (INT)strlen(out); j++)
                        Adx[j] = fm.lMaxCharInc + j / 100;

                if(GpiCharStringPosAt(hPS, &ptl, NULL, CHS_VECTOR,
                             (LONG)strlen(out), out, Adx)==GPI_ERROR)
                        SHOWERROR("GpiCharStringPosAt", EntryName);

// Set up conditions for drawing explanatory string alongside tiny string
                Box.cx = (LONG)(MapX(delta_x / 7.0) * 65536.0);
                   //TSS...was Box.cy = Box.cx
                Box.cy = (LONG)(MapY(delta_y / 7.0) * 65536.0);
                if(GpiSetCharBox(hPS, &Box)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

                ptl.x = (LONG)(0.35 * delta_x);
                ptl.y = (LONG)(0.75 * delta_y);
                MapPt(ptl);

                if(GpiMove(hPS, &ptl)==FALSE)
                        SHOWERROR("GpiMove", EntryName);

                sprintf(out, "Adjacent line tiny due to large number of characters");

                if(GpiCharString(hPS, (LONG)strlen(out), out)==GPI_ERROR)
                        SHOWERROR("GpiCharString", EntryName);

// Set up conditions for drawing two overlapping lines of text
                Box.cx = (LONG)(MapX(delta_x / 5.0) * 65536.0);
                   //TSS...was Box.cy = Box.cx
                Box.cy = (LONG)(MapY(delta_y / 5.0) * 65536.0);
                if(GpiSetCharBox(hPS, &Box)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

                sprintf(out,"Only one line of text should appear.");

// Calculate increments array for longest string of two overlapping lines
                for(j = 0; j < (INT)strlen(out); j++)
                        Adx[j] = fm.lMaxCharInc;

                Angle.x = 0;
                Angle.y = 1;
                if(GpiSetCharAngle(hPS, &Angle)==FALSE)
                        SHOWERROR("GpiSetCharAngle", EntryName);

                ptl.x = (LONG)(0.65 * delta_x);
                ptl.y = (LONG)(0.75 * delta_y);
                MapPt(ptl);

                if(GpiMove(hPS, &ptl)==FALSE)
                        SHOWERROR("GpiMove", EntryName);

                ptl.x = (LONG)(0.2 * delta_x);
                ptl.y = (LONG)(0.75 * delta_y);
                MapPt(ptl);

                sprintf(out,"Only one line of text");

// Calculate increments array for longest string of two overlapping lines
                if(GpiCharStringPosAt(hPS, &ptl, NULL, CHS_LEAVEPOS,
                                                                                                (LONG)strlen(out), out, Adx)==GPI_ERROR)
                        SHOWERROR("GpiCharStringPosAt", EntryName);

                sprintf(out,"Only one line of text should appear.");

// Draw second (longer) line.  This line should superimpose itself on the
// first line.
                if(GpiCharStringPos(hPS, NULL, NULLHANDLE,
                                                                                                (LONG)strlen(out), out, Adx)==GPI_ERROR)
                        SHOWERROR("GpiCharStringPos", EntryName);

                if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

                if(GpiDeleteSetId(hPS, lcid)==FALSE)
                        SHOWERROR("GpiDeleteSetId", EntryName);

               }    // end else - CreateLogicalOutlineFont

                if(GpiSetCharMode(hPS, CM_MODE2)==FALSE)
                        SHOWERROR("GpiSetCharMode", EntryName);

//TSS...Reset the angle 0 degrees....9/22/92
                Angle.x = 1;
                Angle.y = 0;
                if(GpiSetCharAngle(hPS, &Angle)==FALSE)
                        SHOWERROR("GpiSetCharAngle", EntryName);


                ptl.x = (LONG)(0.75 * delta_x);
                ptl.y = (LONG)(0.75 * delta_y);
                MapPt(ptl);

// Query to get all fontnames and match numbers
                EzQueryFonts(hPS, hWndClient, QF_PUBLIC, &Count, &FontStorage);


// Get DC handle for DevEscape call
                hDC = GpiQueryDevice(hPS);

// For each font found, create it, then make it the current font. The
// fontmetrics is queried, and the current character position pointer is
// updated.  The output string is built and drawn to the device.  Following
// this, the y coordinate of the pointer is incremented.  If at the top of
// the page, start a new page, draw test signature, and continue loop.
                             // 30 was Count
                for(i = 0; i < Count; i++) {
                        EzCreateLogicalFonts(hPS, hWndClient, 150L, FontStorage[i]);

// Select newly created logical font
                        if(GpiSetCharSet(hPS, 150L)==FALSE)
                                SHOWERROR("GpiSetCharSet", EntryName);

// Query to get fontmetrics structure for current font
                        if (GpiQueryFontMetrics(hPS, (LONG)sizeof(FONTMETRICS), &fm)== FALSE)
                                SHOWERROR("GpiQueryFontMetrics", EntryName);



                        // set the character box

                        if (fm.fsDefn & FM_DEFN_OUTLINE) { // outline font
                            Box.cx = MAKEFIXED(MapX(delta_x / 5.0),0);
                            Box.cy = MAKEFIXED(MapY(delta_y / 5.0),0);
                        }
                        else  // image font
                        {
                            Box.cx = MAKEFIXED(fm.lEmInc,0);
                            Box.cy = MAKEFIXED(fm.lEmHeight,0);
                        }

                       if(GpiSetCharBox(hPS, &Box)==FALSE)
                            SHOWERROR("GpiSetCharBox", EntryName);

                        sprintf(out,"%s by GpiCharStringPosAt",FontStorage[i].Fontname);

// Query to get the text box coordinates surrounding text string
                        if(GpiQueryTextBox(hPS, (LONG)strlen(out), out, TXTBOX_COUNT,
                                                                                                                                                                        Points)==FALSE)
                                SHOWERROR("GpiQueryTextBox", EntryName);

// Set up clipping rectangle coordinates
                        Rect.xLeft      = Points[TXTBOX_BOTTOMLEFT].x + ptl.x;
                        Rect.yBottom    = Points[TXTBOX_BOTTOMLEFT].y + ptl.y;
                        Rect.xRight     = Points[TXTBOX_TOPRIGHT].x + ptl.x;
                        Rect.yTop       = Points[TXTBOX_TOPLEFT].y + ptl.y;

                        tempout[1] = '\0';
                        ptlTemp.x = ptl.x;
                        ptlTemp.y = ptl.y;

// Calculate increments array for output string
                        for(j = 0; j < (INT)strlen(out); j++) {
                           tempout[0] = out[j];
                           if(GpiQueryTextBox(hPS, (LONG)strlen(tempout), tempout, TXTBOX_COUNT,
                                                               Points2)==FALSE)
                                SHOWERROR("GpiQueryTextBox", EntryName);

                           ptl2.x = ptlTemp.x + Points2[TXTBOX_BOTTOMLEFT].x;
                           ptl2.y = ptlTemp.y + Points2[TXTBOX_BOTTOMLEFT].y;
                           GpiMove( hPS, &ptl2 );

                           ptl2.x = ptlTemp.x + Points2[TXTBOX_BOTTOMRIGHT].x;
                           ptl2.y = ptlTemp.y + Points2[TXTBOX_BOTTOMRIGHT].y;
                           GpiLine( hPS, &ptl2 );
                           ptl2.x = ptlTemp.x + Points2[TXTBOX_TOPRIGHT].x;
                           ptl2.y = ptlTemp.y + Points2[TXTBOX_TOPRIGHT].y;
                           GpiLine( hPS, &ptl2 );
                           ptl2.x = ptlTemp.x + Points2[TXTBOX_TOPLEFT].x;
                           ptl2.y = ptlTemp.y + Points2[TXTBOX_TOPLEFT].y;
                           GpiLine( hPS, &ptl2 );
                           ptl2.x = ptlTemp.x + Points2[TXTBOX_BOTTOMLEFT].x;
                           ptl2.y = ptlTemp.y + Points2[TXTBOX_BOTTOMLEFT].y;
                           GpiLine( hPS, &ptl2 );

                           ptlTemp.x += Points2[TXTBOX_CONCAT].x;
                           ptlTemp.y += Points2[TXTBOX_CONCAT].y;
                           GpiMove( hPS, &ptlTemp );

                           Adx[j] = Points2[TXTBOX_CONCAT].x;
                        }


                        GpiMove( hPS, &ptl );
                        if(GpiCharStringPosAt(hPS, &ptl, &Rect, CHS_VECTOR |
                                                                        CHS_CLIP, (LONG)strlen(out), out, Adx)==GPI_ERROR)
                                SHOWERROR("GpiCharStringPosAt", EntryName);

                   ptl.y += 2 * fm.lMaxBaselineExt;

      // Quit if the output is to the display and the current
      // position is 3/4 inches from the top of the page.

                        if ((UnMapY(ptl.y) >= ((pg_size_y * delta_y) - 75L))
                                        && DeviceIsDisplay())
                                break;

      // If the output is to the printer and the current position
      // is 1/4 inch from the top of the page, start a new page,
      // print the test signature in the same font as the first page,
      // and reset the y coordinate.



                        if ((UnMapY(ptl.y) >= ((pg_size_y * delta_y) - 25L))
                            && (i < Count - 1) && DeviceIsPrinter()) {
                                if ((DevEscape(hDC, DEVESC_NEWFRAME, 0L, NULL, 0L, NULL))
                                              == DEVESC_ERROR)
                                        SHOWERROR("DevEscape", EntryName);

                                if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                                      SHOWERROR("GpiSetCharSet", EntryName);

      // Set character box to be equal to default character box size.

                                if(GpiSetCharBox(hPS, &CharBox)==FALSE)
                                    SHOWERROR("GpiSetCharBox", EntryName);

                                TEST_SIGNATURE(0,0);

                                ptl.y = MapY(0.75 * delta_y);
                        }      // end if


                        else if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                                SHOWERROR("GpiSetCharSet", EntryName);

// Delete newly created logical fonts
                        if(GpiDeleteSetId(hPS, 150L)==FALSE)
                                SHOWERROR("GpiDeleteSetId", EntryName);
                }

                free(Adx);
                free(out);

                // Fontstorage allocated by ezQueryFonts
                if (FontStorage != NULL) DosFreeMem(FontStorage);

                if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

// Delete all logical fonts
                if(GpiDeleteSetId(hPS, LCID_ALL)==FALSE)
                        SHOWERROR("GpiDeleteSetId", EntryName);

                EXIT_MAIN(EntryName);
        }
}

/***************************************************************************
 *\\ddd
 * Routine Name: GpiCharStringPosAtAndQryShdExh
 *
 * Purpose:  This is an entry point for the PTT that causes exhaustive
 *           testing of GpiCharStringPosAt()
 *
 * System Requirements: Section ???
 *
 * Revision Log: ????
 *               - Corrected multiple page output and put back to mode2
 *               - Corrected character box for image fonts
 *               - Corrected problem with test signature
 *
 *
 * Inputs:
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    SelectionCall  // selection parameter
 *
 * Outputs:
 *    NONE
 *
 * Subroutines Required:
 *              ENTER_MAIN
 *              SHOWERROR
 *              TEST_SIGNATURE
 *              DeviceIsDisplay
 *              EzQueryFonts
 *              EzCreateLogicalFonts
 *              CreateSysOutlineFont
 *              LOGINFO
 *              EXIT_MAIN
 *
 * Limitations:
 *              NONE
 *
 *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 *
 *      Allocate memory for the increments array.
 *      Allocate memory for the output string.
 *      Set current character mode to CM_MODE3.
 *      Query to get the fontmetrics structure.
 *      Set current character box to 15 characters per inch.
 *      Set angle to 90 degrees.
 *      Set character increments to the maximum increment for the font.
 *      Position and draw 512 character long string.
 *      Set current character box to 7 characters per inch.
 *      Draw explanatory remark about string with tiny characters.
 *      Set current character box to 5 characters per inch.
 * Build string.
 *      Set character increments to the maximum increment for the font.
 *      Position and draw string, leaving position at beginning of string.
 *      Redraw string with characters appended.
 *      Set current character mode to CM_MODE2.
 *      Set angle to 0 degrees.
 *      Position character pointer.
 *      Query the fonts to get match numbers and facenames.
 *      For index = 0 until index = # of fonts
 *              Create logical font[index].
 *              Set current font to newly created logical font.
 *              Query to get the fontmetrics structure.
 *              Query to get the default character box size.
 *      Set character box to default character box size.
 *              Set current character position.
 *      Build string containing font name and GpiCharString.
 *      Query to get the box coordinates surrounding the string.
 *              Set character increments to the maximum increment for the font.
 *              Draw string, clipping on text box surrounding string.
 *              Increment y field of the character position.
 *              If character position is at top of page, start new page.
 *              Delete newly created logical font.
 *      End for
 *      De-allocate space for the increments array.
 *      De-allocate space for output string.
 *      De-allocate space for font storage
 *
 *\\end
 ***************************************************************************/
VOID APIENTRY  GpiCharStringPosAtAndQryShdExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
        static PCHAR    EntryName="GpiCharStringPosAtAndQryShdExh";// entry point name
        POINTL          ptl,                    // point structure
                        Points[TXTBOX_COUNT],   // text box coords.
                        Points2[TXTBOX_COUNT];  // text box coords.
        RECTL           Rect;                   // clipping rectangle
        GRADIENTL       Angle;                  // angle structure
        SIZEF           Box;                    // character box
        LONG            i,                      // loop variable
                        j,                      // loop variable
                        *Adx,                   // increments array
                        Count,                  // number of fonts
                        ErrorCount;             // error count
        CHAR            *out;                   // output string
        CHAR            tempout[2];
        PTEMPTYPE       FontStorage;            // font structure
        FONTMETRICS     fm;                     // fontmetrics struct
        HDC             hDC;                     //      device context
        BOOL            fontfound=FALSE;
        LONG            lcid;                    // logical font id
        SIZEL           DefCharBox;              // default box structure
        SIZEF           CharBox;                 // character box structure

        LONG num = 2080L;

        if (SelectionCall) {
                WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
                *pBasisX = 10000;
                *pBasisY = 10000;
        }
        else {
                ENTER_MAIN(EntryName);

//      Call GpiQueryDefCharBox() to determine the default character box.
//      This character box will be used to reset the character box
//      for test signature output

                if(GpiQueryDefCharBox(hPS, &DefCharBox)==FALSE)
                        SHOWERROR("GpiQueryDefCharBox", EntryName);

                CharBox.cx = (FIXED)(DefCharBox.cx * 65536.0);
                CharBox.cy = (FIXED)(DefCharBox.cy * 65536.0);

 // set color for shading
                GpiSetColor(hPS,CLR_BLACK);
                GpiSetBackColor( hPS, CLR_GREEN );

// Allocate memory for increments array
                if((Adx=malloc(num * sizeof(LONG)))==NULL) {
                        SHOWERROR("malloc", EntryName);
                }

// Allocate memory for output string
                if((out=malloc(num * sizeof(CHAR)))==NULL) {
                        SHOWERROR("malloc", EntryName);
                }

// Build output string
                sprintf(out,"This text should fall off of the edge.  It is 512 "
                            "characters long, which is the maximum number of ch"
                            "aracters which GpiCharStringPosAt can handle.  Ano"
                            "ther character onto to this string causes us to ex"
                            "pect an error to occur (PMERR_INV_LENGTH_OR_COUNT)"
                            ". We will do this as well in order to test the ret"
                            "urn code received from GpiCharString.  This string"
                            " is getting quite large, and I never realized exac"
                            "tly how hard it is to write 512 characters and for"
                            "m a coherent sentence which makes sense.  The end "
                            "approaches.");

// Set up conditions for drawing text sideways up the left side of the page

// An outline font is required for mode 3

              lcid=5;
              if ((fontfound=CreateSysOutlineFont(hPS,hWndClient,lcid,NULL,
                                 FATTR_SEL_ITALIC))==FALSE)
               {
                SHOWERROR("CreateSysOutlineFontGpiCharString", EntryName);
                } // end if
               else
               {

                  if(GpiSetCharSet(hPS, lcid)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

                if(GpiSetCharMode(hPS, CM_MODE3)==FALSE)
                        SHOWERROR("GpiSetCharMode", EntryName);

                Box.cx = (LONG)(MapX(delta_x / 15.0) * 65536.0);
                   //TSS...was Box.cy = Box.cx
                Box.cy = (LONG)(MapY(delta_y / 15.0) * 65536.0);
                if(GpiSetCharBox(hPS, &Box)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

                if (GpiQueryFontMetrics(hPS, (LONG)sizeof(FONTMETRICS), &fm)== FALSE)
                        SHOWERROR("GpiQueryFontMetrics", EntryName);

                Angle.x = 0;
                Angle.y = 1;
                if(GpiSetCharAngle(hPS, &Angle)==FALSE)
                        SHOWERROR("GpiSetCharAngle", EntryName);

                ptl.x = (LONG)(0.5 * delta_x);
                ptl.y = (LONG)(0.75 * delta_y);
                MapPt(ptl);

                for(j = 0; j < (INT)strlen(out); j++)
                        Adx[j] = fm.lMaxCharInc + j / 100;

                if(GpiCharStringPosAt(hPS, &ptl, NULL, CHS_VECTOR,
                             (LONG)strlen(out), out, Adx)==GPI_ERROR)
                        SHOWERROR("GpiCharStringPosAt", EntryName);

// Set up conditions for drawing explanatory string alongside tiny string
                Box.cx = (LONG)(MapX(delta_x / 7.0) * 65536.0);
                   //TSS...was Box.cy = Box.cx
                Box.cy = (LONG)(MapY(delta_y / 7.0) * 65536.0);
                if(GpiSetCharBox(hPS, &Box)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

                ptl.x = (LONG)(0.35 * delta_x);
                ptl.y = (LONG)(0.75 * delta_y);
                MapPt(ptl);

                if(GpiMove(hPS, &ptl)==FALSE)
                        SHOWERROR("GpiMove", EntryName);

                sprintf(out, "Adjacent line tiny due to large number of characters");

                if(GpiCharString(hPS, (LONG)strlen(out), out)==GPI_ERROR)
                        SHOWERROR("GpiCharString", EntryName);

// Set up conditions for drawing two overlapping lines of text
                Box.cx = (LONG)(MapX(delta_x / 5.0) * 65536.0);
                   //TSS...was Box.cy = Box.cx
                Box.cy = (LONG)(MapY(delta_y / 5.0) * 65536.0);
                if(GpiSetCharBox(hPS, &Box)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

                sprintf(out,"Only one line of text should appear.");

// Calculate increments array for longest string of two overlapping lines
                for(j = 0; j < (INT)strlen(out); j++)
                        Adx[j] = fm.lMaxCharInc;

                Angle.x = 0;
                Angle.y = 1;
                if(GpiSetCharAngle(hPS, &Angle)==FALSE)
                        SHOWERROR("GpiSetCharAngle", EntryName);

                ptl.x = (LONG)(0.65 * delta_x);
                ptl.y = (LONG)(0.75 * delta_y);
                MapPt(ptl);

                if(GpiMove(hPS, &ptl)==FALSE)
                        SHOWERROR("GpiMove", EntryName);

                ptl.x = (LONG)(0.2 * delta_x);
                ptl.y = (LONG)(0.75 * delta_y);
                MapPt(ptl);

                sprintf(out,"Only one line of text");

// Calculate increments array for longest string of two overlapping lines
                if(GpiCharStringPosAt(hPS, &ptl, NULL, CHS_LEAVEPOS,
                                                                                                (LONG)strlen(out), out, Adx)==GPI_ERROR)
                        SHOWERROR("GpiCharStringPosAt", EntryName);

                sprintf(out,"Only one line of text should appear.");

// Draw second (longer) line.  This line should superimpose itself on the
// first line.
                if(GpiCharStringPos(hPS, NULL, NULLHANDLE,
                                                                                                (LONG)strlen(out), out, Adx)==GPI_ERROR)
                        SHOWERROR("GpiCharStringPos", EntryName);


                if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

                if(GpiDeleteSetId(hPS, lcid)==FALSE)
                        SHOWERROR("GpiDeleteSetId", EntryName);

               }    // end else - CreateLogicalOutlineFont

// Set up conditions to print all fonts/TSS..was mode 2

                if(GpiSetCharMode(hPS, CM_MODE2)==FALSE)
                        SHOWERROR("GpiSetCharMode", EntryName);

//TSS...Reset the angle 0 degrees....9/22/92
                Angle.x = 1;
                Angle.y = 0;
                if(GpiSetCharAngle(hPS, &Angle)==FALSE)
                        SHOWERROR("GpiSetCharAngle", EntryName);


                ptl.x = (LONG)(0.75 * delta_x);
                ptl.y = (LONG)(0.75 * delta_y);
                MapPt(ptl);

// Query to get all fontnames and match numbers
                EzQueryFonts(hPS, hWndClient, QF_PUBLIC, &Count, &FontStorage);


// Get DC handle for DevEscape call
                hDC = GpiQueryDevice(hPS);

// For each font found, create it, then make it the current font. The
// fontmetrics is queried, and the current character position pointer is
// updated.  The output string is built and drawn to the device.  Following
// this, the y coordinate of the pointer is incremented.  If at the top of
// the page, start a new page, draw test signature, and continue loop.
                           // 30 was Count



                for(i = 0; i < Count; i++) {
                        EzCreateLogicalFonts(hPS, hWndClient, 150L, FontStorage[i]);

// Select newly created logical font
                        if(GpiSetCharSet(hPS, 150L)==FALSE)
                                SHOWERROR("GpiSetCharSet", EntryName);

// Query to get fontmetrics structure for current font
                        if (GpiQueryFontMetrics(hPS, (LONG)sizeof(FONTMETRICS), &fm)== FALSE)
                                SHOWERROR("GpiQueryFontMetrics", EntryName);


                        // set the character box

                        if (fm.fsDefn & FM_DEFN_OUTLINE) { // outline font
                            Box.cx = MAKEFIXED(MapX(delta_x / 5.0),0);
                            Box.cy = MAKEFIXED(MapY(delta_y / 5.0),0);
                        }
                        else  // image font
                        {
                            Box.cx = MAKEFIXED(fm.lEmInc,0);
                            Box.cy = MAKEFIXED(fm.lEmHeight,0);
                        }

                       if(GpiSetCharBox(hPS, &Box)==FALSE)
                            SHOWERROR("GpiSetCharBox", EntryName);


                        sprintf(out,"%s by GpiCharStringPosAt",FontStorage[i].Fontname);

// Query to get the text box coordinates surrounding text string
                        if(GpiQueryTextBox(hPS, (LONG)strlen(out), out, TXTBOX_COUNT,
                                                                                                                                                                        Points)==FALSE)
                                SHOWERROR("GpiQueryTextBox", EntryName);

// Set up clipping rectangle coordinates
                        Rect.xLeft      = Points[TXTBOX_BOTTOMLEFT].x + ptl.x;
                        Rect.yBottom    = Points[TXTBOX_BOTTOMLEFT].y + ptl.y;
                        Rect.xRight     = Points[TXTBOX_TOPRIGHT].x + ptl.x;
                        Rect.yTop       = Points[TXTBOX_TOPLEFT].y + ptl.y;

                        tempout[1] = '\0';

// Calculate increments array for output string
                        for(j = 0; j < (INT)strlen(out); j++) {
                           tempout[0] = out[j];
                           if(GpiQueryTextBox(hPS, (LONG)strlen(tempout), tempout, TXTBOX_COUNT,
                                                               Points2)==FALSE)
                                SHOWERROR("GpiQueryTextBox", EntryName);

                           Adx[j] = Points2[TXTBOX_CONCAT].x;
                        }


                        if(GpiCharStringPosAt(hPS, &ptl, &Rect, CHS_VECTOR | CHS_OPAQUE |
                                                                        CHS_CLIP, (LONG)strlen(out), out, Adx)==GPI_ERROR)
                                SHOWERROR("GpiCharStringPosAt", EntryName);

                   ptl.y += 2 * fm.lMaxBaselineExt;

      // Quit if the output is to the display and the current
      // position is 3/4 inches from the top of the page.

                        if ((UnMapY(ptl.y) >= ((pg_size_y * delta_y) - 75L))
                                      && DeviceIsDisplay())
                                break;

      // If the output is to the printer and the current position
      // is 1/4 inch from the top of the page, start a new page,
      // print the test signature in the same font as the first page,
      // and reset the y coordinate.


                        if ((UnMapY(ptl.y) >= ((pg_size_y * delta_y) - 25L))
                            && (i < Count - 1) && DeviceIsPrinter()) {
                                if ((DevEscape(hDC, DEVESC_NEWFRAME, 0L, NULL, 0L, NULL))
                                              == DEVESC_ERROR)
                                        SHOWERROR("DevEscape", EntryName);

                                if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                                      SHOWERROR("GpiSetCharSet", EntryName);

      // Set character box to be equal to default character box size.

                                if(GpiSetCharBox(hPS, &CharBox)==FALSE)
                                    SHOWERROR("GpiSetCharBox", EntryName);

                                TEST_SIGNATURE(0,0);

                                ptl.y = MapY(0.75 * delta_y);
                        }      // end if


                        else if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                                SHOWERROR("GpiSetCharSet", EntryName);


// Delete newly created logical fonts
                        if(GpiDeleteSetId(hPS, 150L)==FALSE)
                                SHOWERROR("GpiDeleteSetId", EntryName);
                }

                free(Adx);
                free(out);

                // Fontstorage allocated by ezQueryFonts
                if (FontStorage != NULL) DosFreeMem(FontStorage);

                if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

// Delete all logical fonts
                if(GpiDeleteSetId(hPS, LCID_ALL)==FALSE)
                        SHOWERROR("GpiDeleteSetId", EntryName);

                EXIT_MAIN(EntryName);
        }
}

/***************************************************************************
 *\\ddd
 * Routine Name: GpiCharStringPosAtAndQryExh
 *
 * Purpose:  This is an entry point for the PTT that causes exhaustive
 *           testing of GpiSetCharStringPosAt()
 *
 * System Requirements: Section ???
 *
 * Revision Log: 01/08/91, PDVT, Stanley Logan
 *               - created initial template
 *               - TestCase Design
 *               - Corrected multiple page output and put back to mode2
 *               - Modified font selection for rotated text
 *               - Corrected problem with the test signature
 *
 *
 * Inputs:
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    SelectionCall  // selection parameter
 *
 * Outputs:
 *    NONE
 *
 * Subroutines Required:
 *              ENTER_MAIN
 *              SHOWERROR
 *              TEST_SIGNATURE
 *              DeviceIsDisplay
 *              EzQueryFonts
 *              EzCreateLogicalFonts
 *              CreateSystemOutlineFont
 *              LOGINFO
 *              EXIT_MAIN
 *
 * Limitations:
 *              NONE
 *
 *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 *
 *      Allocate memory for the increments array.
 *      Allocate memory for the output string.
 *      Set current character mode to CM_MODE3.
 *      Query to get the fontmetrics structure.
 *      Set current character box to 15 characters per inch.
 *      Set angle to 90 degrees.
 *      Set character increments to the maximum increment for the font.
 *      Position and draw 512 character long string.
 *      Set current character box to 7 characters per inch.
 *      Draw explanatory remark about string with tiny characters.
 *      Set current character box to 5 characters per inch.
 * Build string.
 *      Set character increments to the maximum increment for the font.
 *      Position and draw string, leaving position at beginning of string.
 *      Redraw string with characters appended.
 *      Set current character mode to CM_MODE2.
 *      Set angle to 0 degrees.
 *      Position character pointer.
 *      Query the fonts to get match numbers and facenames.
 *      For index = 0 until index = # of fonts
 *              Create logical font[index].
 *              Set current font to newly created logical font.
 *              Query to get the fontmetrics structure.
 *              Query to get the default character box size.
 *      Set character box to default character box size.
 *              Set current character position.
 *      Build string containing font name and GpiCharString.
 *      Query to get the box coordinates surrounding the string.
 *              Set character increments to the maximum increment for the font.
 *              Draw string, clipping on text box surrounding string.
 *              Increment y field of the character position.
 *              If character position is at top of page, start new page.
 *              Delete newly created logical font.
 *      End for
 *      De-allocate space for font storage
 *      De-allocate space for the increments array.
 *      De-allocate space for output string.
 *
 *\\end
 ***************************************************************************/
VOID APIENTRY  GpiCharStringPosAtAndQryExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
        static PCHAR    EntryName="GpiCharStringPosAtAndQryExh";// entry point name
        POINTL          ptl,                    // point structure
                        Points[TXTBOX_COUNT],   // text box coords.
                        Points2[TXTBOX_COUNT];  // text box coords.
        RECTL           Rect;                   // clipping rectangle
        GRADIENTL       Angle;                  // angle structure
        SIZEF           Box;                    // character box
        LONG            i,                      // loop variable
                        j,                      // loop variable
                        *Adx,                   // increments array
                        Count,                  // number of fonts
                        ErrorCount;             // error count
        CHAR            *out;                   // output string
        CHAR            tempout[2];
        PTEMPTYPE       FontStorage;            // font structure
        FONTMETRICS     fm;                     // fontmetrics struct
        HDC             hDC;                    //      device context
        BOOL            fontfound=FALSE;
        LONG            lcid;                    // logical font id
        SIZEL           DefCharBox;              // default box structure
        SIZEF           CharBox;                 // character box structure

        LONG num = 2080L;

        if (SelectionCall) {
                WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
                *pBasisX = 10000;
                *pBasisY = 10000;
        }
        else {
                ENTER_MAIN(EntryName);


//      Call GpiQueryDefCharBox() to determine the default character box.
//      This character box will be used to reset the character box
//      for test signature output

                if(GpiQueryDefCharBox(hPS, &DefCharBox)==FALSE)
                        SHOWERROR("GpiQueryDefCharBox", EntryName);

                CharBox.cx = (FIXED)(DefCharBox.cx * 65536.0);
                CharBox.cy = (FIXED)(DefCharBox.cy * 65536.0);

// Allocate memory for increments array
                if((Adx=malloc(num * sizeof(LONG)))==NULL) {
                        SHOWERROR("malloc", EntryName);
                }

// Allocate memory for output string
                if((out=malloc(num * sizeof(CHAR)))==NULL) {
                        SHOWERROR("malloc", EntryName);
                }

// Build output string
                sprintf(out,"This text should fall off of the edge.  It is 512 "
                            "characters long, which is the maximum number of ch"
                            "aracters which GpiCharStringPosAt can handle.  Ano"
                            "ther character onto to this string causes us to ex"
                            "pect an error to occur (PMERR_INV_LENGTH_OR_COUNT)"
                            ". We will do this as well in order to test the ret"
                            "urn code received from GpiCharString.  This string"
                            " is getting quite large, and I never realized exac"
                            "tly how hard it is to write 512 characters and for"
                            "m a coherent sentence which makes sense.  The end "
                            "approaches.");

// Set up conditions for drawing text sideways up the left side of the page

// An outline font is required for mode 3

              lcid=5;
              if ((fontfound=CreateSysOutlineFont(hPS,hWndClient,lcid,NULL,
                                     FATTR_SEL_OUTLINE))==FALSE)
               {
                SHOWERROR("CreateSysOutlineFontGpiCharString", EntryName);
                } // end if
               else
               {

                if(GpiSetCharSet(hPS, lcid)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

                if(GpiSetCharMode(hPS, CM_MODE3)==FALSE)
                        SHOWERROR("GpiSetCharMode", EntryName);

                Box.cx = (LONG)(MapX(delta_x / 15.0) * 65536.0);
                   //TSS...was Box.cy = Box.cx
                Box.cy = (LONG)(MapY(delta_y / 15.0) * 65536.0);
                if(GpiSetCharBox(hPS, &Box)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

                if (GpiQueryFontMetrics(hPS, (LONG)sizeof(FONTMETRICS), &fm)== FALSE)
                        SHOWERROR("GpiQueryFontMetrics", EntryName);

                Angle.x = 0;
                Angle.y = 1;
                if(GpiSetCharAngle(hPS, &Angle)==FALSE)
                        SHOWERROR("GpiSetCharAngle", EntryName);

                ptl.x = (LONG)(0.5 * delta_x);
                ptl.y = (LONG)(0.75 * delta_y);
                MapPt(ptl);

                for(j = 0; j < (INT)strlen(out); j++)
                        Adx[j] = fm.lMaxCharInc + j / 100;

                if(GpiCharStringPosAt(hPS, &ptl, NULL, CHS_VECTOR,
                             (LONG)strlen(out), out, Adx)==GPI_ERROR)
                        SHOWERROR("GpiCharStringPosAt", EntryName);

// Set up conditions for drawing explanatory string alongside tiny string
                Box.cx = (LONG)(MapX(delta_x / 7.0) * 65536.0);
                   //TSS...was Box.cy = Box.cx
                Box.cy = (LONG)(MapY(delta_y / 7.0) * 65536.0);
                if(GpiSetCharBox(hPS, &Box)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

                ptl.x = (LONG)(0.35 * delta_x);
                ptl.y = (LONG)(0.75 * delta_y);
                MapPt(ptl);

                if(GpiMove(hPS, &ptl)==FALSE)
                        SHOWERROR("GpiMove", EntryName);

                sprintf(out, "Adjacent line tiny due to large number of characters");

                if(GpiCharString(hPS, (LONG)strlen(out), out)==GPI_ERROR)
                        SHOWERROR("GpiCharString", EntryName);

// Set up conditions for drawing two overlapping lines of text
                Box.cx = (LONG)(MapX(delta_x / 5.0) * 65536.0);
                   //TSS...was Box.cy = Box.cx
                Box.cy = (LONG)(MapY(delta_y / 5.0) * 65536.0);
                if(GpiSetCharBox(hPS, &Box)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

                sprintf(out,"Only one line of text should appear.");

// Calculate increments array for longest string of two overlapping lines
                for(j = 0; j < (INT)strlen(out); j++)
                        Adx[j] = fm.lMaxCharInc;

                Angle.x = 0;
                Angle.y = 1;
                if(GpiSetCharAngle(hPS, &Angle)==FALSE)
                        SHOWERROR("GpiSetCharAngle", EntryName);

                ptl.x = (LONG)(0.65 * delta_x);
                ptl.y = (LONG)(0.75 * delta_y);
                MapPt(ptl);

                if(GpiMove(hPS, &ptl)==FALSE)
                        SHOWERROR("GpiMove", EntryName);

                ptl.x = (LONG)(0.2 * delta_x);
                ptl.y = (LONG)(0.75 * delta_y);
                MapPt(ptl);

                sprintf(out,"Only one line of text");

// Calculate increments array for longest string of two overlapping lines
                if(GpiCharStringPosAt(hPS, &ptl, NULL, CHS_LEAVEPOS,
                                                                                                (LONG)strlen(out), out, Adx)==GPI_ERROR)
                        SHOWERROR("GpiCharStringPosAt", EntryName);

                sprintf(out,"Only one line of text should appear.");

// Draw second (longer) line.  This line should superimpose itself on the
// first line.
                if(GpiCharStringPos(hPS, NULL, NULLHANDLE,
                                                                                                (LONG)strlen(out), out, Adx)==GPI_ERROR)
                        SHOWERROR("GpiCharStringPos", EntryName);


                if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

                if(GpiDeleteSetId(hPS, lcid)==FALSE)
                        SHOWERROR("GpiDeleteSetId", EntryName);

               }    // end else - CreateLogicalOutlineFont

// Set up conditions to print all fonts/TSS..was mode 2
                if(GpiSetCharMode(hPS, CM_MODE2)==FALSE)
                        SHOWERROR("GpiSetCharMode", EntryName);

//TSS...Reset the angle 0 degrees....9/22/92
                Angle.x = 1;
                Angle.y = 0;
                if(GpiSetCharAngle(hPS, &Angle)==FALSE)
                        SHOWERROR("GpiSetCharAngle", EntryName);


                ptl.x = (LONG)(0.75 * delta_x);
                ptl.y = (LONG)(0.75 * delta_y);
                MapPt(ptl);

// Query to get all fontnames and match numbers
                EzQueryFonts(hPS, hWndClient, QF_PUBLIC, &Count, &FontStorage);


// Get DC handle for DevEscape call
                hDC = GpiQueryDevice(hPS);

// For each font found, create it, then make it the current font. The
// fontmetrics is queried, and the current character position pointer is
// updated.  The output string is built and drawn to the device.  Following
// this, the y coordinate of the pointer is incremented.  If at the top of
// the page, start a new page, draw test signature, and continue loop.
                         // 30 was Count
                for(i = 0; i < Count; i++) {
                        EzCreateLogicalFonts(hPS, hWndClient, 150L, FontStorage[i]);

// Select newly created logical font
                        if(GpiSetCharSet(hPS, 150L)==FALSE)
                                SHOWERROR("GpiSetCharSet", EntryName);

// Query to get fontmetrics structure for current font
                        if (GpiQueryFontMetrics(hPS, (LONG)sizeof(FONTMETRICS), &fm)== FALSE)
                                SHOWERROR("GpiQueryFontMetrics", EntryName);


                        // set the character box

                        if (fm.fsDefn & FM_DEFN_OUTLINE) { // outline font
                            Box.cx = MAKEFIXED(MapX(delta_x / 5.0),0);
                            Box.cy = MAKEFIXED(MapY(delta_y / 5.0),0);
                        }
                        else  // image font
                        {
                            Box.cx = MAKEFIXED(fm.lEmInc,0);
                            Box.cy = MAKEFIXED(fm.lEmHeight,0);
                        }

                       if(GpiSetCharBox(hPS, &Box)==FALSE)
                            SHOWERROR("GpiSetCharBox", EntryName);


                        sprintf(out,"%s by GpiCharStringPosAt",FontStorage[i].Fontname);

// Query to get the text box coordinates surrounding text string
                        if(GpiQueryTextBox(hPS, (LONG)strlen(out), out, TXTBOX_COUNT,
                                                                                                                                                                        Points)==FALSE)
                                SHOWERROR("GpiQueryTextBox", EntryName);

// Set up clipping rectangle coordinates
                        Rect.xLeft      = Points[TXTBOX_BOTTOMLEFT].x + ptl.x;
                        Rect.yBottom    = Points[TXTBOX_BOTTOMLEFT].y + ptl.y;
                        Rect.xRight     = Points[TXTBOX_TOPRIGHT].x + ptl.x;
                        Rect.yTop       = Points[TXTBOX_TOPLEFT].y + ptl.y;

                        tempout[1] = '\0';

// Calculate increments array for output string
                        for(j = 0; j < (INT)strlen(out); j++) {
                           tempout[0] = out[j];
                           if(GpiQueryTextBox(hPS, (LONG)strlen(tempout), tempout, TXTBOX_COUNT,
                                                               Points2)==FALSE)
                                SHOWERROR("GpiQueryTextBox", EntryName);

                           Adx[j] = Points2[TXTBOX_CONCAT].x;
                        }


                        if(GpiCharStringPosAt(hPS, &ptl, &Rect, CHS_VECTOR | CHS_OPAQUE |
                                                                        CHS_CLIP, (LONG)strlen(out), out, Adx)==GPI_ERROR)
                                SHOWERROR("GpiCharStringPosAt", EntryName);

                   ptl.y += 2 * fm.lMaxBaselineExt;

      // Quit if the output is to the display and the current
      // position is 3/4 inches from the top of the page.

                        if ((UnMapY(ptl.y) >= ((pg_size_y * delta_y) - 75L))
                                    && DeviceIsDisplay())
                                break;

      // If the output is to the printer and the current position
      // is 1/4 inch from the top of the page, start a new page,
      // print the test signature in the same font as the first page,
      // and reset the y coordinate.

                        if ((UnMapY(ptl.y) >= ((pg_size_y * delta_y) - 25L))
                            && (i < Count - 1) && DeviceIsPrinter()) {
                                if ((DevEscape(hDC, DEVESC_NEWFRAME, 0L, NULL, 0L, NULL))
                                              == DEVESC_ERROR)
                                        SHOWERROR("DevEscape", EntryName);

                                if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                                      SHOWERROR("GpiSetCharSet", EntryName);

      // Set character box to be equal to default character box size.

                                if(GpiSetCharBox(hPS, &CharBox)==FALSE)
                                    SHOWERROR("GpiSetCharBox", EntryName);

                                TEST_SIGNATURE(0,0);

                                ptl.y = MapY(0.75 * delta_y);
                        }      // end if


                        else if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                                SHOWERROR("GpiSetCharSet", EntryName);



// Delete newly created logical fonts
                        if(GpiDeleteSetId(hPS, 150L)==FALSE)
                                SHOWERROR("GpiDeleteSetId", EntryName);
                }

                free(Adx);
                free(out);

                // Fontstorage allocated by ezQueryFonts
                if (FontStorage != NULL) DosFreeMem(FontStorage);

                if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

// Delete all logical fonts
                if(GpiDeleteSetId(hPS, LCID_ALL)==FALSE)
                        SHOWERROR("GpiDeleteSetId", EntryName);

                EXIT_MAIN(EntryName);
        }
}


/***************************************************************************
 *\\ddd
 * Routine Name: GpiQryDefCharBoxExh
 *
 * Purpose:  This is an entry point for the PTT that causes exhaustive
 *           testing of GpiQueryDefCharBox()
 *
 * System Requirements: Section ???
 *
 * Revision Log: 01/08/91, PDVT, Stanley Logan
 *               - created initial template
 *               - TestCase  Design.
 *                                        02/19/91, PDVT, Stanley Logan
 *                                        - TestCase  Coding.
 *
 *
 * Inputs:
 *
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    SelectionCall  // selection parameter
 *
 * Outputs:
 *              NONE
 *
 * Subroutines Required:
 *              ENTER_MAIN
 *              SHOWERROR
 *              TEST_SIGNATURE
 *              LOGINFO
 *              EXIT_MAIN
 *
 * Limitations:
 *              NONE
 *
 *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 *
 *      Call GpiQueryDefCharBox() to determine the default character box.
 * Set character box to be equal to default character box size.
 *      Call GpiQueryCharBox() to determine the character box size.
 *      Output coordinates of default and current character box, along with
 *              message commenting if they are equal or not.
 * Set character box to be not equal to default character box size.
 *      Call GpiQueryCharBox() to determine the character box size.
 *      Output coordinates of default and current character box, along with
 *              message commenting if they are equal or not.
 *
 *      //NOTE: Since the current character box is in FIXED format, it is
 *                        equal to the actual size * 65536.
 *
 *\\end
 ***************************************************************************/

VOID APIENTRY  GpiQryDefCharBoxExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
        static PCHAR    EntryName="GpiQryDefCharBoxExh";        //      test case name
        POINTL          ptl;            //      point structure
        BOOL            XTrue = TRUE,   //      boolean flag
                        YTrue = TRUE;   //      boolean flag
        SIZEL           DefCharBox;     //      default box structure
        SIZEF           CharBox;        //      character box structure
        CHAR            out[80];        //      output string
        LONG            ErrorCount;     //      error count

        if (SelectionCall) {
                WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
                *pBasisX = 10000;
                *pBasisY = 10000;
        }
        else {
                ENTER_MAIN(EntryName);

                ptl.x = delta_x;
                ptl.y = 5 * delta_y;
                MapPt(ptl);

//      Call GpiQueryDefCharBox() to determine the default character box.
                if(GpiQueryDefCharBox(hPS, &DefCharBox)==FALSE)
                        SHOWERROR("GpiQueryDefCharBox", EntryName);

                CharBox.cx = (FIXED)(DefCharBox.cx * 65536.0);
                CharBox.cy = (FIXED)(DefCharBox.cy * 65536.0);

// Set character box to be equal to default character box size.
                if(GpiSetCharBox(hPS, &CharBox)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

//      Call GpiQueryCharBox() to determine the character box size.
                if(GpiQueryCharBox(hPS, &CharBox)==FALSE)
                        SHOWERROR("GpiQueryDefCharBox", EntryName);

                sprintf(out,"default x size: %ld  actual x size: %ld",
                                                                                                                        DefCharBox.cx,CharBox.cx/65536);

//      Output coordinates of default and current character box, along with
//              message commenting if they are equal or not.
                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(out), out)==GPI_ERROR)
                        SHOWERROR("GpiCharStringAt", EntryName);

                ptl.y = MapY(4.8 * delta_y);

                sprintf(out,"default y size: %ld  actual y size: %ld",
                                                                                                                        DefCharBox.cy,CharBox.cy/65536);

                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(out), out)==GPI_ERROR)
                        SHOWERROR("GpiCharStringAt", EntryName);

                ptl.y = MapY(4.4 * delta_y);

                if((FIXED)(DefCharBox.cx*65536)!=CharBox.cx)    XTrue=FALSE;

                if((FIXED)(DefCharBox.cy*65536)!=CharBox.cy)    YTrue=FALSE;

                if(XTrue&&YTrue) {
                        sprintf(out,"Default character box = actual character box");
                        if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(out), out)==GPI_ERROR)
                                SHOWERROR("GpiCharStringAt", EntryName);
                }
                else {
                        sprintf(out,"Default character box <> actual character box");
                        if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(out), out)==GPI_ERROR)
                                SHOWERROR("GpiCharStringAt", EntryName);
                        sprintf(out,"Failure of GpiQueryDefCharBox().  Box set and"
                                                        " default box were not equal.");
                        LOGINFO((INT)4, "@", out);
                }

                ptl.x = delta_x;
                ptl.y = 3 * delta_y;
                MapPt(ptl);

                if(GpiQueryDefCharBox(hPS, &DefCharBox)==FALSE)
                        SHOWERROR("GpiQueryDefCharBox", EntryName);

                CharBox.cx = (FIXED)((DefCharBox.cx + 1) * 65536.0);
                CharBox.cy = (FIXED)((DefCharBox.cy + 1) * 65536.0);

// Set character box to be not equal to default character box size +1.
                if(GpiSetCharBox(hPS, &CharBox)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

//      Call GpiQueryCharBox() to determine the character box size.
                if(GpiQueryCharBox(hPS, &CharBox)==FALSE)
                        SHOWERROR("GpiQueryDefCharBox", EntryName);

                sprintf(out,"default x size: %ld  actual x size: %ld",
                                                                                                                        DefCharBox.cx,CharBox.cx/65536);

//      Output coordinates of default and current character box, along with
//              message commenting if they are equal or not.
                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(out), out)==GPI_ERROR)
                        SHOWERROR("GpiCharStringAt", EntryName);

                ptl.y = MapY(2.8 * delta_y);

                sprintf(out,"default y size: %ld  actual y size: %ld",
                                                                                                                        DefCharBox.cy,CharBox.cy/65536);

                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(out), out)==GPI_ERROR)
                        SHOWERROR("GpiCharStringAt", EntryName);

                ptl.y = MapY(2.4 * delta_y);

                if((FIXED)(DefCharBox.cx*65536)!=CharBox.cx)    XTrue=FALSE;

                if((FIXED)(DefCharBox.cy*65536)!=CharBox.cy)    YTrue=FALSE;

                if(XTrue&&YTrue) {
                        sprintf(out,"Default character box = actual character box");
                        if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(out), out)==GPI_ERROR)
                                SHOWERROR("GpiCharStringAt", EntryName);
                        sprintf(out,"Failure of GpiQueryDefCharBox().  Box set and"
                                                        " default box were equal.");
                        LOGINFO((INT)4, "@", out);
                }
                else {
                        sprintf(out,"Default character box <> actual character box");
                        if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(out), out)==GPI_ERROR)
                                SHOWERROR("GpiCharStringAt", EntryName);
                }

                EXIT_MAIN(EntryName);
        }
}


/****************************************************************************
 *\\ddd
 * Routine Name: GpiQryTextBoxExh
 *
 * Purpose:  This is an entry point for the PTT that causes exhaustive
 *           testing of GpiQueryTextBox()
 *
 * System Requirements: Section ???
 *
 * Revision Log: 01/08/91, PDVT, Stanley Logan
 *               - created initial template
 *               - TestCase  Design.
 *               - Changed method of font selection
 *               - Expanded test to test all types of fonts
 *                  - System Outline, System Image, Device Outline, Device Image
 *
 *
 *
 * Inputs:
 *
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    SelectionCall  // selection parameter
 *
 * Outputs:
 *              NONE
 *
 * Subroutines Required:
 *              ENTER_MAIN
 *              SHOWERROR
 *              TEST_SIGNATURE
 *              DeviceIsDisplay
 *              FindLogicalFonts
 *              AddStruct
 *              SwapPoints
 *              EXIT_MAIN
 *
 * Limitations:
 *              NONE
 *
  *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 *
 *      Define image and outline font.
 *      Set current box to 6 characters per inch.
 *      Allocate memory for output string.
 *      Set baseline angle to 45 degrees.
 *      Set current font to be an outline font.
 *      Build output string.
 *      Set current character mode to CM_MODE3.
 *      Position character pointer.
 * Query to get the box coordinates surrounding the string.
 *      Set queried concatenation point to current pointer position.
 *      Add current position to queried relative positions.
 *      Swap upper right and bottom right positions and set concatenation point to
 *              upper left corner.
 *      Draw box surrounding text.
 *      Draw text at specified position.
 *      Build output string.
 *      Set current character mode to CM_MODE2.
 *      Position character pointer.
 * Query to get the box coordinates surrounding the string.
 *      Set queried concatenation point to current pointer position.
 *      Add current position to queried relative positions.
 *      Swap upper right and bottom right positions and set concatenation point to
 *              upper left corner.
 *      Draw box surrounding text.
 *      Draw text at specified position.
 *      Build output string.
 *      Set current character mode to CM_MODE1.
 *      Position character pointer.
 * Query to get the box coordinates surrounding the string.
 *      Set queried concatenation point to current pointer position.
 *      Add current position to queried relative positions.
 *      Swap upper right and bottom right positions and set concatenation point to
 *              upper left corner.
 *      Draw box surrounding text.
 *      Draw text at specified position.
 *      Set current box to 4 characters per inch.
 *      Set current font to be an image font.
 *      Build output string.
 *      Set current character mode to CM_MODE2.
 *      Position character pointer.
 * Query to get the box coordinates surrounding the string.
 *      Set queried concatenation point to current pointer position.
 *      Add current position to queried relative positions.
 *      Swap upper right and bottom right positions and set concatenation point to
 *              upper left corner.
 *      Draw box surrounding text.
 *      Draw text at specified position.
 *      Build output string.
 *      Set current character mode to CM_MODE1.
 *      Position character pointer.
 * Query to get the box coordinates surrounding the string.
 *      Set queried concatenation point to current pointer position.
 *      Add current position to queried relative positions.
 *      Swap upper right and bottom right positions and set concatenation point to
 *              upper left corner.
 *      Draw box surrounding text.
 *      Draw text at specified position.
 *      De-allocate memory for output string.
 *      Delete all logical fonts.
 *
 *\\end
 ***************************************************************************/
VOID APIENTRY  GpiQryTextBoxExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
        static PCHAR    EntryName="GpiQryTextBoxExh";
        FONTTYPE                        FontStorage;
        GRADIENTL               Angle;
        POINTL                  ptl,
                                                Points[TXTBOX_COUNT];
        SIZEF                           Box;
        LONG                            ErrorCount,
                                                lcid;
        CHAR                            *out;

        if (SelectionCall) {
                WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
                *pBasisX = 10000;
                *pBasisY = 10000;
        }
        else {
                ENTER_MAIN(EntryName);

//      Define image and outline font.
                if DeviceIsDisplay() {
                        if(!ErrorCount) {
                                strcpy(FontStorage.Fontname,"Helv");
                                FontStorage.fsSelection=0;
                                FontStorage.fsFontUse=0;
                                FontStorage.usCodePage=0;
                                FontStorage.PointSize=100;
                                if(FindLogicalFonts(hPS, DESIRED_FONT_ID, FontStorage)==FALSE)
                                        SHOWERROR("FindLogicalFonts", EntryName);
                        }
                }

                lcid=5;
                strcpy(FontStorage.Fontname,"Helv Bold");
                FontStorage.fsSelection=FATTR_SEL_OUTLINE | FATTR_SEL_BOLD;
                FontStorage.fsFontUse=FATTR_FONTUSE_OUTLINE;
                FontStorage.usCodePage=0;
                FontStorage.PointSize=120;
                if(FindLogicalFonts(hPS, lcid, FontStorage)==FALSE)
                                SHOWERROR("FindLogicalFonts", EntryName);

//      Set current box to 6 characters per inch.
                Box.cx = (FIXED)(MapX(delta_x / 6.0) * 65536.0);
                   //TSS...was Box.cy = Box.cx
                Box.cy = (FIXED)(MapY(delta_y / 6.0) * 65536.0);
                if(GpiSetCharBox(hPS, &Box)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

//      Allocate memory for output string.
                if((out=malloc(50 * sizeof(CHAR)))==NULL) {
                        SHOWERROR("malloc", EntryName);
                }

//      Set baseline angle to 45 degrees.
                Angle.x = MapX(delta_x);
                Angle.y = MapY(delta_y);
                if(GpiSetCharAngle(hPS, &Angle)==FALSE)
                        SHOWERROR("GpiSetCharAngle", EntryName);

//      Set current font to be an outline font.
                if(GpiSetCharSet(hPS, 5L)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

//      Build output string.
                sprintf(out, "Outline text in CM_MODE3");

//      Set current character mode to CM_MODE3.
                if(GpiSetCharMode(hPS, CM_MODE3)==FALSE)
                        SHOWERROR("GpiSetCharMode", EntryName);

//      Position character pointer.
                ptl.x = MapX(0.25 * delta_x);
                ptl.y = MapY(2.0  * delta_y);

                if(GpiMove(hPS, &ptl)==FALSE)
                        SHOWERROR("GpiMove", EntryName);

// Query to get the box coordinates surrounding the string.
                if(GpiQueryTextBox(hPS, (LONG)strlen(out), out, TXTBOX_COUNT, Points)
                                                                                                                                                                                        ==FALSE)
                        SHOWERROR("GpiQueryTextBox", EntryName);

//      Set queried concatenation point to current pointer position.
                Points[TXTBOX_CONCAT].x = ptl.x;
                Points[TXTBOX_CONCAT].y = ptl.y;

//      Add current position to queried relative positions.
                AddStruct(Points);

//      Swap upper right and bottom right positions and set concatenation point to
//      upper left corner.
                SwapPoints(Points);

//      Draw box surrounding text.
                if(GpiPolyLine(hPS, 5L, Points)==GPI_ERROR)
                        SHOWERROR("GpiPolyLine", EntryName);

//      Draw text at specified position.
                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(out), out)==GPI_ERROR)
                        SHOWERROR("GpiCharStringAt", EntryName);

//      Build output string.
                sprintf(out, "Outline text in CM_MODE2");

                if(GpiSetCharMode(hPS, CM_MODE2)==FALSE)
                        SHOWERROR("GpiSetCharMode", EntryName);

                ptl.x = MapX(0.75 * delta_x);
                ptl.y = MapY(2.0  * delta_y);

//      Position character pointer.
                if(GpiMove(hPS, &ptl)==FALSE)
                        SHOWERROR("GpiMove", EntryName);

// Query to get the box coordinates surrounding the string.
                if(GpiQueryTextBox(hPS, (LONG)strlen(out), out, TXTBOX_COUNT, Points)
                                                                                                                                                                                        ==FALSE)
                        SHOWERROR("GpiQueryTextBox", EntryName);

//      Set queried concatenation point to current pointer position.
                Points[TXTBOX_CONCAT].x = ptl.x;
                Points[TXTBOX_CONCAT].y = ptl.y;

//      Add current position to queried relative positions.
                AddStruct(Points);

//      Swap upper right and bottom right positions and set concatenation point to
//              upper left corner.
                SwapPoints(Points);

//      Draw box surrounding text.
                if(GpiPolyLine(hPS, 5L, Points)==GPI_ERROR)
                        SHOWERROR("GpiPolyLine", EntryName);

//      Draw text at specified position.
                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(out), out)==GPI_ERROR)
                        SHOWERROR("GpiCharStringAt", EntryName);

//      Build output string.
                sprintf(out, "Outline text in CM_MODE1");

//      Set current character mode to CM_MODE1.
                if(GpiSetCharMode(hPS, CM_MODE1)==FALSE)
                        SHOWERROR("GpiSetCharMode", EntryName);

                ptl.x = MapX(1.25 * delta_x);
                ptl.y = MapY(2.0  * delta_y);

//      Position character pointer.
                if(GpiMove(hPS, &ptl)==FALSE)
                        SHOWERROR("GpiMove", EntryName);

// Query to get the box coordinates surrounding the string.
                if(GpiQueryTextBox(hPS, (LONG)strlen(out), out, TXTBOX_COUNT, Points)
                                                                                                                                                                                        ==FALSE)
                        SHOWERROR("GpiQueryTextBox", EntryName);

//      Set queried concatenation point to current pointer position.
                Points[TXTBOX_CONCAT].x = ptl.x;
                Points[TXTBOX_CONCAT].y = ptl.y;

//      Add current position to queried relative positions.
                AddStruct(Points);

//      Swap upper right and bottom right positions and set concatenation point to
//              upper left corner.
                SwapPoints(Points);

//      Draw box surrounding text.
                if(GpiPolyLine(hPS, 5L, Points)==GPI_ERROR)
                        SHOWERROR("GpiPolyLine", EntryName);

//      Draw text at specified position.
                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(out), out)==GPI_ERROR)
                        SHOWERROR("GpiCharStringAt", EntryName);

// Set character box to 4 characters / inch
                Box.cx = (FIXED)(MapX(delta_x / 4.0) * 65536.0);
                   //TSS...was Box.cy = Box.cx
                Box.cy = (FIXED)(MapY(delta_y / 4.0) * 65536.0);
                if(GpiSetCharBox(hPS, &Box)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

// Set current font to device image font
                if(GpiSetCharSet(hPS, DESIRED_FONT_ID)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

// Build output string
                sprintf(out, "CM_MODE2/image results are unpredictable");

// Set character mode
                if(GpiSetCharMode(hPS, CM_MODE2)==FALSE)
                        SHOWERROR("GpiSetCharMode", EntryName);

                ptl.x = MapX(1.75 * delta_x);
                ptl.y = MapY(1.0 * delta_y);

// Set current character position pointer
                if(GpiMove(hPS, &ptl)==FALSE)
                        SHOWERROR("GpiMove", EntryName);

// Query text box to get coordinates of box surrounding string
                if(GpiQueryTextBox(hPS, (LONG)strlen(out), out, TXTBOX_COUNT, Points)
                                                                                                                                                                                        ==FALSE)
                        SHOWERROR("GpiQueryTextBox", EntryName);

//      Set queried concatenation point to current pointer position.
                Points[TXTBOX_CONCAT].x = ptl.x;
                Points[TXTBOX_CONCAT].y = ptl.y;

//      Add current position to queried relative positions.
                AddStruct(Points);

//      Swap upper right and bottom right positions and set concatenation point to
//              upper left corner.
                SwapPoints(Points);

//      Draw box surrounding text.
                if(GpiPolyLine(hPS, 5L, Points)==GPI_ERROR)
                        SHOWERROR("GpiPolyLine", EntryName);

//      Draw text at specified position.
                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(out), out)==GPI_ERROR)
                        SHOWERROR("GpiCharStringAt", EntryName);

//      Build output string.
                sprintf(out, "Image text in CM_MODE1");

//      Set current character mode to CM_MODE1.
                if(GpiSetCharMode(hPS, CM_MODE1)==FALSE)
                        SHOWERROR("GpiSetCharMode", EntryName);

                ptl.x = MapX(2.25 * delta_x);
                ptl.y = MapY(1.0 * delta_y);

//      Position character pointer.
                if(GpiMove(hPS, &ptl)==FALSE)
                        SHOWERROR("GpiMove", EntryName);

// Query to get the box coordinates surrounding the string.
                if(GpiQueryTextBox(hPS, (LONG)strlen(out), out, TXTBOX_COUNT, Points)
                                                                                                                                                                                        ==FALSE)
                        SHOWERROR("GpiQueryTextBox", EntryName);

//      Set queried concatenation point to current pointer position.
                Points[TXTBOX_CONCAT].x = ptl.x;
                Points[TXTBOX_CONCAT].y = ptl.y;

//      Add current position to queried relative positions.
                AddStruct(Points);

//      Swap upper right and bottom right positions and set concatenation point to
//              upper left corner.
                SwapPoints(Points);

//      Draw box surrounding text.
                if(GpiPolyLine(hPS, 5L, Points)==GPI_ERROR)
                        SHOWERROR("GpiPolyLine", EntryName);

//      Draw text at specified position.
                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(out), out)==GPI_ERROR)
                        SHOWERROR("GpiCharStringAt", EntryName);

                if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

//      Delete all logical fonts.
                if(GpiDeleteSetId(hPS, LCID_ALL)==FALSE)
                        SHOWERROR("GpiDeleteSetId", EntryName);

//      De-allocate memory for output string.
                free(out);

                EXIT_MAIN(EntryName);
        }
}






