#ifndef GPIBTMP_H
#define GPIBTMP_H
/***************************************************************************
 *\\ddd
 * Subtask Name: pdvt
 *
 * Module name: gpibtmp
 *
 * Purpose: Gpi bit map dll include file
 *
 *  $header$
 *
 * Revision Log:  11/09/90 ,PDVT ,Mike Abuzant
 *                              - Created Initial file
 *                12/07/90 ,PDVT ,Mike Abuzant
 *                              - Eliminated hAB parameter
 *                01/07/91 ,PDVT ,Mike Abuzant
 *                              -This file is Created by modifying GREBTMP.H
 *                02/02/91 ,PDVT ,Mike Abuzant
 *                              -Added a new parameter to the function GpiApp2. This new
 *                - parameter specify the entry point name since this function
 *                - is called from more entry point.
 *
 *
 * Contents:  This file contains the following definitions:
 *
 *              - function prototypes
 *              - define's specific to Gpibtmp
 *
 * Limitations:
 *  None
 *
 *\\end
 ***************************************************************************/

/* declare all dll functions */
VOID  APIENTRY GpiBitPre1(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiBitPre2(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiBitApp1(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiBitApp2(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiBitApp3(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiBitApp4(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiSetBitmapBitsExh(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiBitBltExh(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiWCBitBltExh(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiSetPelExh(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiSetBitmapIdExh(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiQueryDeviceBitmapFormatsExh(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiSetBitmapDimensionExh(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiLoadBitmapExh(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiQueryBitmapHandleRc(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiQueryBitmapParametersExh(HPS hPS, HWND hWndClient, BOOL SelectionCall);

INT GpiBitBlt_test1   (HPS hPS, HWND hWndClient);
INT GpiSetBitmap_test1(HPS hPS, HWND hWndClient);
INT GpiApp1           (HPS hPS, HWND hWndClient);
INT GpiApp2           (HPS hPS, HWND hWndClient, USHORT spiral_control,PCHAR EntryPoint);
INT GpiApp3           (HPS hPS, HWND hWndClient);
INT GpiApp4           (HPS hPS, HWND hWndClient);
INT GpiPre1           (HPS hPS, HWND hWndClient);


                          // number of functions or entry points in this dll.

#define IMAGESIZE            2000

#define NUMBPOINTS           1000

#define PI                   3.14159000

#define MY_BITMAP_ID         3L

#define  FIRST_BITMAP_ID     101
#define  SECOND_BITMAP_ID    102
#define  THIRD_BITMAP_ID     103
#define  FOURT_BITMAP_ID     104
#define  FIFTH_BITMAP_ID     105

#define  CROSS_WIDTH         16
#define  CROSS_HEIGHT        16

#define  CAT_WIDTH           32
#define  CAT_HEIGHT          32

#define  HELLO_WIDTH         21
#define  HELLO_HEIGHT        7

#define  SHAPE_WIDTH         8
#define  SHAPE_HEIGHT        8

#define  PAT1_WIDTH          8
#define  PAT1_HEIGHT         8

#define  PAT2_WIDTH          8
#define  PAT2_HEIGHT         8

#define CONVERTTOINCHES(Value)  (((double)Value)/((double)100.000000/(double)2.5400050800))

#define PIXELSTOUNITS(a,b,c)    ((a)*((double)(b)/CONVERTTOINCHES((c))))

#define  NUMBEROFELEMENTS(ArrayName)  (sizeof(ArrayName)/sizeof(ArrayName[0]))

#define  INCROMENTWITHWRAP(Counter,ArrayName)  \
                  Counter=((++Counter)%NUMBEROFELEMENTS(ArrayName))


typedef struct _MyBitMap
          {
            SHORT   height;
            SHORT   width;
            PBYTE   BitMapBuffer;
          } MyBitMap;


#ifdef MAINSOURCEFILE

CHAR achLogLine[100];      //Buffer used for printing error messages

LONG ErrorCount;          //Error counter.

/* set function name for dll init routine */

CHAR * TestCaseName= "GpiBitMaps";

static  NAMES_AND_ADDRESSES EntryPointList[]=
    {
        TOKENIZEFUNCTIONNAME(GpiBitPre1                    ),
        TOKENIZEFUNCTIONNAME(GpiBitPre2                    ),
        TOKENIZEFUNCTIONNAME(GpiBitApp1                    ),
        TOKENIZEFUNCTIONNAME(GpiBitApp2                    ),
        TOKENIZEFUNCTIONNAME(GpiBitApp3                    ),
        TOKENIZEFUNCTIONNAME(GpiBitApp4                    ),
        TOKENIZEFUNCTIONNAME(GpiSetPelExh                  ),
        TOKENIZEFUNCTIONNAME(GpiBitBltExh                  ),
        TOKENIZEFUNCTIONNAME(GpiSetBitmapBitsExh           ),
        TOKENIZEFUNCTIONNAME(GpiSetBitmapIdExh             ),
        TOKENIZEFUNCTIONNAME(GpiWCBitBltExh                ),
        TOKENIZEFUNCTIONNAME(GpiSetBitmapDimensionExh      ),
        TOKENIZEFUNCTIONNAME(GpiLoadBitmapExh              ),
        TOKENIZEFUNCTIONNAME(GpiQueryDeviceBitmapFormatsExh),
        TOKENIZEFUNCTIONNAME(GpiQueryBitmapParametersExh   ),
    };

BYTE abShape[]={0x3c,0x00,0x00,0x00,    // bitmap to be drawn
                0x42,0x00,0x00,0x00,
                0x81,0x00,0x00,0x00,
                0x99,0x00,0x00,0x00,
                0x99,0x00,0x00,0x00,
                0x81,0x00,0x00,0x00,
                0x42,0x00,0x00,0x00,
                0x3c,0x00,0x00,0x00
               };

BYTE abPat1[]={0x08,0x00,0x00,0x00,    // bitmap to be drawn
               0x08,0x00,0x00,0x00,
               0x08,0x00,0x00,0x00,
               0x08,0x00,0x00,0x00,
               0x08,0x00,0x00,0x00,
               0x3C,0x00,0x00,0x00,
               0x42,0x00,0x00,0x00,
               0x81,0x00,0x00,0x00
               };

BYTE abPat2[]={0x0f,0x00,0x00,0x00,    // bitmap to be drawn
               0x08,0x00,0x00,0x00,
               0x08,0x00,0x00,0x00,
               0x08,0x00,0x00,0x00,
               0x08,0x00,0x00,0x00,
               0x08,0x00,0x00,0x00,
               0x08,0x00,0x00,0x00,
               0xf0,0x00,0x00,0x00
               };

BYTE abCross[]={0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
                0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
                0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
                0x01,0x00,0x00,0x00,0xff,0xff,0x00,0x00,
                0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
                0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
                0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
                0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00
               };

BYTE abCat[]={0x00,0xff,0xff,0x00,0x00,0xa2,0x45,0x00,
              0x00,0xa2,0x45,0x00,0x00,0xa2,0x45,0xe0,
              0x00,0xa2,0x45,0x10,0x00,0xa2,0x45,0x08,
              0x00,0x9c,0x39,0x08,0x00,0xc0,0x03,0x04,

              0x00,0x40,0x02,0x04,0x00,0x40,0x02,0x04,
              0x00,0x40,0x02,0x04,0x00,0x20,0x04,0x04,
              0x00,0x20,0x04,0x04,0x00,0x20,0x04,0x04,
              0x00,0x10,0x08,0x04,0x00,0x10,0x08,0x08,

              0x00,0x10,0x08,0x10,0x00,0x08,0x10,0x20,
              0x00,0x08,0x10,0xc0,0x00,0x08,0x10,0x00,
              0x00,0x07,0xe0,0x00,0x00,0x08,0x10,0x00,
              0x00,0xfc,0x3f,0x00,0x00,0x09,0x90,0x00,

              0x00,0xfc,0x3f,0x00,0x00,0x08,0x10,0x00,
              0x00,0x1a,0x58,0x00,0x00,0x28,0x14,0x00,
              0x00,0x48,0x12,0x00,0x00,0x8f,0xf1,0x00,
              0x01,0x04,0x20,0x80,0x01,0xf8,0x1f,0x80
             };

BYTE  abHello[]={0x00,0x00,0x00,0x00,     // bitmap of the word HELLO
                 0x57,0x77,0x70,0x00,
                 0x54,0x44,0x50,0x00,
                 0x76,0x44,0x50,0x00,
                 0x54,0x44,0x50,0x00,
                 0x57,0x44,0x70,0x00,
                 0x00,0x00,0x00,0x00
                };

LONG  colors[]={CLR_RED,     // Colors that will draw with
                CLR_CYAN,
                CLR_PINK,
                CLR_BLUE,
                CLR_BROWN,
                CLR_YELLOW,
                CLR_GREEN,
                CLR_DARKCYAN,
                CLR_DARKGREEN,
                CLR_DARKBLUE
               };

LONG  pats[]={PATSYM_DENSE8,
              PATSYM_DIAG1,
              PATSYM_DIAG4,
              PATSYM_DEFAULT,
              PATSYM_DENSE4,
              PATSYM_VERT,
              PATSYM_DEFAULT,
              PATSYM_HORIZ,
             };

#else
    extern BYTE  abHello[];

    extern  BYTE abCross[];

    extern  BYTE abCat[];

    extern  BYTE abShape[];

    extern LONG  colors[];

    extern  LONG  pats[];

    extern  BYTE abPat1[];

    extern  BYTE abPat2[];

    extern CHAR achLogLine[];

    extern LONG ErrorCount;

#endif

#endif


