PROJ = gpiarc
CC = icc

#  /W3           - Warns of all non-ANSI usage
#  /G3           - Generate 80486 code
#  /DLINT_ARGS   - Check functional arguments against prototypes
#  /Sp           - Packs Structure
#  /Ti+          - Generates all debugger information
#  /Sm           - Allow all C Set/2 extensions including those for migration
#  /O+           - Optimize object code
#  /Gs+          - Stack checking
#  /Ge           - Build .EXE file
#  /Ss           - Allow for the // comments

CFLAGS  = /Ge- /Ti+ /O- /Oi- /Os- /Oc- /W3 /G3 /DLINT_ARGS /Sp /Sm /Gm+ /Gd+ /Gs+ /Ss

#
#  The following is to use the new libraries for Visual Age C/C++
#
LLIBS    = CPPOM30.LIB + OS2386.LIB

LFLAGS   =  /DE /CODEVIEW /STACK:64000 /NOD /ALIGN:16 /PACKC /PACKD /M /BASE:0x10000 

ICLCPPOPTS=/GM+ /GD+ /DIC_TRACE_ALL /DIC_DEVELOP /B" /PM:PM"

IMPLIB = implib/NOIGNORECASE

EXECFLAGS= $(ICLCPPOPTS)
EXELFLAGS=/B" /PM:PM"

MAPFILE  = gpiarc.map
# LINKER   = link386
# old linker... the new linker is ilink
LINKER   = ilink
LRF      = echo > NUL
RC       = rc
DEF_FILE = gpiarc.DEF

OBJS  = gpiarc.obj   gpiarcp.obj  \
        gpiarcx.obj  gpiarcx2.obj \
        gpiarcx3.obj arc_grid.obj \
        common.obj   arc_util.obj \
        arcutil2.obj pttdllvr.obj

.dll.lib:
        $(IMPLIB) $*.lib $*.dll

compile = $(CC) /c $(CFLAGS)

all: $(PROJ).dll

.SUFFIXES:
.SUFFIXES: .sbr .obj .res .c .rc

gpiarc.obj : gpiarc.c gpiarc.h arc_util.h pttdlldf.h
   $(compile) /Fo$@ gpiarc.c

gpiarcp.obj : gpiarcp.c gpiarc.h arc_util.h pttdlldf.h arc_grid.h
   $(compile) /Fo$@ gpiarcp.c

gpiarcx.obj : gpiarcx.c gpiarc.h arc_util.h pttdlldf.h arc_grid.h
   $(compile) /Fo$@ gpiarcx.c

gpiarcx2.obj : gpiarcx2.c gpiarc.h arc_util.h pttdlldf.h arc_grid.h
   $(compile) /Fo$@ gpiarcx2.c

gpiarcx3.obj : gpiarcx3.c gpiarc.h arc_util.h pttdlldf.h
   $(compile) /Fo$@ gpiarcx3.c

arc_grid.obj : arc_grid.c arc_grid.h arc_util.h
   $(compile) /Fo$@ arc_grid.c

arc_util.obj : arc_util.c arc_util.h pttdlldf.h
   $(compile) /Fo$@ arc_util.c

arcutil2.obj : arcutil2.c arc_util.h pttdlldf.h
   $(compile) /Fo$@ arcutil2.c

common.obj : common.c common.h pttdlldf.h
   $(compile) /Fo$@ common.c

pttdllvr.obj : pttdllvr.c errors.h pttdlldf.h
   $(compile) /Fo$@ pttdllvr.c

gpiarc.dll: $(OBJS)
      $(LINKER) /nofree $(LFLAGS) \
          $(OBJS),gpiarc.dll,gpiarc.map,$(LLIBS),gpiarc.def

