#define INCL_WIN
#define INCL_DEV
#define INCL_GPI
#define INCL_ERRORS    // PM error definitions
#include <string.h>
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include "PTTDLLDF.h"
#include "arc_util.h"


#define LCID_FIXED10   1L

static SHORT sFontSize[6] = {80, 100, 120, 140, 180, 240};
static CHAR *szFacename[4] = {"System Proportional", "Courier", "Helv", "Tms Rmn"};
static LONG alMatch[4][6];
//static LONG MyMatch;  BSC-Not used
//static LONG MyAveCharWidth; BSC-Not used
//static CHAR MyFacename[FACESIZE]; BSC-Not used


// * RCB 10/29/91:  NOTE: THIS FILE IS BASICALLY STDUTIL2.C WITH MINOR CHANGES
// *                MADE IN ORDER TO ALLOW LIMITED INTEGRATED USE OF PHASE I AND
// *                PHASE II FUNCTIONS FOR GPIARC.DLL.  GPIARC IS A PHASE I DLL,
// *                BUT IT WAS BENEFICIAL TO WRITE THE RETURN CODE TESTS UTILIZING
// *                PHASE II FUNCTIONS.  PHASE I AND PHASE II ARE NORMALLY
// *                INCOMPATIBLE.
// *

 /***************************************************************************
 *\\ddd
 * Routine name:  set_delta1()
 *
 * Purpose:   This is the initialization routine that sets the following
 *            global variables for use in formatting output to the proper
 *            screen or printer location.  Sets:
 *                 *pBasisX       - horizontal units per page
 *                 *pBasisY       - vertical units per page
 *                 width_in_pels  - device width
 *                 height_in_pels - device height
 *                 hori_pels_per_m- horizontal resolution
 *                 vert_pels_per_m- vertical resolution
 *                 delta_x        - units per horizontal inch
 *                 delta_y        - units per vertical inch
 *                 pg_size_x      - horizontal page size in smallest whole inch
 *                 pg_size_y      - vertical page size in smallest whole inch
 *                 line_space     - std amount of vertical space between lines
 *                                  of text
 *
 * System Requirements:  None
 *
 * Revision Log:  11/28/90, PDVT, Kim Cairns
 *                   - initial module completion
 *
 * Inputs:    hPS                 - presentation space handle
 *
 * Outputs:   hDC                 - device context handle
 *
 * Subroutines Required: None
 *
 * Limitations: None
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *  set *pBasisX and *pBasisY = 10000
 *  use DevQueryCaps() to get:
 *    width_in_pels
 *    height_in_pels
 *    hori_pels_per_m
 *    vert_pels_per_m
 *  and calculate:
 *    delta_x
 *    delta_y
 *    pg_size_x
 *    pg_size_y
 *    line_space
 *
 *\\end
 ***************************************************************************/

HDC set_delta1(HPS hPS)
{
    LONG   alArray[12], buf[2];
    HDC    hDC;

    *pBasisX = 10000;                            // horizontal units per page
    *pBasisY = 10000;                                    // vertical units per page
    hDC = GpiQueryDevice(hPS);

    DevQueryCaps(hDC, 4L, 6L, alArray);

    width_in_pels = alArray[0];                  // device width
    height_in_pels = alArray[1];                    // device height
    buf[0] = alArray[2];                         // we don't need these two
    buf[1] = alArray[3];
    hori_pels_per_m = alArray[4];                // horizontal resolution
    vert_pels_per_m = alArray[5];                // vertical resolution
    delta_x = (254 * hori_pels_per_m) / width_in_pels;
    delta_y = (254 * vert_pels_per_m) / height_in_pels;
                                                  // page size in whole inches


// RCB  11/11/91: FIX*******************************************************
    DevQueryCaps(hDC, CAPS_TECHNOLOGY, 1L, alArray);
    if (alArray[0] == CAPS_TECH_RASTER_DISPLAY)
    {
       pg_size_x = (width_in_pels * 10000) / (hori_pels_per_m * 254);
       pg_size_y = (height_in_pels * 10000) / (vert_pels_per_m * 254);
    }
    else
    {
       DevQueryCaps(hDC, CAPS_HORIZONTAL_FONT_RES, 2L, alArray);
       pg_size_x = width_in_pels / alArray[0];
       pg_size_y = height_in_pels / alArray[1];
    }

// RCB  11/11/91: ************END OF FIX************************************

    line_space = delta_y * 1/5;
    return(hDC);                                            // device context handle
}


 /***************************************************************************
 *\\ddd
 * Routine name:  EzfQueryFonts
 *
 * Purpose:  This is a function to query available fonts
 *
 * System Requirements:  None
 *
 * Revision Log:  12/04/90, PDVT, Kim Cairns
 *                - initial function design
 *                01/10/91, PDVT, Kim Cairns
 *                - made common code
 *                - 06/13/91 Tim Seevers
 *                  Added code to initialize alMatch.
 *
 * Inputs:
 *             hPS            - presentation space handle
 *
 * Outputs:
 *             TRUE if useable font(s) available
 *             FALSE if all font(s) too large
 *
 * Subroutines Required:
 *             None
 *
 * Limitations:
 *             None
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 * for fonts System Proportional, Courier, Times Roman, Helvetica
 *   query font information
 *   return FALSE if all fonts too large
 *      else return TRUE
 *
 *\\end
 ***************************************************************************/
BOOL EzfQueryFonts (HPS hps)
{
  FONTMETRICS *pfm;
  HDC         hdc;
  LONG        lHorzRes, lVertRes, lRequestFonts, lNumberFonts;
  SHORT       sIndex, sFace, sSize;
  USHORT                  i, j;

  hdc = GpiQueryDevice(hps);
  DevQueryCaps(hdc, CAPS_HORIZONTAL_FONT_RES, 1L, &lHorzRes);
  DevQueryCaps(hdc, CAPS_VERTICAL_FONT_RES, 1L, &lVertRes);

  /*intializing the two dimensional array of alMatch[4][6]*/
        for (i=0; i<4; i++)
        {
          for (j=0; j<6; j++)
                {
                 alMatch[i][j] = 0;
                }
        }

  for (sFace = 0; sFace<4; sFace++)
  {
     lRequestFonts = 0;
     lNumberFonts = GpiQueryFonts(hps, QF_PUBLIC, szFacename[sFace],
                                  &lRequestFonts, 0L, NULL);

     if (lNumberFonts == 0)
        continue;
     if (lNumberFonts * sizeof(FONTMETRICS) >= 65536L)
        return FALSE;
       pfm = malloc ((SHORT) lNumberFonts*sizeof(FONTMETRICS));

     if (pfm == NULL)
        return FALSE;
     GpiQueryFonts(hps, QF_PUBLIC, szFacename[sFace], &lNumberFonts,
                   (LONG) sizeof (FONTMETRICS), pfm);
     for (sIndex = 0; sIndex < (SHORT) lNumberFonts; sIndex++)

//TSS...avoid when font crosses segment.
    if( (sIndex != 315) && (sIndex != 630) && (sIndex != 945) && (sIndex != 1260) )
         sIndex += 1;

        if (pfm[sIndex].sXDeviceRes == (SHORT) lHorzRes &&
            pfm[sIndex].sYDeviceRes == (SHORT) lVertRes)
            {
            for (sSize = 0; sSize < 6; sSize++)
              if (pfm[sIndex].sNominalPointSize == sFontSize[sSize])
                 break;
            if (sSize != 6)
              alMatch[sFace][sSize] = pfm[sIndex].lMatch;
            }
     free(pfm);
     }
  return TRUE;
}

 /***************************************************************************
 *\\ddd
 * Routine name:  EzfCreateLogicalFonts
 *
 * Purpose:  This is a function to create a logical font
 *
 * System Requirements:  None
 *
 * Revision Log:  12/04/90, PDVT, Kim Cairns
 *                - initial function design
 *                01/10/91, PDVT, Kim Cairns
 *                - made common code
 *
 * Inputs:
 *             hPS            - presentation space handle
 *             lcid           - font id
 *             idFace         - face name of desired font
 *             idSize         - size of desired font
 *             fsSelection    - other desired font criterion
 *
 * Outputs:
 *             0 if criteria out of range
 *             The lcid of the selected font
 *
 * Subroutines Required:
 *             None
 *
 * Limitations:
 *             None
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *   return FALSE if criteria out of range
 *   GpiCreateLogFont for desired criteria and return lcid
 *
 *\\end
 ***************************************************************************/
LONG EzfCreateLogFont(HPS hps, LONG lcid, USHORT idFace, USHORT idSize,
                      USHORT fsSelection)
{
  static FATTRS fat;

  if (idFace > 3 || idSize > 5 || alMatch[idFace][idSize] == 0)
     return FALSE;
  fat.usRecordLength = sizeof fat;
  fat.fsSelection = fsSelection;
  fat.lMatch = alMatch[idFace][idSize];
  if (fat.lMatch == 0)                //TSS...initialize codepage per Vish
        {
          fat.usCodePage = 850;
        }
  strcpy(fat.szFacename, szFacename[idFace]);
  return GpiCreateLogFont(hps, NULL, lcid, &fat);
}


VOID APIENTRY MapArrayOfPoints(int num_pts, POINTL aptl[])
{
  int i;

  for (i = 0; i < num_pts; i++) {
      MapPt(aptl[i]);

  }
}
