/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = UTLLOG.C
 *
 * DESCRIPTIVE NAME = PRINTER DRIVER SOURCE FILE
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION DEBUGGING LOG FILE PROCESSING
 *
 *
 * FUNCTIONS
 *
 *
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#pragma pack(1)
#define  INCL_PM
#include "inc\prdinclt.h"
#include "inc\prdgextf.h"
#include "inc\prdeextf.h"
#include "inc\prdmath.h"
#include "inc\prderre.h"
#include "inc\utl.h"
#include "inc\pspagtun.h"             /* V2.174057  Page Tuning */
// @V4.0169885
#include "inc\uinames.h"

#define  INCL_WINSHELLDATA

#if      DEBUG
/*
** The character buffer's szlog1 and szlog2 always contain the
** a human readable indication of what the two most recent calls
** from the engine were.
*/

char szlog1[128];                      /* Buffer containing the most recent */
                                       /* call                              */
char szlog2[128];
BOOL fLogFileIsOpen = FALSE;           /* TRUE if the log file's been       */
                                       /* opened                            */
HFILE fhLog;                           /* The log file handle               */
PDV pdvSave = NULL;

/***************************************************************************
 *
 * FUNCTION NAME =  LogIsOn()
 *
 * DESCRIPTION   =
 *
 * INPUT         = NONE
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = TRUE if log is on
 *
 * RETURN-ERROR  = FALSE if log is not on
 *
 **************************************************************************/

BOOL LogIsOn()
{
  char szSkip[10];
  char szLog[10];
  char szFile[10];
  BOOL fLogIsOn;

  // @V4.0169885
#if 0
//PrfQueryProfileString (HINI_PROFILE, (PSZ) "PSCRIPT", (PSZ) "LOG", (PSZ) "",
//                       (PSZ) szLog, (ULONG) sizeof (szLog));
//PrfQueryProfileString (HINI_PROFILE, (PSZ) "PSCRIPT", (PSZ) "SKIPCOUNT",
//                       (PSZ) "", (PSZ) szSkip, (ULONG) sizeof (szSkip));
#endif
  PrfQueryProfileString (HINI_PROFILE, (PSZ) PSCRIPT_DRV_NAME, (PSZ) "LOG",
                         (PSZ) "", (PSZ) szLog, (ULONG) sizeof (szLog));
  PrfQueryProfileString (HINI_PROFILE, (PSZ) PSCRIPT_DRV_NAME, (PSZ) "SKIPCOUNT",
                         (PSZ) "", (PSZ) szSkip, (ULONG) sizeof (szSkip));
  fLogIsOn = FALSE;

  if (szLog[0] == '1')
  {
    switch (szSkip[0])
    {
    case '0':
         fLogIsOn = TRUE;
         // @V4.0169885
#if 0
//       PrfWriteProfileString (HINI_SYSTEMPROFILE, (PSZ) "PSCRIPT", (PSZ) "LOG",
//                              (PSZ) "0");
//       PrfWriteProfileString (HINI_SYSTEMPROFILE, (PSZ) "PSCRIPT",
//                              (PSZ) "SKIPCOUNT", (PSZ) "-");
#endif
         PrfWriteProfileString (HINI_SYSTEMPROFILE, (PSZ) PSCRIPT_DRV_NAME,
                                (PSZ) "LOG", (PSZ) "0");
         PrfWriteProfileString (HINI_SYSTEMPROFILE, (PSZ) PSCRIPT_DRV_NAME,
                                (PSZ) "SKIPCOUNT", (PSZ) "-");
         break;

    case '1':
    case '2':
    case '3':
         szSkip[0] = szSkip[0] - 1;
         // @V4.0169885
#if 0
//       PrfWriteProfileString (HINI_SYSTEMPROFILE, (PSZ) "PSCRIPT",
//                              (PSZ) "SKIPCOUNT", (PSZ) szSkip);
#endif
         PrfWriteProfileString (HINI_SYSTEMPROFILE, (PSZ) PSCRIPT_DRV_NAME,
                                (PSZ) "SKIPCOUNT", (PSZ) szSkip);
         break;

    default:
         fLogIsOn = TRUE;
         break;
    }
  }
  return (fLogIsOn);
}


/***************************************************************************
 *
 * FUNCTION NAME = OpenLogFile()
 *
 * DESCRIPTION   = This routine opens the debugging log file.
 *
 * INPUT         = (pdv)
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

void OpenLogFile (PDV pdv)
{
  static SHORT iSkipCount = 0;
  ULONG      Temp;
  char       szBuffer[10];
  BOOL       fDoSkip;


  if (!LogIsOn ())
  {
    return;
  }
  fLogFileIsOpen = !DosOpen ("log.txt", (PHFILE) &fhLog, (PULONG) &Temp, 0L,
                             0L, 0x12, 0x42, 0L);

  /*
  ** Save the DV pointer so that CloseLogFile knows when a
  ** matching close occurs.
  */
  if (fLogFileIsOpen)
  {
    pdvSave = pdv;
  }
}


/***************************************************************************
 *
 * FUNCTION NAME = CloseLogFile(pdv)
 *
 * DESCRIPTION   = CloseLogFile
 *
 * INPUT         = pdv
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

void CloseLogFile (PDV pdv)
{
  /*
  ** Close the log file only for the DV that matches
  ** the one that was used to open the log file.
  */
  if (pdv != pdvSave)
  {
    return;
  }

  if (fLogFileIsOpen)
  {
    DosClose (fhLog);
    fLogFileIsOpen = FALSE;
    pdvSave = NULL;
  }
}


/***************************************************************************
 *
 * FUNCTION NAME = PrintLog()
 *
 * DESCRIPTION   = This routine sends formatted output to the log file.
 *                 A printf-style format string specifies the format of
 *                 the output.
 *
 * INPUT         = pszFormat
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

void PrintLog (PSZ pszFormat, ...)
  /* PSZ pszFormat;                        Near ptr to the format string     */
{
  static char szBuf[128];
  ULONG       nb;                      /* Number of bytes deposited by      */
                                       /* kprintf                           */
  ULONG nbWritten;

  if (!fLogFileIsOpen)
  {
    return;
  }

  /*
  ** Make the PrintLog output be indented four spaces from LogCall
  */
  szBuf[0] = ' ';
  szBuf[1] = ' ';
  szBuf[2] = ' ';
  szBuf[3] = ' ';

  /*
  ** Deposit the formatted output in the buffer
  */
  nb = kprintf (FALSE, (PB) &szBuf[4], sizeof (szBuf) - 4, pszFormat,
                (ULONG *) (((PSZ) &pszFormat) + sizeof (PSZ)));

  /*
  ** If the log file is valid, write the output to the log file
  */
  if (fLogFileIsOpen)
  {
    if (DosWrite ((HFILE) fhLog, szBuf, (ULONG) (nb + 4), (PULONG) &nbWritten))
    {
      CloseLogFile (pdvSave);
    }
  }
}

/***************************************************************************
 *
 * FUNCTION NAME = LogCall()
 *
 * DESCRIPTION   = This function is used to log engine calls to the driver.
 *                   the output is recorded in the log file.
 *
 *                 Note: The two most recent engine calls can always be
 *                       determined by looking in the szlog1 and szlog2
 *                       buffers.
 *
 * INPUT         = pszFormat, lpStack
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

void LogCall (PSZ pszFormat, char *lpStack)
{
  ULONG nbWritten;
  ULONG nb;
  SHORT   i;

  if (!fLogFileIsOpen)
  {
    return;
  }

  /*
  ** Copy the current command buffer to the previous command buffer
  ** and zero out the current command buffer
  */
  for (i = 0 ; i < sizeof (szlog2) ; ++i)
  {
    szlog2[i] = szlog1[i];
    szlog1[i] = 0;
  }
  nb = 2;
  szlog1[0] = '\r';
  szlog1[1] = '\n';

  /*
  ** Deposit the formated output in the first log buffer
  */
  nb += kprintf (FALSE, (PB) &szlog1[2], sizeof (szlog1) - 2, pszFormat,
                 (ULONG *) lpStack);

  /*
  ** Terminate the line with Cr/Lf and a null
  */
  if (nb < (sizeof (szlog1) + 3))
  {
    szlog1[nb++] = '\r';
    szlog1[nb++] = '\n';
  }

  /*
  ** If the log file is valid, write the new log entry to the file
  */
  if (fLogFileIsOpen)
  {
    if (DosWrite ((HFILE) fhLog, szlog1, (ULONG) nb, (PULONG) &nbWritten))
    {
      CloseLogFile (pdvSave);
    }
  }
}


/***************************************************************************
 *
 * FUNCTION NAME = LogReturn()
 *
 * DESCRIPTION   = This function is used to log function return values.
 *
 * INPUT         = psz, lVal
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

void LogReturn (PSZ psz, LONG lVal)
{
  if (!fLogFileIsOpen)
  {
    return;
  }
  PrintLog ((PSZ) "return from %ls: %ld\n", psz, lVal);
}

#endif
