/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = pstuner.c
 *
 * DESCRIPTIVE NAME = Contains a page tuning query function.
 *
 *
 * VERSION = V2.1
 *
 * DATE
 *
 * DESCRIPTION
 * This file contains the function QueryTunerProcData, which is used by a
 * profiling hook for page tuning.  The reason     this function is defined
 * in a separate file is because, when compiling for page-tuning, all source
 * files are to enable with profiling hooks enabled (/Gh+).  This function is
 * the only exception.  It is to be compiled with profiling hooks disabled
 * (/Gh-).  The reason is because the hook calls QueryTunerProcData.  If this
 * compiled with hook-enable, a fatal recursion occurs.  The section in the
 * MAKE file that compiles this file *MUST* include '/Gh-' as the *LAST*
 * option.  This is so that, if '/Gh+' is defined as an option elsewhere,
 * '/Gh-' being last overrides any previous setting.
 *
 * ** PAGE-TUNING NOTES:
 * - To include TUNERPROCDATA, on the command line, include "PTUNE=1".
 * - Before page-tuning, delete all PAGETUNE OBJ files.  This is to ensure a
 *   clean build.
 *
 * FUNCTIONS  - QueryTunerProcData
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#pragma pack(1) 
/*
** TUNER.H is included in PSPAGETUN.H.
*/
#define  INCL_BASE
#include <os2.h>
#include "inc\pspagtun.h"





/*
** If page-tuning is enabled, define the global structure TUNERPROCDATA.
** If disabled, QueryTunerProcData will still be exported, so define it as
** a dummy VOID function.
*/
#ifdef PAGE_TUNE
  /*
  ** TunerProcData is defined in MEMORY.C.
  */
  extern TUNERPROCDATA TunerProcData;
#else
  typedef VOID PTUNERPROCDATA;
  PTUNERPROCDATA QueryTunerProcData( VOID );
#endif





/***************************************************************************
 *
 * FUNCTION NAME = QueryTunerProcData
 *
 * DESCRIPTION   = This function is only used when page-tuning.  It returns
 *                 a pointer to the global TUNERPROCDATA structure, which
 *                 is defined on a per-process basis.  This is used by
 *                 a profiling hook to determine the minimum number of pages
 *                 needed by this driver.
 *                 This function is exported.
 *
 * INPUT         = None.
 *
 * OUTPUT        = None.
 *
 * RETURN-NORMAL = Pointer to structure TunerProcData.
 *                 TunerProcData is defined in MEMORY.C
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/
PTUNERPROCDATA QueryTunerProcData( )
{
  #ifdef PAGE_TUNE
    return( &TunerProcData );
  #endif
}
