/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PPDLG.C
 *
 * DESCRIPTIVE NAME = Functions to maintain the Postscript Printer Properties.
 *
 *
 * VERSION = V1.0
 *
 * DATE
 *
 * AUTHORS : Larry Moore and Debbie Cook
 *
 * DESCRIPTION : This file contains functions and procedures to maintain the
 *               Printer Properties dialog box.
 *
 *
 * FUNCTIONS :         PrinterPropertiesDlgProc
 *                     FormDefPageDlgProc
 *                     FormPPPageInitControls
 *                     DefineFormsDlgProc
 *                     ModeSwitchDlgProc
 *                     ModeSwitchInitPage
 *                     ModeSwitchSaveSettings
 *                     VerifyTrayFormMapping
 *                     InitializeCustomForms
 *
 * NOTES
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
#pragma pack(1)
#define  INCL_PM
#define  INCL_GRE_DCS
#define  INCL_DOSNLS
#define  INCL_TKTP
#define  INCL_GENPLIB_ERROR
#define  INCL_GENPLIB_LAYOUT
#define  INCL_GENPLIB_FONTSUB
#define  INCL_GENPLIB_FONTMGR
#define  INCL_GENPLIB_GPLUTIL
#define  INCL_GENPLIB_WEBPAGE  

#include <os2.h>
#include <pmddi.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <genplib.h>
#include "inc\config.h"
#include "inc\ppdialog.h"
#include "inc\profile.h"
#include "inc\dlgproc.h"
#include "inc\dlg.h"
#include "inc\profile.h"
#include "inc\uinames.h"
#include "inc\pspagtun.h"

#ifndef DDKBLD                                                            //@V1.0VV06
#include <fontmgr.h>
#include "inc\enumpage.h"
#include "fntlib\inc\fntlib.h"
#endif                                                                    //@V1.0VV06

/****************************************************************************\
** DEFINES START                                                            **
\****************************************************************************/
#define NUM_OF_PAGES        3
#define NUM_OF_TOTAL_FORMS  64

/****************************************************************************\
** DEFINES END                                                              **
\****************************************************************************/





/****************************************************************************\
** TYPEDEFS START                                                           **
\****************************************************************************/
/****************************************************************************\
** TYPEDEFS END                                                             **
\****************************************************************************/





/****************************************************************************\
** FUNCTION PROTOTYPES START                                                **
\****************************************************************************/
MRESULT EXPENTRY FormDefPageDlgProc( HWND, ULONG, MPARAM, MPARAM );
MRESULT EXPENTRY ModeSwitchDlgProc( HWND, ULONG, MPARAM, MPARAM );
VOID FormPPPageInitControls( HWND, PDLGHDR );
MRESULT EXPENTRY DefineFormsDlgProc( HWND, ULONG, MPARAM, MPARAM );
HWND QueryCurrentForm( HWND, PUSHORT, PUINT );
VOID ModeSwitchInitPage( HWND, PDLGHDR );
VOID ModeSwitchSaveSettings( HWND, PDLGHDR );
BOOL VerifyTrayFormMapping( HWND );
VOID InitializeCustomForms( HWND, PDLGHDR );
BOOL QueryAddFormButtonStatus( PDLGHDR, HWND );
INT VerifyUniqueForm( HWND, PDLGHDR, PSZ );
BOOL CompareStri( PSZ, PSZ );
BOOL EnableDefineFormAddButton( HWND );
VOID FormPPPageDefaultControls( HWND, PDLGHDR );
VOID ModeSwitchDefaultControls( HWND, PDLGHDR );
VOID ListMatchingForms( HWND, PDLGHDR, HWND );
VOID SetMatchingTrayHandle( PDLGHDR, HWND, HWND );
MRESULT APIENTRY FontMgrCallbackProc(PVOID, PVOID);       
INT ps_upper( PSZ, PSZ );
/****************************************************************************\
** FUNCTION PROTOTYPES END                                                  **
\****************************************************************************/





/****************************************************************************\
** EXTERNAL DEFINITIONS START                                               **
\****************************************************************************/
extern PBYTE StringTable[ MAX_STRINGS ];
extern VOID PrintFontMem( PCNFDATA );
extern LONG DefaultFontCount( PDESPPD );
extern SHORT szDlmCopy( PSZ, PSZ, SHORT );
extern BOOL _System szIsEqual( PSZ, PSZ );
extern PSZ GetDefaultPageSize( PDESPPD, PBYTE );
extern BOOL CheckNumeric( HWND, PSZ );
extern SHORT cvi( PB * );
extern LONG UpdateSelection( HWND, PDLGHDR, ULONG, BOOL );
/****************************************************************************\
** EXTERNAL DEFINITIONS END                                                 **
\****************************************************************************/


/****************************************************************************\
** GLOBAL VARIABLES START                                                   **
\****************************************************************************/
/*
** For JPNB_DLG_UI, an argument will be passed into to QueryFeaturePageLoad,
** but at this time, the argument isn't defined yet, so set the field to NULL.
*/
GDPTMPL DlgPPTmplTable[ NUM_OF_PAGES ] =
{
  PPNB_DLG_FORMS,      (PFNWP) FormDefPageDlgProc, JPF_TAB,  GTAB_ID, 0,
  PPNB_DLG_AUTOSWITCH, (PFNWP) ModeSwitchDlgProc,  PPA_TAB,  GTAB_ID, 0,
  JPNB_DLG_UI,         (PFNWP) FeaturePageDlgProc, JPUI_TAB, GTAB_ID, 0
};

#define PP_FORM_PAGE_INDEX       0
#define PP_OPTIONS_PAGE_INDEX    1
#define PP_FEATURE_PAGE_INDEX    2

//HWND   hNotebook;
USHORT usCustString;           // index of custom string
SHORT  sCFormCount;
/****************************************************************************\
** GLOBAL VARIABLES END                                                     **
\****************************************************************************/

/****************************************************************************/
/* PROCEDURE NAME : InitWebDownloadPage                                     */
/* AUTHOR         : Valters Vingolds                                        */
/* DATE WRITTEN   : 04/14/00                                                */
/* DESCRIPTION    : Initialize and add Web Download notebook page to        */
/*                  printer properties.                                     */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/****************************************************************************/


VOID InitWebDownloadPage( PDLGHDR pPPHdr )
{
// driver-global default URL's. Can be overriden by defining device-specific
// urls in ExtraDV (devlst.c)
#define DEFAULT_HOME_URL "http://service.software.ibm.com/os2ddpak/html/printers/index.htm"
#define DEFAULT_DRIVER_URL "ftp://service.boulder.ibm.com/ps/products/os2/printpak/"

   PVOID   pWebPageCB;
   WEBPAGE_DRIVERINFO sWebPageDriverInfo;

   //
   // Web notebook page initialization
   //
   pWebPageCB = NULL;

   // if there is special home URL for that device, show that url,
   // else - default catch-all URL.
   if( pPPHdr->pExtraDV && pPPHdr->pExtraDV->pszHomeURL )
   {
      sWebPageDriverInfo.pszHomeURL = pPPHdr->pExtraDV->pszHomeURL;
   }
   else
      sWebPageDriverInfo.pszHomeURL = DEFAULT_HOME_URL;

   // if there is special driver download URL for that device, show that url,
   // else - default catch-all URL
   if( pPPHdr->pExtraDV && pPPHdr->pExtraDV->pszDriverURL )
   {
      sWebPageDriverInfo.pszDriverURL = pPPHdr->pExtraDV->pszDriverURL;
   }
   else
      sWebPageDriverInfo.pszDriverURL = DEFAULT_DRIVER_URL;

   // give webpage printer's INI key to read data from
   sWebPageDriverInfo.pszKeyApp = pPPHdr->pCNFData->szKeyApp;

   pPPHdr->hWebPagePgInst = GplWebCreatePage(                          
                                               pPPHdr->hNBInstance,   
                                               pWebPageCB,            
                                               NULL,                  
                                               NULL,        
                                               &sWebPageDriverInfo    
                                            );                        
}




/******************************************************************************
 *
 * FUNCTION NAME = PrinterPropertiesDlgProc
 *
 * DESCRIPTION
 * This is the procedure to maintain the Printer Properties dialog box.
 *
 * INPUT
 * hDlg - Dialog handle.
 * ulMsg - Dialog message ID.
 * mp1 - Message parameter 1.
 * mp2 - Message parameter 2.
 *
 * OUTPUT
 * None
 *
 * RETURN-NORMAL - Return code from WinDefDlgProc.
 * RETURN-ERROR  - Return code from WinDefDlgProc.
 *
 *****************************************************************************/
MRESULT EXPENTRY PrinterPropertiesDlgProc( HWND hDlg, ULONG ulMsg, MPARAM mp1,
                                           MPARAM mp2 )
{
  PDLGHDR pPPHdr;                  // Printer properties header
  
#ifndef DDKBLD                                                             //@V1.0VV06
  // GENPLIB Font Manager data
  PVOID   pFontMgrCB;
  FNTMGR_DRIVERINFO rFntMgrDriverInfo;
#endif                                                                     //@V1.0VV06

  UINT    uiLoop;                  // Local loop counter
  MRESULT mRC = (MRESULT) FALSE;   // Function return code

  switch( ulMsg )
  {
  case WM_INITDLG:
       if ((pPPHdr = InitializeDialogHeader( hDlg, mp2, NUM_OF_PAGES ))
           != NULL)
       {
         InitializeDialog( hDlg, pPPHdr, DPDM_CHANGEPROP, DlgPPTmplTable,
                           NULL, NUM_OF_PAGES, 0, PP_FEATURE_PAGE_INDEX );

         // add the font substitution page.
//@FS    pPPHdr->hFSInstance = GplFontsubCreatePage( pPPHdr->hNBInstance,
//@FS                                                NULL,
//@FS                                                pPPHdr->pCNFData->szKeyApp,
//@FS                                                0 );
         // one more page.
//@FS    if (pPPHdr->hFSInstance) pPPHdr->usNumOfPages++;

#ifndef DDKBLD                                                             //@V1.0VV06
         //
         // Font Manager initialization
         //
         if ( GreQueryEngineVersion() >= 0x220 &&
              GplFontMgrCheckEnvironment() &&
              !CHECKFLAG_EXT(pPPHdr->pExtraDV,ulFlags,NO_FNTMGR) )
         {
            pFontMgrCB = pPPHdr;
            memset( &rFntMgrDriverInfo, 0, sizeof(rFntMgrDriverInfo) );
            rFntMgrDriverInfo.pszPrinterName = pPPHdr->pCNFData->szKeyApp;
            rFntMgrDriverInfo.rDevInfo.lHarddisk = STORAGE_STATUS_UNKNOWN;
            rFntMgrDriverInfo.rDevInfo.lFlash = STORAGE_STATUS_ERROR;
            rFntMgrDriverInfo.rDevInfo.lRAM = STORAGE_STATUS_UNKNOWN;
            rFntMgrDriverInfo.rFontFuncDispatch.pfnFontFuncFileRecognize = FntLibRecognizeFontPS;
            rFntMgrDriverInfo.rFontFuncDispatch.pfnFontFuncFileDownload = FntLibDownloadFontPS;
            rFntMgrDriverInfo.rFontFuncDispatch.pfnFontFuncFileReload = FntLibReloadFontPS;
            rFntMgrDriverInfo.rFontFuncDispatch.pfnFontFuncFileUninstall = FntLibDeleteFontPS;
            pPPHdr->hFontMgrPgInst = GplFontMgrCreatePage(pPPHdr->hNBInstance,
               pFontMgrCB, NULL, (PVOID) pPPHdr, &rFntMgrDriverInfo);
          }
#endif                                                                     //@V1.0VV06

          InitWebDownloadPage( pPPHdr );                          

       }
       break;

  case WM_COMMAND:
       pPPHdr = (PDLGHDR) WinQueryWindowULong( hDlg, QWL_USER );
       switch( SHORT1FROMMP( mp1 ) )
       {
       // OK - Exit dialog box, save settings.
       case PSB_OK:
            if ( SaveDialogSettings(WinWindowFromID(hDlg, PS_NOTEBOOK_GROUP)) )
            {
              if (VerifyAndSaveSettings( pPPHdr ) == PMERR_OK)
              {
                GplWebDestroyPage    (0, pPPHdr->hWebPagePgInst);            
#ifndef DDKBLD                                                             //@V1.0VV06
                GplFontMgrDestroyPage(0, pPPHdr->hFontMgrPgInst);
#endif                                                                     //@V1.0VV06
              // remove the font substitution page.
//@FS           GplFontsubDestroyPage( 0, pPPHdr->hFSInstance,
//@FS                                  TRUE);
                WrtQueryProfile( hDlg, pPPHdr->pdesPPD, pPPHdr->pCNFData );
                ClosePSDlg( hDlg, pPPHdr, TRUE );
              }
            }
            break;

       case PSB_DEFAULT:
            // PUT SOME DEFAULT CODE IN HERE!!!!!
            break;

       case DID_CANCEL:
       case PSB_CANCEL:
            GplWebDestroyPage    (0, pPPHdr->hWebPagePgInst);                
#ifndef DDKBLD                                                             //@V1.0VV06
            GplFontMgrDestroyPage(0, pPPHdr->hFontMgrPgInst);
#endif                                                                     //@V1.0VV06
            // remove the font substitution page.
//@FS       GplFontsubDestroyPage( 0, pPPHdr->hFSInstance,
//@FS                              FALSE);

            ClosePSDlg( hDlg, pPPHdr, FALSE );
            break;

       case PSB_HELP:
            // PUT SOME HELP CODE IN HERE!!!!!
            break;
       }
       break;

  case WM_CLOSE:
       /*
       ** The OK button ID already contains code to save the current data.
       ** Rather than duplicate the code, simply send an OK message since the
       ** processing for both messages is the same.
       */
       WinSendMsg( hDlg, WM_COMMAND, (MPARAM) PSB_OK, (MPARAM) 0 );
       break;

  case WM_CONTROLPOINTER:
       mRC = SetContextHelp( hDlg, ulMsg, mp1, mp2, NULL, 0, 0 );
       break;
       
  case WM_HITTEST:
       // Simulate WM_CONTROLPOINTER for controls such as spinbutton.
       GplHitTestHandler(hDlg, mp1, mp2);
       break;

  default:
       mRC = WinDefDlgProc( hDlg, ulMsg, mp1, mp2 );
  }

  return( mRC );
}
/*---------------------------------------------------------------------------*\
* PrinterPropertiesDlgProc End                                                *
\*---------------------------------------------------------------------------*/





/******************************************************************************
 *
 * FUNCTION NAME = FormDefPageDlgProc
 *
 * DESCRIPTION
 * This is the procedure to maintain the "Forms" page.
 *
 * INPUT
 * hDlg - Dialog handle.
 * ulMsg - Dialog message ID.
 * mp1 - Message parameter 1.
 * mp2 - Message parameter 2.
 *
 * OUTPUT
 * None
 *
 * RETURN-NORMAL - Return code from WinDefDlgProc.
 * RETURN-ERROR  - Return code from WinDefDlgProc.
 *
 *****************************************************************************/
MRESULT EXPENTRY FormDefPageDlgProc( HWND hDlg, ULONG ulMsg, MPARAM mp1,
                                     MPARAM mp2 )
{
  PDLGHDR  pPPHdr;                   // Printer Properties header struct
  BOOL     bCustomForm;              // TRUE if custom form is requested
  HWND     hCtrl;                    // Control handle
  SHORT    sIndex;                   // Index value
  LONG     lItemHandle;              // Handle of a specific item
  MRESULT  mRC = (MRESULT) FALSE;    // Function return code
  SHORT    sLoop;                     // Local loop counter
  SHORT    sLoop2;                    // Local loop counter
  PSZ      pDummyPtr = NULL;

  if (ulMsg != WM_INITDLG)
  {
    pPPHdr = (PDLGHDR) WinQueryWindowULong( hDlg, QWL_USER );
  }

  switch( ulMsg )
  {
  case WM_INITDLG:
       pPPHdr = InitDlgULong( hDlg, mp2 );

       FormPPPageInitControls( hDlg, pPPHdr );
       break;

  case WM_COMMAND:
       switch( LOUSHORT( mp1 ) )
       {
       case PSB_UNDO:
            for (sIndex = 0 ; sIndex < NUM_OF_UNQ_FORMS ; sIndex++)
            {
              if (pPPHdr->stUnqFrmLst[ sIndex ].sFlag == UNQ_FORM_NEW)
              {
                pPPHdr->stUnqFrmLst[ sIndex ].aFormName[ 0 ] = 0;
              }

              pPPHdr->stUnqFrmLst[ sIndex ].sFlag = 0;
            }

            FormPPPageInitControls( hDlg, pPPHdr );
            break;

       case PSB_DEFAULT:
            FormPPPageDefaultControls( hDlg, pPPHdr );
            break;

       case PPF_DEFINEFORM:
            if ((lItemHandle = (LONG) WinDlgBox( HWND_DESKTOP, hDlg,
                                      DefineFormsDlgProc,
                                      pPPHdr->pCNFData->hmod, PPDLG_DEFFORMS,
                                      (PVOID) pPPHdr )) != -1)
            {
              /*
              ** Insert the new string into the listbox.  Set the handle as
              ** well.  The handle is the zero-based offset of that form data
              ** in the UNQFRM list structure.  The high bit (bit 15) is set
              ** to 1 to indicate that this is a unique form.
              */
              hCtrl = WinWindowFromID( hDlg, PPF_FORMLIST );
              sIndex = (SHORT) WinSendMsg( hCtrl, LM_INSERTITEM,
                               MPFROMSHORT( LIT_END ),
                               MPFROMP( pPPHdr->stUnqFrmLst[ lItemHandle ].
                               aFormName ) );
              pPPHdr->stUnqFrmLst[ lItemHandle ].sFlag = UNQ_FORM_NEW; // unset UNQ_FORM_DELETE flag //@DISABLE_NF
              WinSendMsg( hCtrl, LM_SETITEMHANDLE, MPFROMSHORT( sIndex ),
                          (MPARAM) CONV_UNQID_TO_LBID( lItemHandle ) );

            }
            QueryAddFormButtonStatus( pPPHdr, hDlg );   // see if we have hit limit  //@DISABLE_NF
            break;

       case PPF_DELETEFORM:
            hCtrl = WinWindowFromID( hDlg, PPF_FORMLIST );

            if (DisplayMessageBox( hDlg, PPDLG_DELFORM_MSG,
                                   PPDLG_DELFORM_TITLE,
                                   MB_YESNO | MB_ICONQUESTION ) == MBID_YES)
            {
              sIndex = (SHORT) WinSendMsg( hCtrl, LM_QUERYSELECTION,
                                           MPFROMSHORT( LIT_FIRST ),
                                           (MPARAM) 0 );

              lItemHandle = (LONG) WinSendMsg( hCtrl, LM_QUERYITEMHANDLE,
                                               MPFROMSHORT( sIndex ),
                                               (MPARAM) 0 );

              lItemHandle = CONV_LBID_TO_UNQID( lItemHandle );

              WinSendMsg( hCtrl, LM_DELETEITEM, MPFROMSHORT( sIndex ),
                          (MPARAM) 0 );

              pPPHdr->stUnqFrmLst[ lItemHandle ].aFormName[0] = 0; //clear FormName so QueryAddFormButtonStatus finds free forms //@DISABLE_NF
              pPPHdr->stUnqFrmLst[ lItemHandle ].sFlag = UNQ_FORM_DELETE;

              QueryAddFormButtonStatus( pPPHdr, hDlg );

              WinSendMsg( hCtrl, LM_SELECTITEM, (MPARAM) 0,
                          MPFROMSHORT( TRUE ) );
            }
            break;

       case DID_CANCEL:
            WinSendMsg( pPPHdr->hDlg , WM_COMMAND, (MPARAM) PSB_CANCEL, (MPARAM) 0 );
       }
       break;

  case WMPS_CONSTRAINTS:
       if (SHORT1FROMMP( mp1 ) != PPF_TRAYLIST)
       {
         WinSendDlgItemMsg( hDlg, PPF_TRAYLIST, UCM_LISTITEMS, (MPARAM) 0,
                            (MPARAM) 0 );
       }
       break;

  case WMPS_SAVESETTINGS:
       if (VerifyTrayFormMapping( hDlg ) == TRUE)
       {
         SavePageTrayINIData( hDlg, pPPHdr );
       }
       mRC = (MRESULT) PMERR_OK;
       break;

  case WMPS_VERIFYSETTINGS:
       mRC = (MRESULT) PMERR_OK;
       if (VerifyTrayFormMapping( hDlg ) == FALSE)
       {
         if (DisplayMessageBox( hDlg, PPF_NOFORMMAPMSG, PPNB_DLG_FORMS,
                                MB_YESNO ) == MBID_NO)
         {
           mRC = (MRESULT) ~PMERR_OK;
         }
       }
       break;

  case WM_CONTROLPOINTER:
       mRC = SetContextHelp( hDlg, ulMsg, mp1, mp2, NULL, 0, 0 );
       break;

  default:
       mRC = WinDefDlgProc( hDlg, ulMsg, mp1, mp2 );
  }

  return( mRC );
}
/*---------------------------------------------------------------------------*\
* FormDefPageDlgProc End                                                      *
\*---------------------------------------------------------------------------*/





/******************************************************************************
 *
 * FUNCTION NAME = FormPPPageInitControls
 *
 * DESCRIPTION
 * Initializes the controls for the "Forms" page for the Printer Properties.
 *
 * INPUT
 * hDlg - Dialog handle.
 * pPPHdr - Printer Properties header
 *
 * OUTPUT
 * None
 *
 * RETURN-NORMAL - None
 * RETURN-ERROR  - None
 *
 *****************************************************************************/
VOID FormPPPageInitControls( HWND hDlg, PDLGHDR pPPHdr )
{
  HWND hTrayCtrl;
  CHAR aTrayString[ MAX_PSIZE ];

  InitializeUIControl( hDlg, pPPHdr, UINAME_PAGESIZE, PPF_FORMLIST, 0 );

  if (InitializeUIControl( hDlg, pPPHdr, UINAME_INPUTSLOT, PPF_TRAYLIST, 0 )
      == NULL)
  {
    hTrayCtrl = WinWindowFromID( hDlg, PPF_TRAYLIST );
    WinLoadString( (HAB) 0, pscript_module, JPF_AUTOTRAYSELECT, MAX_PSIZE,
                   (PSZ) aTrayString );
    WinSendMsg( hTrayCtrl, LM_INSERTITEM, (MPARAM) 0, (MPARAM) aTrayString );
    WinSendMsg( hTrayCtrl, LM_SETITEMHANDLE, (MPARAM) 0,
                (MPARAM) AUTOTRAY_HANDLE );
    WinSendMsg( hTrayCtrl, LM_SELECTITEM, (MPARAM) 0, (MPARAM) TRUE );

    /*
    ** The form listbox requires the pointer to the tray block in order
    ** to be listed.  However, since there are no trays, send a dummy
    ** pointer (-1 in mp1) so that the listbox will be filled.
    */
    WinSendDlgItemMsg( hDlg, PPF_FORMLIST, UCM_LISTITEMS, (MPARAM) -1,
                       (MPARAM) 0 );
  }

  /*
  ** The "Add new form name" button should be highlighted only if there is
  ** room in the UNQFRM structure list for additional unique forms.  If this
  ** is not the case, disable the button.
  */
  QueryAddFormButtonStatus( pPPHdr, hDlg );
}
/*---------------------------------------------------------------------------*\
* FormPPPageInitControls End                                                  *
\*---------------------------------------------------------------------------*/





/******************************************************************************
 *
 * FUNCTION NAME = DefineFormsDlgProc
 *
 * DESCRIPTION
 * Message procedure for the Custom Forms dialog box.
 *
 * INPUT
 * hDlg - Dialog handle
 * ulMsg - Message ID.
 * mp1 - First message parameter
 * mp2 - Second message parameter
 *
 * OUTPUT
 * None
 *
 * RETURN-NORMAL - Return code from WinDefDlgProc
 * RETURN-ERROR  - Return code from WinDefDlgProc
 *
 *****************************************************************************/
MRESULT EXPENTRY DefineFormsDlgProc( HWND hDlg, ULONG uMsg, MPARAM mp1,
                                     MPARAM mp2 )
{
  CHAR    pUniqString[ MAX_PSIZE ];  // Unique string name
  PDLGHDR pDlgHdr;                   // Dialog header pointer
  INT     iUniqFormSel;              // Custom form selected from UNIQUE struct
  SHORT   sIndex;                    // Listbox item index
  HWND    hCtrl;                     // Control handle
  HWND    hList;                     // Listbox handle
  BOOL    bEnableCtrl;               // Enable/disable control boolean value
  MRESULT mRC = (MRESULT) FALSE;     // Function return code

  if (uMsg != WM_INITDLG)
  {
    pDlgHdr = (PDLGHDR) WinQueryWindowULong( hDlg, QWL_USER );
  }

  switch (uMsg)
  {
  case WM_INITDLG:
       pDlgHdr = InitDlgULong( hDlg, mp2 );

//       SetSysMenuFields( hDlg );
       InitializeCustomForms( hDlg, pDlgHdr );
       break;

  case WM_CONTROL:
       switch( SHORT1FROMMP( mp1 ) )
       {
       case PPDLG_NAMEENTRY:
            if (SHORT2FROMMP( mp1 ) == EN_CHANGE)
            {
              EnableDefineFormAddButton( hDlg );
            }
            break;

       case PPDLG_SIZELIST:
            if (SHORT2FROMMP( mp1 ) == LN_SELECT)
            {
              EnableDefineFormAddButton( hDlg );

              /*
              ** Find out if the custom string was selected . . .
              */
              hCtrl = WinWindowFromID( hDlg, PPDLG_SIZELIST);
              sIndex = (SHORT) WinSendMsg( hCtrl, LM_QUERYSELECTION,
                                           MPFROMSHORT( LIT_FIRST ),
                                           (MPARAM) 0 );
              sIndex = (SHORT) WinSendMsg( hCtrl, LM_QUERYITEMHANDLE,
                                           MPFROMSHORT( sIndex ),
                                           (MPARAM) 0 );

              /*
              ** Get the handle of the custom list field
              */
              hList = WinWindowFromID( hDlg, PPDLG_CUSTOMUNITLIST );

              if (sIndex == CUSTOMFORM_HANDLE)
              {
                bEnableCtrl = TRUE;
              }
              else
              {
                bEnableCtrl = FALSE;

                /*
                ** Now blank out the fields
                */
                WinSendDlgItemMsg( hDlg, PPDLG_CUSTOMUNITLIST, LM_DELETEALL,
                                   (MPARAM) 0, (MPARAM) 0 );
                WinSendDlgItemMsg( hDlg, PPDLG_CUSTOMWIDTHENTRY, EM_CLEAR,
                                   (MPARAM) 0, (MPARAM) 0 );
                WinSendDlgItemMsg( hDlg, PPDLG_CUSTOMHEIGHTENTRY, EM_CLEAR,
                                   (MPARAM) 0, (MPARAM) 0 );
              }

              /*
              ** Enable/disable the custom forms controls in the group.
              */
              WinEnableWindow( hList, bEnableCtrl );
              WinEnableWindow( WinWindowFromID( hDlg, PPDLG_CUSTOMGROUP ),
                               bEnableCtrl );
              WinEnableWindow( WinWindowFromID( hDlg, PPDLG_CUSTOMUNITTEXT ),
                               bEnableCtrl );
              WinEnableWindow( WinWindowFromID( hDlg, PPDLG_CUSTOMUNITLIST ),
                               bEnableCtrl );
              WinEnableWindow( WinWindowFromID( hDlg, PPDLG_CUSTOMWIDTHTEXT ),
                               bEnableCtrl );
              WinEnableWindow( WinWindowFromID( hDlg, PPDLG_CUSTOMWIDTHENTRY ),
                               bEnableCtrl );
              WinEnableWindow( WinWindowFromID( hDlg, PPDLG_CUSTOMHEIGHTTEXT ),
                               bEnableCtrl );
              WinEnableWindow( WinWindowFromID( hDlg, PPDLG_CUSTOMHEIGHTENTRY),
                               bEnableCtrl );

              if (sIndex == CUSTOMFORM_HANDLE)
              {
                // Now fill in the fields . . .
                WinSetDlgItemShort(hDlg, PPDLG_CUSTOMWIDTHENTRY, 0,
                                   (BOOL)FALSE );
                WinSetDlgItemShort(hDlg, PPDLG_CUSTOMHEIGHTENTRY, 0,
                                   (BOOL)FALSE );

                // Clear the units list box and fill with the inches,
                // centimeters, and points

                WinSendMsg( hList, LM_DELETEALL, (MPARAM)NULL, (MPARAM)NULL );
                WinSendMsg( hList, LM_INSERTITEM, (MPARAM)LIT_END,
                            (MPARAM)(PSZ) StringTable[IDS_Inches-STRING_BASE] );
                WinSendMsg( hList, LM_INSERTITEM, (MPARAM)LIT_END,
                            (MPARAM)(PSZ) StringTable[IDS_Cms-STRING_BASE] );
                WinSendMsg( hList, LM_INSERTITEM, (MPARAM)LIT_END,
                            (MPARAM)(PSZ) StringTable[IDS_Points-STRING_BASE] );

                // Select INCHES
                WinSendMsg( hList, LM_SELECTITEM, (MPARAM)0, (MPARAM)TRUE );
                WinSetFocus( HWND_DESKTOP, hList );
              }
            }
       }
       break;

  case WM_COMMAND:
       switch( SHORT1FROMMP( mp1 ) )
       {
       case PPDLG_ADD:
            WinQueryWindowText( WinWindowFromID( hDlg, PPDLG_NAMEENTRY ),
                                MAX_PSIZE, (PCH) pUniqString );
            if ((iUniqFormSel = VerifyUniqueForm( hDlg, pDlgHdr,
                                (PSZ) pUniqString )) != -1)
            {
              szDlmCopy( pDlgHdr->stUnqFrmLst[ iUniqFormSel ].aFormName,
                         pUniqString, MAX_PSIZE );
              sIndex = (SHORT) WinSendDlgItemMsg( hDlg, PPDLG_SIZELIST,
                               LM_QUERYSELECTION, MPFROMSHORT( LIT_FIRST ),
                               (MPARAM) 0 );
              pDlgHdr->stUnqFrmLst[ iUniqFormSel ].sPrtHndlMap =
                (SHORT) WinSendDlgItemMsg( hDlg, PPDLG_SIZELIST,
                        LM_QUERYITEMHANDLE, MPFROMSHORT( sIndex ),
                        (MPARAM) 0 );

              WinDismissDlg( hDlg, iUniqFormSel );
            }
            else
            {
              DisplayMessageBox( hDlg, IDM_CantAddForm, 0, MB_OK );
            }
            break;

       case PPDLG_CANCEL:
            WinDismissDlg( hDlg, -1 );
            break;
       }
       break;

  case WM_CONTROLPOINTER:
       mRC = SetContextHelp( hDlg, uMsg, mp1, mp2, NULL, 0,
                             PPDLG_DEFFORMSCSH );
       break;

  default:
       mRC = WinDefDlgProc( hDlg, uMsg, mp1, mp2 );
  }

  return( mRC );
}
/*---------------------------------------------------------------------------*\
* DefineFormsDlgProc End                                                      *
\*---------------------------------------------------------------------------*/





INT VerifyUniqueForm( HWND hDlg, PDLGHDR pPPHdr, PSZ pNewString )
{
  PUI_BLOCK pFormBlock;                         // Pointer to form block
  PUI_BLOCK pTrayBlock;                         // Pointer to tray block
  CHAR      aTestString[ MAX_PSIZE ];           // pNewString set to uppercase
  CHAR      aTempString[ MAX_PSIZE ];           // Temporary string
  PSZ       pName;                              // UI Name
  INT       iIndex;                             // Local loop index
  INT       iUnqFrmNdx;                         // First empty element in strt
  PUNQFRM   pUniqForm = pPPHdr->stUnqFrmLst;    // Ptr to unique form list
  INT       iRC = -1;                           // Function return code

  /*
  ** Get the blocks for the form and tray.
  */
  pFormBlock = QueryBlockFromKeyword( &pPPHdr->pdesPPD->stUIList,
                                      pPPHdr->pItemsBuff, UINAME_PAGESIZE,
                                      NULL );
  pTrayBlock = QueryBlockFromKeyword( &pPPHdr->pdesPPD->stUIList,
                                      pPPHdr->pItemsBuff, UINAME_INPUTSLOT,
                                      NULL );

  /*
  ** Convert the new string to uppercase.
  */
  ps_upper( pNewString, (PSZ) aTestString );

  for (iIndex = 0 ; iIndex < (INT) pFormBlock->usNumOfEntries ; iIndex++)
  {
    pName = (PSZ) (pFormBlock->uiEntry[ iIndex ].ofsOption +
                   pPPHdr->pItemsBuff);

    if (CompareStri( aTestString, pName ) == FALSE)
    {
      goto error_exit;
    }
  }

  /*
  ** @V4.0167773
  ** Apparently, the old driver allowed you to define a unique form name that
  ** was the same as a tray name, and there are customers who take advantage
  ** of that.  Therefore, do not compare the unique name against tray names.
  */
#if 0
///*
//** At this point, the new name is unique.  Now, compare the new name against
//** all printer-defined tray names.  Again, check the translation strings
//** in the comparason.
//*/
//for (iIndex = 0 ; iIndex < (INT) pTrayBlock->usNumOfEntries ; iIndex++)
//{
//  pName = (PSZ) (pTrayBlock->uiEntry[ iIndex ].ofsOption +
//                 pPPHdr->pItemsBuff);
//
//  if (CompareStri( aTestString, pName ) == FALSE)
//  {
//    goto error_exit;
//  }
//}
#endif

  /*
  ** So far, so good.  Now, verify that the name is not "No Forms Selected",
  ** for that is a reserved string for the form list (indicates that no forms
  ** have been selected).
  */
  WinLoadString( WinQueryAnchorBlock( hDlg ), pscript_module,
                 PPF_NOFORMSSELECT, MAX_PSIZE, (PSZ) aTempString );
  if (CompareStri( aTestString, aTempString ) == FALSE)
  {
    goto error_exit;
  }

  /*
  ** At this point in time, the name is unique.  Now, verify the name with
  ** the names in the UNQFRM list structure.  Not only are we to verify that
  ** the name does not match with any other names, but also, to find an empty
  ** element in the list so that the new name can be inserted.
  ** Translation strings don't need to be compared at this time because the
  ** unique form names don't have translation strings.
  */
  iUnqFrmNdx = -1;
  for (iIndex = 0 ; iIndex < NUM_OF_UNQ_FORMS ; iIndex++)
  {
    if ((pUniqForm + iIndex)->aFormName[ 0 ] != 0)
    {
      ps_upper( (pUniqForm + iIndex)->aFormName, aTempString );

      if (szIsEqual( aTempString, aTestString ))
      {
        if ((pUniqForm + iIndex)->sFlag != UNQ_FORM_DELETE)
        {
          iUnqFrmNdx = iIndex;
        }
        else
          break;
      }
    }
    else if (iUnqFrmNdx == -1)
    {
      iUnqFrmNdx = iIndex;
    }
  }
  iRC = iUnqFrmNdx;

error_exit:

  return( iRC );
}





BOOL EnableDefineFormAddButton( HWND hDlg )
{
  CHAR aTempString[ MAX_PSIZE ];
  INT  iStrLen;
  INT  ofsStr = 0;
  HWND hAddBtn = WinWindowFromID( hDlg, PPDLG_ADD );
  BOOL bRC = FALSE;

  /*
  ** Retrieve the text from the entry field.
  */
  iStrLen = (INT) WinQueryWindowText( WinWindowFromID( hDlg, PPDLG_NAMEENTRY ),
                                      MAX_PSIZE, aTempString );

  /*
  ** Verify that that the string returned (if any) is not entirely of spaces.
  ** Continue to increment an offset counter until the first non-space
  ** or NULL is found.
  */
  while (ofsStr < iStrLen && aTempString[ ofsStr ] != 0 &&
         aTempString[ ofsStr ] == ' ')
  {
    ofsStr++;
  }

  /*
  ** If the string is valid, then set the return code to TRUE.
  */
  if (aTempString[ ofsStr ] != 0 && ofsStr < iStrLen)
  {
    bRC = TRUE;
  }

  /*
  ** If the entry field above is valid AND an item in the listbox has been
  ** selected, then all is OK.  Otherwise, the ADD button should not be
  ** enabled.
  */
  if (bRC == TRUE &&
      WinSendDlgItemMsg( hDlg, PPDLG_SIZELIST, LM_QUERYSELECTION,
                         MPFROMSHORT( LIT_FIRST ), (MPARAM) 0 )
       == (MPARAM) LIT_NONE)
  {
    bRC = FALSE;
  }

  WinEnableWindow( hAddBtn, bRC );

  return( bRC );
}





BOOL CompareStri( PSZ pString1, PSZ pString2 )
{
  CHAR  aTempStr[ MAX_PSIZE ];
  PCHAR pTransString;
  BOOL  bRC = TRUE;
//@V3.130814
  CHAR  aTempStr1[ MAX_PSIZE ];

  ps_upper( pString1, aTempStr1 );
//@V3.130814 end

  ps_upper( pString2, aTempStr );
  pTransString = TerminateTranslationString( aTempStr );

//@V3.130814
  if (szIsEqual( aTempStr1, aTempStr ) ||
      (pTransString != NULL && szIsEqual( aTempStr1, pTransString )))
  {
    bRC = FALSE;
  }

  return( bRC );
}





/******************************************************************************
 *
 * FUNCTION NAME = ModeSwitchDlgProc
 *
 * DESCRIPTION
 * Message procedure for the Printer Properties "Options" page.
 *
 * INPUT
 * hDlg - Dialog handle
 * ulMsg - Message ID.
 * mp1 - First message parameter
 * mp2 - Second message parameter
 *
 * OUTPUT
 * None
 *
 * RETURN-NORMAL - Return code from WinDefDlgProc
 * RETURN-ERROR  - Return code from WinDefDlgProc
 *
 *****************************************************************************/
MRESULT EXPENTRY ModeSwitchDlgProc( HWND hDlg, ULONG ulMsg, MPARAM mp1,
                                    MPARAM mp2 )
{
  PDLGHDR pPPHdr;
  MRESULT mRC = (MRESULT) FALSE;

  if (ulMsg != WM_INITDLG)
  {
    pPPHdr = (PDLGHDR) WinQueryWindowULong( hDlg, QWL_USER );
  }

  switch( ulMsg )
  {
  case WM_INITDLG:
       WinSendDlgItemMsg( hDlg, PPO_REPDFVALUE, SPBM_SETLIMITS,
                          MPFROMLONG( 999 ), MPFROMLONG( 0 ) );
       WinSendDlgItemMsg( hDlg, PPO_REPDFVALUE, SPBM_SETTEXTLIMIT,
                          MPFROMLONG( 3 ), (MPARAM) 0 );
       pPPHdr = InitDlgULong( hDlg, mp2 );

       ModeSwitchInitPage( hDlg, pPPHdr );
       break;

  case WMPS_VERIFYSETTINGS:
       mRC = (MRESULT) PMERR_OK;
       break;

  case WMPS_SAVESETTINGS:
       ModeSwitchSaveSettings( hDlg, pPPHdr );
       mRC = (MRESULT) PMERR_OK;
       break;

  case WM_COMMAND:
       switch (SHORT1FROMMP( mp1 ))
       {
       case PSB_UNDO:
            WinSendMsg( WinWindowFromID( hDlg, PPO_REPDFVALUE ),
                        LM_DELETEALL, (MPARAM) 0, (MPARAM) 0 );
            ModeSwitchInitPage( hDlg, pPPHdr );
            break;
       case PSB_DEFAULT:
            ModeSwitchDefaultControls( hDlg, pPPHdr );
            break;

       case PPO_PRINTFONTCAP:
            PrintFontMem( pPPHdr->pCNFData );
            break;

       case DID_CANCEL:
            WinSendMsg( pPPHdr->hDlg, WM_COMMAND, (MPARAM) PSB_CANCEL, (MPARAM) 0 );
       }
       break;

  case WM_CONTROLPOINTER:
       mRC = SetContextHelp( hDlg, ulMsg, mp1, mp2, NULL, 0, 0 );
       break;

  default:
       mRC = WinDefDlgProc( hDlg, ulMsg, mp1, mp2 );
  }

  return( mRC );
}
/*---------------------------------------------------------------------------*\
* ModeSwitchDlgProc End                                                       *
\*---------------------------------------------------------------------------*/





/******************************************************************************
 *
 * FUNCTION NAME = ModeSwitchInitPage
 *
 * DESCRIPTION
 * Initializes the data for the Printer Properties "Options" page.
 *
 * INPUT
 * hDlg - Dialog handle
 * pPPHdr - Printer Properties header structure.
 *
 * OUTPUT
 * None
 *
 * RETURN-NORMAL - None
 * RETURN-ERROR  - None
 *
 *****************************************************************************/
VOID ModeSwitchInitPage( HWND hDlg, PDLGHDR pPPHdr )
{
  HWND  hModeSwitch;
  HWND  hModeSwitchText;
  ULONG ulCheckFlag = 0;         // Flag to set the checkbox

  WinSendDlgItemMsg( hDlg, PPO_REPDFVALUE, SPBM_SETCURRENTVALUE,
                     MPFROMLONG( pPPHdr->pCNFData->lFontCount ),
                     (MPARAM) 0 );

  hModeSwitch = WinWindowFromID( hDlg, PPO_AUTOSWITCHCHECK );
  hModeSwitchText = WinWindowFromID( hDlg, PPO_AUTOMSGROUP );

  if (pPPHdr->pdesPPD->desItems.ofsInitString != -1)/* If init string exists  */
  {
    WinEnableWindow( hModeSwitchText, TRUE );/* Enable Auto Mode Group        */
    WinEnableWindow( hModeSwitch, TRUE );/* Enable Auto Mode Switch           */

    if (pPPHdr->pCNFData->uPrinterPropFlags & MODESWITCH)
    {
      ulCheckFlag = 1;
    }
  }
  else
  {
    WinEnableWindow( hModeSwitchText, FALSE );/* Disable group                */
    WinEnableWindow( hModeSwitch, FALSE );/* Disable button                   */
    pPPHdr->pCNFData->uPrinterPropFlags &= ~MODESWITCH;
  }

  WinSendDlgItemMsg( hDlg, PPO_AUTOSWITCHCHECK, BM_SETCHECK,
                     MPFROMLONG( ulCheckFlag ), (MPARAM) 0L);

  if (pPPHdr->usFlags & DISP_SEL_FORMS)
  {
    ulCheckFlag = 1;
  }
  else
  {
    ulCheckFlag = 0;
  }

  WinSendDlgItemMsg( hDlg, PPO_DISPMAPPEDFORMS, BM_SETCHECK,
                     MPFROMLONG( ulCheckFlag ), (MPARAM) 0 );

  if (pPPHdr->usFlags & OVERRIDE_MM)
  {
    ulCheckFlag = 1;
  }
  else
  {
    ulCheckFlag = 0;
  }

  WinSendDlgItemMsg( hDlg, PPO_OVERRIDEMISMATCH, BM_SETCHECK,
                     MPFROMLONG( ulCheckFlag ), (MPARAM) 0 );
}
/*---------------------------------------------------------------------------*\
* ModeSwitchInitPage End                                                      *
\*---------------------------------------------------------------------------*/





/******************************************************************************
 *
 * FUNCTION NAME = ModeSwitchSaveSettings
 *
 * DESCRIPTION
 * Responsible for saving the data for the Printer Properties "Options" page.
 *
 * INPUT
 * hDlg - Dialog handle
 * pPPHdr - Printer Properties header structure.
 *
 * OUTPUT
 * None
 *
 * RETURN-NORMAL - None
 * RETURN-ERROR  - None
 *
 *****************************************************************************/
VOID ModeSwitchSaveSettings( HWND hDlg, PDLGHDR pPPHdr )
{
  UINT uiCheckState;     // Queries the current state of the checkbox
  BOOL fDispFormsState;

  uiCheckState = (UINT) WinSendDlgItemMsg( hDlg, PPO_AUTOSWITCHCHECK,
                                           BM_QUERYCHECK, (MPARAM) 0,
                                           (MPARAM) 0 );

  if (uiCheckState == 1)
  {
    pPPHdr->pCNFData->uPrinterPropFlags |= MODESWITCH;
  }
  else
  {
    pPPHdr->pCNFData->uPrinterPropFlags &= ~MODESWITCH;
  }

  /*
  ** Save the Modeswitch setting.
  */
  SavePrtPropOptionsINI( (PSZ) pPPHdr->pCNFData->szKeyApp,
                         INISUBKEY_MODESWITCH,
                         pPPHdr->pCNFData->uPrinterPropFlags );

  WinSendDlgItemMsg( hDlg, PPO_REPDFVALUE, SPBM_QUERYVALUE,
                     MPFROMP( &pPPHdr->pCNFData->lFontCount ),
                     MPFROM2SHORT( 0, SPBQ_ALWAYSUPDATE ) );

  if (WinSendDlgItemMsg( hDlg, PPO_DISPMAPPEDFORMS, BM_QUERYCHECK,
                         (MPARAM) 0, (MPARAM) 0 ) == (MRESULT) 1)
  {
    fDispFormsState = TRUE;
  }
  else
  {
    fDispFormsState = FALSE;
  }

  SavePrtPropOptionsINI( (PSZ) pPPHdr->pCNFData->szKeyApp,
                         INISUBKEY_DISPFORMS, fDispFormsState );

  /*
  ** Override forms mistmatch.
  */
  if (WinSendDlgItemMsg( hDlg, PPO_OVERRIDEMISMATCH, BM_QUERYCHECK,
                         (MPARAM) 0, (MPARAM) 0 ) == (MRESULT) 1)
  {
    fDispFormsState = TRUE;
  }
  else
  {
    fDispFormsState = FALSE;
  }

  SavePrtPropOptionsINI( (PSZ) pPPHdr->pCNFData->szKeyApp,
                         INISUBKEY_OVERRIDEMM, fDispFormsState );
}
/*---------------------------------------------------------------------------*\
* ModeSwitchSaveSettings End                                                  *
\*---------------------------------------------------------------------------*/





/******************************************************************************
 *
 * FUNCTION NAME = VerifyTrayFormMapping
 *
 * DESCRIPTION
 * Verifies that at least one tray in the "Trays" listbox is not set to
 * "No Forms Selected" - that at least one tray maps to a valid form.
 *
 * The handle to each form maps to the zero-based offset of the form found in
 * the PPD.  If the tray maps to a custom form, then that value is negative.
 * The handle NOFORMS_HANDLE is reserved to indicate that the tray does not
 * map to any form.
 *
 * Each tray in the listbox is queried.  If the handle to that tray is not
 * NOFORMS_HANDLE, then the function exits with TRUE.  If the handle for all
 * the trays is NOFORMS_HANDLE, then the function returns FALSE.
 *
 * INPUT
 * hDlg - Dialog handle
 *
 * OUTPUT
 * None
 *
 * RETURN-NORMAL - TRUE
 * RETURN-ERROR  - FALSE (default)
 *
 *****************************************************************************/
BOOL VerifyTrayFormMapping( HWND hDlg )
{
  UINT uiNumOfTrays;              // Number of trays in the listbox
  UINT uiLoop;                    // Local loop counter
  HWND hTray = WinWindowFromID( hDlg, PPF_TRAYLIST );  // Tray LB handle
  BOOL bRC = FALSE;               // Function return code

  /*
  ** Query the number of trays in the listbox.
  */
  uiNumOfTrays = (UINT) WinSendMsg( hTray, LM_QUERYITEMCOUNT, (MPARAM) 0,
                                    (MPARAM) 0 );

  for (uiLoop = 0 ; uiLoop < uiNumOfTrays ; uiLoop++)
  {
    /*
    ** Query the current tray handle.  If it is not NOFORMS_HANDLE, then
    ** break out of the loop, and return TRUE.
    */
    if ((SHORT) WinSendMsg( hTray, LM_QUERYITEMHANDLE, MPFROMSHORT( uiLoop ),
                            (MPARAM) 0 ) != (SHORT) NOFORMS_HANDLE)
    {
      bRC = TRUE;
      break;
    }
  }

  return( bRC );
}
/*---------------------------------------------------------------------------*\
* VerifyTrayFormMapping End                                                   *
\*---------------------------------------------------------------------------*/





/******************************************************************************
 *
 * FUNCTION NAME = InitializeCustomForms
 *
 * DESCRIPTION
 * Initializes the data needed to display the "Display Forms" dialog box.
 * Also, retrieves the form name selected and mapped form handle from the
 * "Define Forms" dialog box and inserts the string and handle into the FORMS
 * listbox.
 *
 * This function also displays the "Define Forms" dialog box.
 *
 * The FORMS listbox is queried.  Any custom forms already defined is copied
 * to a Custom Forms data structure (CFDEF).  This includes the "No Forms
 * Selected" string.  This prvents the user from defining another form with
 * the same name as the form names already defined.
 *
 * The handle to the newly defined is the negative value, minus 1, of the
 * form handle which it is mapped.  For example, if "Test Form" is, mapped
 * to "Letter", and "Letter has a handle of 0, then the handle for "Test Form"
 * is -1.  If "Test Form" is mapped to "Legal" and "Legal has a handle of 2,
 * then Test Form's handle is -3.  The reason for this is to identify custom
 * forms from printer-defined forms.  All printer-defined forms are zero or
 * greater.  This also provides a way to identify the form which this maps to.
 *
 * INPUT
 * hDlg - Dialog handle
 * pPPHdr - Printer Properties header structure.
 *
 * OUTPUT
 * None
 *
 * RETURN-NORMAL - None
 * RETURN-ERROR  - None
 *
 *****************************************************************************/
VOID InitializeCustomForms( HWND hDlg, PDLGHDR pPPHdr )
{
//  PSZ       pDefaultPage;                               // Default page string
  CHAR      aString[ MAX_PSIZE ];                       // Temp buffer
  SHORT     sIndex;                                     // Index value
  PUI_BLOCK pFormBlock;
  HWND      hListBox = WinWindowFromID( hDlg, PPDLG_SIZELIST );

  /*
  ** Fill the listbox with the printer-defined forms.  Do not include
  ** user-defined forms.
  */
  pFormBlock = QueryBlockFromKeyword( &pPPHdr->pdesPPD->stUIList,
                                      pPPHdr->pItemsBuff,
                                      UINAME_PAGESIZE, NULL );

  ListUIItems( hListBox, pPPHdr, pFormBlock, TRUE, IGNORE_CONSTRAINTS,
               BLOCK_SEARCH_ALL, DO_NOT_OVERWRITE );

  /*
  ** If variable paper sizes are supported, insert "Custom" at the end of
  ** the listbox.
  */
// remark out this snippet. in case we make custom forms work, this //@DISABLE_NF
// will have to be uncommented again.                               //@DISABLE_NF
/*  if (pPPHdr->pdesPPD->desPage.fIsVariablePaper == TRUE)
**  {
**    WinLoadString( WinQueryAnchorBlock( hDlg ), pscript_module,
**                   IDS_Custom, MAX_PSIZE, (PSZ) aString );
**    sIndex = (SHORT) WinSendMsg( hListBox, LM_INSERTITEM,
**                                 MPFROMSHORT( LIT_END ), MPFROMP( aString ) );
**    WinSendMsg( hListBox, LM_SETITEMHANDLE, MPFROMSHORT( sIndex ),
**                MPFROMLONG( CUSTOMFORM_HANDLE ) );
**  }
*/
//@DISABLE_NF

  /*
  ** Set the maximum text limit in the entry field to MAX_PSIZE - 1 (subtract
  ** 1 to reserve space for '\0').
  */
  WinSendDlgItemMsg( hDlg, PPDLG_NAMEENTRY, EM_SETTEXTLIMIT,
                     MPFROMSHORT( MAX_PSIZE - 1 ), (MPARAM) 0 );
}
/*---------------------------------------------------------------------------*\
* InitializeCustomForms End                                                   *
\*---------------------------------------------------------------------------*/


/*****************************************************************************
 *
 * FUNCTION NAME = ps_upper
 *
 * DESCRIPTION    = changes a string to uppercase
 *
 * INPUT
 *
 * OUTPUT        = none
 *
 * RETURN-NORMAL = NONE
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/
INT ps_upper ( PSZ szInString, PSZ szOutString )
{
  INT         iRC;
  INT         iLength;
  COUNTRYCODE Country;

  Country.codepage = 0;
  Country.country = 0;

  iLength = strlen( szInString );
  memset( szOutString, 0, iLength );
  strcpy( szOutString, szInString );

  iRC = DosMapCase( iLength, &Country, szOutString );

  return( iRC );
}





BOOL QueryAddFormButtonStatus( PDLGHDR pPPHdr, HWND hFormPage )
{
  INT     iIndex;
  PUNQFRM pUniqueForm = pPPHdr->stUnqFrmLst;
  HWND    hButton = WinWindowFromID( hFormPage, PPF_DEFINEFORM );
  BOOL    bRC = FALSE;

  if (hButton != (HWND) 0)
  {

    for (iIndex = 0 ; iIndex < NUM_OF_UNQ_FORMS ; iIndex++)
    {
      if ((pUniqueForm + iIndex)->aFormName[ 0 ] == 0)
      {
        bRC = TRUE;
        break;
      }
    }

    WinEnableWindow( hButton, bRC );
  }
  else
  {
    GplErrSetWarning( (USHORT) -1 );
  }

  return( bRC );
}


/******************************************************************************
 *
 * FUNCTION NAME = FormPPPageDefaultControls
 *
 * DESCRIPTION
 * Defaults the controls for the "Forms" page for the Printer Properties.
 *
 * INPUT
 * hDlg - Dialog handle.
 * pPPHdr - Printer Properties header
 *
 * OUTPUT
 * None
 *
 * RETURN-NORMAL - None
 * RETURN-ERROR  - None
 *
 *****************************************************************************/
VOID FormPPPageDefaultControls( HWND hDlg, PDLGHDR pPPHdr )
{
  PUI_BLOCK  pTrayBlock;                    // Pointer to INPUTSLOT block
  PUI_BLOCK  pFormBlock;                    // Pointer to PAGESIZE block
  LONG       lLoop;
  PSZ        pDefForm;
  PTMENTRY   pTMEntry = (PTMENTRY) pPPHdr->pPtr;
  HWND       hTrayLB = WinWindowFromID( hDlg, PPF_TRAYLIST );
  PDESPPD    pdesPPD  = pPPHdr->pdesPPD;    // PPD data structure

  /*
  ** Query the default form and tray block.
  */
  pTrayBlock = QueryBlockFromKeyword( &pPPHdr->pdesPPD->stUIList,
                                      pPPHdr->pItemsBuff,
                                      UINAME_INPUTSLOT, NULL );
  pFormBlock = QueryBlockFromKeyword( &pPPHdr->pdesPPD->stUIList,
                                      pPPHdr->pItemsBuff,
                                      UINAME_PAGESIZE, NULL );

  /*
  ** Reset all tray/form selections.  Set all mappings to NOFORMS_HANDLE so
  ** "No Forms Selected" is displayed when any tray is selected.
  */
  for (lLoop = 0 ; lLoop < pTrayBlock->usNumOfEntries ; lLoop++)
  {
    (pTMEntry + lLoop)->lFormID = NOFORMS_HANDLE;
  }

  /*
  ** @V4.0168335
  ** Query the default form.  Instead of getting it from the block default
  ** value, call GetDefaultPageSize() because for some countries, A4 is the
  ** default.
  */
  pDefForm = GetDefaultPageSize( pdesPPD, pdesPPD->pPSStringBuff );
  if (QueryEntryFromOption( pdesPPD->pPSStringBuff, pFormBlock,
                            (PBYTE) pDefForm, (PINT) &lLoop ) == NULL)
  {
    lLoop = 0;
  }

  /*
  ** lFormID in pTMEntry contains the mapped form for the current tray.  Since
  ** we are setting the default values, set the lFormID for the default tray
  ** to the default form.
  */
  pTMEntry->lFormID = lLoop;

  /*
  ** UCM_SETDEFAULT sets the current control to the default entry.  Do this
  ** for the tray list.
  */
  WinSendMsg( hTrayLB, UCM_SETDEFAULT, (MPARAM) 0, (MPARAM) 0 );

  /*
  ** The default tray is now selected.  Now, send a UCM_LISTITEMS message to
  ** the form control.  This will force the control to re-display the default
  ** based on the value set in the 'pTMEntry->lFormID =' above.  This  will
  ** of course be the default form.
  ** We do not want to send a "UCM_SETDEFAULT" message to the form because
  ** the current form setting is based entirely on the current tray setting.
  */
  WinSendDlgItemMsg( hDlg, PPF_FORMLIST, UCM_LISTITEMS, (MPARAM) pTrayBlock,
                     (MPARAM) pTrayBlock->usDefaultEntry );

  QueryAddFormButtonStatus( pPPHdr, hDlg); // we should call this instead of plainly
                                           // enabling that button. //@DISABLE_NF
  WinEnableWindow( WinWindowFromID( hDlg, PPF_DELETEFORM ), FALSE );
}
/*---------------------------------------------------------------------------*\
* FormPPPageDefaultControls End                                               *
\*---------------------------------------------------------------------------*/





/******************************************************************************
 *
 * FUNCTION NAME = ModeSwitchDefaultControls
 *
 * DESCRIPTION
 * Defaults the data for the Printer Properties "Options" page.
 *
 * INPUT
 * hDlg - Dialog handle
 * pPPHdr - Printer Properties header structure.
 *
 * OUTPUT
 * None
 *
 * RETURN-NORMAL - None
 * RETURN-ERROR  - None
 *
 *****************************************************************************/
VOID ModeSwitchDefaultControls( HWND hDlg, PDLGHDR pPPHdr )
{
  ULONG ulCheckFlag;         // Flag to set the checkbox
  HWND  hModeSwitch = WinWindowFromID( hDlg, PPO_AUTOSWITCHCHECK );
  HWND  hModeSwitchText = WinWindowFromID( hDlg, PPO_AUTOMSGROUP );

  pPPHdr->pCNFData->lFontCount = DefaultFontCount( pPPHdr->pdesPPD );

  WinSendDlgItemMsg( hDlg, PPO_REPDFVALUE, SPBM_SETCURRENTVALUE,
                     MPFROMLONG( pPPHdr->pCNFData->lFontCount ),
                     (MPARAM) 0 );

  if (pPPHdr->pdesPPD->desItems.ofsInitString != -1)/* If init string exists  */
  {
    WinSendDlgItemMsg( hDlg, PPO_AUTOSWITCHCHECK, BM_SETCHECK,
                       MPFROMLONG( TRUE ), (MPARAM) 0L);
  }

  WinSendDlgItemMsg( hDlg, PPO_DISPMAPPEDFORMS, BM_SETCHECK,
                     MPFROMSHORT( FALSE ), (MPARAM) 0 );

  WinSendDlgItemMsg( hDlg, PPO_OVERRIDEMISMATCH, BM_SETCHECK,    
                     MPFROMSHORT( FALSE ), (MPARAM) 0 );         
}
/*---------------------------------------------------------------------------*\
* ModeSwitchDefaultControls End                                               *
\*---------------------------------------------------------------------------*/





LONG ListPrtPropFormEntries( HWND      hCtrl,
                             PDLGHDR   pDlgHdr,
                             PUI_BLOCK pFormBlock,
                             PUI_BLOCK pTrayBlock,
                             LONG      lTraySelection
                           )
{
  LONG     lNumInserted;
  LONG     lLoop;
  INT      ofsList;
  PSZ      pDefForm;
  ULONG    aulStrList[ NUM_OF_UNQ_FORMS ];
  LONG     alHndlList[ NUM_OF_UNQ_FORMS ];
  PUNQFRM  pUniqueForm = pDlgHdr->stUnqFrmLst;
  PTMENTRY pTMEntry = ((PTMENTRY) pDlgHdr->pPtr) + lTraySelection;

  /*
  ** pTrayBlock will be set to -1 if no trays exist.  This is needed because
  ** this function will not be called if pTrayBlock is NULL.  Now that we
  ** are in the function, set pTrayBlock to NULL (its no longer needed).
  */
  if (pTrayBlock == (PUI_BLOCK) -1)
  {
    pTrayBlock = NULL;
  }

#if IPMD_DISPLAY_UI
  if (pTrayBlock != NULL)
  {
    PSZ pTrayName = (PSZ) (pDlgHdr->pItemsBuff + pTrayBlock->ofsUIName);
    PSZ pTrayEntry = (PSZ) (pDlgHdr->pItemsBuff +
                           pTrayBlock->uiEntry[ lTraySelection ].ofsOption);
  }
#endif

  // @V4.0173031
  if (pTMEntry != NULL)
  {
    lLoop = pTMEntry->lFormID;
  }
  else
  {
    lLoop = DO_NOT_OVERWRITE;
  }

  /*
  ** Insert the list of predefined forms.  The only constraints that apply
  ** are trays.
  */
  lNumInserted = ListUIItems( hCtrl, pDlgHdr, pFormBlock, FALSE, pTrayBlock,
                              BLOCK_SEARCH_AND, lLoop );

  /*
  ** This loop will insert the custom trays one-by-one, providing there are no
  ** constraints against the currently selected tray.
  */
  ofsList = 0;
  for (lLoop = 0 ; lLoop < NUM_OF_UNQ_FORMS ; lLoop++)
  {
    /*
    ** Does the unique form exist?
    */
    if (pUniqueForm->aFormName[ 0 ] != 0 &&
        !(pUniqueForm->sFlag & UNQ_FORM_DELETE))
    {
      /*
      ** Include the user-defined form for one of two conditions:
      ** - The user-defined form was selected for the currently displayed
      **   tray.
      ** - The real form name does not constrain with the current tray.
      **
      ** Each unique form corresponds to a real form.  Compare the
      ** cooresponding real form to the highlighted tray.  Do not display
      ** the form if a constraint exists.
      */
      if (lLoop == (LONG) CONV_UNQID_TO_LBID( pTMEntry->lFormID ) ||
          QueryCnstListBlock ( pDlgHdr, pFormBlock, pUniqueForm->sPrtHndlMap,
                               pTrayBlock,
                               CONVERT_OFS_TO_UISEL( lTraySelection ) )
          == FALSE)
      {
        aulStrList[ ofsList ]   = (ULONG) pUniqueForm->aFormName;
        alHndlList[ ofsList++ ] = CONV_UNQID_TO_LBID( lLoop );
      }
    }

    pUniqueForm++;
  }

  /*
  ** Display the list of unique forms if any exist.
  */
  if (ofsList > 0)
  {
    GplPageInsertListItems( hCtrl, 0, aulStrList, GDPF_STRTYPEPTR,
                            alHndlList, (LONG) ofsList, LIT_END,
                            pscript_module );
  }

  /*
  ** If a tray is not provided, then highlight the default form.
  */
  if (pTrayBlock != NULL)
  {
    /*
    ** Insert "No Forms Selected" in the top of the listbox.  This is
    ** necessary only if trays exist for the device.  If no trays exist,
    ** then use 'Auto Tray', which therefore, means that 'No Forms Selected'
    ** is not necessary.
    */
    aulStrList[ 0 ] = PPF_NOFORMSSELECT;
    alHndlList[ 0 ] = NOFORMS_HANDLE;
    GplPageInsertListItems( hCtrl, 0, aulStrList, GDPF_STRTYPEID,
                            alHndlList, 1, 0, pscript_module );

    lLoop = (((PTMENTRY) pDlgHdr->pPtr) + lTraySelection)->lFormID;
  }
  else        // Tray block does not exists - highlight default form.
  {
    pDefForm = GetDefaultPageSize( pDlgHdr->pdesPPD, pDlgHdr->pItemsBuff );

    if (QueryEntryFromOption( pDlgHdr->pItemsBuff, pFormBlock, pDefForm,
                              (PINT) &lLoop ) == NULL)
    {
      lLoop = (LONG) pFormBlock->usDefaultEntry;
    }
  }

  GplPageSelectListItem( hCtrl, 0, lLoop, GDPI_HANDLE );

  return( lNumInserted );
}





VOID UpdatePrtPropFormSelection( HWND    hFormCtrl,
                                 PDLGHDR pDlgHdr,
                                 ULONG   ulCtrlID
                               )
{
  HWND hParent;
  LONG lHandle;

  /*
  ** Before updating the current selection, set the UIC_MSG_RECURSE flag.
  ** This way, constraints messages are not sent to the other controls.
  ** No constraints are applied for form definition.
  */
  pDlgHdr->usFlags |= UIC_NO_UPDATE;
  lHandle = UpdateSelection( hFormCtrl, pDlgHdr, ulCtrlID, FALSE );
  pDlgHdr->usFlags &= ~UIC_NO_UPDATE;

  UpdateTrayHandle( hFormCtrl, pDlgHdr );

  if (IS_UNQ_FORMID( lHandle ))
  {
    lHandle = TRUE;
  }
  else
  {
    lHandle = FALSE;
  }

  hParent = WinQueryWindow( hFormCtrl, QW_PARENT );
  WinEnableWindow( WinWindowFromID( hParent, PPF_DELETEFORM ),
                   (BOOL) lHandle );
}





VOID UpdateTrayHandle( HWND    hForm,
                       PDLGHDR pDlgHdr
                     )
{
  HWND     hTray;
  LONG     lTraySelected;
  LONG     lFormSelected;
  LONG     lFormIndex;
  PTMENTRY pTMEntry = (PTMENTRY) pDlgHdr->pPtr;

  if (pTMEntry != NULL)
  {
    /*
    ** Query the tray's handle.
    */
    hTray = WinWindowFromID( WinQueryWindow( hForm, QW_PARENT ),
                             PPF_TRAYLIST );
    GplPageQueryLBSelection( hTray, 0, &lTraySelected, NULL );

    /*
    ** Query the currently selected form's handle.
    */
    GplPageQueryLBSelection( hForm, 0, &lFormSelected,
                              (PSHORT) &lFormIndex );

    (pTMEntry + lTraySelected)->lFormID = (LONG) lFormSelected;
  }
}

//
//
//
MRESULT
APIENTRY
FontMgrCallbackProc(
	PVOID	pCB,
	PVOID	pInst
	)
	{
	return NULL;
	}
