/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = NOINSTAL.C
 *
 * DESCRIPTIVE NAME = Stubs for routines not supported by this
 *                    postscript driver.
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS :            prdb_DeviceCreateBitmap
 *                        prdb_DeviceDeleteBitmap
 *                        prdb_DeviceSelectBitmap
 *                        prdb_GetBitmapBits
 *                        prdb_SetBitmapBits
 *                        prdb_ScrollRect
 *                        prdb_GetPel
 *                        prdb_SaveScreenBits
 *                        prdb_RestoreScreenBits
 *                        prdg_Death
 *                        prdg_ErasePS
 *                        prdg_Resurrection
 *                        prdg_LockDevice
 *                        prdg_UnLockDevice
 *                        prdc_RealizeColorTable
 *                        prdc_UnrealizeColorTable
 *                        prdl_DrawConicsInPath
 *                        prdl_DrawLinesInPath
 *                        prdd_CharRect
 *                        prdd_CharStr
 *                        prdd_DeviceInvalidateVisRegionc
 *                        prdd_DeviceSetAVIOFont
 *                        prdd_DeviceSetCursor
 *                        prdd_GetPickWindow
 *                        prdd_GetStyleRatio
 *                        prdd_SetColorCursor
 *                        prdd_SetPickWindow
 *                        prdd_UpdateCursor
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#pragma pack(1) 
#define  INCL_GPIBITMAPS
/*#define INCL_GRE_COLORTABLE      */   /*                          */
/*#define INCL_GRE_DEVICE          */   /* no need, we are defining */
/*#define INCL_GRE_LINES           */   /* INCL_GREALL in prdinclt.h*/
/*#define INCL_GRE_SCANS           */   /*                          */
#include "inc\prdinclt.h"
#include "inc\utl.h"
#include "inc\fillet.h"               /*     included for drawlinesinpath*/
#include "inc\pspagtun.h"             /* V2.174057  Page Tuning */
#define  INCL_GENPLIB_ERROR
#include <genplib.h>

#define OD_MEMORY 8L

extern PDDC EnterDriver(PDDC);
extern VOID ExitDriver(PDDC);

typedef struct _tagSTYLE_RATIO
{
    UCHAR   rx;
    UCHAR   ry;
} STYLE_RATIO,  *PRATIO;


/***************************************************************************
 *
 * FUNCTION NAME = prdb_DeviceCreateBitmap
 *
 * DESCRIPTION   = This call should be passed on to the display driver, and
 *                 should never get this far in the postscript driver.
 *
 * INPUT         =  HDC         hdc
 *                  PB          pbInfoHdr
 *                  ULONG       ulUsage
 *                  PB          pbBits
 *                  PB          pbInit
 *                  PDDC        pddc
 *                  ULONG       ifn
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

HBITMAP prdb_DeviceCreateBitmap (HDC hdc,PB pbInfoHdr,ULONG ulUsage,
                                 PB pbBits,PB pbInit,PDDC pddc, ULONG ulFunN)
{
  ULONG ulRet = 0;

  EnterDriver(pddc);

  #if      DEBUG
    LogCall ((PSZ)"DeviceCreateBitmap(%lp, %lp, %08lx, %lp, %lp, %lp, %lp)",
             ((PB)&hdc)+sizeof(hdc));
  #endif  /* DEBUG                            */

  /*
  ** Create the bitmap in the shadow memory DC in Display.
  */
  if (!(ulRet = InnerGreCreateBitmap (pddc->hdcMemory, pbInfoHdr, ulUsage,
                                      pbBits, pbInit, ulFunN)))
  {
    RIP ("Prdb_DeviceCreateBitmap: GreCreateBitmap failed") ;
  }

  /*
  ** this call should be passed on to the display driver, and should
  ** not ever get this far in the driver.
  */
  /*
  ** GplErrSetError((LONG)PMERR_DEV_FUNC_NOT_INSTALLED);
  */

  ExitDriver (pddc);

  return (ulRet);
}


/***************************************************************************
 *
 * FUNCTION NAME = prdb_DeviceDeleteBitmap
 *
 * DESCRIPTION   = This call should be passed on to the display driver, and
 *                 should never get this far in the postscript driver.
 *
 * INPUT         = ULONG       hdc
 *                 HBITMAP     hbm
 *                 ULONG   *lpHandle
 *                 ULONG       Usage
 *                 PDDC        pddc
 *                 ULONG       ifn
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

ULONG prdb_DeviceDeleteBitmap (ULONG hdc, HBITMAP hbm,
                               PULONG pReturns,
                               ULONG flOptions, PDDC pddc, ULONG ulFunN)
{
  ULONG ulReturn = FALSE ;

  /*
  ** GRE will not pass a VALID HDC and PDDC.
  ** EnterDriver(pddc);
  */

  #if      DEBUG
    LogCall ((PSZ)"DeviceDeleteBitmap(%08lx, %08lx, %lp, %08lx, %lp, %ld)",
             ((PB)hdc)+sizeof(hdc));
  #endif  /* DEBUG                            */


  if (flOptions & CBM_INIT)
  {
     BITMAPINFOHEADER bmi;
     PBITMAPINFOHEADER2 pInfo ;
     ULONG ulSize ;
     ULONG pBits ;
     HDC hdcMemory ;

     /*
     ** Determine the bitmap format
     */
     bmi.cbFix = sizeof(BITMAPINFOHEADER) ;
     if (!GreGetBitmapParameters (hbm, &bmi))
     {
        return (FALSE) ;
     }

      if (bmi.cBitCount == 24)
     {
         ulSize = 0;
     }
     else
     {
         ulSize = sizeof(RGB2) * (1 << bmi.cBitCount) ;
     }
     /**************************************************************/
     /* Allocate memory for bitmap info table. return error if     */
     /* allocation fails.                                          */
     /**************************************************************/
     /**************************************************************/
     /* we don't want to setup a full BITMAPINFO2 structure        */
     /* all we want is the first 5 fields                          */
     /*      ULONG    cbFix                                        */
     /*      ULONG    cx,cy                                        */
     /*      USHORT   cPlanes,cBitCount                            */
     /* This comes to a total of 16 bytes                          */
     /**************************************************************/
     #define BITMAPINFOUSEDPART 16
     if (SSAllocMem (&pInfo, BITMAPINFOUSEDPART + ulSize, 0L))
        return (FALSE) ;

     /**************************************************************/
     /* Fill in the parameters in BITMAPINFO structure             */
     /**************************************************************/
     pInfo->cbFix     = BITMAPINFOUSEDPART ;
     pInfo->cx        = bmi.cx ;
     pInfo->cy        = bmi.cy ;
     pInfo->cPlanes   = bmi.cPlanes ;
     pInfo->cBitCount = bmi.cBitCount ;

     /**************************************************************/
     /* Calculate memory required for the bits and allocate it.    */
     /**************************************************************/
     ulSize = (((bmi.cx * bmi.cBitCount + 31) >> 5) << 2) * bmi.cy ;
     if (SSAllocMem (&pBits, ulSize, 0L))
     {
        SSFreeMem (pInfo) ;
        return (FALSE) ;
     }


     // Open a memory DC in the display and select the bitmap into it.
     if ((hdcMemory = GreOpenDC( (HDC) NULL, OD_MEMORY,"*", 0L,
                                    (PDEVOPENDATA) NULL)))
     {

       // Select the bitmap.
       if (GreSelectBitmap (hdcMemory, hbm) != HBM_ERROR)
       {

         // Get the bits from the bitmap.
         if (GreGetBitmapBits (hdcMemory, hbm, 0, bmi.cy, pBits, pInfo) ==
                                                                    bmi.cy)

         {
            ulReturn = TRUE ;

         }

         GreSelectBitmap (hdcMemory, (HBITMAP) NULL) ;
       }


       GreCloseDC (hdcMemory) ;
     }


     if (ulReturn && !InnerGreDeleteBitmap(hbm, ulFunN))
     {
        SSFreeMem ((PVOID)pInfo) ;
        SSFreeMem ((PVOID)pBits) ;
        return (FALSE) ;
     }

     /**************************************************************/
     /* Set the returned BITMAPINFO structure pointer              */
     /**************************************************************/
     ((PDELETERETURN)pReturns)->pInfo = (ULONG)pInfo ;
     ((PDELETERETURN)pReturns)->pBits = (ULONG)pBits ;

     // GRE will free the pInfo and pBits !!!

     return (TRUE) ;

  }
  else
  if (!(ulReturn = InnerGreDeleteBitmap(hbm, ulFunN)))
  {
     RIP ("Prdb_DeviceDeleteBitmap: GreDeleteBitmap failed") ;
  }

  /*** this call should be passed on to the display driver, and should
  ** not ever get this far in the driver.
  */
  /*
  ** GplErrSetError((LONG)PMERR_DEV_FUNC_NOT_INSTALLED);
  */

  /*
  ** ExitDriver(pddc);
  */

  return (ulReturn);
}


/***************************************************************************
 *
 * FUNCTION NAME = prdb_DeviceSelectBitmap
 *
 * DESCRIPTION   = This call should be passed on to the display driver, and
 *                 should never get this far in the postscript driver.
 *
 * INPUT         = HDC         hdc
 *                 ULONG       hbm
 *                 PDDC        pddc
 *                 ULONG       ifn
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

ULONG prdb_DeviceSelectBitmap (HDC hdc, ULONG hbm, PDDC pddc, ULONG ulFunN)
{
  ULONG ulRet;

  EnterDriver(pddc);

  #if      DEBUG
    LogCall ((PSZ)"DeviceSelectBitmap(%08lx, %08lx, %lp, %ld)",
             ((PB)hdc)+sizeof(hdc));
  #endif  /* DEBUG                            */

  ulRet = InnerGreSelectBitmap (pddc->hdcMemory, hbm, ulFunN);

  if (ulRet == HBM_ERROR)
  {
    RIP ("Prdb_DeviceSelectBitmap: GreSelectBitmap failed");
    ulRet = FALSE;
  }
  else
  {
    ulRet = TRUE;
  }

  /*
  ** this call should be passed on to the display driver, and should
  ** not ever get this far in the driver.
  */
  /*
  **GplErrSetError((LONG)PMERR_DEV_FUNC_NOT_INSTALLED);
  */

  ExitDriver (pddc);

  return (ulRet);
}


/***************************************************************************
 *
 * FUNCTION NAME = prdb_GetBitmapBits
 *
 * DESCRIPTION   = This call should be passed on to the display driver, and
 *                 should never get this far in the postscript driver.
 *
 * INPUT         = HDC         hdc
 *                 HBITMAP     hbm
 *                 ULONG       iyOrg
 *                 ULONG       nyExt
 *                 PB          pbBits
 *                 PB          pbInfo
 *                 PDDC        pddc
 *                 ULONG       ifn
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

LONG prdb_GetBitmapBits (HDC hdc,HBITMAP hbm, ULONG iyOrg, ULONG nyExt,
                         PB pbBits, PB pbInfo, PDDC pddc, ULONG ulFunN)
{
  ULONG ulRet;

  EnterDriver (pddc);

  #if      DEBUG
    LogCall ((PSZ)"GreGetBitmapBits(%lp, %lp, %ld, %ld, %lp, %lp, %lp, %ld)",
             ((PB)&hdc)+sizeof(hdc));
  #endif  /* DEBUG                            */

  if (hbm)
  {
     HBITMAP hbmDisplay ;

     // Get the bitmap handle of our shadow memory DC.
     hbmDisplay = GetDriverInfo (hbm, 1, hdc) ;

     if (hbmDisplay != GPI_ALTERROR)
     {
        ulRet = InnerGreGetBitmapBits (pddc->hdcMemory, hbmDisplay,
                                       iyOrg, nyExt,
                                       pbBits, pbInfo, ulFunN);
     }
     else
     {
        ulRet = GPI_ALTERROR ;
     }
  }
  else
  {
     ulRet = InnerGreGetBitmapBits (pddc->hdcMemory, hbm, iyOrg, nyExt,
                                    pbBits, pbInfo, ulFunN);
  }

  /*
  ** this call should be passed on to the display driver, and should
  ** not ever get this far in the driver.
  */
  /*
  ** GplErrSetError ((LONG) PMERR_DEV_FUNC_NOT_INSTALLED);
  */

  ExitDriver (pddc);

  return (ulRet);
}


/***************************************************************************
 *
 * FUNCTION NAME = prdb_SetBitmapBits
 *
 * DESCRIPTION   = This call should be passed on to the display driver, and
 *                 should never get this far in the postscript driver.
 *
 * INPUT         = HDC         hdc
 *                 HBITMAP     hbm
 *                 ULONG       iyOrg
 *                 ULONG       nyExt
 *                 PB          pbBits
 *                 PB          pbInfo
 *                 PDDC        pddc
 *                 ULONG       ifn
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

ULONG prdb_SetBitmapBits (HDC hdc, HBITMAP hbm, ULONG iyOrg, ULONG nyExt,
                          PB pbBits, PB pbInfo, PDDC pddc, ULONG ulFunN)
{
  ULONG ulRet;

  EnterDriver (pddc);

  #if      DEBUG
    LogCall ((PSZ)"SetBitmapBits(%lp, %08lx, %ld, %ld, %lp, %lp, %lp, %ld)",
             ((PB)&hdc)+sizeof(hdc));
  #endif  /* DEBUG                            */

  if (hbm)
  {
    HBITMAP hbmDisplay ;

    /*
    ** Get the bitmap handle of our shadow memory DC.
    */
    hbmDisplay = GetDriverInfo (hbm, 1, hdc);

    if (hbmDisplay != GPI_ALTERROR)
    {
      ulRet = InnerGreSetBitmapBits (pddc->hdcMemory, hbmDisplay, iyOrg, nyExt,
                                     pbBits, pbInfo, ulFunN);
    }
    else
    {
      ulRet = GPI_ALTERROR;
    }
  }
  else
  {
    ulRet = GreSetBitmapBits (pddc->hdcMemory, hbm, iyOrg, nyExt,
                              pbBits, pbInfo);
  }

  /*
  ** this call should be passed on to the display driver, and should
  ** not ever get this far in the driver.
  */
  GplErrSetError ((LONG) PMERR_DEV_FUNC_NOT_INSTALLED);

  ExitDriver (pddc);

  return (ulRet);
}


/***************************************************************************
 *
 * FUNCTION NAME = prdb_ScrollRect
 *
 * DESCRIPTION   = This call should be passed on to the display driver, and
 *                 should never get this far in the postscript driver.
 *
 * INPUT         = ULONG       hdc
 *                 ULONG   *pPS
 *                 PRECTL      prcl
 *                 PDDC        pddc
 *                 ULONG       ifn
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

ULONG prdb_ScrollRect (ULONG hdc, ULONG *pPS, PRECTL prcl, PDDC pddc, ULONG ifn)
{
  EnterDriver (pddc);

  #if      DEBUG
    LogCall((PSZ)"ScrollRect(%08lx, %lp, %lp, %lp, %ld)",
            ((PB)&hdc)+sizeof(hdc));
  #endif                                 /* DEBUG                             */

  /*
  ** this call should be passed on to the display driver, and should
  ** not ever get this far in the driver.
  */
  GplErrSetError ((LONG) PMERR_DEV_FUNC_NOT_INSTALLED);

  ExitDriver (pddc);
  return (FALSE);
}


/***************************************************************************
 *
 * FUNCTION NAME = prdb_GetPel
 *
 * DESCRIPTION   = This call should be passed on to the display driver, and
 *                 should never get this far in the postscript driver.
 *
 * INPUT         = hdc     The display context handle
 *                 pptl    The coordinates of the pel requested
 *                 pddc    Ptr to the DC instance data
 *                 FunN    The engine function number
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

LONG prdb_GetPel (HDC hdc, PPOINTL pptl, PDDC pddc, ULONG ulFunN)
{
  ULONG ulRet;

  EnterDriver(pddc);

  #if      DEBUG
    LogCall ((PSZ)"prdb_GetPel(%lp, %lp, %lp, %lp)\n",
             ((PB)&hdc)+sizeof(hdc));
  #endif                                 /* DEBUG                             */

  if (pddc->iType == OD_MEMORY)
  {
    ulRet = InnerGreGetPel (pddc->hdcMemory, pptl, ulFunN);
  }
  else
  {
    /*
    ** this call should be passed on to the display driver, and should
    ** not ever get this far in the driver.
    */
    GplErrSetError ( PMERR_DEV_FUNC_NOT_INSTALLED);
    ulRet = GPI_ALTERROR ;
  }

  ExitDriver (pddc);

  return (ulRet);
}


/***************************************************************************
 *
 * FUNCTION NAME = prdb_SaveScreenBits
 *
 * DESCRIPTION   = This call should be passed on to the display driver, and
 *                 should never get this far in the postscript driver.
 *
 * INPUT         = HDC    hdc
 *                 PRECTL prcl
 *                 PDDC   pddc
 *                 ULONG  ifn
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

ULONG prdb_SaveScreenBits (HDC hdc, PRECTL prcl, PDDC pddc, ULONG ifn)
{
  EnterDriver (pddc);
  #if      DEBUG
    LogCall((PSZ)"prdb_SaveScreenBits(%lp, %lp, %lp, %lp)\n",
            ((PB)&hdc)+sizeof(hdc));
  #endif                                 /* DEBUG                             */

  /*
  ** this call should be passed on to the display driver, and should
  ** not ever get this far in the driver.
  */
  GplErrSetError ( PMERR_DEV_FUNC_NOT_INSTALLED);

  ExitDriver (pddc);
  return (GPI_ERROR);
}


/***************************************************************************
 *
 * FUNCTION NAME = prdb_RestoreScreenBits
 *
 * DESCRIPTION   = This call should be passed on to the display driver, and
 *                 should never get this far in the postscript driver.
 *
 * INPUT         = HDC hdc
 *                 ULONG ulHandle
 *                 PRECTL prcl
 *                 ULONG ulFlags
 *                 PDDC pddc
 *                 ULONG ifn
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 **************************************************************************/

ULONG prdb_RestoreScreenBits (HDC hdc, ULONG ulHandle, PRECTL prcl,
                              ULONG ulFlags, PDDC pddc, ULONG ifn)
{
  EnterDriver (pddc);

  #if      DEBUG
    LogCall((PSZ)"prdb_RestoreScreenBits(%lp, %lp, %lp, %lp)\n",
            ((PB)&hdc)+sizeof(hdc));
  #endif                                 /* DEBUG                             */

  /*
  ** this call should be passed on to the display driver, and should
  ** not ever get this far in the driver.
  */
  GplErrSetError ( PMERR_DEV_FUNC_NOT_INSTALLED);

  ExitDriver (pddc);
  return (GPI_ERROR);
}


/***************************************************************************
 *
 * FUNCTION NAME = prdg_Death
 *
 *
 * DESCRIPTION   = The death call notifies the driver of the death of a
 *                 screen group.  Since the driver is not interested in
 *                 screen groups its a no-op.
 *
 *
 * INPUT         = HDC    hdc   The display context handle
 *                 PDDC   pddc  Ptr to the dc instance data
 *                 ULONG  ifn   The engine funciton number
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

ULONG prdg_Death (HDC hdc, PDDC pddc, ULONG ifn)
{
  EnterDriver (pddc);

  #if      DEBUG
    LogCall("prdg_Death(%lp, %lp, %lp)",
            ((PB)&hdc)+sizeof(hdc));
  #endif                                 /* DEBUG                           */

  ExitDriver (pddc);
  return (SUCCESS);
}


/***************************************************************************
 *
 * FUNCTION NAME = prdg_ErasePS
 *
 * DESCRIPTION   = This call erases the media. For printers, no
 *                 operation is done.
 *
 * INPUT         = HDC    hdc   The display context handle
 *                 PDDC   pddc  Ptr to the dc instance data
 *                 ULONG  ifn   The engine funciton number
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

ULONG prdg_ErasePS (HDC hdc, PDDC pddc, ULONG ulFunN)
{
  ULONG ulRet;

  EnterDriver (pddc);

  #if      DEBUG
    LogCall ("prdg_ErasePS(%lp, %lp, %lp)", ((PB)&hdc)+sizeof(hdc));
  #endif  /* DEBUG                            */

  if (pddc->iType == OD_MEMORY)
  {
    ulRet = InnerGreErasePS (pddc->hdcMemory, ulFunN);
  }
  else
  {
    ulRet = SUCCESS;
  }

  ExitDriver (pddc);

  return (ulRet);
}


/***************************************************************************
 *
 * FUNCTION NAME = prdg_Resurrection
 *
 * DESCRIPTION   = The resurrection call notifies the driver of the
 *                 resurrection of a screen group.  Since the driver is not
 *                 interested in screen groups, this call is a no-op.
 *
 * INPUT         = HDC    hdc   The display context handle
 *                 PDDC   pddc  Ptr to the dc instance data
 *                 ULONG  ifn   The engine funciton number
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

ULONG prdg_Resurrection (HDC hdc, PDDC pddc, ULONG ifn)
{
  EnterDriver (pddc);

  #if      DEBUG
    LogCall("prdg_Resurrection(%lp, %lp, %lp)",
            ((PB)&hdc)+sizeof(hdc));
  #endif                                 /* DEBUG                           */

  ExitDriver (pddc);
  return (SUCCESS);
}


/***************************************************************************
 *
 * FUNCTION NAME = prdg_LockDevice
 *
 * DESCRIPTION   = This call is used to lock out other threads from executing
 *                 driver code.  The driver fails on this call to indicate
 *                 that its not possible to lock out the device.
 *
 * INPUT         = HDC    hdc   The display context handle
 *                 PDDC   pddc  Ptr to the dc instance data
 *                 ULONG  ifn   The engine funciton number
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

ULONG prdg_LockDevice (HDC hdc, PDDC pddc, ULONG ulFunN)
{
  ULONG ulRet;

  EnterDriver (pddc);

  #if      DEBUG
    LogCall ("prdg_LockDevice(%lp, %lp, %lp)", ((PB)&hdc)+sizeof(hdc));
  #endif  /* DEBUG                            */

  if (pddc->iType == OD_MEMORY)
  {
    ulRet = InnerGreLockDevice (pddc->hdcMemory, ulFunN);
  }
  else
  {
    ulRet = SUCCESS ;
  }

  ExitDriver (pddc);

  return (ulRet);
}


/***************************************************************************
 *
 * FUNCTION NAME = prdg_UnLockDevice
 *
 * DESCRIPTION   = This call is used to enable threads locked out from the
 *                 prdg_LockDevice call.  Since no threads can be locked out
 *                 this call returns a failure status.
 *
 * INPUT         = HDC    hdc   The display context handle
 *                 PDDC   pddc  Ptr to the dc instance data
 *                 ULONG  ifn   The engine funciton number
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

ULONG prdg_UnlockDevice (HDC hdc, PDDC pddc, ULONG ulFunN)
{
  ULONG ulRet;

  EnterDriver(pddc);

  #if      DEBUG
    LogCall ("prdg_UnlockDevice(%lp, %lp, %lp)", ((PB)&hdc)+sizeof(hdc));
  #endif                                 /* DEBUG                           */

  if (pddc->iType == OD_MEMORY)
  {
    ulRet = InnerGreUnlockDevice (pddc->hdcMemory, ulFunN);
  }
  else
  {
    ulRet = SUCCESS;
  }

  ExitDriver (pddc);

  return (ulRet);
}


/***************************************************************************
 *
 * FUNCTION NAME = prdc_RealizeColorTable
 *
 * DESCRIPTION   = This function is called to alter the device's hardware
 *                 color table so that it matches the logical color table.
 *                 Since PostScript device's don't have a hardware color
 *                 table, this function does nothing.
 *
 * INPUT         = HDC    hdc   The display context handle
 *                 PDDC   pddc  Ptr to the dc instance data
 *                 ULONG  ifn   The engine funciton number
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

ULONG prdc_RealizeColorTable (HDC hdc, PDDC pddc, ULONG ulFunN)
{
  ULONG ulRet;

  EnterDriver(pddc);

  #if      DEBUG
    LogCall ("prdc_RealizeColorTable(%lp, %lp, %lp)\n",
             ((PB)&hdc)+sizeof(hdc));
  #endif  /* DEBUG                            */

  if (pddc->iType == OD_MEMORY)
  {
     ulRet = InnerGreRealizeColorTable (pddc->hdcMemory, ulFunN);
  }
  else
  {
     /*
     ** Color table cannot be realized
     */
     GplErrSetError ( PMERR_DEV_FUNC_NOT_INSTALLED);
     ulRet = FAILURE;
  }

  ExitDriver (pddc);

  return (ulRet);
}


/***************************************************************************
 *
 * FUNCTION NAME = prdc_UnrealizeColorTable
 *
 * DESCRIPTION   = This function is called to reverse the effects of
 *                 the RealizeColorTable call.  Since RealizeColorTable is
 *                 a no-op in the PostScript driver, this function is also
 *                 a no-op.
 *
 * INPUT         = HDC    hdc   The display context handle
 *                 PDDC   pddc  Ptr to the dc instance data
 *                 ULONG  ifn   The engine funciton number
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

ULONG prdc_UnrealizeColorTable (HDC hdc, PDDC pddc, ULONG ulFunN)
{
  ULONG ulRet;

  EnterDriver (pddc);

  #if      DEBUG
    LogCall ("prdc_UnrealizeColorTable(%lp, %lp, %lp)\n",
             ((PB)&hdc)+sizeof(hdc));
  #endif /* DEBUG                             */

  if (pddc->iType == OD_MEMORY)
  {
     ulRet = InnerGreUnrealizeColorTable (pddc->hdcMemory, ulFunN);
  }
  else
  {
     /*
     ** Color table cannot be unrealized
     */
     GplErrSetError ( PMERR_DEV_FUNC_NOT_INSTALLED);
     ulRet = FAILURE;
  }

  ExitDriver (pddc);

  return (ulRet);
}


/***************************************************************************
 *
 * FUNCTION NAME = prdl_DrawConicsInPath
 *
 * DESCRIPTION   = Since the Postscript driver does all its own paths,
 *                 this function just needs to fail so the engine does
 *                 the right thing.
 *
 * INPUT         = HDC   hdc
 *                 PB    pph
 *                 PB    pcvFirst
 *                 LONG  icvCount
 *                 PDDC  pddc
 *                 ULONG FunN
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

ULONG prdl_DrawConicsInPath (HDC hdc, PB pph, PB pcvFirst, LONG icvCount,
                             PDDC pddc, ULONG FunN)
{
  GplErrSetError ( PMERR_DEV_FUNC_NOT_INSTALLED);
  return (FAILURE);
}


/***************************************************************************
 *
 * FUNCTION NAME = prdl_DrawLinesInPath
 *
 * DESCRIPTION   = Since the Postscript driver does all its own paths,
 *                 this function just needs to fail so the engine does
 *                 the right thing.
 *
 * INPUT         = HDC   hdc
 *                 PB    pph
 *                 PB    pcvFirst
 *                 LONG  icvCount
 *                 PDDC  pddc
 *                 ULONG FunN
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

ULONG prdl_DrawLinesInPath (HDC hdc, PB pph, PB pcvFirst, LONG icvCount,
                            PDDC pddc, ULONG ulFunN)
{
  ULONG ulRet;

  EnterDriver (pddc);

  if (pddc->iType == OD_MEMORY)
  {
     ulRet = InnerGreDrawLinesInPath (pddc->hdcMemory, pph, pcvFirst,
                                      icvCount, ulFunN);
  }
  else
  {
     GplErrSetError ( PMERR_DEV_FUNC_NOT_INSTALLED);
     ulRet = FAILURE;
  }

  ExitDriver (pddc);

  return (ulRet);
}


/*
**PTR OSDD B734791
**The following routines are stubs for the mandatory functions for displays.
**The were added to support the new 2.0 32 bit engine.
*/
/***************************************************************************
 *
 * FUNCTION NAME = prdd_CharRect
 *
 * DESCRIPTION   =
 *
 * INPUT         = HDC         hDC
 *                 VOID  *  pps
 *                 VOID  *  pCharRect
 *                 PDDC        pddC
 *                 ULONG       FunN
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

ULONG prdd_CharRect (HDC hDC, VOID *pps, VOID *pCharRect, PDDC pddc, ULONG FunN)
{
  EnterDriver (pddc);

  GplErrSetWarning ( PMERR_DEV_FUNC_NOT_INSTALLED);

  ExitDriver (pddc);
  return (NO_ERROR);                   /* success                           */
}


/***************************************************************************
 *
 * FUNCTION NAME = prdd_CharStr
 *
 * DESCRIPTION   =
 *
 * INPUT         = HDC         hDC
 *                 VOID  *  pps
 *                 VOID  *  pCharStr
 *                 PDDC        pddc
 *                 ULONG       FunN
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

ULONG prdd_CharStr (HDC hDC, VOID *pps, VOID *pCharStr, PDDC pddc, ULONG FunN)
{
  EnterDriver (pddc);
  GplErrSetWarning ( PMERR_DEV_FUNC_NOT_INSTALLED);
  ExitDriver (pddc);
  return (NO_ERROR);                   /* success                           */
}


/***************************************************************************
 *
 * FUNCTION NAME = prdd_DeviceInvalidateVisRegion
 *
 * DESCRIPTION   =
 *
 * INPUT         = HDC         hDC
 *                 LONG        cArray
 *                 PDC_BLOCK   paBlock
 *                 PDDC        pddc
 *                 ULONG       FunN
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

ULONG prdd_DeviceInvalidateVisRegion (HDC hDC, LONG cArray,PDC_BLOCK paBlock,
                                      PDDC pddc, ULONG FunN)
{
  EnterDriver (pddc);
  GplErrSetWarning (PMERR_DEV_FUNC_NOT_INSTALLED);
  ExitDriver (pddc);
  return (1L);                         /* success                           */
}


/***************************************************************************
 *
 * FUNCTION NAME = prdd_DeviceSetAVIOFont
 *
 * DESCRIPTION   =
 *
 * INPUT         = HDC     hDC
 *                 PBYTE   pFontDef
 *                 LONG    lcid
 *                 PDDC    pDDC
 *                 ULONG   FunN
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

ULONG prdd_DeviceSetAVIOFont (HDC hDC, PBYTE pFontDef, LONG lcid,PDDC pddc,
                              ULONG FunN)
{
  EnterDriver (pddc);
  GplErrSetWarning ( PMERR_DEV_FUNC_NOT_INSTALLED);
  ExitDriver (pddc);
  return (1L);                         /* success                           */
}


/***************************************************************************
 *
 * FUNCTION NAME = prdd_DeviceSetCursor
 *
 * DESCRIPTION   =
 *
 * INPUT         = HDC     hDC
 *                 PPOINTL pPts
 *                 HBITMAP hBitmap
 *                 PDDC    pDDC
 *                 ULONG   FunN
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

ULONG prdd_DeviceSetCursor (HDC hDC, PPOINTL pPts, HBITMAP hBitmap,
                            PDDC pddc, ULONG FunN)
{
  EnterDriver (pddc);
  GplErrSetWarning ( PMERR_DEV_FUNC_NOT_INSTALLED);
  ExitDriver (pddc);
  return (1L);                         /* success                           */
}


/***************************************************************************
 *
 * FUNCTION NAME = prdd_GetPickWindow
 *
 * DESCRIPTION   =
 *
 * INPUT         = HDC     hDC
 *                 PRECTL  pPick
 *                 PDDC    pDDC
 *                 ULONG   FunN
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

ULONG prdd_GetPickWindow (HDC hDC, PRECTL pPick, PDDC pddc, ULONG FunN)
{
  EnterDriver (pddc);
  GplErrSetWarning (PMERR_DEV_FUNC_NOT_INSTALLED);
  ExitDriver (pddc);
  return (1L);                         /* success                           */
}


/***************************************************************************
 *
 * FUNCTION NAME = prdd_GetStyleRatio
 *
 * DESCRIPTION   = This function stores, at the location addressed by
 *                 pRatio, the style ratio x and y direction step values.
 *
 *                 Contrary to the documentation, when the line type is
 *                 LINETYPE_ALTERNATE, this function does not restore
 *                 the style ratio to the value zero.
 *
 * INPUT         = HDC     hDC
 *                 PRECTL  pPick
 *                 PDDC    pDDC
 *                 ULONG   FunN
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

ULONG prdd_GetStyleRatio (HDC hdc, PBYTE pRatio, PDDC pddc, ULONG ulFunN)
{
  ULONG ulRet;

  EnterDriver (pddc);

  if (pddc->iType == OD_MEMORY)
  {
    /*
    ** Get our ratio for hdcMemory (which we have already set it).
    */
    ulRet = InnerGreGetStyleRatio (pddc->hdcMemory, pRatio, ulFunN);
  }
  else
  {
    GplErrSetWarning ( PMERR_DEV_FUNC_NOT_INSTALLED);
    ulRet = SUCCESS;
  }
  ExitDriver (pddc);
  return (ulRet);
}


/***************************************************************************
 *
 * FUNCTION NAME = prdd_SetColorCursor
 *
 * DESCRIPTION   =
 *
 * INPUT         = HDC         hDC
 *                 VOID  *  pPointerInfo
 *                 PDDC        pDDC
 *                 ULONG       FunN
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

ULONG prdd_SetColorCursor (HDC hDC, VOID *pPointerInfo, PDDC pddc, ULONG FunN)
{
  EnterDriver (pddc);
  GplErrSetWarning (PMERR_DEV_FUNC_NOT_INSTALLED);
  ExitDriver (pddc);
  return (1L);                         /* success                           */
}


/***************************************************************************
 *
 * FUNCTION NAME = prdd_SetPickWindow
 *
 * DESCRIPTION   =
 *
 * INPUT         = HDC     hDC
 *                 PRECTL  pPick
 *                 PDDC    pDDC
 *                 ULONG   FunN
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

ULONG prdd_SetPickWindow (HDC hDC, PRECTL pPick, PDDC pddc, ULONG FunN)
{
  EnterDriver (pddc);
  GplErrSetWarning ( PMERR_DEV_FUNC_NOT_INSTALLED);
  ExitDriver (pddc);
  return (1L);                         /* success                           */
}


/***************************************************************************
 *
 * FUNCTION NAME = prdd_UpdateCursor
 *
 * DESCRIPTION   =
 *
 * INPUT         = HDC         hDC
 *                 VOID  *  pps
 *                 PDDC        pDDC
 *                 ULONG       FunN
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

ULONG prdd_UpdateCursor (HDC hDC, VOID *pps, PDDC pddc, ULONG FunN)
{
  EnterDriver (pddc);
  GplErrSetWarning ( PMERR_DEV_FUNC_NOT_INSTALLED);
  ExitDriver (pddc);
  return (NO_ERROR);                   /* success                           */
}


/*
**PTR OSDD B734791  end of changes
*/
/* functions are from mandfunc.c    move them back later                     */
/***************************************************************************
 *
 * FUNCTION NAME = prdm_DisjointLines
 *
 * DESCRIPTION   =
 *
 * INPUT         =
 *
 *
 *
 *
 * OUTPUT        =
 *
 * RETURN-NORMAL =
 *
 * RETURN-ERROR  =
 *
 **************************************************************************/

ULONG prdm_DisjointLines (HDC hdc, PPOINTL paptlPoint, LONG cPoints, PDDC pddc,
                          ULONG ulFunN)
{
  ULONG ulRet;

  EnterDriver (pddc);

  if (pddc->iType == OD_MEMORY)
  {
    ulRet = InnerGreDisjointLines (pddc->hdcMemory, paptlPoint, cPoints, ulFunN);
  }
  else
  {
     /*
     ** we should not come this far
     */
     GplErrSetError ((LONG) PMERR_DEV_FUNC_NOT_INSTALLED);
     ulRet = GPI_ERROR ;
  }

  ExitDriver (pddc);

  return (ulRet);
}


/***************************************************************************
 *
 * FUNCTION NAME = prdm_PolyScanLine
 *
 * DESCRIPTION   =
 *
 * INPUT         =
 *
 *
 *
 *
 * OUTPUT        =
 *
 * RETURN-NORMAL =
 *
 * RETURN-ERROR  =
 *
 **************************************************************************/
ULONG prdm_PolyScanline (HDC hdc, PSCANDATA pScanData, PDDC pddc, ULONG ulFunN)
{
  ULONG ulRet;

  EnterDriver (pddc);

  if (pddc->iType == OD_MEMORY)
  {
    ulRet = InnerGrePolyScanline (pddc->hdcMemory, pScanData, ulFunN);
  }
  else
  {
    /*
    ** we should not come this far
    */
    GplErrSetError ((LONG) PMERR_DEV_FUNC_NOT_INSTALLED);
    ulRet = GPI_ERROR;
  }

  ExitDriver (pddc);

  return (ulRet);
}


/***************************************************************************
 *
 * FUNCTION NAME = prdm_PolyShortLine
 *
 * DESCRIPTION   =
 *
 * INPUT         =
 *
 *
 *
 *
 * OUTPUT        =
 *
 * RETURN-NORMAL =
 *
 * RETURN-ERROR  =
 *
 **************************************************************************/
ULONG prdm_PolyShortLine (HDC hdc, PSHORTLINE psl, PDDC pddc, ULONG ulFunN)
{
  ULONG ulRet;

  EnterDriver (pddc);

  if (pddc->iType == OD_MEMORY)
  {
    ulRet = InnerGrePolyShortLine (pddc->hdcMemory, psl, ulFunN);
  }
  else
  {
    /*
    ** we should not come this far
    */
    GplErrSetError ((LONG) PMERR_DEV_FUNC_NOT_INSTALLED);
    ulRet = GPI_ERROR;
  }

  ExitDriver (pddc);

  return (ulRet);
}


/***************************************************************************
 *
 * FUNCTION NAME = prdm_DrawBits
 *
 * DESCRIPTION   =
 *
 * INPUT         =
 *
 *
 *
 *
 * OUTPUT        =
 *
 * RETURN-NORMAL =
 *
 * RETURN-ERROR  =
 *
 **************************************************************************/
ULONG  prdm_DrawBits (HDC hdc, PBYTE pBitmap, PBITMAPINFO pInfo, LONG  cPoints,
                      PPOINTL paptlPoint, LONG lRop, ULONG flOptions,
                      PDDC pddc, ULONG ulFunN)
{
  ULONG ulRet;

  EnterDriver (pddc);

  if (pddc->iType == OD_MEMORY)
  {
    ulRet = InnerGreDrawBits (pddc->hdcMemory, pBitmap, pInfo, cPoints,
                              paptlPoint, lRop, flOptions, ulFunN);
  }
  else
  {
    /*
    ** we should not come this far
    */
    GplErrSetError ((LONG) PMERR_DEV_FUNC_NOT_INSTALLED);
    ulRet = GPI_ERROR;
  }

  ExitDriver (pddc);

  return (ulRet);
}


/***************************************************************************
 *
 * FUNCTION NAME = prdm_DrawBorder
 *
 * DESCRIPTION   =
 *
 * INPUT         =
 *
 *
 *
 *
 * OUTPUT        =
 *
 * RETURN-NORMAL =
 *
 * RETURN-ERROR  =
 *
 **************************************************************************/
ULONG prdm_DrawBorder (HDC hdc, PRECTL prclFrame, ULONG cxBorder, ULONG cyBorder,
                       LONG clrBorder, LONG clrInterior, ULONG flCmd, PDDC pddc,
                       ULONG ulFunN)
{
  ULONG ulRet;

  EnterDriver (pddc);

  if (pddc->iType == OD_MEMORY)
  {
    ulRet = InnerGreDrawBorder (pddc->hdcMemory, prclFrame, cxBorder, cyBorder,
                                clrBorder, clrInterior, flCmd, ulFunN);
  }
  else
  {
    /*
    ** we should not come this far
    */
    GplErrSetError ((LONG) PMERR_DEV_FUNC_NOT_INSTALLED);
    ulRet = GPI_ERROR;
  }

  ExitDriver (pddc);

  return (ulRet);
}


/***************************************************************************
 *
 * FUNCTION NAME = prdm_QueryDevResource
 *
 * DESCRIPTION   =
 *
 * INPUT         =
 *
 *
 *
 *
 * OUTPUT        =
 *
 * RETURN-NORMAL =
 *
 * RETURN-ERROR  =
 *
 **************************************************************************/
ULONG prdm_QueryDevResource (HDC hdc, ULONG rType, ULONG id, PDDC pddc,
                             ULONG ulFunN)
{
  ULONG ulRet;

  EnterDriver (pddc);

  if (pddc->iType == OD_MEMORY)
  {
    ulRet = (ULONG) InnerGreQueryDevResource2 (pddc->hdcMemory, rType, id, ulFunN);
  }
  else
  {
    /*
    ** we should not come this far
    */
    GplErrSetError ((LONG) PMERR_DEV_FUNC_NOT_INSTALLED);
    ulRet = GPI_ERROR;
  }

  ExitDriver (pddc);

  return (ulRet);
}
