#----------------------------------------------------------------------------
# MAKEFILE for the POSTSCRIPT DRIVER
#
# SCCSID: src/wp.osdd/pscript/makefile nextbuild 94/05/11
#
# COMPONENT_NAME: PSCRIPT
#
# FUNCTIONS: POSTSCRIPT PRESENTATION DRIVER
#
# ORIGINS: Linked to os2
#
# (C) COPYRIGHT International Business Machines Corp. 1992
# All Rights Reserved
# Licensed Materials - Property of IBM
#
# US Government Users Restricted Rights - Use, duplication or
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
#----------------------------------------------------------------------------
#
#General Rules for the developers.
#
#1. Use Absolute Paths from Root. The root is defined relatively.
#   The complexity of the tree can be overcome by
#   absolute paths($(ROOT)\src\) instead of relative path (..\..\..\src\ etc)
#   This makes the output readable.
#
#2. Please don't write generated output to the \src tree. The intermediate
#   output should go into the \obj tree and the release tree (\rel)
#   should contain the files that needs to be shipped. The location of files
#   in the release tree should be decided after discussions with the
#   install group.
#
#3. Include the compiler and flags that need to be used for each build option
#   in compiler.mak. This will give us a global way to change the compiler
#   options and flags for any given sub-system. For example, changing
#   from metaware, ibm C set++ etc.
#
#4. Development should give the build lab the list of components that
#   need to be built and the order in which they need to be built.
#   The wait dependencies for the components should be given, so that
#   components are not kicked off before libraries, tools, etc.(Dependencies)
#   Call the build lab if you have any questions regarding dependencies.
#
#5. Development should provide a mechanism to have all components associated
#   with public code (i.e. \src\public) to be built as soon as possible. This
#   list can be placed in the Build Lab's Makefile that invokes the development's
#   Component makefile. A psuedo-target called public can be used to list
#   the components necessary to be built. Again the component dependencies should
#   provided.
#
#6. All public headers and libs should be used from the "rel" tree.
#   You can't use files from other sub-systems source/output tree.
#
#7. Make Sure that the output paths exists. There will be a build break
#   if directory into which you are writing doesn't exist.
#   Use tools like "makepath", or macro "create_path" to create directory
#   structure. Some base paths are created in header.mak
#
#8. When building for the DDK, include the parameter "ddkbld=1" (case
#   sensitive).
#----------------------------------------------------------------------------
# Define this Component Specific Macros
#----------------------------------------------------------------------------
# SUBSYS is a macro to define the name of the subsystem that this makefile is a
# part of.   It is the name of the subdirectory that is above all of the
# individual components.
#
# SUBSYS_RELATIVE is a macro to define the name of this component.
# SRC_RELATIVE is the full path for the current directory from the
# ROOT.
#
# This uses the substitution feature which takes the current directory of
# this makefile (MAKEDIR) and removes the relative part of the directory to
# get the TOP level directory.
#
# The other macros are used to build directories in other levels of the tree.
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# The syntax for generating a list (combination of C and assembler) is:
# nmake OPT=<retos2c | dbgos2c> <file name>.lis
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# RENAMING THE DRIVER
# To rename the physical driver name, search for "PS_DEF_NAME" and "PS_DRV_NAME"
# (below).  Follow the instructions that accompany them.
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# Modified by:
# Description:  Makefile for POSTSCRIPT PRESENTATION DRIVER
# Date       :  May 17, 1994
#------------------------------------------------------------------------------


#------------------------------------------------------------------------------
# CHANGING THE NAME OF THE DRIVER
#
# The following macros define the definition name and driver name for this
# driver.  The first two lines are reserved for the Japanese driver and should
# not be modified.  The second two lines may be modified when necessary.
#
# PS_DEF_NAME sets up the "#define" string that is used in the driver that
# is used in the full device name.  This string is copied to DRVNAME.H.
# The entire string *MUST* be in uppercase.
#
# PS_DRV_NAME defines the physical name for .DRV, .SYM, .MAP, etc. file names
# that are created in this makefile.  Since this driver is built in HPFS,
# this string is case-sensitive, so it is recommended that this string be in
# lowercase.
#
# IMPORTANT - Except for case, both "PS_DEF_NAME" and "PS_DRV_NAME" must match.
# There is a REXX utility called COMPARE.CMD that ensures this.  COMPARE will
# display an error if the strings do not match (case insensitive).
#------------------------------------------------------------------------------
!if ( "$(NLV)" == "jp" || "$(NLV)" == "JP" || \
      "$(NLV)" == "JA" || "$(NLV)" == "ja" || \
      "$(NLV)" == "tw" || "$(NLV)" == "TW" || \
      "$(NLV)" == "ko" || "$(NLV)" == "KO"  )
# Do not modify these lines
PS_DEF_NAME = PSCRIPT2
PS_DRV_NAME = pscript2
!else
# Modify these flags to change the driver name.
PS_DEF_NAME = PSCRIPT
PS_DRV_NAME = pscript
!endif


SUBSYS          = osdd
SUBSYS_RELATIVE = pscript\post32
SRC_RELATIVE    = src\$(SUBSYS)\$(SUBSYS_RELATIVE)
SRC_NL_RELATIVE = mri\$(NLV)\$(SUBSYS)\$(SUBSYS_RELATIVE)


#------------------------------------------------------------------------------
# Names for all the paths and locations..
#------------------------------------------------------------------------------

PS_SRC   = $(ROOT)\$(SRC_RELATIVE)
MRIPATH  = $(ROOT)\$(SRC_NL_RELATIVE)
PS_INC   = $(PS_SRC)\inc
OUTDIR   = $(DRIVERS_NLV)\pscript
DATAPATH = $(ROOT)\obj\data\pscript
DATAINC  = $(DATAPATH)\inc
MRIOUT   = $(O_NLV)
PPDPATH  = $(MRIPATH)\..\ppd
PPBPATH  = $(DATAPATH)\$(NLV)\ppb
PPDSRC   = $(PS_SRC)\ppd
PPDBIN   = $(O)\ppd
AFMSRC   = $(PS_SRC)\afm
AFMOUT   = $(DATAPATH)\afm
AFMBIN   = $(O)\afm
PRDESC   = $(O)\..\..\prdesc\$(NLV)
ODCOMMON = $(ROOT)\src\$(SUBSYS)\common

#------------------------------------------------------------------------------
#  Use built in macro "MAKEDIR" to establish "ROOT".  Due to case sensitivity
#  of nmake macro substitution, try all lowercase then all uppercase.  Fail if
#  current working directory path is mixed case.  This is a current nmake
#  limitation on macro substitutions but should not be a problem for most
#  people.  We are searching for a fix to this problem.
#------------------------------------------------------------------------------
# \src\mm\misc\mmpmcrt is an example of the path for a specific component
# in the tree structure. Please change the path as applied to your component.
# Refer to Nmake documentation, if you have any questions about MAKEDIR
#------------------------------------------------------------------------------

ROOT            = $(MAKEDIR:\src\osdd\pscript\post32=)
!if "$(ROOT)" == "$(MAKEDIR)"
ROOT            = $(MAKEDIR:\SRC\OSDD\PSCRIPT\POST32=)
!endif
!if "$(ROOT)" == "$(MAKEDIR)"
!error Problem setting "ROOT"! Make sure current working directory is either all\
uppercase or all lowercase!
!endif

#-----------------------------------------------------------------
# Set up component/subsystem specific macros for use in header.mak
# This allows you establish a search order for header and lib paths.  A
# prefix would be a path that you would like to add to the beginning of
# the standard path which is set in header.mak.  A suffix tags onto the
# end of the standard path.
#-----------------------------------------------------------------


#CMP_HDR_PREFIX = <specify non-default path(s) for front of INCLUDE path>
CMP_HDR_PREFIX =
#CMP_HDR_SUFFIX = <specify non-default path(s) for back INCLUDE path>
CMP_HDR_SUFFIX = $(PS_INC);$(ROOT)\src\osdd\genplib;$(DATAINC);$(MRIPATH);$(PPBPATH)
#CMP_LIB_PREFIX = <specify non-default path(s) for front of LIB path>
CMP_LIB_PREFIX =
#CMP_LIB_SUFFIX = <specify non-default path(s) for back LIB path>
CMP_LIB_SUFFIX=

# Uncomment to use ibmc libs.  With this out, it uses the
# default metaware libs location.
USE_IBMC_LIB = 1

#-----------------------------------------------------------------------------
# PUBLIC can be one of "ibmmk", "cps","os2".  Please define the below macros
# if you want to include the public files in a different order.  These macros
# would be used if you have a preference as to which directory gets searched
# first.  For example, you would like to search the OS2 header or include
# files before you search the ibmmk header or include files.  In this case,
# you would specify PUBLIC1 = OS2 and PUBLIC2= IBMMK and PUBLIC3 = CPS.
# These macros are then used in header.mak to set the path order.
#-----------------------------------------------------------------------------

PUBLIC1 = os2

#-----------------------------------------------------------------------------
# Version of build in here
#-----------------------------------------------------------------------------
!include $(ODCOMMON)\version.mak


#------------------------------------------------------------------------------
# HOST_PROC and HOST_OS will be set in the environment by the build lab.
# Set them in your private builds.
# Please don't set these variables in the public build.
# HOST_PROC=386
# HOST_OS=OS2
#-----------------------------------------------------------------------------

!ifndef HOST_PROC
HOST_PROC=386
HOST_OS=OS2
!endif


#------------------------------------------------------------------------------
# header.mak is the public makefile that sets up all paths and options.  It
# should not be altered.  Additions or changes to header.mak for a component
# can be overwritten in this makefile.  Additions or changes to header.mak
# for an entire subsystem can be overwritten in subsys.mak
#-----------------------------------------------------------------------------

!include $(ROOT)\header.mak

#-------------------------------------------------------------------------
# subsys.mak is used as a way for each subsystem to override any settings
# that were set in header.mak.  It is owned by development.
#-------------------------------------------------------------------------
!include $(ROOT)\src\$(SUBSYS)\common\subsys.mak


# The $(ROOT)\src\$(SUBSYS)\common\options.mak is called by root header.mak

!if "$(TARGET_PROC)"=="ppc"
EXT = prv
!else
EXT = drv
!endif
PRIV_HDR  = $(PS_INC)

#-------------------------------------------------------------------------
# Insert any paths or macros that weren't defined in header.mak or
# subsys.mak here.
#--------------------------------------------------------------------------


#----------------------------------------------------------------
# Set up the list of suffixes, if the suffixes in header.mak are not
# sufficient.  Be sure to include the entire list.
#-----------------------------------------------------------------

.SUFFIXES:
.SUFFIXES: .c .cpp .asm .h .inc .obj .def .dll .lib .o .res .rc .drv


#------------------------------------------------------------------------
# Please define all compiler, assembler, and linker flags here.
# Use if statement to define the flags for each type of builds.
# See $(ROOT)\src\$(SUBSYS)\common\subsys.mak for defines.
#------------------------------------------------------------------------


# PPC pragma defintions are:
#   88 - Expression has no side-effects.
#  257 - '=' encountered where '==' may have been intended.
#  290 - Static function is not referenced.
#  587 - Linkage pragma not supported yet.
#  652 - Variable is never used.


# For the DDK build.  If defined, define interal '#ifdef' directive.
! ifdef ddkbld
DDKBLD = -DDDKBLD
! endif

!ifdef DISABLE_DJP_SUPPORT
DJPOPTS = -DDISABLE_DJP_SUPPORT
!endif

# Tack on your specfic options instead of adding to CFLAGS
PSOPTS = $(DDKBLD) $(DJPOPTS)


!if "$(TARGET_PROC)"=="ppc"
! if "$(BLD_TYPE)"=="retail"
DBG_CFLAGS=
! else
DBG_CFLAGS= -g
! endif

CFLAGS = -c $(SYSTEM_CFLAGS) $(MW_IBMC_DEFS) $(DBG_CFLAGS) -o $@ -D_OS2 -DMACH \
          -DSWITCH -DINCL_32 -DWPOS_BLD -DIBMC -DPPC -DUNIX_BUILD -D__GNUASM \
          -DPOWERPC -DMETAWARE -DMACH_IPC_TYPED=0 $(PSOPTS) \
          -Hpragma=Offwarn(88,257,290,587,652) -pic -Hon=Char_default_unsigned \
          -Hpragma=os_id(4) -HL -Hinlsize=300 -Hon=Char_is_rep
CFLAGSEXE = $(CFLAGS)
LINKLIBS  = $(GENPLIB) $(R_OS2_LIB)\libos2.a $(R_OS2P_LIB)\libos2p.a \
            $(R_CRT_LIB)\libspc.a
!else
! if "$(BLD_TYPE)"=="retail"
DBG_CFLAGS= /O+
! else
DBG_CFLAGS= /Ti+ /O- /DLINT_ARGS /DIPMD=1
LDFLAGS = /DEBUG
! endif

CFLAGS    = $(TUNEROPT) $(COPT) $(PSOPTS) -c -Q+ -Ge- -Ss -Rn -Ms -Gn -Sp -W3 -Gs- /Fo$@
LFLAGS    = /SEG:140 /MAP /PACKCODE /NOD /NOE /a:4 $(LINK_CV)
LIBOS2    = $(R206_LIB)\os2386.lib
#LIBOS2P   = $(R206_LIB)\os2386p.lib
CLIBSDLL  = $(COMPILER_LIB)\dde4nbs.lib
LINKLIBS  = $(LIBOS2) $(LIBOS2P) $(CLIBSDLL) $(GENPLIB) $(TUNERLIB)
!endif

# 140397 - Remove '/O+'
# TOOLS_OPT= /O+ -Ss+ -Sp $(LISTING) /Fo$(@R).obj /Fe$(@R).exe
TOOLS_OPT= -Ss+ -Sp $(LISTING) /Fo$(@R).obj /Fe$(@R).exe

#--------------------------------------------------------------------------
# If the Inference rules defined in header.mak are not sufficient, then
# define the inference rules necessary at this point.
# The following inference rules are just an example.
# You can delete this section if you don't need to add more inference rules.
#-------------------------------------------------------------------------

.c{$(O)}.obj:
        $(CC) $(DBG_CFLAGS) $(CFLAGS) $(@B).c

.c.lis:
        $(CC) $(DBG_CFLAGS) $(CFLAGS) -Fo- -Fa$(@B).lis $(@B).c

.asm{$(O)}.obj:
        $(AS) -DINCL_32 $(@B).asm,$(O)\$(@B).obj;

#------------------------------------------------------------------------
#Component defines start here. Example of som defines are attached in
#this template
#------------------------------------------------------------------------

LIBSDLL = $(LIBOS2) $(LIBOS2P) $(CLIBSDLL)


# For OEM support
!ifndef ddkbld
OBJOEM = $(O)\hp.obj $(O)\oem.obj
!endif

OBJ01 = $(O)\arcs.obj       $(O)\asm2c.obj      $(O)\attrs.obj
OBJ02 = $(O)\bitmaps.obj    $(O)\bounds.obj     $(O)\box.obj
OBJ03 = $(O)\charstr.obj    $(O)\charstr2.obj   $(O)\colortab.obj
OBJ04 = $(O)\config.obj     $(O)\devblock.obj   $(O)\devesc.obj
OBJ05 = $(O)\devmode.obj    $(O)\dlg.obj        $(O)\download.obj
OBJ06 = $(O)\enable.obj     $(O)\flchkdlg.obj   $(O)\fonts.obj
OBJ07 = $(O)\init.obj       $(O)\jpdlg.obj      $(O)\memory.obj
OBJ08 = $(O)\noinstal.obj   $(O)\patfill.obj
OBJ09 = $(O)\path.obj       $(O)\path2.obj      $(O)\polystuf.obj
OBJ10 = $(O)\ppdlg.obj      $(O)\prdevect.obj   $(O)\profile.obj
OBJ11 = $(O)\psdjp.obj      $(O)\pstuner.obj    $(O)\query.obj
OBJ12 = $(O)\querybox.obj   $(O)\querychr.obj   $(O)\surface.obj
OBJ13 = $(O)\utlchnl.obj    $(O)\utllog.obj     $(O)\utlprint.obj
OBJ14 = $(O)\utlps.obj      $(O)\xforms.obj

#--------------------------------------------------------------------------

GPLMRI  = $(ROOT)\mri\$(NLV)\$(SUBSYS)\drvmri
!if "$(TARGET_PROC)"=="ppc"
OBJ99  = $(MRIOUT)\$(PS_DRV_NAME).o
GENPLIB = $(O)\..\..\genplib\libgenp.a
!else
OBJ99  = $(O)\stub.obj
GENPLIB = $(O)\..\..\genplib\genplib.lib
RESFILE = $(MRIOUT)\$(PS_DRV_NAME).res
MRIPATH  = $(ROOT)\$(SRC_NL_RELATIVE)
!endif

#---------------------------------------------------------------------------

PSOBJS = $(OBJ01) $(OBJ02) $(OBJ03) $(OBJ04) $(OBJ05) \
         $(OBJ06) $(OBJ07) $(OBJ08) $(OBJ09) $(OBJ10) \
         $(OBJ11) $(OBJ12) $(OBJ13) $(OBJ14) $(OBJ99) \
         $(OBJOEM)

#-----------------------------------------------------------------------------
#  RESOURCE creation
#
#
#
#
#-----------------------------------------------------------------------------

# Adobe Font Metrics files
AFM = $(AFMSRC)

AFM01 = $(AFM)\agb.afm   $(AFM)\agbo.afm  $(AFM)\agd.afm     \
        $(AFM)\agdo.afm  $(AFM)\bd.afm    $(AFM)\bdi.afm
AFM02 = $(AFM)\bl.afm    $(AFM)\bli.afm   $(AFM)\cb.afm      \
        $(AFM)\cbo.afm   $(AFM)\cm.afm    $(AFM)\co.afm
AFM03 = $(AFM)\fgbrh.afm $(AFM)\fmbrh.afm $(AFM)\gal.afm     \
        $(AFM)\gdb.afm   $(AFM)\gdbi.afm  $(AFM)\gdi.afm
AFM04 = $(AFM)\gdrg.afm  $(AFM)\gdsb.afm  $(AFM)\gdsbi.afm   \
        $(AFM)\gmrh.afm  $(AFM)\gmrh2.afm $(AFM)\hb.afm
AFM05 = $(AFM)\hbo.afm   $(AFM)\hm.afm    $(AFM)\ho.afm      \
        $(AFM)\hvn.afm   $(AFM)\hvnb.afm  $(AFM)\hvnbo.afm
AFM06 = $(AFM)\hvno.afm  $(AFM)\jlrh.afm  $(AFM)\lb.afm      \
        $(AFM)\lbo.afm   $(AFM)\ld.afm    $(AFM)\ldo.afm
AFM07 = $(AFM)\ncb.afm   $(AFM)\ncbi.afm  $(AFM)\nci.afm     \
        $(AFM)\ncr.afm   $(AFM)\pb.afm    $(AFM)\pbi.afm
AFM08 = $(AFM)\pi.afm    $(AFM)\pr.afm    $(AFM)\rlrh.afm    \
        $(AFM)\rlrh2.afm $(AFM)\sd.afm    $(AFM)\sdi.afm
AFM09 = $(AFM)\sl.afm    $(AFM)\sli.afm   $(AFM)\sm.afm      \
        $(AFM)\tb.afm    $(AFM)\tbi.afm   $(AFM)\ti.afm
AFM10 = $(AFM)\tr.afm    $(AFM)\zc.afm    $(AFM)\zd.afm

AFMS = $(AFM01) $(AFM02) $(AFM03) $(AFM04) $(AFM05)         \
       $(AFM06) $(AFM07) $(AFM08) $(AFM09) $(AFM10)

# List of all Printer description files
PPD = $(PPDPATH)

PPD01 = $(PPD)\39300OS2.PPD $(PPD)\39600OS2.PPD $(PPD)\401917US.ppd      \
        $(PPD)\401939US.ppd $(PPD)\40291730.ppd $(PPD)\40291760.ppd
PPD02 = $(PPD)\40293930.ppd $(PPD)\40293960.ppd $(PPD)\7728os2u.ppd      \
        $(PPD)\AGFA94US.ppd $(PPD)\AGFA__US.ppd $(PPD)\AMCHR518.ppd
PPD03 = $(PPD)\APL230US.ppd $(PPD)\APL380US.ppd $(PPD)\APL422US.ppd      \
        $(PPD)\AST470US.ppd $(PPD)\CPPER241.ppd $(PPD)\CPPRO518.ppd
PPD04 = $(PPD)\CPPSNA10.ppd $(PPD)\CPPSNB10.ppd $(PPD)\DATAP_US.ppd      \
        $(PPD)\DECLN_US.ppd $(PPD)\DECLP_US.ppd $(PPD)\DJ1200C3.PPD
PPD05 = $(PPD)\DP470_US.ppd $(PPD)\EPL75523.ppd $(PPD)\FS-1600.ppd       \
        $(PPD)\FS-16002.ppd $(PPD)\FS-1600A.ppd $(PPD)\FS-3400.ppd
PPD06 = $(PPD)\FS-3400A.ppd $(PPD)\FS-3600.ppd  $(PPD)\FS-36002.ppd      \
        $(PPD)\FS-3600A.ppd $(PPD)\FS-6500.ppd  $(PPD)\FS-6500A.ppd
PPD07 = $(PPD)\FS-850A.ppd  $(PPD)\FS1600A2.ppd $(PPD)\FS3600A2.ppd      \
        $(PPD)\FS_1500.ppd  $(PPD)\FS_1500A.ppd $(PPD)\FS_1550.ppd
PPD08 = $(PPD)\FS_1550A.ppd $(PPD)\FS_3500.ppd  $(PPD)\FS_3500A.ppd      \
        $(PPD)\FS_400.ppd   $(PPD)\FS_400A.ppd  $(PPD)\FS_5500.ppd
PPD09 = $(PPD)\FS_5500A.ppd $(PPD)\FS_850.ppd   $(PPD)\GENER_US.ppd      \
        $(PPD)\HL_10H.ppd   $(PPD)\HL_10PS.PPD  $(PPD)\HL_1260.ppd
PPD10 = $(PPD)\HL_4PS.ppd   $(PPD)\HL_8PS.ppd   $(PPD)\HP1600C1.PPD      \
        $(PPD)\HP3DL2.PPD   $(PPD)\HP3L2.PPD    $(PPD)\HP3PL2.PPD
PPD11 = $(PPD)\HP3SI523.ppd $(PPD)\HP4SI_30.ppd $(PPD)\HPIID522.ppd      \
        $(PPD)\HPIII522.ppd $(PPD)\HPIIP522.ppd $(PPD)\HPLJ4ML3.ppd
PPD12 = $(PPD)\HPLJ4MP4.ppd $(PPD)\HPLJ4MV1.ppd $(PPD)\HPLJ4_30.PPD      \
        $(PPD)\HPLJ5P_1.PPD $(PPD)\HPPJXL3.PPD  $(PPD)\HP_3D522.ppd
PPD13 = $(PPD)\HP_3P522.ppd $(PPD)\HP_650C1.PPD $(PPD)\HP__CLJ1.ppd      \
        $(PPD)\HS_1PS.ppd   $(PPD)\HS_1PS2.ppd  $(PPD)\IBM20_US.ppd
PPD14 = $(PPD)\IBM30_US.ppd $(PPD)\IBM31_US.ppd $(PPD)\IBM4079.PPD       \
        $(PPD)\IIPX.ppd     $(PPD)\IMAGESER.ppd $(PPD)\L1_380US.ppd
PPD15 = $(PPD)\L1_425US.ppd $(PPD)\L2_471US.ppd $(PPD)\L2_493US.ppd      \
        $(PPD)\L3_470US.ppd $(PPD)\L3_471US.ppd $(PPD)\L3_493US.ppd
PPD16 = $(PPD)\L5_493US.ppd $(PPD)\LW_NTXUS.ppd $(PPD)\LW_NT_US.ppd      \
        $(PPD)\N2090522.ppd $(PPD)\N2290520.ppd $(PPD)\N890X505.ppd
PPD17 = $(PPD)\NCOL_519.ppd $(PPD)\NEC470US.ppd $(PPD)\OKOL8701.ppd      \
        $(PPD)\OL830525.ppd $(PPD)\OL840518.ppd $(PPD)\OL850525.ppd
PPD18 = $(PPD)\OLIV50US.ppd $(PPD)\P3954101.ppd $(PPD)\P4455514.ppd      \
        $(PPD)\PAP54101.ppd $(PPD)\PERS_CP.ppd  $(PPD)\P_2000.ppd
PPD19 = $(PPD)\Q860PLS2.PPD $(PPD)\QCS1000.PPD  $(PPD)\QCS10002.ppd      \
        $(PPD)\QCS10010.ppd $(PPD)\QCS10030.ppd $(PPD)\QCSM30SI.ppd
PPD20 = $(PPD)\QMS1725.PPD  $(PPD)\QMS2025.PPD  $(PPD)\QMS3225.PPD       \
        $(PPD)\QMS3825e.ppd  $(PPD)\QMS420.PPD   $(PPD)\QMS4525.PPD
PPD21 = $(PPD)\QMSCS210.PPD $(PPD)\QMSCS230.PPD $(PPD)\QMSCS_US.ppd      \
        $(PPD)\QPS1500.ppd  $(PPD)\QPS2000.ppd  $(PPD)\QPS2200.ppd
PPD22 = $(PPD)\QPS2210.ppd  $(PPD)\QPS2220.ppd  $(PPD)\QPS410.ppd        \
        $(PPD)\QPS800.ppd   $(PPD)\QPS800P.ppd  $(PPD)\QPS810.ppd
PPD23 = $(PPD)\QPS810T.ppd  $(PPD)\QPS815.ppd   $(PPD)\QPS815MR.ppd      \
        $(PPD)\QPS820.ppd   $(PPD)\QPS820T.ppd  $(PPD)\QPS825.ppd
PPD24 = $(PPD)\QPS825MR.ppd $(PPD)\QUME47US.ppd $(PPD)\Q_8010.ppd        \
        $(PPD)\SEIKO_04.ppd $(PPD)\SEIKO_14.ppd $(PPD)\SHTFDRUS.ppd
PPD25 = $(PPD)\SKPSFCD1.ppd $(PPD)\STAR_LS5.ppd $(PPD)\T1513470.ppd      \
        $(PPD)\TEK_CPUS.ppd $(PPD)\TI08__US.ppd $(PPD)\TI15__US.ppd
PPD26 = $(PPD)\TIL23521.ppd $(PPD)\TIM17521.ppd $(PPD)\TIM35521.ppd      \
        $(PPD)\TIMLP231.ppd $(PPD)\TK200171.PPD $(PPD)\TK200391.PPD
PPD27 = $(PPD)\TKP200I1.PPD $(PPD)\TKPH2SD1.PPD $(PPD)\TKPH4401.ppd      \
        $(PPD)\TKPHZR21.ppd $(PPD)\TKPHZR31.ppd $(PPD)\TKPXE171.PPD
PPD28 = $(PPD)\TKPXE391.PPD $(PPD)\VT600_US.ppd $(PPD)\WANG15US.ppd      \
        $(PPD)\WANGFPUS.ppd $(PPD)\cc6603ps.ppd $(PPD)\cc6613ps.ppd
PPD29 = $(PPD)\cc6613xf.ppd $(PPD)\cp_pse31.ppd $(PPD)\cpqpm153.ppd      \
        $(PPD)\cpqpm203.ppd $(PPD)\dclf02_1.ppd $(PPD)\dclf02f1.ppd
PPD30 = $(PPD)\ep826051.ppd $(PPD)\hp4plus3.ppd $(PPD)\hp4plus6.ppd      \
        $(PPD)\hplj4ml4.ppd $(PPD)\ibm4039p.ppd $(PPD)\lex4039p.ppd
PPD31 = $(PPD)\lexoptra.ppd $(PPD)\loptrac.ppd  $(PPD)\nc62p__1.ppd      \
        $(PPD)\nc95___1.ppd $(PPD)\nc95f__1.ppd $(PPD)\nc97f__1.ppd
PPD32 = $(PPD)\nc_10971.ppd $(PPD)\ncps40_1.ppd $(PPD)\ncps80_1.ppd      \
        $(PPD)\q1000mc2.ppd $(PPD)\q1700524.ppd $(PPD)\q860psys.ppd
PPD33 = $(PPD)\qms10602.ppd $(PPD)\qms16602.ppd $(PPD)\t1535470.ppd      \
        $(PPD)\timlp672.ppd $(PPD)\timp3232.ppd $(PPD)\timpe231.ppd
PPD34 = $(PPD)\titrb161.ppd $(PPD)\titrbo61.ppd $(PPD)\titrbo91.ppd      \
        $(PPD)\tix17521.ppd $(PPD)\tix35521.ppd $(PPD)\tk220171.ppd
PPD35 = $(PPD)\tk220391.ppd $(PPD)\tk240171.ppd $(PPD)\tk240391.ppd      \
        $(PPD)\tk340171.ppd $(PPD)\tk340391.ppd $(PPD)\tk340691.ppd
PPD36 = $(PPD)\tk340ja1.ppd $(PPD)\tk340jb1.ppd $(PPD)\tkp200j1.ppd      \
        $(PPD)\tkp220i1.ppd $(PPD)\tkp220j1.ppd $(PPD)\tkp2sdj1.ppd
PPD37 = $(PPD)\tkp2sdx1.ppd $(PPD)\tkp300i1.ppd $(PPD)\tkp300j1.ppd      \
        $(PPD)\tkp340j1.ppd $(PPD)\tkp480j1.ppd $(PPD)\tkp540j1.ppd
PPD38 = $(PPD)\tkp540p1.ppd $(PPD)\tkph4801.ppd $(PPD)\tkph5401.ppd      \
        $(PPD)\tkphpx.ppd   $(PPD)\tkphpxi1.ppd $(PPD)\tkphz2j1.ppd
PPD39 = $(PPD)\tkphz3j1.ppd $(PPD)\xr049151.ppd $(PPD)\xr049201.ppd      \
        $(PPD)\xr_42201.ppd $(PPD)\xr_45051.ppd $(PPD)\xr_45201.ppd
PPD40 = $(PPD)\xr_49001.ppd $(PPD)\xrx4215.ppd  $(PPD)\xrx4219.ppd       \
        $(PPD)\aplw3601.ppd $(PPD)\aplwcob1.ppd $(PPD)\aplwgri1.ppd
PPD41 = $(PPD)\qms2425d.ppd $(PPD)\qms3825e.ppd $(PPD)\qmsmccx.ppd       \
        $(PPD)\x4517.ppd    $(PPD)\hplj5m_4.ppd $(PPD)\tk300xp1.ppd
PPD42 = $(PPD)\tk350171.ppd $(PPD)\tk350691.ppd






PPDS = $(PPD01) $(PPD02) $(PPD03) $(PPD04) $(PPD05) $(PPD06) $(PPD07)   \
       $(PPD08) $(PPD09) $(PPD10) $(PPD11) $(PPD12) $(PPD13) $(PPD14)   \
       $(PPD15) $(PPD16) $(PPD17) $(PPD18) $(PPD19) $(PPD20) $(PPD21)   \
       $(PPD22) $(PPD23) $(PPD24) $(PPD25) $(PPD26) $(PPD27) $(PPD28)   \
       $(PPD29) $(PPD30) $(PPD31) $(PPD32) $(PPD33) $(PPD34) $(PPD35)   \
       $(PPD36) $(PPD37) $(PPD38) $(PPD39) $(PPD40) $(PPD41)



#-----------------------------------------------------------------------------
# The all target is used to specify a list of targets that need to be built
#Please don't delete "dep" from the target list.  It is used to generate the
#depend.mak file
#Please look at the example for more details.
#-----------------------------------------------------------------------------


all: dep paths buildres $(OUTDIR)\$(PS_DRV_NAME).$(EXT)
#all: dep paths makeres $(OUTDIR)\$(PS_DRV_NAME).$(EXT)
#all: paths buildres $(OUTDIR)\$(PS_DRV_NAME).$(EXT)

nodep: paths buildres $(OUTDIR)\$(PS_DRV_NAME).$(EXT)

paths:
  -makepath $(OUTDIR) $(MRIOUT) $(PRDESC)


#------------------------------------------------------------------------------
# General Resource building
#------------------------------------------------------------------------------

# Need to get makefile in os2c mode for resources
# toolsmode shoud hace the mode fo building tools
TOOLSMODE = retos2c

makeres:
!if "$(TARGET_PROC)"!="$(TOOLSMODE)"
  @echo switching to $(TOOLSMODE) to make tools
  @set TOOLSFLAG=
  $(MAKE) $(MAKE_OPTS) -f $(MAKEFILE_NAME) OPT=$(TOOLSMODE) /NOLOGO buildres
!else
  buildres
!endif

BUILT_RES =  $(AFMOUT)\fntremap.txt $(DATAPATH)\makevect.out \
             $(PPBPATH)\directry.ppb $(PPBPATH)\ppbs.rc \
             $(AFMOUT)\psfont.rc $(AFMOUT)\fontres.h

buildres: tools_paths $(BUILT_RES)
  @echo Tools Built!

tools_paths:
  -makepath $(DATAINC) $(PPDBIN) $(PPBPATH) $(AFMBIN) $(AFMOUT)

#Flag files
FLAG_FILES = $(DATAPATH)\fntremap.out $(DATAPATH)\$(PS_DRV_NAME).out \
             $(DATAPATH)\ppd2bin.out $(DATAPATH)\fontprep.out


$(FLAG_FILES):


# Make fntremap.txt
$(AFMOUT)\fntremap.txt: $(AFMBIN)\fntremap.exe
  cd $(AFMSRC)
  $(AFMBIN)\fntremap -d$(AFMOUT)
  @echo Ran fntremap > $(DATAPATH)\fntremap.out
  cd $(PS_SRC)

$(AFMBIN)\fntremap.exe: $(AFMSRC)\fntremap.c $(PS_INC)\mapping.h
  cd $(AFMSRC)
  $(CC) $(TOOLS_OPT) fntremap.c
  cd $(PS_SRC)


# Make the table for hooking engine

$(DATAPATH)\makevect.out: $(O)\makevect.exe $(R_OS2_HDR)\pmddim.h
  $(O)\makevect $(R_OS2_HDR)\pmddim.h $(DATAINC)
  @echo Ran makevect > $(DATAPATH)\makevect.out

$(O)\makevect.exe: makevect.c $(R_OS2_HDR)\pmddim.h
  $(CC) $(TOOLS_OPT) makevect.c


# Make the PPBs

$(PPBPATH)\directry.ppb: $(PPDBIN)\ppd2bin.exe $(PPDSRC)\ppdfile.lst $(PPDS)
  cd $(PPDPATH)
  $(PPDBIN)\ppd2bin -i $(PPDSRC)\ppdfile.lst -o $(PPBPATH)\ -g gener_us  -p$(MRIPATH)
  @echo Ran ppd2bin > $(DATAPATH)\ppd2bin.out
  cd $(PS_SRC)

$(PPBPATH)\ppbs.rc:
#This is a dummy entry to keep nmake happy.  When directry.ppb is built
#it will take care of this

# Make PPD compiler

$(PPDBIN)\ppd2bin.exe: $(PPDSRC)\ppd2bin.h $(PPDSRC)\ppd2bin.c \
                       $(PS_INC)\ppdialog.h $(AFMOUT)\fontres.h \
                       $(PS_INC)\ppdtable.h $(PPBPATH)\drvname.h
  cd $(PPDSRC)
  $(CC) $(TOOLS_OPT) $(PPDDEBUG) ppd2bin.c
  cd $(PS_SRC)

$(PPBPATH)\drvname.h:  makefile
    @echo  @<<$(PPBPATH)\drvname.h
#define PSCRIPT_DRV_NAME    "$(PS_DEF_NAME)"
<<KEEP
   if exist $(O_NLV)\*.obj del $(O_NLV)\*.obj

# Make the PFMs

$(AFMOUT)\fontres.h $(AFMOUT)\psfont.rc: $(AFMBIN)\afm2bin.exe \
                                         $(AFMBIN)\fontprep.exe $(AFMS)
  cd $(AFMSRC)
  $(AFMBIN)\fontprep -d$(AFMOUT) -e$(AFMBIN)
  -copy $(AFMOUT)\fontres.h $(DATAINC)\fontres.h
  @echo Ran fontprep > $(DATAPATH)\fontprep.out
  cd $(PS_SRC)

# Make the tools

$(AFMBIN)\fontprep.exe: $(AFMSRC)\fontprep.h $(AFMSRC)\fontprep.c
  cd $(AFMSRC)
  $(CC) $(TOOLS_OPT) fontprep.c
  cd $(PS_SRC)

$(AFMBIN)\afm2bin.exe: $(AFMSRC)\afm2bin.h $(AFMSRC)\afm2bin.c
  cd $(AFMSRC)
  $(CC) $(TOOLS_OPT) afm2bin.c
  cd $(PS_SRC)



# For OEM support
!ifndef ddkbld
OEMDLG  = psoem.dlg
OEMDLGp = $(MRIPATH)\$(OEMDLG)
OEMDLGc = + $(OEMDLGp)
OEMRC   = psoem.rc
OEMRCp  = $(MRIPATH)\$(OEMRC)
OEMRCc  = + $(OEMRCp)
!endif

#$(MRIOUT)\pscript.rc: $(MRIPATH)\postscr.rc $(AFMOUT)\psfont.rc \
#                      $(PPBPATH)\ppbs.rc
$(MRIOUT)\pscript.rc: $(MRIPATH)\postscr.rc $(DATAPATH)\fontprep.out \
                      $(DATAPATH)\ppd2bin.out  $(PPBPATH)\drvname.h
  copy $(MRIPATH)\postscr.rc $(OEMRCc) + $(AFMOUT)\psfont.rc + $(PPBPATH)\ppbs.rc \
       $(MRIOUT)\pscript.rc
  @echo icon 01 "laser.ico"  >> $(MRIOUT)\pscript.rc
  @echo Ran pscript > $(DATAPATH)\$(PS_DRV_NAME).out


RESOURCES = $(FLAG_FILES) $(MRIPATH)\config.dlg \
            $(PS_INC)\config.h $(PS_INC)\fremap.h \
            laser.ico $(MRIOUT)\pscript.rc $(OEMDLGp) \
            $(OUTDIR)\$(PS_DRV_NAME).hlp $(GPLMRI)\gplnup.rc \
            $(GPLMRI)\gplwm.rc

#
# Build Resource File for PPC
#
$(MRIOUT)\$(PS_DRV_NAME).o: $(RESOURCES)
  copy $(MRIPATH)\config.dlg $(OEMDLGc) $(DATAPATH)
  copy $(GPLMRI)\gpl*.rc
##mres $(MRIOUT)\pscript.rc,,,$(MRIOUT)\$(PS_DRV_NAME).o
  mres  -As,$(MRIOUT)\pscript.rc -- $(MRIOUT)\$(PS_DRV_NAME).o
  -del $(DATAPATH)\config.dlg
  -del gpl*.rc

#
# Build Resource File for OS2C
#
$(MRIOUT)\$(PS_DRV_NAME).res: $(RESOURCES)
  copy $(MRIPATH)\config.dlg $(OEMDLGc) $(DATAPATH)
  copy $(GPLMRI)\gpl*.rc
  rc -r -i . $(MRIOUT)\pscript.rc $(MRIOUT)\$(PS_DRV_NAME).res
  -del $(DATAPATH)\config.dlg
  -del gpl*.rc

$(OUTDIR)\$(PS_DRV_NAME).hlp: $(MRIPATH)\pscript.itl
  cd $(MRIPATH)
  ipfc /L:$(L) /C:$(P) /D:$(C) $(MRIPATH)\pscript.itl $(OUTDIR)\$(PS_DRV_NAME).hlp
  cd $(PS_SRC)

$(OUTDIR)\$(PS_DRV_NAME).$(EXT): makefile $(PSOBJS) $(O)\$(PS_DRV_NAME).def $(LINKLIBS)  \
                       $(PS_SRC)\pkgps.cmd $(RESFILE) $(ODCOMMON)\version.mak
!if "$(TARGET_PROC)"=="ppc"
##################################### PPC ####################################
       $(LINK) $(DLL_LFLAGS) @<<$(O)\pscript.lnk
$(DLL_INIT)
$(PSOBJS: =^
)
$(HCLIB)
-L$(O)\..\..\GENPLIB
-lgenp
$(CRT_VER_LIB)
-los2
-los2p
$(DLL_FINI)
-o $(OUTDIR)\$(@B).$(EXT)
-i $(O)\$(PS_DRV_NAME).def
<<keep
    pkgps $(_VERSION21) $@ $(PPBPATH)\directry.ppb  $(PRDESC)\pscript.tmp $(PS_DEF_NAME)
    -sed /.DRV/s//.PRV/ $(PRDESC)\pscript.tmp > $(PRDESC)\pscript.lst
    -erase $(PRDESC)\pscript.tmp

$(PS_DRV_NAME).dbg: $(OUTDIR)\$(PS_DRV_NAME).$(EXT)
  elfstrip -o $(OUTDIR)\$(PS_DRV_NAME).dbg $(OUTDIR)\$(PS_DRV_NAME).$(EXT)
  pkgps $(_VERSION21) $(OUTDIR)\$(PS_DRV_NAME).dbg $(PPBPATH)\directry.ppb \
  $(PRDESC)\pscript.lst $(PS_DRV_NAME)

# $(FILEVER) required to include file version in descript (see VERSION.MAK).
$(O)\$(PS_DRV_NAME).def: makefile
  @echo Writing new  @<<$(O)\$(PS_DRV_NAME).def
LIBRARY $(PS_DEF_NAME)  INITINSTANCE  TERMINSTANCE
DESCRIPTION '$(FILEVER) POSTSCRIPT PRINTER DEVICE DRIVER DYNA-LINK'
PROTMODE

SEGMENTS
  global      CLASS  'DATA' SHARED
  perprocess  CLASS  'DATA' NONSHARED

EXPORTS
        OS2_PM_DRV_ENABLE           @200
        OS2_PM_DRV_DEVMODE          @201
        OS2_PM_DRV_DEVICENAMES      @202
        QueryDeviceSurface          @203
        QueryTunerProcData          @204
        OS2_PM_DRV_POSTESCAPE       @206

IMPORTS
        GetDriverInfo      = PMGRE.37
        SetDriverInfo      = PMGRE.38
        Debug32Output      = PMWIN.955
<<KEEP

!else
################################# OS2Classic #################################
       $(LINK) $(LFLAGS) $(LDFLAGS) @<<$(O)\pscript.lnk
$(PSOBJS:.obj=.obj+
)
$(@)
$(O)\$(PS_DRV_NAME).map
$(LINKLIBS)
$(O)\$(PS_DRV_NAME).def
<<keep
  $(RC) $(MRIOUT)\$(PS_DRV_NAME).res $(@)
  cd $(OUTDIR)
  $(MAPSYM) $(O)\$(PS_DRV_NAME).map
  cd $(PS_SRC)
  pkgps $(_VERSION21) $@ $(PPBPATH)\directry.ppb  $(PRDESC)\pscript.lst $(PS_DEF_NAME)
  eautil $(OUTDIR)\$(PS_DRV_NAME).$(EXT) $(OUTDIR)\$(PS_DRV_NAME).ea /s /r /p

$(O)\$(PS_DRV_NAME).def: makefile
  @echo Writing new  @<<$(O)\$(PS_DRV_NAME).def
LIBRARY $(PS_DEF_NAME)  INITINSTANCE  TERMINSTANCE
DESCRIPTION 'PRINTER DEVICE DRIVER DYNA-LINK'
PROTMODE
DATA SINGLE READWRITE LOADONCALL
CODE LOADONCALL

SEGMENTS
  DDE4_DATA32 CLASS  'DATA' NONSHARED
  global      CLASS  'DATA' SHARED
  perprocess  CLASS  'DATA' NONSHARED

EXPORTS
        OS2_PM_DRV_ENABLE           @200
        OS2_PM_DRV_DEVMODE          @201
        OS2_PM_DRV_DEVICENAMES      @202
        QueryDeviceSurface          @203
        QueryTunerProcData          @204
        OS2_PM_DRV_POSTESCAPE       @206

IMPORTS
        GetDriverInfo      = PMGRE.37
        SetDriverInfo      = PMGRE.38
        Debug32Output      = PMWIN.955
        DosQueryModFromEIP = DOSCALL1.360
<<KEEP

!endif

# 143708 - Remove WinCallHelpHook.  Go back to Win16CallHelpHook.
#       WinCallHelpHook    = PMWIN.288

#***************************************************************************
# Include Footer.mak at this point.
#***************************************************************************

!include $(ROOT)\footer.mak

#****************************************************************************
#  Dependency generation and Checking
#****************************************************************************

# Includes is currently commented out for test purposes.

$(O)\depend.mak:  $(O)\dephold
        -$(CREATE_PATH)
        -$(TOUCH) $(O)\depchk
        -echo generate depend.mak
        makedep -A -DPS -TP $(O) $(HCINC:-I=-I ) -o $@ *.c
        -del $(O)\depchk
        -compare $(PS_DRV_NAME) $(PS_DEF_NAME)

$(O)\dephold:
        -$(TOUCH) $@

clean:
        -echo y | del $(O)\*
