/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDTEXTF.H
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : Printer Device Driver external files for Text routines
 *
 *
 * FUNCTIONS
 *
 *
 * NOTES       : Reference - Device Driver Interface Specification
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
#pragma pack(1)


/*
**  these declare private driver font subroutines public to all driver
**  functions.  The functions are located in PRDTSUBR.C
*/

PFONTDEF prda_LoadFontResource (PDDC, SHORT) ;
BOOL     prda_CheckFontResource (PDDC);
SHORT    prda_NumPrinterFonts (PDDC) ;
SHORT    prda_DefaultFontIndex (PDDC) ;
SHORT    prda_MatchFaceName (PSZ, PDDC);
void     prda_CopyMetrics (PFONTMETRICS, PFONTMETRICS, ULONG, LONG, PDDC) ;
LONG     prda_GetKernAmount (SHORT, SHORT, PDDC) ;
SHORT    prda_BackMapChar (SHORT, PDDC) ;
LONG     prda_RemapString (PCH, LONG, PDDC) ;
SHORT    prda_QuoteChar (PDDC, PCH, BYTE, SHORT) ;
void     prda_DrawLine (PDDC, POINTL, LONG, LONG) ;
void     prda_ComputeTextTransformMatrix (PDDC) ;
void     prda_FontTransform (PPOINTL, PDDC) ;

/*
** The following assembler functions are pulled from the engine.
*/

extern void  _System CopyAndNormalize (XFORM *, MATRIX *) ;
extern BOOL  TransformPoints (MATRIX *, POINTL *, SHORT) ;

/*
** the following function vectors are declared in PRDEVECT.C and
** point to the engine's default text function handlers.  The driver
** calles them when the engine wants to simulate vector fonts.
*/

extern PFNL pfnlCharStringPos;
extern PFNL pfnlCharString;
extern PFNL pfnlQueryTextBox;
extern PFNL pfnlQueryCharPositions;
extern PFNL pfnlGetPairKerningTable ;
extern PFNL pfnlQueryWidthTable;
extern PFNL pfnlSetAttributes;


/*
    This table maps PM line end styles to PostScript linecap values
*/
static short aiLineCap[] = {0, 0, 2, 1};

/*
    This table maps PM line join styles to PostScript linejoin values
*/
static short aiLineJoin[] = {2, 2, 1, 0};

/*
** macros for getting/setting font remapping information.  font lcids
** are legal from 1 thru 254.  pddc->pddcb->cgs.bFontRemap allows one bit
** per lcid which tells whether the font for the given lcid has been
** remapped.
*/

#define QueryFontRemap(a) (pddc->pddcb->cgs.bFontRemap[a>>3] & (1<<(a&7)))
#define SetFontRemap(a) (pddc->pddcb->cgs.bFontRemap[a>>3] |= (1<<(a&7)))
#define ClearFontRemap(a) (pddc->pddcb->cgs.bFontRemap[a>>3] &= ~(1<<(a&7)))

#define MIN_FONT_LCID   1L
#define MAX_FONT_LCID   255L
