/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "src/prntdd/pscript/inc/prdmacro.h, postscript, osdd, 13.355 90/08/21";*/
/**********************************************************************/
/*								      */
/*   Module	     = PRDMACRO 				      */
/*								      */
/*   Description     = Printer Device Driver macros		      */
/*								      */
/*   Function	     = Include file defining C macros		      */
/*								      */
/*   Reference	     = Winthorn Functional Specification	      */
/*		       Device Driver Interface Specification	      */
/*		       Printer Device Driver Design Specification     */
/*								      */
/*								      */
/**********************************************************************/
#pragma pack(1) 

/**********************************************************************/
/* abs(x) : returns the absolute value of x (x must be signed)	      */
/**********************************************************************/
#define abs(x) ((x)<0?(-x):(x))

/**********************************************************************/
/* RotateLeft(x) : returns byte x rotated one bit left		      */
/**********************************************************************/
/* KH SEA6 */
#define RotateLeft(x)		      \
	(((x) & 0x80)?((x)<<1)|0x01:(x)<<1)
/* KH SEA6 */
/**********************************************************************/
/* max(x,y) : returns whichever of x and y has the higher value       */
/**********************************************************************/
/* #define max(x,y) (x)>(y)?(x):(y)
 */
/**********************************************************************/
/* min(x,y) : returns whichever of x and y has the lower value	      */
/**********************************************************************/
/* #define min(x,y) (x)<(y)?(x):(y)
 */

/**********************************************************************/
/* macro which will clear a RAM semaphore			      */
/**********************************************************************/
#define ClearSemaphore(x) \
    (void)DosSemClear((void far *)(x))

/**********************************************************************/
/* macro which will do the exchange of our routine's addresses        */
/* and the engine's default handlers.                                 */
/**********************************************************************/
# define ExchangeDispatch(MyAddress, EngineAddress)	\
    p_Disp_Entry = ((param2->DispTab) +       \
		    (EngineAddress & 0xFFL));		\
    Temp = *p_Disp_Entry;				\
    (PFNL)*p_Disp_Entry = MyAddress;			\
    (ULONG)MyAddress = Temp;

# define CopyDispatch(MyAddress, EngineAddress)     \
    p_Disp_Entry = ((param2->DispTab) +       \
		    (EngineAddress & 0xFFL));		\
    Temp = *p_Disp_Entry;				\
    (ULONG)MyAddress = Temp;
