/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "src/prntdd/pscript/inc/prdjcone.h, postscript, osdd, 13.355 90/08/21";*/

/**********************************************************************/
/*								      */
/*   File	     = PRDICONE 				      */
/*								      */
/*   Description     = Printer Device Driver clipping constants       */
/*								      */
/*   Function	     =						      */
/*								      */
/*   Reference	     = Device Driver Interface Specification	      */
/*								      */
/*								      */
/**********************************************************************/
#pragma pack(1) 

/**********************************************************************/
/* Error codes							      */
/**********************************************************************/
#define PRDJERR 	     600
#define BAD_CREATE_JOURNAL   PRDJERR+1 /* cannot create GRE journal   */
#define BAD_START_JOURNAL    PRDJERR+2 /* cannot start GRE journal    */
#define BAD_STOP_JOURNAL     PRDJERR+3 /* cannot stop GRE journal     */
#define BAD_PLAY_JOURNAL     PRDJERR+4 /* cannot play GRE journal     */
#define BAD_DELETE_JOURNAL   PRDJERR+5 /* cannot delete GRE journal   */
#define MAKE_BAND_FAILED     PRDJERR+6 /* failed to make a new band   */
#define NO_JOURNAL_NAMES     PRDJERR+7 /* failed to open a permanent  */
				       /* journal file for ESC spool  */
#define ESC_SPOOL_FAIL	     PRDJERR+8 /* failed to create an ESC     */
				       /* format spool file	      */
#define BAD_OPEN_JOURNAL     PRDJERR+9 /* failed to dosopen permanent */
				       /* journal file		      */
#define BAD_JOURNAL_READ    PRDJERR+10 /* failed to read a record     */
				       /* from journal file	      */
#define ERR_SPOOL_MAKE	    PRDJERR+11 /* error making spool file     */
#define BAD_SPOOL_WRITE     PRDJERR+12 /* error writing to spool file */
#define BAD_SPOOL_ENDDOC    PRDJERR+13 /* error on SplQmEndDoc	      */
#define ERR_SPOOL_STARTDOC  PRDJERR+14 /* error on SplQmStartDoc      */
#define BAD_CLOSE_JOURNAL   PRDJERR+15 /* failed to dosclose	      */
				       /* permanent journal file      */
#define BAD_OPENJRN_JSTRT   PRDJERR+16 /* failed to dosopen journal   */
				       /* in prdjstrt		      */
#define BAD_CLOSE_JRN_END   PRDJERR+17 /* failed to dosopen journal   */
				       /* in prdjstrt		      */
#define BAD_ESC_PLAY_JRN    PRDJERR+18 /* bad replay of journal made  */
				       /* using doswrites	      */
#define FAIL_OPEN_JOURNAL   PRDJERR+19 /* bad open of journal for     */
				       /* direct esc format DC	      */
#define BAD_RAWSPOOL_WRITE  PRDJERR+20 /* bad SplQmWrite to raw       */
				       /* format spool file	      */

/**********************************************************************/
/* Length of buffer used for reading permanent journal file	      */
/**********************************************************************/
#define BUFFER_LENGTH	     100       /* buffer length 	      */

/**********************************************************************/
/* Spool file formats						      */
/**********************************************************************/
#define IBM_Q_STD	     1	       /* device independent format   */
#define IBM_Q_ESC	     2	       /* device independent format   */
#define IBM_Q_RAW	     3	       /* raw format		      */
