/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDDCT.H
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : Printer Device Driver DC types
 *
 * FUNCTIONS
 *
 * NOTES       : Reference - Device Driver Interface Specification
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#pragma pack(1)

#include <gpledc.h>
#include <fontmgr.h>
/*
** Type definitions for the DC Instance Data and the Device Driver's
** view of DC.
*/

/*
**  ---------- DEFINES ---------------
*/
/*
** @V4.0169885
** Instead of using PSCRIPT.DLL, use PSCRIPT_DRV_NAME, in DRVNAME.H.  In the
** event the driver name is changed, PSCRIPT_DRV_NAME will be automatically
** updated to reflect that change.
*/
//#define PSCRIPT_DLL     "PSCRIPT"   /* The device driver name (.drv name) */

/*
**  The number of operator classes in utlps.c
*/
#define N_PS_OPERATORS   12
#define IGSMAX           10         /* The maximum depth of the gsave stack */
//@V3.0105712
//#define N_MAXCOLORS      64
#define N_MAXCOLORS     261         /* The maximum color table size         */
#define DRIVER_ID      0x41444245L  /* "ADBE" = driver id */
#define MAX_FONT_LCID   255L

/*
**  --- from prdpbseg.c
*/
#define PATH_BUF_INIT_SIZE (16*1024L)
#define PATH_BUF_SIZE_EMPTY 0xFFFFL

/*
**  --- from patfill.c
*/
#define FX_ONEHALF 0x8000L
#define FX_TWO     0x20000L
#define FILLFONTLOADED  1L          /* These bits are to keep track of user   */
#define FILLFONTSAVED   4L          /* define patterns. 1,2 and 16 define the */
#define BASEPATLOADED   2L          /* particular pattern. 4,8 and 32 will    */
#define BASEPATSAVED    8L          /* keep track in the case of new pages.   */
#define LOGFONTLOADED  16L          /* In the case of new page the pattern    */
/*
**  will be redefine at the top of the stack to prevent loosing them at
*/
#define LOGFONTSAVED   32L

#define PF_ENDAREA      1           /* Is the path fill for an EndArea     */
#define PF_BLT_ATTRS    2           /* Override with bitblt attributes     */

typedef struct _MATRIX
{
    FIXED   mx_fxM11;
    FIXED   mx_fxM12;
    FIXED   mx_fxM21;
    FIXED   mx_fxM22;
    LONG    mx_lM41;
    LONG    mx_lM42;
    SHORT  mx_usfracM41;
    SHORT  mx_usfracM42;
    SHORT  mx_flags;
    SHORT  mx_unused;
} MATRIX;


#define  CP_LIMIT      10
#define  CP_LIMIT_MINUS_ONE CP_LIMIT - 1

#define  CP_NOOFM      1
#define  CP_OFM        2
#define  CP_UNICODE    3

typedef struct _CGSCP
{
    USHORT  usCP;
    CHAR    szCPName[16];
    USHORT  usCPType;
    USHORT  usCPVector[256]; /* CodePage vectors */
} CGSCP, PCGSCP;

/*
**  a place to store the current graphics state.
*/

typedef struct _CGS
{
    BOOL    fPathExists;        /* true if path exists in printer.         */
    BOOL    fValidCP;           /* False if the CP needs to be updated.    */
    BOOL    fUpdateCP;          /* true if we need a moveto to sync        */
    BOOL    fFRedefDownld ;     /* TRUE if font redef routine downloaded   */
    BOOL    fValidFont;         /* TRUE if the font doesn't need updating  */
    BOOL    fOutlineDefined;    /* TRUE if outline font code downloaded.   */
    BOOL    fCurvesInPath;      /* TRUE if any curve in current path.      */
    XFORM   xformCTM;           /* The current transform matrix            */

    SHORT   usLineJoin;
    SHORT   usLineCap;
    SHORT   usLineType;
    BOOL    fIsGeometric;       /* TRUE if the line width is geometric  */
    BOOL    fFullArcInPath;
    FIXED   fxLineWidth;
    LONG    lColor;             /* Current RGB color */

    SHORT   usSelection;        /* Selection from FATTRS */
    FIXED   fxFontWidth;        /* The font width */
    FIXED   fxFontHeight;       /* The font height */
    FIXED   fxFontShear;        /* The font shear */
    FIXED   fxFontAngleX;       /* The font angle */
    FIXED   fxFontAngleY;       /* The font angle */
    char    szFont[80];         /* The PostScript font name */
    /*
    **  one bit for each of the 254 logical fonts, telling whether the
    **  font has been remapped.
    */
    BYTE    bFontRemap[32];
    SHORT   cCodePagesRemapped;
//  SHORT   usCPTable[10];
    SHORT   usNewCPs;       
//  SHORT   usCPVector[10][256]; /* CodePage vectors */
    CGSCP   CPTable[CP_LIMIT];    /* CodePages in printer */
} CGS, *PCGS;



/*
**  Structure to hold info about a logical font that has been realized
*/

typedef struct _LOGFONTINFO
{
    SHORT        sOffset ;      /* Offset of physical font in directory */
    USHORT       usFlags ;
} LOGFONTINFO, *PLOGFONTINFO;   /* lfi */

// Defines for LOGFONTINFO.usFlags
#define LFONT_IN_USE            0x0001
#define LFONT_HAS_KERNING       0x0002
#define LFONT_HAS_UNDERSCORE    0x0004
#define LFONT_HAS_STRIKEOUT     0x0008
#define LFONT_IS_OUTLINE        0x0010
#define LFONT_OUTLINE_NOTDONE   0x0020
#define LFONT_HAS_ITALIC        0x0040                                  //@DBCS
#define LFONT_HAS_BOLD          0x0080                                  //@DBCS
#define LFONT_HAS_BACKUP        0x0100
#define LFONT_IS_SOFTFONT       0x0200
#define LFONT_OUTLINE_DONE      0XFFDF



/*
** Structure to contain all information about a journal file.
*/
typedef struct
{
    SHORT       fhJournal;      /* The journal file handle                 */
    ULONG       hJournal;       /* The journal handle                      */
    char        szJournal[12];  /* The journal file name                   */
} JNL_STATE;


typedef struct _PAT_STATE
{
    ULONG   Null;
    ULONG   ulFgColor;      /* The RGB color value */
    ULONG   ulBgColor;      /* The RGB background color */
    SHORT   usFgMix;        /* The forground mix mode */
    SHORT   usBgMix;        /* The background mix mode */
    SHORT   usSet;
    SHORT   usSymbol;
    POINTL  ptlOrg;         /* The pattern origin */
    SHORT   usfFontLoaded;  /* flag is true if pattern font loaded */
} PAT_STATE;

#define MAX_DBCS_VECTOR     20                                          //@DBCS

typedef struct _TXT_STATE
{
    CHARBUNDLE  ChrBundle;      /* the current character attributes       */
    CHAR        szFont[FACESIZE] ;   /* the currently selected fontname   */
    BOOL        fFontSimulation ;    /* set if engine is to simulate      */
    FIXED       fxXScale ;      /* Cell width divided by 1000             */
    FIXED       fxYScale ;      /* Cell height divided by 1000            */
    FIXED       fxCos ;         /* Cosine of angle of printed text        */
    FIXED       fxSin ;         /* Sine of angle of printed text          */
    FIXED       fxCharExtra ;   /* Extra width to add to non-break chars  */
    FIXED       fxBreakExtra ;  /* Extra width to add to the break char   */
    FIXED       fxErrorCurrentX;/* Current error term in pen placement    */
    FIXED       fxErrorCurrentY;/* Current error term in pen placement    */
    FIXED       fxErrorNewX ;   /* New error term in pen placement        */
    FIXED       fxErrorNewY ;   /* New error term in pen placement        */
    SHORT       usFont ;        /* current font--index in prntr font list */
    SHORT       usCurFontDef ;  /* current font data -- font list index   */
    PFONTDEF    pfdfFontDef ;   /* pointer to font definition resource    */
    SHORT       usDefCodePg ;   /* the default codepage number            */
    PSHORT      pusDefCodePgVector ; /* the corresponding codepage vector */
    PSHORT      pusCurCodePgVector ; /* current codepage vector           */
    BYTE        bFontHasKerning ;    /* 1=Current font has kerning        */
    BYTE        bFontHasUnderscore;
    BYTE        bFontHasStrikeout;
    BYTE        bFontIsOutline;
    BYTE        bLogFontEntry ; /* entry num of font currently in use     */
    LOGFONTINFO lfiEntry[256] ; /* data on logical fonts cur realized     */
    PFONTMETRICS pfmFontMetrics;/* font metrics of the current font in use*/
    MATRIX      transformmatrix;/* the current text transformation matrix */
    BOOL        fUseSoftFont;   
    ULONG       fMoreFlags;     /* @v4.0159651 More font flags            */
    #define       MADE_ITALIC       0x00000001   /* made font italic */
/* DBCS  start */                                                       //@DBCS
    CHAR        szDBCSFont[FACESIZE];
    PFONTDEF    pfdfDBCSFontDef;
    PFONTMETRICS pfmDBCSFontMetrics;
    BOOL        fDispatchDBCS;
    UCHAR       ubDBCSVector[MAX_DBCS_VECTOR];
    UCHAR       ubUserVector[MAX_DBCS_VECTOR]; 
    LONG        lBold;
/* DBCS enabling end   */                                               //@DBCS
    BOOL        fDynamicFont;   // This is Dynamic Font
    PDYNFNT_LIST   prDynFnt;    // Dynamic Font record
    BOOL        fYInversion;    
} TXT_STATE, * PTXT_STATE;

typedef struct _PEN_STATE
{
    POINTL      ptlOrg;         /* The pen origion            */
    POINTL      ptlCur;         /* The current pen location   */
    SHORT       nStyle;         /* line style state & mask     */
    BYTE        StyleXRatio;    /* line style x ratio value    */
    BYTE        StyleYRatio;    /* line style y ratio value    */
    ULONG       TypeMask;

    /* The following fields appear in the line attributes bundle */
    ULONG   ulFgColor;          /* Foreground RGB color */
    SHORT   usFgMix;            /* Foreground mix mode */
    FIXED   fxWidth;            /* Line width */
    LONG    lGeomWidth;         /* Geomentric width */
    SHORT   usType;             /* The line type */
    SHORT   usEnd;              /* The endcap type */
    SHORT   usJoin;             /* The linejoin type */
} PEN_STATE;


typedef struct _PATH_STATE
{
    BOOL    fPathOrArea;        /* TRUE if an area or path is being built */
    BOOL    fPathIsOpen;        /* TRUE if a path is being built */
    BOOL    fAreaIsOpen;        /* TRUE if an area is being built */
    BOOL    fDidClipPath;       /* TRUE if there is a selected clip path */
    BOOL    fDidClipRect;       /* TRUE if a clip rect was done */
    SHORT   uscClipRects;       /* number of clip rects*/
    SHORT   usAreaFlags;        /* The flags passed to BeginArea */
    BOOL    fDrawAreaBorder;    /* TRUE if area borders should be drawn */
    RECTL   rclClip;            /* The clip rectangle */
    POINTL  ptlAreaCP;          /* Begin - EndArea current position */
    ULONG   ulAreaFgColor;      /* The RGB color value at BeginArea time */
    BOOL    fModifiedPath;      /* TRUE if the Path is being modified */
} PATH_STATE;


typedef struct _MARKER_STATE
{
    DMARKERBUNDLE    dmbnd;
    SHORT      usfMFont;       /* TRUE if marker font has been loaded */
} MARKER_STATE;


typedef struct _ARC_STATE
{
    BOOL        fDoingArcArea;  /* TRUE if an arc area is in progress */
    SHORT       usfCW;          /* TRUE if arc drawn clockwise */
    ARCPARAMS   arcparams;      /* arc parameters */
    MATRIX      arcparmmatrix;  /* arc parameter matrix */
    MATRIX      invarcpmatrix;  /* inv arc parameter matrix */
} ARC_STATE;


typedef struct _IMAGE_STATE
{
    ULONG       ulFgColor;     /* The foreground color */
    ULONG       ulBgColor;     /* The background color */
    SHORT       usFgMix;       /* The foreground mix mode */
    SHORT       usBgMix;       /* The backgound mix mode */

    BOOL        fBitsReady;    /* TRUE if bits are already in the buffer */
    HDC         hdcSrc;        /* The source DC handle */
    HBITMAP     hbmSrc;        /* Source bitmap handle */
    int         iySrc;         /* The souce bitmap offset */
    ULONG       bmi[4];        /* Bitmap info */
} IMAGE_STATE;



typedef struct _BOUNDS_STATE
{
    BOOL    fInit;          /* TRUE if the bounds rect should be initialized */
    BOOL    fAccumulate;    /* TRUE if bounds accumulation is turned on */
    RECTL   rcl;            /* The bounds rectangle */
} BOUNDS_STATE;


typedef struct _COLOR_STATE
{
    ULONG   ulMode;         /* The color indexing mode */
    ULONG   ulFormat;       /* The color table format */
    BOOL    fUsePureColor;  /* TRUE if the driver shouldn't use half-tones */
    int     nColors;        /* The number of elements in the color table */
    ULONG   aulColors[N_MAXCOLORS]; /* The color table */
} COLOR_STATE;

/* @V4.0161634
** New Struct for paths
** The X means either path buf or clip path buf
*/
typedef struct _XPATH_BUF
{
  ULONG ulBufSize;          /* Size of buffer including overhead */
  ULONG ulCount;            /* Count of actual bytes in path     */
  BYTE  bPath[1];           /* Start of data area                */
} XPATH_BUF, * PXPATH_BUF;


/*
** The DC header structure contains a dc handle and DC
** type.  The driver looks at the type to determine if
** it is a memory DC.  If its a memory DC then the rest
** of the DC instance data is not present and the
** PostScript driver uses the hdc value to call the
** display driver to do the work on bitmaps.
*/

typedef struct _DDCB
{
    struct _DDCB   *pddcbNext;      /* Ptr to next entry in DDCB chain     */
    XFORM           xformCTM;       /* The current transform matrix        */
    SHORT           usMatrixIndex;  /* index for saving matrices on stack  */
    PAT_STATE       pat;            /* The pattern state.                  */
    JNL_STATE       jnl;            /* The journal state.                  */
    TXT_STATE       text;           /* The text state.                     */
    PEN_STATE       pen;            /* The pen state.                      */
    IMAGE_STATE     image;          /* The image state.                    */
    PATH_STATE      path;           /* The path state.                     */
    MARKER_STATE    mkr;            /* The current marker state.           */
    BOUNDS_STATE    bounds;         /* The accumulate bounds state.        */
    ARC_STATE       arc;            /* The current arc parameter state     */
    COLOR_STATE     color;          /* The color table state.              */
    CGS             cgs;            /* current graphics state.             */
    CHAR            *lpPathBuf;     /* pointer to path buffer              */
    CHAR            *lpPathBufSave; /* Save ptr for lpPathBuf              */
    LONG            lPathBufCount;  /* number of free bytes in path buf    */
    LONG            lPathBufSize;   /* current size of path buff           */

/* @V4.0161634 Use new struct for path */
/// PCHAR           lpClipPathBuf;      /* pointer to clip path buffer       */
/// PCHAR           lpClipPathBufSave;  /* points allocate buffer            */
/// LONG            lClipPathBufCount;  /* # of free bytes in clip path buf  */
/// LONG            lClipPathBufSize;   /* current size of clip path buff    */
    PXPATH_BUF      pClipPathBuf;       /* Pointer to Clip Path buffer       */

    ULONG           ulClipPathOptions;  /* Options (Winding or Alternate).   */
    /*
    **  TRUE if either clip region or clip path in the engine is changed
    **  and the driver is not updated otherwise FALSE. Presently not used.
    */
    BOOL            fClipChanged;
    PEDCFONTDATA    pEDCFontData;   // GPLEDC Need to save copy for each save state

} DDCB,  *PDDCB;

typedef struct _DDC 
{
    /*
    **  patfix (begin) see utlps.c for details
    */
    HDC     patfix_hdc;  /* HDC from COMPLETE_OPEN_DC enabling */
    HRGN    patfix_hrgn; /* Region from ps_startdoc call */
    /*
    **  patfix (end)
    */

    LONG    id;         /* Unique driver id number = 'ADBE' */
    HDC     hdc ;       /* HDC  */
    HDC     hdcMemory;  /* HDC for      shadow memory DC in Display*/
    HRGN    hrgnMemory; /* HRGN for the shadow memory DC Clip region */
    BOOL    fClipChange ; /* TRUE if the RAO of both DC and
                           * the shadow memory DC are out of sync. */
    PDV     pdv;        /* Ptr to the device descriptor.  */
    LONG    iType;      /* The DC type (OD_DIRECT, etc.) */
    HHEAP   hHeap;      /* Heap handle this structure was allocated from */
    SHORT   usHeapSel;  /* Heap selector */
    PID     pid;        /* The process and                               */
    TID     tid;        /* thread that have the DDC locked               */
//  HMTX    ptsemPort;  /* semaphore of port for direct printing         */
    PEDCGENDATA pEDCGenData;
    /*
    **  The number of times our pid/tid has locked this DDC
    */
    SHORT  cLockCount;
    SHORT           usSavedDCs ;    /* The number of saved DC's             */
    SHORT           SavedState;     /* save level in DEVESC_STARTDOC.       */
    ULONG           fhSpool;        /* The spool file handle                */
    BOOL            fENDDOC;        /* TRUE driver currently in enddoc.     */
    BOOL            fDocWasAborted; /* TRUE if an ABORTDOC was received     */
    /*
    **  TRUE if user decided to cancel printing to file, after having been
    **  told file already exists.
    */
    BOOL            fCancelOp;
    BOOL            fHeaderSent; /* TRUE if header sent and EOJ not yet sent */
    BOOL            fEOJSent;    /* TRUE if EOJ sent and next header not sent*/
    BOOL            fIntCharWidth;/* TRUE if integer char widths to be used. */
    CGS             agsStack[IGSMAX]; /* the gsave stack */
    USHORT          usgsStack;      /* stack pointer */

    USHORT          usCodePages[MAX_FONT_LCID + 1];
    PDDCB           pddcb;

    PDEVICESURFACE  pDeviceSurface;           
} DDC,  *PDDC;
