/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDBTYPT.H
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * NOTES
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
#pragma pack(1) 

/*
**  Type definition for bitmap parameters
*/

/*
*/


typedef struct
    {
	ULONG	Width;
	ULONG	Height;
	ULONG	Planes;
	ULONG	Bitcount;
	ULONG	BytesPerRow;
    } BitmapParms;

/*
**  Type definition for bitmap list entry
*/

typedef struct BLEtag
    {
	lpBitmap	     Bitmap;
	/*
	**  selector increment for huge bitmaps
	*/
	SHORT		    Huge;
	BitmapParms	     Parms;	 /* width, height, planes and	*/
				       /* bitcount		      */
	
	PDDC		     DCHandle;	 /* DC handle if selected	*/
	/*
	**  lpDVTColorTable
	**  pointer to device color table for this format
	*/
	ULONG		     DCTPtr;
	struct BLEtag	    *NextEntry;
	SHORT		    XOrigin;	/* bottom x coord of DC band   */
	SHORT		    YOrigin;	/* bottom y coord of DC band   */
    } BitmapListEntry;

typedef BitmapListEntry  * pBMListEntry;

/*
**  Type definition for a parse string used in Rops
*/
typedef SHORT ParseStringType [PARSE_STRING_SIZE];

/*
**  Type definition for an operand string (used by BitBlt)
*/
typedef SHORT OpStringType [MAX_OPERANDS];

/*
**  Type definition for info table as used by DeviceCreateBitmap,
**  Set/GetBitmapBits.
*/

typedef struct
    {
	SHORT		   Width;	/* bitmap width in pels        */
	SHORT		   Height;	/* bitmap height in pels       */
	SHORT		   Planes;	/* no. of planes	       */
	SHORT		   Bitcount;	/* bits per plane	       */
	Byte		    Colors[256]; /* color table 		*/
    } InfoTableType;

/*
**  Pattern definition for bitblt
*/

typedef ULONG PatternType [PATTERN_HEIGHT];

/*
**  Parameter definition for prdb_ConvertBitmap parameters
*/

typedef struct
    {
	lpBitmap	Source;        /* source bitmap handle	      */
	/*
	**  increment for when source is huge bitmap
	*/
	SHORT	       HugeInc;
	
	PDDC		SourceDC;      /* DC pointer for source DC    */
	
	PDDC		TargetDC;      /* DC pointer for target DC    */
	/*
	**  lpDVTColorTable
	**  pointer to device color table for source bitmap
	*/
	ULONG		SrcDCT;
	/*
	**  lpDVTColorTable
	**  pointer to device color table for target bitmap
	*/
	ULONG		TrgDCT;
	/*
	**  byte offset to bits to be converted
	*/
	ULONG		SrcByteOffset;
	/*
	**  bit offset within byte (if (1,1) or (4,1) format), zero otherwise
	*/
	SHORT	       SrcBitOffset;
	/*
	**  source bitmap format: 1, 4, 8 or 24
	*/
	ULONG		SrcFormat;
	/*
	**  target bitmap format: 1, 4, 8 or 24
	*/
	ULONG		TrgFormat;
	/*
	**  flag to say that the source color table contains 24 bit RGBs
	**  instead of double SHORT
	*/
	Boolean 	SourceRGB;
    } ConvertParmsType;

/*
**  type definition for argument to DeviceDeleteBitmap
*/

typedef struct
	{
	    InfoTableType  *lpInfo;
	    lpBitmap	    lpBits;
	} DeleteReturns;

/*
**  type definition for argument to BitBlt
*/

typedef struct
	{
	    ULONG     Size;
	    ULONG     DestFore;
	    ULONG     DestBack;
	    ULONG     SrcFore;
	    ULONG     SrcBack;
	} BitBltAttrsType;

