/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDBCONE.H
 *
 * DESCRIPTIVE NAME = Bitmap Constants
 *
 *
 * VERSION = V2.0
 *
 * DATE        : --/--/--
 *
 * DESCRIPTION : Printer Device Driver Bitmap constants
 *
 * FUNCTIONS
 *
 * NOTES       : Reference - Device Driver Interface Specification
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
#pragma pack(1)

/*
**  Error codes
*/
#define PRDBERR           500
#define NO_MEMORY         PRDBERR+4    /* error getting bitmap memory */
#define BM_NOT_FOUND      PRDBERR+5    /* bitmap list entry not found */
#define BM_SELECTED       PRDBERR+6    /* bitmap is currently selected*/
#define FREEING_SEGMENT   PRDBERR+7    /* error freeing segment       */
/*#define INVALID_BITMAP  PRDBERR+8    -- invalid bitmap on Select    */
#define NULL_BITMAP       PRDBERR+9    /* null bitmap handle on Select*/
#define MULT_SEL          PRDBERR+10   /* error trying to select an   */
                                       /* already selected bitmap     */
#define NO_BITMAP         PRDBERR+11   /* no bitmap selected for a DC */
                                       /* on GetBitmapParameters      */
#define NO_LISTENTRY      PRDBERR+12   /* the bitmap handle on a      */
                                       /* GetBitmapParameters has no  */
                                       /* list entry                  */
#define NOT_MEMORYDC      PRDBERR+13   /* function cannot be performed*/
                                       /* if DC is not a memory DC    */
#define BAD_START         PRDBERR+14   /* start line specified in Get-*/
                                       /* SetmapBits is incorrect     */
#define BAD_COUNT         PRDBERR+15   /* no. lines specified in Get- */
                                       /* SetBitmapBits is incorrect  */
#define BITMAP_NOT_FOUND  PRDBERR+16   /* bitmap not found on delete  */
#define SAME_DCS          PRDBERR+17   /* BitBlt - source and target  */
                                       /* DCs are the same on a       */
                                       /* direct DC                   */
#define DIFFERENT_LDB     PRDBERR+18   /* BitBlt - source and target  */
                                       /* DCs are on different ldb's  */
#define SOURCE_NOT_SEL    PRDBERR+19   /* BitBlt - source is a memory */
                                       /* DC but is not selected      */
#define TARGET_NOT_SEL    PRDBERR+20   /* BitBlt - target is a memory */
                                       /* DC but is not selected      */
#define SOURCE_ROP_ERROR  PRDBERR+21   /* BitBlt - source specified   */
                                       /* when not required by Rop or */
                                       /* source not available when   */
                                       /* required                    */
#define NO_SRC_LIST_ENTRY PRDBERR+22   /* BitBlt - source bitmap has  */
                                       /* no list entry               */
#define NO_TRG_LIST_ENTRY PRDBERR+23   /* BitBlt - target bitmap has  */
                                       /* no list entry               */
#define BAD_COORDS        PRDBERR+24   /* BitBlt - source and target  */
                                       /* coordinates are invalid     */
#define BITMAP_DOS_ERROR  PRDBERR+25
#define PEL_OUTSIDE_BITMAP PRDBERR+26

/*
**  Direction indicators on a bitblt
*/
#define RIGHT                    1     /* right                       */
#define LEFT                     2     /* left                        */
#define UP                       1     /* up                          */
#define DOWN                     2     /* down                        */

/*
**  Logical operations on a bitblt Rop
*/
#define BB_NOT                   0     /* logical not                 */
#define BB_XOR                   1     /* logical XOR                 */
#define BB_OR                    2     /* logical OR                  */
#define BB_AND                   3     /* logical AND                 */

/*
**  Phase directions on a bitblt
*/
#define POS                      1     /* positive phase              */
#define NEG                      2     /* negative phase              */

/*
**  Operand definitions on a bitblt
*/
#define SRC                      0     /* source                      */
#define DEST                     1     /* destination                 */
#define PAT                      2     /* pattern                     */
#define PUSH                     3     /* a push                      */
#define POP                      4     /* a pop                       */

/*
**  Other constants
*/
#define END_OF_LIST             99     /* end of list indicator       */

#define USAGE_INITIALISE      0x04     /* DeviceCreateBitmap          */
#define USAGE_TRANSLATE       0x04     /* DeviceDeleteBitmap          */

#define PARSE_STRING_SIZE        8     /* No. chars in a Rop parse    */
                                       /* string - used by bitblt     */
#define NUMBER_PARSE             8     /* Total number of parse strs  */
#define MAX_OPERANDS             5     /* max operands in a Rop       */
                                       /* - used by bitblt            */

#define INFO_TABLE_SIZE    DDT_MAX_COLORS * 3 + 8
                                       /* Info table size in bytes    */
#define PATTERN_HEIGHT          16     /* height of predefined        */
                                       /* patterns                    */
#define NUMBER_PATTERNS         17     /* number of predefined        */
                                       /* patterns                    */

/*
**  style options for BitBlt
*/
#define STYLE_SOURCE_BITMAP    0x200   /* source is dc or bitmap      */
#define STYLE_ATTRIBUTES       0x400   /* optional attributes         */



/*
**  indicators for type of source supplied to bitblt
*/
#define NO_SOURCE         0 /* no source supplied (mode 0 only)       */
#define SELECTED_BITMAP   1 /* source is a bitmap, selected into a DC */
#define UNSELECTED_BITMAP 2 /* source is a bm, not selected into a DC */
#define SOURCE_DC         4 /* source is a DC                         */
