/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PPDIALOG.H
 *
 * DESCRIPTIVE NAME = PPD setting
 *
 *
 * VERSION = V2.0
 *
 * DATE        : 11/27/91
 *
 * DESCRIPTION : Header file for PPD setting
 *
 *
 * FUNCTIONS
 *
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
#pragma pack(1)
#ifndef ppdialog_h_
  #define ppdialog_h_

#include "jobres.h"    // Needed for cnfdata def

#define  ALLPPDS       450
#define  DIRECTORY_PPB 1
#define  TRUE          1
#define  FALSE         0
#define  NONE          -1
#define  BANNER        0
#define  NOBANNER      1
#define  NORMAL        0
#define  REVERSE       1
#define  PORTRAIT      0
#define  LANDSCAPE     1
#define  CNFRES        0
#define  PPDRES        1
#define  RESBUF        2
#define  SGNRES        3
#define  DIRRES        4
#define  LCLRES        5
#define  IMAXRES       5
#define  SYSTEM        0
#define  RAW           1
#define  ENCAPS        2
#define  ATRAY         0
#define  BTRAY         1
#define  CTRAY         2
#define  DTRAY         3
#define  ETRAY         4
#define  MANUAL        5     /* treated as the last tray                    */
#define  MAX_FNAMESIZE 40    /* Maximum size of a file name                 */
/*
** @V4.0163251
** Increase MAX_INPUT from 256 to 512 to allow for more PPD files.
*/
#define  MAX_INPUT     512   /* Maximum number of PPD files in directory
                                segment                                     */
#define  DRENTRYSIZE   48    /* Size of each directory table entry          */
/* Change INPBINS from 5 to 8. */
#define  INPBINS       16    /* Max no of input bins                        */
#define  OUTBINS       3     /* Max no of output bins                       */
#define  PRBUFSZ       4096
#define  MAX_PSIZE     64
#define  APPKEYSIZE    20
#define  MAX_KEYAPPSIZE 78   /* Max size for application name in ini        */

/*
**  The driver version should be changed when any changes in DRIVDATA
**  could cause a problem.  Newer versions should be greater then
**  previous to allow logical comparisons.  Fill in defaults for
**  DRIVDATA for newer drivers in ValidateDriveData()
**  DRIVERSION always has the most current version
*/

#define  DRIVERSION_1_3  0X00010003L
#define  DRIVERSION_1_31 0X00010301L
#define  DRIVERSION_2_11 0X00020011L  /* For Warp summer '94 */
#define  DRIVERSION_3_00 0X00030000L  /* For Warp spring '95 */   //@V3.0115481
#define  DRIVERSION_3_11 0X00030011L  /* For Warp Merlin '96 */
#define  DRIVERSION_4_00 0X00040000L  /* For Warp Merlin '96 fix cmpat */
#define  DRIVERSION      0X00040000L
#define  DEF_IEXT      ".ppd"
#define  DEF_OEXT      ".ppb"
#define  PB            CHAR *
#define  MAX_CHARS_IN_EXTENSION 3
#define  MAX_CHARS_IN_FILENAME 8

//@V3.MEDIATYPE
//#define MEDIATYPE_STRING    "MediaType"

/*
** This define is used when it is desired to view each block name.  This causes
** extra code to be inserted and defines some global variables.  This is
** defined like this in case it is desired NOT to display the block names
** in the debugger, all you need to do is change the value here, rather than
** in all the C files.
*/
#define IPMD_DISPLAY_UI    IPMD


// @V3.1157420
/*
** Used in NewUserForms() in QUERY.C.
** With this flag, the function returns the number of user-defined forms.
*/
#define QUERY_NUM_OF_USER_FORMS      -1


/*****************************************************************************/
/*
** V3.0UI
*/
// @V3.0FIX
/*
** A UI entry is each entry within a *OpenUI / *CloseUI.
*/
typedef struct _UI_ENTRY
{
  USHORT ofsOption;                  // Option string offset
  USHORT ofsTransString;             // Translation string offset
  USHORT ofsValue;                   // Value string offset
} UI_ENTRY, *PUI_ENTRY;


/*
** A UI block is defined here as all data that falls within an
** *OpenUI / *CloseUI.
*/
typedef struct _UI_BLOCK
{
  USHORT   ofsUIName;                // Offset to block name
  USHORT   ofsUITransString;         // Offset to block translation string
  USHORT   usOrderDep;               // Numeric value, order of block in list
  USHORT   usDisplayOrder;           // Order block is displayed in listbox

  USHORT   usUILocation;             // Job location where block is written
    #define UI_ORDER_ANYSETUP     0
    #define UI_ORDER_JCLSETUP     1
    #define UI_ORDER_PAGESETUP    2
    #define UI_ORDER_DOCSETUP     4
    #define UI_ORDER_PROLOGSETUP  8
    #define UI_ORDER_EXITSERVER   0x10

  USHORT   usSelectType;             // Selection type for Job Properties
    #define UI_SELECT_BOOLEAN    4
    #define UI_SELECT_PICKMANY   2
    #define UI_SELECT_PICKONE    1

  UCHAR    ucGroupType;
    #define UIGT_DEFAULTOPTION     0 // Displayed in Job Properties
    #define UIGT_INSTALLABLEOPTION 1 // Displayed in Printer Properties

  UCHAR    ucPanelID;                // Identifies owner of feature
    #define UIP_OS2_FEATURE      0   // Feature supported by IBM's J.P. Dialog
    #define UIP_OEM_FEATURE      1   // Feature supported by OEM Dialog
    #define UIP_PREDEF_FEATURE   2   // Feature predefined in PPD

  USHORT   usDefaultEntry;           // 0-based offset of default entry (below)
  USHORT   usNumOfEntries;           // Number of entries in block
  UI_ENTRY uiEntry[ 1 ];             // List of UI entries
} UI_BLOCK, *PUI_BLOCK;

/*
** p is a pointer to the current UI_BLOCK structure.
*/
#define QUERY_BLOCK_SIZE( p )       (sizeof( UI_BLOCK ) + \
                                     (((p)->usNumOfEntries - 1) * \
                                     sizeof( UI_ENTRY )))
#define INCREMENT_BLOCK_PTR( p )    p = (PUI_BLOCK) ((PCHAR) p + \
                                                     QUERY_BLOCK_SIZE( p ))


/*
** The UI list makes up of all *OpenUI / *CloseUI blocks in the PPD.  This
** contains a header an a pointer to the list buffer.
*/
typedef struct _UI_LIST
{
  USHORT    usNumOfBlocks;            // Number of total blocks
  USHORT    usBlockListSize;          // Byte size of UI list
  PUI_BLOCK pBlockList;               // Pointer to UI list buffer

} UI_LIST, *PUI_LIST;

typedef ULONG   UI_SEL;
typedef UI_SEL *PUI_SEL;

/*
** @V3.0UI
** This structure deals with the user-selected UI's.  There is a buffer called
** the UI selection buffer.  Each 32-bit value in the list is reserved for
** a UI block and each bit in each 32-bit value represents a UI entry.  If
** the bit is set to 1, that UI entry is to be sent out with the job.  It is
** possible to have multiple entry selections per block.
** This structure contains the byte length of the UI selection block and a
** pointer to the UI selecton block.
*/
typedef struct _UI_SELLIST
{
  USHORT  usCurrUIListSize;        // Total byte size of UI selection list
  USHORT  ofsSelectList;           // Offset to UI selection list
} UI_SELLIST, *PUI_SELLIST;
#define ASSIGN_UISELLIST_PTR( p )   (PUI_SEL) ((PBYTE) (p) + sizeof( CNFDATA ))

/*
** The User Interface Constraints provide a set of mutually exclusive options.
** This has been provided so that printers can indicate if any options will
** not work with other options.  For example, a duplex may not support
** envelopes, so the UI constraints will indicate that if either any envelope
** or the duplex is selected, then the other cannot be selected.
** The UI constraint list contains the ID of the related dialog box ID for
** that given key.
** The Entry structure is used for each key.  The key ID contains the dialog
** ID for the key.  The Key2 ID is used for any keys that use a list box and
** contains a specific ID for that key in the list box.
** The Block structure contains the IDs of both keys that are not to be
** selected together.
** The list structure contains a variable list of the UIC_BLOCK structures.
*/
// @V3.0UIC
typedef struct _UIC_ENTRY
{
  USHORT ofsUIBlock;       // Offset to block in block list
  UI_SEL bOption;          // Bit value of option(s) for a given keyword
} UIC_ENTRY, *PUIC_ENTRY;

typedef struct _UIC_BLOCK
{
  UIC_ENTRY uicEntry1;      // Mutually exclusive key 1
  UIC_ENTRY uicEntry2;      // Mutually exclusive key 2
} UIC_BLOCK, *PUIC_BLOCK;

// @V3.0UIC
typedef struct _UIC_LIST
{
  USHORT     usNumOfUICs;    // Number of UIC_BLOCKs
  PUIC_BLOCK puicBlockList;  // Variable-length list of UIC_BLOCKs
} UIC_LIST, *PUIC_LIST;

/*
** The following macro calculates the size of the UI_LIST structure, including
** the list of UIC_BLOCKs, in bytes.
** Argument u is a PUIC_LIST pointer.
*/
#define UIC_LIST_SIZE( u )   (sizeof( UIC_LIST ) + (sizeof( UIC_BLOCK ) * \
                              ((PUIC_LIST) (u)->usNumOfUICs - 1)))
/*****************************************************************************/

/*
**  defines for the duplex options
*/

#define  DUPLEX_NONE   -1
#define  DUPLEX_FALSE  0
#define  DUPLEX_DUPLEXNOTUMBLE 1
#define  DUPLEX_DUPLEXTUMBLE 2


/*
** typedef declarations for use by prdefpdb.c,filelist.c and other modules.
** These declarations relate to printer configuration .
** Description of typedef struc defined :
**            CNFDATA : structure typedef defined so that a device context
**                      data can be stored and accessed by various routines.
**            PPD1    : A typedef defined so that various assorted printer
**                      descriptive items can be stored in a group.
**            PPD2    : A typedef defined so that various printer paper related
**                      values and command lists can be stored under one group.
**            PPD3    : A typedef defined so that Input Paper Tray related
**                      items can be kept under a group.
**            PPD4    : A typedef defined so that Output Paper Tray related
**                      items can be kept under a group.
**            PPD5    : A typedef defined so that Fonts related items can be
**                      kept under a group .
**          DESPPD    : An agglomeration of items PPD1 to PPD5 .The structure
**                      desPpd (with Type DESPPD) is used to access all the
**                      relevant parameters of an adobe printer descriptor file
*/
/* This is the old source for compatibility's sake */
typedef struct _DUMMYSRC
{
  /*
  **  paper name lying in the upper tray
  */
  CHAR szPaperName[5][MAX_PSIZE];
  SHORT shCustomWidth;
  SHORT shCustomHeight;
} DUMMYSRC;

/* @V3.0
** The new 8 tray structure
*/
typedef struct _SOURCE
{
  CHAR szPaperName[INPBINS][MAX_PSIZE];
  SHORT shCustomWidth;
  SHORT shCustomHeight;
} SOURCE, *PSOURCE;

/* @V3.0
** This is an Internal Variable (IV) struct which can be used for
** any vars that do not need to passed out of the driver as job
** properties.  You can extend this but obey the WARNING below.
**
** WARNING   WARNING    WARNING    WARNING    WARNING
**
** Make sure the size of IV does NOT get greater than DUMMYSRC or
** the alignment will be off for older drivers.
*/
typedef struct _IV
{
  PSOURCE pSourcePaper;
  CHAR    aTraySelected[ MAX_PSIZE ];
       #define AUTOTRAY_STRING    "AUTOTRAYSELECT"
       #define MANUALFEED_STRING  "MANUALFEED"

  /*
  ** This verifies if the Job properties have been inited
  ** If 1, then the props are correct.  If 0, props have not been set,
  ** therefore, set default NON ZERO values in CNFDATA.
  */
  BYTE fJobPropSet;
  MASTERRESOURCECONTROLBLOCK  MRCB; //Holds pointers to resources          @RES
} IV, *PIV;

typedef union _U
{
  DUMMYSRC dummy;
  IV       iv;
} U, *PU;
                             /* defines paper types lying in various trays  */
typedef struct _EFFECTS
{
  SHORT fIsFliptb;           /* whether to flip top to bottom               */
  SHORT fIsDrawInverted;     /* whether to draw source image bit inverted   */
  SHORT fIsFliplr;           /* whether to draw flipped left to right       */
  SHORT iJobTimeout;         /* The value of job timeout in seconds         */
  SHORT iWaitTimeout;        /* The value of wait timeout in seconds        */
} EFFECTS;
                             /* structure for output printing effects       */
typedef struct _JOBPROP
{
  CHAR szFormName[MAX_PSIZE];/* form name on which job is tobe printed      */
  /*
  **  form size i.e. letter,A4 ,on which job is tobe printed
  */
  CHAR szFormSize[MAX_PSIZE];
  SHORT iOutPlace;           /* paper placement in output bin               */
  SHORT iOrient;             /* orientation : Portrait or Landscape         */
  SHORT fIsColorDevice;      /* whether colour support required or not      */
  /*
  **  The enlargement value in terms of percentage
  */
  USHORT uScale;             // Changed to USHORT                  @V4.1192074
  SHORT iManualfeed;         /* default manual feed true=1,false=0,none=-1  */
} JOBPROP;
                             /* structure for job properties                */
// @V3.RGBGAMMA
typedef struct _RGBGAMMA
{
  LONG lRed;
  LONG lGreen;
  LONG lBlue;
} RGBGAMMA, *PRGBGAMMA;





/*
** In order to maintain backward compatibility with the older N-up code, we
** must include the old structure.  This structure is no longer valid with
** the current code.
*/
typedef struct _GJFX
{
  ULONG  cb;                             // Size of struct - do not modify
  USHORT usInternalFlags;                // Internal flags - do not modify
         #define GXF_INITIALIZED  1
         #define GXF_MEMALLOC     2

  USHORT  usID;                          // Control block ID
} GJFX, *PGJFX;

typedef struct GJNCB2
{
  GJFX  gdfx;                            // Internal structure - do not modify
                                         // This field *MUST* be first.
  ULONG  ulNumPgSheet;                   // # of pages per sheet

  ULONG  ulFlags;                        // User flags
         // If set, do NOT draw logical page border.
         #define GNDF_IGNOREBORDER   1

  ULONG  ulReserved1;                    // Reserved - must be 0
  ULONG  ulReserved2;                    // Reserved - must be 0
  PVOID  pvoid;                          // Reserved - must be NULL

} GJNCB2, *PGJNCB2;





typedef struct _CNFDATA
{
/*HMODULE hmod;              +* Dummy since HMODULE is 4 bytes in 32bit     */
  SHORT   oldhmod;           /* Pscript.drv module handle                   */
  ULONG uHelp;               /* the handle to help resources                */
  USHORT uPrinterPropFlags;  /* Used for Printer properties                 */
#define  MODESWITCH    1     /* Bit 0; Printer mode switch 0=off 1=on       */
  SHORT iCntFiles;           /* count of input files                        */
  /*
  **  this option signify what action to take whether to display dialog
  **  box or not
  */
  SHORT uSaveOptions;
  /*
  **  version no maintined to support compatibility with different
  **  versions of driver
  */
  LONG lVersion;
  LONG lGetPtr;              /* to indicate current offset in input file    */
  CHAR szPrtName[MAX_FNAMESIZE]; /* Used to be szKeyApp                     */
  CHAR szSegName[MAX_FNAMESIZE]; /* info segment name                       */

  /*
  **  name of the paper selected for various trays
  */
  /* @V3.0
  ** Create a union of dummy structure and a IV. The IV contains a pointer
  ** to SOURCE.
  */
  U u;

  CHAR szFontName[MAX_FNAMESIZE];/* name of the font selected               */
  /*
  **  a structure to contain various print effect parameters
  */
  EFFECTS effOutput;
  /*
  **  Job properties set under job property dialog box
  */
  JOBPROP jobProperties;
  SHORT iCntCopies;          /* no of output copies to be produced          */
  /*
  **  type of destination : 0-System(LPT1 or COM1),1-Raw mode file,
  *                         2-Encapsulated postscript file
  */
  SHORT iDestnType;
  CHAR szDestnFile[MAX_FNAMESIZE];/* Name of output file                    */

  /*
  ** Do not change the rel position of above structure it will mess up old
  ** drivers on the network.  Make any changes to the end
  --
  **  variable to get allppd resource segment, it replaces the old
  **  selReousrce variable on 1.2
  */
  PVOID pvResource;

  /*
  **  DCR 1462 JOB PROP DUPLEX MODE
  */
  SHORT sDuplexMode;         /* Job prop duplex mode                        */

  /*
  **  DCR 1399 NAME OF APP IN INI FILE WHERE SPECIFIC PRINTER DETAILS
  **  ARE KEPT
  */
  /*
  **  Name of App in ini file where specific printer details are kept
  */
  CHAR szKeyApp[MAX_KEYAPPSIZE];

  /*
  */
  SHORT uResolution;

  /*  ** The amount of user downloaded fonts
  */
  LONG lFontCount;

  HMODULE hmod;               /* Pscript.drv module handle */

  SHORT sUseDLFonts;          

  USHORT usPSLevel1;          /* D746091 - support level 1 compatibility */
/*DRIVERSION      0X00020011L ends here */

  /*
  ** @3.0GAMMA1
  ** This stores the gamma correction value.  Since the gamma value is in the
  ** order of 0.1 to 9.0 in increments of 0.1, store the value multiplied by
  ** 10, so that the value is stored as an integer and not as a floating point
  ** value.  The gamma function divides this value by 10 to get the real value.
  ** When defining NO_GAMMA, take the above into consideration.  Currently,
  ** a value if 1 means not gamma should be applied.
  */
//LONG lGammaValue;
// @V3.RGBGAMMA
  RGBGAMMA sGammaValues;    // Range -> (1 to 90) for gamma values (0.1 to 9.0)
  #define NO_GAMMA       10           // 'Normal' (or no) gamma value
  #define MIN_GAMMA       1
  #define MAX_GAMMA      50
  #define RED_OFFSET      0
  #define GREEN_OFFSET  256
  #define BLUE_OFFSET   512

//#V3.RGBGAMMA2
  BOOL     bGammaLock;

  /*
  ** This value makes up the size of the CNFDATA structure prior to the
  ** UI addition.  This value is needed and can never be modified.
  */
  #define PRE_UI_CNFDATA_SIZE         770

  /*
  ** @V3.0UI
  ** This structure makes up the current UI selections from the dialog box.
  */
  UI_SELLIST stUISelList;      // UI selection list structure

//DRIVERSION_3_00 starts here                                     //@V3.0115481

  SHORT sUsePDFonts;                                              //@V3.0115481

  GJNCB2  gjfncb;                       // N-UP control block

  ULONG ulFlags;                    // Generic flags
  #define UNIX_COMPAT    0x00000001 // Do not send CTRL-D at file end.
  #define PD_FONTS_SET   0x00000002 // Set to indicate sUsePDFonts has been initialized.
  #define NO_FORM_IN_JP  0x00000004 // Form Name was empty upon entry
  #define DUPLEX_CHANGED 0x00000008 // Set for flipping duplex for landscape
  //@V4.0172646
  #define OLD_INI_USED   0x00000010 // Set if reading old INI data
  #define RAW_FILE       0x00000020 // Set if std job is raw             //@V4.1190984
  #define ENCAPS_FILE    0x00000040 // Set if std job is encapsulated    //@V4.1190984
  #define USEFONTSUB     0x00000080 // Set if using font substitution.
  #define SIM_COLLATE    0x00000100 
//  #define MIXED_FEED     0x00000200 // First page on different paper  @MIXED_FEED
  #define MIXED_FEED     0x00000E00 // First page on different paper+(next 2 flags)  @MIXED_FEED
  #define NOT_NUP_1ST    0x00000400 // Don't NUP first page          @MIXED_FEED
  #define NOT_DUP_1ST    0x00000800 // Don't Duplex first page       @MIXED_FEED
  
  #define ENCAPS_PS_WM_ID      1
  #define BOOKLET_MAX_RANGES_SIZE 40                     
  CHAR szBookletRangeOfPages[BOOKLET_MAX_RANGES_SIZE];   
  
  CHAR szFormName_1[MAX_PSIZE];                          // @MIXED_FEED
  CHAR aTraySelected_1[MAX_PSIZE];                       // @MIXED_FEED
  CHAR szMediaType_1[MAX_PSIZE];                         // @MIXED_FEED

} CNFDATA, *PCNFDATA;

/*
**  structure for Device Driver data
*/

typedef struct _LDRIVDATA
{                            /* driv                                        */
  LONG cb;
  LONG lVersion;
  CHAR szDeviceName[32];
  CNFDATA cnfData;
} LDRIVDATA, *PLDRIVDATA;

/*** RESLIST is a structure that points to a variable array of RESTYPE
** structures.
** uNumOfRes - Number of RESTYPE structures in pResType.
** uResOffset - This contains a zero-based offset where the resolution
** information is kept in a variable-length buffer.  The information
** for the resolution is kept the following way (in order):
** 2-byte resolution value, in dots-per-inch
** ------------------------------------------
** 1-byte length of the following string:
** ------------------------------------------
** string length, this string does not always
** have a terminating NULL character
**
** PRESLIST - Pointer to a RESLIST structure.
*/
/*
** @V3.0115171
** Add a flag to indicate if this resolution is used as part of the JCL
** format.  If TRUE, the resoluion is part of JCL.  False otherwise.
*/
typedef struct _RESLIST
{
    SHORT uNumOfRes;
    SHORT uResOffset;
    BOOL  bIsJCLResolution;             // @V3.0115171
} RESLIST;
typedef RESLIST *PRESLIST;

typedef struct _PPD1
{
  SHORT iSizeBuffer;         /* size buffer where params are stored         */
  SHORT ofsPswrd;            /* offset pointer to password                  */
  SHORT iPpm;                /* No of pages printed/minute                  */
  LONG lFreeVM;              /* amount of free virtual memory               */
  SHORT ofsPrType;           /* offset pointer to printer type              */
  SHORT ofsPrName;           /* offset pointer to printer name              */
  SHORT iResDpi;             /* Resolution in dots per inch                 */

  /*
  **  Structure containing the available PostScript resolutions.
  */
  RESLIST ResList;

  /*
  **  Screen frequencly in cells per inch multiplied by 100
  */
  LONG lScrFreq;
  SHORT fIsColorDevice;       /* whether device supports colour or not       */
  /*
  **  whether device supports independent file system or not
  */
  SHORT fIsFileSystem;
  SHORT ofsReset;            /* offset to printer reset command string      */
  SHORT ofsExitserver;       /* offset to exitserver command string         */
  LONG iScreenAngle;         /* Halftone Screen angle                       */

  /*
  ** Added this field to the structure.  This field is an
  ** offset that allows the driver to identify what PostScript
  ** level the current device supports.
  */
  USHORT usLanguageLevel;    /* Contains language level                     */
  SHORT ofsTransferNor;      /* offset to Normalised transfer function      */
  /*
  **  offset to Normalised Inverse transfer function
  */
  SHORT ofsTransferInv;
  /*
  **  @1462 offset to PS mode emul. init. string
  */
  SHORT ofsInitString;       /* offset to PS mode emul. init. string        */

  /*
  ** @V3.0115171
  ** This offset points to the JCL to PS interpreter string.
  */
  SHORT ofsJCLToPS;

  /*
  **  @1462 offset to PS mode emul. terminate string
  */
  SHORT ofsTermString;       /* offset to PS mode emul. terminate string    */
  SHORT sDefaultDuplex;      /* default duplex mode                         */
  SHORT ofsDuplexFalse;      /* string to turn off duplex/tumble            */
  SHORT ofsDuplexNoTumble;   /* string to turn on duplex                    */
  SHORT ofsDuplexTumble;     /* string to turn on duplex/tumble             */
  SHORT ofsPCFileName;                                 /* @V3.OEM          */
} PPD1;

typedef struct _PPD2
{
  SHORT ofsDfpgsz;           /* offset pointer to default paper size        */
                             /* - now an index value                        */
  SHORT fIsVariablePaper;    /* true if variable paper supported            */
  SHORT ofsDefimagearea;     /* offset to paper name string                 */
  SHORT ofsDefpaperdim;      /* offset to paper dim string                  */
  SHORT iCmpgpairs;          /* no of paper command pairs                   */
  SHORT ofsLspgCmnds;        /* offset pointer to list of paper commands    */
  SHORT iDmpgpairs;          /* no of paper dimension pairs                 */
  SHORT ofsDimxyPgsz;        /* offset pointer to list of xy dimensions     */
  SHORT iImgpgpairs;         /* no of paper imageable coordinate pairs      */
  /*
  **  offset pointer to list of Imageable page and coordinates pairs
  */
  SHORT ofsImgblPgsz;
} PPD2;

typedef struct _PPD3
{
  SHORT iManualfeed;         /* default manual feed true=1,false=0,none=-1  */
  /*
  **  offset pointer to command for manual feed true
  */
  SHORT ofsManualtrue;
  /*
  **  offset pointer to command for manual feed false
  */
  SHORT ofsManualfalse;
  SHORT ofsDefinputslot;     /* offset pointer to default input bin         */
  SHORT iInpbinpairs;        /* no of bin name and command pairs            */
  /*
  **  offset pointer to list of bin names & select commands
  */
  SHORT ofsCmInpbins;

  // @V3.0UI
  SHORT iNumOfPageSizes;     // Number of page sizes in list
  SHORT ofsPageSizes;        // List of paper sizes
} PPD3;

typedef struct _PPD4
{
  /*
  **  Default output order can be normal or reverse
  */
  SHORT fIsDefoutorder;
  /*
  **  offset pointer to command string for output order normal
  */
  SHORT ofsOrdernormal;
  /*
  **  offset pointer to command string for output order reverse
  */
  SHORT ofsOrderreverse;
  /*
  **  offset pointer to name of default output order
  */
  SHORT ofsDefoutputbin;
  /*
  **  no of bin name and command pairs
  */
  SHORT iOutbinpairs;
  /*
  **  offset pointer to list of bin select commands
  */
  SHORT ofsCmOutbins;
} PPD4;

typedef struct _PPD5
{
  SHORT ofsDeffont;          /* offset pointer to default font name         */
  SHORT iFonts;              /* no of fonts supported                       */
  SHORT ofsFontnames;        /* offset pointer to list of font names        */
} PPD5;

typedef struct _PPD6
{
  USHORT usFormCount;        /* Count of forms                              */
  SHORT  ofsFormTable;       /* Forms Table                                 */
  SHORT  ofsFormIndex;       /* Index Table                                 */
} PPD6;

typedef struct _FORMSTRUCT
{
  PSZ FormName;              /* Pointer to form name                        */
  PSZ XlateName;
  PSZ OldSuffix;             /* Ptr to old name w xlate attached            */
  PBYTE Data;                /* Pointer to data of interest                 */
} FORMSTRUCT, *PFORMSTRUCT;

typedef struct _DESPPD
{
  PPD1 desItems;             /* Individual items defined                    */
  PPD2 desPage;              /* Storage for paper descriptors defined       */
  PPD3 desInpbins;           /* Storage for Input bin descriptors defined   */
  PPD4 desOutbins;           /* Storage for Output bin descriptors defined  */
  PPD5 desFonts;             /* Storage for Font names defined              */
  PPD6 desForms;             /* Form tables                                 */

  /*
  ** @V3.0UI
  */
  UI_LIST stUIList;
  // @V3.0UIC
  UIC_LIST stUICList;

  PBYTE   pPSStringBuff;
} DESPPD, *PDESPPD;
/*
**  printer descriptor segments
*/

/*
** Directory entry data structure.  This structure contains
** printer driver names and it is used when searching for
** a given printer.
*/

typedef struct _DRENTRY
{
  CHAR szName[MAX_FNAMESIZE];
  LONG lResNum;
  CHAR free[4];
} DRENTRY, *PDRENTRY;
/*
**  directory table entry structure
*/

/*
**  PPB file Header structure . This structure contains PPB file identifier
**  Table size and no of entries in the PPB file .
*/

typedef struct _SIGNATURE
{
  CHAR szName[MAX_FNAMESIZE];
  SHORT iTblSize;
  SHORT cntEntries;
  CHAR free[4];
} SIGNATURE, *PSIGNATURE;

typedef struct _DDCOPY
{
  PBYTE pBuffer;
  LONG  lBuffSize;
} DDCOPY, *PDDCOPY;

/*
** EXTRA_DV - device additional information
** See DEVLST.C for ExtraDV list 
** Use CHECKFLAG_EXT to check flags in ExtraDV
*/

#define CHECKFLAG_EXT( p, flag, bit ) ((p)&&(((p)->flag) & (ULONG)(bit)))

typedef struct _EXTRA_DV
{
  CHAR  szDeviceName[MAX_FNAMESIZE];  // Device name
  
  #define NO_FNTMGR       0x00000001  // Disable font manager
  ULONG ulFlags;                      // Extra flags for device
  
  PSZ   pszHomeURL;                   
  PSZ   pszDriverURL;                 

} EXTRA_DV, *PEXTRA_DV;



#endif
