/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
#pragma pack(1)
#ifndef jobres_h_
  #define jobres_h_

/*
** Resources are based on a block type storage system.  Each component is a
** block with a common header and additional fields as needed.  The header has a
** type which uniquely identifies it, a size which is the whole size of the
** block, and pointer to the next block of same type.
**
** The resources are stored as linked lists when created.  The Master Resource
** Control Block is stored in the CNFDATA (Job Props).  If the count is 0
** then there is no resources.  Each resource has a Resource Control Block which
** contains a common header, count of resources of that type and a pointer to
** the chain.
**
** +-------------------------------+
** | MASTER_RESOURCE_CONTROL_BLOCK |
** +--+----------------------------+
**    |
**    |  +------------------------+    +---------------------+   +---------------------+
**    +->| RESOURCE_CONTROL_BLOCK +--->| FONT_RESOURCE_BLOCK +-->| FONT_RESOURCE_BLOCK |
**    +--+       (Fonts)          |    |     ( Font 1 )      |   |     ( Font 2 )      |
**    |  +------------------------+    +---------------------+   +---------------------+
**____|__________________Not implemented yet____________________________________________
**    |  +------------------------+
**    +->| RESOURCE_CONTROL_BLOCK |
**    +--+      (Patterns)        |
**    |  +------------------------+
**    |
**    |  +------------------------+
**    +->| RESOURCE_CONTROL_BLOCK |
**       |       (Forms)          |
**       +------------------------+
*/

/* Block types */
#define NULL_BLOCK                       0x4C4C554E    //NULL
#define MASTER_RESOURCE_CONTROL_BLOCK    0x4243524D    //MRCB
#define FONT_CONTROL_BLOCK               0x5F424346    //FCB_
#define FONT_RESOURCE_BLOCK              0x5F425246    //FRB_

/* NOTE
** Pointers are not explicitly defined in the actual structures for 2 reasons
** 1) The resource data is part of job props which goes between processes or
**    systems via network
** 2) They can change size between OS ex. 32 vs 64 which can/will cause
**    alignment problems.
**
** The pointers must be converted to offsets when given to the the spooler.
** They can be coverted back to ptrs when read back in
*/

/*
** Resource header
** -------- ------
** Used for each block - contains the block type, size of block, a optional
** offset field for split records, a pointer to next block of same type
*/
typedef struct _RESHEADER
{
  ULONG ulType;         // Block type
  LONG  lSize;          // Size of block
  ULONG ulpNext;        // Pointer to next of same type
} RESHEADER, *PRESHEADER;

typedef struct _RESOURCECONTROLBLOCK
{
  RESHEADER   header;
  LONG        lCount;             // How many resouce blocks
  ULONG       ulpResource;        // Ptr to resource blocks
} RESOURCECONTROLBLOCK, *PRESOURCECONTROLBLOCK;

typedef struct _MASTERRESOURCECONTROLBLOCK
{
  RESHEADER  header;
  ULONG      ulVersion;
    #define    V1_0       0x00010000      // Note - update this where ref
  LONG       lCount;      // How many control blocks
  LONG       lTotalSize;  // Total size of all resource material needed only when
                          // stored out of memory - don't include MRCB it's in CNFDATA
  ULONG      ulFlags;     // Flags for resources
    #define    RESOURCE_DATA_SET    0x00000001
    #define    RESOURCE_DO_NOT_FREE 0x00000002
    #define    RESOURCE_FREE_BLOCKS 0x00000004
    #define    RESOURCE_FREE_BUF    0x00000008
  ULONG      ulpRCB;      // Ptr/offset to Resource Control Blocks
  LONG       lLastPageProcessed;                                   //@4.1198538
} MASTERRESOURCECONTROLBLOCK, *PMASTERRESOURCECONTROLBLOCK;

typedef struct _FONTRESOURCEBLOCK
{
  RESHEADER header;     //FONT_RESOURCE_BLOCK
  LONG      ulUsage;
    #define   SINGLE_CHAR   0x00000001
    #define   SINGLE_LINE   0x00000002
    #define   SINGLE_PAGE   0x00000004
    #define   TOP_OF_PAGE   0x00000008
    #define   MULTI_PAGE    0x00000010
  LONG      lStartPage;
  LONG      lFontType;
    #define   DEVICEFONT    1
    #define   DOWNLOAD      2
    #define   ENGINEFONT    3
  ULONG     ulFlags;
    #define   FONT_LOADED           0x00000001
    #define   IN_SAVE_STATE         0x00000002
//#define   FONT_NAME_SIZE  32
  CHAR      achFontName[ FACESIZE + 1 ];
} FONTRESOURCEBLOCK, *PFONTRESOURCEBLOCK;

#endif
