/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = FILLET.H
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * NOTES
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
#pragma pack(1) 

/*
**  define common types in the Engine and DDI
*/


/*
**  Curve types
*/

#define LINE_IDENTIFIER 	   0x4C
#define FILLET_SHARP_IDENTIFIER    0x46
#define FILLET_EQN_IDENTIFIER	   0x45
#define CURVEATTR_IDENTIFIER	   0x41

typedef struct _CURVE { /* cv */
    BYTE     bIdent;
    BYTE     bType;
    SHORT   usStyle;
    SHORT   fs;
    struct   _CURVE NEAR *npcvNext;
    struct   _CURVE NEAR *npcvPrev;
    struct   _CURVE NEAR *npcvAttrs;
    POINTFX  ptfxA;
    POINTFX  ptfxC;
    BYTE     Reserved2[16];
} CURVE;
typedef CURVE *PCURVE;

typedef struct _FILLETEQN { /* fse */
    BYTE    bIdent;
    BYTE    bType;
    SHORT  usReferences;
    POINTS  ptsA;
    POINTS  ptsC;
    POINTS  ptsB;
    SHORT  usNumerator;
    SHORT  usDenominator;
    LONG    lAlpha;
    LONG    lBeta;
    LONG    lGamma;
    LONG    lDelta;
    LONG    lEpsilon;
    LONG    lZeta;
} FILLETEQN;
typedef FILLETEQN *PFILLETEQN;

typedef struct _FILLETSHARP { /* fs */
    BYTE    bIdent;
    BYTE    bType;
    SHORT  usStyle;
    SHORT  fs;
    CURVE   NEAR *npcvNext;
    CURVE   NEAR *npcvPrev;
    CURVE   NEAR *npcvAttrs;
    POINTFX ptfxA;
    POINTFX ptfxC;
    POINTFX ptfxB;
    FIXED   lSharpness;
    FILLETEQN NEAR *npEquation;
    BYTE    Reserved2[2];
} FILLETSHARP;
typedef FILLETSHARP *PFILLETSHARP;
