/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
#ifndef config_h_
  #define config_h_

/**************************************************************************
 *
 * SOURCE FILE NAME = CONFIG.H
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * NOTES
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/#pragma pack(1)

#define MAX_TITLEBAR_STR_LEN   33  /* MFR                                   */

#define LASER           1
#define ALLPPDS         450

#define IMAGE_CODE      501
#define IMAGEGRP        500

#ifdef DCR1476
#define PRTPROP         THI_ABOUT
#define JOBPROP         102
#define JOBOPT          103
#define DEFFORM         104
#define INSTALL         105
#define HELP_GROUP      460
#endif

#define IDH_CONTEXT     2
#define OVERWRITE       3

/*
** @V3.2155893
** All Merlin dialogs requires BKS_TABBEDDIALOG for tabs.  If an earlier
** version, this flag will not be defined, so define it here.
*/
#ifndef BKS_TABBEDDIALOG
#define BKS_TABBEDDIALOG          0x00000800
#endif

/*
** Define the maximum and minimum fonts to download .
*/
#define MAX_DOWN_FONT   999L
#define MIN_DOWN_FONT   0L

/*
**  printer configuration dialog box.
*/

#define PRCONFIG_BASE   200
#define DLG_PRCONFIG             PRCONFIG_BASE
#define DSPTXT_VERSION           PRCONFIG_BASE + 1
#define PUSH_JOBPROP             PRCONFIG_BASE + 2
#define PUSH_FORMS               PRCONFIG_BASE + 3
#define LIST_TRAY                PRCONFIG_BASE + 4
#define LIST_PAPER               PRCONFIG_BASE + 5
#define TEXT_FORM                PRCONFIG_BASE + 6
#define TEXT_TRAY                PRCONFIG_BASE + 7
#define GROUP_SOURCE             PRCONFIG_BASE + 8
#define TEXT_PRMODEL             PRCONFIG_BASE + 9
#define PUSH_DELETE              PRCONFIG_BASE + 10
#define DSPTXT_MODEL             PRCONFIG_BASE + 11
#define TEXT_VERSION             PRCONFIG_BASE + 12
#define PUSH_SOFTFONT            PRCONFIG_BASE + 13
#define CHECK_MODESWITCH         PRCONFIG_BASE + 14
#define GROUP_FONT_DOWN          PRCONFIG_BASE + 15
#define TEXT_MAX_FONTS           PRCONFIG_BASE + 16
#define SPIN_MAX_FONTS           PRCONFIG_BASE + 17
#define PUSH_FONT_DEFAULT        PRCONFIG_BASE + 18
#define IDP_PRINT_FONT_CAPACITY  PRCONFIG_BASE + 19

/*
**  job properties dialog box.
*/

#define JOBPROP_BASE    300
#define DLG_JOBPROP     JOBPROP_BASE
#define LIST_FORMS      JOBPROP_BASE + 1
#define PUSH_OPTIONS    JOBPROP_BASE + 2
#define GROUP_ORIENT    JOBPROP_BASE + 3
#define CHECK_COLOR     JOBPROP_BASE + 4
#define CHECK_MANUAL    JOBPROP_BASE + 5
#define TEXT_SCALE      JOBPROP_BASE + 6
#define EDIT_SCALE      JOBPROP_BASE + 7
#define GROUP_SCALE     JOBPROP_BASE + 8
#define RADIO_PORTRAIT  JOBPROP_BASE + 9
#define RADIO_LAND      JOBPROP_BASE + 10
#define RADIO_FLIP      JOBPROP_BASE + 11  
#define RADIO_BOOK      JOBPROP_BASE + 12  
#define RADIO_ONE_SIDED JOBPROP_BASE + 13  
#define GROUP_PLEXING   JOBPROP_BASE + 14  
#define TEXT_FORM_2     JOBPROP_BASE + 15  
#define TEXT_RESOLUTION  PRCONFIG_BASE + 16
#define LIST_RESOLUTION  PRCONFIG_BASE + 17

/*
**  options dialog box.
*/

#define OPTIONS_BASE         400
#define DLG_OPTIONS          OPTIONS_BASE
#define DSPTXT_PRINTER       OPTIONS_BASE + 1
#define TEXT_UNCOLLATED      OPTIONS_BASE + 2
#define EDIT_COPIES          OPTIONS_BASE + 3
#define GROUP_EFFECTS        OPTIONS_BASE + 4
#define CHECK_INVERT         OPTIONS_BASE + 5
#define CHECK_LEFTRIGHT      OPTIONS_BASE + 6
#define CHECK_TOPBOTTOM      OPTIONS_BASE + 7
#define GROUP_TIMEOUT        OPTIONS_BASE + 8
#define EDIT_JOB             OPTIONS_BASE + 9
#define TEXT_JOB             OPTIONS_BASE + 10
#define GROUP_PRINT          OPTIONS_BASE + 11
#define TEXT_FILE            OPTIONS_BASE + 12
#define EDIT_FILE            OPTIONS_BASE + 13
#define RADIO_ENCAPS         OPTIONS_BASE + 14
#define RADIO_RAW            OPTIONS_BASE + 15
#define RADIO_PRINTER        OPTIONS_BASE + 16
#define EDIT_WAIT            OPTIONS_BASE + 17
#define TEXT_WAIT            OPTIONS_BASE + 18
#define JPO_CB_REPDLFONTS    OPTIONS_BASE + 19 
#define JPO_CB_PSLVL1        OPTIONS_BASE + 20
#define JPO_CB_REPDEVFONTS   OPTIONS_BASE + 21                   //@V3.0115481
#define JPO_ERRHNDLR         OPTIONS_BASE + 22                   // @V3.1142412
/*
** @V3.0GAMMA1
** Gamma correction controls
*/
// @V3.RGBGAMMA
//#define OPT_GAMMASLIDE     OPTIONS_BASE + 22
//#define OPT_GAMMATEXT      OPTIONS_BASE + 23
//#define OPT_GAMMANUM       OPTIONS_BASE + 24
#define OPT_GAMMASLIDE_R     OPTIONS_BASE + 22
#define OPT_GAMMATEXT_R      OPTIONS_BASE + 23
#define OPT_GAMMANUM_R       OPTIONS_BASE + 24
#define OPT_GAMMAGROUP       OPTIONS_BASE + 25
#define OPT_GAMMASLIDE_G     OPTIONS_BASE + 26
#define OPT_GAMMATEXT_G      OPTIONS_BASE + 27
#define OPT_GAMMANUM_G       OPTIONS_BASE + 28
#define OPT_GAMMASLIDE_B     OPTIONS_BASE + 29
#define OPT_GAMMATEXT_B      OPTIONS_BASE + 30
#define OPT_GAMMANUM_B       OPTIONS_BASE + 31
#define OPT_LOCKRGB          OPTIONS_BASE + 32

/*
**  define forms dialog box.
*/

#define FORMS_BASE      500
#define DLG_FORMS       FORMS_BASE
#define TEXT_NAME       FORMS_BASE + 1
#define LIST_SIZE       FORMS_BASE + 2
#define TEXT_SIZE       FORMS_BASE + 3
#define EDIT_HEIGHT     FORMS_BASE + 4
#define TEXT_HEIGHT     FORMS_BASE + 5
#define EDIT_WIDTH      FORMS_BASE + 6
#define TEXT_WIDTH      FORMS_BASE + 7
#define LIST_UNITS      FORMS_BASE + 8
#define TEXT_UNITS      FORMS_BASE + 9
#define GROUP_CUSTOM    FORMS_BASE + 10
#define PUSH_ADD        FORMS_BASE + 11
#define EDIT_NAME       FORMS_BASE + 12

/*
** Warning Panel - that raw output file already exists
** reworked to fix PTR OSDD HM01010
*/
/*
** Warning Panel - that raw output file already exists reworked
*/
#define OVRWARN_BASE    600
#define DLG_OVRWARN     OVRWARN_BASE

#define TEXT_W_TITLE    OVRWARN_BASE + 1
#define TEXT_FILE_OVR   OVRWARN_BASE + 2
#define EDIT_FILE_OVR   OVRWARN_BASE + 3
#define TEXT_W_INF1     OVRWARN_BASE + 4
#define TEXT_W_INF2     OVRWARN_BASE + 5

/*
** Warning Panel - that raw output filename is invalid
** reworked to fix PTR OSDD HM01010
*/
/*
** Warning Panel - that raw output filename is invalid reworked
*/
#define INVFILE_BASE    700
#define DLG_INVFILE     INVFILE_BASE

#define TEXT_E_TITLE    INVFILE_BASE + 1
#define TEXT_FILE_INV   INVFILE_BASE + 2
#define EDIT_FILE_INV   INVFILE_BASE + 3
#define TEXT_E_INF1     INVFILE_BASE + 4
#define TEXT_E_INF2     INVFILE_BASE + 5

/*
**  softfont installer dialog box
*/

#define SOFTFONT_BASE           800
#define DLG_SOFTFONT            SOFTFONT_BASE
#define SF_LB_INSTALLED         SOFTFONT_BASE + 1
#define SF_ADD                  SOFTFONT_BASE + 2
#define SF_ERASE                SOFTFONT_BASE + 3
#define ID_FONT_SOURCE          SOFTFONT_BASE + 4
#define SF_LB_SOURCE            SOFTFONT_BASE + 5
#define SF_OPEN                 SOFTFONT_BASE + 6
#define ID_NEW_FNT_TITLE        SOFTFONT_BASE + 7
#define ID_NEW_SFNT_TITLE       SOFTFONT_BASE + 8
#define ID_INST_FONT_DIR_TITLE  SOFTFONT_BASE + 9
#define ID_INST_FONT_DIR_FRAME  SOFTFONT_BASE + 10
#define ID_INST_FONT_DIR        SOFTFONT_BASE + 11
#define ID_INST_FONTS_TITLE     SOFTFONT_BASE + 12


#define MAX_MESSAGE_SIZE    256
#define IDM_BASE            1100
#define IDM_MsgBoxCaption   IDM_BASE
#define IDM_BadScaleFactor  IDM_BASE + 1
#define IDM_BadWidth        IDM_BASE + 2
#define IDM_BadHeight       IDM_BASE + 3
#define IDM_BadFormName     IDM_BASE + 4
#define IDM_CantDeleteForm  IDM_BASE + 5
#define IDM_CantAddForm     IDM_BASE + 6
#define IDM_BadNumCopies    IDM_BASE + 7
#define IDM_BadJobTimeout   IDM_BASE + 8
#define IDM_BadWaitTimeout  IDM_BASE + 9
#define IDM_BadFileName     IDM_BASE + 10
#define IDM_CantWriteToIni  IDM_BASE + 11
#define IDM_CantDelCurrent  IDM_BASE + 12
#define IDM_VerifyDelForm   IDM_BASE + 13
#define IDM_CantFindPFB     IDM_BASE + 14
#define IDM_CantFindAFM     IDM_BASE + 15
#define IDM_InsertAFMDisk   IDM_BASE + 16
#define IDM_NoFonts         IDM_BASE + 17
#define IDM_SFInstaller     IDM_BASE + 18
#define IDM_BadDirectory    IDM_BASE + 19
#define IDM_DriveOpen       IDM_BASE + 20
#define IDM_JobLTWait       IDM_BASE + 21
#define IDM_FileWriteError  IDM_BASE + 22
#define IDM_UseSystemFonts  IDM_BASE + 23
/*
** New message error ID.
*/
#define IDM_OfflineError    IDM_BASE + 24
//@V3.FORMS
#define IDM_NoFormName      IDM_BASE + 25
//@V3.DLGs
#define IDM_OVERWRITE       IDM_BASE + 26
#define IDM_INVALIDFILE     IDM_BASE + 27


/*
** table of string id's.  these id's must be kept in sequential order.
** if more are added, IDS_EndString must also be updated.
*/

//#define STRING_BASE                 2000
#define STRING_BASE                 16
#define IDS_Letter                  STRING_BASE
#define IDS_A4                      STRING_BASE + 1
#define IDS_Portrait                STRING_BASE + 2
#define IDS_Landscape               STRING_BASE + 3
#define IDS_Custom                  STRING_BASE + 4
#define IDS_UserDefinedForm         STRING_BASE + 5
#define IDS_None                    STRING_BASE + 6
#define IDS_Upper                   STRING_BASE + 7
#define IDS_PostScriptPrn           STRING_BASE + 8
#define IDS_Inches                  STRING_BASE + 9
#define IDS_Cms                     STRING_BASE + 10
#define IDS_Points                  STRING_BASE + 11
#define IDS_Generic                 STRING_BASE + 12
#define IDS_PRINTER_DEFAULTS        STRING_BASE + 13
#define IDS_PM_Q_STD                STRING_BASE + 14
#define IDS_PM_Q_RAW                STRING_BASE + 15
#define IDS_PM_SPOOLER_DD           STRING_BASE + 16
#define IDS_PM_SPOOLER_PRINTER      STRING_BASE + 17
#define IDS_PM_SPOOLER_QUEUE_DD     STRING_BASE + 18
#define IDS_PSCRIPT                 STRING_BASE + 19
/*
*/
/*
**  help strings
*/
#define IDS_HELPTITLE               STRING_BASE + 20
#define IDS_NoHelpFile              STRING_BASE + 21
#define IDS_NoHelpMemory            STRING_BASE + 22
#define IDS_Avail_Mem               STRING_BASE + 23
#define IDS_Sug_Font                STRING_BASE + 24
//@V3.DLGs
#define DLG_VERSION                 STRING_BASE + 25
//@V3.130814
#define DLG_CMYK_STRING             STRING_BASE + 26
#define DLG_GRAY_STRING             STRING_BASE + 27

// @V3.1142412
#define IDS_StatusSheetText         STRING_BASE + 28
#define IDS_ErrHandlerText          STRING_BASE + 29

#define IDS_DNS                     STRING_BASE + 30
#define IDS_DNSCONST1               STRING_BASE + 31
#define IDS_DNSCONST2               STRING_BASE + 32
#define IDS_DNSCONSTPP              STRING_BASE + 33
#define IDS_DNSCONSTJP              STRING_BASE + 34
//#define IDS_ENCAPSULATED            STRING_BASE + 35
#define IDS_COLLATE_SIMULATION      STRING_BASE + 35 //@V4.COLL2FP

//@CONSTRAINT
#define IDS_ConstrItemTitle         STRING_BASE + 36
#define IDS_ConstrItemMsg           STRING_BASE + 37
#define IDS_ConstrFailTitle         STRING_BASE + 38
#define IDS_ConstrFailMsg           STRING_BASE + 39

/*
**  MUST BE THE LAST ONE, AND ONE GREATER THAN THE PRECEDING ONE!
*/
#define IDS_EndString               STRING_BASE + 40

/*
**  MUST BE GREATER THAN OR EQUAL TO THE TOTAL NUMBER OF STRINGS ID'S.
*/
#define MAX_STRINGS                 (IDS_EndString - STRING_BASE + 1)

/*
** Entries added for DCR 1476
*/

/*
**  main help table
*/
#define MAIN_HELPTABLE        15000

/*
**  help subtables
*/
#define IDD_MAIN_SUBTABLE     15100
#define DLG_FORMS_SUBTABLE    15101
#define DLG_OPTIONS_SUBTABLE  15102
#define DLG_JOBPROP_SUBTABLE  15103
#define DLG_SOFTFONT_SUBTABLE 15104

#define IDH_OK                 1090
#define IDH_CANCEL             1091

#define IDH_KEYS              15010
#define IDH_JOB_PROP_PB       15354
#define IDH_PSCRIPT_PP        15355
#define IDH_PAPER_SOURCE      15356
#define IDH_FONTS_PB          15357
#define IDH_DEFINE_FORM_PB    15358
#define IDH_DELETE_FORM_PB    15359
#define IDH_DEFINE_FORMS      15360
#define IDH_NAME              15361
#define IDH_SIZE              15362
#define IDH_UNITS             15363
#define IDH_WIDTH             15364
#define IDH_HEIGHT            15365
#define IDH_ADD_FORM          15366
#define IDH_FONT_INSTALLER    15370
#define IDH_INSTALLED_FONTS   15371
#define IDH_FONT_SOURCE       15372
#define IDH_NEW_SOFT          15373
#define IDH_OPEN              15374
#define IDH_ADD_FONT          15375
#define IDH_DELETE            15376
#define IDH_PSCRIPT_JP        15377
#define IDH_ORIENTATION       15378
#define IDH_SCALING           15379
#define IDH_FORM              15380
#define IDH_FEED              15381
#define IDH_COLOR             15382
#define IDH_OPTIONS_PB        15383
#define IDH_OPTIONS           15384
#define IDH_PRINT             15385
#define IDH_EFFECTS           15386
#define IDH_TIMEOUT           15387
#define IDH_COPIES            15388
#define IDH_INST_FONT_DIR     15389
#define IHD_MODE_SWITCH       15390
#define IHD_DOWNLOADFONT      15391
#define IHD_SETRESOLUTION     15392
#define IHD_REPDLFONTS        15393
#define IHD_PSL1COMPAT        15394

// @V3.1142412
#define PSERR_RESID           400




#define DLG_PSCOMMON                0x0100
#define PS_NOTEBOOK_GROUP           (DLG_PSCOMMON + 1)
#define PS_CONTEXTHELP              (DLG_PSCOMMON + 2)
#define PSB_OK                      (DLG_PSCOMMON + 3)
#define PSB_CANCEL                  (DLG_PSCOMMON + 4)
#define PSB_HELP                    (DLG_PSCOMMON + 5)
#define PSB_DEFAULT                 (DLG_PSCOMMON + 6)
#define PSB_UNDO                    (DLG_PSCOMMON + 7)

/*****************************************************************************\
*                                                                             *
* *** POSTSCRIPT PRINTER PROPERTIES SETTINGS ***                              *
*                                                                             *
\*****************************************************************************/
#define DLG_PSPRINTERPROP           0x0200
#define PPNB_DLG_FORMS              (DLG_PSPRINTERPROP + 0x0010)
#define PPF_TAB                     (PPNB_DLG_FORMS + 1)
#define PPF_FORMGROUP               (PPNB_DLG_FORMS + 2)
#define PPF_FORMTEXT                (PPNB_DLG_FORMS + 3)
#define PPF_FORMLIST                (PPNB_DLG_FORMS + 4)
#define PPF_FORMINFOTEXT            (PPNB_DLG_FORMS + 5)
#define PPF_DEFINEFORM              (PPNB_DLG_FORMS + 6)
#define PPF_DELETEFORM              (PPNB_DLG_FORMS + 7)
#define PPF_TRAYTEXT                (PPNB_DLG_FORMS + 8)
#define PPF_FORMNAMEMAPTRAY         (PPNB_DLG_FORMS + 9)
#define PPF_TRAYLIST                (PPNB_DLG_FORMS + 10)
#define PPF_TRAYINFOTEXT            (PPNB_DLG_FORMS + 11)
#define PPF_PAPERGROUP              (PPNB_DLG_FORMS + 12)
#define PPF_TRAYGROUP               (PPNB_DLG_FORMS + 13)
#define PPF_RESETFORMMAP            (PPNB_DLG_FORMS + 14)

#define PPDLG_DEFFORMS              (PPNB_DLG_FORMS + 15)
#define PPDLG_NAMETEXT              (PPNB_DLG_FORMS + 16)
#define PPDLG_NAMEENTRY             (PPNB_DLG_FORMS + 17)
#define PPDLG_SIZETEXT              (PPNB_DLG_FORMS + 18)
#define PPDLG_SIZELIST              (PPNB_DLG_FORMS + 19)
#define PPDLG_CUSTOMGROUP           (PPNB_DLG_FORMS + 20)
#define PPDLG_CUSTOMUNITTEXT        (PPNB_DLG_FORMS + 21)
#define PPDLG_CUSTOMUNITLIST        (PPNB_DLG_FORMS + 22)
#define PPDLG_CUSTOMWIDTHTEXT       (PPNB_DLG_FORMS + 23)
#define PPDLG_CUSTOMWIDTHENTRY      (PPNB_DLG_FORMS + 24)
#define PPDLG_CUSTOMHEIGHTTEXT      (PPNB_DLG_FORMS + 25)
#define PPDLG_CUSTOMHEIGHTENTRY     (PPNB_DLG_FORMS + 26)
#define PPDLG_ADD                   (PPNB_DLG_FORMS + 27)
#define PPDLG_CANCEL                (PPNB_DLG_FORMS + 28)
#define PPDLG_HELP                  (PPNB_DLG_FORMS + 29)
#define PPDLG_DEFFORMSCSH           (PPNB_DLG_FORMS + 30)

#define PPDLG_DELFORM_TITLE         (PPNB_DLG_FORMS + 32)
#define PPDLG_DELFORM_MSG           (PPNB_DLG_FORMS + 33)
#define PPDLG_CLEARTRAY_TITLE       (PPNB_DLG_FORMS + 34)
#define PPDLG_CLEARTRAY_MSG         (PPNB_DLG_FORMS + 35)
#define PPF_NOFORMSSELECT           (PPNB_DLG_FORMS + 36)
#define PPF_NOFORMMAPMSG            (PPNB_DLG_FORMS + 37)

// Automatic mode switching
#define PPNB_DLG_AUTOSWITCH         (DLG_PSPRINTERPROP + 0x0040)
#define PPA_TAB                     (PPNB_DLG_AUTOSWITCH + 1)
#define PPO_REPDFGROUP              (PPNB_DLG_AUTOSWITCH + 2)
#define PPO_REPDFTEXT               (PPNB_DLG_AUTOSWITCH + 3)
#define PPO_REPDFVALUE              (PPNB_DLG_AUTOSWITCH + 4)
#define PPO_PRINTFONTCAP            (PPNB_DLG_AUTOSWITCH + 5)
#define PPO_AUTOMSGROUP             (PPNB_DLG_AUTOSWITCH + 6)
#define PPO_AUTOSWITCHCHECK         (PPNB_DLG_AUTOSWITCH + 7)
#define PPO_JPDO                    (PPNB_DLG_AUTOSWITCH + 8)
#define PPO_DISPMAPPEDFORMS         (PPNB_DLG_AUTOSWITCH + 9)
#define PPO_OVERRIDEMISMATCH        (PPNB_DLG_AUTOSWITCH + 10)
/*****************************************************************************\
*                                                                             *
* *** END POSTSCRIPT PRINTER PROPERTIES SETTINGS ***                          *
*                                                                             *
\*****************************************************************************/

/*****************************************************************************\
*                                                                             *
* *** POSTSCRIPT JOB PROPERTIES SETTINGS ***                                  *
*                                                                             *
\*****************************************************************************/
#define DLG_PSJOBPROP               0x0300
#define JPSB_GROUPBOX               (DLG_PSJOBPROP + 1)
#define JPSB_PORTRAIT               (DLG_PSJOBPROP + 2)
#define ICON_PORTRAIT               (DLG_PSJOBPROP + 3)
#define JPSB_LANDSCAPE              (DLG_PSJOBPROP + 4)
#define ICON_LANDSCAPE              (DLG_PSJOBPROP + 5)

// Monochrome/Color group.
#define JPSB_MONOCHROME             (DLG_PSJOBPROP + 6)
#define ICON_MONOCHROME             (DLG_PSJOBPROP + 7)
#define JPSB_COLOR                  (DLG_PSJOBPROP + 8)
#define ICON_COLOR                  (DLG_PSJOBPROP + 9)

// Duplex group (No duplex, duplex no tumble, duplex tumble).
#define JPSB_DUPLEX_NONE            (DLG_PSJOBPROP + 10)
#define ICON_DUPLEX_NONE            (DLG_PSJOBPROP + 11)
#define JPSB_DUPLEX_BOOK            (DLG_PSJOBPROP + 12)
#define ICON_DUPLEX_BOOK            (DLG_PSJOBPROP + 13)
#define JPSB_DUPLEX_FLIP            (DLG_PSJOBPROP + 14)
#define ICON_DUPLEX_FLIP            (DLG_PSJOBPROP + 15)

// Output group (printer, raw file, EPS file).
#define JPSB_OUTPUT_PRINTER         (DLG_PSJOBPROP + 16)
#define ICON_OUTPUT_PRINTER         (DLG_PSJOBPROP + 17)
#define JPSB_OUTPUT_RAW             (DLG_PSJOBPROP + 18)
#define ICON_OUTPUT_RAW             (DLG_PSJOBPROP + 19)
#define JPSB_OUTPUT_EPS             (DLG_PSJOBPROP + 20)
#define ICON_OUTPUT_EPS             (DLG_PSJOBPROP + 21)

/*
** Forms Page (Page 1)
*/
#define JPNB_DLG_FORM               (DLG_PSJOBPROP + 0x0030)
#define JPF_TAB                     (JPNB_DLG_FORM + 1)
#define JPF_FORMGROUP               (JPNB_DLG_FORM + 2)
#define JPF_FORMNAMETEXT            (JPNB_DLG_FORM + 4)
#define JPF_FORMNAMELIST            (JPNB_DLG_FORM + 5)
#define JPF_TRAYNAMETEXT            (JPNB_DLG_FORM + 6)
#define JPF_TRAYNAMELIST            (JPNB_DLG_FORM + 7)
#define JPF_MEDIATYPETEXT           (JPNB_DLG_FORM + 8)
#define JPF_MEDIATYPELIST           (JPNB_DLG_FORM + 9)
#define JPF_ORIENTGROUP             (JPNB_DLG_FORM + 10)
#define JPF_PORTRAIT                (JPNB_DLG_FORM + 11)
#define JPF_LANDSCAPE               (JPNB_DLG_FORM + 12)
#define JPF_DUPLEXGROUP             (JPNB_DLG_FORM + 13)
#define JPF_DUPLEXNONE              (JPNB_DLG_FORM + 14)
#define JPF_DUPLEXNOTUMBLE          (JPNB_DLG_FORM + 15)
#define JPF_DUPLEXTUMBLE            (JPNB_DLG_FORM + 16)
#define JPF_COPIESTEXT              (JPNB_DLG_FORM + 17)
#define JPF_COPIESNUM               (JPNB_DLG_FORM + 18)
#define JPF_MANUALFEED              (JPNB_DLG_FORM + 19)
#define JPF_AUTOTRAYSELECT          (JPNB_DLG_FORM + 20)
#define JPF_COPIESBOX               (JPNB_DLG_FORM + 21)    // @V4.COLL2FP
#define JPF_COLLATELIST             (JPNB_DLG_FORM + 22)    // @V4.COLL2FP
#define JPF_COLLATETEXT             (JPNB_DLG_FORM + 23)    // @V4.COLL2FP
#define JPF_FORMNAMETEXT_1          (JPNB_DLG_FORM + 24)    // @MIXED_FEED
#define JPF_FORMNAMELIST_1          (JPNB_DLG_FORM + 25)    // @MIXED_FEED
#define JPF_TRAYNAMETEXT_1          (JPNB_DLG_FORM + 26)    // @MIXED_FEED
#define JPF_TRAYNAMELIST_1          (JPNB_DLG_FORM + 27)    // @MIXED_FEED
#define JPF_MEDIATYPETEXT_1         (JPNB_DLG_FORM + 28)    // @MIXED_FEED
#define JPF_MEDIATYPELIST_1         (JPNB_DLG_FORM + 29)    // @MIXED_FEED
#define JPF_MIXED_FEED              (JPNB_DLG_FORM + 30)    // @MIXED_FEED

/*
** Output page (Page 2)
*/
#define JPNB_DLG_OUTPUT             (DLG_PSJOBPROP + 0x0060)
#define JPO_TAB                     (JPNB_DLG_OUTPUT + 1)
#define JPO_PRINTTOGRP              (JPNB_DLG_OUTPUT + 2)
#define JPO_PRINTER                 (JPNB_DLG_OUTPUT + 3)
#define JPO_RAWFILE                 (JPNB_DLG_OUTPUT + 4)
#define JPO_EPS                     (JPNB_DLG_OUTPUT + 5)
#define JPO_FILETEXT                (JPNB_DLG_OUTPUT + 6)
#define JPO_FILEENTRY               (JPNB_DLG_OUTPUT + 7)
#define JPO_TIMEOUTGP               (JPNB_DLG_OUTPUT + 8)
#define JPO_REPDOWNFONT             (JPNB_DLG_OUTPUT + 9)
#define JPO_LVL1COMPAT              (JPNB_DLG_OUTPUT + 10)
#define JPO_RESOLUTIONTEXT          (JPNB_DLG_OUTPUT + 11)
#define JPO_RESOLUTIONLIST          (JPNB_DLG_OUTPUT + 12)
#define JPO_REPDEVFONTS             (JPNB_DLG_OUTPUT + 13)
#define JPO_UNIXCOMPAT              (JPNB_DLG_OUTPUT + 14)
#define JPO_FONTSUB                 (JPNB_DLG_OUTPUT + 15)

// Effects page (Page 3)
#define JPNB_DLG_EFFECTS            (DLG_PSJOBPROP + 0x0080)
#define JPE_TAB                     (JPNB_DLG_EFFECTS + 1)
#define JPE_GAMMAGROUP              (JPNB_DLG_EFFECTS + 2)
#define JPE_GAMMASLIDE_R            (JPNB_DLG_EFFECTS + 3)
#define JPE_GAMMAVALTXT_R           (JPNB_DLG_EFFECTS + 4)
#define JPE_GAMMAVALNUM_R           (JPNB_DLG_EFFECTS + 5)
#define JPE_FLIPTOPBTM              (JPNB_DLG_EFFECTS + 6)
#define JPE_FLIPLEFTRIGHT           (JPNB_DLG_EFFECTS + 7)
#define JPE_DRAWINVERTED            (JPNB_DLG_EFFECTS + 8)
#define JPE_SCALETEXT               (JPNB_DLG_EFFECTS + 9)
#define JPE_SCALENUM                (JPNB_DLG_EFFECTS + 10)
// @V3.RGBGAMMA
#define JPE_GAMMASLIDE_G            (JPNB_DLG_EFFECTS + 11)
#define JPE_GAMMAVALTXT_G           (JPNB_DLG_EFFECTS + 12)
#define JPE_GAMMAVALNUM_G           (JPNB_DLG_EFFECTS + 13)
#define JPE_GAMMASLIDE_B            (JPNB_DLG_EFFECTS + 14)
#define JPE_GAMMAVALTXT_B           (JPNB_DLG_EFFECTS + 15)
#define JPE_GAMMAVALNUM_B           (JPNB_DLG_EFFECTS + 16)
#define JPE_LOCKRGB                 (JPNB_DLG_EFFECTS + 17)
#define JPE_COLORCHECK              (JPNB_DLG_EFFECTS + 18)
#define JPE_EFFECTS_GROUP           (JPNB_DLG_EFFECTS + 19)
#define JPE_COLOR_GROUP             (JPNB_DLG_EFFECTS + 20)
#define JPE_COLOR_LIST              (JPNB_DLG_EFFECTS + 21)

// Features page (Page 4)
#define JPNB_DLG_UI                 (DLG_PSJOBPROP + 0x0100)
#define JPUI_TAB                    (JPNB_DLG_UI + 1)
#define JPUI_FEATURETEXT            (JPNB_DLG_UI + 2)
#define JPUI_UILIST                 (JPNB_DLG_UI + 3)
#define JPUI_SELGROUP               (JPNB_DLG_UI + 4)
#define JPUI_DESCTEXT               (JPNB_DLG_UI + 5)
#define JPUI_BOOLTRUE               (JPNB_DLG_UI + 6)
#define JPUI_BOOLFALSE              (JPNB_DLG_UI + 7)
#define JPUI_PICKONE                (JPNB_DLG_UI + 8)
#define JPUI_PICKMANY               (JPNB_DLG_UI + 9)

#define JPNB_DLG_COLORFEAT          (DLG_PSJOBPROP + 0x0110)
#define JPCO_TAB                    (JPNB_DLG_COLORFEAT + 1)
/*****************************************************************************/

/*
** These defines make up the tick information for the Gamma Correction slide
** bar.  For more information on ticks, refer to the Programming Guide, vol 2.
** GC_SLIDE_HOME_VAL is the value of the home position and the lowest value
**   of the slider.  This may not always be zero.
** GC_SLIDE_NUM_OF_TICKS is the number of tick marks to be inserted on the
**   slider.  This is needed because the DLG file cannot handle calculations,
**   so a direct value is needed.
** GC_SLIDE_MAJOR_TICK_PIXEL_LEN and GC_SLIDE_MINOR_TICK_PIXEL_LEN
**   deterine the pixel length of the ticks.  The pixel length is from the bar
**   to the numeric value above the tick.  The major tick is always twice as
**   long as the minor tick.
** GC_SLIDE_MAJOR_TICK_PLACE determines the pattern for placing major ticks.
**   If the value is 1, every tick is major.  If 2, every second tick is major.
**   If 3, every third tick is major, etc.  The pattern algorithm is to use
**   modular division.  If the result is 0, a major tick is inserted,
**   otherwise, a minor tick is inserted.
**   ** This must be an integer value. **
**   ** No error checking is performed on these values. **
*/
#define GC_SLIDE_HOME_VAL              1
#define GC_SLIDE_NUM_OF_TICKS          50  // Total number of ticks on slider
#define GC_SLIDE_MAJOR_TICK_PIXEL_LEN  6   // Length of tick mark from bar to #
#define GC_SLIDE_MINOR_TICK_PIXEL_LEN  (INT) (GC_SLIDE_MAJOR_TICK_PIXEL_LEN / 2)
#define GC_SLIDE_MAJOR_TICK_PLACE      10  // Pattern where maj. ticks are used
/*****************************************************************************\
*                                                                             *
* *** END POSTSCRIPT JOB PROPERTIES SETTINGS ***                              *
*                                                                             *
\*****************************************************************************/




#endif
