/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = ALLFONTS.H
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : This file contains a list of all of the fonts included in
 *		 the 1.1 release for all of the supported printers.  It also
 *		 contains several other tables.  Users can select the Bold or
 *		 Italic attribute when creating a logical font.  When this is
 *		 the case, these tables are used to map to the correct font.
 *
 *		 IF YOU CHANGE THIS FILE, be sure to update any constants,
 *		 and to update all tables!!!
 *
 * FUNCTIONS
 *
 * NOTES
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#pragma pack(1)


//#include <stdio.h>
//#include <os2.h>

// There are 2 ways to represent a font - 1 ) use the FONT_INFO type shown
// below or as a ULONG where hi word is family and low word is type.

// Types
#define REGULAR    0
#define ITALIC     1
#define BOLD       2
#define BOLDITALIC 3

#define HELVETICA (MAKEULONG( REGULAR, 3 ))
#define HELVETICA_BOLD (MAKEULONG( BOLD, 3 ))
#define TIMES_ROMAN (MAKEULONG( REGULAR, 19 ))
#define TIMES_BOLD  (MAKEULONG( BOLD, 19 ))
#define COURIER (MAKEULONG( REGULAR, 2 ))

#define IS_HELVETICA( i )  ((( HIUSHORT(i) >= 3 ) && ( HIUSHORT(i) <= 7 )) || ( HIUSHORT(i) == 21 ))
#define IS_AVANT_GARDE( i )  ( HIUSHORT(i) == 8 )
#define SYSTEM_FONTS   21
#define FONT_NOT_FOUND (ULONG)-1

typedef struct _FONT_INFO {
  INT iFamily;
  INT iType;
} FONT_INFO, * PFONT_INFO;

typedef ULONG FONT_ID_NUM;

extern FONT_ID_NUM FindFontIDNum( PDDC, PSZ, BOOL );

PSZ AllFonts[][BOLDITALIC+1] =
{
 { // 0
  "Adobe Garamond Regular",
  "Adobe Garamond Italic",
  "Adobe Garamond Bold",
  "Adobe Garamond Bold Italic",
 },
 { // 1
  "Adobe Garamond Semibold",
  "Adobe Garamond Semibold Italic",
  "Adobe Garamond Bold",
  "Adobe Garamond Bold Italic",
 },
 { // 2
  "Courier",
  "Courier Oblique",
  "Courier Bold",
  "Courier Bold Oblique",
 },
 { // 3
  "Helvetica",
  "Helvetica Oblique",
  "Helvetica Bold",
  "Helvetica Bold Oblique",
 },
 { // 4
  "Helvetica Black",
  "Helvetica Black Oblique",
  "Helvetica Bold",
  "Helvetica Bold Oblique",
 },
 { // 5
  "Helvetica Condensed Medium",
  "Helvetica Condensed Oblique",
  "Helvetica Condensed Bold",
  "Helvetica Condensed Bold Obliqu",
 },
 { // 6
  "Helvetica Light",
  "Helvetica Light Oblique",
  "Helvetica Bold",
  "Helvetica Bold Oblique",
 },
 { // 7
  "Helvetica Narrow",
  "Helvetica Narrow Oblique",
  "Helvetica Narrow Bold",
  "Helvetica Narrow Bold Oblique",
 },
 { // 8
  "ITC Avant Garde Gothic Book",
  "ITC Avant Garde Gothic Book Obl",
  "ITC Avant Garde Gothic Demi",
  "ITC Avant Garde Gothic Demi Obl",
 },
 { // 9
  "ITC Bookman Light",
  "ITC Bookman Light Italic",
  "ITC Bookman Demi",
  "ITC Bookman Demi Italic",
 },
 { // 10
  "ITC Garamond Light",
  "ITC Garamond Light Italic",
  "ITC Garamond Bold",
  "ITC Garamond Bold Italic",
 },
 { // 11
  "ITC Korinna Regular",
  "ITC Korinna Kursiv Regular",
  "ITC Korinna Bold",
  "ITC Korinna Kursiv Bold",
 },
 { // 12
  "ITC Lubalin Graph Book",
  "ITC Lubalin Graph Book Oblique",
  "ITC Lubalin Graph Demi",
  "ITC LubalinGraph Demi Oblique",
 },
 { // 13
  "ITC Souvenir Light",
  "ITC Souvenir Light Italic",
  "ITC Souvenir Demi",
  "ITC Souvenir Demi Italic",
 },
 { // 14
  "ITC Zapf Chancery Medium Italic",
  NULL,
  NULL,
  NULL,
 },
 { // 15
  "ITC Zapf Dingbats",
  NULL,
  NULL,
  NULL,
 },
 { // 16
  "New Century Schoolbook Roman",
  "New Century Schoolbook Italic",
  "New Century Schoolbook Bold",
  "New Century Schoolbook Bold Ita",
 },
 { // 17
  "Palatino Roman",
  "Palatino Italic",
  "Palatino Bold",
  "Palatino Bold Italic",
 },
 { // 18
  "Symbol",
  NULL,
  NULL,
  NULL,
 },
 { // 19
  "Times Roman",
  "Times Italic",
  "Times Bold",
  "Times Bold Italic",
 },
 { // 20
  "Times Roman Varitimes",
  "Times Italic Varitimes",
  "Times Bold Varitimes",
  "Times Bold Italic Varitimes",
 },
 { // 21
  "Helvetica",
  "Helvetica Italic",
  "Helvetica Bold",
  "Helvetica Bold Italic",
 },
 { // 22
  "Times New Roman",
  "Times New Roman Italic",
  "Times New Roman Bold",
  "Times New Roman Bold Italic",
 },
 { // 23
  "Courier",
  "Courier Italic",
  "Courier Bold",
  "Courier Bold Italic",
 },
 { // Marker
  NULL,
  NULL,
  NULL,
  NULL
 }
};

#if 0
// Use this for testing
//main()
//{
//  FONT_INFO fi;
//
//  fi.iFamily = 0;
//  fi.iType = REGULAR;
//
//  while( Fonts[fi.iFamily][REGULAR] != NULL )
//  {
//    printf( "{ // %d\n", fi.iFamily );
//    for ( fi.iType = REGULAR; fi.iType <= BOLDITALIC; fi.iType++ )
//    {
//      if ( Fonts[fi.iFamily][fi.iType] == NULL )
//      {
//        printf(" NULL, ");
//      }
//      else
//      {
//        printf(" \"%s\", ", Fonts[fi.iFamily][fi.iType]);
//      }
//      printf("\n");
//    }
//    printf("},\n");
//    fi.iFamily++;
//  }
//
//  return 0;
//}
#endif

