/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*****************************************************************************
 *
 * SOURCE FILE NAME = HP.C
 *
 * DESCRIPTIVE NAME = HP Color Features Dialog Box
 *
 *
 * VERSION = V1.0
 *
 * DATE
 *
 * AUTHORS      Debbie Cook, Larry Moore
 *
 * DESCRIPTION  Contains functions used to maINTain the color features page
 *              for the PostScript level 2 Job Properties dialog box.
 *
 * FUNCTIONS
 *            ColorFeaturePageDlgProc
 *            ColorOptDlgProc
 *            InitColorFeatProc
 *              GetCurrColorSmartPPDVal
 *              GetCurrColorModelPPDVal
 *              GetCurrPantonePPDVal
 *              SetCurrColorSmartPPDVal
 *              SetCurrColorModelPPDVal
 *              SetCurrPantonePPDVal
 *            InitOptionsProc
 *              GetCurrPrntrClrCntlPPDVal
 *              GetCurrHalftonePPDVal
 *              GetCurrAppHalftonePPDVal
 *              SetCurrPrntrClrCntlPPDVal
 *              SetCurrHalftonePPDVal
 *              SetCurrAppHalftonePPDVal
 *              SaveManColorControl
 *
 *
 * ORDER OF FUNCTIONS
 *              - ColorFeaturePateDlgProc - PM procedure for the Color Features
 *                                          page.
 *                - InitColorFeatProc - Initializes Color Features page controls.
 *                    - GetCurrColorSmartPPDVal -- gets ColorSmart value from PPD
 *                    - GetCurrColorModePPDVal -- gets Color Mode value from PPD
 *                    - GetCurrColorPantonePPDVal -- gets Pantone value from PPD
 *                    - SetCurrColorSmartPPDVal -- sets ColorSmart value
 *                    - SetCurrColorModePPDVal -- sets Color Mode value
 *                    - SetCurrColorPantonePPDVal -- sets Pantone value
 *              - ColorOptDlgProc - PM procedure for the Color Options dialog.
 *                - InitOptionsProc - Initializes Color Options dialog controls.
 *                    - GetCurrColorPrntrClrCntlPPDVal -- gets color control
 *                      values from PPD
 *                    - GetCurrHalftonePPDVal -- gets halftone value from PPD
 *                    - GetCurrAppHalftonePPDVal -- gets application halftone
 *                      value from PPD
 *                    - SaveManColorControl -- calls the set functions
 *                      - SetCurrColorPrntrClrCntlPPDVal -- sets color control
 *                        values
 *                      - SetCurrHalftonePPDVal -- sets halftone value
 *                      - SetCurrAppHalftonePPDVal -- sets application halftone
 *                        value
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
#pragma pack(1)
#define  INCL_WINHELP
#define  INCL_GPIBITMAPS         /* For BITMAPINFO structure */
#define  INCL_DOSPROCESS
#define  INCL_WINHOOKS
#define  INCL_DOSMODULEMGR
#define  INCL_WIN
#define  INCL_PM
#define  INCL_DOS
#define  INCL_SPLFSE
#define INCL_GENPLIB_WATERMARKS
#define INCL_GENPLIB_LAYOUT
#include <os2.h>
#include <string.h>
#include <stdlib.h>
#include <genplib.h>

#include "inc\config.h"                        // TAKE OUT LATER!!!!!!!!
#include "inc\ppdialog.h"                      // TAKE OUT LATER!!!!!!!!
#ifndef DDKBLD                                 
  #include "inc\os2_oem.h"
#endif
#include "inc\hp.h"
#include "inc\pspagtun.h"

static LPPDEVICE lppd = NULL;
static HPDLL     hpdll;

extern PFORMSTRUCT GetImageableArea( SHORT, PFORMSTRUCT, PDESPPD, PBYTE );


/******************************************************************************
 *
 * FUNCTION NAME = ColorFeaturePageDlgProc
 *
 * DESCRIPTION   Processes all messages sent to the Color Features dialog.
 *
 * INPUT
 * hDlg - Dialog handle
 * ulMsg - Message ID
 * mp1, mp2 - General message parameters
 *
 * OUTPUT
 * None
 *
 * RETURN-NORMAL - TRUE
 *                 FALSE
 * RETURN-ERROR  - None
 *
 *****************************************************************************/
MRESULT EXPENTRY ColorFeaturePageDlgProc( HWND hDlg, ULONG ulMsg,
                                          MPARAM mp1, MPARAM mp2 )
{
  MRESULT   mRC = (MRESULT) FALSE;   // Return code
  USHORT    usCheckState;
  INT       iStatus;

  switch( ulMsg )
  {
    /*
    ** Until the hp panel is migrated to a separate DLL,
    ** the panel needs to follow the procedures for the Job Properties
    ** dialog box.
    ** . . . change the WMPS_ message for save to WM_QUIT . . .
    */
    case WM_QUIT:
//      lppd = (LPPDEVICE) WinQueryWindowULong( hDlg, QWL_USER );
      /* save the current settings in PPD */
      SetCurrColorSmartPPDVal( ID_PPDSTR_KEY_COLORSMART, hpdll.iColorSmart);
      SetCurrColorModelPPDVal( ID_PPDSTR_KEY_COLORMODEL, hpdll.iColorModel);
      SetCurrPantonePPDVal   ( ID_PPDSTR_KEY_PANTONE,    hpdll.iPantone);
      mRC = (MRESULT) 0;
      break;

    case WM_INITDLG:
      /* DO SOMETHING HERE TO INIT EVERYTHING */
#if 0
      if ( !(LOUSHORT( mp1 )) )
      {
#endif
        lppd = (LPPDEVICE) mp2;
        WinSetWindowULong( hDlg, QWL_USER, (ULONG) lppd );

//        lppd = (LPPDEVICE) WinQueryWindowULong( hDlg, QWL_USER );
        InitColorFeatProc ( hDlg );

        /*
        ** Do this to force a repaint of the status bar icon.
        */
        WinPostMsg( hDlg, WM_CONTROL, MPFROMSHORT( JPCO_CHK_GRAY ),
                    (MPARAM) 0 );
//      }
      mRC = (MRESULT) TRUE;
      break;

    case WM_PAINT:
      WinDefDlgProc( hDlg, ulMsg, mp1, mp2 );
      CreateColorSmartBitmap(hDlg);
      break;

    case WM_COMMAND:                    /* Posted by pushbutton or key  */
      switch( LOUSHORT( mp1 ) )
      {
       case PSB_UNDO:
         lppd = (LPPDEVICE) WinQueryWindowULong( hDlg, QWL_USER );
         InitColorFeatProc ( hDlg );
         break;
       case PSB_DEFAULT:
         // set colorsmart to AUTOMATIC and disable options button
         WinSendMsg (WinWindowFromID( hDlg, JPCO_RAD_COLORSMART),
                     BM_CLICK, 0L, 0L );
         WinEnableControl ( hDlg, JPCO_MYOPTIONS2, FALSE );

         // uncheck grayscale and make sure it's enabled
         WinSendDlgItemMsg( hDlg, JPCO_CHK_GRAY, BM_SETCHECK,
                            (MPARAM) FALSE, (MPARAM) 0 );
         WinEnableWindow( WinWindowFromID( hDlg, JPCO_CHK_GRAY ), TRUE );

         // uncheck PANTONE (default)
         WinSendDlgItemMsg( hDlg, JPCO_PANTONE, BM_SETCHECK,
                            (MPARAM) FALSE, (MPARAM) 0 );
         WinEnableWindow( WinWindowFromID( hDlg, JPCO_PANTONE ), TRUE );

         break;

        case JPCO_MYOPTIONS2:
          WinDlgBox( HWND_DESKTOP,       /* Place anywhere on desktop    */
                     hDlg,               /* Owned by frame               */
                     ColorOptDlgProc,    /* Address of dialog procedure  */
                     (HMODULE)pscript_module, /* Module handle           */
                     JPNB_DLG_CONTONE,   /* Dialog identifier in resource*/
                     NULL);              /* Initialization data          */
          mRC = (MRESULT) TRUE;
          break;
      }
      break;

    case WM_CONTROL:
      switch( SHORT1FROMMP( mp1 ) )
      {
        case JPCO_RAD_COLORSMART:
          /* grey out the Option button */
          WinEnableControl ( hDlg, JPCO_MYOPTIONS2, FALSE );

          /* check to see if the grayscale button is checked */
          if (usCheckState = WinQueryButtonCheckstate ( hDlg, JPCO_CHK_GRAY ))
          {
            /* it's checked, so set the color model to grey */
            hpdll.iColorModel = (INT) 1;
          }
          else
          {
            /* it's not checked, so set the color model to CMYK */
            hpdll.iColorModel = (INT) 0;
          }
          /* Set the ColorSmart Value */
          hpdll.iColorSmart = (INT) 0;
          break;

        case JPCO_RAD_MAN_CLR:
          /* un-grey the Option button */
          WinEnableControl ( hDlg, JPCO_MYOPTIONS2, TRUE );

          /* check to see if the grayscale button is checked */
          if (usCheckState = WinQueryButtonCheckstate ( hDlg, JPCO_CHK_GRAY ))
          {
            /* it's checked, so set the color model to grey */
            hpdll.iColorModel = (INT) 1;
          }
          else
          {
            /* it's not checked, so set the color model to CMYK */
            hpdll.iColorModel = (INT) 0;
          }
          /* Set the ColorSmart Value */
          hpdll.iColorSmart = (INT) 1;
          break;

        case JPCO_CHK_GRAY:
          if (usCheckState = WinQueryButtonCheckstate ( hDlg, JPCO_CHK_GRAY ))
          {
            /* it's checked, so set the color model to grey */
            hpdll.iColorModel = (INT) 1;
//@V3.130814 -- update status bar
            // uncheck and disable the pantone button
            if (hpdll.iPantone == 1)
            {
              WinSendDlgItemMsg( hDlg, JPCO_PANTONE, BM_SETCHECK,
                                 (MPARAM) FALSE, (MPARAM) 0 );
              hpdll.iPantone = (INT) 0;
            }
            WinEnableWindow( WinWindowFromID( hDlg, JPCO_PANTONE ), FALSE );
            iStatus = FALSE;
          }
          else
          {
            /* it's not checked, so set the color model to CMYK */
            hpdll.iColorModel = (INT) 0;
//@V3.130814 -- update status bar
            OEMSetStatus( hDlg, (MPARAM) TRUE );
            // enable the pantone button
            WinEnableWindow( WinWindowFromID( hDlg, JPCO_PANTONE ), TRUE );
            iStatus = TRUE;
          }

          OEMSetStatus( hDlg, (MPARAM) iStatus );
          break;

        case JPCO_PANTONE:
          if (usCheckState = WinQueryButtonCheckstate ( hDlg, JPCO_PANTONE ))
          {
            hpdll.iPantone = (INT) 1;
            // uncheck and disable the grayscale button
            if (hpdll.iColorModel == 1)
            {
              WinSendDlgItemMsg( hDlg, JPCO_CHK_GRAY, BM_SETCHECK,
                                 (MPARAM) FALSE, (MPARAM) 0 );
              hpdll.iColorModel = (INT) 0;
            }
            WinEnableWindow( WinWindowFromID( hDlg, JPCO_CHK_GRAY ), FALSE );
          }
          else
          {
            hpdll.iPantone = (INT) 0;
            // enable the grayscale button
            WinEnableWindow( WinWindowFromID( hDlg, JPCO_CHK_GRAY ), TRUE );
          }
          break;

        default:
          mRC = WinDefDlgProc( hDlg, ulMsg, mp1, mp2 );
      }
      break;
    default:
      mRC = WinDefDlgProc( hDlg, ulMsg, mp1, mp2 );


  } //switch(ulMsg)

  return (MRESULT) mRC;
}
/*---------------------------------------------------------------------------*\
* ColorFeaturePageDlgProc End                                                 *
\*---------------------------------------------------------------------------*/



/*---------------------------------------------------------------------------*\
* ColorOptDlgProc                                                             *
\*---------------------------------------------------------------------------*/
/*********************************************************************
 * FUNCTION NAME = ColorOptDlgProc
 *
 * DESCRIPTION   Processes all messages sent to the Color Options dialog.
 *
 * INPUT
 * hDlg - Dialog handle
 * msg - Message ID
 * mp1, mp2 - General message parameters
 *
 * OUTPUT
 * None
 *
 * RETURN-NORMAL - TRUE
 *                 FALSE
 * RETURN-ERROR  - None
 *
 ****************************************************************/
MRESULT EXPENTRY ColorOptDlgProc( HWND hDlg, ULONG msg,
                                  MPARAM mp1, MPARAM mp2 )
{
  MRESULT   mRC = (MRESULT) FALSE;   // Return code
  USHORT    usCheckState;

  switch ( msg )
  {
    case WM_INITDLG:
      /* DO SOMETHING HERE TO INIT EVERYTHING */
      InitOptionsProc ( hDlg );
      mRC = (MRESULT) TRUE;
      break;

    case WM_CONTROL:
      /* If any of the controls were hit, save them in the hpdll structure    */
      /* for saving later on . . .                                            */
      switch( SHORT1FROMMP( mp1 ) )
      {
        case JPOP_TEXT_PCC_MS:
          hpdll.iPCCText = (INT) 1;
          break;

        case JPOP_TEXT_PCC_NA:
          hpdll.iPCCText = (INT) 2;
          break;

        case JPOP_TEXT_PCC_VC:
          hpdll.iPCCText = (INT) 0;
          break;

        case JPOP_TEXTHALFTONE_SMOOTH:
          hpdll.iTextHalftone = (INT) 0;
          break;

        case JPOP_TEXTHALFTONE_DETAIL:
          hpdll.iTextHalftone = (INT) 1;
          break;

        case JPOP_TEXTHALFTONE_BASIC:
          hpdll.iTextHalftone = (INT) 2;
          break;

        case JPOP_GRAF_PCC_MS:
          hpdll.iPCCGraf = (INT) 1;
          break;

        case JPOP_GRAF_PCC_NA:
          hpdll.iPCCGraf = (INT) 2;
          break;

        case JPOP_GRAF_PCC_VC:
          hpdll.iPCCGraf = (INT) 0;
          break;

        case JPOP_GRAFHALFTONE_SMOOTH:
          hpdll.iGrafHalftone = (INT) 0;
          break;

        case JPOP_GRAFHALFTONE_DETAIL:
          hpdll.iGrafHalftone = (INT) 1;
          break;

        case JPOP_GRAFHALFTONE_BASIC:
          hpdll.iGrafHalftone = (INT) 2;
          break;

        case JPOP_IMAG_PCC_MS:
          hpdll.iPCCImag = (INT) 1;
          break;

        case JPOP_IMAG_PCC_NA:
          hpdll.iPCCImag = (INT) 2;
          break;

        case JPOP_IMAG_PCC_VC:
          hpdll.iPCCImag = (INT) 0;
          break;

        case JPOP_IMAGHALFTONE_SMOOTH:
          hpdll.iImagHalftone = (INT) 0;
          break;

        case JPOP_IMAGHALFTONE_DETAIL:
          hpdll.iImagHalftone = (INT) 1;
          break;

        case JPOP_IMAGHALFTONE_BASIC:
          hpdll.iImagHalftone = (INT) 2;
          break;

        case JPOP_APPHALFTONE:
          if (usCheckState = WinQueryButtonCheckstate ( hDlg,
                                                        JPOP_APPHALFTONE ))
            hpdll.iAppHalftone = (INT) 1;
          else
            hpdll.iAppHalftone = (INT) 0;
          break;

      }
      break;

    case WM_COMMAND:                    /* Posted by pushbutton or key  */
      /*
       * PM sends a WM_COMMAND message when the user presses either
       * the Enter or Escape pushbuttons.
       */
      switch( SHORT1FROMMP( mp1 ) )     /* Extract the command value    */
      {
        case JPOP_DEFAULT_SETTINGS:
          /* set up the defaults again */
          DefaultOptionsProc ( hDlg );
          break;

        case DID_OK:                    /* The Enter pushbutton or key. */
          /* save the stuff from the dialog . . . */
          SaveManColorControl(hDlg);
          WinDismissDlg( hDlg, TRUE );  /* Removes the dialog box    */
          break;

        case DID_CANCEL:         /* The Cancel pushbutton or Escape key */
          WinDismissDlg( hDlg, TRUE );  /* Removes the dialog box    */
          break;

        default:
          break;
      }
      mRC = (MRESULT) FALSE;
      break;

    default:
      /*
       * Any event messages that the dialog procedure has not processed
       * come here and are processed by WinDefDlgProc.
       * This call MUST exist in your dialog procedure.
       */
      mRC = WinDefDlgProc( hDlg, msg, mp1, mp2 );
  }
  return (MRESULT) mRC;
}
/********************** End of dialog procedure  ************************/
/*---------------------------------------------------------------------------*\
* ColorOptDlgProc  End                                                        *
\*---------------------------------------------------------------------------*/



/*---------------------------------------------------------------------------*\
* InitColorFeatProc                                                           *
\*---------------------------------------------------------------------------*/
/*********************************************************************
 * FUNCTION NAME = InitColorFeatProc
 *
 * DESCRIPTION   Initializes the Color Features dialog.
 *
 * INPUT
 * hDlg - Dialog handle
 *
 * OUTPUT
 * None
 *
 * RETURN-NORMAL - None
 *
 * RETURN-ERROR  - None
 ****************************************************************/
VOID InitColorFeatProc( HWND hDlg )
{
  INT       iColorSmartIndex;
  INT       iColorModelIndex;

  // GET THE DEFAULTS FROM THE PPD FILES!!!!!!!
  /* Get the ColorSmart value and set the dialog buttons according to it      */
  if ( iColorSmartIndex = GetCurrColorSmartPPDVal ( ID_PPDSTR_KEY_COLORSMART ))
  {
    // MANUAL
    WinSendMsg (WinWindowFromID( hDlg, JPCO_RAD_MAN_CLR), BM_CLICK, 0L, 0L );
  }
  else
  {
    // AUTOMATIC (default)
    WinSendMsg (WinWindowFromID( hDlg, JPCO_RAD_COLORSMART), BM_CLICK, 0L, 0L );
  }

  /* Get the color model and set the checkbox accordingly                     */
  if ( iColorModelIndex = GetCurrColorModelPPDVal ( ID_PPDSTR_KEY_COLORMODEL ))
  {
    // uncheck PANTONE and disable it
    WinSendDlgItemMsg( hDlg, JPCO_PANTONE, BM_SETCHECK,
                       (MPARAM) FALSE, (MPARAM) 0 );
    WinEnableWindow( WinWindowFromID( hDlg, JPCO_PANTONE ), FALSE );

    // check GRAYSCALE
    WinSendDlgItemMsg( hDlg, JPCO_CHK_GRAY, BM_SETCHECK,
                       (MPARAM) TRUE, (MPARAM) 0 );
//@V3.130814 -- update status bar
    OEMSetStatus( hDlg, (MPARAM) FALSE );
  }
  else
  {
    // uncheck GRAYSCALE
    WinSendDlgItemMsg( hDlg, JPCO_CHK_GRAY, BM_SETCHECK,
                       (MPARAM) FALSE, (MPARAM) 0 );
    OEMSetStatus( hDlg, (MPARAM) TRUE );

    /* Get the pantone and set the checkbox accordingly                         */
    if ( iColorModelIndex = GetCurrPantonePPDVal ( ID_PPDSTR_KEY_PANTONE ))
    {
      WinEnableWindow( WinWindowFromID( hDlg, JPCO_CHK_GRAY ), FALSE );
    }
    else
    {
      // enable the GRAYSCALE
      WinEnableWindow( WinWindowFromID( hDlg, JPCO_CHK_GRAY ), TRUE );
    }
    // check/uncheck PANTONE
    WinSendDlgItemMsg( hDlg, JPCO_PANTONE, BM_SETCHECK,
                       (MPARAM) iColorModelIndex, (MPARAM) 0 );
  }

  // Call the init functions for the options dialog so that the correct
  // features are displayed on the PSCRIPT regular dialogs
#if 0
  GetCurrPrntrClrCntlPPDVal ( ID_PPDSTR_KEY_PCCTEXT);
  GetCurrPrntrClrCntlPPDVal ( ID_PPDSTR_KEY_PCCGRAF);
  GetCurrPrntrClrCntlPPDVal ( ID_PPDSTR_KEY_PCCIMAG);
  GetCurrHalftonePPDVal     ( ID_PPDSTR_KEY_TEXTHIGHHALFTONE);
  GetCurrHalftonePPDVal     ( ID_PPDSTR_KEY_GRAFHIGHHALFTONE);
  GetCurrHalftonePPDVal     ( ID_PPDSTR_KEY_IMAGHIGHHALFTONE);
  GetCurrAppHalftonePPDVal  ( ID_PPDSTR_KEY_APPHALFTONING );
#endif
  return;
}
/*---------------------------------------------------------------------------*\
* InitColorFeatProc  End                                                      *
\*---------------------------------------------------------------------------*/



/*---------------------------------------------------------------------------*\
* CreateColorSmartBitmap                                                      *
\*---------------------------------------------------------------------------*/
/*********************************************************************
 * FUNCTION NAME = CreateColorSmartBitmap
 *
 * DESCRIPTION   Creates the ColorSmart bitmap . . . this code was lifted from
 *               the Laserjet driver and modified.
 *
 * INPUT
 * hDlg - Dialog handle
 *
 * OUTPUT
 * None
 *
 * RETURN-NORMAL - None
 *
 * RETURN-ERROR  - None
 ****************************************************************/
LONG CreateColorSmartBitmap( HWND hDlg )
{
   BOOL        fOk;
   HPS         hPS;
   RECTL       rectl;
   HWND        hwndFrame;
   USHORT      bmHeight;
   USHORT      bmLength;
   HBITMAP     hBitmap;

   /* Get the frame to put the bitmap into. */
   hwndFrame = WinWindowFromID( hDlg, COLORSMART_BITMAP );
   WinQueryWindowRect(hwndFrame, &rectl);
   hPS       = WinGetPS(hwndFrame);

   /* Put the bitmap INSIDE the frame. */
   rectl.yBottom += 1;
   rectl.xLeft += 1;
   rectl.xRight -= 1;
   rectl.yTop -= 1;

   bmHeight    = rectl.yTop - rectl.yBottom;
   bmLength    = rectl.xRight - rectl.xLeft;

   // Load the bitmap.
   hBitmap = GpiLoadBitmap(hPS, pscript_module, BITMAP_COLORSMART,
                           (LONG) bmLength,(LONG) bmHeight);
   if (hBitmap == GPI_ERROR)
   {
//    DBPRINTF(("GpiLoadBitmap error\n"));
      return FALSE;
   }

   // Write the bitmap.
   fOk = (BOOL) WinDrawBitmap(hPS, hBitmap, NULL, (PPOINTL) &rectl, 0L, 0L,
                              DBM_STRETCH);
   if (!fOk)
   {
//    DBPRINTF(("WinDrawBitmap error\n"));
      return fOk;
   }

   fOk = GpiDeleteBitmap(hBitmap);
   WinReleasePS(hPS);
   return 0;
}
/*---------------------------------------------------------------------------*\
* CreateColorSmartBitmap end                                                  *
\*---------------------------------------------------------------------------*/



/*---------------------------------------------------------------------------*\
* InitOptionsProc                                                             *
\*---------------------------------------------------------------------------*/
/*********************************************************************
 * FUNCTION NAME = InitOptionsProc
 *
 * DESCRIPTION   Initializes the Color Options dialog.
 *
 * INPUT
 * hDlg - Dialog handle
 *
 * OUTPUT
 * None
 *
 * RETURN-NORMAL - None
 *
 * RETURN-ERROR  - None
 ****************************************************************/
VOID InitOptionsProc( HWND hDlg )
{
  INT       iColorIndex;
  INT       iHalftoneIndex;
  INT       iAppHalftoneIndex;
  INT       iLoop1;
  INT       iSetColorField;
  INT       iSetHalftoneField;

  /* check to see if grayscale is selected . . .          */
  /* display the appropriate dialog box                   */
  if (hpdll.iColorModel == (INT) 1)
  {
    /* disable the color icons and enable the gray icons */
    WinShowWindow ( WinWindowFromID( hDlg, JPSB_TEXT ), FALSE );
    WinShowWindow ( WinWindowFromID( hDlg, JPSB_GRAPHICS ), FALSE );
    WinShowWindow ( WinWindowFromID( hDlg, JPSB_IMAGE ), FALSE );
    WinShowWindow ( WinWindowFromID( hDlg, JPSB_GRAY_TEXT ), TRUE );
    WinShowWindow ( WinWindowFromID( hDlg, JPSB_GRAY_GRA ), TRUE );
    WinShowWindow ( WinWindowFromID( hDlg, JPSB_GRAY_IMA ), TRUE );
  }
  else
  {
    /* disable the gray icons and enable the color icons */
    WinShowWindow ( WinWindowFromID( hDlg, JPSB_TEXT ), TRUE );
    WinShowWindow ( WinWindowFromID( hDlg, JPSB_GRAPHICS ), TRUE );
    WinShowWindow ( WinWindowFromID( hDlg, JPSB_IMAGE ), TRUE );
    WinShowWindow ( WinWindowFromID( hDlg, JPSB_GRAY_TEXT ), FALSE );
    WinShowWindow ( WinWindowFromID( hDlg, JPSB_GRAY_GRA ), FALSE );
    WinShowWindow ( WinWindowFromID( hDlg, JPSB_GRAY_IMA ), FALSE );
  }

  /* THE DEFAULTS ARE SET FROM THE PPD FILES!!!!!!!                          */
  /* Go through the loop 3 times to check for text, graphics, and photo      */
  /* for Printed Color Control (GetCurrPrntrClrCntlPPDVal), COLOREt and      */
  /* Normal Halftoning (GetCurrHalftonePPDVal).  Set the dialog defaults     */
  /* according to the results; also save the results in the hpdll structure  */
  /* for saving later on.                                                    */

  for ( iLoop1 = 0 ; iLoop1 < 3 ; iLoop1++)
  {
    switch (iLoop1)
    {
      case 0:
        iColorIndex = GetCurrPrntrClrCntlPPDVal ( ID_PPDSTR_KEY_PCCTEXT);
        switch (iColorIndex)
        {
          case 1:
            // MATCH COLOR ACROSS PRINTERS
            iSetColorField = JPOP_TEXT_PCC_MS;
            hpdll.iPCCText = (INT) 1;
            break;
          case 2:
            // NO ADJUSTMENT
            iSetColorField = JPOP_TEXT_PCC_NA;
            hpdll.iPCCText = (INT) 2;
            break;
          default:
            // VIVID COLOR (default)
            iSetColorField = JPOP_TEXT_PCC_VC;
            hpdll.iPCCText = (INT) 0;
        }
        iHalftoneIndex = GetCurrHalftonePPDVal (
                         ID_PPDSTR_KEY_TEXTHIGHHALFTONE );
        switch (iHalftoneIndex)
        {
          case 0:
            // SMOOTH
            iSetHalftoneField = JPOP_TEXTHALFTONE_SMOOTH;
            hpdll.iTextHalftone = (INT) 0;
            break;
          case 1:
            // DETAIL (default)
            iSetHalftoneField = JPOP_TEXTHALFTONE_DETAIL;
            hpdll.iTextHalftone = (INT) 1;
            break;
          case 2:
            // BASIC
            iSetHalftoneField = JPOP_TEXTHALFTONE_BASIC;
            hpdll.iTextHalftone = (INT) 2;
        }
        break;
      case 1:
        iColorIndex = GetCurrPrntrClrCntlPPDVal ( ID_PPDSTR_KEY_PCCGRAF );
        switch (iColorIndex)
        {
          case 1:
            // MATCH COLOR ACROSS PRINTERS
            iSetColorField = JPOP_GRAF_PCC_MS;
            hpdll.iPCCGraf = (INT) 1;
            break;
          case 2:
            // NO ADJUSTMENT
            iSetColorField = JPOP_GRAF_PCC_NA;
            hpdll.iPCCGraf = (INT) 2;
            break;
          default:
            // VIVID COLOR (default)
            iSetColorField = JPOP_GRAF_PCC_VC;
            hpdll.iPCCGraf = (INT) 0;
        }
        iHalftoneIndex = GetCurrHalftonePPDVal (
                         ID_PPDSTR_KEY_GRAFHIGHHALFTONE );
        switch (iHalftoneIndex)
        {
          case 0:
            // SMOOTH
            iSetHalftoneField = JPOP_GRAFHALFTONE_SMOOTH;
            hpdll.iGrafHalftone = (INT) 0;
            break;
          case 1:
            // DETAIL (default)
            iSetHalftoneField = JPOP_GRAFHALFTONE_DETAIL;
            hpdll.iGrafHalftone = (INT) 1;
            break;
          case 2:
            // BASIC
            iSetHalftoneField = JPOP_GRAFHALFTONE_BASIC;
            hpdll.iGrafHalftone = (INT) 2;
        }
        break;
      case 2:
        iColorIndex = GetCurrPrntrClrCntlPPDVal( ID_PPDSTR_KEY_PCCIMAG );
        switch (iColorIndex)
        {
          case 1:
            // MATCH COLOR ACROSS PRINTERS
            iSetColorField = JPOP_IMAG_PCC_MS;
            hpdll.iPCCImag = (INT) 1;
            break;
          case 2:
            // NO ADJUSTMENT
            iSetColorField = JPOP_IMAG_PCC_NA;
            hpdll.iPCCImag = (INT) 2;
            break;
          default:
            // VIVID COLOR (default)
            iSetColorField = JPOP_IMAG_PCC_VC;
            hpdll.iPCCImag = (INT) 0;
        }
        iHalftoneIndex = GetCurrHalftonePPDVal (
                         ID_PPDSTR_KEY_IMAGHIGHHALFTONE );
        switch (iHalftoneIndex)
        {
          case 0:
            // SMOOTH
            iSetHalftoneField = JPOP_IMAGHALFTONE_SMOOTH;
            hpdll.iImagHalftone = (INT) 0;
            break;
          case 1:
            // DETAIL (default)
            iSetHalftoneField = JPOP_IMAGHALFTONE_DETAIL;
            hpdll.iImagHalftone = (INT) 1;
            break;
          case 2:
            // BASIC
            iSetHalftoneField = JPOP_IMAGHALFTONE_BASIC;
            hpdll.iImagHalftone = (INT) 2;
        }
        break;
    }

    WinSendMsg (WinWindowFromID( hDlg, iSetColorField ), BM_CLICK, 0L, 0L );
    WinSendMsg (WinWindowFromID( hDlg, iSetHalftoneField ), BM_CLICK, 0L, 0L );
  }

  /* Get the defaults for Application Halftoning                             */
  /* (GetCurrAppHalftonePPDVal) and set the dialog defaults according        */
  /* to the results.                                                         */
  if (iAppHalftoneIndex = GetCurrAppHalftonePPDVal(
                          ID_PPDSTR_KEY_APPHALFTONING ))
  {
    hpdll.iAppHalftone = (INT) 1;
  }
  else
  {
    hpdll.iAppHalftone = (INT) 0;
  }
  // check or uncheck APPLICATION HALFTONING
  WinSendDlgItemMsg( hDlg, JPOP_APPHALFTONE, BM_SETCHECK,
                     (MPARAM) hpdll.iAppHalftone, (MPARAM) 0 );

  return;
}
/*---------------------------------------------------------------------------*\
* InitOptionsProc  End                                                        *
\*---------------------------------------------------------------------------*/



/*---------------------------------------------------------------------------*\
* DefaultOptionsProc                                                             *
\*---------------------------------------------------------------------------*/
/*********************************************************************
 * FUNCTION NAME = DefaultOptionsProc
 *
 * DESCRIPTION   Defaults the Color Options dialog.
 *
 * INPUT
 * hDlg - Dialog handle
 *
 * OUTPUT
 * None
 *
 * RETURN-NORMAL - None
 *
 * RETURN-ERROR  - None
 ****************************************************************/
VOID DefaultOptionsProc( HWND hDlg )
{
  INT       iLoop1;
  INT       iSetColorField;
  INT       iSetHalftoneField;

  for ( iLoop1 = 0 ; iLoop1 < 3 ; iLoop1++)
  {
    switch (iLoop1)
    {
      case 0:
        iSetColorField = JPOP_TEXT_PCC_VC;
        iSetHalftoneField = JPOP_TEXTHALFTONE_DETAIL;
        hpdll.iPCCText = (INT) 0;
        hpdll.iTextHalftone = (INT) 1;
        break;
      case 1:
        iSetColorField = JPOP_GRAF_PCC_VC;
        iSetHalftoneField = JPOP_GRAFHALFTONE_DETAIL;
        hpdll.iPCCGraf = (INT) 0;
        hpdll.iGrafHalftone = (INT) 1;
        break;
      case 2:
        iSetColorField = JPOP_IMAG_PCC_VC;
        iSetHalftoneField = JPOP_IMAGHALFTONE_DETAIL;
        hpdll.iPCCImag = (INT) 0;
        hpdll.iImagHalftone = (INT) 1;
    }

    WinSendMsg (WinWindowFromID( hDlg, iSetColorField ), BM_CLICK, 0L, 0L );
    WinSendMsg (WinWindowFromID( hDlg, iSetHalftoneField ), BM_CLICK, 0L, 0L );
  }

  hpdll.iAppHalftone = (INT) 0;
  WinSendDlgItemMsg( hDlg, JPOP_APPHALFTONE, BM_SETCHECK,
                     (MPARAM) hpdll.iAppHalftone, (MPARAM) 0 );

  return;
}
/*---------------------------------------------------------------------------*\
* DefaultOptionsProc  End                                                     *
\*---------------------------------------------------------------------------*/


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*\
* END OF DIALOG PROCS -- now do the real work                                 *
*                   !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!                            *
\*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/


/****************************************************************************

  function: GetCurrPrntrClrCntlPPDVal

  PURPOSE:
       This routine gets the current option string for a PPD keywords
       ID_PPDSTR_KEY_PCCTEXT, ID_PPDSTR_KEY_PCCGRAF, and ID_PPDSTR_KEY_PCCIMAG,
       as specified in the input parm keyword_id.

  arguments:
       keyword_id - resource string table id for keyword

  returns: 2 if the keyword option is "NoAdjust"
           1 if the keyword option is "MatchScreen"
           0 if the keyword option is "Vivid" or not found (default)

****************************************************************************/
INT GetCurrPrntrClrCntlPPDVal( PSZ keyword)
{
  INT     result;
  INT     rc;
//CHAR    keyword[MAX_KEYWORD_LEN]; @V3.0130814
  CHAR    option[MAX_KEYWORD_LEN];
  INT     tmpi = 0;
  LPKEYWORDLISTREC PPDList = 0;

//memset((PSZ)keyword, 0, MAX_KEYWORD_LEN);  @V3.0130814
  memset((PSZ)option, 0, MAX_KEYWORD_LEN);
//LoadDrvrString( lppd, keyword_id, keyword, sizeof(keyword)) ; @V3.0130814
  rc = KeywordListGetCurrentOption(lppd, PPDList, keyword, option,
                                   sizeof(option), &tmpi) ;

  if ((INT)rc == TRUE )
  {
    if (strcmp(option, "NoAdjust") == 0)
      result = 2;
    else if (strcmp(option, "MatchScreen") == 0)
      result = 1;
    else if (strcmp(option, "Vivid") == 0)
      result = 0;
    else
      result = 0;
  }
  else
    result = 0;

  return(result) ;
}



/****************************************************************************

  function: GetCurrHalftonePPDVal

  PURPOSE:
       This routine gets the current option string for PPD keywords
       ID_PPDSTR_KEY_TEXTHIGHHALFTONE, ID_PPDSTR_KEY_GRAFHIGHHALFTONE,
       ID_PPDSTR_KEY_IMAGHIGHHALFTONE, as specified in the input parm keyword_id.

  arguments:
       keyword_id - resource string table id for keyword

  returns: 1 if the keyword option is "Smooth"
           0 if the keyword option is "Detail" or not found (default)

****************************************************************************/
INT GetCurrHalftonePPDVal( PSZ keyword)
{
  INT     result;
  INT     rc;
//CHAR    keyword[MAX_KEYWORD_LEN];  @V3.0130814
  CHAR    option[MAX_KEYWORD_LEN];
  INT     tmpi = 0;
  LPKEYWORDLISTREC PPDList = 0;

//memset((PSZ)keyword, 0, MAX_KEYWORD_LEN);  @V3.0130814
  memset((PSZ)option, 0, MAX_KEYWORD_LEN);
//LoadDrvrString( lppd, keyword_id, keyword, sizeof(keyword)) ; @V3.0130814
  rc = KeywordListGetCurrentOption(lppd, PPDList, keyword, option,
                                     sizeof(option), &tmpi) ;
  if ((INT)rc == TRUE )
  {
    if (strcmp(option, "Smooth" ) == 0 )
      result = 0;
    else if (strcmp(option, "Detail" ) == 0 )
      result = 1;
    else if (strcmp(option, "Basic" ) == 0 )
      result = 2;
    else
      result = 1;
  }
  else
    result = 1;

  return(result) ;
}



/****************************************************************************

  function: GetCurrAppHalftonePPDVal

  PURPOSE:
       This routine gets the current option string for a PPD keyword
       ID_PPDSTR_KEY_APPHALFTONING,
       as specified in the input parm keyword_id.

  arguments:
       keyword_id - resource string table id for keyword

  returns: 1 if the keyword option is "True"
           0 if the keyword option is "False" or not found (default)

****************************************************************************/
INT GetCurrAppHalftonePPDVal( PSZ keyword)
{
  INT     result;
  INT     rc;
//CHAR    keyword[MAX_KEYWORD_LEN];  @V3.0130814
  CHAR    option[MAX_KEYWORD_LEN];
  INT     tmpi = 0;
  LPKEYWORDLISTREC PPDList = 0;

//memset((PSZ)keyword, 0, MAX_KEYWORD_LEN);  @V3.0130814
  memset((PSZ)option, 0, MAX_KEYWORD_LEN);
//LoadDrvrString( lppd, keyword_id, keyword, sizeof(keyword)) ; @V3.0130814
  rc = KeywordListGetCurrentOption(lppd, PPDList, keyword, option,
                                     sizeof(option), &tmpi) ;
  if ((INT)rc == TRUE )
  {
    if (strcmp(option, "True") == 0)
      result = 1;
    else if (strcmp(option, "False") == 0)
      result = 0;
    else
      result = 0;
  }
  else
    result = 0;

  return(result) ;
}



/****************************************************************************

  function: GetCurrPantonePPDVal

  PURPOSE:
       This routine gets the current option string for a PPD keyword
       ID_PPDSTR_KEY_PANTONE,
       as specified in the input parm keyword_id.

  arguments:
       keyword_id - resource string table id for keyword

  returns: 1 if the keyword option is "True"
           0 if the keyword option is "False" or not found (default)

****************************************************************************/
INT GetCurrPantonePPDVal( PSZ keyword)
{
  INT     result;
  INT     rc;
//CHAR    keyword[MAX_KEYWORD_LEN];   @V3.0130814
  CHAR    option[MAX_KEYWORD_LEN];
  INT     tmpi = 0;
  LPKEYWORDLISTREC PPDList = 0;

//memset((PSZ)keyword, 0, MAX_KEYWORD_LEN);  @V3.0130814
  memset((PSZ)option, 0, MAX_KEYWORD_LEN);
//LoadDrvrString( lppd, keyword_id, keyword, sizeof(keyword)) ; @V3.0130814
  rc = KeywordListGetCurrentOption(lppd, PPDList, keyword, option,
                                     sizeof(option), &tmpi) ;
  if ((INT)rc == TRUE )
  {
    if (strcmp(option, "True") == 0)
      result = 1;
    else if (strcmp(option, "False") == 0)
      result = 0;
    else
      result = 0;
  }
  else
    result = 0;

  return(result) ;
}



/****************************************************************************

  function: GetCurrColorModelPPDVal

  PURPOSE:
       This routine gets the current option string for a PPD keyword
       ID_PPDSTR_KEY_COLORMODEL.

  arguments:
       keyword_id - resource string table id for keyword

  returns: 0 if the keyword option is "CMYK" or not found (default)
           1 if the keyword option is "Gray"

****************************************************************************/
INT GetCurrColorModelPPDVal( PSZ keyword)
{
  INT     result;
  INT     rc;
//CHAR    keyword[MAX_KEYWORD_LEN];   @V3.0130814
  CHAR    option[MAX_KEYWORD_LEN];
  INT     tmpi = 0;
  LPKEYWORDLISTREC PPDList = 0;

//memset((PSZ)keyword, 0, MAX_KEYWORD_LEN);  @V3.0130814
  memset((PSZ)option, 0, MAX_KEYWORD_LEN);
//LoadDrvrString( lppd, keyword_id, keyword, sizeof(keyword)) ; @V3.0130814
  rc = KeywordListGetCurrentOption(lppd, PPDList, keyword, option,
                                     sizeof(option), &tmpi) ;
  if ((INT)rc == TRUE )
  {
    if (strcmp(option, "Gray") == 0)
      result = 1;
    else if (strcmp(option, "CMYK") == 0)
      result = 0;
    else
      result = 0;
  }
  else
    result = 0;

  return(result) ;
}



/****************************************************************************

  function: GetCurrColorSmartPPDVal

  PURPOSE:
       This routine gets the current option string for a PPD keyword
       ID_PPDSTR_KEY_COLORSMART.

  arguments:
       keyword_id - resource string table id for keyword

  returns: 1 if the keyword option is "Manual"
           0 if the keyword option is "Auto" or not found (default)

****************************************************************************/
INT GetCurrColorSmartPPDVal( PSZ keyword)
{
  INT     result;
  INT     rc;
//CHAR    keyword[MAX_KEYWORD_LEN];   @V3.0130814
  CHAR    option[MAX_KEYWORD_LEN];
  INT     tmpi = 0;
  LPKEYWORDLISTREC PPDList = 0;

//memset((PSZ)keyword, 0, MAX_KEYWORD_LEN);  @V3.0130814
  memset((PSZ)option, 0, MAX_KEYWORD_LEN);
//LoadDrvrString( lppd, keyword_id, keyword, sizeof(keyword)) ; @V3.0130814
  rc = KeywordListGetCurrentOption(lppd, PPDList, keyword, option,
                                     sizeof(option), &tmpi) ;
  if ((INT)rc == TRUE )
  {
    if (strcmp(option, "Manual") == 0)
      result = 1;
    else if (strcmp(option, "Auto") == 0)
      result = 0;
    else
      result = 0;
  }
  else
    result = 0;

  return(result) ;

}




/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*\
* THE SETS . . .                                                              *
*                   !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!                            *
\*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/



/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*
**OPTION DIALOG SETS:


  function: SaveManColorControl

  PURPOSE:
       This routine saves the settings from the Color Options dialog.

  arguments:
       hDlg - Dialog handle

  returns:

****************************************************************************/
void SaveManColorControl ( HWND hDlg )

{
  INT       iLoop;
  INT       iSetVal1;
  INT       iSetVal2;
  PSZ       szSetField1;  //@V3.0130814 -- CHANGE FROM INT
  PSZ       szSetField2;  // "

  /****************************************************************************/
  /* Set Color Map and Halftone vals                                          */
  /* NOTE:  szSetField1 is the Color Map val;  szSetField2 is the Halftone    */
  /*        val, which is set according to which dialog is being displayed:   */
  /*        ID_PPDSTR_KEY_XXXHIGHHALFTONE for High Quality COLOREt, and       */
  /*        ID_PPDSTR_KEY_XXXNORMHALFTONE for normal                          */
  /****************************************************************************/
  for ( iLoop = 0 ; iLoop < 3 ; iLoop++ )
  {
    switch (iLoop)
    {
      case 0:
        szSetField1 = ID_PPDSTR_KEY_PCCTEXT;
        iSetVal1 = hpdll.iPCCText;

        szSetField2 = ID_PPDSTR_KEY_TEXTHIGHHALFTONE;
        iSetVal2 = hpdll.iTextHalftone;
        break;

      case 1:
        szSetField1 = ID_PPDSTR_KEY_PCCGRAF;
        iSetVal1 = hpdll.iPCCGraf;

        szSetField2 = ID_PPDSTR_KEY_GRAFHIGHHALFTONE;
        iSetVal2 = hpdll.iGrafHalftone;
        break;

      case 2:
        szSetField1 = ID_PPDSTR_KEY_PCCIMAG;
        iSetVal1 = hpdll.iPCCImag;

        szSetField2 = ID_PPDSTR_KEY_IMAGHIGHHALFTONE;
        iSetVal2 = hpdll.iImagHalftone;
      break;
    }
    SetCurrPrntrClrCntlPPDVal( szSetField1, iSetVal1 );
    SetCurrHalftonePPDVal( szSetField2, iSetVal2 );
  }

  /* set the app halftone val                                                 */
  SetCurrAppHalftonePPDVal( ID_PPDSTR_KEY_APPHALFTONING,
                            hpdll.iAppHalftone);

  return;
}



/****************************************************************************

  function: SetCurrPrntrClrCntlPPDVal

  PURPOSE:
       This routine sets the current option string for a PPD keywords
       ID_PPDSTR_KEY_PCCTEXT, ID_PPDSTR_KEY_PCCGRAF, and ID_PPDSTR_KEY_PCCIMAG,
       as specified in the input parm keyword_id.

  arguments:
       keyword_id - resource string table id for keyword
       val -

  returns:

****************************************************************************/
INT SetCurrPrntrClrCntlPPDVal( PSZ keyword, INT val )
{
  INT     result;
  INT     rc = 0;
  CHAR    val_string[MAX_OPTION_LEN] ;
//CHAR    keyword[MAX_KEYWORD_LEN];  @V3.0130814
  LPKEYWORDLISTREC PPDList = 0;

//LoadDrvrString( lppd, keyword_id, keyword, sizeof(keyword)) ; @V3.0130814
  if (val == 0)
    strcpy((PSZ)val_string, "Vivid");
  else if (val == 1)
    strcpy((PSZ)val_string, "MatchScreen");
  else if (val == 2)
    strcpy((PSZ)val_string, "NoAdjust");

  rc = KeywordListSetCurrentOptionDialog(lppd, PPDList, keyword, val_string, 0);
  if ( rc == (INT) TRUE )
    result = val;
  else
    result = RC_not_found;

  return(result);
}



/****************************************************************************

  function: SetCurrHalftonePPDVal

  PURPOSE:
       This routine sets the current option string for PPD keywords
       ID_PPDSTR_KEY_TEXTHIGHHALFTONE, ID_PPDSTR_KEY_GRAFHIGHHALFTONE,
       ID_PPDSTR_KEY_IMAGHIGHHALFTONE,
       as specified in the input parm keyword_id.

  arguments:
       keyword_id - resource string table id for keyword
       val -

  returns:

****************************************************************************/
//@V3.0130814 -- change from INT keyword_id TO PSZ Keyword
INT SetCurrHalftonePPDVal( PSZ keyword, INT val )
{
  INT     result;
  INT     rc = 0;
  CHAR    val_string[MAX_OPTION_LEN] ;
//CHAR    keyword[MAX_KEYWORD_LEN];  @V3.0130814
  LPKEYWORDLISTREC PPDList = 0;

//LoadDrvrString( lppd, keyword_id, keyword, sizeof(keyword)) ; @V3.0130814
  if (val == 0)
    strcpy((PSZ)val_string, "Smooth");
  else if (val == 1)
    strcpy((PSZ)val_string, "Detail");
  else if (val == 2)
    strcpy((PSZ)val_string, "Basic");

  rc = KeywordListSetCurrentOptionDialog(lppd, PPDList, keyword, val_string, 0);
  if ( rc == (INT) TRUE )
    result = val;
  else
    result = RC_not_found;

  return(result) ;
}



/****************************************************************************

  function: SetCurrAppHalftonePPDVal

  PURPOSE:
       This routine sets the current option string for a PPD keywords
       ID_PPDSTR_KEY_APPHALFTONING,
       as specified in the input parm keyword_id.

  arguments:
       keyword_id - resource string table id for keyword
       val -

  returns:

****************************************************************************/
//@V3.0130814 -- change from INT keyword_id TO PSZ Keyword
INT SetCurrAppHalftonePPDVal( PSZ keyword, INT val )
{
  INT     result;
  INT     rc = 0;
  CHAR    val_string[MAX_OPTION_LEN] ;
//CHAR    keyword[MAX_KEYWORD_LEN];  @V3.0130814
  LPKEYWORDLISTREC PPDList = 0;

//LoadDrvrString( lppd, keyword_id, keyword, sizeof(keyword)) ; @V3.0130814
  if (val == 0)
    strcpy((PSZ)val_string, "False");
  else if (val == 1)
    strcpy((PSZ)val_string, "True");

  rc = KeywordListSetCurrentOptionDialog(lppd, PPDList, keyword, val_string, 0);
  if ( rc == (INT) TRUE )
    result = val;
  else
    result = RC_not_found;

  return(result) ;
}



//***************************************************************************
// COLOR FEATURE PAGE SETS:
/****************************************************************************

  function: SetCurrColorSmartPPDVal

  PURPOSE:
       This routine sets the current option string for a PPD keyword
       ID_PPDSTR_KEY_COLORSMART.

  arguments:
       keyword_id - resource string table id for keyword
       val -

  returns:

****************************************************************************/
//@V3.0130814 -- change from INT keyword_id TO PSZ Keyword
INT SetCurrColorSmartPPDVal( PSZ keyword, INT val )
{
  INT     result;
  INT     rc = 0;
  CHAR    val_string[MAX_OPTION_LEN] ;
//CHAR    keyword[MAX_KEYWORD_LEN];  @V3.0130814
  LPKEYWORDLISTREC PPDList = 0;

//LoadDrvrString( lppd, keyword_id, keyword, sizeof(keyword)) ; @V3.0130814
  if (val == 0)
    strcpy((PSZ)val_string, "Auto");
  else if (val == 1)
    strcpy((PSZ)val_string, "Manual");

  rc = KeywordListSetCurrentOption(lppd, PPDList, keyword, val_string, 0);
  if ( rc == (INT) TRUE )
    result = val;
  else
    result = RC_not_found;

  return(result) ;
}



/****************************************************************************
  function: SetCurrColorModelPPDVal

  PURPOSE:
       This routine sets the current option string for a PPD keyword
       ID_PPDSTR_KEY_COLORMODEL.

  arguments:
       keyword_id - resource string table id for keyword
       val -

  returns:

****************************************************************************/
//@V3.0130814 -- change from INT keyword_id TO PSZ Keyword
INT SetCurrColorModelPPDVal( PSZ keyword, INT val )
{
  INT     result;
  INT     rc = 0;
  CHAR    val_string[MAX_OPTION_LEN] ;
//CHAR    keyword[MAX_KEYWORD_LEN];  @V3.0130814
  LPKEYWORDLISTREC PPDList = 0;

//LoadDrvrString( lppd, keyword_id, keyword, sizeof(keyword)) ; @V3.0130814
  if (val == 0)
    strcpy((PSZ)val_string, "CMYK");
  else if (val == 1)
    strcpy((PSZ)val_string, "Gray");

  rc = KeywordListSetCurrentOption(lppd, PPDList, keyword, val_string, 0);
  if ( rc == (INT) TRUE )
    result = val;
  else
    result = RC_not_found;

  return(result) ;
}



/****************************************************************************

  function: SetCurrPantonePPDVal

  PURPOSE:
       This routine sets the current option string for a PPD keyword
       ID_PPDSTR_KEY_PANTONE,
       as specified in the input parm keyword_id.

  arguments:
       keyword_id - resource string table id for keyword
       val -

  returns:

****************************************************************************/
//@V3.0130814 -- change from INT keyword_id TO PSZ Keyword
INT SetCurrPantonePPDVal( PSZ keyword, INT val )
{
  INT     result;
  INT     rc = 0;
  CHAR    val_string[MAX_OPTION_LEN] ;
//CHAR    keyword[MAX_KEYWORD_LEN];  @V3.0130814
  LPKEYWORDLISTREC PPDList = 0;

//LoadDrvrString( lppd, keyword_id, keyword, sizeof(keyword)) ; @V3.0130814
  if (val == 0)
    strcpy((PSZ)val_string, "False");
  else if (val == 1)
    strcpy((PSZ)val_string, "True");

  rc = KeywordListSetCurrentOption(lppd, PPDList, keyword, val_string, 0);
  if ( rc == (INT) TRUE )
    result = val;
  else
    result = RC_not_found;

  return(result) ;
}
