/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
#define   INCL_PM
#include   <os2.h>

#include	"inc\enumpage.h"

BOOL EnumNotebookPages( HWND      hwndNotebook,
                        ULONG     CommandID,
                        PMRESULT  pRC )
{
   HWND      hwndPage;      
   ULONG     PageID;
   
   // assume all notebook pages responses with success status
   *pRC = PMERR_OK;
   
   // query notebook first page ID
   PageID = (ULONG) WinSendMsg( hwndNotebook,
                                BKM_QUERYPAGEID,
                                (MPARAM) 0,
                                MPFROMLONG(BKA_FIRST) );
      
   // enumerate all notebook pages
   while ( PageID && PageID != BOOKERR_INVALID_PARAMETERS )
   {
      // query page window handle
      hwndPage = (HWND)
      WinSendMsg( hwndNotebook, 
                  BKM_QUERYPAGEWINDOWHWND, 
                  MPFROMLONG(PageID), 
                  (MPARAM)0 );
         
      // check that page handle is correct  
      if ( hwndPage != NULLHANDLE
           && hwndPage != BOOKERR_INVALID_PARAMETERS )
      {
         // notify current notebook page using specified command
         *pRC = (MRESULT) WinSendMsg( hwndPage,
                                      CommandID,
                                      (MPARAM) 0,
                                      (MPARAM) 0 );
            
         // check that notebook page fails
         if ( *pRC != PMERR_OK )
         {
            //
            // If PMERR_OK didn't get from page should go out from function
            // and activate this page in verify message processing 
            //
            return FALSE;
         }   
      }
         
      // query next page ID
      PageID = (ULONG) WinSendMsg( hwndNotebook,
                                   BKM_QUERYPAGEID,
                                   MPFROMLONG(PageID),
                                   MPFROMLONG(BKA_NEXT) );
   }
      
   // all notebook pages notified successfully 
   return TRUE;
}

BOOL SaveDialogSettings( HWND hDlg )
{
   MRESULT   RC;
   BOOL      fSuccess;
   
   //
   // notify all notebook pages about settings verify moment. 
   //
   fSuccess = (BOOL) EnumNotebookPages( hDlg,
                                        WM_VERIFYSETTINGS,
                                        &RC );
      
   // check that all pages confirm their settings is OK
   if ( fSuccess && RC == PMERR_OK )
   {
      // notify all notebook pages about save settings
      fSuccess = (BOOL) EnumNotebookPages( hDlg,
                                           WM_SAVESETTINGS,
                                           &RC );
   }
      
   // return last notification result to caller
   return (fSuccess && RC == PMERR_OK) ? TRUE : FALSE;
}
