/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = DEVMODE.C
 *
 * DESCRIPTIVE NAME = Contains OS2_PM_DRV_DEVMODE.
 *
 *
 * VERSION = V2.0
 *
 * DATE      09/16/89
 *
 * DESCRIPTION  This file contains OS2_PM_DRV_DEVMODE.
 *
 *
 * FUNCTIONS
 *                 OS2_PM_DRV_DEVMODE
 *                 CheckPrinterName
 *                 GetPrinterName
 *
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *      extern HMODULE hModPS;
 *      extern PBYTE StringTable[MAX_STRINGS];
 *
 * EXTERNAL FUNCTIONS
 *      extern ULONG   GplErrSetError;
 *      extern BOOL   ValidateDriveData(PLDRIVDATA,PCNFDATA);
 *
*/
#pragma pack(1)
#define  INCL_DEV
#define  INCL_WINERRORS
#define INCL_DOSPROCESS                                                  //@V3.0118732
#define INCL_DOSFILEMGR                                                  //@DJP
#define INCL_DOSMISC                                                     //@DJP
#include <string.h>
#include <stdlib.h>
#include "inc\prdinclt.h"
#include "inc\prdgextf.h"
#include "inc\prdmath.h"
#include "inc\prdrsrc.h"
#include "inc\utl.h"
#include "inc\config.h"
#include "inc\pspagtun.h"              /* V2.174057   Page Tuning */
#define  INCL_GENPLIB_ERROR
#define  INCL_GENPLIB_MEMORY
#define  INCL_GENPLIB_GPLUTIL
#include <genplib.h>
#include <assert.h>
#include "inc\init.h"
// @V4.0169885
#include "inc\uinames.h"

#define  INCL_WINSHELLDATA
#define  INCL_INCL_WINSHELLDATA

extern HMODULE pscript_module;                 /* memory.c */
extern PBYTE StringTable[MAX_STRINGS]; /* memory.c */
extern PVOID pProcessHeap;
// extern BOOL   ValidateDriveData(PLDRIVDATA,PCNFDATA);
extern BOOL ValidateDriveData( PLDRIVDATA, PDESPPD, PCNFDATA );
extern LONG ProfileAllocStringQuery( HINI, PSZ, PSZ, PSZ, PPVOID );
extern LONG UsePrinterDeviceFonts( VOID );                        //@V3.0124227

// @V3.0129238
PCNFDATA AllocCNFStructure( PDESPPD, BOOL );
BOOL VerifyLDDCNFStructure( PDESPPD, PLDRIVDATA, ULONG );
VOID FreeCNFStructure( PCNFDATA );

// @V3.0130814
VOID CopyCNFData( PCNFDATA, PCNFDATA, UINT, UINT );
extern PDESPPD LoadPPBResource( PDV, PSZ );                              //@DJP
extern VOID LoadCurrentUISelections( PDESPPD, PCNFDATA );
extern VOID MapPaperAndInputslots( PDESPPD, PCNFDATA );


static PSZ pm_spooler_printer = "PM_SPOOLER_PRINTER";
SHORT ValidateSelector(SHORT);
extern BOOL DeviceModes( PSZ, PDESPPD, PCNFDATA );
extern void   szNewCopy(PSZ,PSZ,SHORT);
extern BOOL   sznIsEqual(PSZ,PSZ);
extern BOOL   GetPrinterName(PSZ pszDevice,PSZ pszPName);
// @V3.1140397
extern VOID FreePPBResource( PDESPPD );
extern VOID ConvertNewJpToOld( PDRIVDATA, PDESPPD );
extern LONG QueryDrivdataSize( PDESPPD );

// @V4.0169885
BOOL InsertQueueString( PSZ, PSZ, PSZ );

/***************************************************************************
 *
 * FUNCTION NAME = OS2_PM_DRV_DEVMODE
 *
 * DESCRIPTION   = The DevPostDeviceModes function causes a device driver to
 *                 post a dialog box so the user can set options for the device
 *                 (resolution, font cartridges, and so on).
 *
 *                 The application can call this function first with a NULL data
 *                 pointer to find how much storage is needed for the data
 *                 buffer.  It then calls the function a second time to have the
 *                 buffer filled with data.  You can then pass the returned data
 *                 to the DevOpenDC function as the buffer data pointed to by
 *                 the pbDriverData parameter.
 *
 *                 Parameter      Description
 *                 --------------------------------------------
 *                 hab
 *                 Identifies the anchor block.
 *
 *                 pbDriverData
 *                 Points to the data buffer that receives device data defined
 *                 by the driver. If this parameter is NULL, the function
 *                 returns the required buffer size. The format of the data is
 *                 the same as for the pbData parameter of the DevOpenDC
 *                 function.
 *
 *                 pszDriverName
 *                 Points to the null-terminated string that contains the name
 *                 of the device driver.
 *
 *                 achDeviceName
 *                 Points to the null-terminated string that identifies the
 *                 particular device (for example, its model number). This
 *                 string must not exceed 32 bytes. Valid names are defined by
 *                 device drivers.
 *
 *                 pszName
 *                 Points to the null-terminated string that contains the
 *                 printer name.
 *
 *                 flOptions
 *                 Specifies whether the function should display a dialog box
 *                 that allows the user to change job properties, display two
 *                 dialog boxes that allow the user to change job and printer
 *                 properties, or simply return the current job properties. This
 *                 parameter can be one of the following values:
 *
 *                 Value               Meaning
 *                 -------------------------------------------------------------
 *                 DPDMF_POSTJOBPROP   Display a dialog box that allows the user
 *                                     to change job properties. The default
 *                                     values for this dialog box are taken from
 *                                     the PM_SPOOLER_DD section of the os2.ini
 *                                     file if the pszName parameter specifies a
 *                                     logical address. If pszName is NULL, the
 *                                     default values are taken from the
 *                                     pbDriverData parameter.
 *
 *                 DPDMF_CHANGEPROP    Display two dialog boxes. The first
 *                                     dialog box allows the user to change job
 *                                     properties; the second allows the user to
 *                                     change printer properties. The default
 *                                     values for these dialog boxes are taken
 *                                     from the PM_SPOOLER_DD section of the
 *                                     os2.ini file. The function returns the
 *                                     new values in the pbDriverData parameter.
 *                                     The pszName parameter cannot be NULL when
 *                                     this option is selected.
 *
 *                 DPDMF_QUERYJOBPROP  Return the current job properties.
 *
 * INPUT         = (pDriverData,pszDriver,pszDevice,pszName,options)
 *
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 *                 The return value, if the pbDriverData parameter is NULL, is
 *                 the size (in bytes) required for the data buffer, DPDM_NONE
 *                 if there are no settable options, or DPDM_ERROR if an error
 *                 occurs.
 *
 *                 The return value, if pbDriverData is not NULL, is DEV_OK if
 *                 the function is successful, DPDM_NONE if there is no device
 *                 mode, or DPDM_ERROR if an error occurs.
 *
 * RETURN-ERROR  = NONE
 *
 *                 Use the WinGetLastError function to retrieve the error value,
 *                 which may be one of the following:
 *
 *                 PMERR_INV_DEVICE_NAME
 *                 PMERR_INV_DRIVER_DATA
 *                 PMERR_INV_DRIVER_NAME
 *                 PMERR_INV_LOGICAL_ADDRESS
 *
 *
 **************************************************************************/
ULONG OS2_PM_DRV_DEVMODE( PLDRIVDATA pDriverData, PSZ pszDriver, PSZ pszDevice,
                          PSZ pszName, ULONG ulOptions )

  /* PLDRIVDATA pDriverData;               pointer to drivdata block         */
  /* PSZ pszDriver;                        pointer to driver name            */
  /* PSZ pszDevice;                        pointer to device name under      */
  /*                                       which printer is registered       */
  /* PSZ pszName;                          error log address                 */
  /* ULONG options;                        save options                      */

  /* HAB hab;                      anchor-block handle                         */
  /* PDRIVDATA pbDriverData;       pointer to buffer for data                  */
  /* PSZ pszDriverName;            pointer to string for driver name           */
  /* PSZ achDeviceName;            pointer to device name                      */
  /* PSZ pszName;                  pointer to string for output device name    */
  /* ULONG ulOptions;              specifies various options                   */

{
  ULONG    ulDrivDataSize;              // Size (in bytes) of LDRIVDATA + UI's
  PDESPPD  pdesPPD;                     // PPD description buffer
  CHAR     achPName[ MAX_FNAMESIZE ];   // Device name
  ULONG    ulRC;                        // Return code
  PCNFDATA pCNFData = NULL;             // Local configuration pointer
//PPIB     pPib;                                                        //@V3.0118732
//PTIB     pTib;                                                        //@V3.0118732
//PSZ      pszProcName;                                                 //@V3.0118732
//PSZ      pszShellName;                                                //@DJP
//PSZ      pszOrigShell = "\\PMSHELL.EXE";                              //@DJP
  PDRIVDATA pLocalDD = NULL;                                     // @V3.1142031

  /*
  ** Load the PPB data.
  */
  if ((pdesPPD = LoadPPBResource( NULL, pszDevice )) != NULL)
  {
    ulDrivDataSize = (ULONG) QueryDrivdataSize( pdesPPD );
  }
  else
  {
    GplErrSetError(  PMERR_INV_DRIVER_NAME );
    return DPDM_ERROR;
  }

  /*
  ** If pDriverData == NULL, then the user has asked this driver to return
  ** the buffer size needed to run.
  */
  if (pdesPPD != NULL && pDriverData != (PLDRIVDATA) NULL)
  {
    /*
    ** @V3.0130814
    ** Verify if data is at least the size of LDRIVDATA.  The UI variable
    ** length data can be ignored if it is not in LDRIVDATA (the defaults will
    ** be used).
    */
//    if (pDriverData->cb >= ulDrivDataSize)
    /*
    ** Some apps may be sending in a valid LDRIVDATA, but not setting the
    ** size (cb).  Remove this verification.  CopyCNFData() looks at cb so
    ** if it is 0, no data is copied and defaults are used.
    */
#if 0
//    if (pDriverData->cb >= sizeof( LDRIVDATA ))
//    {
#endif
    /*
    ** Allocate memory for the CNF Data structre.
    */
    // @V3.1142031
//    if ((pCNFData = AllocCNFStructure( pdesPPD, TRUE )) != NULL)
    if ((pLocalDD = InitializeLocalDRIVDATA( (PDRIVDATA) pDriverData, pdesPPD,
                                             pszName, pszDevice, NULL,
                                             &pCNFData )) != NULL)
    {
// @V3.1142031
#if 0
//    /*
//    ** Copy the configuration data to the local pointer.
//    */
//    VerifyLDDCNFStructure( pdesPPD, pDriverData, ulDrivDataSize );
//    CopyCNFData( pCNFData, &pDriverData->cnfData, ulDrivDataSize,
//                 (UINT) pDriverData->cb );
//    pCNFData->hmod = pscript_module;
#endif

      /*
      ** Validate the selector.  Make sure it exists and is large enough
      ** to handle our drivedata structure.
      ** If the DPDMF_CHANGEPROP option is selected, it is an error if
      ** pszName == NULL.
      */
      if ((ulOptions == DPDM_CHANGEPROP) && (pszName == NULL))
      {
        RIP( "OS2_PM_DRV_DEVMODE: pszName == NULL when DPDMF_CHANGEPROP" );
        GplErrSetError(  PMERR_INV_DRIVER_NAME );

        ulRC = (ULONG) DPDM_ERROR;
      }
      else
      {
        /*@V3.0118732
        ** If we get a Post Printer Properties then it better be the shell/
        ** Print Object calling us.  If not just change to Post Job Properties
        */
        if (ulOptions == DPDM_CHANGEPROP)                                  //@V3.0118732
        {                                                                  //@V3.0118732
// @V4.0175358 Use genplib to see if we may show printer apps
#if 0
//////////DosGetInfoBlocks( &pTib, &pPib );                                //@V3.0118732
//////////pszProcName = strrchr( pPib->pib_pchcmd, '\\' );  //Get just name//@V3.0118732
////////////Get the shell name from env.                                   //@DJP
//////////if ( ! DosScanEnv( "RUNWORKPLACE", &pszShellName ) )             //@DJP
//////////{                                                                //@DJP
//////////  pszShellName = strrchr( pszShellName, '\\' );                  //@DJP
//////////}                                                                //@DJP
//////////if ( pszProcName )  /* Found name */                             //@V3.0118732
//////////{                                                                //@V3.0118732
//////////////if ( strcmp ( pszProcName, "\\PMSHELL.EXE" ) )                 //@V3.0118732
//////////  if ( strcmp ( pszProcName, pszShellName ) != 0 &&
//////////       strcmp ( pszProcName, pszOrigShell ) != 0  )
//////////  { /* Not equal case */                                         //@V3.0118732
//////////    ulOptions = DPDM_POSTJOBPROP; /* Force job props */          //@V3.0118732
//////////  }                                                              //@V3.0118732
//////////}                                                                //@V3.0118732
#endif
          if ( GplMayShowPrinterProp( ) == FALSE )
          {                                                                //@V3.0118732
            ulOptions = DPDM_POSTJOBPROP;   /* Force job props */          //@V3.0118732
          } /* endif */                                                    //@V3.0118732
        }                                                                  //@V3.0118732

        /*
        **  put the printer type in the two fields below
        */
        // @V3.1142031
#if 0
//      szNewCopy( (PSZ) pCNFData->szPrtName, pszDevice,
//                 sizeof( pCNFData->szPrtName ) );
//      szNewCopy( (PSZ) pCNFData->szSegName, pszDevice,
//                 sizeof( pCNFData->szSegName ) );
#endif

        /*
        ** build keyapp form of
        ** PM_DD_<printerName>,<deviceDriver>.<deviceName>
        */
        /*
        ** If the name is null try to find a printer of same type
        ** If no printer name given use devicename preceded by a blank and .
        */
        if (!pszName || !*pszName)
        {
          /*
          ** Try to find printer
          */
          if (GetPrinterName( pszDevice, (PSZ) achPName ) == TRUE)
          {
            /*
            ** Set name to point to rite name
            */
            pszName = (PSZ) achPName;
          }
          else
          {
            pszName = NULL;
          }
        }

        /*
        ** Printer names limited to total of 32 chars
        */
        if (pszName != NULL)
        {
          // @V4.0169885
          InsertQueueString( pCNFData->szKeyApp, pszName, pszDevice );

#if 0
//        strcpy( pCNFData->szKeyApp, "PM_DD_" );
//        strcat( (PSZ) pCNFData->szKeyApp, (PSZ) pszName );
//        strcat( pCNFData->szKeyApp, ",PSCRIPT." );   // Add in driver name
//
//        /*
//        ** Tack on device name (< 32)
//        */
//        strcat( pCNFData->szKeyApp, pszDevice );
#endif
        }

        /*
        ** this seems hokey, but this is what we have to do to work correctly
        ** with the print manager.  they call us with the drive data zeroed out;
        ** including the version number.  in this case, they expect us to fill
        ** in the drive data with some "default" set of information.
        */
        // @V3.1142031
#if 0
//      LoadCurrentUISelections( pdesPPD, pCNFData );
//      if (ValidateDriveData( (PLDRIVDATA) pDriverData, pdesPPD, pCNFData )
//                              == FALSE)
//      {
//        pCNFData->lVersion = -1;
//        pCNFData->iDestnType = SYSTEM;
//        pCNFData->jobProperties.uScale = (SHORT) DEFAULT_SCALE;
//        pCNFData->jobProperties.iOrient = (SHORT) DEFAULT_ORIENT;
//        pCNFData->jobProperties.iManualfeed = (SHORT) DEFAULT_MANUAL;
//        pCNFData->jobProperties.fIsColorDevice = (BOOL) DEFAULT_COLOR;
//        pCNFData->effOutput.iJobTimeout = (SHORT) DEFAULT_TIMEOUTS;
//        pCNFData->effOutput.iWaitTimeout = (SHORT) DEFAULT_TIMEOUTS;
//        pCNFData->effOutput.fIsFliptb = (BOOL) DEFAULT_TOPBOTTOM;
//        pCNFData->effOutput.fIsFliplr = (BOOL) DEFAULT_LEFTRIGHT;
//        pCNFData->effOutput.fIsDrawInverted = (BOOL) DEFAULT_INVERT;
//        pCNFData->iCntCopies = (SHORT) DEFAULT_COPIES;
//        pCNFData->szDestnFile[0] = '\0';
//        /// pcnfData->sUsePDFonts = 1;      /* @V3.0115481*/
//        pCNFData->sUsePDFonts = UsePrinterDeviceFonts();   //@V3.0124227
//
//        /*
//        ** @V3.0GAMMA1
//        */
//        pCNFData->lGammaValue = NO_GAMMA;
// @V3.RGBGAMMA
//        pCNFData->sGammaValues.lRed = NO_GAMMA;
//        pCNFData->sGammaValues.lGreen = NO_GAMMA;
//        pCNFData->sGammaValues.lBlue = NO_GAMMA;
//      }
#endif

        /*
        ** fill in some fields in the printer configuration data structure.
        */
        pCNFData->uSaveOptions = (SHORT) ulOptions;

        /*
        ** DeviceModes displays the dialog boxes.
        */
        if ((ulRC = (ULONG) DeviceModes( pszDevice, pdesPPD, pCNFData ))
            == TRUE)
        {
          pDriverData->lVersion = pCNFData->lVersion = DRIVERSION;
          pDriverData->cb = ulDrivDataSize;

          if (pszDevice != NULL)
          {
            szNewCopy( (PSZ) pDriverData->szDeviceName, (PSZ) pszDevice,
                       sizeof( pDriverData->szDeviceName ) );
          }
          else
          {
            szNewCopy( (PSZ) pDriverData->szDeviceName,
                       (PSZ) StringTable[IDS_Generic - STRING_BASE],
                       sizeof( pDriverData->szDeviceName ) );
          }

          /* Convert any new JPs to Old */
          ConvertNewJpToOld( pLocalDD, pdesPPD );

          /*
          ** Copy the configuration data back to the original.
          */
          // @V3.1142031
          CopyDRIVDATA( (PDRIVDATA) pDriverData, pLocalDD );
        }
      }
    }
    else  // Memory allocation error. Free remaining buffers and set error.
    {
      ulRC = DPDM_ERROR;
    }

    /*
    ** Free all memory.
    */
//    if (pCNFData)                                              // @V3.1142031
    if (pLocalDD)
    {
#if 0
//    pCNFData->u.iv.pSourcePaper = NULL;
//    FreeCNFStructure( pCNFData );
#endif
      FreeLocalDRIVDATA( pLocalDD );
      pLocalDD = NULL;
      pCNFData = NULL;
    }
  }
  else       // pDriverData == NULL
  {
    ulRC = ulDrivDataSize;
  }

  /*
  ** Free the DESPPD structure.
  */
  if (pdesPPD != NULL)
  {
    FreePPBResource( pdesPPD );
    pdesPPD = NULL;
  }
  else
  {
    ulRC = DPDM_ERROR;
  }

#if ipmd
  assert( pdesPPD == NULL );
  assert( pCNFData == NULL );
#endif

  return( ulRC );
}

/***************************************************************************
 *
 * FUNCTION NAME = CheckPrinterName
 *
 * DESCRIPTION   = Given logical name of printer will see if it has any pscript printers
 *                 of the requested type.
 *
 * INPUT         = pszPSName, pszPrinter, fDefault
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = TRUE if match
 *
 * RETURN-ERROR  = False if not
 *
 **************************************************************************/

BOOL CheckPrinterName( PSZ pszPSName, PSZ pszPrinter, BOOL fDefault )
{
  /* CHAR           achBuf[256]; */
  PSZ            achBuf;               
  register SHORT i;
  PSZ            p;

  /*
  ** Get the data for printer - in form of "port;device[,device];queue"
  */
  /*
  ** PrfQueryProfileString( HINI_SYSTEMPROFILE, pm_spooler_printer, pszPrinter,
  **    ";;;", (PSZ) achBuf, (ULONG) sizeof(achBuf) );
  */
  
  ProfileAllocStringQuery( HINI_SYSTEMPROFILE, pm_spooler_printer, pszPrinter,
                           ";;;", (PPVOID) &achBuf );

  if (achBuf != NULL)
  {
    /*
    ** If not attached to port return
    */
    
    /*
    ** Network printers dont have a port so don't check if default
    */
    if ((fDefault == FALSE) && (achBuf[0] == ';'))
    {
      
      GplMemoryFree( achBuf );
      return( FALSE );
    }
    p = achBuf;

    while (*p != ';')                    /* Skip over port */
    {
      p++;
    }
    p++;                                 /* And the colon */

    /*
    ** Loop for each name in device list
    */
    while (*p != ';')
    {
      /*
      ** Compare device to parm
      */
      i = 0;

      while (*(pszPSName+i) == *p)
      {
        i++;
        p++;
      }

      /*
      ** Good ending conditions
      */
      if (*(pszPSName+i) == '\0' && (*p == ',' || *p == ';'))
      {
        
        GplMemoryFree( achBuf );
        return( TRUE );
      }

      /*
      ** No match - see any more device names
      */
      while (*p != ',' && *p != ';')
      {
        p++;
      }

      if (*p == ',')                     /* Comma means more to come */
      {
        p++;
      }
    }

    
    GplMemoryFree( achBuf );
  }

  return( FALSE );
}

/***************************************************************************
 *
 * FUNCTION NAME = GetPrinterName
 *
 * DESCRIPTION   = First checks the default printer, then all others for the
 *                 first match of requested name.
 *
 *                 pszDevice = the device type to look for eg. QMS-PS 810
 *                 pszPname  = pointer to buffer for printer name eg PRINTER1
 *
 * INPUT         = pszDevice, pszPName
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = TRUE if found and copies name into supplied buffer.
 *
 * RETURN-ERROR  = FALSE if no match
 *
 **************************************************************************/

BOOL GetPrinterName( PSZ pszDevice, PSZ pszPName )
{
  /* CHAR           achPrt[256]; */
  PSZ            achPrt;              
  CHAR           achTypeDotName[66];
//PSZ            p;
  register SHORT i;
  BOOL           RC = FALSE;

  /*
  ** Build name as PSCRIPT.Printer_name
  */
  // @V4.0169885
#if 0
//strcpy( achTypeDotName, "PSCRIPT." );
//strcpy( &achTypeDotName[8], pszDevice );
#endif
  strcpy( achTypeDotName, PSCRIPT_DRV_NAME );
  strcat( achTypeDotName, "." );
  strcat( achTypeDotName, pszDevice );

  /*
  ** see if default printer set up
  */
  /*
  ** if ((i = (SHORT) PrfQueryProfileString( HINI_PROFILE, "PM_SPOOLER", "PRINTER",
  **    "", (PSZ) achPrt, (ULONG) sizeof(achPrt))) > 1)
  */
  
  i = (SHORT) ProfileAllocStringQuery( HINI_PROFILE, "PM_SPOOLER",
                                       "PRINTER", NULL, (PPVOID) &achPrt);

  if (achPrt != NULL && i > 1)
  {
    /*
    ** Strip off trailing semicolon
    */
    achPrt[i-2] = '\0';
    RC = CheckPrinterName( (PSZ) achTypeDotName, (PSZ) achPrt, TRUE );
    i = 0;                             /* Set for copy to name later */
  }

  if (RC == FALSE)
  {
    /*
    ** Get enum list of printers
    */
    /*
    ** PrfQueryProfileString( HINI_SYSTEMPROFILE, pm_spooler_printer, (PSZ) NULL,
    **    "", (PSZ) achPrt, (ULONG) sizeof(achPrt) );
    */
    
    ProfileAllocStringQuery( HINI_SYSTEMPROFILE, pm_spooler_printer, (PSZ) 0,
                             NULL, (PPVOID) &achPrt );
    i = 0;

    if (achPrt != NULL)
    {
      while (i < sizeof(achPrt) && achPrt[i] != '\0')
      {
        if ((RC = CheckPrinterName( (PSZ) achTypeDotName, (PSZ) &achPrt[i],
                                    FALSE)) == TRUE)
        {
          break;                         /* match found, break loop */
        }

        /*
        ** Skip to next name
        */
        while (achPrt[i++] != '\0');
      }
    }
  }

  if (RC == TRUE)
  {                                    /* Copy name */
    
    strcpy( pszPName, (char *) (achPrt + i) );
    GplMemoryFree( achPrt );

    return( TRUE );
  }
  else
  {
    
    if (achPrt != NULL)
    {
      GplMemoryFree( achPrt );
    }

    return( FALSE );
  }
}





// @V4.0169885
/***************************************************************************
 *
 * FUNCTION NAME = InsertQueueString
 *
 * DESCRIPTION
 * With a given buffer (pOutString), inserts the "driver-queue-device"
 * string in the following format:
 *
 *      "PM_DD_<queue name>,<driver name>,<device name>"
 *
 * Queue name and device name are provided.  Driver name is the pre-defined
 * string PSCRIPT_DRV_NAME.
 *
 * INPUT
 * pQueueName - Queue name to add to the string.
 * pDeviceName - Device name to add to the string.
 *
 * OUTPUT
 * pOutString - Buffer where the final string is created.
 *
 * RETURN-NORMAL = TRUE string is created.
 *
 * RETURN-ERROR  = FALSE if string is not created.
 *
 **************************************************************************/
BOOL InsertQueueString( PSZ pOutString,
                        PSZ pQueueName,
                        PSZ pDeviceName
                      )
{
  BOOL fRC = FALSE;

  if (pOutString != NULL && pQueueName != NULL && pDeviceName != NULL)
  {
    strcpy( pOutString, "PM_DD_" );
    strcat( pOutString, pQueueName );
    strcat( pOutString, "," );
    strcat( pOutString, PSCRIPT_DRV_NAME );
    strcat( pOutString, "." );
    strcat( pOutString, pDeviceName );

    fRC = TRUE;
  }

  return( fRC );
}
