/*
** This REXX utility compares the strings PS_DRV_NAME and PS_DEF_NAME defined
** in the makefile to ensure that they are match, and that one is lowercase and
** the other is uppercase.
*/

parse arg driverName defineName

if driverName == defineName then
do
  SAY ''
  SAY ''
  SAY 'COMPARE.CMD:'
  SAY 'WARNING - Driver name should be in lowercase and define name should'
  SAY '          be in uppercase.'
  SAY ''
  SAY ''
end

parse upper arg driverName defineName

if driverName <> defineName then
do
  SAY ''
  SAY ''
  SAY 'COMPARE.CMD:'
  SAY 'WARNING - Driver name and definition name do not match.'
  SAY ''
  SAY ''
end

