/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = FNTREMAP.C
 *
 * DESCRIPTIVE NAME = Resource Generator Module
 *
 *
 * VERSION = V2.0
 *
 * DATE      10/17/88
 *
 * DESCRIPTION Generates a file called "fntremap.txt" which will
 *             contain text needed by the PostScript printer driver.
 *             This text will get incorporated into PSCRIPT.DRV as a
 *             resource.
 *
 * FUNCTIONS
 *
 *
 * NOTES       Format of fntremap.txt
 *             ----------------------
 *
 *             1. Header:  Offsets
 *             2. Text:    Postscript code to download verbatim, and
 *                         Post-script names of all glyphs recognized
 *                         by Winthorn multi-codepage support.
 *
 *             1. Header
 *             ---------
 *             SHORT Offset to start of Postscript code to download verbatim
 *             SHORT Number of glyph names present
 *             SHORT Offset to name of glyph with ID value zero
 *             SHORT Offset to name of glyph with ID value one
 *               ...
 *             SHORT Offset to name of glyph with ID value [number of
 *                   glyph names present minus one]
 *
 *             Note:  All offsets are from the very start of the file.
 *
 *             2. Text
 *             -------
 *             SZ Name of glyph with ID value zero
 *             SZ Name of glyph with ID value one
 *               ...
 *             SZ Name of glyph with ID value [number of glyph names
 *                present minus one]
 *             SZ Postscript code to download verbatim
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define  AFM2BIN          1

typedef struct
{
  char *pszName;
  int iCP850Code, ipscriptCode;
} CharData;
                                       /* cd                                 */
#include "..\inc\mapping.h"
typedef char *PSZ;
typedef unsigned char BYTE;

PSZ apszRemapCode[] =
{
  "/redefine { findfont begin currentdict dup length dict begin {",
  "1 index /FID ne {def} {pop pop} ifelse } forall /FontName exch def",
  "dup length 0 ne { /Encoding Encoding 256 array copy def 0 exch {",
  "dup type /nametype eq { Encoding 2 index 2 index put pop 1 add",
  "}{ exch pop } ifelse } forall } if pop currentdict dup end end",
  "/FontName get exch definefont pop } bind def", NULL
} ;

BYTE Buffer[8192];

/***************************************************************************
 *
 * FUNCTION NAME = main
 *
 * DESCRIPTION   = Mainline function
 *
 * INPUT         = argc - number of commandline arguments
 *                 argv - pointer to array of commandline arguments
 *
 * OUTPUT        = NONE.
 *
 * RETURN-NORMAL = NONE.
 * RETURN-ERROR  = NONE.
 *
 *************************************************************************   */

main(int argc,char **argv)
{
  PSZ   p;
  short sNumGlyphs;
  short i,j,k;
  FILE *fhOut;
  int   verbose = 0;
  char  cOutDir[255];
  PSZ   pszOutName = "fntremap.txt";

  cOutDir[0] = 0;
  /*
  ** Look at command line arguments
  */
  for ( i= 1; i < argc; i++ )
  {
    /* look for out dir */
    if ( ! strncmp( argv[i], "-d", 2 ) )
    {
      strcpy( cOutDir, (argv[i])+2 );
      /* Remove last \ sice we will add one */
      j = strlen( cOutDir ) - 1;
      if ( cOutDir[ j ] == '\\' )
      {
        cOutDir[ j ] = 0;
      }
      strcat( cOutDir, "\\" );
      strcat( cOutDir, pszOutName );
    }
    else
      if ( ! strncmp( argv[i], "-v", 2 ) )
      {
        verbose = 1;
      }
      else
      {
        printf("Usage: %s [-dOut_dir] [-v]\n", argv[0]);
        exit(1);
      } /* endif */
  } /* endfor */

  /* if no path use default */
  if ( cOutDir[0] == 0)
  {
    strcpy( cOutDir, pszOutName );
  }


  if (verbose)
  {
    printf("\nFont Remap Code Resource Generator for\n");
    printf("PostScript Printer Driver\n\n");
  }

  /*
  ** Determine how many glyph names there are
                                                                             */

  sNumGlyphs = 0;

  do
  {
    j = 0;

    while ((charmapAdobeStandard[j].pszName) && (charmapAdobeStandard[j].
       iCP850Code != sNumGlyphs))
      j++;

    if (charmapAdobeStandard[j].pszName)
      sNumGlyphs++;
  }

  while (charmapAdobeStandard[j].pszName);

  if (verbose)
    printf("There are a total of %d glyph names\n\n", sNumGlyphs);

  /*
  ** Put number of glyph names in header
                                                                             */

  Buffer[2] = (BYTE)(sNumGlyphs&0x0ff);
  Buffer[3] = (BYTE)((sNumGlyphs >> 8)&0x0ff);
  i = (sNumGlyphs *2)+4;

  for (j = 0; j < sNumGlyphs; j++)
  {

    /*
    ** Put offset to glyph name in header
                                                                             */

    Buffer[(j *2)+4] = (BYTE)(i&0x0ff);
    Buffer[(j *2)+5] = (BYTE)((i >> 8)&0x0ff);

    /*
    ** Put glyph name in text section
                                                                             */

    k = 0;

    while (charmapAdobeStandard[k].iCP850Code != j)
      k++;
    p = charmapAdobeStandard[k].pszName;

    if (verbose)
      printf("Glyph number %d has name \042%s\042\n", j, p);

    while (*p)
      Buffer[i++] = (BYTE)*p++;
    Buffer[i++] = (BYTE)0;

    /*
    ** Make sure this glyph isn't listed twice
                                                                             */

    k++;

    while (charmapAdobeStandard[k].pszName)
    {

      if (j && (charmapAdobeStandard[k].iCP850Code == j))
        printf("Warning: Glyph has multiple names\n");
      k++;
    }
  }

  /*
  ** Put offset to remap code in header section
                                                                             */

  Buffer[0] = (BYTE)(i&0x0ff);
  Buffer[1] = (BYTE)((i >> 8)&0x0ff);

  /*
  ** Put remap code in text section
                                                                             */

  for (j = 0; (p = apszRemapCode[j]) != 0; j++)
  {

    while (*p)
      Buffer[i++] = (BYTE)*p++;
    Buffer[i++] = (BYTE)'\000';
  }
  Buffer[i++] = (BYTE)0;

  /*
  ** Write the buffer to fntremap.txt
                                                                             */

  fhOut = fopen( cOutDir, "wb" );

  if (fhOut == NULL)
  {
    printf("Cannot create output file\n");
    exit(1);
  }
  fwrite( Buffer, i, 1, fhOut );
  fclose( fhOut );

  if (verbose)
    printf("The resource is %d bytes long\n", i);

  return 0;
}
