/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = XFORMS.H
 *
 * DESCRIPTIVE NAME = External Function Declarations
 *
 *
 * VERSION = V2.0
 *
 * DATE        12/12/88
 *
 * DESCRIPTION
 *             Function Prototypes for NotifyTransformChange, get_angle_xform,
 *             and ConvertWithMatrix.   Macros for conversion of coordinates.
 *
 * FUNCTIONS
 *
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/*
**  Some macros to make coordinate conversions easy!
*/
#define  convert_device_to_world(hdc, pointl, count, ddc) (BOOL)((*daConvert) \
((HDC)(hdc), (LONG)CVTC_DEVICE, (LONG)CVTC_WORLD,  (PPOINTL)(pointl), \
(LONG)( count), (PDDC)(ddc), NGreConvert))
#define  convert_world_to_device(hdc, pointl, count, ddc) (BOOL)((*daConvert) \
((HDC)(hdc), (LONG)CVTC_WORLD, (LONG)CVTC_DEVICE,  (PPOINTL)(pointl), \
(LONG)( count), (PDDC)(ddc), NGreConvert))
#define  convert_device_to_model(hdc, pointl, count, ddc) (BOOL)((*daConvert) \
((HDC)(hdc), (LONG)CVTC_DEVICE, (LONG)CVTC_MODEL,  (PPOINTL)(pointl), \
(LONG)(count), (PDDC)(ddc), NGreConvert))

/*
**  Function prototypes for what we do
*/
extern LONG  NotifyTransformChange ( HDC, ULONG,
                                     PNOTIFYTRANSFORMDATA, PDDC,
                                     ULONG );
extern BOOL  get_angle_xform ( PXFORM, PPOINTL );
extern BOOL  ConvertWithMatrix ( HDC, PPOINTL, LONG, PXFORM, ULONG,
                                 ULONG );
extern ULONG f_lsqrt(ULONG);
