/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = UTILS.H
 *
 * DESCRIPTIVE NAME = External Function Declarations
 *
 *
 * VERSION = V2.0
 *
 * DATE        12/12/88
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *             External Function declarations for
 *             IsIta_Port_Name, IsIta_Device_Name, clear_memory, copy_memory,
 *             compare_memory,
 *             get_mod_handle, int_to_str, lstrcmp, lstrncmp, lstrcpy,
 *             lstrlen, lstrtoksrch, prompt_for_carousel, prompt_for_page,
 *             save_mod_handle, str_to_int, flush_opt_buffer,
 *             queue_opt_buffer, fill_opt_init, fill_opt_end
 *
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/


#define  HEAPSIZE      65535           /* This value must match the .DEF    */
#define  MAX_SHORT     ((SHORT) (( -1L & 0x0000FFFF) >> 1))
#define  SWAPLONG(x,y) {                                                  \
                       LONG lTmp = x;                                     \
                       x = y;                                             \
                       y = lTmp;                                          \
                       }
extern HMODULE hModule;
extern BOOL           IsIta_COM_Port_Name ( PSZ );
extern BOOL           IsIta_Device_Name ( PSZ );
/*
** clear_memory, copy_memory and compare_memory are not used anywhere
*/
//extern VOID    PLOTOPT clear_memory ( PBYTE, SHORT );
//extern VOID    PLOTOPT copy_memory ( PBYTE, PBYTE, SHORT );

extern BOOL      PLOTOPT compare_memory ( PBYTE, PBYTE, SHORT );
extern HMODULE           get_mod_handle ( VOID );
 extern SHORT     PLOTOPT int_to_str ( LONG, PSZ, SHORT );

extern BOOL      PLOTOPT lstrcmp (  PSZ,  PSZ);
extern BOOL      PLOTOPT lstrncmp (  PSZ,  PSZ, ULONG );
extern VOID      PLOTOPT lstrcpy ( PSZ,  PSZ );
extern USHORT    PLOTOPT lstrlen (  PSZ );
extern VOID      PLOTOPT lstrtoksrch ( PSZ, CHAR );
extern BOOL              prompt_for_carousel ( PDDC, SHORT );
extern BOOL              prompt_for_page ( PDDC );
extern VOID              save_mod_handle ( HMODULE );
extern PSZ       PLOTOPT str_to_int ( PSZ, PSHORT );
extern VOID      PLOTOPT find_device_name   ( PVOID, PSZ, PSZ );
extern PDRIVDATA PLOTOPT return_driver_data ( PVOID, PDRIVDATA, PSZ, BOOL );
extern PSZ       PLOTOPT find_printer_name  ( PVOID, PSZ, PSZ, BOOL );
extern BOOL      PLOTOPT ConvertWithRotation(HDC, PDDC, BOOL, PLONG, PLONG);

#if      FILLOPTPATH
extern VOID  flush_opt_buffer ( PDDC );
extern VOID  queue_opt_buffer(PDDC,POINTL,POINTL); 
extern VOID  fill_opt_init(PDDC);                  
extern VOID  fill_opt_end(PDDC);                   
#else
  #define  fill_opt_init(a)
  #define  fill_opt_end(a)
#endif
/*
*/
#define  CENTERORIGIN(p) (p != CLASS_HP7440A && p != CLASS_HP7470A && \
                    p != CLASS_6182STANDARD && \
                    p != CLASS_HP7475A     && p != CLASS_HP7550A && \
                    p != CLASS_PAINTJET_XL && p != CLASS_DESIGNJET600 && \
                    p != CLASS_PAINTJET_XL300 && p != CLASS_DESIGNJET650 && \
                    p != CLASS_DRAFTMASTER_SERIES && p != CLASS_PCLHPGL2MONO && \
                    p != CLASS_DRAFTPROPLUS_SERIES && p != CLASS_DESIGNJET230 )
#define  IsIBM7374(p)  ( p == CLASS_HP7580A || p == CLASS_HP7580B )
#define  IsIBM7375X(p) ( p == CLASS_HP7585A || p == CLASS_HP7585B || \
                         p == CLASS_HP7586B )
#define  IsSizeAPaper(s) (( MEDSZ_A | MEDSZ_A4 ) & ( 1 << s ))
#define  IsSizeCPaper(s) (( MEDSZ_C | MEDSZ_A3 ) & ( 1 << s ))

//#define ADDROLLS /* should not be on in final product */
//                  /* leave commented out lines in      */
#ifdef ADDROLLS     /* added for customer private */
#define  IsRollPaper(s)  (( MEDSZ_R24 | MEDSZ_R36 |MEDSZ_A | MEDSZ_B | \
                            MEDSZ_C | MEDSZ_D | MEDSZ_E ) & ( 1 << s ))
#else
#define  IsRollPaper(s)  (( MEDSZ_R24 | MEDSZ_R36 ) & ( 1 << s ))
#endif

#define  ROUNDDIV( a,b ) (LONG) ( (a / b) + ( ((a % b) >= (b / 2)) && (b != 1))? (a>=0 && b>=0? 1: (a<0 && b<0? 1:-1) ): 0 )
