/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PLOTTERS.H
 *
 * DESCRIPTIVE NAME = External Data Declarations and Definitions
 *
 *
 * VERSION = V2.0
 *
 * DATE        12/12/88
 *
 * DESCRIPTION
 *             Definitions, MACROs, and TYPEDEFs
 *
 * FUNCTIONS
 *
 *
 * NOTES
 *
 *
 * STRUCTURES
 *             PENINFO
 *             CARSLINFO
 *             PROFILEINFO
 *             PDEVICE
 *             COLORTABLE
 *             OPTLN
 *             OPTBUF
 *             DDC
 *             OPTIONINFO
 *             DEFPROFILE
 *             DEVICEINFO
 *             PENOPTIONS
 *             PLOTTERCLASS
 *             PLOTTERDEF
 *
 * EXTERNAL REFERENCES
 *
 *             PlotterClass
 *             PlotterDef
 *             usPlotterCount
 *             P1P2Table
 *             PrintOffTable
 *             PaperResTable
 *             PhysicalPageSize
 *
 * EXTERNAL FUNCTIONS
 *
*/

#ifndef PLOTTERS_H
#define PLOTTERS_H

#define  LOCAL
#ifdef POWERPC
#define FSRSEM ULONG
#define PFSRSEM PULONG
#endif

#define  VERSION          0x200        /* Important for OS/2 2.0 which does
                                          version checking                  */
/* The PLOTTER driver used to use VERSION as its printer/job properties version
** level.  When going to 32-bit, VERSION was bumped up to 200 from 120.  This
** breaks the checking logic.  So now there are two different version numbers.
** One to report to the engine and one to use in the properties.  @MJH3
*/
#define  JOBPROP_VERSION  0x120        /* version checking                  */
#ifndef  USERINTERFACE
#define  INCL_DDIDEFS                  /* Get definitions                   */
#define  INCL_DDIGRE                   /* Get engine stuff                  */
#define  INCL_DDIMISC                  /* Get shortline stuff               */
#define  INCL_DDIPATHS                 /* Path stuff                        */
#define  INCL_DDICOMFLAGS              /* Function bit definitions          */
#endif

#ifdef POWERPC
#define  INCL_DOSSEMAPHORES            /* Dos Ram Sems for PowerPc          */
#endif
#define  INCL_32                       /* Get 32-bit header info            */
#define  INCL_DDIBUNDLES               /* Get bundle stuff                  */
#define  INCL_GREALL                   /* Get it all                        */
#define  INCL_GPIERRORS                /* Get error stuff                   */
#define  INCL_SHLERRORS                /* SHL error messages                */
#define  INCL_WINHEAP                  /* Heap stuff                        */
//#define  INCL_WINP                     /* Needed to make _DDIPATHS work!    */
#define  INCL_WINWINDOWMGR             /* General Window manager- WinFillRect*/
#define  INCL_GRE_POLYGON              /* include engine polygon functions */

/*
** Define the following macros.  These are needed for performance
** semaphores.
*/
#ifdef PAGE_TUNE
  #define INCL_BASE
  #define INCL_DOSSEMAPHORES
#endif

#if      DEBUG
  #define  INCL_DOSDEVICES             /* doscallback, etc.                 */
#endif
#include <os2.h>
#include <os2p.h>
#define  INCL_GREALL                   /* New Raster GRE stuff              */
#define  INCL_VMANDDI                  /* New Raster GRE stuff              */
#include <ddi.h>                       /* New Raster GRE stuff              */
#include <pmddi.h>

/*
** C lib includes
*/
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

/*
** GLOBAL GENPLIB INCLUDES- any private genplib includes can be done
** in the module before including plotters.h
*/
#define INCL_GENPLIB_ERROR           /* genplib error loging functions       */
#define INCL_GENPLIB_ASSERT          /* genplib Error Assert functions       */
#define INCL_GENPLIB_MEMORY          /* genplib memory functions             */
#define INCL_GENPLIB_THREAD          /* genplib Thread functions             */
#define INCL_GENPLIB_JOURNAL         /* genplib Journal functions            */
#define INCL_GENPLIB_EDC             /* genplib engine draw cars - backup fnt*/
#include <genplib.h>                 /* generic printer lib header           */


//  Defines not in the 32 bit PMDDIM.h file yet
#ifndef NGrePolygonSet
#define NGrePolygonSet 0x00004056
#define GrePolygonSet(a,b,c,d,e) (ULONG) Gre32Entry7((HDC)(a),(ULONG)(b),(ULONG)(c),(PPOLYGON)(d),(ULONG)(e),0L,NGrePolygonSet)
#endif
#ifndef NGreDevicePolygonSet
#define NGreDevicePolygonSet 0x00004059
#define GreDevicePolygonSet32(a,b) Gre32Entry4((HDC)(a),(PPOLYSET)(b),0L,NGreDevicePolySet)
#endif


#if      IEEESUPPORT
    break - should never get here
//  #include <pmieee.h>                /* IEEE stuff                        */
#endif
#include "innergre.h"                  /* needed for MemoryDc and Bitmap
                                          Support       Kran        */

// PAGE_TUNE
// Contains tuned segments.
#ifndef POWERPC
#include "ptune.h"
#endif

/*
** Use _Optlink in functions that we suspect it will make quicker
*/
#define PLOTOPT
/*
** Valid values for idCodePage field
** Other valid values correspond to the codepage number in question
** This define along with other code page values used to be
** pmwinp.h. But not any more. This is the only one that
** plotters is dependent on.
*/

#define  CP_850        850             /* Multilingual code page            */
#define  ABS(Value)    ((Value) > 0 ? (Value) : (-(Value)))
#define  WITHIN(value,lower,upper) ((value) >= (lower) && (value) <= (upper))
#define  MIN(a,b)      ((a) > (b) ? (b) : (a))
#define  MAX(a,b)      ((a) > (b) ? (a) : (b))

/*
**    Constants controlling the type of handshaking involved with this
**  plotter.  The mode is obtained from the os2.ini file.   The values
**  here are passed to the plotter via an <ESC>.P command,  so do not
**  change them without changing the initialisation code too!!!!
*/

#define  HNDSHK_NONE   0               /* None at all - not good            */
#define  HNDSHK_SOFT   1               /* Software - XON/XOFF (DC1/DC3)     */
/*
**  Hardware handshake - DTR on plotter
*/
#define  HNDSHK_HARD   3

/*
**  Used in the Linestyle to mirror the display driver when calling back
**  to the engine
*/
#define  DDC_FIRST_PEL 0x00010000L;
#define  MAX_PENS      8L              /* Maximum pens in 1 carousel        */

#if      MAX_PENS      > 8
  #error     "WARNING: fbCarPenUsed assumes <= 8 pens per carousel"
#endif

/*
** define GRE Versions
**/
#define RASTER_ENGINE_22   0x0220
#define RASTER_ENGINE_234  0x0234         // INTEL (even) DAX version

/*
** Caps colors for 24 bit RGB HPGL2 devices
*/
#define  CAPS_COLORS_24BIT      0x100000  /* 16,777,216 colors (24bit RGB)  */
#define  CAPS_COLORS_8BIT       0x100     /* 256 color  (8bit indexed RGB)  */
#define  CAPS_COLORS_4BIT       0x10      /* 16  colors ( 4 bit indexed RGB */
#define  CAPS_COLORS_1BIT          2      /* 2   colors ( 1 bit per pel     */
#define  CAPS_COLOR_BITCOUNT_24   24      /* 24 bit per pel                 */
#define  CAPS_COLOR_BITCOUNT_8     8      /* 8  bit per pel                 */
#define  CAPS_COLOR_BITCOUNT_4     4      /* 8  bit per pel                 */
#define  CAPS_COLOR_BITCOUNT_1     1      /* 8  bit per pel                 */


/*
** Define plotter MAX values
*/
#define  MAX_CAROUSELS      10L        /* Maximum carousels allowed         */
#define  MAX_COLORS         126L       /* Maximum plotter pen colors        */
#define  MAX_COLOR_INDEX    255L       /* Maximum range of log color index  */
#define  MAX_PEN_TYPES      16L        /* Maximum plotter pen types         */
#define  MAX_PEN_GROUPS      5L        /* Maximum plotter pen groups        */
#define  MAX_PEN_OPTIONS     5L        /* Maximum number of pen options     */
#define  MAX_DEFAULT_COLORS 16L        /* size of default color table       */
#define  MAX_DEFAULT_INDEX  15L        /* Highest predefined index for      */
                                       /* default color table               */

/*
**  Media sizes specify the media sizes allowed per plotter.  This information
**   is defined in several places.  Within the DEVICEINFO structure, the
**   following are used as indices (indexes for some) into the bitmap field
**   MediaSizeSupport.  They also correspond to the entries in the
**   P1P2Table, PaperResTable and PrintOffTable arrays (plotters.c)
*/

#define  MAX_MEDIA_SIZES 16            /* Maximum media sizes               */
#define  MEDSZ_A       0x0001          /* A: 8.5in x 11in                   */
#define  MEDSZ_B       0x0002          /* B: 11in x 17in                    */
#define  MEDSZ_C       0x0004          /* C: 17in x 22in                    */
#define  MEDSZ_D       0x0008          /* D: 22in x 34in                    */
#define  MEDSZ_E       0x0010          /* E: 34in x 44in                    */
#define  MEDSZ_A4      0x0020          /* A4: 210mm x 297mm                 */
#define  MEDSZ_A3      0x0040          /* A3: 297mm x 420mm                 */
#define  MEDSZ_A2      0x0080          /* A2: 420mm x 594mm                 */
#define  MEDSZ_A1      0x0100          /* A1: 594mm x 841mm                 */
#define  MEDSZ_A0      0x0200          /* A0: 841mm x 1189mm                */
#define  MEDSZ_R24     0x0400          /* 24in Roll                         */
#define  MEDSZ_R36     0x0800          /* 36in Roll                         */
#define  MEDSZ_AB      0x1000          /* Architectural AB: 12in x 18in      */
#define  MEDSZ_AC      0x2000          /* Architectural AC: 18in x 24in      */
#define  MEDSZ_AD      0x4000          /* Architectural AD: 24in x 36in      */
#define  MEDSZ_AE      0x8000          /* Architectural AE: 36in x 48in      */

#if      MAX_MEDIA_SIZES > 16
  #error     "MAX_MEDIA_SIZES is bitfield - limited to 16 bits"
#endif

/*
** Resolution defines - When adding resolutions
**                      increase MAX_RESOLUTIONS (do not exceed 32)
**                      and add entries to the aptl_Res_Table in
**                      plotters.c
*/
#define  MAX_RESOLUTIONS 9               /* Maximum resolutions             */
#define  RES_150X150     0x0001          /* 150  X 150                      */
#define  RES_180X180     0x0002          /* 180  X 180                      */
#define  RES_200X200     0x0004          /* 200  X 200                      */
#define  RES_204X204     0x0008          /* 204  X 204                      */
#define  RES_300X300     0x0010          /* 300  X 300                      */
#define  RES_600X600     0x0020          /* 600  X 600                      */
#define  RES_800X800     0x0020          /* 800  X 800                      */
#define  RES_1200X600    0x0040          /* 1200 X 600                      */
#define  RES_1200X1200   0x0080          /* 1200 X 1200                     */

#if      MAX_RESOLUTIONS > 32
  #error     "MAX_RESOLUTIONS is bitfield - limited to 32 bits"
#endif

#define  RES_150X150INDEX       00      /* 150  X 150                      */
#define  RES_180X180INDEX       01      /* 180  X 180                      */
#define  RES_200X200INDEX       02      /* 200  X 200                      */
#define  RES_204X204INDEX       03      /* 204  X 204                      */
#define  RES_300X300INDEX       04      /* 300  X 300                      */
#define  RES_600X600INDEX       05      /* 600  X 600                      */
#define  RES_800X800INDEX       06      /* 800  X 800                      */
#define  RES_1200X600INDEX      07      /* 1200 X 600                      */
#define  RES_1200X1200INDEX     08      /* 1200 X 1200                     */

#define  OR_PORTRAIT   0               /* Ditto, but portrait mode          */
#define  OR_LANDSCAPE  1               /* Orientation field for landscape   */
#define  UNITSPERMM    40L             /* Plotter Units per millimeter      */
//#define  RESOLUTION    5L            /* Effective resolution we will      */
                                       /* scale                             */
#define  MMPER10INCH         254L      /* 25.4 millimeters per inch         */
#define  INCHESPERMETERX100  3937L     /* inches in a meter = 39.37         */
#define  PLOTTERUNITSPERINCH 1016L     /* # of plotter units in an inch     */
//#define  STEPSPERMM    ((UNITSPERMM / RESOLUTION))
//#define  STEPSPERCM    ((STEPSPERMM * 10))

/*
** VERT_FONT_RES and HORZ_FONT_RES
**
**  note:  the vertical and horizontal resolution (of an HP/IBM
**         plotter) are equal.
**
**  8040 pels      1 meter       1 cm                  pels
** -----------  * --------- * ------------ =  204.216 ------
**    meter        100 cm     .3937 inches             inch
*/
#define  VERT_FONT_RES (804000/3937)
#define  HORZ_FONT_RES (804000/3837)

/*
**   Set default character sizes as 1.87mm wide by 2.69mm high. NOTE: The
**  factors of 3/2 and 2 are related to the way the plotter font is
**  defined.  For a given character box size,  the plotter characters
**  are set to 2/3 the width and half the height.  This produces correct
**  spacing.  So,  to get the default chaaracters to the desired size,
**  the sizes below are adjusted.  Also see CharStringPos in textout.c
*/

//#define  DEF_CHAR_WIDTH ((((STEPSPERCM * 187) + 500) * 3 / 2 / 1000))
//#define  DEF_CHAR_HEIGHT ((((STEPSPERCM * 269) + 500) * 3 / 2 / 1000))
//#define  DEF_MARK_WIDTH ((((STEPSPERCM * 80) + 500) * 3 / 2 / 1000))
//#define  DEF_MARK_HEIGHT ((((STEPSPERCM * 80) + 500) * 2 / 1000))


#define  CLASS_HP7440A              0
#define  CLASS_HP7470A              1
#define  CLASS_HP7475A              2
#define  CLASS_HP7550A              3
#define  CLASS_HP7580A              4
#define  CLASS_HP7585A              5
#define  CLASS_HP7580B              6
#define  CLASS_HP7585B              7
#define  CLASS_HP7586B              8
#define  CLASS_HP7570A              9
#define  CLASS_HP7595A              10
#define  CLASS_HP7596A              11
#define  CLASS_PAINTJET_XL          12
#define  CLASS_DESIGNJET600         13
#define  CLASS_PAINTJET_XL300       14
#define  CLASS_DRAFTMASTER_SERIES   15
#define  CLASS_DESIGNJET650         16
#define  CLASS_PCLHPGL2MONO         17
#define  CLASS_DRAFTPROPLUS_SERIES  18
#define  CLASS_DESIGNJET230         19
#define  CLASS_6182STANDARD         20
#define  MAX_PLOTTER_CLASSES        21

// May be there is some other way to determine if the device is 600 or 650c
// Currently we are using the same structure for both the devices. Now it's
// changed into two different structures.
// All I need to know is to find out in drawimage which device we are dealing
// with ? Check this out with MarkV.
#define  CLASS_COLORPRO CLASS_HP7440A
#define  CLASS_DRAFTPRO CLASS_HP7570A
#define  CLASS_DRAFTMASTER1 CLASS_HP7595A
#define  CLASS_DRAFTMASTER2 CLASS_HP7596A
#define  HPGL_NONE     0x0000
#define  HPGL_ARCS     0x0001
#define  HPGL_AUTOPEN  0x0002
#define  HPGL_AUTOVIEW 0x0004
#define  HPGL_CHARSET7 0x0008
#define  HPGL_CIRCLE   0x0010
#define  HPGL_EDGERECT 0x0020
#define  HPGL_FILLRECT 0x0040
#define  HPGL_PENTHICK 0x0080
#define  HPGL_POLYGON  0x0100
#define  HPGL_ALL      0x01ff
#define  HPGL2         0x1000
#define  HPGL2_BEZIER  0x2000

#define  HPRTL         0x4000        // Kran
#define  PCL5          0x8000
#define  PM_Q_STD      0
#define  PM_Q_RAW      1
#define  PAPER         0
#define  TRANSPARENCY  1
#define  ROLLERBALL    2
#define  DISPOSABLE    3
#define  REFILLABLE    4

/****************************************************************************
** Defines for compression modes in the driver that the device supports
****************************************************************************/
#define  DRV_COMPRESS_NONE      0x0      /* no driver compression   */
#define  DRV_COMPRESS_ADAPTIVE  0x1      /* Adaptive compression    */


/****************************************************************************/
/*  defines for usFlags.  This is a USHORT value!                           */
/****************************************************************************/
#define  FL_UNCOLLATEDMASK   0x0F       /* numeric: range 1 .. 16           */
#define  FL_USEAPPCOLORS     0x10       /* use application colors           */
#define  FL_SAVECOLORSORT    0x20       /* Save the color sorting option    */
#define  FL_USERDEFINEDFORMS 0x40       /* Switch interpretation of Size    */
#define  FL_RASTER           0x80       /* Send Raster image                */

/****************************************************************************/
/* Commands for end_page call                                               */
/****************************************************************************/
#define  FL_OUTPUT_PAGE      0x01
#define  FL_INIT_PAGE        0x02

/****************************************************************************/
/* Odd Commands for interfunction communication                             */
/* If any function wants to communicate with the rest, they should use this */
/* flag instead of using one more parameter on the stack and mugging the    */
/* code. Make sure to clear the flag once requirement is completed. Also    */
/* consider defining a flag here rather than creating one more bool member  */
/* in PDEVICE structure.                                                    */
/****************************************************************************/
#define  FL_CALLFROM_BAND    0x00000001
#define  FL_TRANSPARENCY_OFF  0x00000002

/****************************************************************************/
/* Structures                                                               */
/****************************************************************************/
#pragma pack(1)
typedef struct                         /* Pen Information                   */
{
  UCHAR Color;                         /* Pen color                         */
  UCHAR Type;                          /* Pen type                          */
  UCHAR Speed;                         /* Pen speed                         */
  UCHAR Force;                         /* Pen force                         */
  UCHAR Acceleration;                  /* Pen acceleration                  */
  UCHAR Usage;                         /* Pen usage                         */
} PENINFO;
#pragma pack()
typedef PENINFO  *PPENINFO;

typedef struct                         /* Carousel Information              */
{
  PENINFO Pen[MAX_PENS];
} CARSLINFO;

typedef CARSLINFO  *PCARSLINFO;

typedef struct                         /* Profile Information               */
{
  SHORT  CurrentCarousel;               /* Current carousel                  */
  SHORT  Orientation;                   /* Orientation                       */
  SHORT  PaperFeed;                     /* Paper feed                        */
  SHORT  Roll24;                        /* Roll length for 24"               */
  SHORT  RollLength;                    /* Roll length for 36 and others"    */
  SHORT  Size;                          /* Media size                        */
  SHORT  Version;                       /* Internal version                  */
  SHORT  bColorSort;                    /* Color sorting enabled?            */
  USHORT usFlags;                       /* Bit flags                         */
                                        /* see FL_XXX defines                */
  SHORT  bGECOption;                    /* GEC Option                        */
  SHORT  bPreloaded;                    /* Paper preloaded?                  */
  SHORT  bActiveCarousel[MAX_CAROUSELS];/* Active carousel information       */
  CARSLINFO Carousel[MAX_CAROUSELS];    /* Carousel information              */
  LONG   lResIndex;                     /* Resolution index into aptlRes_Table*/
  LONG   lDummy;                        /* @v3.133820 -- dummy field          */
} PROFILEINFO;
typedef PROFILEINFO  *PPROFILEINFO;

#define  PEN_NOFLAGS       0x00        /* do not set any flags              */
#define  PEN_DEFINED       0x01        /* This Pen has been defined         */
#define  PEN_PERMANENT     0x02        /* This Pen should not be redefined  */
typedef struct                         /* Pen Palette entry (HPGL2)         */
{                                      /* Index position in array is pen #  */
  ULONG  ulPenRGBColor;                /* Pen color                         */
  ULONG  fulPenFlags;                  /* Flags for the pen                 */
} PALETTEENTRY;
typedef PALETTEENTRY *PPALETTEENTRY;   /* pointer to a paletteentry struct  */

typedef struct                         /* Physical Device PDEVICE           */
{
  /*
  **  Pointers
  */
  PVOID pddc;                          /* temp pddc pointer until we fix    */
                                       /* QueryDeviceSurface                */
  PPROFILEINFO pSetup;                 /* Plotter Configuration             */
  HTHREAD      hThread;                /* Output Thread handle              */
  LONG         lDcType;                /* Device Context (Queued / Direct)  */
  EDCGENDATA   EDCGenData;             /* GenPLib General data for backup fnt */
  PSZ pszDriverDescription;            /* Driver description string-resource*/
  PSZ pszLogAddress;                   /* Pointer to address of device      */
  PSZ pszDriverName;                   /* Pointer to driver name            */
  PDRIVDATA pDriverData;               /* Pointer to driver data            */
  PSZ pszPrinterName;                  /* Pointer to spooler's printer name */
  PSZ pszDataType;                     /* Pointer to data type              */
  PSZ pszComment;                      /* Pointer to comment field          */
  PSZ pszQueueProcName;                /* Pointer to queue processor        */
  PSZ pszQueueProcParams;              /* Pointer to queue processor parms  */
  PSZ pszSpoolerParams;                /* Pointer to spooler parameters     */
  PSZ pszNetworkParams;                /* Pointer to network parameters     */
  PSZ pszDocumentName;                 /* Pointer to document name          */

  /*
  **  Handles
  */
  HMCB     hmcbHeap;                     /* Handle to heap                    */
  HAB      hAB;                          /* Handle to anchor block            */
  LHANDLE  hJournal;                     /* Handle to Journal File            */
  HJOURNAL hJournalGpl;                  /* Handle to GPL Journal File        */
  HFILE    hLogFile;                     /* Debugging log file handle         */
  LHANDLE  hSpooler;                     /* Handle to Spooler                 */
  HFILE    hDev;                         /* Handle to Device                  */
  SHANDLE  hIEEE;                        /* Handle to IEEE address            */

  /*
  ** GplJournal Journal information structure
  ** Journaling also uses the bJournal flag and the hJournal handle
  */
  IJOURNAL         IJournal;          // Input structure for journaling

  /*
  **  Flags and Buckets
  */
  POINTL PhysPosition;                 /* Physical position                 */
  POINTL ptlRefPoint;                  /* Current device pattern reference  */
                                       /* pt                                */
  USHORT Plotter;                      /* Plotter ID                        */
  USHORT StringID;                     /* Plotter String ID                 */
  USHORT usHPGLType;                   /* HPGL capabilities                 */
  USHORT DataType;                     /* 0=Std, 1=Escape, 2=Raw            */
  USHORT CurrentPage;                  /* Current page number               */
  SHORT  sCurrentFillPattern;          /* Current Device current fill patt  */
  USHORT usCurrentFillAngle;           /* Current Device filling angle      */
  SHORT  sCurrentPixelPlacement;       /* Current Pixel Placement           */
  SHORT  sCurrentMCROP;                /* Current Merge Control ROP         */
  SHORT  sPreviousMCROP;               /* Previous Merge Control ROP        */
  LONG   lCurrentRotate;               /* Current Rotate coordinate system  */
  LONG   lPreviousRotate;              /* Previous Rotate Coordinate System */
  USHORT BufferBytes;                  /* Bytes in output buffer            */
  USHORT HandShake;                    /* Type of handshake in operation    */
  BOOL bIEEEdevice;                    /* IEEE device?                      */
  BOOL bJobStarted;                    /* Dos/SplQm Open?                   */
  BOOL bDocStarted;                    /* StartDoc started?                 */
  BOOL bPageStarted;                   /* Page started?                     */
  BOOL bSomeRawData;                   /* RAWDATA on this page?             */
  BOOL bSpoolStdOpened;                /* SplStdOpen has been done          */
  BOOL bSpoolStdStarted;               /* SplStdStart has been done         */
  BOOL bLineInConstruction;            /* Line build flag                   */
  BOOL bStringInConstruction;          /* String build flag                 */
  BOOL bLabelConstruction;             /* Label LB instruction in use flag  */
  BOOL bPenIsUp;                       /* Current pen position TRUE = UP    */
  BOOL bPlotRelative;                  /* Current plotting format           */
  BOOL bEnableOutput;                  /* Turn off for abort                */
  BOOL bRealPlotter;                   /* True if output is to real plotter */
  BOOL bRelativeMove;                  /* True after PR, FALSE after PA     */
  BOOL bInRasterMode;                  /* True if we are in raster mode     */
  BOOL bAllocatedPatterns;             /* True if we allocated patterns     */
  BOOL bBanding;                       /* True if we are RASTER banding     */
  BOOL bRaster;                        /* True if we are in RASTER Mode     */
  BOOL bEnableComplete;                /* TRUE if CompleteEnable was called */
  ULONG ulCntrlFlag;                   /* Odd commands for interfunction    */
                                       /* communication. We should actually */
                                       /* merge all the above 20 flags into */
                                       /* this flag. Kran.                  */
  /*
  **  Color Information
  */
  BOOL  bColorSorting;                 /* Color-sorting enabled?            */
  SHORT NumColorsAvailable;
  SHORT ColorAvailable[MAX_COLORS];
  /*
  **  Carousel Information
  */
  SHORT CurrentCarousel;               /* Current carousel outputting       */
  BOOL  bMultiCarousel;                /* Multi-carousel enabled?           */
  BOOL  bCarouselPensUsedBuilt;        /* CarouselPensUsed built?           */
  BYTE  fbCarPenUsed[MAX_CAROUSELS];   /* Bit 1 => pen used                 */
  /*
  **  Pen Information
  */
  SHORT CurrentPen;                    /* Current pen we are outputting     */
  SHORT CurrentSpeed;                  /* Current pen speed                 */
  SHORT CurrentForce;                  /* Current pen force                 */
  SHORT CurrentAcceleration;           /* Current pen acceleration          */
  SHORT CurrentPenThickness;           /* Current pen thickness             */
  SHORT CurrentTRMode;                 /* Current Transparency mode         */
  BOOL  bPenIsSelected;                /* A Pen has been selected           */
  ULONG CurrentRealColor;              /* Current real color of selected    */
                                       /* Pen                               */
  ULONG CurrentRGBPenColor;            /* Current RBG pen color             */
  UCHAR  CurrentPenUsage;              /* Current Pen Usage                 */
  SHORT  iHPGL2PenNumber[MAX_CAROUSELS][MAX_PENS];/* Pen # in Palette       */
  USHORT usPensInPalette;              /* # of pen colors in HPGL2 pen pal  */
  PPALETTEENTRY paPaletteEntry;        /* ptr to the HPGL2 pen Palette      */
                                       /* The HPGL2 Pen pallete is used     */
                                       /* if the user has chosen the use    */
                                       /* the application colors not the    */
                                       /* pen colors                        */
  USHORT usLastPenDefined;             /* The number of the last pen defined*/
  /*
  **  Banding information
  */
  LONG  lNumBands;                     /* Number of bands for drawing       */
  LONG  lNumBandsCompleted;            /* Current band                      */
  LONG  lBandOffset;                   /* Band offset for roll feed         */
  LONG  lLastBandLength;               /* Length of roll feed band          */
  RECTL CurrentBand;                   /* Current band boundary             */
  /*
  **  Miscellaneous Information
  */
  USHORT fsTransform;                  /* Device transformation             */
  USHORT usLineType;                   /* Current line type                 */
  SHORT  iLineJoin;                    /* Current line Join                 */
  SHORT  iLineEnd;                     /* Current line End                  */
  RECTL  DefaultP1P2;                  /* Default P1/P2 settings            */
  RECTL  CurrentP1P2;                  /* Current P1/P2 settings            */
  RECTL  CurrentScale;                 /* Current Scale settings            */
  LONG   lIWScale;                     /* Scale factor for IW command       */
  LONG   lIWScaleMultiplier;           /* Decimal Points in scale 100=2     */
  LONG   lRes_XPelsPerInch;            /* X Resolution, pels/meter          */
  LONG   lRes_YPelsPerInch;            /* Y Resolution, pels/meter          */
  LONG   lPltrRes_XPelsPerMeter;       /* X Resolution, pels/meter          */
  LONG   lPltrRes_YPelsPerMeter;       /* Y Resolution, pels/meter          */
  LONG   lCapsHeight;                  /* Printable page height, pels       */
  LONG   lCapsWidth;                   /* Printable page width, pels        */
  LONG   lCapsDefCharWidth;            /* Default char width                */
  LONG   lCapsDefCharHeight;           /* Default char height               */
  LONG   lCapsDefMarkerWidth;          /* Default Marker Width              */
  LONG   lCapsDefMarkerHeight;         /* Default Marker Height             */
  LONG   lLengthRes;                   /* Resolution of full length band    */
  ULONG  ClipComplexity;               /* Current clip complexity           */
  RECTL  ClipRect;                     /* Bounding rect for clip region     */
  BOOL   bFillingPolygon;              /* TRUE while filling polygons in    */
                                       /* dev.                              */
  BOOL   bFirstPolygonPtSet;           /* TRUE if first polygon point is    */
                                       /* set                               */
  USHORT usNumPtsInPolygon;            /* Number of points in device        */
                                       /* polygon                           */
  ULONG  ulNumPolygonsSent;            /* # of polygons sent to the device  */
                                       /* we count the # of polygons        */
                                       /* sent to the device because HPGL/2 */
                                       /* will run out of memory if too     */
                                       /* many polygons are sent            */
  /*
  **  Character Information
  */
  SIZEF  CharCell;                     /* Character size                    */
  POINTS CharAngle;                    /* Character run/rise sinX, cosY     */
  POINTS CharShear;                    /* Character shear                   */
  USHORT fFlags_cdef;                  /* device CDEF flags(bold-italic)    */
  USHORT AltCharSet;                   /* Current alternate character set   */
  USHORT CharDirection;                /* Character direction               */
  BOOL   bStandardCharSetActive;       /* Standard character set active?    */
  FONTMETRICS fmDefaultFont;           /* Default font metrics              */

  /*
  ** Raster Information.      Kran
  */
  LONG   lxPicFrame;
  LONG   lyPicFrame;
  BOOL   bHPGL2_PalettePushed;         /* TRUE if the pallette was pushed   */
  ULONG  RFindex;                      /* Raster Fill index 1..8            */
  ULONG  ulCurrentPrintMode;           /* Current mode HPGL2 PCL or HPRTL   */

  /*
  ** SetAbortProc stuff @SA
  */
  SETABORTPROC SetAbortProc;           /* SetAbortProcStruct */

} PDEVICE;

typedef PDEVICE  *PPDEVICE;

/*
**  The DRIVDATA structure defines one byte for driver profile information.
**  So the total size of data is sizeof(DRIVDATA) - sizeof(the one byte) +
**  sizeof(the actual driver profile info)
**   #define DRIVDATASIZ  (sizeof(PROFILEINFO) + sizeof(DRIVDATA)
**         - sizeof(pDriverData->abGeneralData))
*/
#define  DRIVDATASIZ   (sizeof(DRIVDATA) - sizeof(CHAR) + sizeof(PROFILEINFO))

typedef struct
{
  LONG LogRGB;                         /* Logical RGB (Index)               */
  LONG PhysRGB;                        /* Physical RGB (Index)              */
} COLORTABLE;

typedef COLORTABLE  *PCOLORTABLE;

/*
** Fill optimization routines and definitions
**
*/
#define  FILLOPTPATH   1              
#define  FILLOPTBOX    1

/*
**  instruction values for optln
*/
#if      FILLOPTPATH
  #define  OPTBUFELEMENTS 300          

typedef struct _OPTLN
{
  BOOL   bActive;                      /* Set when not plotted              */
  USHORT usInstruction;                /* instruction type                  */
  POINTL aptl[2];                      /* The end points                    */
} OPTLN;

typedef OPTLN  *POPTLN;

typedef struct _OPTBUF
{
  USHORT usIndex;                      /* Number of lines stored            */
  POINTL ptlWhere;                     /* Physical pen position             */
  OPTLN olDat[OPTBUFELEMENTS];         /* Lines!                            */
  BOOL bMovePenFirst;                  /* TRUE-move pen to first line of path */
} OPTBUF;

typedef OPTBUF  *POPTBUF;
#endif
/*
** DC state info for save DC must include the following:
** * Current position
** * current attributes
** * current transforms, viewing limits, and clip path
** * any reference to a selected clip window
** * references to any loaded logical fonts
** * references to the regions created on the associated DC
*/
typedef struct _DCSTATE
{
  /*
  ** State #
  */
  LONG lStateID;                       /* State identifier = saved state #  */
  /*
  **  Pointers
  */
  struct _DCSTATE  *pSavedDCState;     /* Previously chained DC State(saveDC)*/
//PRGB2  PRGB2DevicePalette;           /* Ptr to hardware palette RGB2s     */
//                                     /* set by DevicePalette              */
  PCOLORTABLE pColorTable;             /* Logical color table               */
  /*
  **  High access variables
  */
  POINTL LogPosition;                  /* Logical position                  */
  POINTL WorldPosition;                /* World position                    */
  ARCPARAMS ArcParams;                 /* lP, lQ, lR, lS                    */
  /*
  **  ColorTable Information
  */
  USHORT usColorFormat;                /* Color format type                 */
  LONG lColorLoIndex;                  /* Lowest Index                      */
  LONG lColorHiIndex;                  /* Highest Index                     */
  /*
  **  Clip/Region information
  */
  ULONG ClipComplexity;                /* Number of rectangles in clip      */
  RECTL ClipRect;                      /* Bounding rect for clip region     */
  /*
  **  Relevant transform data
  */
  XFORM  xfLastMatrix;                 /* Last seen by NotifyTransformChange*/
  POINTL ptlRotation;                  /* Inferred Rotation information     */
  POINTL ptlShear;                     /* Shear information                 */
  USHORT usXfData;                     /* Status information - see #define  */
  /*
  **  Attribute bundles
  */
  LINEBUNDLE   lbnd;                   /* Current Line Bundle               */
  DCHARBUNDLE  dcbnd;                  /* Current Character Bundle          */
  MARKERBUNDLE mbnd;                   /* Current Marker Bundle             */
  AREABUNDLE   abnd;                   /* Current Area Bundle               */
  IMAGEBUNDLE  ibnd;                   /* Current Image Bundle              */
  AREABUNDLE   abndBeginArea;          /* Begin Area area Bundle            */
  /*
  ** Default Attribute Bundles for GreSetDefaultAttributes
  */
  LINEBUNDLE   lbndDefault;            /* Default line Bundle               */
  DCHARBUNDLE  dcbndDefault;           /* Default Character Bundle          */
  MARKERBUNDLE mbndDefault;            /* Default Marker Bundle             */
  AREABUNDLE   abndDefault;            /* Default Area Bundle               */
  IMAGEBUNDLE  ibndDefault;            /* Default Image Bundle              */
  /*
  **  Miscellaneous information
  */
  BOOL bInArea;                        /* Area converted to path            */
  BOOL bDoFills;                       /* Enable my own filling             */
  BOOL bDrawingText;                   /* TRUE if drawing text              */
  BOOL bFilling;                       /* Doing my own filling              */
  BOOL bClearingArea;                  /* Clearing Area-Don't select new pen */
  BOOL bWideLines;                     /* Doing wide lines in StrokePath    */
  ULONG ulAreaFlags;                   /* Begin area flags                  */
  ULONG ulLineStyle;                   /* Current line style                */

} DCSTATE;
typedef DCSTATE  *PDCSTATE;


/* !!!!!  put this in because we can't use PMWINP.H anymore!!!!! */
#pragma pack(1)
#ifndef FSRSEM
  typedef struct _FSRSEM    /* fsrs */
  {
     USHORT Length;
     USHORT Padding;
     USHORT ProcID;
     USHORT ThrdID;
     USHORT Usage;
     USHORT Client;
     ULONG  Timeout;
     ULONG  RAMsem;
  } FSRSEM;
  typedef FSRSEM *PFSRSEM;
#endif
#pragma pack(0)

typedef struct _DDC                    /* Device Driver Cookie DDC          */
{
  /*
  **  Device info pointer
  */
  PPDEVICE pPDevice;                   /* Pointer to Physical Device        */
  /*
  ** Device surface pointer
  */
  PDEVICESURFACE pDeviceSurface;       /* Pointer to the device surface     */
  /*
  **  Non-Reset information
  */
  USHORT usDCType;                     /* DC Type OD_XXXXXX                 */
  LONG lNumSavedDCs;                   /* Number of saved DCs               */
  /*
  **  Saved DC ID for COM_SAVE around play of journal file
  */
  LONG lSavedDCid;                     
  /*
  ** Need the following variables to support MEMORY_DC. Kranthi
  */
  HDC     hdc ;                        /* HDC  */
  PEDCFONTDATA pEDCFontData;           /* GenPLib Font data for backup font  */
  PEDCGENDATA  pEDCGenData;            /* GenPlib ptr to gendata in pdevice */
  //HDC     hdcDirectMem               /* Direct DC for compatable memory dc */
  HDC     hdcMemory;                   /* HDC for shadow memory DC in Display */
  HRGN    hrgnMemory;                  /* HRGN - shadow memory DC Clip region */

  /*
  **  Bounds information
  */
  BOOL bGpiBoundsIsReset;              /* Flag for Gpi bounds reset         */
  BOOL bUserBoundsIsReset;             /* Flag for User bounds reset        */
  RECTL GpiBounds;                     /* GPI bounds rectangle              */
  RECTL UserBounds;                    /* User bounds rectangle             */

#if      FILLOPTPATH
  /*
  **  Area Fill Optimization Goodies
  */
  POPTBUF pOptBuffer;                  /* Pointer to optimization buffer    */
  USHORT usOptMode;                    /* Optimisation mode - see below     */
#endif
  /*
  **  CodePage stuff
  */
  ULONG ulCurrentProcessCP;            /* ul Current Process code page */
  ULONG ulCodePage;                    /* Current code page in effect       */
  PUSHORT pCPVector;                   /* Code page mapping vector, if != 0 */
  /*
  **  Engine Version
  */
  LONG lEngineVersion;                 /* Engine ver. GreQueryEngineVersion */
  DCSTATE DCState;                     
  /*
  **  Conversion to C/Set 2
  **  Instance Locking
  */
  FSRSEM fsrDDCLock;                   /* FSR Sem to lock DDC               */
  ULONG  ulLockCount;                  /* Number of EnterDrivers per thread */
  PID    pibProcessID;                 /* Process ID of Current thread      */
  TID    tidThreadID;                  /* Thread ID of Current thread       */
  BOOL   bJournalPlayed;
  /*
  ** The GRE used this in there code to implement fxExtra in CharStringPos but
  ** I don't think we need it.
  */
  FIXED  fxTempExtraError;             /* Extra Error used for CharStingPos */
#ifdef POWERPC
  RAMSEM ramsem;                       /* Ram Sem used to lock DDC on POWERPC */
#endif
} DDC;

typedef DDC  *PDDC;

/*
**   Bit definitions used in the usXfData field above.  These specify
**   whether any particular transforms are applicable.
*/

#define  XF_ROTATION   0x0001          /* Rotation applies                  */
#define  XF_SHEAR      0x0002          /* Shear is in effect                */
#define  XF_SCALE_ONLY 0x0004          /* Set if only scaling involved      */

/*
**      Values for usOptMode field above.
*/
#define  FOM_NONE      0               /* No fill optimisation in progress  */
/*
** Recording fill optimisation - no output
*/
#define  FOM_RECORD    1
#define  FOM_PLAY      2               /* Playing back recording            */

/*
**  Aspect ratio values to be applied to the character cell when
**  manipulating characters.  These are determined by the nominal shape
**  of the characters in the hardware font,  and are really guesses
**  based on the default character size for the HP 7445A with A size paper.
*/
#define  ASPECT_D      269             /* The height component              */
#define  ASPECT_M      187             /* The width component               */

typedef struct
{
  UCHAR Min;
  UCHAR Max;
  UCHAR Increment;
} OPTIONINFO;

typedef struct
{
                                       /* Note PenInfo can be as large as   */
                                       /* MAX_CAROUSELS as needed; sync     */
                                       /* size up with code in profile.c    */
                                       /* for (; CarouselIndex < 2; ++)     */
  UCHAR  uchPenColor[MAX_CAROUSELS][MAX_PENS]; /*  Pen Color                */
  UCHAR  uchPenType[MAX_CAROUSELS][MAX_PENS];  /*  Pen Type                 */
  SHORT  sSize;                        /* Media size                        */
  USHORT usActiveCarousels;            /* # of active carousels             */
  BOOL   bUseAppColors;                /* default for bUseAppColors         */
  LONG   lDefaultResIndex;             /* default resolution Index          */
                                       /* into aptlRes_Table                */
} DEFPROFILE;
typedef DEFPROFILE  *PDEFPROFILE;

typedef struct                         /* Device Information Structure      */
{
  UCHAR PenTypeSupport[MAX_PEN_TYPES];
  UCHAR PenOptionsSupport[MAX_PEN_OPTIONS];
  UCHAR PaperFeedSupport;
  UCHAR GECSupport;
  UCHAR PensInCarousel;
  BOOL  fColorSort;                    /* Default color sort state TRUE=ON  */
  USHORT fsMediaSizeSupport;           /* Flags of valid sizes              */
  SHORT ForceValue[8];
  OPTIONINFO Speed;
  OPTIONINFO Force;
  OPTIONINFO Acceleration;
} DEVICEINFO;
typedef DEVICEINFO  *PDEVICEINFO;

typedef struct
{
  UCHAR Speed[MAX_PEN_GROUPS];
  UCHAR Force[MAX_PEN_GROUPS];
  UCHAR Acceleration[MAX_PEN_GROUPS];
} PENOPTIONS;
typedef PENOPTIONS  *PPENOPTIONS;

/*
**  Bit values ORed into the fsOdd field following.  This field allows
**  specifying unusual differences between plotters.
*/

#define  OD_USERIW             0x0001      /* Set if IW uses user units     */
#define  OD_FILLTYPE           0x0002      /* Set if FT (FillType) supported*/
#define  OD_VERTICAL_P1P2      0x0004      /* P1P2 is Vertical              */
/* @MJH2
** The default for filling rectangles is exclusive exclusive.  That is,
** the box boundary is one bigger on all sides than it needs to be.
** If a device has this bit set, then its rectangles are inclusive inclusive
** (that is, the box is the exact size).
*/
#define  OD_FILLRECT_INCLUSIVE 0x0008      /* Filled rectangles are inclusive*/
#define  OD_HPRTL              0x0010      /* Supports HPRTL language        */
#define  OD_PCL                0x0020      /* Supports PCL  language         */
#define  OD_COLOR              0x0040      /* Color Device                   */
#define  OD_HPRTL_GREY         0x0080      /* HPRTL and Supports GreyScaling */
#define  OD_BITMAP_SCALING     0x0100      /* Device supports bitmap scaling */
#define  OD_NEEDS_GAMMA        0x0200      /* Needs a default gamma correction*/
#define  OD_PAGEPROTECT        0x0400      /* Page Protection capability     */
#define  OD_HPGL2_PENPLOTTER   0x0800      /* Pen plotter and supports hpgl2 */
/*
**  Device specific transformation flags
*/

#define  DXF_CENTERED  0x0001
#define  DXF_PORTRAIT  0x0002
#define  DXF_ROTATE90  0x0004

typedef struct                         /* Plotter Class Structure           */
{
  PSZ    pszDeviceModeInit;            /* Device init string -ie mode switch*/
  PSZ    pszDeviceModeTerm;            /* Device Termination string-Mode end*/
  USHORT usHPGLCaps;                   /* HPGL capabilities without GEC     */
  USHORT usHPGLCapsGEC;                /* HPGL capabilities with GEC        */
  USHORT fsOdd;                        /* Funny characteristics             */
  USHORT usMaxPolygonSize;             /* Max polygon points without GEC    */
  USHORT usMaxPolygonSizeGEC;          /* Max polygon points with GEC       */
  USHORT usMaxHPGL2Pens;               /* Max HPGL2 Pens in PC command      */
  ULONG  fulSupportedResolutions;      /* flag of supported resolutions     */
  SHORT  P1P2Index;                    /* Index into P1P2Table              */
  SHORT  PaperResIndex;                /* Index into PaperResTable          */
  SHORT  PrintOffIndex;                /* Index into PrintOffTable          */
  ULONG  fulGplCompressFlags;          /* Supported Genplib compression     */
  ULONG  fulDrvCompressFlags;          /* Supported internal compression    */
  DEVICEINFO DeviceInfo;               /* Device information                */
  PENOPTIONS PenOptions;               /* Pen option information            */
  DEFPROFILE DefProfile;               /* Default profile information       */
} PLOTTERCLASS;
typedef PLOTTERCLASS  *PPLOTTERCLASS;

typedef struct                         /* Plotter Definition Structure      */
{
  USHORT usClass;                      /* Plotter Class                     */
  USHORT usStringId;                   /* String Table Plotter Name         */
  PSZ pDeviceName;                     /* Pointer to ASCII szDeviceName     */
} PLOTTERDEF;
typedef PLOTTERDEF  *PPLOTTERDEF;

//
// Per Process data declared in plotters.c
//
typedef struct                         /* Process data structure           */
{
  PFN pfnSplQmGetJobID;                /* ptr to SplQmGetJobID function    */
  PFN pfnPrtNewPage;                   /* ptr to PrtNewPage function       */
} PERPROCESS;
typedef PERPROCESS *PPPERPROCESS;
//
// End PerProcess data structure
//

#if      DEBUG
  /*
  **  Nice features for debug output
  */
  #define    DEBUGBREAK()  DosCallback(WinDebugBreak)
  #define    DEBUGMSG(psz) DebugOutput(psz)
#else
  #define  DEBUGBREAK()
  #define  DEBUGMSG(psz)
#endif

#ifdef   FONTDEBUG
  #define  FNTDBGMSG(string) DBPRINTF(string)
  #define  FNTDBGMSGBRK(string) ASSERTSTRING(string)
#else
  #define  FNTDBGMSG(string)
  #define  FNTDBGMSGBRK(string)
#endif

#ifdef   COLORDEBUG
  #define  CLRDBGMSG(string) DBPRINTF(string)
  #define  CLRDBGMSGBRK(string) ASSERTSTRING(string)
#else
  #define  CLRDBGMSG(string)
  #define  CLRDBGMSGBRK(string)
#endif


// Changed to "FAR" so that devmode.c could access it...                @MARK
extern POINTL aptlRes_Table[MAX_RESOLUTIONS];
extern PLOTTERCLASS  PlotterClass[MAX_PLOTTER_CLASSES];
extern PLOTTERDEF PlotterDef[];
extern USHORT usPlotterCount;          /* Number of above                   */
extern RECTS P1P2Table[][MAX_MEDIA_SIZES];
extern POINTS PrintOffTable[][MAX_MEDIA_SIZES];
extern POINTL PaperResTable[][MAX_MEDIA_SIZES];
extern POINTS PhysicalPageSize[MAX_MEDIA_SIZES];


extern PSZ pszPJLPageProtOFF,
           pszPJLPageProtLTR,
           pszPJLPageProtA4,
           pszPJLPageProtLGL,
           pszPJLPageProtLEDGER,
           pszPJLPageProtAUTO,
           pszPJLPageProtON;

extern PERPROCESS PerProcess;

#ifdef PAGE_TUNE
#include <tuner.h>
#endif

#endif
