/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = OUTPUT.H
 *
 * DESCRIPTIVE NAME = External Function Declarations
 *
 *
 * VERSION = V2.0
 *
 * DATE        12/12/88
 *
 * DESCRIPTION
 *             Function Prototypes for check_fill_type,
 *             check_line_construction, construct_fixed, construct_float,
 *             construct_point, convert_point, draw_line, draw_point,
 *             end_doc, end_job, end_page, get_closest_point, move_pen,
 *             lift_pen, next_band, output_comma, output_number,
 *             output_point, plot_line, set_default_p1p2,
 *             set_default_scale, set_line_type, set_p1p2, set_scale,
 *             start_doc, start_job, and start_page
 *
 * FUNCTIONS
 *
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
/*
** DEFINES
*/
#define SCALE_ANISOTROPIC   0           /* x may be different than y scale */
#define SCALE_ISOTROPIC     1           /* X and Y scale are the same  */
#define SCALE_POINTFACTOR   2           /* uses a point factor  */


/*
**      Functions made available to the outside world
*/
extern BOOL   check_fill_type ( PDDC );
extern BOOL   check_line_construction ( PDDC );
extern BOOL   check_string_construction ( PDDC );
extern VOID   construct_fixed ( PDDC, LONG );
extern BOOL   construct_float ( PDDC, LONG, ULONG );
extern VOID   construct_point ( PDDC, PPOINTL, BOOL );
extern VOID   convert_point ( PDDC, PPOINTL, BOOL );
extern BOOL   draw_line ( PDDC, PPOINTL, PPOINTL );
extern BOOL   draw_point ( PDDC, PPOINTL );
extern BOOL   end_doc ( PDDC );
extern BOOL   end_job ( PDDC );
extern BOOL   end_page ( PDDC, HDC, LONG, ULONG );
extern BOOL   get_closest_point ( PPOINTL, PPOINTL, PPOINTL );
extern BOOL   move_pen ( PDDC, PPOINTL, BOOL );
extern BOOL   lift_pen ( PDDC );                  
extern BOOL   next_band ( PDDC, HDC, PRECTL, ULONG );
extern VOID   output_comma ( PDDC );
extern VOID   output_number ( PDDC, LONG );
extern VOID   output_point ( PDDC, PPOINTL );
extern BOOL   plot_line ( PDDC, PPOINTL );
extern BOOL   set_default_p1p2 ( PDDC );
extern BOOL   set_default_scale ( PDDC );
extern BOOL   set_line_type ( PDDC, USHORT );
extern BOOL   set_p1p2 ( PDDC, PRECTL );
extern BOOL   set_scale ( PDDC, PRECTL, USHORT );
extern BOOL   set_rotation(PDDC, LONG, BOOL);
extern BOOL   start_doc  ( PDDC );
extern BOOL   start_job  ( PDDC );
extern BOOL   start_page  ( PDDC );
extern BOOL   set_phydevice_unknown(PDDC);
