
;/*****************************************************************************
;*
;* SOURCE FILE NAME = INIT.ASM
;*
;* DESCRIPTIVE NAME = Utility routines
;*
;* COPYRIGHT    COPYRIGHT IBM CORPORATION, 1991, 1992
;*              Copyright Microsoft Corporation, 1990
;*              LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
;*              REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
;*              RESTRICTED MATERIALS OF IBM
;*              IBM CONFIDENTIAL
;*
;* VERSION      V2.0
;*
;* DATE         09/18/88
;*
;* DESCRIPTION  Contains an Int3 routine for debugging purposes
;*
;* FUNCTIONS    Int3
;*
;* NOTES        NONE
;*
;* STRUCTURES   Definition of DefDataType
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR    CHANGE DESCRIPTION
;*   --------  ----------  -----   --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx   xxxxxxx
;*   02/01/90  @V2.0DVH00  AR05753 Wrote R2DosWrite and R3DosWrite
;*                                 1 Feb 90     Dave Van Horn       [davevh]
;*
;*   09/09/90  @V2.0SB00   8131    Changed DosWrite to PrtWrite
;*                                 Tue 09 Sep 1990    -by-    Stacey Barnes
;*****************************************************************************/

        page    ,132

        .386p
        .xlist
        include 32cmacro.inc
        .list
?PLM = CC_SYSCALL

; Change to 'SEG35' for new tuned code.  See PTUNE.H.
;
; CODE32  SEGMENT DWORD PUBLIC USE32 'CODE'
SEG35   SEGMENT DWORD PUBLIC USE32 'CODE'
           ASSUME CS:FLAT, DS:FLAT, ES:FLAT, SS:FLAT
           ALIGN  4h
;/***************************************************************************
;*
;* FUNCTION NAME = Int3
;*
;* DESCRIPTION   = Debugging routine to issue a software interrupt 3
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

;cProc Int3,<PUBLIC>
;cBegin
;        int    3
;cEnd

;**************************************************************************/
; Name: PSZ ENGENTRY SetMem
; Syntax: VOID SetMem(PBYTE, BYTE, ULONG);
;
; Return:   (PBYTE)pbData
;
; Description:  our version of memset();
; NOTE:
;
; History:
;    12/09/92 MV added
;
;**************************************************************************/


cProc   SetMem,<PUBLIC,NODATA,NONWIN>,<EDI,ESI,EBX>
        parmD   Dst
        parmB   SrcByte
        parmD   Count
cBegin
        mov     edi,Dst             ;destination ptr
        mov     al,SrcByte          ;get value
        mov     ah,al               ;blast in word
        mov     ecx,Count           ;get no of bytes
        jecxz short SetMemDone       ;nothing to do
        cld
        test    edi,1                ;word boundary ?
        jz  short SetMemSet1
        stosb
        dec     ecx

SetMemSet1:
        shr     ecx,1                ;try to move by word,
        repz    stosw
        rcl     ecx,1                ;get the module of 2
        repz    stosb
SetMemDone:
cEnd


;===========================================================================
; Function: PSZ ENGENTRY CopyMem
; Syntax:  CopyMem(PBYTE, PBYTE, ULONG);
;
; Return:   PBYTE pbDest
;
; Description:  our version of memcpy (far call)
;
; NOTE:
;
; History:
;    12/09/92 MV added
;
;===========================================================================

cProc   CopyMem,<PUBLIC,NODATA,NONWIN>,<EDI,ESI,EBX>
        parmD   pbDst
        parmD   pbSrc
        parmD   Count
cBegin
        mov     ecx,Count               ;ulSize
        mov     esi,pbSrc               ;src
        mov     edi,pbDst               ;dest
        cld
        shr     ecx,1                    ;try to copy by word,
        repz    movsw
        rcl     cx,1                    ;get the module of 2
        repz    movsb
cEnd

; PAGE_TUNE
; Segment end.
SEG35  ENDS
       END
