/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = FORMS.H
 *
 * DESCRIPTIVE NAME = header for things dealing with user defined forms
 *
 *
 * VERSION = V2.0
 *
 * DATE        11/30/93
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * NOTES
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/***********************************************************************/
/* Global defines                                                      */
/***********************************************************************/

/* Defines for OS2SYS.INI keyname entries
*/
#define UNITS_KEYNAME      "UNITS"
#define FORMS_KEYNAME      "FORMS"

#define NAME_LENGTH        50

/* This contains information about a user defined form.
*/
struct _userforminfo {
   USHORT     usFormID;                  // The ID
   CHAR       achFormName[NAME_LENGTH];  // The name
   ULONG      ulHeight;                  // in hundreds of a millimeter
   ULONG      ulWidth;                   //      "              "
};
typedef struct _userforminfo USERFORMINFO, *PUSERFORMINFO;

/* This is an element in a linked list.
** The two character string arrays are "redundant" information and are
** there to make it easy to display information about the form to the user.
*/
struct _userformlist {
   struct _userformlist *pPrev;                  // The previous list element
   struct _userformlist *pNext;                  // The next list element
   USERFORMINFO          ufi;                    // A user defined form element
   CHAR                  achHeight[NAME_LENGTH]; // Displayed to the user
   CHAR                  achWidth[NAME_LENGTH];  //     "             "
};
typedef struct _userformlist USERFORMLIST, *PUSERFORMLIST;
typedef struct _userformlist **PPUSERFORMLIST;


/***********************************************************************/
/* Global functions                                                    */
/***********************************************************************/
MPARAM user_defined_forms_dialog_proc (HWND          hwnd,
                                       USHORT        msg,
                                       MPARAM        mp1,
                                       MPARAM        mp2);
VOID   display_user_form_paper_size   (PDEVMODE      pDevMode,
                                       HWND          hwnd,
                                       PUSERFORMINFO pufi);
SHORT  add_user_forms_to_list         (PDEVMODE      pDevMode, HWND hwnd);
VOID   delete_user_forms_from_list    (PDEVMODE      pDevMode, HWND hwnd);
VOID   find_user_form_size            (PVOID         pvHeap,
                                       PSZ           pszAppName,
                                       SHORT         Size,
                                       PLONG         plPrintableXmm,
                                       PLONG         plPrintableYmm);
USHORT number_user_forms_defined      (PSZ           pszAppName,
                                       HWND          hwnd);
PBYTE  return_flat_user_forms_list    (PVOID         pvHeap,
                                       PSZ           pszAppName);
BOOL   user_form_exists_exists        (PVOID         pvHeap,
                                       PSZ           pszAppName,
                                       PUSERFORMINFO pUfi);
