/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = clip.h
 *
 * DESCRIPTIVE NAME = Definitions for clip.c
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION        HEADER FILE FOR PLOTTER DRIVER
 *
 *
 * FUNCTIONS
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
/*
**      Values returned from apply_clipping.
*/

#define  AC_RECT0      0               /* No clipping                       */
#define  AC_RECT1      1               /* One rectangle, returned to caller */
#define  AC_RECT2      2               /* Complex clipping - difficult to
                                          handle                            */
#define  MCR_NONE      0               /* No intersection                   */
#define  MCR_WHOLE     1               /* Whole of region intersection      */
#define  MCR_PART      2               /* Part of clip region intersection  */
#define  QC_RECTYSIZE  3L              /*
                                       ** incremental quad clip rectangle size
                                       */
/*
**   Quad Clip parameters and locals
*/
typedef struct
{
  LONG lSize;                          /* incremental clip rect y size
                                          (QC_RECTYSIZE)                    */
  LONG lD;                             /* current y scan line               */
  RECTL rctlBox;                       /* object bounding box               */
  FIXED fxM[4];                        /* line slopes                       */
  FIXED fxB[4];                        /* line y intercepts                 */
  BOOL bEnabled;                       /* quad clipping active?             */
} QCINFO;

typedef QCINFO *PQCINFO;           /* pointer to the above...           */

/*
**  The functions made available to all
*/
extern SHORT apply_clipping ( HDC, PRECTL, PRECTL, PDDC );
extern VOID set_clip_rectangle ( PDDC );
extern USHORT merge_clip_rect ( HDC, PRECTL, PRECTL, PUSHORT, PDDC );
extern VOID rectl_intersect ( PRECTL, PRECTL, PRECTL );
extern BOOL NotifyClipChange ( HDC, PRECTL, ULONG, ULONG, PDDC, ULONG );
extern VOID output_clip_rect ( PDDC, LONG, PRECTL );
extern VOID get_bounds ( INT, PPOINTL, PRECTL );
extern VOID init_quad_clip ( PQCINFO, PPOINTL );
extern BOOL get_quad_clip ( PQCINFO, PRECTL, BOOL );
