/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
// text.c

#define INCL_DOS
#define INCL_PM
#include <os2.h>

#define INCL_GRE_STRINGS
#define INCL_DDIMISC
#define INCL_DDICOMFLAGS
// @DBCS
#define INCL_VMANDDI
#include <ddi.h>
#include <pmddi.h>

// c includes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>

#define INCL_INNER_GRE
#include "def.h"
#include "driver.h"
#include "funcs.h"




//---------------------------------------------------------------------------------------------------------------------
LONG ENGENTRY CharString(               HDC            hdc,
                                        LONG           cChars,
                                        PCHAR          pchString,
                                        PDDC           pddc,
                                        ULONG          ulFunction )
{
  REGREC      regrec;
  ULONG       ulException;
  LONG        lrc;


  REGISTERHANDLER (regrec, globals.hModule);
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    // clean up here
    assertstring ("Exception occured!\n");
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    lrc = GPI_ERROR;
    goto depart;
  }

  ENTERDDC( pddc );

  // pass charstring on to charstringpos
  // keep COM_ flags, but change function number
  lrc = CharStringPos( hdc, NULL, NULL, 0, cChars, pchString, NULL, NULL, pddc, NGreCharStringPos|(0xFFFF0000 & ulFunction ));

depart:
  EXITDDC( pddc );
  UNREGISTERHANDLER( regrec );
  return lrc;
}




/// CharStringPos
///
/// Draws  a character string starting at the current x, y position, with
/// user controlled spacing.  The character string is formatted according
/// to the format control flags passed.
///
/// Parameters
///
///      pch     Long pointer to the string of character codepoints.
///
///      cch     Specifies the number of bytes in the character string.
///
///      flCmd   :-
///
///                CHS_OPAQUE = 0 Opaque rectangle not present
///                           = 1 Opaque rectangle present
///
///                CHS_VECTOR = 0 Position or delta vector not present
///                           = 1 Position or delta vector present
///
///              CHS_LEAVEPOS = 0 Update current position
///                           = 1 Don't update current position
///
///                  CHS_CLIP = 0 Don't clip to opaque rectangle
///                           = 1 Clip to opaque rectangle
///
///              CHS_START_XY = 0 start postion not present
///                           = 1 start postion present
///
///             CHS_ATTR_INFO = 0 Attribute info not present
///                           = 1 Attribute info present
///
///            CHS_UNDERSCORE = 0 No underscore
///                           = 1 Underscore
///
///             CHS_STRIKEOUT = 0 No strikeout
///                           = 1 Strikeout
///
///
///      prclOpaque  optional rectangle which will be filled with the
///                  character background color before the text is layed
///                  down. The coordinates are in world coordinates.
///
///      paDX        optional vector of fixed point deltas or
///                  positions. All information is in world coordinates.
///
///      pptlStart   optional starting position.
///
///      pAttrs      optional structure of attributes to be used with
///                  the characters.  The structure looks like
///                      csp_info struc
///                              cSize   dd ?    ; size of structure in bytes
///                              clrFore dd ?    ; foreground color to use
///                              clrBack dd ?    ; background color to use
///                      csp_info ends
///
///

//---------------------------------------------------------------------------------------------------------------------

LONG ENGENTRY CharStringPos(            HDC            hdc,
                                        PPOINTL        pptlStart,
                                        PRECTL         prclRect,
                                        ULONG          flOptions,
                                        LONG           cChars,
                                        PCHAR          pchString,
                                        PLONG          paDX,
                                        PCSP_INFO      pAttrs,
                                        PDDC           pddc,
                                        ULONG          ulFunction )
{
typedef LONG (* _System PFNCHARSTRINGPOS) (HDC,PPOINTL,PRECTL,ULONG,LONG,PCH,PLONG,PCSP_INFO,ULONG,ULONG);
  REGREC           regrec;
  ULONG            ulException;
  LONG             lrc;
  PFNCHARSTRINGPOS pfnCharStringPos;
#ifdef DEBUG
  PDEBUGINFO       pDbg = &globals.DebugInfo;
#endif


  REGISTERHANDLER (regrec, globals.hModule);
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    // clean up here
    assertstring ("Exception occured!\n");
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    lrc = GPI_ERROR;
    goto depart;
  }
  ENTERDDC( pddc );


  DBPRINTIF(( pDbg->bCHARSTRING, "CharStringPos(): Enter\n" ));

  if( ulFunction & COM_DEVICE )
  {

    DBPRINTIF(( pDbg->bCHARSTRING, "CharStringPos(): COM_DEVICE\n" ));

    // give to shadow DC at device level
    lrc = InnerGreCharStringPos( pddc->hdcShadow, pptlStart, prclRect, flOptions, cChars, pchString, paDX, pAttrs, ulFunction );
    assert( lrc != GPI_ERROR );

  } /* end if */
  else
  {

    // invoke engine simulation function
    pfnCharStringPos = (PFNCHARSTRINGPOS)globals.ppfnDispatchTableCopy[ NGreCharStringPos & 0x00FF ];
    assert( pfnCharStringPos );

    if( flOptions & CHS_START_XY )
    {
      DBPRINTIF(( pDbg->bCHARSTRING, "CharStringPos(~COM_DEVICE): [%d][%d] %s\n",
                  pptlStart->x, pptlStart->y, pchString ));
    } /* end if */
    else
    {
      DBPRINTIF(( pDbg->bCHARSTRING, "CharStringPos(~COM_DEVICE): [curpos] %s\n",
                  pchString ));

    } /* end else */

    lrc = (LONG)( *pfnCharStringPos )( hdc, pptlStart, prclRect, flOptions, cChars, pchString, paDX, pAttrs, (ULONG)pddc, ulFunction );
    assert( lrc != GPI_ERROR );

  } /* end else */


depart:
  EXITDDC( pddc );
  UNREGISTERHANDLER( regrec );

  DBPRINTIF(( pDbg->bCHARSTRING, "CharStringPos(): Exit\n" ));

  return(lrc);

} /* end CharStringPos */




//---------------------------------------------------------------------------------------------------------------------

LONG ENGENTRY QueryCharPositions(       HDC            hdc,
                                        PPOINTL        pptlStart,
                                        ULONG          flOptions,
                                        LONG           cChars,
                                        PCHAR          pchString,
                                        PLONG          paDX,
                                        PPOINTL        paptlXY,
                                        PDDC           pddc,
                                        ULONG          ulFunction )
{
typedef LONG (* _System PFNQUERYCHARPOS) (HDC,PPOINTL,ULONG,LONG,PCH,PLONG,PPOINTL,ULONG,ULONG);
  REGREC          regrec;
  ULONG           ulException;
  LONG            lrc;
  PFNQUERYCHARPOS pfn;


  REGISTERHANDLER (regrec, globals.hModule);
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    // clean up here
    assertstring ("Exception occured!\n");
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    lrc = FALSE;
    goto depart;
  }
  ENTERDDC( pddc );

  // call the engine simulation function for this case
  pfn = (PFNQUERYCHARPOS)globals.ppfnDispatchTableCopy[ NGreQueryCharPositions & 0x00FF ];
  assert( pfn );
  lrc = (*pfn)( hdc, pptlStart, flOptions, cChars, pchString, paDX, paptlXY, (ULONG)pddc, ulFunction );
  assert( lrc );


depart:
  EXITDDC( pddc );
  UNREGISTERHANDLER( regrec );
  return lrc;
}




//---------------------------------------------------------------------------------------------------------------------

LONG ENGENTRY QueryTextBox(             HDC            hdc,
                                        LONG           cChars,
                                        PCHAR          pchString,
                                        LONG           cptPosition,
                                        PPOINTL        paptlPosition,
                                        PDDC           pddc,
                                        ULONG          ulFunction )
{
typedef LONG (* _System PFNQUERYTEXTBOX) (HDC,LONG,PCHAR,LONG,PPOINTL,ULONG,ULONG);
  REGREC          regrec;
  ULONG           ulException;
  LONG            lrc;
  PFNQUERYTEXTBOX pfn;


  REGISTERHANDLER (regrec, globals.hModule);
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    // clean up here
    assertstring ("Exception occured!\n");
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    lrc = FALSE;
    goto depart;
  }
  ENTERDDC( pddc );


  // call the engine simulation function for this case
  pfn = (PFNQUERYTEXTBOX)globals.ppfnDispatchTableCopy[ NGreQueryTextBox & 0x00FF ];
  assert( pfn );
  lrc = (*pfn)( hdc, cChars, pchString, cptPosition, paptlPosition, (ULONG)pddc, ulFunction );
  assert( lrc );


depart:
  EXITDDC( pddc );
  UNREGISTERHANDLER( regrec );
  return lrc;
}




//---------------------------------------------------------------------------------------------------------------------

LONG ENGENTRY QueryWidthTable(          HDC            hdc,
                                        LONG           lFirstChar,
                                        LONG           cWidthTable,
                                        PLONG          paWidthTable,
                                        PDDC           pddc,
                                        ULONG          ulFunction )
{
typedef LONG (* _System PFNQUERYWIDTHTABLE) (HDC,LONG,LONG,PLONG,ULONG,ULONG);
  REGREC             regrec;
  ULONG              ulException;
  LONG               lrc;
  PFNQUERYWIDTHTABLE pfn;


  REGISTERHANDLER (regrec, globals.hModule);
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    // clean up here
    assertstring ("Exception occured!\n");
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    lrc = FALSE;
    goto depart;
  }
  ENTERDDC( pddc );


  // call the engine simulation function for this case
  pfn = (PFNQUERYWIDTHTABLE)globals.ppfnDispatchTableCopy[ NGreQueryWidthTable & 0x00FF ];
  assert( pfn );
  lrc = (*pfn)( hdc, lFirstChar, cWidthTable, paWidthTable, (ULONG)pddc, ulFunction );
  assert( lrc );

depart:
  EXITDDC( pddc );
  UNREGISTERHANDLER( regrec );
  return lrc;
}


