/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
// output.c

// Output routines


#define INCL_DOS
#define INCL_PM
#define INCL_SPL
#define INCL_SPLFSE
#include <os2.h>

// @DBCS
#define INCL_VMANDDI
#include <ddi.h>
#include <pmddi.h>

// c includes
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <setjmp.h>

// genplib includes
#define INCL_GENPLIB_COMPRESS

#include "def.h"
#include "driver.h"
#include "funcs.h"

#if 0
BOOL
WriteCommandWithWord (HTHREAD hThread,
                      PBYTE pbCommand,
                      USHORT usWord,
                      ULONG ulLength)
{
   CHAR   achSend[50];
   BOOL   bRC;

   memcpy (achSend, pbCommand, ulLength);
   achSend[ulLength]   = LOBYTE (usWord);
   achSend[ulLength+1] = HIBYTE (usWord);

   bRC = GplThreadOutput (hThread,
                          achSend,
                          ulLength+2,
                          THREAD_DT_BINARY);
   assertF (bRC);

   return bRC;

}

BOOL
WriteCommandWithPrintf (HTHREAD hThread,
                        USHORT  usLength,
                        PSZ     pszCommand,
                                ...)
{
   CHAR         achCmd[10];
   CHAR         achOutput[512];
   ULONG        ulBytesWritten = 0;
   BOOL         bRC;
   va_list      list;
   register INT iSrc, iDst;

   // use the va* functions to implement dbprintf with vsprintf
   // see va* function documentation in your ANSI C compiler reference
   va_start (list, pszCommand);

   for (iSrc = 0, iDst = 0; iSrc < usLength; iSrc++)
   {
      achOutput[iDst] = pszCommand[iSrc];
      if ('%' == pszCommand[iSrc])
      {
         USHORT  usLen;
         INT     iValueOnStack;

         achCmd[0] = pszCommand[iSrc];
         achCmd[1] = pszCommand[iSrc+1];
         achCmd[2] = 0;
         iValueOnStack = va_arg (list,int);   // Grab off stack, point to next one

         if (('w' == achCmd[1]) ||
             ('W' == achCmd[1])  )
         {
            /* Special format character
            */
            achOutput[iDst]   = LOBYTE (iValueOnStack);
            achOutput[iDst+1] = HIBYTE (iValueOnStack);
            usLen = 2;
         }
         else if (('c' == achCmd[1]) ||
                  ('C' == achCmd[1])  )
         {
            /* Need to special case this because if you use %c and give it
            ** a 0, then strlen will return 0 instead of 1.
            */
            achOutput[iDst] = iValueOnStack;
            usLen = 1;
         }
         else
         {
            sprintf (achOutput+iDst,
                     achCmd,
                     iValueOnStack);

            if (iValueOnStack)
               usLen = strlen (achOutput+iDst);
            else
               usLen = 1;
         }

         ulBytesWritten += usLen;
         iDst += usLen;
         iSrc++;
      }
      else
      {
         ulBytesWritten++;
         iDst++;
      }
   }

   va_end (list);

   bRC = GplThreadOutput (hThread,
                          achOutput,
                          ulBytesWritten,
                          THREAD_DT_BINARY);
   assertF (bRC);

   return bRC;
}

BOOL
WriteASCIICommand (HTHREAD hThread, PSZ pszCommand)
{
   BOOL   bRC;

   bRC = GplThreadOutput (hThread,
                          pszCommand,
                          strlen (pszCommand),
                          THREAD_DT_BINARY);
   assertF (bRC);

   return bRC;
}

BOOL
WriteBlock (HTHREAD hThread, PBYTE pbBlock, ULONG ulLength)
{
   BOOL   bRC;

   bRC = GplThreadOutput (hThread,
                          pbBlock,
                          ulLength,
                          THREAD_DT_BINARY);
   assertF (bRC);

   return bRC;
}

BOOL
BufferCommandWithWord (PBYTE  pbByte,
                       PINT   pIndex,
                       PBYTE  pbCommand,
                       USHORT usWord,
                       ULONG  ulLength)
{
   memcpy (pbByte, pbCommand, ulLength);
   pbByte[ulLength]   = LOBYTE (usWord);
   pbByte[ulLength+1] = HIBYTE (usWord);

   *pIndex += ulLength+2;

   return TRUE;
}

BOOL
BufferCommandWithPrintf (PBYTE  pbByte,
                         PINT   pIndex,
                         USHORT usLength,
                         PSZ    pszCommand,
                                ...)
{
   CHAR         achCmd[10];
   ULONG        ulBytesWritten = 0;
   va_list      list;
   register INT iSrc, iDst;

   // use the va* functions to implement dbprintf with vsprintf
   // see va* function documentation in your ANSI C compiler reference
   va_start (list, pszCommand);

   for (iSrc = 0, iDst = 0; iSrc < usLength; iSrc++)
   {
      pbByte[iDst] = pszCommand[iSrc];
      if ('%' == pszCommand[iSrc])
      {
         USHORT  usLen;
         INT     iValueOnStack;

         achCmd[0] = pszCommand[iSrc];
         achCmd[1] = pszCommand[iSrc+1];
         achCmd[2] = 0;
         iValueOnStack = va_arg (list,int);   // Grab off stack, point to next one

         if (('w' == achCmd[1]) ||
             ('W' == achCmd[1])  )
         {
            pbByte[iDst]   = LOBYTE (iValueOnStack);
            pbByte[iDst+1] = HIBYTE (iValueOnStack);
            usLen = 2;
         }
         else
         {
            sprintf (pbByte+iDst,
                     achCmd,
                     iValueOnStack);

            if (iValueOnStack)
               usLen = strlen (pbByte+iDst);
            else
               usLen = 1;
         }

         ulBytesWritten += usLen;
         iDst += usLen;
         iSrc++;
      }
      else
      {
         ulBytesWritten++;
         iDst++;
      }
   }

   va_end (list);

   *pIndex += ulBytesWritten;

   return TRUE;
}

BOOL
BufferASCIICommand (PBYTE pbByte, PINT pIndex, PSZ pszCommand)
{
   ULONG  ulBytesWritten = 0;

   ulBytesWritten = strlen (pszCommand);
   memcpy (pbByte, pszCommand, ulBytesWritten);
   *pIndex += ulBytesWritten;

   return TRUE;
}

BOOL
BufferBlock (PBYTE pbByte, PINT pIndex, PBYTE pbBlock, ULONG ulLength)
{
   memcpy (pbByte, pbBlock, ulLength);
   *pIndex += ulLength;

   return TRUE;
}

BOOL
BufferWord (PBYTE pbByte, PINT pIndex, USHORT usWord)
{
   pbByte[0] = LOBYTE (usWord);
   pbByte[1] = HIBYTE (usWord);

   *pIndex += 2;

   return TRUE;
}

#endif

VOID
SetYPosition (PDDC pddc, INT iWorldY)
{
   pddc->ptlPrintHead.y = iWorldY;
}

#if 0
/****************************************************************************
 * FUNCTION       : CompressRasterPlane()                                              *
 * AUTHOR         : mjones                                                  *
 * DATE WRITTEN   : 08/08/94                                                *
 * DESCRIPTION    : Calls compress routine and then writeblock()            *
 *                                                                          *
 * PARAMETERS: pbBuffer = pointer to bytes to compress (Input)              *
 *             iPrinterBytesInArray = count of bytes to compress (Input)    *
 *             LastPlane = TRUE if last plane (Input)                       *
 *             pbLastLine = pointer to bytes in previous scanline (Input)   *
 *             pbCompress = pointer to contain compress output (Output)     *
 *             currentcompressmode = pointer to current compress mode in    *
 *                                   effect.                                *
 *             pvDDC = pointer to Drawing Device Context.                   *
 *             pDelta = pointer to array of pointers to difference          *
 *                      fragments.                                          *
 *                                                                          *
 * RETURN VALUES:                                                           *
 *                                                                          *
 *--------------------------------------------------------------------------*
 * CHANGE/MODIFICATION LOG :                                                *
 *--------------------------------------------------------------------------*
 *                                                                          *
 ****************************************************************************/

BOOL _System CompressRasterPlane( PBYTE pbBuffer, INT iPrinterBytesInArray, BOOL LastPlane,
          PBYTE pbLastLine, PBYTE pbCompress ,PINT currentcompressmode, ULONG compressmodesupported, PVOID pvDDC, PUSHORT pDelta )
{

  PDDC pddc = (PDDC)pvDDC;
  INT compressmode, iCompressed;


  if (compressmodesupported != 0)
     compressmode = GplCompressChooseMode(pbBuffer, pbLastLine, iPrinterBytesInArray, compressmodesupported, pDelta );
  else
     compressmode = 0;

  if (*currentcompressmode != compressmode )
  {
    WriteCommandWithPrintf (pddc->pdb->hThread,
                       pddc->pdb->pDevice->pCmds->ulCmdSetCompression,
                       pddc->pdb->pDevice->pCmds->pszCmdSetCompression,
                       compressmode);

    *currentcompressmode = compressmode;
  }

  switch (compressmode)
  {
     case 0:           // no compression
         iCompressed = iPrinterBytesInArray;
         memcpy( pbCompress, pbBuffer, iPrinterBytesInArray);
         if (compressmodesupported >= GPLCOMPRESS_DELTAROW)
              memcpy( pbLastLine, pbBuffer, iPrinterBytesInArray);
         break;
     case 1:           // mode 1 = RLL compression
          iCompressed = GplCompressRLL (pbBuffer,
                                        iPrinterBytesInArray,
                                        pbCompress,
                                        2 * iPrinterBytesInArray);
         assertT(iCompressed == -1 );
         if (compressmodesupported >= GPLCOMPRESS_DELTAROW)
              memcpy( pbLastLine, pbBuffer, iPrinterBytesInArray);
         break;
     case 2:           // mode 2 = TIFF compression
         iCompressed = GplCompressTIFF (pbBuffer,
                                        iPrinterBytesInArray,
                                        pbCompress,
                                        2 * iPrinterBytesInArray);
         assertT(iCompressed == -1 );
         if (compressmodesupported >= GPLCOMPRESS_DELTAROW)
              memcpy( pbLastLine, pbBuffer, iPrinterBytesInArray);
         break;
     case 3:           // mode 3 = Delta Row compression


         iCompressed = GplCompressDeltaRow (  iPrinterBytesInArray,
                                           pbBuffer,
                                           pbLastLine,
                                           2 * iPrinterBytesInArray,
                                           pbCompress,
                                           pDelta );


         assertT(iCompressed == -1);
         if (iCompressed != 0)        // current and last line are different
           memcpy( pbLastLine, pbBuffer, iPrinterBytesInArray);
         break;
      case 9:           // mode 9 = Enhanced Delta Row compression




         iCompressed = GplCompressRLLDeltaRow(iPrinterBytesInArray,
                                           pbBuffer,
                                           pbLastLine,
                                           2 * iPrinterBytesInArray,
                                           pbCompress,
                                           pDelta );


         if (iCompressed != 0)     // current and last line are different
           memcpy( pbLastLine, pbBuffer, iPrinterBytesInArray);
         break;
     default:
        assertstring("Bad compression type");    // should never execute
        break;

   } /* end switch */

   // Write raster data transfer header

   if (LastPlane)
     WriteCommandWithPrintf (pddc->pdb->hThread,
                           pddc->pdb->pDevice->pCmds->ulCmdTransferRasterBlock,
                           pddc->pdb->pDevice->pCmds->pszCmdTransferRasterBlock,
                           iCompressed);
   else
     WriteCommandWithPrintf (pddc->pdb->hThread,
                           pddc->pdb->pDevice->pCmds->ulCmdTransferRasterPlane,
                           pddc->pdb->pDevice->pCmds->pszCmdTransferRasterPlane,
                           iCompressed);

   // Send a scanline
   if (iCompressed != 0)
     WriteBlock (pddc->pdb->hThread, pbCompress, iCompressed);

  return FALSE;

} /* end CompressRasterPlane */

#endif
