/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
// newframe.c
// get bits from shadow DC and send them to the printer

#define INCL_DOS
#define INCL_SPL
#define INCL_SPLFSE
#define INCL_PM
#include <os2.h>

#define INCL_GRE_DEVMISC2
#define INCL_GRE_DEVICE
#define INCL_GRE_BITMAPS
#define INCL_GRE_DEVSUPPORT
#define INCL_GRE_COLORTABLE
#define INCL_DDIMISC
#define INCL_GRE_DEVICESURFACE  // 2.2 Engine stuff
#define INCL_VMANDDI            // 2.2 Engine stuff
#include <ddi.h>                // 2.2 Engine stuff
#include <pmddi.h>

// c includes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>
#include <memory.h>

#include "def.h"
#include "driver.h"
#include "funcs.h"

#define INCL_GENPLIB_LAYOUT
#include <genplib.h>

#define BUMP_TO_NEXT_MODULUS(n,m) ((((n)+(m)-1)/(m))*(m))


#if 0
INT
GrabPrintHeadBand (PBYTE pbBits,
                   PBYTE pbBuffer,
                   INT   iMaxX,
                   INT   iCurrentY,
                   INT   iBytesPerColumn,
                   INT   iBytesInScanLine,
                   BOOL  fInterleaved,
                   PINT  piMaxRight)
{
   static BYTE  bMaxBit[256] = {
                              0, 8, 7, 8, 6, 8, 7, 8, 5, 8, 7, 8, 6, 8, 7, 8,
                              4, 8, 7, 8, 6, 8, 7, 8, 5, 8, 7, 8, 6, 8, 7, 8,
                              3, 8, 7, 8, 6, 8, 7, 8, 5, 8, 7, 8, 6, 8, 7, 8,
                              4, 8, 7, 8, 6, 8, 7, 8, 5, 8, 7, 8, 6, 8, 7, 8,
                              2, 8, 7, 8, 6, 8, 7, 8, 5, 8, 7, 8, 6, 8, 7, 8,
                              4, 8, 7, 8, 6, 8, 7, 8, 5, 8, 7, 8, 6, 8, 7, 8,
                              3, 8, 7, 8, 6, 8, 7, 8, 5, 8, 7, 8, 6, 8, 7, 8,
                              4, 8, 7, 8, 6, 8, 7, 8, 5, 8, 7, 8, 6, 8, 7, 8,
                              1, 8, 7, 8, 6, 8, 7, 8, 5, 8, 7, 8, 6, 8, 7, 8,
                              4, 8, 7, 8, 6, 8, 7, 8, 5, 8, 7, 8, 6, 8, 7, 8,
                              3, 8, 7, 8, 6, 8, 7, 8, 5, 8, 7, 8, 6, 8, 7, 8,
                              4, 8, 7, 8, 6, 8, 7, 8, 5, 8, 7, 8, 6, 8, 7, 8,
                              2, 8, 7, 8, 6, 8, 7, 8, 5, 8, 7, 8, 6, 8, 7, 8,
                              4, 8, 7, 8, 6, 8, 7, 8, 5, 8, 7, 8, 6, 8, 7, 8,
                              3, 8, 7, 8, 6, 8, 7, 8, 5, 8, 7, 8, 6, 8, 7, 8,
                              4, 8, 7, 8, 6, 8, 7, 8, 5, 8, 7, 8, 6, 8, 7, 8
   };
   static BYTE  bBitMask[8] = {0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01};
   static BYTE  bRemMask[8] = {0x80, 0xC0, 0xE0, 0xF0, 0xF8, 0xFC, 0xFE, 0xFF};
   BOOL         fAllZero    = TRUE;
   BYTE         currentbyte,
                columnbyte0, columnbyte1, columnbyte2, columnbyte3,
                columnbyte4, columnbyte5, columnbyte6, columnbyte7;
   INT          iPosInArray,
                iBytesInCX,
                iRemX,
                iMaxRight;
   INT          offset2, offset3, offset4, offset5, offset6, offset7;
   register INT i, j, x;

   // Sanity checks
   assertF (pbBits);
   assertF (pbBuffer);
   assertF (iMaxX);
   assertF (iBytesPerColumn);
   assertF (iBytesInScanLine);

   iMaxRight = 0;

   // How many bytes are there for the iMaxX bits?
   iBytesInCX = BUMP_TO_NEXT_MODULUS (iMaxX, 8) / 8;

   /* The for loop and the other tests expect the number to be one less than
   ** the real number.
   */
   iBytesInCX--;

   // How many bits are there in the last byte?
   iRemX = iMaxX & 7;
   if (0 == iRemX)
      /* Since cx is divisible by 8, the "end of the byte" is in effect and
      ** you want to address every bit in that byte.
      */
      iRemX = 8;
   assertF (1 <= iRemX && iRemX <= 8);

   // Calculate the offsets in advance
   offset2  = iBytesPerColumn << 1;
   offset3  = offset2 + iBytesPerColumn;
   offset4  = offset3 + iBytesPerColumn;
   offset5  = offset4 + iBytesPerColumn;
   offset6  = offset5 + iBytesPerColumn;
   offset7  = offset6 + iBytesPerColumn;

   /* Loop through every pel in the X direction one byte at a time.
   ** 8-bit move along the x axis.
   */
   for (x = 0; x <= iBytesInCX; x++)
   {
      /* Calculate the offset into the bitmap array (OS/2 PM defined).
      ** This is a 1-bpp bitmap format.  Note that x (in pels) runs in
      ** multiples of 8, so to access the bitmap data, you need to divide
      ** by 8.
      */
      iPosInArray = x + iCurrentY * iBytesInScanLine;

      /* Loop through the number of bytes in the printer head.
      ** 8-bit move along the y axis.
      */
      for (j = 0; j < iBytesPerColumn; j++)
      {
         // Clear out the column bits
         columnbyte0 = columnbyte1 = columnbyte2 = columnbyte3 =
         columnbyte4 = columnbyte5 = columnbyte6 = columnbyte7 = 0;

         if (iPosInArray >= 0)
         {
            /* Construct the 90 deg rotated bytes from column of bits.
            ** Loop through each scanline in the 8-bit byte of the printer head.
            ** 1-bit move along the y axis.
            */
            for (i = 0; i <= 7; i++)
            {
               // Grab the byte of bitmap data
               currentbyte = pbBits[iPosInArray];

               if (x == iBytesInCX)
                  /* If this is the last byte then, only look at the remaining
                  ** bits (mask off extraneous bits).
                  */
                  currentbyte &= bRemMask[iRemX - 1];

               // Is there something there?
               if (currentbyte)
               {
                  fAllZero = FALSE;

                  /* Keep track of the maximum bit that was set for this
                  ** byte of bitmap data.
                  */
                  iMaxRight = max (((x << 3) + bMaxBit[currentbyte]),
                                   iMaxRight);

                  /* Set the corresponding rotated bits in the column bytes.
                  */
                  if (currentbyte & 0x80) columnbyte0 |= bBitMask[i];
                  if (currentbyte & 0x40) columnbyte1 |= bBitMask[i];
                  if (currentbyte & 0x20) columnbyte2 |= bBitMask[i];
                  if (currentbyte & 0x10) columnbyte3 |= bBitMask[i];
                  if (currentbyte & 0x08) columnbyte4 |= bBitMask[i];
                  if (currentbyte & 0x04) columnbyte5 |= bBitMask[i];
                  if (currentbyte & 0x02) columnbyte6 |= bBitMask[i];
                  if (currentbyte & 0x01) columnbyte7 |= bBitMask[i];
               }

               /* Decrement the scan line pointer.  This has the effect of
               ** keeping x the same and moving one less for y.
               */
               iPosInArray -= iBytesInScanLine;
               if (fInterleaved)
                  iPosInArray -= iBytesInScanLine;

               if (iPosInArray < 0)
                  // We are outside the bitmap array.  Leave!
                  break;
            }
         }

         // Are we on the last byte?
         if (x == iBytesInCX)
         {
            /* Check the number of bits remaining before writing out the data.
            ** We are guarenteed at least one.
            */
            *(pbBuffer + j) = columnbyte0;
            if (1 < iRemX)
               *(pbBuffer + iBytesPerColumn + j) = columnbyte1;
            if (2 < iRemX)
               *(pbBuffer + offset2         + j) = columnbyte2;
            if (3 < iRemX)
               *(pbBuffer + offset3         + j) = columnbyte3;
            if (4 < iRemX)
               *(pbBuffer + offset4         + j) = columnbyte4;
            if (5 < iRemX)
               *(pbBuffer + offset5         + j) = columnbyte5;
            if (6 < iRemX)
               *(pbBuffer + offset6         + j) = columnbyte6;
            if (7 < iRemX)
               *(pbBuffer + offset7         + j) = columnbyte7;
         }
         else
         {
            /* Write the 8 column block of bitmap data.
            */
            *(pbBuffer +                   j) = columnbyte0;
            *(pbBuffer + iBytesPerColumn + j) = columnbyte1;
            *(pbBuffer + offset2         + j) = columnbyte2;
            *(pbBuffer + offset3         + j) = columnbyte3;
            *(pbBuffer + offset4         + j) = columnbyte4;
            *(pbBuffer + offset5         + j) = columnbyte5;
            *(pbBuffer + offset6         + j) = columnbyte6;
            *(pbBuffer + offset7         + j) = columnbyte7;
         }
      }

      /* We have done an 8 byte block for however many byte columns there
      ** are.  Increment the output buffer pointer...
      */
      pbBuffer += (iBytesPerColumn << 3);
   }

   // Return the maximum bit that was set in the x axis.
   if (piMaxRight)
      *piMaxRight = iMaxRight;

   // Return if this band is empty or not.
   return fAllZero;
}
#endif

BYTE
GrabColumnByte (PBYTE pbBits,
                INT   x,
                INT   y,
                INT   iOffset,
                INT   iMaxX,
                INT   iBytesInArray)
{
   static BYTE  Mask[8] = {
                0x80,
                0x40,
                0x20,
                0x10,
                0x08,
                0x04,
                0x02,
                0x01
   };
   BYTE         byte = 0;
   INT          yPosInArray;
   register INT i;

   if (x >= iMaxX)
      // Out of bounds condition
      return 0;

   /* We start at the top of the buffer and look down as y decreases.
   ** However, the scan line data starts at 0 and moves up.  Therefore,
   ** we must calculate the inverse offset.
   */
   yPosInArray = (y - (iOffset << 3 )) * iBytesInArray;

   for (i = 0; i <= 7; i++)
   {
      if (yPosInArray >= 0)
      {
         // Within bounds condition
         // Should be safe to get the byte
         if (pbBits[yPosInArray + (x >> 3)] & Mask[x & 0x7])
            byte |= Mask[i];
      }
      else
         break;

      yPosInArray -= iBytesInArray;   // get next byte
   }

   return byte;
}

VOID
RotateBits (PCHAR pchINBuffer, PCHAR pchOUTBuffer, PBITMAPINFO2 pbmi)
{
   LONG         lOutScanLine;
   LONG         lMaxOutScanLine;
   LONG         lNumByteInINColumn;
   INT          iMaxINX;
   INT          iINY;
   INT          iBytesInOUTArray,
                iBytesInINArray;
   register INT x, b;

#ifdef DEBUG
  PDEBUGINFO  pDbg = &globals.DebugInfo;
#endif

   DBPRINTIF(( pDbg->bDEVESC_NEWFRAME, ">>>> Entry: RotateBits() <<<<\n" ));

   iMaxINX = pbmi->cx;
   lMaxOutScanLine = pbmi->cx-1;
   lOutScanLine = 0;
   lNumByteInINColumn = BUMP_TO_NEXT_MODULUS (pbmi->cy, 8)/8;
   iBytesInOUTArray   = BUMP_TO_NEXT_MODULUS (pbmi->cy, 32)/8;
   iBytesInINArray    = BUMP_TO_NEXT_MODULUS (pbmi->cx, 32)/8;

   for (x = pbmi->cx-1; x >= 0; x--)
   {
      iINY = pbmi->cy-1;

      for (b = 0; b < lNumByteInINColumn; b++)
      {
         pchOUTBuffer[(lMaxOutScanLine-lOutScanLine)*iBytesInOUTArray + b]
                = GrabColumnByte (pchINBuffer, x, iINY, 0, iMaxINX, iBytesInINArray);
         iINY -= 8;
      }
      lOutScanLine++;
   }

   DBPRINTIF(( pDbg->bDEVESC_NEWFRAME, ">>>> Exit: RotateBits() <<<<\n" ));
}

VOID
RotateColorBytes (PCHAR        pchINBuffer,
                  PCHAR        pchOUTBuffer,
                  PBITMAPINFO2 pbmi)
{
   LONG         lNumPadBytesInOUTArray,
                lNumPadBytesInINArray;
   INT          iNumBytesInPel;
   INT          iMaxY;
   register INT x, y, b;
#ifdef DEBUG
  PDEBUGINFO  pDbg = &globals.DebugInfo;
#endif

   DBPRINTIF(( pDbg->bDEVESC_NEWFRAME, ">>>> Entry: RotateColorBytes() <<<<\n" ));

   //  Need to add 4 bit per pel format.
   switch (pbmi->cBitCount)
   {
   case 4:
      assertstring("pbmi->cBitCount = 4 TDB");
      break;
   case 8:
      break;
   case 16:
      break;
   case 24:
      break;
   default:
      assertstring("pbmi->cBitCount not known");
      break;
   }

   /*   Example:
   **   bitmap size = (3, 5)
   **
   **       +--------+ padded to 32-bit
   ** ptr=> 04  14  24 boundary
   **       03  13  23                     +------------+ padded to 32-bit
   **       02  12  22  [rotated to] ptr=> 00 01 02 03 04 boundary
   **       01  11  21                     10 11 12 13 14
   **       00  10  20                     20 21 22 23 24
   **
   **           
   **                                        
   **                 [rotated to]           
   **                                          
   **           
   **
   ** There are three complications in this matrix rotate:
   **  1) each y scan line is padded to a 32bit boundary
   **  2) the byte pointer starts at the maximum y scan line and moves down
   **     to 0.
   **  3) each (x,y) element can be a 8, 16, or 24 bit number
   */
   iMaxY                  = pbmi->cy - 1;
   lNumPadBytesInINArray  = (((pbmi->cBitCount * pbmi->cx) + 31) >> 5) << 2;
   lNumPadBytesInOUTArray = (((pbmi->cBitCount * pbmi->cy) + 31) >> 5) << 2;
   iNumBytesInPel         = pbmi->cBitCount / 8;

   PRINT_VARtIF (pDbg->bDEVESC_NEWFRAME, iMaxY,                  d);
   PRINT_VARtIF (pDbg->bDEVESC_NEWFRAME, pchINBuffer,            x);
   PRINT_VARtIF (pDbg->bDEVESC_NEWFRAME, pchOUTBuffer,           x);
   PRINT_VARtIF (pDbg->bDEVESC_NEWFRAME, lNumPadBytesInINArray,  d);
   PRINT_VARtIF (pDbg->bDEVESC_NEWFRAME, lNumPadBytesInOUTArray, d);
   PRINT_VARtIF (pDbg->bDEVESC_NEWFRAME, iNumBytesInPel,         d);

   for (x = pbmi->cx - 1; x >= 0; x--)
      for (y = 0; y <= iMaxY; y++)
         for (b = 0; b < iNumBytesInPel; b++)
            pchOUTBuffer[ (x*lNumPadBytesInOUTArray)
                        + (y*iNumBytesInPel)
                        + b]
                        = pchINBuffer[ (iMaxY - y)*lNumPadBytesInINArray
                                     + (x*iNumBytesInPel)
                                     + b];

   DBPRINTIF(( pDbg->bDEVESC_NEWFRAME, ">>>> Exit: RotateColorBytes() <<<<\n" ));
}

VOID
SwapScanLines (PVOID pvS,
               PVOID pvD,
               INT   iNumULs,
               INT   iBitCount)
{
   ULONG           ulDDecrement;
   register PULONG pulS = (PULONG)pvS;
   register PULONG pulD = (PULONG)pvD;
   register ULONG  ulTemp;
   register INT    j;

   ulDDecrement = iNumULs * 2;

   /* Stop when the source scan line is beyond the destination scan
   ** line.  Do not bother swapping the same scan line (pulS == pulD)
   */
   while (pulS < pulD)
   {
      /* Loop through the number of double words in a scanline
      */
      j = iNumULs;
      while (j)
      {
         /* Swap one source dword with one destination dword
         */
         ulTemp = *pulS;
         *pulS  = *pulD;
         *pulD  = ulTemp;

         /* Decrement, increment, etc...
         */
         j--;
         pulS++;
         pulD++;
      }

      /* No need to increment the source scan line.
      ** The destination scan line is two scan lines farther down in memory.
      ** It should have moved up one scan line.  Make it so...
      */
      pulD -= ulDDecrement;
   }
}

VOID
MirrorBuffer (PCHAR        pchBitBuffer,
              PBITMAPINFO2 pbmi,
              LONG         cBytesPerScanLineIN)
{
#define SRCBUFFER( xloc ) (y + xloc)

#define DESTBUFFER( xloc ) (y + xloc)

#define SWAPPARTIALBYTE savePel = *SRCBUFFER(xl) & leftPel ;   \
                        if( *SRCBUFFER(xr) & rightPel )        \
                           *DESTBUFFER(xl) |= leftPel;         \
                        else                                   \
                           *DESTBUFFER(xl) &= ~leftPel;        \
                                                               \
                        if( savePel )                          \
                           *DESTBUFFER(xr) |= rightPel;        \
                        else                                   \
                           *DESTBUFFER(xr) &= ~rightPel;

#define LOOP( inc )  halfLine = ((pbmi->cx-1)*inc) >> 1;                      \
                     for (y = pchBitBuffer+(pbmi->cy - 1)*cBytesPerScanLineIN;\
                          y >= pchBitBuffer;                                  \
                          y -= cBytesPerScanLineIN)                           \
                     {                                                        \
                        for (xright = (pbmi->cx-1) * inc, xleft = 0;          \
                             xright >= halfLine;                              \
                             xright -= inc, xleft+=inc)                       \
                        {                                                     \

#define ENDLOOP         }                                                     \
                     }

   LONG  xleft, xright, xl, xr, halfLine;
   char  rightPel, leftPel, savePel;
   PBYTE y;

   switch( (LONG)pbmi->cBitCount )
   {
      case 1:
         LOOP( 1 )
            xl = xleft >> 3;
            xr = xright >> 3 ;
            rightPel = (CHAR)(0x80 >> (xright & 7));
            leftPel = (CHAR)(0x80 >> (xleft & 7));
            SWAPPARTIALBYTE
         ENDLOOP
         break;
      case 2:
         LOOP( 1 )
            xl = xleft >> 2;
            xr = xright >> 2;
            rightPel = (CHAR)(0xC0 >> (xright & 3));
            leftPel = (CHAR)(0xC0 >> (xleft & 3));
            SWAPPARTIALBYTE
         ENDLOOP
         break;
      case 4:
         LOOP( 1 )
            xl = xleft >> 1;
            xr = xright >> 1;
            rightPel = (xright & 1) ? 0x0f : 0xf0;
            leftPel =  (xleft & 1) ? 0x0f : 0xf0 ;
            SWAPPARTIALBYTE
         ENDLOOP
         break;
      case 8:
         LOOP( 1 )
            rightPel = *SRCBUFFER(xright);
            *DESTBUFFER(xright) = *SRCBUFFER(xleft);
            *DESTBUFFER(xleft) = rightPel;
         ENDLOOP
         break;
      case 16:
         LOOP( 2 )
            rightPel = *SRCBUFFER(xright);
            *DESTBUFFER(xright) = *SRCBUFFER(xleft);
            *DESTBUFFER(xleft) = rightPel;

            rightPel = *SRCBUFFER(xright+1);
            *DESTBUFFER(xright+1) = *SRCBUFFER(xleft+1);
            *DESTBUFFER(xleft+1) = rightPel;
         ENDLOOP
         break;
      case 24:
         LOOP( 3 )
            rightPel = *SRCBUFFER(xright);
            *DESTBUFFER(xright) = *SRCBUFFER(xleft);
            *DESTBUFFER(xleft) = rightPel;

            rightPel = *SRCBUFFER(xright+1);
            *DESTBUFFER(xright+1) = *SRCBUFFER(xleft+1);
            *DESTBUFFER(xleft+1) = rightPel;

            rightPel = *SRCBUFFER(xright+2);
            *DESTBUFFER(xright+2) = *SRCBUFFER(xleft+2);
            *DESTBUFFER(xleft+2) = rightPel;
         ENDLOOP
   }

#undef SRCBUFFER
#undef DESTBUFFER
#undef SWAPPARTIALBYTE
#undef LOOP
#undef ENDLOOP
}

PCHAR
ReturnPortraitBitmapBits (PDDC pddc, PBITMAPINFO2 pbmi)
{
   register USHORT      fBitsOn               = FALSE;
   LONG                 cColors;
   LONG                 cLinesPerBufferIN;
   LONG                 cBytesPerScanLineIN;
   LONG                 cLinesPerBufferOUT;
   LONG                 cBytesPerScanLineOUT;
   LONG                 cLines;
   LONG                 cLinesScanned;
   PCHAR                pchBitBuffer          = NULL;
   PCHAR                pchTmpBuffer          = NULL;
   PCHAR                pchRet                = NULL;
   register PCHAR       pch;
   LONG                 i;
#ifdef DEBUG
   PDEBUGINFO           pDbg                  = &globals.DebugInfo;
#endif

   DBPRINTIF ((pDbg->bDEVESC_NEWFRAME, ">>>> Entry: ReturnPortraitBitmapBits() <<<<\n"));

   // compute the number of bytes per line; must be the next greater or equal multiple of four
   cBytesPerScanLineIN = (((pbmi->cBitCount * pbmi->cx) + 31) >> 5) << 2;
   // compute the number of scan lines that can fit into one bitbuffer
   cLinesPerBufferIN   = pbmi->cy;

   if (pddc->pdb->bRasterPortrait)
   {
      cBytesPerScanLineOUT = cBytesPerScanLineIN;
      cLinesPerBufferOUT   = cLinesPerBufferIN;
   }
   else
   {
      // The following is used for rotate of the bitmap for printers that
      // do not print in graphics when in landscape mode.
      cBytesPerScanLineOUT = (((pbmi->cBitCount * pbmi->cy) + 31) >> 5) << 2;
      // compute the number of scan lines that can fit into one bitbuffer
      cLinesPerBufferOUT   = pbmi->cx;
   }

   DBPRINTIF ((pDbg->bDEVESC_NEWFRAME, "cBytesPerScanLineIN = %d\n", cBytesPerScanLineIN));
   DBPRINTIF ((pDbg->bDEVESC_NEWFRAME, "cLinesPerBufferIN = %d\n", cLinesPerBufferIN));
   DBPRINTIF ((pDbg->bDEVESC_NEWFRAME, "cBytesPerScanLineOUT = %d\n", cBytesPerScanLineOUT));
   DBPRINTIF ((pDbg->bDEVESC_NEWFRAME, "cLinesPerBufferOUT = %d\n", cLinesPerBufferOUT));

   if (GRE_22 > globals.ulGreVersion)   // Not 2.2 Engine
   {
      // Don't give a heap handle and you will get process memory (DosAlloc)
      // for large allocations such as this...

      pchBitBuffer = (PCHAR)GplMemoryAlloc (0, cBytesPerScanLineIN*cLinesPerBufferIN);
      assertF (pchBitBuffer);

      // this is how many scan lines to get
      cLines = cLinesPerBufferIN;

      // get the bitmap bits from the shadow DC bitmap
      cLinesScanned = GreGetBitmapBits (pddc->hdcShadow,
                                        0,          // Use DC bitmap
                                        0,
                                        cLines,
                                        pchBitBuffer,
                                        pbmi);

      assertF (cLinesScanned == cLines);
#ifndef DEBUG
      cLinesScanned++;
#endif
   }
   else
   {
      PDEVICESURFACE  pds    = pddc->pdb->pDeviceSurface;
      PRGB2           prgb2  = (PRGB2)pds->pHWPalette;

      pchBitBuffer = pds->SurfaceBmapInfo.pBits;

      if (GRE_23 > globals.ulGreVersion)
      {
         /* This version of the engine does not support the
         ** DS_BOTTOMTOP flag.  We must flip the scan lines ourselves...
         */
         INT             iNumULs;
         INT             iMaxY;

         iNumULs = (pddc->bmp.cx * pddc->bmp.cBitCount + 31)/32;
         iMaxY = pddc->bmp.cy - 1;

         SwapScanLines ((PULONG)pchBitBuffer,
                        (PULONG)(pchBitBuffer + iMaxY * iNumULs * 4),
                        iNumULs,
                        pddc->bmp.cBitCount);
      }

      cColors = Power (2, pbmi->cBitCount);

      DBPRINTIF ((pDbg->bDEVESC_NEWFRAME, "cColors = %d\n", cColors));

      if (cColors <= 256)
      {
         memcpy ((PRGB2)pbmi->argbColor, prgb2, cColors * sizeof (RGB2));
      }

      if (2 == cColors)
      {
         pbmi->argbColor[0].bRed   = '\xFF'; pbmi->argbColor[1].bRed   = '\x00';
         pbmi->argbColor[0].bGreen = '\xFF'; pbmi->argbColor[1].bGreen = '\x00';
         pbmi->argbColor[0].bBlue  = '\xFF'; pbmi->argbColor[1].bBlue  = '\x00';
      }
   }

   DBPRINTIF ((pDbg->bDEVESC_NEWFRAME, "pchBitBuffer = %p\n", pchBitBuffer));

   /* @191062 Added the following 12 lines for handling the mirror image of media
   **         See the device.h file for explantion
   */
   if ((pddc->pdb->pJobProperties->ulImageoption & IMAGE_OPTION_MIRROR)   &&
       !(pddc->pdb->pMediaInfo->ulMediaCap & MEDIA_TYPE_REQUIRES_INVERSE) &&
       (ORIENTATION_PORTRAIT == pddc->pdb->pJobProperties->ulOrientation)  )
      MirrorBuffer (pchBitBuffer,
                    pbmi,
                    cBytesPerScanLineIN);

   if (!(pddc->pdb->pJobProperties->ulImageoption & IMAGE_OPTION_MIRROR)  &&
       (pddc->pdb->pMediaInfo->ulMediaCap & MEDIA_TYPE_REQUIRES_INVERSE)  &&
       (ORIENTATION_PORTRAIT == pddc->pdb->pJobProperties->ulOrientation)  )
      MirrorBuffer (pchBitBuffer,
                    pbmi,
                    cBytesPerScanLineIN);

   // Portrait
   if (pddc->pdb->bRasterPortrait)
   {
      pchRet = pchBitBuffer;
   }
   else
   {
      // Landscape
      pchTmpBuffer = (PCHAR)GplMemoryAlloc (0, cBytesPerScanLineOUT*cLinesPerBufferOUT);
      assertF (pchTmpBuffer);

      DBPRINTIF ((pDbg->bDEVESC_NEWFRAME, "printmode = %d\n", pddc->pdb->pPrintMode->ulPrintModeID));

      if ((COLOR_TECH_MONO ==  pddc->pdb->pPrintMode->ulColorTech) ||
          (COLOR_TECH_K    ==  pddc->pdb->pPrintMode->ulColorTech)  )
         RotateBits (pchBitBuffer, pchTmpBuffer, pbmi);
      else if ((COLOR_TECH_COLOR ==  pddc->pdb->pPrintMode->ulColorTech) ||
               (COLOR_TECH_CMY   ==  pddc->pdb->pPrintMode->ulColorTech) ||
               (COLOR_TECH_CMYK  ==  pddc->pdb->pPrintMode->ulColorTech) ||
               (COLOR_TECH_KCMY  ==  pddc->pdb->pPrintMode->ulColorTech)  )
         RotateColorBytes (pchBitBuffer, pchTmpBuffer, pbmi);

      pchRet = pchTmpBuffer;
   }

#ifdef DEBUG
   if (globals.bShowBitmap)
      ShowBitmap (pddc, pchRet, pbmi);
#endif

   if (GRE_22 > globals.ulGreVersion &&
       1 == pbmi->cBitCount           )
   {
      // Not the 2.2 Engine
      // bits from shadow DC are inverted: bit=1 ==>white;  bit=0 ==>black
      // invert the bits here
      for (i = cLinesPerBufferOUT * cBytesPerScanLineOUT,
              pch = pchRet;
           i;
           i--, pch++)
      {
         // xor the byte of bits with FFh
         *pch ^= 0xFF;
         // determine if there are any "on" bits at all
         fBitsOn |= *pch;
      }
   }

   DBPRINTIF ((pDbg->bDEVESC_NEWFRAME, ">>>> Exit: ReturnPortraitBitmapBits() <<<<\n"));

   return pchRet;
}

// --------------------------------------------------------------------------------------------------------------------
// has the side effect of erasing the shadow DC after fetching the bits

BOOL _System
NewFrame (PDDC pddc, PRECTL prectlBandLocation)
{
   APIRET               rc;
   PBITMAPINFO2         pbmi          = NULL;
   BITMAPINFOHEADER     bmihIN;
   PBITMAPINFOHEADER    pbmihIN       = &bmihIN;
   SIZEL                sizelBuffer;
   SIZEL                sizelPage;
   RECTL                rectlBand;
   ULONG                ulFlags,
                        cColors;
   POINTL               ptlOffset;
   LONG                 lrc;
   PCHAR                pchBitBuffer  = NULL;
   REGREC               regrec;
   ULONG                ulException;
   PFNSUBCLASS          pfnSubClass;
///PJOURNAL             pJournal      = (PJOURNAL)pddc->hJournal;
#ifdef DEBUG
   PDEBUGINFO           pDbg          = &globals.DebugInfo;
#endif


   REGISTERHANDLER (regrec, globals.hModule);
   ulException = setjmp(regrec.jmp);
   if (ulException)
   {
      assertstring ("Exception occured!\n");
      CheckForTermination (&regrec, ulException, pddc);
      // error result
      lrc = FALSE;
      goto depart;
   }

   DBPRINTIF ((pDbg->bDEVESC_NEWFRAME, ">>>> Entry: NewFrame() <<<<\n"));

   DBPRINTIF ((pDbg->bDEVESC_NEWFRAME, "NewFrame called with rectangle:\n"));
   DBPRINTIF ((pDbg->bDEVESC_NEWFRAME, "           +---------+(%4d,%4d)\n",
               prectlBandLocation->xRight, prectlBandLocation->yTop));
   DBPRINTIF ((pDbg->bDEVESC_NEWFRAME, "           |         |\n"));
   DBPRINTIF ((pDbg->bDEVESC_NEWFRAME, "(%4d,%4d)+---------+\n",
               prectlBandLocation->xLeft, prectlBandLocation->yBottom));

   // @SAP - begin
   if (pddc->pdb->SetAbortProc.pAbortProc != NULL)
   {
      pddc->pdb->SetAbortProc.pAbortProc (pddc->pdb->SetAbortProc.hdc, 0);
   }
   // @SAP - end

   if (GRE_22 > globals.ulGreVersion)   // Not 2.2 Engine
   {
      lrc = GreGetBitmapParameters (pddc->hbmShadow, pbmihIN);
      assertF (lrc);
   }
   else
      *pbmihIN = pddc->bmp;

   cColors = Power (2, pbmihIN->cBitCount);

   // use regular heap alloc for bitmapinfo2 struct

   if (cColors <= 256)
      pbmi = (PBITMAPINFO2)GplMemoryAlloc (pddc->pdb->hmcbHeap,
                                           sizeof (BITMAPINFO2)
                                           + cColors
                                             * sizeof(RGB2));
   else
      pbmi = (PBITMAPINFO2)GplMemoryAlloc (pddc->pdb->hmcbHeap,
                                           sizeof (BITMAPINFO2));
   assertF (pbmi);

   memset (pbmi, 0, sizeof (BITMAPINFOHEADER2));

   pbmi->cbFix = sizeof (BITMAPINFOHEADER2);
   pbmi->cx = pbmihIN->cx;
   pbmi->cy = pbmihIN->cy;
   pbmi->cPlanes = pbmihIN->cPlanes;
   pbmi->cBitCount = pbmihIN->cBitCount;

///pbmi->ulCompression = BCA_UNCOMP;
///pbmi->cbImage       = 0;
///pbmi->cxResolution  = 0;
///pbmi->cyResolution  = 0;
///pbmi->clrUsed       = 0;
///pbmi->cclrImportant = 0;

   pchBitBuffer = ReturnPortraitBitmapBits (pddc, pbmi);

   if (!pddc->pdb->bRasterPortrait)
   {
      SWAP (pbmi->cx, pbmi->cy);            // landscape
   }

   if (pchBitBuffer)
   {
      /* Set up rectangles...
      */
      sizelBuffer.cx = pbmi->cx;
      sizelBuffer.cy = pbmi->cy;

      sizelPage.cx   = pddc->pdb->pFormInfo->hcInfo.xPels;
      sizelPage.cy   = pddc->pdb->pFormInfo->hcInfo.yPels;

      rectlBand = *prectlBandLocation;

      /* Set up subclassed function pointer...
      */
      pfnSubClass = pddc->pdb->pDevice->pSubclassedFunctions;

      if (pfnSubClass->pfnDeviceQuery)
      {
         ptlOffset.x = 0;
         ptlOffset.y = 0;
         ulFlags = DEVICE_BOTTOM_ORIGIN;

         rc = pfnSubClass->pfnDeviceQuery ((PVOID)pddc,
                                           DEVICE_QUERY_ORIGIN,
                                           (PVOID)&ulFlags,
                                           (PVOID)&ptlOffset,
                                           pddc->pdb->pvDeviceCookie);

         if (rc)
         {
            // Account for the page offset
            if (ulFlags & DEVICE_TOP_ORIGIN)
            {
               rectlBand.yBottom = sizelPage.cy - 1 - rectlBand.yBottom;
               rectlBand.yTop    = sizelPage.cy - 1 - rectlBand.yTop;
            }

            // Account for the offset
            rectlBand.xLeft   = rectlBand.xLeft   + ptlOffset.x;
            rectlBand.yBottom = rectlBand.yBottom + ptlOffset.y;
            rectlBand.xRight  = rectlBand.xRight  + ptlOffset.x;
            rectlBand.yTop    = rectlBand.yTop    + ptlOffset.y;
         }
      }

      if (pddc->pdb->pfnBandPlugInSendBand)
      {
         pddc->pdb->pfnBandPlugInSendBand (pddc->pdb->ulBandHandle,
                                           pchBitBuffer,
                                           pbmi,
                                           &sizelBuffer,
                                           &sizelPage,
                                           &rectlBand);
      }

      if (pfnSubClass->pfnRasterizeBand)
      {
         
         ULONG        ulOrientation   = pddc->pdb->pJobProperties->ulOrientation;
         SIZEL        sizelBufferBlank;
         SIZEL        sizelPageBlank;
         RECTL        rectlBandBlank;
         LONG         lBytes          = (((pbmi->cBitCount * pbmi->cx) + 31) >> 5) << 2;
         BYTE         bWhiteColor;
         PBITMAPINFO2 pbmi1           = NULL;
         ULONG        ulSize;

         if (OmniBookletEnabled (pddc))    
         {
            if (!pddc->bBlankPageRasterized)
            {
               if (cColors <= 256)
                  ulSize = sizeof (BITMAPINFO2) + cColors * sizeof(RGB2);
               else
                  ulSize = sizeof (BITMAPINFO2);

               pbmi1 = (PBITMAPINFO2)GplMemoryAlloc (NULL, ulSize);

               memcpy (pbmi1, pbmi, ulSize);

               if (pbmi->cBitCount == 1)
                  bWhiteColor = 0x00;
               else
                  bWhiteColor = 0xFF;
            }

            SWAPP (pddc->pdb->pLargeFormInfo, pddc->pdb->pFormInfo);

            if (pddc->pdb->pJobProperties->ulOrientation == ORIENTATION_PORTRAIT)
            {
               SWAP (sizelPage.cx,      sizelPage.cy);
               SWAP (rectlBand.yTop,    rectlBand.xRight);
               SWAP (rectlBand.yBottom, rectlBand.xLeft);
            }

            if (!pddc->bBlankPageRasterized)
            {
               sizelBufferBlank = sizelBuffer;
               sizelPageBlank   = sizelPage;
               rectlBandBlank   = rectlBand;
            }

            //
            // Left or Bottom (if landscape) logical page, need to move
            //
            if (!(  (  (pddc->pdb->bFlags & OMNI_BOOKLET_ENABLED)
                    && (pddc->pdb->pJobProperties->ulOrientation == ORIENTATION_PORTRAIT)
                    && !(pddc->ulBookletPage % 2)
                    )
                 || (  (pddc->pdb->bFlags & OMNI_BOOKLET_ENABLED)
                    && (pddc->pdb->pJobProperties->ulOrientation == ORIENTATION_LANDSCAPE)
                    && (pddc->ulBookletPage % 2)
                    )
                 || (  !(pddc->pdb->bFlags & OMNI_BOOKLET_ENABLED)
                    && (pddc->pdb->pJobProperties->ulOrientation == ORIENTATION_LANDSCAPE)
                    && !(pddc->ulBookletPage % 2)
                    )
                 || (  !(pddc->pdb->bFlags & OMNI_BOOKLET_ENABLED)
                    && (pddc->pdb->pJobProperties->ulOrientation == ORIENTATION_PORTRAIT)
                    && (pddc->ulBookletPage % 2)
                    )
                 )
               )
            {
               sizelPage.cx       = pddc->pdb->pFormInfo->hcInfo.xPels;
               sizelPage.cy       = pddc->pdb->pFormInfo->hcInfo.yPels;
               rectlBand.yTop    += pddc->pdb->pFormInfo->hcInfo.yPels / 2;
               rectlBand.yBottom += pddc->pdb->pFormInfo->hcInfo.yPels / 2;
               pddc->iShift       = pddc->pdb->pFormInfo->hcInfo.yPels / 2;
            }
            else
            {
               rectlBand.yTop    -= pddc->pdb->ulTopMove;
               rectlBand.yBottom -= pddc->pdb->ulTopMove;
               pddc->iShift       = 0;
            }

            pddc->pdb->pJobProperties->ulOrientation = ORIENTATION_PORTRAIT;
         }
         

         rc = pfnSubClass->pfnRasterizeBand (pchBitBuffer,
                                             pbmi,
                                             &sizelBuffer,
                                             &sizelPage,
                                             &rectlBand,
                                             pddc->pdb->pvDeviceCookie,
                                             pddc);

         
         if (OmniBookletEnabled (pddc))   
         {
            if (!pddc->bBlankPageRasterized)
            {
               LONG lY = pddc->ptlPrintHead.y;

               memcpy (pbmi, pbmi1, ulSize);

               // @TBD - should be GreErasePS ();
               memset (pchBitBuffer, bWhiteColor, lBytes * pbmi->cy);

               GplBookletSetOutput (pddc->pdb->hThread, BOOKLET_OUTPUT_BLANKPAGE);

               pddc->ptlPrintHead.y    = pddc->lHeaderY;
               rectlBandBlank.yTop    -= pddc->pdb->ulTopMove;
               rectlBandBlank.yBottom -= pddc->pdb->ulTopMove;
               pddc->iShift            = 0;

               pfnSubClass->pfnRasterizeBand (pchBitBuffer,
                                              pbmi,
                                              &sizelBufferBlank,
                                              &sizelPageBlank,
                                              &rectlBandBlank,
                                              pddc->pdb->pvDeviceCookie,
                                              pddc);

               GplBookletResetOutput (pddc->pdb->hThread);

               GplMemoryFree (pbmi1);

               pddc->lHeaderY       = pddc->ptlPrintHead.y;
               pddc->ptlPrintHead.y = lY;
            }

            SWAPP (pddc->pdb->pLargeFormInfo, pddc->pdb->pFormInfo);

            pddc->pdb->pJobProperties->ulOrientation = ulOrientation;
         }

         
      }
   }

   lrc = TRUE;

depart:

   // clean up allocations if allocated for landscape
   if (!pddc->pdb->bRasterPortrait)
      GplMemoryFree (pchBitBuffer);

   if (pbmi)
   {
      rc = GplMemoryFree (pbmi);
      assert (rc == 0);
      pbmi = NULL;
   }

   if (GRE_22 > globals.ulGreVersion)
   {
      // Not the 2.2 Engine
      if (pchBitBuffer)
      {
         rc = GplMemoryFree (pchBitBuffer);
         assert (rc == 0);
         pchBitBuffer = NULL;
      }
   }

   UNREGISTERHANDLER (regrec);

   DBPRINTIF ((pDbg->bDEVESC_NEWFRAME, ">>>> Exit: NewFrame() <<<<\n"));

   return lrc;
}
