/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
// initterm.c

// per-process DLL initialization and termination

#define INCL_DOS
#define INCL_ERRORS
#define INCL_PM
#include <os2.h>

// @DBCS
#define INCL_VMANDDI
#include <ddi.h>
#include <pmddi.h>

// c includes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>

#define INCL_GENPLIB_RUNTIME

#include "def.h"
#include "driver.h"
#include "funcs.h"

/* Function prototypes...
*/
VOID FreeGlobalMemory (VOID);
#ifdef _V3_CRT_
int  _CRT_init        (void);
void _CRT_term        (void);
#endif

// ------------------------------------------------------------------------------------------------------------------
// _DLL_InitTerm is called once at process init, and once at process terminate
// ulFlag == 0, then do DLL init per process
// ulFlag == 1, then DLL freed per process

ULONG APIENTRY
_DLL_InitTerm (ULONG hThisModule, ULONG ulFlag)
{
   int              i,
                    j;
   APIRET           rc;
   PPIB             pPib;
   PTIB             pTib;
   REGREC           regrec;
   ULONG            ulException;
   ULONG            ulrc;

   // Is the module loading?  If so, then initialize before anything else
#ifdef _V3_CRT_
   if (0 == ulFlag)
   {
      if (_CRT_init () == -1)       /* Need to initialize runtimes for V3 */
      {
         return 0UL;
      }
   }
#endif

   if (0 == ulFlag)
   {
      CHAR achBuffer[128];

      GplRuntimeInit ();

      if (PrfQueryProfileString (HINI_SYSTEMPROFILE,
                                 APPNAME_DEBUGINFO,
                                 KEYNAME_HOOKTYPE,
                                 "",
                                 achBuffer,
                                 sizeof (achBuffer)))
      {
         if (0 == strcmp (achBuffer, "HOOKTYPE_DEBUGOUT"))
         {
            GplHookAssert (HOOKTYPE_DEBUGOUT);
         }
         else if (0 == strcmp (achBuffer, "HOOKTYPE_PMPRINTF"))
         {
            GplHookAssert (HOOKTYPE_PMPRINTF);
         }
      }
   }

   REGISTERHANDLER (regrec, globals.hModule);
   ulException = setjmp (regrec.jmp);
   if (ulException)
   {
     // clean up here as required
     // check for the killed-thread case
     switch (ulException)
     {
     case XCPT_PROCESS_TERMINATE:
     case XCPT_ASYNC_PROCESS_TERMINATE:
       DosUnsetExceptionHandler ((PEXCEPTIONREGISTRATIONRECORD)&regrec);
       DosExit (EXIT_THREAD, 0);
       break;
     }
     // error result
     ulrc = 0;
     goto depart;
   }

   DBPRINTF (("%s(): Enter\n", __FUNCTION__));

   switch (ulFlag)
   {
   /*------------------------------------------------------------------------*/
   /* Load Module                                                            */
   /*------------------------------------------------------------------------*/
   case 0:
   {
      // process is instantiating the driver
      DBPRINTF (("OS/2 OMNI DRIVER: DLL_InitTerm - instantiating\n"));

      // get process id and store in process data area
      rc = DosGetInfoBlocks (&pTib, &pPib);
      assertT (rc);
      procdata.pid = pPib->pib_ulpid;

      // SYSTEM-GLOBAL MUTEX SEMAPHORE

      // two chances to open the shared mutex sem;
      // necessary due to possible race condition where two processes
      // could be loading the driver at nearly the same time
      i = 2;

      do
      {
         // open the shared mutex sem for this process
         DBPRINTF (("DLL_InitTerm - open global sem %x\n", procdata.hmtxGlobalSem));
         rc = DosOpenMutexSem (globals.pszSemName, &procdata.hmtxGlobalSem);

         switch (rc)
         {
         case 0:
            // good result; sem  opened
            break;

         case ERROR_SEM_NOT_FOUND:
            // perhaps never been created? quite possible.
            // create a named (therefore shared) system, mutex sem in the unowned state;
            // in a race condition, this could fail, too, because other process could
            // have just created it. In this case, loop and try to open again
            DBPRINTF (("DLL_InitTerm - create global sem (sem not found)\n"));
            rc = DosCreateMutexSem (globals.pszSemName, &procdata.hmtxGlobalSem, 0, 0);
            break;

         default:
            // blow up the debug version
            assertstring ("unknown case!\n");
            break;
         }
      } while (rc && --i);

      assertT (rc);

      // GLOBALS INIT STUFF

      // request the global mutex sem
      DBPRINTF (("DLL_InitTerm - requesting global sem %x\n", procdata.hmtxGlobalSem));
      rc = DosRequestMutexSem (procdata.hmtxGlobalSem, SEM_INDEFINITE_WAIT);
      assertT (rc);

      if (globals.cInstances == 0)
      {
         /* This is the first time that this module is being called!
         ** Call SetNumberOfPrinters to set the number of printers.
         ** Unfortunatly, the number of printers is a macro that is dynamically
         ** calculated at compile time and it is only known in the file
         ** driver.c.  Therefore, a function was created to set a global
         ** variable with this information.
         */
         SetNumberOfPrinters ();

         /* Turn off DBPRINTFs if there is a sysini file entry
         ** OmniDriver / Assert whose value is 0 (FALSE).  A nonzero
         ** value (TRUE) will route DBPRINTFs to the debugger screen.
         */
         Assert = PrfQueryProfileInt (HINI_SYSTEMPROFILE,
                                      APPNAME_DEBUGINFO,
                                      KEYNAME_ASSERTINFO,
                                      0);

#ifdef DEBUG
         /* Show band bitmaps.
         */
         globals.bShowBitmap = PrfQueryProfileInt (HINI_SYSTEMPROFILE,
                                                   APPNAME_DEBUGINFO,
                                                   KEYNAME_SHOWBITMAP,
                                                   0);
#endif
      }

      globals.cInstances++;
      DBPRINTF (("cInstances++ = %d\n", globals.cInstances));

      // if this is the first time, then do globals initialization
      if (!globals.hModule)
      {
         // Set a Trailer Signature to validate we don't accidentally overrite
         // global data
         globals.ulSig    = BEGIN_GLOBAL; // "GLOB"
         globals.ulEndSig = END_GLOBAL;   // "GLOE"

         // record module handle
         globals.hModule = hThisModule;
         assert (globals.hModule);

         // get module name
         rc = DosQueryModuleName (globals.hModule, sizeof(globals.szModule), globals.szModule);
         assertT (rc);

         globals.pvSharedHeap = GplMemoryCreateInstance (LEN_SHAREDHEAP,  // Size
                                                         0,               // Extent
                                                         0,               // Threshold
                                                         SHARED_MEMORY);  // Type
         assertF (globals.pvSharedHeap);

         // get path to module name and store - find right most
         for (i = strlen(globals.szModule); i != 0; i--)
            if (*(globals.szModule + i) == '\\')
               break;

         // copy to globals.szDLLPathName
         for (j = 0; j <= i; j++)
            *(globals.szDLLPathName + j) = *(globals.szModule + j);

         // @TTY
         globals.bBaseStringTableInitialized = FALSE;
         globals.bDlgStringTableInitialized = FALSE;
#ifdef DEBUG
         globals.bDebugInfoInitialized = FALSE;
#endif
      }

      // module handles are the same across all processes in the system
      assert (globals.hModule == hThisModule);

      // create a private process-wide sem for this process in the unowned state

      DBPRINTF (("DLL_InitTerm - create process sem\n"));
      assert ((HMTX)0 == procdata.hmtxProcessSem);
      rc = DosCreateMutexSem (NULL, &procdata.hmtxProcessSem, 0, 0);
      assertT (rc);

      DBPRINTF (("DLL_InitTerm - releasing global sem %x\n", procdata.hmtxGlobalSem));
      rc = DosReleaseMutexSem (procdata.hmtxGlobalSem);
      assertT (rc);
      break;
   }

   /*------------------------------------------------------------------------*/
   /* Free Module                                                            */
   /*------------------------------------------------------------------------*/
   case 1:
   {
      // process is unlinking the driver; do cleanup
      rc = DosRequestMutexSem (procdata.hmtxGlobalSem, SEM_INDEFINITE_WAIT);
      assertT (rc);

      // decrement the driver instance count
      globals.cInstances--;
      DBPRINTF (("cInstances-- = %d\n", globals.cInstances));

      rc = DosReleaseMutexSem (procdata.hmtxGlobalSem);
      assertT (rc);

      if (globals.cInstances == 0)
      {
         // last process is unlinking the driver
         // this never happens on 2.0SP or 2.1 once a dc is created
         // it can happen at install time

         rc = DosRequestMutexSem (procdata.hmtxGlobalSem, SEM_INDEFINITE_WAIT);
         assertT (rc);

         FreeGlobalMemory ();

         assertF (globals.pvSharedHeap);
         GplMemoryDeleteInstance (globals.pvSharedHeap);

         globals.pvSharedHeap = (PVOID)NULL;
         globals.hModule = (HMODULE)0;

         rc = DosReleaseMutexSem (procdata.hmtxGlobalSem);
         assertT (rc);

         rc = DosCloseMutexSem (procdata.hmtxProcessSem);
         assertT (rc);
         procdata.hmtxProcessSem = HMTX_CLOSED;

         rc = DosCloseMutexSem (procdata.hmtxGlobalSem);
         assertT (rc);
         procdata.hmtxGlobalSem = HMTX_CLOSED;
      }
      break;
   }

   default:
   {
      // blow up the debug version
      assertstring ("unknown case!\n");
   }
   }

   // success
   ulrc = 1;

depart:
   UNREGISTERHANDLER (regrec);

   DBPRINTF (("%s(): Exit; ulrc=%d\n", __FUNCTION__, ulrc));

   // Is the module unloading?  If so, then terminate as the last thing that we do
   if (1 == ulFlag)
   {
      GplRuntimeTerm ();
   }

#ifdef _V3_CRT_
   if (1 == ulFlag)
   {
      _CRT_term();   /* Clean up runtime environment */
   }
#endif

   return ulrc;

} /* end _DLL_InitTerm */

/****************************************************************************/
/* PROCEDURE NAME : FreeGlobalMemory                                        */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
VOID
FreeGlobalMemory (VOID)
{
   PFONTINFO2   pFonts;
   INT          cFonts;
   INT          iDriver;
   APIRET       rc;
   register INT i;

   // Clean up the string table
   for (i = 0; i < dimof (globals.pbStringTable); i++)
   {
      if (globals.pbStringTable[i])
      {
         rc = GplMemoryFree (globals.pbStringTable[i]);
         assertT (rc);

         globals.pbStringTable[i] = NULL;
      }
   }

   // Clean up device fonts
   // search through all driver structs we know about
   for (iDriver = 0; iDriver < globals.ulTotalDrivers; iDriver++)
   {
      cFonts = globals.ppDrivers[iDriver]->ulNumFonts;
      pFonts = globals.ppDrivers[iDriver]->pFONTS;

      for (i = 0; i < cFonts; i++)
      {
         if (pFonts[i].vpGlobalFocaFont)
         {
            rc = GplMemoryFree (pFonts[i].vpGlobalFocaFont);
            assertT (rc);

            pFonts[i].vpGlobalFocaFont = NULL;
         }
      }
   }

#ifndef DEBUG
   rc++;          // Avoid compiler warnings
#endif
}
