/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/****************************************************************************/
/*                                                                          */
/*      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is         */
/*      sample code created by IBM Corporation. This sample code is not     */
/*      part of any standard or IBM product and is provided to you solely   */
/*      for  the purpose of assisting you in the development of your        */
/*      presentation drivers.  The code is provided "AS IS", without        */
/*      warranty of any kind.  IBM shall not be liable for any damages      */
/*      arising out of your use of the sample code, even if they have been  */
/*      advised of the possibility of such damages.                         */
/*                                                                          */
/****************************************************************************/
/****************************************************************************/
/*                                                                          */
/* FILENAME       : HELP.H                                                  */
/* AUTHOR         : Matthew F. Rutkowski                                    */
/* DATE WRITTEN   : 05-28-95                                                */
/* DESCRIPTION    : This module contains all MACROS, IDs, constants and     */
/*                  data type definitions used by                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* Modification/Change log                                                  */
/*--------------------------------------------------------------------------*/
/* TAG - DATE - [COMPANY] - AUTHOR - DESCRIPTION                            */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/****************************************************************************/
#ifndef _HELP_H
#define _HELP_H

#define INCL_GENPLIB_MEMORY
#include <genplib.h>

#define HEAP_LEN      32000

typedef struct _CTXENTRY{
  struct _CTXENTRY *pNext;
  ULONG             ulCtlID;
  PSZ               pszCtxHelp;
} CTXENTRY;

typedef CTXENTRY *PCTXENTRY, **PPCTXENTRY;

typedef struct _HELPCTX{
  HMCB       hmcb;
  ULONG      ulCurrent;
  ULONG      ulNumEntries;
  PCTXENTRY  pFirstEntry;
  PCTXENTRY  pLastEntry;
  PCTXENTRY  pNextEntry;
} HELPCTX;

typedef HELPCTX *PHELPCTX, **PPHELPCTX;

BOOL   CreateContextHelp( PPHELPCTX );
VOID   DestroyContextHelp( PHELPCTX );

BOOL   AddContextHelp( PHELPCTX, ULONG, PSZ );
BOOL   QueryContextHelp( PHELPCTX, HWND, ULONG );
VOID   DisplayContextHelp( PHELPCTX, HWND, ULONG );

#endif
