/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/****************************************************************************/
/*                                                                          */
/*      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is         */
/*      sample code created by IBM Corporation. This sample code is not     */
/*      part of any standard or IBM product and is provided to you solely   */
/*      for  the purpose of assisting you in the development of your        */
/*      presentation drivers.  The code is provided "AS IS", without        */
/*      warranty of any kind.  IBM shall not be liable for any damages      */
/*      arising out of your use of the sample code, even if they have been  */
/*      advised of the possibility of such damages.                         */
/*                                                                          */
/****************************************************************************/
/****************************************************************************/
/* AUTHOR         : Matthew F. Rutkowski                                    */
/* FILENAME       : HELP.C                                                  */
/* DATE WRITTEN   : 05-28-95                                                */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/* TAG - DATE - [COMPANY] - AUTHOR - DESCRIPTION                            */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/

#define INCL_DOS
#define INCL_SPL
#define INCL_GPI
#define INCL_GPIERRORS
#define INCL_DEV
#define INCL_WIN

// DBCS enable
#define INCL_DOSNLS
// DBCS enable

#include <os2.h>

#define INCL_DDIDEFS
#define INCL_GRE_DEVICE
#define INCL_GRE_DEVMISC2
#define INCL_DDIMISC
#define INCL_VMANDDI            // 2.2 Engine stuff
#define INCL_GRE_DCS
#define INCL_GRE_CLIP
#include <ddi.h>                // 2.2 Engine stuff
#include <pmddi.h>

// c includes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>

#define INCL_GENPLIB_ASSERT
#define INCL_GENPLIB_MEMORY
#include <genplib.h>

#include "driver.h"
#include "funcs.h"
#include "def.h"
#include "help.h"

#define LEN_STRING 256

/****************************************************************************/
/* PROCEDURE NAME : CreateContextHelp                                       */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 5/28/95                                                 */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
BOOL
CreateContextHelp (PPHELPCTX pCtxHelp)
{
   HMCB          hmcb = NULL;     // heap handle
   PHELPCTX      pHlp;

   // Initialize handle in case of error
   *pCtxHelp = NULL;

   // Create a heap to use for allocations
   hmcb = GplMemoryCreateInstance (HEAP_LEN,  // Size
                                   0,                 // Extent
                                   0,                 // Threshold
                                   PROCESS_MEMORY);   // Type

   // Able to create a heap for menu usage
   if (hmcb != NULL)
   {
      pHlp = (PHELPCTX)GplMemoryAlloc (hmcb, sizeof (HELPCTX));

      // Initialize Values in Menu structure
      pHlp->hmcb         = hmcb;
      pHlp->ulNumEntries = 0;
      pHlp->pFirstEntry  = NULL;
      pHlp->pLastEntry   = NULL;
      pHlp->pNextEntry   = NULL;

      // return handle to menu to caller SUCCESS!!!!
      *pCtxHelp = pHlp;

      return TRUE;
   }

   return FALSE;

} /* end CreateContextHelp */

/****************************************************************************/
/* PROCEDURE NAME : DestroyContextHelp                                      */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 5/28/95                                                 */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
VOID
DestroyContextHelp (PHELPCTX pCtxHelp)
{
   HMCB          hmcb = NULL;     // heap handle

   // If we really have a menu to free up
   if (pCtxHelp)
   {
      PCTXENTRY pCurrent, pNext;

      // remember heap handle (memory instance handle)
      hmcb = pCtxHelp->hmcb;

      // Initialize pointer to first node in linked list
      pCurrent = pCtxHelp->pFirstEntry;

      while (  (pCtxHelp->ulNumEntries > 0)
            && (pCurrent != NULL)
            )
      {
         // Remember next node in linked list
         pNext = pCurrent->pNext;

         // Free any strings allocated in context help entry structure
         if (pCurrent->pszCtxHelp)
            GplMemoryFree (pCurrent->pszCtxHelp);

         // Free current context help entry in linked list
         GplMemoryFree (pCurrent);

         // Decrement # buttons in Menu linked list
         pCtxHelp->ulNumEntries--;

         // next node now becomes current node to process
         pCurrent = pNext;
      }

      GplMemoryFree (pCtxHelp);

      // If Heap exists free it up
      if (hmcb)
         GplMemoryDeleteInstance (hmcb);
   }

} /* end DestroyContextHelp */

/****************************************************************************/
/* PROCEDURE NAME : AddContextHelp                                          */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 5/28/95                                                 */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
BOOL
AddContextHelp (PHELPCTX pHelpCtx, ULONG ulCtlID, PSZ pszCtxHelp)
{
   BOOL   rc;

   rc = ValidatePointer (pszCtxHelp, VALIDATE_TYPE_STRING, 64);
   assertF (rc);
   if (!rc)
      return FALSE;

   // If we have a valid help context to dereference
   if (pHelpCtx)
   {
      PCTXENTRY pHlpEntry = NULL;

      // Create Help entry and copy info into it
      pHlpEntry = (PCTXENTRY)GplMemoryAlloc (pHelpCtx->hmcb, sizeof (CTXENTRY));

      pHlpEntry->ulCtlID = ulCtlID;
      pHlpEntry->pszCtxHelp = (PSZ)GplMemoryAlloc (pHelpCtx->hmcb,
                                                   strlen (pszCtxHelp) + 1);

      strcpy (pHlpEntry->pszCtxHelp, pszCtxHelp);

      pHlpEntry->pNext = NULL;

      // If first entry to be inserted
      if (pHelpCtx->ulNumEntries == 0)
      {
         // Set up list head pointer
         pHelpCtx->pFirstEntry = pHlpEntry;

         // Insert button at end of list
         pHelpCtx->pLastEntry = pHlpEntry;
      }
      else
      {
         // Insert entry at end of list
         pHelpCtx->pLastEntry->pNext = pHlpEntry;
         pHelpCtx->pLastEntry        = pHlpEntry;
      }

      // Bump # entries in linked list
      pHelpCtx->ulNumEntries++;

      return TRUE;
   }

   return FALSE;

} /* end AddContextHelp */

/****************************************************************************/
/* PROCEDURE NAME : QueryContextHelp                                        */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 5/28/95                                                 */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
BOOL
QueryContextHelp (PHELPCTX pHelpCtx, HWND hwnd, ULONG ulCtlID)
{
   // If we have a valid help context to dereference
   if (pHelpCtx)
   {
      PCTXENTRY pCurrent, pNext;

      // Initialize pointer to first node in linked list
      pCurrent = pHelpCtx->pFirstEntry;

      while (pCurrent != NULL)
      {
         // Remember next node in linked list
         pNext = pCurrent->pNext;

         if (pCurrent->ulCtlID == ulCtlID)
         {
            WinSetWindowText (hwnd, pCurrent->pszCtxHelp);

            return TRUE;
         }

         // next node now becomes current node to process
         pCurrent = pNext;
      }
   }

   return FALSE;

} /* end QueryContextHelp */

/****************************************************************************/
/* PROCEDURE NAME : DisplayContextHelp                                      */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 5/28/95                                                 */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
VOID
DisplayContextHelp (PHELPCTX pHelp, HWND hwndHelp, ULONG ulCtlID)
{
   BOOL  bRC;

   if (ulCtlID != (ULONG)DID_STATIC)
   {
      bRC = QueryContextHelp (pHelp, hwndHelp, ulCtlID);

#if DEBUG
      // If no context help found show control ID in entryfield
      if (!bRC)
      {
         CHAR  szTemp[LEN_STRING];

         sprintf (szTemp, "Unknown Control ID = %d\0", ulCtlID);

         WinSetWindowText (hwndHelp, szTemp);
      }
#endif
   }

#ifndef DEBUG
   bRC++;           // Avoid compiler warnings
#endif

} /* end DisplayContextHelp */
